/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.refiner;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPathBuilder;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGInterpolant;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGInterpolantManager;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class SMGInterpolationTree {
    private final LogManager logger;
    private int interpolationCounter = 0;
    private final SMGInterpolationStrategy strategy;
    private final ARGState root;
    private final Map<ARGState, ARGState> predecessorRelation = new LinkedHashMap<ARGState, ARGState>();
    private final ListMultimap<ARGState, ARGState> successorRelation = ArrayListMultimap.create();
    private final Map<ARGState, SMGInterpolant> interpolants = new HashMap<ARGState, SMGInterpolant>();
    private final SMGInterpolantManager interpolantManager;
    public static final ARGPath EMPTY_PATH = null;

    public SMGInterpolationTree(SMGInterpolantManager pInterpolantManager, LogManager pLogger, List<ARGPath> pTargetPaths, boolean useTopDownInterpolationStrategy) {
        this.logger = pLogger;
        this.interpolantManager = pInterpolantManager;
        this.root = this.build(pTargetPaths);
        this.strategy = useTopDownInterpolationStrategy ? new TopDownInterpolationStrategy() : new BottomUpInterpolationStrategy(this.extractTargets(pTargetPaths));
    }

    private ARGState build(Collection<ARGPath> targetPaths) {
        return targetPaths.size() == 1 ? this.buildTreeFromSinglePath((ARGPath)((Object)Iterables.getOnlyElement(targetPaths))) : this.buildTreeFromMultiplePaths(targetPaths);
    }

    private ARGState buildTreeFromSinglePath(ARGPath targetPath) {
        ImmutableList<ARGState> states = targetPath.asStatesList();
        for (int i = 0; i < states.size() - 1; ++i) {
            ARGState predecessorState = (ARGState)states.get(i);
            ARGState successorState = (ARGState)states.get(i + 1);
            this.predecessorRelation.put(successorState, predecessorState);
            this.successorRelation.put((Object)predecessorState, (Object)successorState);
        }
        return (ARGState)states.get(0);
    }

    private ARGState buildTreeFromMultiplePaths(Collection<ARGPath> targetPaths) {
        ARGState itpTreeRoot = null;
        ArrayDeque<ARGState> todo = new ArrayDeque<ARGState>(this.extractTargets(targetPaths));
        while (!todo.isEmpty()) {
            ARGState currentState = (ARGState)todo.removeFirst();
            if (currentState.getParents().iterator().hasNext()) {
                if (this.predecessorRelation.containsKey(currentState)) continue;
                ARGState parentState = currentState.getParents().iterator().next();
                this.predecessorRelation.put(currentState, parentState);
                this.successorRelation.put((Object)parentState, (Object)currentState);
                todo.addFirst(parentState);
                continue;
            }
            if (itpTreeRoot != null) continue;
            itpTreeRoot = currentState;
        }
        return itpTreeRoot;
    }

    private Set<ARGState> extractTargets(Collection<ARGPath> targetsPaths) {
        return Collections3.transformedImmutableSetCopy(targetsPaths, ARGPath::getLastState);
    }

    public ARGState getRoot() {
        return this.root;
    }

    public Collection<ARGState> obtainRefinementRoots() {
        HashSet<ARGState> refinementRoots = new HashSet<ARGState>();
        ArrayDeque<ARGState> todo = new ArrayDeque<ARGState>(Collections.singleton(this.root));
        while (!todo.isEmpty()) {
            ARGState currentState = (ARGState)todo.removeFirst();
            if (this.stateHasNonTrivialInterpolant(currentState)) {
                refinementRoots.add(currentState);
                continue;
            }
            List successors = this.successorRelation.get((Object)currentState);
            todo.addAll(successors);
        }
        return refinementRoots;
    }

    private boolean stateHasNonTrivialInterpolant(ARGState currentState) {
        return this.interpolants.containsKey(currentState) && !this.interpolants.get(currentState).isTrivial();
    }

    public void addInterpolants(Map<ARGState, SMGInterpolant> interpolantsToAdd) {
        for (Map.Entry<ARGState, SMGInterpolant> entry : interpolantsToAdd.entrySet()) {
            ARGState state = entry.getKey();
            SMGInterpolant itp = entry.getValue();
            if (this.interpolants.containsKey(state)) {
                this.interpolants.put(state, this.interpolants.get(state).join(itp));
                continue;
            }
            this.interpolants.put(state, itp);
        }
    }

    private boolean stateHasFalseInterpolant(ARGState currentState) {
        return this.interpolants.containsKey(currentState) && this.interpolants.get(currentState).isFalse();
    }

    public boolean hasNextPathForInterpolation() {
        return this.strategy.hasNextPathForInterpolation();
    }

    public ARGPath getNextPathForInterpolation() {
        return this.strategy.getNextPathForInterpolation();
    }

    public SMGInterpolant getInitialInterpolantForPath(ARGPath errorPath) {
        return this.strategy.getInitialInterpolantForRoot(errorPath.getFirstState());
    }

    public Map<CFANode, SMGInterpolant.SMGPrecisionIncrement> extractPrecisionIncrement(ARGState pRefinementRoot) {
        HashMap<CFANode, SMGInterpolant.SMGPrecisionIncrement> increment = new HashMap<CFANode, SMGInterpolant.SMGPrecisionIncrement>();
        ArrayDeque<ARGState> todo = new ArrayDeque<ARGState>(Collections.singleton(this.predecessorRelation.get(pRefinementRoot)));
        while (!todo.isEmpty()) {
            ARGState currentState = (ARGState)todo.removeFirst();
            if (this.stateHasNonTrivialInterpolant(currentState) && !currentState.isTarget()) {
                SMGInterpolant itp = this.interpolants.get(currentState);
                SMGInterpolant.SMGPrecisionIncrement inc = itp.getPrecisionIncrement();
                CFANode loc = AbstractStates.extractLocation(currentState);
                if (increment.containsKey(loc)) {
                    SMGInterpolant.SMGPrecisionIncrement inc2 = (SMGInterpolant.SMGPrecisionIncrement)increment.get(loc);
                    SMGInterpolant.SMGPrecisionIncrement joinInc = inc.join(inc2);
                    increment.put(loc, joinInc);
                } else {
                    increment.put(loc, inc);
                }
            }
            if (this.stateHasFalseInterpolant(currentState)) continue;
            todo.addAll(this.successorRelation.get((Object)currentState));
        }
        return increment;
    }

    public void exportToDot(PathTemplate file, long refinementCounter) {
        StringBuilder result = new StringBuilder().append("digraph tree {\n");
        for (Map.Entry current : this.successorRelation.entries()) {
            if (this.interpolants.containsKey(current.getKey())) {
                result.append(((ARGState)current.getKey()).getStateId()).append(" [label=\"").append(((ARGState)current.getKey()).getStateId()).append(" / ").append(AbstractStates.extractLocation((AbstractState)current.getKey())).append(" has itp ").append("itp is ").append(this.interpolants.get(current.getKey())).append("\"]").append("\n");
                result.append(((ARGState)current.getKey()).getStateId()).append(" -> ").append(((ARGState)current.getValue()).getStateId()).append("\n");
            } else {
                result.append(((ARGState)current.getKey()).getStateId()).append(" [label=\"").append(((ARGState)current.getKey()).getStateId()).append(" has itp NA\"]").append("\n");
                result.append(((ARGState)current.getKey()).getStateId()).append(" -> ").append(((ARGState)current.getValue()).getStateId()).append("\n");
            }
            if (((ARGState)current.getValue()).isTarget()) {
                result.append(((ARGState)current.getValue()).getStateId()).append(" [style=filled, fillcolor=\"red\"]").append("\n");
            }
            assert (!((ARGState)current.getKey()).isTarget());
        }
        result.append("}");
        try {
            IO.writeFile((Path)file.getPath(new Object[]{refinementCounter, this.interpolationCounter}), (Charset)Charset.defaultCharset(), (Object)result);
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write interpolation tree to file");
        }
    }

    private class BottomUpInterpolationStrategy
    implements SMGInterpolationStrategy {
        private List<ARGState> sources;

        public BottomUpInterpolationStrategy(Set<ARGState> pTargets) {
            this.sources = new ArrayList<ARGState>(pTargets);
        }

        @Override
        public ARGPath getNextPathForInterpolation() {
            ARGState current = this.sources.remove(0);
            assert (current.isTarget()) : "current element is not a target";
            ARGPathBuilder errorPathBuilder = ARGPath.reverseBuilder();
            errorPathBuilder.add(current, (CFAEdge)FluentIterable.from(AbstractStates.getOutgoingEdges(current)).first().orNull());
            while (SMGInterpolationTree.this.predecessorRelation.get(current) != null) {
                ARGState parent = SMGInterpolationTree.this.predecessorRelation.get(current);
                if (SMGInterpolationTree.this.stateHasFalseInterpolant(parent)) {
                    SMGInterpolationTree.this.logger.log(Level.FINEST, new Object[]{"interpolant on path, namely for state ", parent.getStateId(), " is already false, so return empty path"});
                    return EMPTY_PATH;
                }
                if (SMGInterpolationTree.this.predecessorRelation.get(parent) != null) {
                    errorPathBuilder.add(parent, parent.getEdgeToChild(current));
                }
                current = parent;
            }
            return errorPathBuilder.build(current);
        }

        @Override
        public SMGInterpolant getInitialInterpolantForRoot(ARGState pRoot) {
            return SMGInterpolationTree.this.interpolantManager.createInitialInterpolant();
        }

        @Override
        public boolean hasNextPathForInterpolation() {
            return !this.sources.isEmpty();
        }
    }

    private class TopDownInterpolationStrategy
    implements SMGInterpolationStrategy {
        private Deque<ARGState> sources;

        private TopDownInterpolationStrategy() {
            this.sources = new ArrayDeque<ARGState>(Collections.singleton(SMGInterpolationTree.this.root));
        }

        @Override
        public ARGPath getNextPathForInterpolation() {
            ARGPathBuilder errorPathBuilder = ARGPath.builder();
            ARGState current = this.sources.pop();
            if (!this.isValidInterpolationRoot(SMGInterpolationTree.this.predecessorRelation.get(current))) {
                SMGInterpolationTree.this.logger.log(Level.FINEST, new Object[]{"interpolant of predecessor of ", current.getStateId(), " is already false, so return empty path"});
                return EMPTY_PATH;
            }
            if (!Objects.equals(current, SMGInterpolationTree.this.root)) {
                errorPathBuilder.add(SMGInterpolationTree.this.predecessorRelation.get(current), SMGInterpolationTree.this.predecessorRelation.get(current).getEdgeToChild(current));
            }
            while (SMGInterpolationTree.this.successorRelation.get((Object)current).iterator().hasNext()) {
                Iterator children = SMGInterpolationTree.this.successorRelation.get((Object)current).iterator();
                ARGState child = (ARGState)children.next();
                errorPathBuilder.add(current, current.getEdgeToChild(child));
                int size = 1;
                while (children.hasNext()) {
                    ++size;
                    ARGState sibling = (ARGState)children.next();
                    SMGInterpolationTree.this.logger.log(Level.FINEST, new Object[]{"\tpush new root ", sibling.getStateId(), " onto stack for parent ", SMGInterpolationTree.this.predecessorRelation.get(sibling).getStateId()});
                    this.sources.push(sibling);
                }
                assert (size <= 2);
                current = child;
            }
            return errorPathBuilder.build(current);
        }

        private boolean isValidInterpolationRoot(ARGState pRoot) {
            return !SMGInterpolationTree.this.stateHasFalseInterpolant(pRoot);
        }

        @Override
        public SMGInterpolant getInitialInterpolantForRoot(ARGState pRoot) {
            SMGInterpolant initialInterpolant = SMGInterpolationTree.this.interpolants.get(pRoot);
            if (initialInterpolant == null) {
                initialInterpolant = SMGInterpolationTree.this.interpolantManager.createInitialInterpolant();
                assert (SMGInterpolationTree.this.interpolants.size() == 0) : "initial interpolant was null after initial interpolation!";
            }
            return initialInterpolant;
        }

        @Override
        public boolean hasNextPathForInterpolation() {
            return !this.sources.isEmpty();
        }
    }

    private static interface SMGInterpolationStrategy {
        public ARGPath getNextPathForInterpolation();

        public boolean hasNextPathForInterpolation();

        public SMGInterpolant getInitialInterpolantForRoot(ARGState var1);
    }
}

