/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.refiner;

import com.google.common.primitives.ImmutableLongArray;
import java.util.Objects;

public class SMGMemoryPath {
    private final String variableName;
    private final String functionName;
    private final Integer locationOnStack;
    private final boolean globalStart;
    private final ImmutableLongArray pathOffsets;

    private SMGMemoryPath(String pVariableName, String pFunctionName, long pPathOffset, Integer pLocationOnStack) {
        this.globalStart = false;
        this.variableName = pVariableName;
        this.functionName = pFunctionName;
        this.pathOffsets = ImmutableLongArray.of((long)pPathOffset);
        this.locationOnStack = pLocationOnStack;
    }

    private SMGMemoryPath(String pVariableName, long pPathOffset) {
        this.globalStart = true;
        this.variableName = pVariableName;
        this.functionName = null;
        this.locationOnStack = null;
        this.pathOffsets = ImmutableLongArray.of((long)pPathOffset);
    }

    public SMGMemoryPath(SMGMemoryPath pParent, long pOffset) {
        this.globalStart = pParent.globalStart;
        this.variableName = pParent.variableName;
        this.functionName = pParent.functionName;
        this.locationOnStack = pParent.locationOnStack;
        this.pathOffsets = ImmutableLongArray.builder((int)(pParent.getPathOffset().length() + 1)).addAll(pParent.getPathOffset()).add(pOffset).build();
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Integer getLocationOnStack() {
        return this.locationOnStack;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public ImmutableLongArray getPathOffset() {
        return this.pathOffsets;
    }

    public boolean startsWithGlobalVariable() {
        return this.globalStart;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (!this.globalStart) {
            result.append(this.functionName);
            result.append(":");
        }
        result.append(this.variableName);
        this.pathOffsets.forEach(offset -> {
            result.append("->");
            result.append(offset);
        });
        return result.toString();
    }

    public int hashCode() {
        return Objects.hash(this.globalStart, this.locationOnStack, this.functionName, this.pathOffsets, this.variableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SMGMemoryPath)) {
            return false;
        }
        SMGMemoryPath other = (SMGMemoryPath)obj;
        return this.globalStart == other.globalStart && Objects.equals(this.locationOnStack, other.locationOnStack) && Objects.equals(this.functionName, other.functionName) && Objects.equals(this.pathOffsets, other.pathOffsets) && Objects.equals(this.variableName, other.variableName);
    }

    public static SMGMemoryPath valueOf(String pVariableName, String pFunctionName, long pPathOffset, Integer pLocationOnStack) {
        return new SMGMemoryPath(pVariableName, pFunctionName, pPathOffset, pLocationOnStack);
    }

    public static SMGMemoryPath valueOf(String pVariableName, long pPathOffset) {
        return new SMGMemoryPath(pVariableName, pPathOffset);
    }

    public static SMGMemoryPath valueOf(SMGMemoryPath pParent, long pOffset) {
        return new SMGMemoryPath(pParent, pOffset);
    }
}

