/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.refiner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.smg.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableCLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGMemoryPath;

public class SMGMemoryPathCollector {
    private final UnmodifiableCLangSMG smg;

    public SMGMemoryPathCollector(UnmodifiableCLangSMG pSmg) {
        this.smg = pSmg;
    }

    public Set<SMGMemoryPath> getMemoryPaths() {
        LinkedHashSet<SMGMemoryPath> result = new LinkedHashSet<SMGMemoryPath>();
        LinkedHashSet<SMGObject> reached = new LinkedHashSet<SMGObject>();
        this.getMemoryPathsFromGlobalVariables(result, reached);
        this.getMemoryPathsFromStack(result, reached);
        return Collections.unmodifiableSet(result);
    }

    public Map<SMGObject, SMGMemoryPath> getHeapObjectMemoryPaths() {
        LinkedHashMap<SMGObject, SMGMemoryPath> result = new LinkedHashMap<SMGObject, SMGMemoryPath>();
        LinkedHashSet<SMGObject> reached = new LinkedHashSet<SMGObject>();
        this.getHeapObjectMemoryPathsFromGlobalVariables(result, reached);
        this.getHeapObjectMemoryPathsFromStack(result, reached);
        return Collections.unmodifiableMap(result);
    }

    private void getMemoryPathsFromGlobalVariables(Set<SMGMemoryPath> pResult, Set<SMGObject> pReached) {
        for (Map.Entry entry : this.smg.getGlobalObjects().entrySet()) {
            this.getMemoryPathsFromObject((SMGObject)entry.getValue(), pResult, pReached, SMGObjectPosition.GLOBAL, null, null, null, (String)entry.getKey());
        }
    }

    private void getMemoryPathsFromStack(Set<SMGMemoryPath> pResult, Set<SMGObject> pReached) {
        int pLocationOnStack = 0;
        for (CLangStackFrame frame : this.smg.getStackFrames()) {
            String functionName = frame.getFunctionDeclaration().getName();
            for (Map.Entry<String, SMGRegion> entry : frame.getVariables().entrySet()) {
                this.getMemoryPathsFromObject(entry.getValue(), pResult, pReached, SMGObjectPosition.STACK, null, functionName, pLocationOnStack, entry.getKey());
            }
            if (frame.getReturnObject() != null) {
                this.getMemoryPathsFromObject(frame.getReturnObject(), pResult, pReached, SMGObjectPosition.STACK, null, functionName, pLocationOnStack, frame.getReturnObject().getLabel());
            }
            ++pLocationOnStack;
        }
    }

    private void getMemoryPathsFromObject(SMGObject pSmgObject, Set<SMGMemoryPath> pResult, Set<SMGObject> pReached, SMGObjectPosition pPos, SMGMemoryPath pParent, String pFunctionName, Integer pLocationOnStack, String pVariableName) {
        ArrayList<Long> offsets = new ArrayList<Long>();
        HashMap<Long, SMGObject> offsetToRegion = new HashMap<Long, SMGObject>();
        HashMap<Long, SMGMemoryPath> offsetToParent = new HashMap<Long, SMGMemoryPath>();
        for (SMGEdgeHasValue objectHve : this.smg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pSmgObject))) {
            SMGObject rObject;
            SMGValue value = objectHve.getValue();
            long offset = objectHve.getOffset();
            SMGMemoryPath path = this.getSMGMemoryPath(pVariableName, offset, pPos, pFunctionName, pLocationOnStack, pParent);
            pResult.add(path);
            if (!this.smg.isPointer(value) || !this.smg.isHeapObject(rObject = this.smg.getObjectPointedBy(value)) || pReached.contains(rObject)) continue;
            pReached.add(rObject);
            offsets.add(offset);
            offsetToRegion.put(offset, rObject);
            offsetToParent.put(offset, path);
        }
        Collections.sort(offsets);
        Iterator<Object> iterator = offsets.iterator();
        while (iterator.hasNext()) {
            long offset = (Long)iterator.next();
            SMGObject smgObject = (SMGObject)offsetToRegion.get(offset);
            SMGMemoryPath currentPath = (SMGMemoryPath)offsetToParent.get(offset);
            this.getMemoryPathsFromObject(smgObject, pResult, pReached, SMGObjectPosition.HEAP, currentPath, null, null, null);
        }
    }

    private void getHeapObjectMemoryPathsFromGlobalVariables(Map<SMGObject, SMGMemoryPath> pResult, Set<SMGObject> pReached) {
        for (Map.Entry entry : this.smg.getGlobalObjects().entrySet()) {
            this.getHeapObjectMemoryPathsFromObject((SMGObject)entry.getValue(), pResult, pReached, SMGObjectPosition.GLOBAL, null, null, null, (String)entry.getKey());
        }
    }

    private void getHeapObjectMemoryPathsFromStack(Map<SMGObject, SMGMemoryPath> pResult, Set<SMGObject> pReached) {
        int pLocationOnStack = 0;
        for (CLangStackFrame frame : this.smg.getStackFrames()) {
            String functionName = frame.getFunctionDeclaration().getName();
            for (Map.Entry<String, SMGRegion> entry : frame.getVariables().entrySet()) {
                this.getHeapObjectMemoryPathsFromObject(entry.getValue(), pResult, pReached, SMGObjectPosition.STACK, null, functionName, pLocationOnStack, entry.getKey());
            }
            if (frame.getReturnObject() == null) continue;
            this.getHeapObjectMemoryPathsFromObject(frame.getReturnObject(), pResult, pReached, SMGObjectPosition.STACK, null, functionName, pLocationOnStack, frame.getReturnObject().getLabel());
            ++pLocationOnStack;
        }
    }

    private void getHeapObjectMemoryPathsFromObject(SMGObject pSmgObject, Map<SMGObject, SMGMemoryPath> pResult, Set<SMGObject> pReached, SMGObjectPosition pPos, SMGMemoryPath pParent, String pFunctionName, Integer pLocationOnStack, String pVariableName) {
        ArrayList<Long> offsets = new ArrayList<Long>();
        HashMap<Long, SMGObject> offsetToRegion = new HashMap<Long, SMGObject>();
        HashMap<Long, SMGMemoryPath> offsetToParent = new HashMap<Long, SMGMemoryPath>();
        for (SMGEdgeHasValue objectHve : this.smg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pSmgObject))) {
            SMGValue value = objectHve.getValue();
            if (!this.smg.isPointer(value)) continue;
            SMGObject rObject = this.smg.getObjectPointedBy(value);
            long offset = objectHve.getOffset();
            if (!this.smg.isHeapObject(rObject) || pReached.contains(rObject)) continue;
            pReached.add(rObject);
            offsets.add(offset);
            offsetToRegion.put(offset, rObject);
            SMGMemoryPath path = this.getSMGMemoryPath(pVariableName, offset, pPos, pFunctionName, pLocationOnStack, pParent);
            offsetToParent.put(offset, path);
            pResult.put(rObject, path);
        }
        Collections.sort(offsets);
        Iterator<Object> iterator = offsets.iterator();
        while (iterator.hasNext()) {
            long offset = (Long)iterator.next();
            SMGObject smgObject = (SMGObject)offsetToRegion.get(offset);
            SMGMemoryPath currentPath = (SMGMemoryPath)offsetToParent.get(offset);
            this.getHeapObjectMemoryPathsFromObject(smgObject, pResult, pReached, SMGObjectPosition.HEAP, currentPath, null, null, null);
        }
    }

    private SMGMemoryPath getSMGMemoryPath(String pVariableName, long pOffset, SMGObjectPosition pPos, String pFunctionName, Integer pLocationOnStack, SMGMemoryPath pParent) {
        switch (pPos) {
            case GLOBAL: {
                return SMGMemoryPath.valueOf(pVariableName, pOffset);
            }
            case STACK: {
                return SMGMemoryPath.valueOf(pVariableName, pFunctionName, pOffset, pLocationOnStack);
            }
            case HEAP: {
                return SMGMemoryPath.valueOf(pParent, pOffset);
            }
        }
        throw new AssertionError();
    }

    private static enum SMGObjectPosition {
        STACK,
        HEAP,
        GLOBAL;

    }
}

