/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.refiner;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.smg.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.SMGUtils;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGInterpolant;

public class SMGPathInterpolationExporter {
    private final LogManager logger;
    private final PathTemplate exportPath;
    private final SMGOptions.SMGExportLevel exportWhen;

    SMGPathInterpolationExporter(LogManager pLogger, PathTemplate pExportPath, SMGOptions.SMGExportLevel pExportWhen) {
        this.logger = pLogger;
        this.exportPath = pExportPath;
        this.exportWhen = pExportWhen;
    }

    void exportInterpolation(ARGPath pErrorPath, Map<ARGState, SMGInterpolant> pInterpolants, int pInterpolationId) {
        if (this.exportWhen != SMGOptions.SMGExportLevel.EVERY || this.exportPath == null) {
            return;
        }
        this.exportCFAPath(pErrorPath.getInnerEdges(), pInterpolationId);
        ARGState firstState = pErrorPath.getFirstState();
        if (pInterpolants.containsKey(firstState)) {
            SMGInterpolant firstInterpolant = pInterpolants.get(firstState);
            this.exportFirstInterpolant(firstInterpolant, pInterpolationId);
        }
        PathIterator pathIterator = pErrorPath.pathIterator();
        int pathIndex = 2;
        while (pathIterator.advanceIfPossible()) {
            ARGState currentARGState = pathIterator.getAbstractState();
            if (!pInterpolants.containsKey(currentARGState)) {
                ++pathIndex;
                continue;
            }
            SMGInterpolant currentInterpolant = pInterpolants.get(currentARGState);
            CFANode currentLocation = pathIterator.getLocation();
            CFAEdge currentIncomingEdge = pathIterator.getIncomingEdge();
            this.exportInterpolant(currentInterpolant, currentLocation, currentIncomingEdge, pInterpolationId, pathIndex);
            ++pathIndex;
        }
    }

    private void exportFirstInterpolant(SMGInterpolant pFirstInterpolant, int pInterpolationId) {
        if (pFirstInterpolant.isFalse()) {
            return;
        }
        Object states = pFirstInterpolant.reconstructState();
        int counter = 1;
        Iterator iterator = states.iterator();
        while (iterator.hasNext()) {
            SMGState state = (SMGState)iterator.next();
            String fileName = "smgInterpolant-1-smg-" + counter++ + ".dot";
            Path path = this.exportPath.getPath(new Object[]{pInterpolationId, fileName});
            String name = "First interpolant";
            SMGUtils.dumpSMGPlot(this.logger, state, name, path);
        }
    }

    private void exportInterpolant(SMGInterpolant pCurrentInterpolant, CFANode pCurrentLocation, CFAEdge pIncomingEdge, int pInterpolationId, int pPathIndex) {
        if (!this.isImportantEdge(pIncomingEdge) || pCurrentInterpolant.isFalse()) {
            return;
        }
        Object states = pCurrentInterpolant.reconstructState();
        int counter = 1;
        Iterator iterator = states.iterator();
        while (iterator.hasNext()) {
            SMGState state = (SMGState)iterator.next();
            String fileName = "smgInterpolant-" + pPathIndex + "-smg-" + counter++ + ".dot";
            Path path = this.exportPath.getPath(new Object[]{pInterpolationId, fileName});
            String location = pIncomingEdge + " on N" + pCurrentLocation.getNodeNumber();
            SMGUtils.dumpSMGPlot(this.logger, state, location, path);
        }
    }

    private boolean isImportantEdge(CFAEdge edge) {
        CDeclaration cDcl;
        if (edge.getEdgeType() == CFAEdgeType.BlankEdge) {
            return false;
        }
        return edge.getEdgeType() != CFAEdgeType.DeclarationEdge || !((cDcl = ((CDeclarationEdge)edge).getDeclaration()) instanceof CFunctionDeclaration) && !(cDcl instanceof CTypeDeclaration);
    }

    private void exportCFAPath(List<CFAEdge> pFullPath, int pInterpolationId) {
        StringBuilder interpolationPath = new StringBuilder();
        for (CFAEdge edge : pFullPath) {
            if (!this.isImportantEdge(edge)) continue;
            interpolationPath.append(edge).append("\n");
        }
        Path path = this.exportPath.getPath(new Object[]{pInterpolationId, "interpolationPath.txt"});
        try {
            IO.writeFile((Path)path, (Charset)Charset.defaultCharset(), (Object)interpolationPath.toString());
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Failed to write interpolation path to path " + path);
        }
    }
}

