/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.refiner;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.smg.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGEdgeInterpolator;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGFeasibilityChecker;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGInterpolant;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGInterpolantManager;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGPathInterpolationExporter;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;

public class SMGPathInterpolator {
    protected int interpolationOffset = -1;
    private static final UniqueIdGenerator idGenerator = new UniqueIdGenerator();
    private final StatCounter totalInterpolations = new StatCounter("Number of interpolations");
    private final StatInt totalInterpolationQueries = new StatInt(StatKind.SUM, "Number of interpolation queries");
    private final ShutdownNotifier shutdownNotifier;
    private final SMGEdgeInterpolator interpolator;
    private final SMGInterpolantManager interpolantManager;
    private final SMGFeasibilityChecker checker;
    private final LogManager logger;
    private final SMGPathInterpolationExporter exporter;

    public SMGPathInterpolator(ShutdownNotifier pShutdownNotifier, SMGInterpolantManager pInterpolantManager, SMGEdgeInterpolator pInterpolator, LogManager pLogger, PathTemplate pExportPath, SMGOptions.SMGExportLevel pExportWhen, SMGFeasibilityChecker pChecker) {
        this.shutdownNotifier = pShutdownNotifier;
        this.interpolantManager = pInterpolantManager;
        this.interpolator = pInterpolator;
        this.logger = pLogger;
        this.checker = pChecker;
        this.exporter = new SMGPathInterpolationExporter(pLogger, pExportPath, pExportWhen);
    }

    public Map<ARGState, SMGInterpolant> performInterpolation(ARGPath pErrorPath, SMGInterpolant pInterpolant, ARGReachedSet pReachedSet) throws InterruptedException, CPAException {
        this.totalInterpolations.inc();
        int interpolationId = idGenerator.getFreshId();
        this.logger.log(Level.ALL, new Object[]{"Start interpolating path with interpolation id ", interpolationId});
        this.interpolationOffset = -1;
        Map<ARGState, SMGInterpolant> interpolants = this.performEdgeBasedInterpolation(pErrorPath, pInterpolant, pReachedSet);
        this.propagateFalseInterpolant(pErrorPath, pErrorPath, interpolants);
        this.exporter.exportInterpolation(pErrorPath, interpolants, interpolationId);
        this.logger.log(Level.ALL, new Object[]{"Finish generating Interpolants for path with interpolation id ", interpolationId});
        return interpolants;
    }

    private void propagateFalseInterpolant(ARGPath errorPath, ARGPath pErrorPathPrefix, Map<ARGState, SMGInterpolant> pInterpolants) {
        if (pErrorPathPrefix.size() < errorPath.size()) {
            PathIterator it = errorPath.pathIterator();
            for (int i = 0; i < pErrorPathPrefix.size(); ++i) {
                it.advance();
            }
            for (ARGState state : it.getSuffixInclusive().asStatesList()) {
                pInterpolants.put(state, this.interpolantManager.getFalseInterpolant());
            }
        }
    }

    private Map<ARGState, SMGInterpolant> performEdgeBasedInterpolation(ARGPath pErrorPath, SMGInterpolant pInterpolant, ARGReachedSet pReachedSet) throws InterruptedException, CPAException {
        boolean checkAllTargets = !this.checker.isFeasible(pErrorPath, true);
        LinkedHashMap<ARGState, SMGInterpolant> pathInterpolants = new LinkedHashMap<ARGState, SMGInterpolant>(pErrorPath.size());
        PathIterator pathIterator = pErrorPath.pathIterator();
        ArrayList<SMGInterpolant> interpolants = new ArrayList<SMGInterpolant>();
        interpolants.add(pInterpolant);
        while (pathIterator.hasNext()) {
            ArrayList<SMGInterpolant> resultingInterpolants = new ArrayList<SMGInterpolant>();
            for (SMGInterpolant interpolant : interpolants) {
                this.shutdownNotifier.shutdownIfNecessary();
                if (!interpolant.isFalse()) {
                    ARGState nextARGState = pathIterator.getNextAbstractState();
                    List<SMGInterpolant> deriveResult = this.interpolator.deriveInterpolant(pathIterator.getOutgoingEdge(), pathIterator.getPosition(), interpolant, checkAllTargets, pReachedSet, nextARGState);
                    resultingInterpolants.addAll(deriveResult);
                } else {
                    resultingInterpolants.add(this.interpolantManager.getFalseInterpolant());
                }
                this.totalInterpolationQueries.setNextValue(this.interpolator.getNumberOfInterpolationQueries());
                if (interpolant.isTrivial() || this.interpolationOffset != -1) continue;
                this.interpolationOffset = pathIterator.getIndex();
            }
            pathIterator.advance();
            SMGInterpolant jointResultInterpolant = this.joinInterpolants(resultingInterpolants);
            ARGState argState = pathIterator.getAbstractState();
            pathInterpolants.put(argState, jointResultInterpolant);
            interpolants.clear();
            interpolants.addAll(resultingInterpolants);
        }
        return pathInterpolants;
    }

    private SMGInterpolant joinInterpolants(List<SMGInterpolant> pResultingInterpolants) {
        SMGInterpolant result = null;
        for (SMGInterpolant interpolant : pResultingInterpolants) {
            if (result == null) {
                result = interpolant;
                continue;
            }
            result = result.join(interpolant);
        }
        return result;
    }
}

