/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.refiner;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionBlock;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGInterpolant;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGMemoryPath;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentMultimap;
import org.sosy_lab.cpachecker.util.predicates.BlockOperator;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public abstract class SMGPrecision
implements Precision {
    private final SMGPrecisionAbstractionOptions options;
    private final int maxLength;
    private final int threshold = 0;

    protected SMGPrecision(SMGPrecisionAbstractionOptions pOptions) {
        this.options = pOptions;
        this.maxLength = 2;
    }

    protected SMGPrecision(SMGPrecisionAbstractionOptions pOptions, int pMaxLength) {
        this.options = pOptions;
        this.maxLength = pMaxLength;
    }

    public static SMGPrecision createStaticPrecision(boolean pEnableHeapAbstraction) {
        SMGPrecisionAbstractionOptions options = new SMGPrecisionAbstractionOptions(pEnableHeapAbstraction, false, false);
        return new SMGStaticPrecision(options);
    }

    public static SMGPrecision createStaticPrecision(boolean pEnableHeapAbstraction, int pMaxLength) {
        SMGPrecisionAbstractionOptions options = new SMGPrecisionAbstractionOptions(pEnableHeapAbstraction, false, false);
        return new SMGStaticPrecision(options, pMaxLength);
    }

    public abstract Precision withIncrement(Map<CFANode, SMGInterpolant.SMGPrecisionIncrement> var1);

    public abstract SMGPrecision join(SMGPrecision var1);

    public static SMGPrecision createRefineablePrecision(SMGPrecision pPrecision) {
        return new SMGRefineablePrecision(new SMGPrecisionAbstractionOptions(pPrecision.options.allowsHeapAbstraction(), true, true), PersistentMultimap.of(), PersistentMultimap.of(), PersistentMultimap.of());
    }

    public abstract boolean isTracked(SMGMemoryPath var1, CFANode var2);

    public abstract Set<SMGMemoryPath> getTrackedMemoryPathsOnNode(CFANode var1);

    public abstract Set<MemoryLocation> getTrackedStackVariablesOnNode(CFANode var1);

    public boolean allowsHeapAbstractionOnNode(CFANode pCfaNode, BlockOperator pBlockOperator) {
        return this.options.allowsHeapAbstraction() && pBlockOperator.isBlockEnd(pCfaNode, 0);
    }

    public SMGPrecisionAbstractionOptions getAbstractionOptions() {
        return this.options;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SMGPrecision)) {
            return false;
        }
        SMGPrecision other = (SMGPrecision)o;
        return 0 == other.threshold && this.maxLength == other.maxLength && this.options.equals(other.options);
    }

    public int hashCode() {
        return this.options.hashCode() + this.maxLength;
    }

    public abstract Set<SMGAbstractionBlock> getAbstractionBlocks(CFANode var1);

    public static final class SMGPrecisionAbstractionOptions {
        private final boolean heapAbstraction;
        private final boolean fieldAbstraction;
        private final boolean stackAbstraction;

        public SMGPrecisionAbstractionOptions(boolean pHeapAbstraction, boolean pFieldAbstraction, boolean pStackAbstraction) {
            this.heapAbstraction = pHeapAbstraction;
            this.fieldAbstraction = pFieldAbstraction;
            this.stackAbstraction = pStackAbstraction;
        }

        public boolean allowsHeapAbstraction() {
            return this.heapAbstraction;
        }

        public boolean allowsFieldAbstraction() {
            return this.fieldAbstraction;
        }

        public boolean allowsStackAbstraction() {
            return this.stackAbstraction;
        }

        public int hashCode() {
            return Objects.hash(this.fieldAbstraction, this.heapAbstraction, this.stackAbstraction);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SMGPrecisionAbstractionOptions)) {
                return false;
            }
            SMGPrecisionAbstractionOptions other = (SMGPrecisionAbstractionOptions)obj;
            return this.fieldAbstraction == other.fieldAbstraction && this.heapAbstraction == other.heapAbstraction && this.stackAbstraction == other.stackAbstraction;
        }

        public String toString() {
            return "SMGPrecisionAbstractionOptions [heapAbstraction=" + this.heapAbstraction + ", fieldAbstraction=" + this.fieldAbstraction + ", stackAbstraction=" + this.stackAbstraction + "]";
        }
    }

    private static class SMGStaticPrecision
    extends SMGPrecision {
        private SMGStaticPrecision(SMGPrecisionAbstractionOptions pAllowsHeapAbstraction) {
            super(pAllowsHeapAbstraction);
        }

        public SMGStaticPrecision(SMGPrecisionAbstractionOptions pAllowsHeapAbstraction, int pMaxLength) {
            super(pAllowsHeapAbstraction, pMaxLength);
        }

        @Override
        public boolean isTracked(SMGMemoryPath pPath, CFANode pCfaNode) {
            return true;
        }

        @Override
        public Precision withIncrement(Map<CFANode, SMGInterpolant.SMGPrecisionIncrement> pPrecisionIncrement) {
            return this;
        }

        @Override
        public SMGPrecision join(SMGPrecision pPrecision) {
            return this;
        }

        @Override
        public Set<SMGAbstractionBlock> getAbstractionBlocks(CFANode pLocation) {
            return ImmutableSet.of();
        }

        @Override
        public Set<SMGMemoryPath> getTrackedMemoryPathsOnNode(CFANode pCfaNode) {
            throw new UnsupportedOperationException("Method not yet implemented.");
        }

        @Override
        public Set<MemoryLocation> getTrackedStackVariablesOnNode(CFANode pCfaNode) {
            throw new UnsupportedOperationException("Method not yet implemented.");
        }

        public String toString() {
            return "Static precision " + this.getAbstractionOptions();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof SMGStaticPrecision && super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class SMGRefineablePrecision
    extends SMGPrecision {
        private final PersistentMultimap<CFANode, SMGMemoryPath> trackedMemoryPaths;
        private final PersistentMultimap<CFANode, MemoryLocation> trackedStackVariables;
        private final PersistentMultimap<CFANode, SMGAbstractionBlock> abstractionBlocks;

        private SMGRefineablePrecision(SMGPrecisionAbstractionOptions pOptions, PersistentMultimap<CFANode, SMGMemoryPath> pTrackedMemoryPaths, PersistentMultimap<CFANode, SMGAbstractionBlock> pAbstractionBlocks, PersistentMultimap<CFANode, MemoryLocation> pTrackedStackVariables) {
            super(pOptions);
            this.trackedMemoryPaths = pTrackedMemoryPaths;
            this.abstractionBlocks = pAbstractionBlocks;
            this.trackedStackVariables = pTrackedStackVariables;
        }

        @Override
        public Set<SMGMemoryPath> getTrackedMemoryPathsOnNode(CFANode pLocationNode) {
            return this.trackedMemoryPaths.get(pLocationNode);
        }

        @Override
        public Set<MemoryLocation> getTrackedStackVariablesOnNode(CFANode pCfaNode) {
            return this.trackedStackVariables.get(pCfaNode);
        }

        @Override
        public Precision withIncrement(Map<CFANode, SMGInterpolant.SMGPrecisionIncrement> pPrecisionIncrement) {
            PersistentMultimap<CFANode, SMGMemoryPath> resultMemoryPaths = this.trackedMemoryPaths;
            PersistentMultimap<CFANode, MemoryLocation> resultStackVariables = this.trackedStackVariables;
            PersistentMultimap<CFANode, SMGAbstractionBlock> resultAbstractionBlocks = this.abstractionBlocks;
            for (Map.Entry<CFANode, SMGInterpolant.SMGPrecisionIncrement> entry : pPrecisionIncrement.entrySet()) {
                SMGInterpolant.SMGPrecisionIncrement inc = entry.getValue();
                CFANode cfaNode = entry.getKey();
                resultAbstractionBlocks = resultAbstractionBlocks.putAllAndCopy(cfaNode, inc.getAbstractionBlock());
                resultMemoryPaths = resultMemoryPaths.putAllAndCopy(cfaNode, inc.getPathsToTrack());
                resultStackVariables = resultStackVariables.putAllAndCopy(cfaNode, inc.getStackVariablesToTrack());
            }
            return new SMGRefineablePrecision(this.getAbstractionOptions(), resultMemoryPaths, resultAbstractionBlocks, resultStackVariables);
        }

        @Override
        public SMGPrecision join(SMGPrecision pPrecision) {
            if (pPrecision instanceof SMGStaticPrecision) {
                return pPrecision;
            }
            SMGRefineablePrecision other = (SMGRefineablePrecision)pPrecision;
            assert (this.getAbstractionOptions().equals(pPrecision.getAbstractionOptions()));
            return new SMGRefineablePrecision(this.getAbstractionOptions(), this.trackedMemoryPaths.putAllAndCopy(other.trackedMemoryPaths), this.abstractionBlocks.putAllAndCopy(other.abstractionBlocks), this.trackedStackVariables.putAllAndCopy(other.trackedStackVariables));
        }

        @Override
        public boolean isTracked(SMGMemoryPath pPath, CFANode pCfaNode) {
            return this.trackedMemoryPaths.get(pCfaNode).contains((Object)pPath);
        }

        @Override
        public Set<SMGAbstractionBlock> getAbstractionBlocks(CFANode location) {
            return this.abstractionBlocks.get(location);
        }

        public String toString() {
            return "SMGRefineablePrecision [trackedMemoryPaths=" + this.trackedMemoryPaths + ", trackedStackVariables=" + this.trackedStackVariables + ", abstractionBlocks=" + this.abstractionBlocks + "]";
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof SMGRefineablePrecision) && !super.equals(o)) {
                return false;
            }
            SMGRefineablePrecision other = (SMGRefineablePrecision)o;
            return this.trackedMemoryPaths.equals(other.trackedMemoryPaths) && this.trackedStackVariables.equals(other.trackedStackVariables) && this.abstractionBlocks.equals(other.abstractionBlocks);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + Objects.hash(this.trackedMemoryPaths, this.trackedStackVariables, this.abstractionBlocks);
        }
    }
}

