/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.refiner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.automaton.ControlAutomatonCPA;
import org.sosy_lab.cpachecker.cpa.smg.SMGCPA;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGPredicateManager;
import org.sosy_lab.cpachecker.cpa.smg.SMGTransferRelationKind;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGEdgeInterpolator;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGFeasibilityChecker;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGInterpolant;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGInterpolantManager;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGInterpolationTree;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGPathInterpolator;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGPrecision;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGStrongestPostOperator;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.refinement.InterpolationTree;
import org.sosy_lab.cpachecker.util.refinement.PathExtractor;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;

@Options(prefix="cpa.smg.refinement")
public class SMGRefiner
implements Refiner {
    private final LogManager logger;
    private final SMGFeasibilityChecker checker;
    private final ARGCPA argCpa;
    private final SMGCPA smgCpa;
    private final PathExtractor pathExtractor;
    private final SMGInterpolantManager interpolantManager;
    private final SMGPathInterpolator interpolator;
    private final StatCounter refinementCounter = new StatCounter("Number of refinements");
    private final StatInt numberOfTargets = new StatInt(StatKind.SUM, "Number of targets found");
    private final ShutdownNotifier shutdownNotifier;
    @Option(secure=true, description="export interpolation trees to this file template")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate interpolationTreeExportFile = PathTemplate.ofFormatString((String)"interpolationTree.%d-%d.dot");
    @Option(secure=true, description="export interpolant smgs for every path interpolation to this path template")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate exportInterpolantSMGs = PathTemplate.ofFormatString((String)"smg/interpolation-%d/%s");
    @Option(secure=true, description="export interpolant smgs for every path interpolation to this path template")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate exportRefinementSMGs = PathTemplate.ofFormatString((String)"smg/refinement-%d/smg-%s");
    @Option(secure=true, description="when to export the interpolation tree\nNEVER:   never export the interpolation tree\nFINAL:   export the interpolation tree once after each refinement\nALWAYS:  export the interpolation tree once after each interpolation, i.e. multiple times per refinement", values={"NEVER", "FINAL", "ALWAYS"})
    private String exportInterpolationTree = "NEVER";

    private SMGRefiner(SMGCPA pSmgCpa, ARGCPA pArgCpa, Set<ControlAutomatonCPA> automatonCpas) throws InvalidConfigurationException, SMGInconsistentException {
        pSmgCpa.getConfiguration().inject((Object)this);
        this.argCpa = pArgCpa;
        this.smgCpa = pSmgCpa;
        this.logger = pSmgCpa.getLogger();
        CFA cfa = pSmgCpa.getCFA();
        this.shutdownNotifier = pSmgCpa.getShutdownNotifier();
        this.smgCpa.enableRefinement(this.exportRefinementSMGs);
        this.pathExtractor = new PathExtractor(this.logger, pSmgCpa.getConfiguration());
        SMGPredicateManager predicateManager = this.smgCpa.getPredicateManager();
        SMGStrongestPostOperator strongestPostOpForCEX = new SMGStrongestPostOperator(this.logger, cfa, predicateManager, this.smgCpa.getOptions(), SMGTransferRelationKind.STATIC, this.shutdownNotifier);
        UnmodifiableSMGState initialState = this.smgCpa.getInitialState(cfa.getMainFunction(), StateSpacePartition.getDefaultPartition());
        this.checker = new SMGFeasibilityChecker(strongestPostOpForCEX, this.logger, cfa, initialState, automatonCpas);
        this.interpolantManager = new SMGInterpolantManager(this.logger, cfa, this.smgCpa.getOptions());
        SMGStrongestPostOperator strongestPostOpForInterpolation = new SMGStrongestPostOperator(this.logger, cfa, predicateManager, this.smgCpa.getOptions(), SMGTransferRelationKind.REFINEMENT, this.shutdownNotifier);
        SMGFeasibilityChecker checkerForInterpolation = new SMGFeasibilityChecker(strongestPostOpForInterpolation, this.logger, cfa, initialState, automatonCpas);
        SMGEdgeInterpolator edgeInterpolator = new SMGEdgeInterpolator(checkerForInterpolation, strongestPostOpForInterpolation, this.interpolantManager, this.shutdownNotifier, this.logger, this.smgCpa.getBlockOperator());
        this.interpolator = new SMGPathInterpolator(this.shutdownNotifier, this.interpolantManager, edgeInterpolator, this.logger, this.exportInterpolantSMGs, this.smgCpa.getOptions().getExportSMGLevel(), checkerForInterpolation);
    }

    public static SMGRefiner create(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException, SMGInconsistentException {
        ARGCPA argCpa = CPAs.retrieveCPAOrFail(pCpa, ARGCPA.class, SMGRefiner.class);
        SMGCPA smgCpa = CPAs.retrieveCPAOrFail(pCpa, SMGCPA.class, SMGRefiner.class);
        ImmutableSet automatonCpas = CPAs.asIterable(pCpa).filter(ControlAutomatonCPA.class).toSet();
        return new SMGRefiner(smgCpa, argCpa, (Set<ControlAutomatonCPA>)automatonCpas);
    }

    @Override
    public boolean performRefinement(ReachedSet pReached) throws CPAException, InterruptedException {
        List<ARGPath> targetPaths;
        ARGReachedSet reached = new ARGReachedSet(pReached, this.argCpa);
        Collection<ARGState> targets = this.pathExtractor.getTargetStates(reached);
        CounterexampleInfo cexInfo = this.performRefinementForPaths(reached, targets, targetPaths = this.pathExtractor.getTargetPaths(targets));
        boolean isSpuriousCEX = cexInfo.isSpurious();
        if (isSpuriousCEX) {
            this.smgCpa.nextRefinement();
        }
        return isSpuriousCEX;
    }

    private CounterexampleInfo performRefinementForPaths(ARGReachedSet pReached, Collection<ARGState> pTargets, List<ARGPath> pTargetPaths) throws CPAException, InterruptedException {
        Preconditions.checkState((pTargets.size() == pTargetPaths.size() ? 1 : 0) != 0);
        this.logger.log(Level.FINEST, new Object[]{"performing refinement ..."});
        this.refinementCounter.inc();
        this.numberOfTargets.setNextValue(pTargets.size());
        CounterexampleInfo cex = this.isAnyPathFeasible(pReached, pTargetPaths);
        if (cex.isSpurious()) {
            SMGInterpolationTree interpolationTree = this.obtainInterpolants(pTargetPaths, pReached);
            this.refineUsingInterpolants(pReached, interpolationTree);
        }
        this.logger.log(Level.FINEST, new Object[]{"refinement finished"});
        return cex;
    }

    private List<ARGPath> getFeasibleErrorPaths(Collection<ARGPath> pErrorPaths) throws CPAException, InterruptedException {
        ArrayList<ARGPath> lst = new ArrayList<ARGPath>();
        for (ARGPath currentPath : pErrorPaths) {
            if (!this.checker.isFeasible(currentPath)) continue;
            lst.add(currentPath);
        }
        return lst;
    }

    private CounterexampleInfo isAnyPathFeasible(ARGReachedSet pReached, Collection<ARGPath> pErrorPaths) throws CPAException, InterruptedException {
        List<ARGPath> feasibleErrorPaths = this.getFeasibleErrorPaths(pErrorPaths);
        for (ARGPath aRGPath : feasibleErrorPaths) {
            this.pathExtractor.addFeasibleTarget(aRGPath.getLastState());
        }
        ARGPath feasiblePath = (ARGPath)((Object)Iterables.getFirst(feasibleErrorPaths, null));
        if (feasiblePath != null) {
            for (ARGPath others : pErrorPaths) {
                if (others == feasiblePath) continue;
                pReached.removeSubtree(others.getLastState());
            }
            this.logger.log(Level.FINEST, new Object[]{"found a feasible counterexample"});
            CFAPathWithAssumptions cFAPathWithAssumptions = this.createModel();
            if (!cFAPathWithAssumptions.isEmpty()) {
                return CounterexampleInfo.feasiblePrecise(feasiblePath, cFAPathWithAssumptions);
            }
            return CounterexampleInfo.feasibleImprecise(feasiblePath);
        }
        return CounterexampleInfo.spurious();
    }

    private CFAPathWithAssumptions createModel() {
        return CFAPathWithAssumptions.empty();
    }

    private SMGInterpolationTree obtainInterpolants(List<ARGPath> pTargetPaths, ARGReachedSet pReachedSet) throws CPAException, InterruptedException {
        SMGInterpolationTree interpolationTree = this.createInterpolationTree(pTargetPaths);
        while (interpolationTree.hasNextPathForInterpolation()) {
            this.performPathInterpolation(interpolationTree, pReachedSet);
        }
        this.exportTree(interpolationTree, "FINAL");
        return interpolationTree;
    }

    private void performPathInterpolation(SMGInterpolationTree interpolationTree, ARGReachedSet pReachedSet) throws CPAException, InterruptedException {
        ARGPath errorPath = interpolationTree.getNextPathForInterpolation();
        if (errorPath == InterpolationTree.EMPTY_PATH) {
            this.logger.log(Level.FINEST, new Object[]{"skipping interpolation, because false interpolant on path to target state"});
            return;
        }
        SMGInterpolant initialItp = interpolationTree.getInitialInterpolantForPath(errorPath);
        if (this.isInitialInterpolantTooWeak(interpolationTree.getRoot(), initialItp, errorPath)) {
            errorPath = ARGUtils.getOnePathTo(errorPath.getLastState());
            initialItp = this.interpolantManager.createInitialInterpolant();
        }
        this.logger.log(Level.FINEST, new Object[]{"performing interpolation, starting at ", errorPath.getFirstState().getStateId(), ", using interpolant ", initialItp});
        interpolationTree.addInterpolants(this.interpolator.performInterpolation(errorPath, initialItp, pReachedSet));
        this.exportTree(interpolationTree, "ALWAYS");
    }

    private boolean isInitialInterpolantTooWeak(ARGState root, SMGInterpolant initialItp, ARGPath errorPath) throws CPAException, InterruptedException {
        if (Objects.equals(errorPath.getFirstState(), root)) {
            return false;
        }
        Iterator iterator = initialItp.reconstructState().iterator();
        while (iterator.hasNext()) {
            UnmodifiableSMGState start = (UnmodifiableSMGState)iterator.next();
            if (!this.checker.isFeasible(errorPath, start)) continue;
            return true;
        }
        return false;
    }

    private SMGInterpolationTree createInterpolationTree(List<ARGPath> pTargetPaths) {
        return new SMGInterpolationTree(this.interpolantManager, this.logger, pTargetPaths, true);
    }

    private void refineUsingInterpolants(ARGReachedSet pReached, SMGInterpolationTree pInterpolationTree) throws InterruptedException {
        HashMap refinementInformation = new HashMap();
        Collection<ARGState> refinementRoots = pInterpolationTree.obtainRefinementRoots();
        for (ARGState aRGState : refinementRoots) {
            this.shutdownNotifier.shutdownIfNecessary();
            ArrayList<Precision> precisions = new ArrayList<Precision>(2);
            precisions.add(this.mergeSMGPrecisionsForSubgraph(aRGState, pReached).withIncrement(pInterpolationTree.extractPrecisionIncrement(aRGState)));
            refinementInformation.put(aRGState, precisions);
        }
        for (Map.Entry entry : refinementInformation.entrySet()) {
            this.shutdownNotifier.shutdownIfNecessary();
            ArrayList precisionTypes = Lists.newArrayList((Object[])new Predicate[]{Predicates.instanceOf(SMGPrecision.class)});
            pReached.removeSubtree((ARGState)entry.getKey(), (List)entry.getValue(), precisionTypes);
        }
    }

    private SMGPrecision mergeSMGPrecisionsForSubgraph(ARGState pRefinementRoot, ARGReachedSet pReached) {
        Set uniquePrecisions = Sets.newIdentityHashSet();
        for (ARGState descendant : ARGUtils.getNonCoveredStatesInSubgraph(pRefinementRoot)) {
            uniquePrecisions.add(Precisions.extractPrecisionByType(pReached.asReachedSet().getPrecision(descendant), SMGPrecision.class));
        }
        SMGPrecision mergedPrecision = (SMGPrecision)Iterables.getLast((Iterable)uniquePrecisions);
        for (SMGPrecision precision : uniquePrecisions) {
            mergedPrecision = mergedPrecision.join(precision);
        }
        return mergedPrecision;
    }

    private void exportTree(SMGInterpolationTree interpolationTree, String level) {
        if (this.interpolationTreeExportFile != null && this.exportInterpolationTree.equals(level)) {
            interpolationTree.exportToDot(this.interpolationTreeExportFile, this.refinementCounter.getValue());
        }
    }
}

