/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.refiner;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGUseGraphEdge;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGUseVertice;

public class SMGUseGraph<V extends SMGUseVertice, E extends SMGUseGraphEdge<V>> {
    private final Multimap<V, E> graph = HashMultimap.create();

    public void addEdge(E edge) {
        this.graph.put(edge.getSource(), edge);
    }

    public String toString() {
        return this.graph.toString();
    }

    public Map<V, SMGUseRange> getAllTargetsAndUseRangeOfSources(Set<V> pSources, int curPos) {
        HashMap<SMGUseVertice, SMGUseRange> result = new HashMap<SMGUseVertice, SMGUseRange>();
        HashSet<SMGUseVertice> waitlist = new HashSet<SMGUseVertice>();
        HashSet addToWaitlist = new HashSet();
        for (SMGUseVertice source : pSources) {
            int srcPos = source.getPosition();
            assert (srcPos <= curPos);
            result.put(source, new SMGUseRange(srcPos, curPos));
            waitlist.add(source);
        }
        while (!waitlist.isEmpty()) {
            for (SMGUseVertice source : waitlist) {
                for (SMGUseGraphEdge edge : this.graph.get((Object)source)) {
                    Object target = edge.getTarget();
                    if (!result.containsKey(target)) {
                        result.put((SMGUseVertice)target, new SMGUseRange(target.getPosition(), source.getPosition()));
                        addToWaitlist.add(target);
                        continue;
                    }
                    SMGUseRange range = (SMGUseRange)result.get(target);
                    if (range.getPosUse() >= source.getPosition()) continue;
                    result.put((SMGUseVertice)target, new SMGUseRange(target.getPosition(), source.getPosition()));
                }
            }
            waitlist.clear();
            waitlist.addAll(addToWaitlist);
            addToWaitlist.clear();
        }
        return result;
    }

    public static class SMGUseRange {
        private final int posStart;
        private final int posUse;

        public SMGUseRange(int pStart, int pUse) {
            this.posStart = pStart;
            this.posUse = pUse;
        }

        public int getPosUse() {
            return this.posUse;
        }

        public int getPosStart() {
            return this.posStart;
        }

        public String toString() {
            return "SMGUseRange [posStart=" + this.posStart + ", posUse=" + this.posUse + "]";
        }
    }
}

