/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.util;

import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;

public class PersistentBiMap<K extends Comparable<? super K>, V extends Comparable<? super V>> {
    PersistentSortedMap<K, V> delegate;
    PersistentSortedMap<V, K> reverse;

    private PersistentBiMap(PersistentSortedMap<K, V> pDelegate, PersistentSortedMap<V, K> pReverse) {
        this.delegate = pDelegate;
        this.reverse = pReverse;
    }

    public static <K extends Comparable<? super K>, V extends Comparable<? super V>> PersistentBiMap<K, V> of() {
        return new PersistentBiMap<K, V>(PathCopyingPersistentTreeMap.of(), PathCopyingPersistentTreeMap.of());
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean containsKey(Object pO) {
        return this.delegate.containsKey(pO);
    }

    public boolean containsValue(Object pO) {
        return this.reverse.containsKey(pO);
    }

    public V get(Object pO) {
        return (V)((Comparable)this.delegate.get(pO));
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    public PersistentBiMap<V, K> inverse() {
        return new PersistentBiMap<V, K>(this.reverse, this.delegate);
    }

    public PersistentBiMap<K, V> putAndCopy(K pK, V pV) {
        return new PersistentBiMap<K, V>(this.delegate.putAndCopy(pK, pV), this.reverse.putAndCopy(pV, pK));
    }

    public PersistentBiMap<K, V> removeAndCopy(K pK) {
        V value = this.get(pK);
        if (value != null) {
            return this.removeAndCopy(pK, value);
        }
        return this;
    }

    private PersistentBiMap<K, V> removeAndCopy(K pK, V pV) {
        return new PersistentBiMap<K, V>(this.delegate.removeAndCopy(pK), this.reverse.removeAndCopy(pV));
    }
}

