/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;

@Immutable(containerOf={"K", "V"})
public class PersistentMultimap<K, V> {
    private final PersistentMap<K, ImmutableSet<V>> delegate;

    private PersistentMultimap(PersistentMap<K, ImmutableSet<V>> pDelegate) {
        this.delegate = pDelegate;
    }

    public static <K extends Comparable<? super K>, V> PersistentMultimap<K, V> of() {
        return new PersistentMultimap<K, V>(PathCopyingPersistentTreeMap.of());
    }

    public PersistentMultimap<K, V> putAndCopy(K key, V value) {
        return this.putAllAndCopy(key, Collections.singleton(value));
    }

    public PersistentMultimap<K, V> putAllAndCopy(K key, Iterable<V> values) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Set old = (Set)this.delegate.get(key);
        if (old != null) {
            builder.addAll((Iterable)old);
        }
        return new PersistentMultimap<K, V>(this.delegate.putAndCopy(key, (Object)builder.addAll(values).build()));
    }

    public PersistentMultimap<K, V> putAllAndCopy(PersistentMultimap<K, V> other) {
        PersistentMultimap<K, V> tmp = this;
        for (Map.Entry<K, ImmutableSet<V>> entry : other.entries()) {
            tmp = tmp.putAllAndCopy(entry.getKey(), (Iterable)entry.getValue());
        }
        return tmp;
    }

    public PersistentMultimap<K, V> removeAndCopy(K key) {
        return new PersistentMultimap<K, V>(this.delegate.removeAndCopy(key));
    }

    public PersistentMultimap<K, V> removeAndCopy(K key, V value) {
        Set old = (Set)this.delegate.get(key);
        if (old == null || !old.contains(value)) {
            return this;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(Iterables.filter((Iterable)old, e -> !e.equals(value)));
        ImmutableSet fresh = builder.build();
        if (fresh.isEmpty()) {
            return new PersistentMultimap<K, V>(this.delegate.removeAndCopy(key));
        }
        return new PersistentMultimap<K, V>(this.delegate.putAndCopy(key, (Object)fresh));
    }

    public ImmutableSet<V> get(K key) {
        ImmutableSet set = (ImmutableSet)this.delegate.get(key);
        return set == null ? ImmutableSet.of() : set;
    }

    public boolean contains(K key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsEntry(K key, V value) {
        return this.delegate.containsKey(key) && ((ImmutableSet)this.delegate.get(key)).contains(value);
    }

    public ImmutableSet<V> values() {
        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)this.delegate.values()));
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof PersistentMultimap && this.delegate.equals(((PersistentMultimap)o).delegate);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public Set<Map.Entry<K, ImmutableSet<V>>> entries() {
        return this.delegate.entrySet();
    }
}

