/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentSet;

@Immutable(containerOf={"K", "V"})
public class PersistentMultimapWithPersistentValues<K extends Comparable<? super K>, V extends Comparable<? super V>> {
    private final PersistentMap<K, PersistentSet<V>> delegate;

    private PersistentMultimapWithPersistentValues(PersistentMap<K, PersistentSet<V>> pDelegate) {
        this.delegate = pDelegate;
    }

    public static <K extends Comparable<? super K>, V extends Comparable<? super V>> PersistentMultimapWithPersistentValues<K, V> of() {
        return new PersistentMultimapWithPersistentValues<K, V>(PathCopyingPersistentTreeMap.of());
    }

    public PersistentMultimapWithPersistentValues<K, V> putAndCopy(K key, V value) {
        return this.putAllAndCopy(key, Collections.singleton(value));
    }

    public PersistentMultimapWithPersistentValues<K, V> putAllAndCopy(K key, Iterable<V> values) {
        PersistentSet<Comparable> old = (PersistentSet<Comparable>)this.delegate.get(key);
        if (old == null) {
            old = PersistentSet.of();
        }
        for (Comparable value : values) {
            old = old.addAndCopy(value);
        }
        return new PersistentMultimapWithPersistentValues<K, V>(this.delegate.putAndCopy(key, old));
    }

    public PersistentMultimapWithPersistentValues<K, V> putAllAndCopy(PersistentMultimapWithPersistentValues<K, V> other) {
        PersistentMultimapWithPersistentValues<Comparable, V> tmp = this;
        for (Map.Entry<K, PersistentSet<V>> entry : other.entries()) {
            tmp = tmp.putAllAndCopy((Comparable)entry.getKey(), (Iterable)entry.getValue());
        }
        return tmp;
    }

    public PersistentMultimapWithPersistentValues<K, V> removeAndCopy(K key) {
        return new PersistentMultimapWithPersistentValues<K, V>(this.delegate.removeAndCopy(key));
    }

    public PersistentMultimapWithPersistentValues<K, V> removeAndCopy(K key, V value) {
        PersistentSet<V> old = (PersistentSet<V>)this.delegate.get(key);
        if (old == null || !old.contains(value)) {
            return this;
        }
        if ((old = old.removeAndCopy(value)).isEmpty()) {
            return new PersistentMultimapWithPersistentValues<K, V>(this.delegate.removeAndCopy(key));
        }
        return new PersistentMultimapWithPersistentValues<K, V>(this.delegate.putAndCopy(key, old));
    }

    public PersistentSet<V> get(K key) {
        PersistentSet set = (PersistentSet)this.delegate.get(key);
        return set == null ? PersistentSet.of() : set;
    }

    public boolean contains(K key, V value) {
        return this.delegate.containsKey(key) && ((PersistentSet)this.delegate.get(key)).contains(value);
    }

    public ImmutableSet<V> values() {
        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)this.delegate.values()));
    }

    public int size() {
        return this.delegate.size();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof PersistentMultimapWithPersistentValues && this.delegate.equals(((PersistentMultimapWithPersistentValues)o).delegate);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public Set<Map.Entry<K, PersistentSet<V>>> entries() {
        return this.delegate.entrySet();
    }
}

