/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.util;

import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;

@Immutable(containerOf={"K"})
public class PersistentSet<K extends Comparable<? super K>>
implements Set<K> {
    private final PersistentMap<K, Void> delegate;

    private PersistentSet(PersistentMap<K, Void> pDelegate) {
        this.delegate = pDelegate;
    }

    public PersistentSet() {
        this.delegate = PathCopyingPersistentTreeMap.of();
    }

    public static <K extends Comparable<? super K>> PersistentSet<K> of() {
        return new PersistentSet<K>(PathCopyingPersistentTreeMap.of());
    }

    public static <K extends Comparable<? super K>> PersistentSet<K> of(K entry) {
        PersistentSet<K> retSet = new PersistentSet<K>(PathCopyingPersistentTreeMap.of());
        return retSet.addAndCopy(entry);
    }

    public static <K extends Comparable<? super K>> PersistentSet<K> copyOf(Collection<K> entries) {
        PersistentSet<Comparable> retSet = new PersistentSet<Comparable>((PersistentMap<Comparable, Void>)PathCopyingPersistentTreeMap.of());
        for (Comparable e : entries) {
            retSet = retSet.addAndCopy(e);
        }
        return retSet;
    }

    public static <K extends Comparable<? super K>> PersistentSet<K> copyOf(Iterable<K> entries) {
        PersistentSet<Comparable> retSet = new PersistentSet<Comparable>((PersistentMap<Comparable, Void>)PathCopyingPersistentTreeMap.of());
        for (Comparable e : entries) {
            retSet = retSet.addAndCopy(e);
        }
        return retSet;
    }

    @SuppressFBWarnings
    public PersistentSet<K> addAndCopy(K key) {
        return new PersistentSet<K>(this.delegate.putAndCopy(key, null));
    }

    public PersistentSet<K> removeAndCopy(K key) {
        return new PersistentSet<K>(this.delegate.removeAndCopy(key));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.containsKey(o);
    }

    public Set<K> asSet() {
        return this.delegate.keySet();
    }

    @Override
    public Iterator<K> iterator() {
        return this.delegate.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(K pK) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object el : c) {
            if (this.contains(el)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends K> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PersistentSet)) {
            return false;
        }
        PersistentSet other = (PersistentSet)o;
        return this.delegate.equals(other.delegate);
    }

    public String toString() {
        return this.delegate.keySet().toString();
    }
}

