/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.errorprone.annotations.Immutable;
import java.util.Iterator;
import java.util.Map;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;

@Immutable(containerOf={"T"})
public class PersistentStack<T>
implements Iterable<T> {
    private final PersistentMap<Integer, T> delegate;

    private PersistentStack(PersistentMap<Integer, T> pDelegate) {
        this.delegate = pDelegate;
    }

    public static <T> PersistentStack<T> of() {
        return new PersistentStack<T>(PathCopyingPersistentTreeMap.of());
    }

    public PersistentStack<T> pushAndCopy(T elem) {
        Preconditions.checkState((!this.delegate.containsKey((Object)(this.delegate.size() + 1)) ? 1 : 0) != 0, (Object)"level already exists");
        return new PersistentStack<T>(this.delegate.putAndCopy((Object)(this.delegate.size() + 1), elem));
    }

    public PersistentStack<T> popAndCopy() {
        Preconditions.checkState((!this.delegate.isEmpty() ? 1 : 0) != 0, (Object)"there is no element");
        return new PersistentStack<T>(this.delegate.removeAndCopy((Object)this.delegate.size()));
    }

    public T peek() {
        Preconditions.checkState((!this.delegate.isEmpty() ? 1 : 0) != 0, (Object)"there is no first element");
        return (T)this.delegate.get((Object)this.delegate.size());
    }

    public PersistentStack<T> replace(Predicate<T> pred, T elem) {
        for (Map.Entry entry : this.delegate.entrySet()) {
            if (!pred.apply(entry.getValue())) continue;
            int index = (Integer)entry.getKey();
            if (elem == entry.getValue()) {
                return this;
            }
            return new PersistentStack<T>(this.delegate.removeAndCopy((Object)index).putAndCopy((Object)index, elem));
        }
        throw new AssertionError((Object)"no match found");
    }

    public int size() {
        return this.delegate.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.values().iterator();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof PersistentStack && this.delegate.equals(((PersistentStack)o).delegate);
    }

    public String toString() {
        return "[" + Joiner.on((String)", ").join((Iterable)this.delegate.values()) + "]";
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }
}

