/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAdditionalInfo;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteStatePath;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.StopNeverOperator;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithAdditionalInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithConcreteCex;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.AdditionalInfoConverter;
import org.sosy_lab.cpachecker.cpa.smg.SMGStatistics;
import org.sosy_lab.cpachecker.cpa.smg2.AdditionalInfoExtractor;
import org.sosy_lab.cpachecker.cpa.smg2.SMGAdditionalInfoConverter;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPAExportOptions;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPAStatistics;
import org.sosy_lab.cpachecker.cpa.smg2.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg2.SMGPrecision;
import org.sosy_lab.cpachecker.cpa.smg2.SMGPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.SMGTransferRelation;
import org.sosy_lab.cpachecker.cpa.smg2.refiner.SMGConcreteErrorPathAllocator;
import org.sosy_lab.cpachecker.cpa.value.PredicateToValuePrecisionConverter;
import org.sosy_lab.cpachecker.cpa.value.symbolic.ConstraintsStrengthenOperator;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.predicates.BlockOperator;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

@Options(prefix="cpa.smg2")
public class SMGCPA
implements ConfigurableProgramAnalysis,
ConfigurableProgramAnalysisWithConcreteCex,
ConfigurableProgramAnalysisWithAdditionalInfo,
StatisticsProvider {
    @Option(secure=true, name="stop", toUppercase=true, values={"SEP", "NEVER", "END_BLOCK"}, description="which stop operator to use for the SMGCPA")
    private String stopType = "SEP";
    @Option(secure=true, name="merge", toUppercase=true, values={"SEP"}, description="which merge operator to use for the SMGCPA")
    private String mergeType = "SEP";
    @Option(secure=true, description="get an initial precision from file")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path initialPrecisionFile = null;
    @Option(secure=true, description="get an initial precision from a predicate precision file")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path initialPredicatePrecisionFile = null;
    private final MachineModel machineModel;
    private final BlockOperator blockOperator;
    private final LogManager logger;
    private final Configuration config;
    private final CFA cfa;
    private final SMGOptions options;
    private final SMGCPAExportOptions exportOptions;
    private final SMGPrecisionAdjustment.PrecAdjustmentOptions precisionAdjustmentOptions;
    private final SMGPrecisionAdjustment.PrecAdjustmentStatistics precisionAdjustmentStatistics;
    private final ShutdownNotifier shutdownNotifier;
    private VariableTrackingPrecision precision;
    private boolean refineablePrecisionSet = false;
    private final SMGStatistics stats = new SMGStatistics();
    private final PredicateToValuePrecisionConverter predToValPrec;
    private final ConstraintsStrengthenOperator constraintsStrengthenOperator;
    private final SMGCPAStatistics statistics;

    private SMGCPA(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.options = new SMGOptions(pConfig);
        this.config = pConfig;
        this.cfa = pCfa;
        this.machineModel = this.cfa.getMachineModel();
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.precision = this.initializePrecision(this.config, this.cfa);
        this.predToValPrec = new PredicateToValuePrecisionConverter(this.config, this.logger, pShutdownNotifier, this.cfa);
        this.constraintsStrengthenOperator = new ConstraintsStrengthenOperator(this.config, this.logger);
        this.statistics = new SMGCPAStatistics(this, this.config);
        this.precisionAdjustmentOptions = new SMGPrecisionAdjustment.PrecAdjustmentOptions(this.config, this.cfa);
        this.precisionAdjustmentStatistics = new SMGPrecisionAdjustment.PrecAdjustmentStatistics();
        this.blockOperator = new BlockOperator();
        pConfig.inject((Object)this.blockOperator);
        this.blockOperator.setCFA(this.cfa);
        this.exportOptions = new SMGCPAExportOptions(this.options.getExportSMGFilePattern(), this.options.getExportSMGLevel());
    }

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(SMGCPA.class);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    @Override
    public AdditionalInfoConverter exportAdditionalInfoConverter() {
        return new SMGAdditionalInfoConverter();
    }

    @Override
    public CFAPathWithAdditionalInfo createExtendedInfo(ARGPath pPath) {
        return new AdditionalInfoExtractor().createExtendedInfo(pPath);
    }

    @Override
    public ConcreteStatePath createConcreteStatePath(ARGPath pPath) {
        try {
            return new SMGConcreteErrorPathAllocator(this.config, this.logger, this.machineModel).allocateAssignmentsToPath(pPath);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return DelegateAbstractDomain.getInstance();
    }

    @Override
    public TransferRelation getTransferRelation() {
        return new SMGTransferRelation(this.logger, this.options, this.exportOptions, this.cfa, this.constraintsStrengthenOperator, this.statistics);
    }

    @Override
    public MergeOperator getMergeOperator() {
        switch (this.mergeType) {
            case "SEP": {
                return MergeSepOperator.getInstance();
            }
            case "JOIN": {
                return new MergeJoinOperator(this.getAbstractDomain());
            }
        }
        throw new AssertionError((Object)"unknown mergetype for SMGCPA");
    }

    @Override
    public StopOperator getStopOperator() {
        switch (this.stopType) {
            case "NEVER": {
                return StopNeverOperator.getInstance();
            }
            case "SEP": {
                return new StopSepOperator(this.getAbstractDomain());
            }
        }
        throw new AssertionError((Object)"unknown stoptype for SMGCPA");
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        SMGState initState = SMGState.of(this.machineModel, this.logger, this.options, this.cfa);
        return initState;
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return this.precision;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return new SMGPrecisionAdjustment(this.statistics, this.cfa, this.precisionAdjustmentOptions, this.precisionAdjustmentStatistics);
    }

    public LogManager getLogger() {
        return this.logger;
    }

    public void injectRefinablePrecision() {
        if (this.initialPrecisionFile == null && this.initialPredicatePrecisionFile == null && !this.refineablePrecisionSet) {
            this.precision = new SMGPrecision(this.precision);
            this.refineablePrecisionSet = true;
        }
    }

    private VariableTrackingPrecision initializePrecision(Configuration pConfig, CFA pCfa) throws InvalidConfigurationException {
        if (this.initialPrecisionFile == null && this.initialPredicatePrecisionFile == null) {
            return VariableTrackingPrecision.createStaticPrecision(pConfig, pCfa.getVarClassification(), this.getClass());
        }
        VariableTrackingPrecision initialPrecision = new SMGPrecision(VariableTrackingPrecision.createStaticPrecision(pConfig, pCfa.getVarClassification(), this.getClass()));
        if (this.initialPredicatePrecisionFile != null) {
            initialPrecision = ((VariableTrackingPrecision)initialPrecision).withIncrement(this.predToValPrec.convertPredPrecToVariableTrackingPrec(this.initialPredicatePrecisionFile));
        }
        if (this.initialPrecisionFile != null) {
            initialPrecision = ((VariableTrackingPrecision)initialPrecision).withIncrement(this.restoreMappingFromFile(pCfa));
        }
        return initialPrecision;
    }

    private Multimap<CFANode, MemoryLocation> restoreMappingFromFile(CFA pCfa) {
        HashMultimap mapping = HashMultimap.create();
        List<String> contents = null;
        try {
            contents = Files.readAllLines(this.initialPrecisionFile, Charset.defaultCharset());
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not read precision from file named " + this.initialPrecisionFile);
            return mapping;
        }
        Map<Integer, CFANode> idToCfaNode = CFAUtils.getMappingFromNodeIDsToCFANodes(pCfa);
        CFANode location = this.getDefaultLocation(idToCfaNode);
        for (String currentLine : contents) {
            if (currentLine.trim().isEmpty()) continue;
            if (currentLine.endsWith(":")) {
                String scopeSelectors = currentLine.substring(0, currentLine.indexOf(":"));
                Matcher matcher = CFAUtils.CFA_NODE_NAME_PATTERN.matcher(scopeSelectors);
                if (!matcher.matches()) continue;
                location = idToCfaNode.get(Integer.parseInt(matcher.group(1)));
                continue;
            }
            mapping.put((Object)location, (Object)MemoryLocation.parseExtendedQualifiedName(currentLine));
        }
        return mapping;
    }

    private CFANode getDefaultLocation(Map<Integer, CFANode> idToCfaNode) {
        return idToCfaNode.values().iterator().next();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public CFA getCFA() {
        return this.cfa;
    }

    public ShutdownNotifier getShutdownNotifier() {
        return this.shutdownNotifier;
    }
}

