/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPAValueVisitor;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMG2Exception;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGObjectAndOffset;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGStateAndOptionalSMGObjectAndOffset;
import org.sosy_lab.cpachecker.cpa.smg2.util.value.SMGCPAExpressionEvaluator;
import org.sosy_lab.cpachecker.cpa.smg2.util.value.ValueAndSMGState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.AddressExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicIdentifier;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class SMGCPAAddressVisitor
extends DefaultCExpressionVisitor<List<SMGStateAndOptionalSMGObjectAndOffset>, CPATransferException>
implements CRightHandSideVisitor<List<SMGStateAndOptionalSMGObjectAndOffset>, CPATransferException> {
    private final SMGCPAExpressionEvaluator evaluator;
    private final SMGState state;
    private final LogManagerWithoutDuplicates logger;
    private final CFAEdge cfaEdge;

    public SMGCPAAddressVisitor(SMGCPAExpressionEvaluator pEvaluator, SMGState currentState, CFAEdge edge, LogManagerWithoutDuplicates pLogger) {
        this.evaluator = pEvaluator;
        this.state = currentState;
        this.cfaEdge = edge;
        this.logger = pLogger;
    }

    @Override
    public List<SMGStateAndOptionalSMGObjectAndOffset> visit(CFunctionCallExpression pIastFunctionCallExpression) throws CPATransferException {
        return ImmutableList.of((Object)SMGStateAndOptionalSMGObjectAndOffset.of(this.state));
    }

    @Override
    protected List<SMGStateAndOptionalSMGObjectAndOffset> visitDefault(CExpression pExp) throws CPATransferException {
        this.logger.logf(Level.INFO, "%s, Default value: CExpression %s could not find a address for %s. Related CFAEdge: %s", new Object[]{this.cfaEdge.getFileLocation(), pExp, this.state, this.cfaEdge.getRawStatement()});
        return ImmutableList.of((Object)SMGStateAndOptionalSMGObjectAndOffset.of(this.state));
    }

    @Override
    public List<SMGStateAndOptionalSMGObjectAndOffset> visit(CArraySubscriptExpression e) throws CPATransferException {
        CExpression arrayExpr = e.getArrayExpression();
        CExpression subscriptExpr = e.getSubscriptExpression();
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (ValueAndSMGState arrayValueAndState : arrayExpr.accept(new SMGCPAValueVisitor(this.evaluator, this.state, this.cfaEdge, this.logger))) {
            Value arrayValue = arrayValueAndState.getValue();
            SMGState currentState = arrayValueAndState.getState();
            if (arrayValue.isUnknown()) {
                resultBuilder.add((Object)SMGStateAndOptionalSMGObjectAndOffset.of(currentState));
                continue;
            }
            for (ValueAndSMGState subscriptValueAndState : subscriptExpr.accept(new SMGCPAValueVisitor(this.evaluator, currentState, this.cfaEdge, this.logger))) {
                Value subscriptValue = subscriptValueAndState.getValue();
                currentState = subscriptValueAndState.getState();
                if (!subscriptValue.isNumericValue()) {
                    this.logger.log(Level.FINE, new Object[]{"A subscript value was found to be non concrete when trying to find a memory location of an array. No memory region could be returned."});
                    resultBuilder.add((Object)SMGStateAndOptionalSMGObjectAndOffset.of(currentState.withUnknownOffsetMemoryAccess()));
                    continue;
                }
                BigInteger typeSizeInBits = this.evaluator.getBitSizeof(currentState, e.getExpressionType());
                BigInteger subscriptOffset = typeSizeInBits.multiply(subscriptValue.asNumericValue().bigInteger());
                resultBuilder.add((Object)this.handleSubscriptExpression(arrayValue, subscriptOffset, currentState));
            }
        }
        return resultBuilder.build();
    }

    private SMGStateAndOptionalSMGObjectAndOffset handleSubscriptExpression(Value arrayValue, BigInteger subscriptOffset, SMGState pCurrentState) throws SMG2Exception {
        if (arrayValue instanceof AddressExpression) {
            AddressExpression arrayAddr = (AddressExpression)arrayValue;
            Value addrOffset = arrayAddr.getOffset();
            if (!addrOffset.isNumericValue()) {
                this.logger.log(Level.FINE, new Object[]{"A offset value was found to be non concrete when trying to find a memory location in an array. No memory region could be returned."});
                return SMGStateAndOptionalSMGObjectAndOffset.of(pCurrentState.withUnknownOffsetMemoryAccess());
            }
            BigInteger baseOffset = addrOffset.asNumericValue().bigInteger();
            BigInteger finalOffset = baseOffset.add(subscriptOffset);
            List<SMGStateAndOptionalSMGObjectAndOffset> targets = this.evaluator.getTargetObjectAndOffset(pCurrentState, arrayAddr.getMemoryAddress(), finalOffset);
            Preconditions.checkArgument((targets.size() == 1 ? 1 : 0) != 0);
            return targets.get(0);
        }
        if (pCurrentState.getMemoryModel().isPointer(arrayValue)) {
            List<SMGStateAndOptionalSMGObjectAndOffset> maybeTargetMemoriesAndOffsets = pCurrentState.dereferencePointer(arrayValue);
            Preconditions.checkArgument((maybeTargetMemoriesAndOffsets.size() == 1 ? 1 : 0) != 0);
            SMGStateAndOptionalSMGObjectAndOffset maybeTargetMemoryAndOffset = maybeTargetMemoriesAndOffsets.get(0);
            if (!maybeTargetMemoryAndOffset.hasSMGObjectAndOffset()) {
                return maybeTargetMemoryAndOffset;
            }
            BigInteger baseOffset = maybeTargetMemoryAndOffset.getOffsetForObject();
            BigInteger finalOffset = baseOffset.add(subscriptOffset);
            return SMGStateAndOptionalSMGObjectAndOffset.of(maybeTargetMemoryAndOffset.getSMGObject(), finalOffset, pCurrentState);
        }
        if (arrayValue.isNumericValue() && arrayValue.asNumericValue().bigInteger().compareTo(BigInteger.ZERO) == 0) {
            return SMGStateAndOptionalSMGObjectAndOffset.of(SMGObject.nullInstance(), subscriptOffset, pCurrentState);
        }
        return SMGStateAndOptionalSMGObjectAndOffset.of(pCurrentState);
    }

    @Override
    public List<SMGStateAndOptionalSMGObjectAndOffset> visit(CCastExpression e) throws CPATransferException {
        return e.getOperand().accept(this);
    }

    @Override
    public List<SMGStateAndOptionalSMGObjectAndOffset> visit(CFieldReference e) throws CPATransferException {
        CFieldReference explicitReference = e.withExplicitPointerDereference();
        CExpression ownerExpression = explicitReference.getFieldOwner();
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (ValueAndSMGState structValuesAndState : ownerExpression.accept(new SMGCPAValueVisitor(this.evaluator, this.state, this.cfaEdge, this.logger))) {
            BigInteger finalFieldOffset;
            BigInteger baseOffset;
            Value structValue = structValuesAndState.getValue();
            SMGState currentState = structValuesAndState.getState();
            if (structValue.isUnknown()) {
                resultBuilder.add((Object)SMGStateAndOptionalSMGObjectAndOffset.of(currentState));
                continue;
            }
            BigInteger fieldOffset = this.evaluator.getFieldOffsetInBits(SMGCPAExpressionEvaluator.getCanonicalType(ownerExpression), explicitReference.getFieldName());
            if (structValue instanceof AddressExpression) {
                AddressExpression structAddr = (AddressExpression)structValue;
                Value addrOffset = structAddr.getOffset();
                if (!addrOffset.isNumericValue()) {
                    resultBuilder.add((Object)SMGStateAndOptionalSMGObjectAndOffset.of(currentState));
                }
                baseOffset = addrOffset.asNumericValue().bigInteger();
                finalFieldOffset = baseOffset.add(fieldOffset);
                resultBuilder.addAll(this.evaluator.getTargetObjectAndOffset(currentState, structAddr.getMemoryAddress(), finalFieldOffset));
                continue;
            }
            if (structValue instanceof SymbolicIdentifier && ((SymbolicIdentifier)structValue).getRepresentedLocation().isPresent()) {
                MemoryLocation variableAndOffset = ((SymbolicIdentifier)structValue).getRepresentedLocation().orElseThrow();
                String varName = variableAndOffset.getIdentifier();
                Optional<SMGObjectAndOffset> maybeTarget = this.evaluator.getTargetObjectAndOffset(currentState, varName, finalFieldOffset = (baseOffset = BigInteger.valueOf(variableAndOffset.getOffset())).add(fieldOffset));
                if (maybeTarget.isPresent()) {
                    resultBuilder.add((Object)SMGStateAndOptionalSMGObjectAndOffset.of(maybeTarget.orElseThrow(), currentState));
                    continue;
                }
                resultBuilder.add((Object)SMGStateAndOptionalSMGObjectAndOffset.of(currentState));
                continue;
            }
            if (structValue.isNumericValue() && structValue.asNumericValue().bigInteger().compareTo(BigInteger.ZERO) == 0) {
                resultBuilder.add((Object)SMGStateAndOptionalSMGObjectAndOffset.of(SMGObject.nullInstance(), fieldOffset, currentState));
                continue;
            }
            resultBuilder.add((Object)SMGStateAndOptionalSMGObjectAndOffset.of(currentState));
        }
        return resultBuilder.build();
    }

    @Override
    public List<SMGStateAndOptionalSMGObjectAndOffset> visit(CIdExpression e) throws CPATransferException {
        CSimpleDeclaration varDecl = e.getDeclaration();
        if (varDecl == null) {
            throw new SMG2Exception("Usage of undeclared variable: " + e.getName() + ".");
        }
        Optional<SMGObjectAndOffset> maybeTarget = this.evaluator.getTargetObjectAndOffset(this.state, varDecl.getQualifiedName());
        if (maybeTarget.isPresent()) {
            return ImmutableList.of((Object)SMGStateAndOptionalSMGObjectAndOffset.of(maybeTarget.orElseThrow().getSMGObject(), maybeTarget.orElseThrow().getOffsetForObject(), this.state));
        }
        return ImmutableList.of((Object)SMGStateAndOptionalSMGObjectAndOffset.of(this.state));
    }

    @Override
    public List<SMGStateAndOptionalSMGObjectAndOffset> visit(CPointerExpression e) throws CPATransferException {
        CType type = SMGCPAExpressionEvaluator.getCanonicalType(e.getExpressionType());
        CExpression expr = e.getOperand();
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (ValueAndSMGState evaluatedSubExpr : expr.accept(new SMGCPAValueVisitor(this.evaluator, this.state, this.cfaEdge, this.logger))) {
            SMGState currentState = evaluatedSubExpr.getState();
            Value value = evaluatedSubExpr.getValue();
            if (!(value instanceof AddressExpression)) {
                resultBuilder.add((Object)SMGStateAndOptionalSMGObjectAndOffset.of(currentState));
                continue;
            }
            AddressExpression pointerValue = (AddressExpression)value;
            Value offset = pointerValue.getOffset();
            if (!offset.isNumericValue()) {
                resultBuilder.add((Object)SMGStateAndOptionalSMGObjectAndOffset.of(currentState));
                continue;
            }
            if (type instanceof CFunctionType) {
                this.logger.log(Level.FINE, new Object[]{"Currently there is no function pointer implementation. No memory region could be returned."});
                resultBuilder.addAll((Iterable)this.visitDefault(e));
                continue;
            }
            BigInteger offsetInBits = offset.asNumericValue().bigInteger();
            resultBuilder.addAll(this.evaluator.getTargetObjectAndOffset(currentState, pointerValue.getMemoryAddress(), offsetInBits));
        }
        return resultBuilder.build();
    }
}

