/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPAAddressVisitor;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPAValueVisitor;
import org.sosy_lab.cpachecker.cpa.smg2.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMG2Exception;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGStateAndOptionalSMGObjectAndOffset;
import org.sosy_lab.cpachecker.cpa.smg2.util.value.SMGCPAExpressionEvaluator;
import org.sosy_lab.cpachecker.cpa.smg2.util.value.ValueAndSMGState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.AddressExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicIdentifier;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class SMGCPAAssigningValueVisitor
extends SMGCPAValueVisitor {
    private final SMGOptions options;
    private final boolean truthValue;
    private final Collection<String> booleans;

    public SMGCPAAssigningValueVisitor(SMGCPAExpressionEvaluator pEvaluator, SMGState currentState, CFAEdge edge, LogManagerWithoutDuplicates pLogger, boolean pTruthValue, SMGOptions pOptions, Collection<String> booleanVariables) {
        super(pEvaluator, currentState, edge, pLogger);
        this.booleans = booleanVariables;
        this.truthValue = pTruthValue;
        this.options = pOptions;
    }

    @Override
    public List<ValueAndSMGState> visit(CBinaryExpression pE) throws CPATransferException {
        CBinaryExpression.BinaryOperator binaryOperator = pE.getOperator();
        CExpression lVarInBinaryExp = pE.getOperand1();
        CExpression rVarInBinaryExp = pE.getOperand2();
        SMGCPAExpressionEvaluator evaluator = super.getInitialVisitorEvaluator();
        LogManagerWithoutDuplicates logger = super.getInitialVisitorLogger();
        CFAEdge edge = super.getInitialVisitorCFAEdge();
        SMGState initialState = super.getInitialVisitorState();
        ImmutableList.Builder finalValueAndStateBuilder = ImmutableList.builder();
        for (ValueAndSMGState leftValueAndState : lVarInBinaryExp.accept(new SMGCPAValueVisitor(evaluator, initialState, edge, logger))) {
            Value leftValue = leftValueAndState.getValue();
            for (ValueAndSMGState rightValueAndState : rVarInBinaryExp.accept(new SMGCPAValueVisitor(evaluator, leftValueAndState.getState(), edge, logger))) {
                Value rightValue = rightValueAndState.getValue();
                SMGState currentState = rightValueAndState.getState();
                if (this.isEqualityAssumption(binaryOperator)) {
                    currentState = this.handleEqualityAssumption(lVarInBinaryExp, leftValue, rVarInBinaryExp, rightValue, currentState);
                }
                if (this.isNonEqualityAssumption(binaryOperator)) {
                    currentState = this.handleInEqualityAssumption(lVarInBinaryExp, leftValue, rVarInBinaryExp, rightValue, currentState);
                }
                finalValueAndStateBuilder.addAll((Iterable)pE.accept(new SMGCPAValueVisitor(evaluator, currentState, edge, logger)));
            }
        }
        return finalValueAndStateBuilder.build();
    }

    private SMGState handleEqualityAssumption(CExpression lVarInBinaryExp, Value leftValue, CExpression rVarInBinaryExp, Value rightValue, SMGState currentState) throws CPATransferException {
        SMGCPAExpressionEvaluator evaluator = super.getInitialVisitorEvaluator();
        SMGState initialState = super.getInitialVisitorState();
        for (ValueAndSMGState uselessValueAndUpdatedState : this.updateNested(lVarInBinaryExp, leftValue, rVarInBinaryExp, rightValue, currentState)) {
            currentState = uselessValueAndUpdatedState.getState();
            if (!this.isEligibleForAssignment(leftValue) || !rightValue.isExplicitlyKnown() || evaluator.isPointerValue(leftValue, currentState)) continue;
            List<SMGStateAndOptionalSMGObjectAndOffset> leftHandSideAssignments = this.getAssignable(lVarInBinaryExp, currentState);
            Preconditions.checkArgument((leftHandSideAssignments.size() == 1 ? 1 : 0) != 0);
            SMGStateAndOptionalSMGObjectAndOffset leftHandSideAssignment = leftHandSideAssignments.get(0);
            currentState = leftHandSideAssignment.getSMGState();
            if (this.isAssignable(leftHandSideAssignments)) {
                CType type = SMGCPAExpressionEvaluator.getCanonicalType(rVarInBinaryExp);
                BigInteger size = evaluator.getBitSizeof(currentState, type);
                currentState = currentState.writeValueTo(leftHandSideAssignment.getSMGObject(), leftHandSideAssignment.getOffsetForObject(), size, rightValue, type);
                continue;
            }
            if (!this.isEligibleForAssignment(rightValue) || !leftValue.isExplicitlyKnown() || evaluator.isPointerValue(rightValue, currentState)) continue;
            List<SMGStateAndOptionalSMGObjectAndOffset> rightHandSideAssignments = this.getAssignable(rVarInBinaryExp, initialState);
            Preconditions.checkArgument((rightHandSideAssignments.size() == 1 ? 1 : 0) != 0);
            SMGStateAndOptionalSMGObjectAndOffset rightHandSideAssignment = rightHandSideAssignments.get(0);
            currentState = rightHandSideAssignment.getSMGState();
            if (!this.isAssignable(rightHandSideAssignments)) continue;
            CType type = SMGCPAExpressionEvaluator.getCanonicalType(lVarInBinaryExp);
            BigInteger size = evaluator.getBitSizeof(currentState, type);
            currentState = currentState.writeValueTo(rightHandSideAssignment.getSMGObject(), rightHandSideAssignment.getOffsetForObject(), size, leftValue, type);
        }
        return currentState;
    }

    private SMGState handleInEqualityAssumption(CExpression lVarInBinaryExp, Value leftValue, CExpression rVarInBinaryExp, Value rightValue, SMGState currentState) throws CPATransferException {
        BigInteger size;
        CType type;
        SMGCPAExpressionEvaluator evaluator = super.getInitialVisitorEvaluator();
        SMGState initialState = super.getInitialVisitorState();
        if (SMGCPAAssigningValueVisitor.assumingUnknownToBeZero(leftValue, rightValue)) {
            if (!this.isNestingHandleable((CExpression)SMGCPAAssigningValueVisitor.unwrap(lVarInBinaryExp))) {
                return currentState;
            }
            List<SMGStateAndOptionalSMGObjectAndOffset> leftHandSideAssignments = this.getAssignable(lVarInBinaryExp, currentState);
            Preconditions.checkArgument((leftHandSideAssignments.size() == 1 ? 1 : 0) != 0);
            SMGStateAndOptionalSMGObjectAndOffset leftHandSideAssignment = leftHandSideAssignments.get(0);
            currentState = leftHandSideAssignment.getSMGState();
            if (this.isAssignable(leftHandSideAssignments)) {
                String leftMemLocName = this.getExtendedQualifiedName((CExpression)SMGCPAAssigningValueVisitor.unwrap(lVarInBinaryExp));
                if (this.options.isOptimizeBooleanVariables() && (this.booleans.contains(leftMemLocName) || this.options.isInitAssumptionVars())) {
                    type = SMGCPAExpressionEvaluator.getCanonicalType(rVarInBinaryExp);
                    size = evaluator.getBitSizeof(currentState, type);
                    currentState = currentState.writeValueTo(leftHandSideAssignment.getSMGObject(), leftHandSideAssignment.getOffsetForObject(), size, (Value)new NumericValue(1L), type);
                }
            }
        }
        if (this.options.isOptimizeBooleanVariables() && SMGCPAAssigningValueVisitor.assumingUnknownToBeZero(rightValue, leftValue)) {
            if (!this.isNestingHandleable((CExpression)SMGCPAAssigningValueVisitor.unwrap(rVarInBinaryExp))) {
                return currentState;
            }
            String rightMemLocName = this.getExtendedQualifiedName((CExpression)SMGCPAAssigningValueVisitor.unwrap(rVarInBinaryExp));
            if (this.booleans.contains(rightMemLocName) || this.options.isInitAssumptionVars()) {
                List<SMGStateAndOptionalSMGObjectAndOffset> rightHandSideAssignments = this.getAssignable(rVarInBinaryExp, initialState);
                Preconditions.checkArgument((rightHandSideAssignments.size() == 1 ? 1 : 0) != 0);
                SMGStateAndOptionalSMGObjectAndOffset rightHandSideAssignment = rightHandSideAssignments.get(0);
                currentState = rightHandSideAssignment.getSMGState();
                if (this.isAssignable(rightHandSideAssignments)) {
                    type = SMGCPAExpressionEvaluator.getCanonicalType(lVarInBinaryExp);
                    size = evaluator.getBitSizeof(currentState, type);
                    currentState = currentState.writeValueTo(rightHandSideAssignment.getSMGObject(), rightHandSideAssignment.getOffsetForObject(), size, (Value)new NumericValue(1L), type);
                }
            }
        }
        return currentState;
    }

    private List<ValueAndSMGState> updateNested(CExpression lVarInBinaryExp, Value leftValue, CExpression rVarInBinaryExp, Value rightValue, SMGState currentState) throws CPATransferException {
        BigInteger rNum;
        SMGCPAExpressionEvaluator evaluator = super.getInitialVisitorEvaluator();
        LogManagerWithoutDuplicates logger = super.getInitialVisitorLogger();
        CFAEdge edge = super.getInitialVisitorCFAEdge();
        Object updatedStates = ImmutableList.of((Object)ValueAndSMGState.ofUnknownValue(currentState));
        if (leftValue.isExplicitlyKnown()) {
            Number lNum = leftValue.asNumericValue().getNumber();
            if (BigInteger.ONE.equals(lNum)) {
                updatedStates = rVarInBinaryExp.accept(new SMGCPAAssigningValueVisitor(evaluator, currentState, edge, logger, this.truthValue, this.options, this.booleans));
            }
        } else if (rightValue.isExplicitlyKnown() && BigInteger.ONE.equals(rNum = rightValue.asNumericValue().bigInteger())) {
            updatedStates = lVarInBinaryExp.accept(new SMGCPAAssigningValueVisitor(evaluator, currentState, edge, logger, this.truthValue, this.options, this.booleans));
        }
        return updatedStates;
    }

    private static AExpression unwrap(AExpression expression) {
        while (expression instanceof CCastExpression) {
            expression = ((CCastExpression)expression).getOperand();
        }
        return expression;
    }

    private boolean isEqualityAssumption(CBinaryExpression.BinaryOperator binaryOperator) {
        return binaryOperator == CBinaryExpression.BinaryOperator.EQUALS && this.truthValue || binaryOperator == CBinaryExpression.BinaryOperator.NOT_EQUALS && !this.truthValue;
    }

    private boolean isNonEqualityAssumption(CBinaryExpression.BinaryOperator binaryOperator) {
        return binaryOperator == CBinaryExpression.BinaryOperator.EQUALS && !this.truthValue || binaryOperator == CBinaryExpression.BinaryOperator.NOT_EQUALS && this.truthValue;
    }

    private List<SMGStateAndOptionalSMGObjectAndOffset> getAssignable(CExpression expression, SMGState currentState) throws CPATransferException {
        if (expression instanceof CFieldReference || expression instanceof CArraySubscriptExpression || expression instanceof CIdExpression || expression instanceof CPointerExpression) {
            SMGCPAAddressVisitor av = new SMGCPAAddressVisitor(super.getInitialVisitorEvaluator(), currentState, super.getInitialVisitorCFAEdge(), super.getInitialVisitorLogger());
            return expression.accept(av);
        }
        return ImmutableList.of((Object)SMGStateAndOptionalSMGObjectAndOffset.of(currentState));
    }

    private boolean isAssignable(List<SMGStateAndOptionalSMGObjectAndOffset> possibleAssignables) {
        for (SMGStateAndOptionalSMGObjectAndOffset possibleAssignable : possibleAssignables) {
            if (possibleAssignable.hasSMGObjectAndOffset()) continue;
            return false;
        }
        return true;
    }

    private boolean isEligibleForAssignment(Value pValue) {
        return !pValue.isExplicitlyKnown() && this.options.isAssignEqualityAssumptions() && !(pValue instanceof AddressExpression) && (!(pValue instanceof SymbolicIdentifier) || !((SymbolicIdentifier)pValue).getRepresentedLocation().isPresent());
    }

    private static boolean assumingUnknownToBeZero(Value value1, Value value2) {
        return value1.isUnknown() && value2.equals(new NumericValue(BigInteger.ZERO));
    }

    private String getExtendedQualifiedName(CExpression expr) throws SMG2Exception {
        if (expr instanceof CIdExpression) {
            return ((CIdExpression)expr).getName();
        }
        if (expr instanceof CArraySubscriptExpression) {
            return expr.toQualifiedASTString();
        }
        if (expr instanceof CFieldReference) {
            return ((CFieldReference)expr).getFieldOwner().toQualifiedASTString() + ((CFieldReference)expr).getFieldName();
        }
        if (expr instanceof CPointerExpression) {
            return expr.toQualifiedASTString();
        }
        throw new SMG2Exception("Internal error when getting the qualified name of a CExpression.");
    }

    private boolean isNestingHandleable(CExpression expr) {
        if (expr instanceof CBinaryExpression) {
            return this.isNestingHandleable(((CBinaryExpression)expr).getOperand1()) && this.isNestingHandleable(((CBinaryExpression)expr).getOperand2());
        }
        return expr instanceof CIdExpression || expr instanceof CArraySubscriptExpression || expr instanceof CFieldReference || expr instanceof CPointerExpression;
    }
}

