/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPAAddressVisitor;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPAExportOptions;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPAValueVisitor;
import org.sosy_lab.cpachecker.cpa.smg2.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.StackFrame;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMG2Exception;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGStateAndOptionalSMGObjectAndOffset;
import org.sosy_lab.cpachecker.cpa.smg2.util.value.SMGCPAExpressionEvaluator;
import org.sosy_lab.cpachecker.cpa.smg2.util.value.ValueAndSMGState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.AddressExpression;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;

public class SMGCPABuiltins {
    private static final UniqueIdGenerator U_ID_GENERATOR = new UniqueIdGenerator();
    private final SMGCPAExpressionEvaluator evaluator;
    private final MachineModel machineModel;
    private final LogManagerWithoutDuplicates logger;
    private final SMGCPAExportOptions exportSMGOptions;
    private final SMGOptions options;
    private static final int MEMSET_BUFFER_PARAMETER = 0;
    private static final int MEMSET_CHAR_PARAMETER = 1;
    private static final int MEMSET_COUNT_PARAMETER = 2;
    private static final int MEMCPY_TARGET_PARAMETER = 0;
    private static final int MEMCPY_SOURCE_PARAMETER = 1;
    private static final int MEMCPY_SIZE_PARAMETER = 2;
    private static final int MALLOC_PARAMETER = 0;
    private static final int STRCMP_FIRST_PARAMETER = 0;
    private static final int STRCMP_SECOND_PARAMETER = 1;
    private final Set<String> BUILTINS = Sets.newHashSet((Object[])new String[]{"__VERIFIER_BUILTIN_PLOT", "memcpy", "memset", "__builtin_alloca", "alloca", "printf", "strcmp", "realloc", "__builtin_va_start", "__builtin_va_arg", "__builtin_va_end", "__builtin_va_copy"});
    private static final String NONDET_PREFIX = "__VERIFIER_nondet_";

    public SMGCPABuiltins(SMGCPAExpressionEvaluator pExpressionEvaluator, SMGOptions pOptions, SMGCPAExportOptions pExportSMGOptions, MachineModel pMachineModel, LogManagerWithoutDuplicates pLogger) {
        this.evaluator = pExpressionEvaluator;
        this.machineModel = pMachineModel;
        this.logger = pLogger;
        this.exportSMGOptions = pExportSMGOptions;
        this.options = pOptions;
    }

    boolean isABuiltIn(String functionName) {
        return this.BUILTINS.contains(functionName) || this.isNondetBuiltin(functionName) || this.isConfigurableAllocationFunction(functionName) || this.isDeallocationFunction(functionName) || this.isExternalAllocationFunction(functionName);
    }

    private boolean isNondetBuiltin(String pFunctionName) {
        return pFunctionName.startsWith(NONDET_PREFIX) || pFunctionName.equals("nondet_int");
    }

    public boolean isConfigurableAllocationFunction(String functionName) {
        return this.options.getMemoryAllocationFunctions().contains((Object)functionName) || this.options.getArrayAllocationFunctions().contains((Object)functionName);
    }

    public boolean isDeallocationFunction(String functionName) {
        return this.options.getDeallocationFunctions().contains((Object)functionName);
    }

    private boolean isExternalAllocationFunction(String functionName) {
        return this.options.getExternalAllocationFunction().contains((Object)functionName);
    }

    public List<ValueAndSMGState> handleFunctioncall(CFunctionCallExpression pFunctionCall, String functionName, SMGState pSmgState, CFAEdge pCfaEdge) throws CPATransferException {
        if (this.isABuiltIn(functionName)) {
            if (this.isConfigurableAllocationFunction(functionName)) {
                return this.evaluateConfigurableAllocationFunction(pFunctionCall, pSmgState, pCfaEdge);
            }
            return this.handleBuiltinFunctionCall(pCfaEdge, pFunctionCall, functionName, pSmgState);
        }
        return this.handleUnknownFunction(pCfaEdge, pFunctionCall, functionName, pSmgState);
    }

    public List<ValueAndSMGState> handleBuiltinFunctionCall(CFAEdge pCfaEdge, CFunctionCallExpression cFCExpression, String calledFunctionName, SMGState pState) throws CPATransferException {
        if (this.isExternalAllocationFunction(calledFunctionName)) {
            return this.evaluateExternalAllocation(cFCExpression, pState);
        }
        switch (calledFunctionName) {
            case "alloca": 
            case "__builtin_alloca": {
                return this.evaluateAlloca(cFCExpression, pState, pCfaEdge);
            }
            case "memset": {
                return this.evaluateMemset(cFCExpression, pState, pCfaEdge);
            }
            case "memcpy": {
                return this.evaluateMemcpy(cFCExpression, pState, pCfaEdge);
            }
            case "strcmp": {
                return this.evaluateStrcmp(cFCExpression, pState, pCfaEdge);
            }
            case "__VERIFIER_BUILTIN_PLOT": {
                this.evaluateVBPlot(cFCExpression, pState);
            }
            case "printf": {
                List<SMGState> checkedStates = this.checkAllParametersForValidity(pState, pCfaEdge, cFCExpression);
                return Collections3.transformedImmutableListCopy(checkedStates, state -> ValueAndSMGState.ofUnknownValue(state));
            }
            case "realloc": {
                return this.evaluateRealloc();
            }
            case "__builtin_va_start": {
                return this.evaluateVaStart(cFCExpression, pCfaEdge, pState);
            }
            case "__builtin_va_arg": {
                return this.evaluateVaArg(cFCExpression, pCfaEdge, pState);
            }
            case "__builtin_va_copy": {
                return this.evaluateVaCopy(cFCExpression, pCfaEdge, pState);
            }
            case "__builtin_va_end": {
                return this.evaluateVaEnd(cFCExpression, pCfaEdge, pState);
            }
        }
        if (this.isNondetBuiltin(calledFunctionName)) {
            return Collections.singletonList(ValueAndSMGState.ofUnknownValue(pState));
        }
        throw new UnsupportedOperationException("Unexpected function handled as a builtin: " + calledFunctionName);
    }

    private List<ValueAndSMGState> evaluateVaEnd(CFunctionCallExpression cFCExpression, CFAEdge pCfaEdge, SMGState pState) {
        Preconditions.checkArgument((cFCExpression.getParameterExpressions().size() == 1 ? 1 : 0) != 0);
        CIdExpression firstIdArg = (CIdExpression)this.evaluateCFunctionCallToFirstParameterForVA(cFCExpression);
        SMGState currentState = pState.copyAndPruneFunctionStackVariable(firstIdArg.getDeclaration().getQualifiedName());
        return ImmutableList.of((Object)ValueAndSMGState.ofUnknownValue(currentState));
    }

    private CExpression evaluateCFunctionCallToFirstParameterForVA(CFunctionCallExpression cFCExpression) {
        CExpression firstArg = cFCExpression.getParameterExpressions().get(0);
        while (firstArg instanceof CCastExpression) {
            firstArg = ((CCastExpression)firstArg).getOperand();
        }
        if (firstArg instanceof CUnaryExpression) {
            firstArg = ((CUnaryExpression)firstArg).getOperand();
        }
        Preconditions.checkArgument((boolean)(firstArg instanceof CIdExpression));
        return firstArg;
    }

    private List<ValueAndSMGState> evaluateVaCopy(CFunctionCallExpression cFCExpression, CFAEdge pCfaEdge, SMGState pState) throws CPATransferException {
        Preconditions.checkArgument((cFCExpression.getParameterExpressions().size() == 2 ? 1 : 0) != 0);
        CExpression destArg = cFCExpression.getParameterExpressions().get(0);
        Preconditions.checkArgument((boolean)(destArg instanceof CIdExpression));
        CIdExpression destIdArg = (CIdExpression)destArg;
        CExpression srcArg = cFCExpression.getParameterExpressions().get(1);
        Preconditions.checkArgument((boolean)(srcArg instanceof CIdExpression));
        CIdExpression srcIdArg = (CIdExpression)srcArg;
        Preconditions.checkArgument((boolean)destIdArg.getExpressionType().equals(srcIdArg.getExpressionType()));
        BigInteger sizeInBits = this.evaluator.getBitSizeof(pState, srcIdArg);
        List<ValueAndSMGState> addressesAndStates = this.evaluator.readStackOrGlobalVariable(pState, srcIdArg.getName(), BigInteger.ZERO, sizeInBits, SMGCPAExpressionEvaluator.getCanonicalType(srcIdArg));
        Preconditions.checkArgument((addressesAndStates.size() == 1 ? 1 : 0) != 0);
        ValueAndSMGState addressAndState = addressesAndStates.get(0);
        SMGState currentState = addressAndState.getState();
        if (addressAndState.getValue().isUnknown()) {
            throw new SMG2Exception("Critical error in builtin function va_copy. The source does not reflect a valid value when read.");
        }
        currentState = currentState.writeToStackOrGlobalVariable(destIdArg.getDeclaration().getQualifiedName(), BigInteger.ZERO, sizeInBits, addressAndState.getValue(), destIdArg.getExpressionType());
        return ImmutableList.of((Object)ValueAndSMGState.ofUnknownValue(currentState));
    }

    private List<ValueAndSMGState> evaluateVaArg(CFunctionCallExpression cFCExpression, CFAEdge pCfaEdge, SMGState pState) throws SMG2Exception {
        throw new SMG2Exception("Feature va_arg() not finished because our parser does not like the function.");
    }

    private List<ValueAndSMGState> evaluateVaStart(CFunctionCallExpression cFCExpression, CFAEdge pCfaEdge, SMGState pState) throws CPATransferException {
        SMGState currentState = pState;
        Preconditions.checkArgument((cFCExpression.getParameterExpressions().size() == 2 ? 1 : 0) != 0);
        CExpression firstArg = this.evaluateCFunctionCallToFirstParameterForVA(cFCExpression);
        CExpression secondArg = cFCExpression.getParameterExpressions().get(1);
        StackFrame currentStack = pState.getMemoryModel().getStackFrames().peek();
        CParameterDeclaration paramDecl = currentStack.getFunctionDefinition().getParameters().get(currentStack.getFunctionDefinition().getParameters().size() - 1);
        if (!paramDecl.getType().equals(secondArg.getExpressionType())) {
            this.logger.logf(Level.INFO, "The types of variable arguments (%s) do not match the last not variable argument of the function (%s)", new Object[]{paramDecl.getType(), secondArg.getExpressionType()});
        }
        BigInteger sizeInBitsPointer = this.evaluator.getBitSizeof(pState, firstArg);
        BigInteger sizeInBitsVarArg = this.evaluator.getBitSizeof(pState, secondArg);
        BigInteger overallSizeOfVarArgs = BigInteger.valueOf(currentStack.getVariableArguments().size()).multiply(sizeInBitsVarArg);
        ValueAndSMGState pointerAndState = this.evaluator.createHeapMemoryAndPointer(currentState, overallSizeOfVarArgs);
        currentState = pointerAndState.getState();
        Value address = pointerAndState.getValue();
        List<SMGStateAndOptionalSMGObjectAndOffset> targets = firstArg.accept(new SMGCPAAddressVisitor(this.evaluator, currentState, pCfaEdge, this.logger));
        Preconditions.checkArgument((targets.size() == 1 ? 1 : 0) != 0);
        for (SMGStateAndOptionalSMGObjectAndOffset target : targets) {
            currentState = target.getSMGState();
            if (!target.hasSMGObjectAndOffset()) {
                return ImmutableList.of((Object)ValueAndSMGState.ofUnknownValue(currentState));
            }
            SMGObject targetObj = target.getSMGObject();
            BigInteger offset = target.getOffsetForObject();
            currentState = currentState.writeValueTo(targetObj, offset, sizeInBitsPointer, address, firstArg.getExpressionType());
        }
        BigInteger offset = BigInteger.ZERO;
        for (Value varArg : currentStack.getVariableArguments()) {
            List<SMGState> writtenStates = currentState.writeValueTo(address, offset, sizeInBitsVarArg, varArg, SMGCPAExpressionEvaluator.getCanonicalType(secondArg));
            Preconditions.checkArgument((writtenStates.size() == 1 ? 1 : 0) != 0);
            currentState = writtenStates.get(0);
            offset = offset.add(sizeInBitsVarArg);
        }
        return ImmutableList.of((Object)ValueAndSMGState.ofUnknownValue(currentState));
    }

    private List<SMGState> checkAllParametersForValidity(SMGState pState, CFAEdge pCfaEdge, CFunctionCallExpression cFCExpression) throws CPATransferException {
        SMGState currentState = pState;
        for (CExpression param : cFCExpression.getParameterExpressions()) {
            if (!(param instanceof CPointerExpression)) continue;
            SMGCPAValueVisitor valueVisitor = new SMGCPAValueVisitor(this.evaluator, currentState, pCfaEdge, this.logger);
            for (ValueAndSMGState valueAndState : param.accept(valueVisitor)) {
                currentState = valueAndState.getState();
            }
        }
        return ImmutableList.of((Object)currentState);
    }

    List<ValueAndSMGState> handleUnknownFunction(CFAEdge pCfaEdge, CFunctionCallExpression cFCExpression, String calledFunctionName, SMGState pState) throws CPATransferException {
        switch (this.options.getHandleUnknownFunctions()) {
            case STRICT: {
                if (!this.isSafeFunction(calledFunctionName)) {
                    throw new CPATransferException(String.format("Unknown function '%s' may be unsafe. See the cpa.smg2.SMGCPABuiltins.handleUnknownFunction()", calledFunctionName));
                }
            }
            case ASSUME_SAFE: {
                List<SMGState> checkedStates = this.checkAllParametersForValidity(pState, pCfaEdge, cFCExpression);
                return Collections3.transformedImmutableListCopy(checkedStates, state -> ValueAndSMGState.ofUnknownValue(state));
            }
            case ASSUME_EXTERNAL_ALLOCATED: {
                return Collections.singletonList(ValueAndSMGState.ofUnknownValue(pState));
            }
        }
        throw new UnsupportedOperationException("Unhandled function in cpa.smg2.SMGCPABuiltins.handleUnknownFunction(): " + this.options.getHandleUnknownFunctions());
    }

    private List<ValueAndSMGState> getAllocateFunctionSize(SMGState pState, CFAEdge cfaEdge, CFunctionCallExpression functionCall) throws CPATransferException {
        String functionName = functionCall.getFunctionNameExpression().toASTString();
        if (this.options.getArrayAllocationFunctions().contains((Object)functionName)) {
            if (functionCall.getParameterExpressions().size() != 2) {
                throw new UnrecognizedCodeException(functionName + " needs 2 arguments.", cfaEdge, functionCall);
            }
            ImmutableList.Builder resultBuilder = ImmutableList.builder();
            for (ValueAndSMGState value1AndState : this.getAllocateFunctionParameter(this.options.getMemoryArrayAllocationFunctionsNumParameter(), functionCall, pState, cfaEdge)) {
                Value value1 = value1AndState.getValue();
                SMGState state1 = value1AndState.getState();
                if (!value1.isNumericValue()) {
                    resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(state1));
                    continue;
                }
                for (ValueAndSMGState value2AndState : this.getAllocateFunctionParameter(this.options.getMemoryArrayAllocationFunctionsElemSizeParameter(), functionCall, state1, cfaEdge)) {
                    Value value2 = value2AndState.getValue();
                    SMGState state2 = value2AndState.getState();
                    if (!value2.isNumericValue()) {
                        resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(state2));
                        continue;
                    }
                    BigInteger size = value1.asNumericValue().bigInteger().multiply(value2.asNumericValue().bigInteger());
                    resultBuilder.add((Object)ValueAndSMGState.of(new NumericValue(size), state2));
                }
            }
            return resultBuilder.build();
        }
        if (functionCall.getParameterExpressions().size() != 1) {
            throw new UnrecognizedCodeException(functionName + " needs 1 arguments.", cfaEdge, functionCall);
        }
        return this.getAllocateFunctionParameter(this.options.getMemoryAllocationFunctionsSizeParameter(), functionCall, pState, cfaEdge);
    }

    private List<ValueAndSMGState> getAllocateFunctionParameter(int pParameterNumber, CFunctionCallExpression functionCall, SMGState pState, CFAEdge cfaEdge) throws CPATransferException {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (ValueAndSMGState sizeValueAndState : this.getFunctionParameterValue(pParameterNumber, functionCall, pState, cfaEdge)) {
            SMGState currentState = sizeValueAndState.getState();
            Value value = sizeValueAndState.getValue();
            if (value.isUnknown()) {
                if (!this.options.isGuessSizeOfUnknownMemorySize()) continue;
                NumericValue forcedValue = new NumericValue(this.options.getGuessSize());
                resultBuilder.add((Object)ValueAndSMGState.of(forcedValue, currentState));
                continue;
            }
            resultBuilder.add((Object)sizeValueAndState);
        }
        return resultBuilder.build();
    }

    private List<ValueAndSMGState> getFunctionParameterValue(int pParameterNumber, CFunctionCallExpression functionCall, SMGState pState, CFAEdge cfaEdge) throws CPATransferException {
        CRightHandSide expr;
        String functionName = functionCall.getFunctionNameExpression().toASTString();
        try {
            expr = functionCall.getParameterExpressions().get(pParameterNumber);
        }
        catch (IndexOutOfBoundsException e) {
            this.logger.logDebugException((Throwable)e);
            throw new UnrecognizedCodeException(functionName + " argument #" + pParameterNumber + " not found.", cfaEdge, functionCall);
        }
        SMGCPAValueVisitor vv = new SMGCPAValueVisitor(this.evaluator, pState, cfaEdge, this.logger);
        return vv.evaluate(expr, SMGCPAExpressionEvaluator.getCanonicalType(functionCall));
    }

    List<ValueAndSMGState> evaluateConfigurableAllocationFunction(CFunctionCallExpression functionCall, SMGState pState, CFAEdge cfaEdge) throws CPATransferException {
        String functionName = functionCall.getFunctionNameExpression().toASTString();
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (ValueAndSMGState sizeAndState : this.getAllocateFunctionSize(pState, cfaEdge, functionCall)) {
            Value sizeValue = sizeAndState.getValue();
            if (!sizeValue.isNumericValue()) {
                if (this.options.isGuessSizeOfUnknownMemorySize()) {
                    sizeValue = new NumericValue(this.options.getGuessSize());
                } else {
                    if (this.options.isIgnoreUnknownMemoryAllocation()) {
                        resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(sizeAndState.getState()));
                        continue;
                    }
                    throw new SMG2Exception("An allocation function was called with a symbolic size. This is not supported currently by the SMG2 analysis. Try GuessSizeOfUnknownMemorySize.");
                }
            }
            BigInteger sizeInBits = sizeValue.asNumericValue().bigInteger().multiply(BigInteger.valueOf(8L));
            SMGState currentState = sizeAndState.getState();
            if (sizeInBits.compareTo(BigInteger.ZERO) == 0) {
                NumericValue addressToZero = new NumericValue(0);
                resultBuilder.add((Object)ValueAndSMGState.of(addressToZero, currentState));
                continue;
            }
            ValueAndSMGState addressAndState = this.evaluator.createHeapMemoryAndPointer(currentState, sizeInBits);
            Value addressToNewRegion = addressAndState.getValue();
            SMGState stateWithNewHeap = addressAndState.getState();
            if (this.options.getZeroingMemoryAllocation().contains((Object)functionName)) {
                stateWithNewHeap = stateWithNewHeap.writeToZero(addressToNewRegion, functionCall.getExpressionType()).get(0);
            }
            resultBuilder.add((Object)ValueAndSMGState.of(addressToNewRegion, stateWithNewHeap));
            if (!this.options.isEnableMallocFailure()) continue;
            NumericValue addressToZero = new NumericValue(0);
            resultBuilder.add((Object)ValueAndSMGState.of(addressToZero, currentState));
        }
        return resultBuilder.build();
    }

    private boolean isSafeFunction(String calledFunctionName) {
        for (String safeUnknownFunctionPattern : this.options.getSafeUnknownFunctions()) {
            if (!Pattern.compile(safeUnknownFunctionPattern).matcher(calledFunctionName).matches()) continue;
            return true;
        }
        return false;
    }

    private void evaluateVBPlot(CFunctionCallExpression functionCall, SMGState currentState) {
        if (this.exportSMGOptions.hasExportPath()) {
            // empty if block
        }
    }

    private List<ValueAndSMGState> evaluateMemset(CFunctionCallExpression functionCall, SMGState pState, CFAEdge cfaEdge) throws CPATransferException {
        if (functionCall.getParameterExpressions().size() != 3) {
            throw new UnrecognizedCodeException(functionCall.getFunctionNameExpression().toASTString() + " needs 3 arguments.", cfaEdge, functionCall);
        }
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (ValueAndSMGState bufferAddressAndState : this.getFunctionParameterValue(0, functionCall, pState, cfaEdge)) {
            Value bufferValue = bufferAddressAndState.getValue();
            SMGState currentState = bufferAddressAndState.getState();
            if (!(bufferValue instanceof AddressExpression) || ((AddressExpression)bufferValue).getMemoryAddress().isUnknown() || !((AddressExpression)bufferValue).getOffset().isNumericValue()) {
                currentState = currentState.withInvalidWrite(bufferValue);
                resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(currentState));
                continue;
            }
            for (ValueAndSMGState charValueAndSMGState : this.getFunctionParameterValue(1, functionCall, currentState, cfaEdge)) {
                for (ValueAndSMGState countAndState : this.getFunctionParameterValue(2, functionCall, charValueAndSMGState.getState(), cfaEdge)) {
                    resultBuilder.add((Object)this.evaluateMemset(countAndState.getState(), cfaEdge, (AddressExpression)bufferValue, charValueAndSMGState.getValue(), countAndState.getValue()));
                }
            }
        }
        return resultBuilder.build();
    }

    private ValueAndSMGState evaluateMemset(SMGState currentState, CFAEdge cfaEdge, AddressExpression bufferAddressAndOffset, Value charValue, Value countValue) throws CPATransferException {
        if (countValue.isUnknown()) {
            currentState = currentState.withInvalidWrite("Invalid (Unknown) size (third argument) for memset() function call.", countValue);
            return ValueAndSMGState.ofUnknownValue(currentState);
        }
        if (!countValue.isNumericValue()) {
            currentState = currentState.withInvalidWrite("Symbolic count (second argument) for memset() function call not supported.", countValue);
            return ValueAndSMGState.ofUnknownValue(currentState);
        }
        long count = countValue.asNumericValue().longValue();
        Value bufferMemoryAddress = bufferAddressAndOffset.getMemoryAddress();
        BigInteger bufferOffsetInBits = bufferAddressAndOffset.getOffset().asNumericValue().bigInteger();
        BigInteger sizeOfCharInBits = BigInteger.valueOf(this.machineModel.getSizeofCharInBits());
        Preconditions.checkArgument((!currentState.getMemoryModel().pointsToZeroPlus(bufferMemoryAddress) ? 1 : 0) != 0);
        if (charValue.isNumericValue() && charValue.asNumericValue().bigInteger().equals(BigInteger.ZERO)) {
            currentState = currentState.writeValueTo(bufferMemoryAddress, bufferOffsetInBits, sizeOfCharInBits.multiply(BigInteger.valueOf(count)), charValue, (CType)CNumericTypes.CHAR).get(0);
        } else {
            int c = 0;
            while ((long)c < count) {
                currentState = currentState.writeValueTo(bufferMemoryAddress, bufferOffsetInBits.add(BigInteger.valueOf(c).multiply(sizeOfCharInBits)), sizeOfCharInBits, charValue, (CType)CNumericTypes.CHAR).get(0);
                ++c;
            }
        }
        if (bufferOffsetInBits.compareTo(BigInteger.ZERO) == 0) {
            return ValueAndSMGState.of(bufferMemoryAddress, currentState);
        }
        ValueAndSMGState newPointerAndState = this.evaluator.findOrcreateNewPointer(bufferMemoryAddress, bufferOffsetInBits, currentState).get(0);
        return ValueAndSMGState.of(newPointerAndState.getValue(), newPointerAndState.getState());
    }

    private List<ValueAndSMGState> evaluateExternalAllocation(CFunctionCallExpression pFunctionCall, SMGState pState) throws SMG2Exception {
        throw new SMG2Exception("evaluateExternalAllocation in SMGBUILTINS");
    }

    private List<ValueAndSMGState> evaluateAlloca(CFunctionCallExpression functionCall, SMGState pState, CFAEdge cfaEdge) throws CPATransferException {
        if (functionCall.getParameterExpressions().size() != 1) {
            throw new UnrecognizedCodeException(functionCall.getFunctionNameExpression().toASTString() + " needs 1 argument.", cfaEdge, functionCall);
        }
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (ValueAndSMGState argumentAndState : this.getAllocateFunctionParameter(0, functionCall, pState, cfaEdge)) {
            resultBuilder.addAll(this.evaluateAlloca(argumentAndState.getState(), argumentAndState.getValue(), SMGCPAExpressionEvaluator.getCanonicalType(functionCall.getExpressionType()), cfaEdge));
        }
        return resultBuilder.build();
    }

    private List<ValueAndSMGState> evaluateAlloca(SMGState pState, Value pSizeValue, CType type, CFAEdge cfaEdge) throws CPATransferException {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        SMGState currentState = pState;
        if (!pSizeValue.isNumericValue()) {
            resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(currentState));
        } else {
            String allocationLabel = "_ALLOCA_ID_" + U_ID_GENERATOR.getFreshId();
            ValueAndSMGState addressValueAndState = this.evaluator.createStackAllocation(allocationLabel, pSizeValue.asNumericValue().bigInteger(), type, pState);
            currentState = addressValueAndState.getState();
            resultBuilder.add((Object)ValueAndSMGState.of(addressValueAndState.getValue(), currentState));
        }
        return resultBuilder.build();
    }

    public final List<SMGState> evaluateFree(CFunctionCallExpression pFunctionCall, SMGState pState, CFAEdge cfaEdge) throws CPATransferException {
        if (pFunctionCall.getParameterExpressions().size() != 1) {
            throw new UnrecognizedCodeException("The function free() needs exactly 1 paramter", cfaEdge, pFunctionCall);
        }
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (ValueAndSMGState addressAndState : this.getFunctionParameterValue(0, pFunctionCall, pState, cfaEdge)) {
            Value maybeAddressValue = addressAndState.getValue();
            SMGState currentState = addressAndState.getState();
            resultBuilder.addAll(currentState.free(maybeAddressValue, pFunctionCall, cfaEdge));
        }
        return resultBuilder.build();
    }

    private List<ValueAndSMGState> evaluateMemcpy(CFunctionCallExpression functionCall, SMGState pState, CFAEdge cfaEdge) throws CPATransferException {
        if (functionCall.getParameterExpressions().size() != 3) {
            throw new UnrecognizedCodeException(functionCall.getFunctionNameExpression().toASTString() + " needs 3 arguments.", cfaEdge, functionCall);
        }
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (ValueAndSMGState destAndState : this.getFunctionParameterValue(0, functionCall, pState, cfaEdge)) {
            Value targetAddress = destAndState.getValue();
            if (!SMGCPAExpressionEvaluator.valueIsAddressExprOrVariableOffset(targetAddress)) {
                resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(destAndState.getState()));
                continue;
            }
            if (!(targetAddress instanceof AddressExpression)) {
                resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(destAndState.getState()));
                continue;
            }
            AddressExpression targetAddressExpr = (AddressExpression)targetAddress;
            if (!targetAddressExpr.getOffset().isNumericValue()) {
                resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(destAndState.getState()));
                continue;
            }
            for (ValueAndSMGState sourceAndState : this.getFunctionParameterValue(1, functionCall, destAndState.getState(), cfaEdge)) {
                Value sourceAddress = sourceAndState.getValue();
                if (SMGCPAExpressionEvaluator.valueIsAddressExprOrVariableOffset(sourceAddress)) {
                    resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(sourceAndState.getState()));
                    continue;
                }
                if (!(sourceAddress instanceof AddressExpression)) {
                    resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(sourceAndState.getState()));
                    continue;
                }
                AddressExpression sourceAddressExpr = (AddressExpression)sourceAddress;
                if (!sourceAddressExpr.getOffset().isNumericValue()) {
                    resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(sourceAndState.getState()));
                    continue;
                }
                for (ValueAndSMGState sizeAndState : this.getFunctionParameterValue(2, functionCall, sourceAndState.getState(), cfaEdge)) {
                    SMGState currentState = sizeAndState.getState();
                    Value sizeValue = sizeAndState.getValue();
                    if (!sizeValue.isNumericValue()) {
                        resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(currentState));
                        continue;
                    }
                    resultBuilder.addAll(this.evaluateMemcpy(currentState, targetAddressExpr, sourceAddressExpr, sizeValue));
                }
            }
        }
        return resultBuilder.build();
    }

    private List<ValueAndSMGState> evaluateMemcpy(SMGState pState, AddressExpression targetAddress, AddressExpression sourceAddress, Value numOfBytesValue) throws SMG2Exception {
        Preconditions.checkArgument((boolean)(numOfBytesValue instanceof NumericValue));
        long numOfBytes = numOfBytesValue.asNumericValue().bigInteger().longValue();
        if (numOfBytes < 0L) {
            numOfBytes = Integer.toUnsignedLong(numOfBytesValue.asNumericValue().bigInteger().intValueExact());
        }
        BigInteger sizeToCopyInBits = BigInteger.valueOf(numOfBytes).multiply(BigInteger.valueOf(this.machineModel.getSizeofCharInBits()));
        BigInteger targetOffset = targetAddress.getOffset().asNumericValue().bigInteger();
        BigInteger sourceOffset = sourceAddress.getOffset().asNumericValue().bigInteger();
        Value targetMemoryAddress = targetAddress.getMemoryAddress();
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        if (targetOffset.compareTo(BigInteger.ZERO) == 0) {
            List<SMGState> copyResultStates = this.evaluator.copyFromMemoryToMemory(sourceAddress.getMemoryAddress(), sourceOffset, targetMemoryAddress, targetOffset, sizeToCopyInBits, pState);
            for (SMGState copyResultState : copyResultStates) {
                resultBuilder.add((Object)ValueAndSMGState.of(targetMemoryAddress, copyResultState));
            }
        } else {
            List<ValueAndSMGState> newPointersAndStates = this.evaluator.findOrcreateNewPointer(targetMemoryAddress, targetOffset, pState);
            for (ValueAndSMGState newPointerAndState : newPointersAndStates) {
                resultBuilder.add((Object)ValueAndSMGState.of(newPointerAndState.getValue(), this.evaluator.copyFromMemoryToMemory(sourceAddress.getMemoryAddress(), sourceOffset, targetMemoryAddress, targetOffset, sizeToCopyInBits, newPointerAndState.getState()).get(0)));
            }
        }
        return resultBuilder.build();
    }

    private List<ValueAndSMGState> evaluateStrcmp(CFunctionCallExpression pFunctionCall, SMGState pState, CFAEdge pCfaEdge) throws CPATransferException {
        if (pFunctionCall.getParameterExpressions().size() != 2) {
            throw new UnrecognizedCodeException("The function strcmp needs exactly 2 arguments.", pCfaEdge);
        }
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (ValueAndSMGState firstValueAndSMGState : this.getFunctionParameterValue(0, pFunctionCall, pState, pCfaEdge)) {
            Value firstAddress = firstValueAndSMGState.getValue();
            if (!(firstAddress instanceof AddressExpression)) {
                resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(firstValueAndSMGState.getState()));
                continue;
            }
            AddressExpression firstAddressExpr = (AddressExpression)firstAddress;
            if (!firstAddressExpr.getOffset().isNumericValue()) {
                resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(firstValueAndSMGState.getState()));
                continue;
            }
            for (ValueAndSMGState secondValueAndSMGState : this.getFunctionParameterValue(1, pFunctionCall, firstValueAndSMGState.getState(), pCfaEdge)) {
                Value secondAddress = secondValueAndSMGState.getValue();
                if (!SMGCPAExpressionEvaluator.valueIsAddressExprOrVariableOffset(secondAddress)) {
                    resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(secondValueAndSMGState.getState()));
                    continue;
                }
                if (!(secondAddress instanceof AddressExpression)) {
                    resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(secondValueAndSMGState.getState()));
                    continue;
                }
                AddressExpression secondAddressExpr = (AddressExpression)secondAddress;
                if (!secondAddressExpr.getOffset().isNumericValue()) {
                    resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(secondValueAndSMGState.getState()));
                    continue;
                }
                resultBuilder.add((Object)this.evaluator.stringCompare(firstAddressExpr.getMemoryAddress(), firstAddressExpr.getOffset().asNumericValue().bigInteger(), secondAddressExpr.getMemoryAddress(), secondAddressExpr.getOffset().asNumericValue().bigInteger(), secondValueAndSMGState.getState()));
            }
        }
        return resultBuilder.build();
    }

    private List<ValueAndSMGState> evaluateRealloc() throws CPATransferException {
        throw new CPATransferException("Unhandled realloc function");
    }

    public Collection<SMGState> checkAllParametersForValidity(CFunctionCallExpression cFCExpression, SMGState pState, CFAEdge pCfaEdge) throws CPATransferException {
        return this.checkAllParametersForValidity(pState, pCfaEdge, cFCExpression);
    }
}

