/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.ALiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CDefaults;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPAExportOptions;
import org.sosy_lab.cpachecker.cpa.smg2.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.SMGTransferRelation;
import org.sosy_lab.cpachecker.cpa.smg2.SymbolicProgramConfiguration;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMG2Exception;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGStateAndOptionalSMGObjectAndOffset;
import org.sosy_lab.cpachecker.cpa.smg2.util.value.ValueAndSMGState;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;

public class SMGCPATransferRelationTest {
    SMGState initialState;
    SMGOptions smgOptions;
    private static final CType CHAR_TYPE = CNumericTypes.CHAR;
    private static final CType SHORT_TYPE = CNumericTypes.SHORT_INT;
    private static final CType UNSIGNED_SHORT_TYPE = CNumericTypes.UNSIGNED_SHORT_INT;
    private static final CType INT_TYPE = CNumericTypes.INT;
    private static final CType UNSIGNED_INT_TYPE = CNumericTypes.UNSIGNED_INT;
    private static final CType LONG_TYPE = CNumericTypes.LONG_INT;
    private static final CType UNSIGNED_LONG_TYPE = CNumericTypes.UNSIGNED_LONG_INT;
    private static final CType FLOAT_TYPE = CNumericTypes.FLOAT;
    private static final CType DOUBLE_TYPE = CNumericTypes.DOUBLE;
    private static final CType[] TEST_TYPES = new CType[]{CHAR_TYPE, SHORT_TYPE, UNSIGNED_SHORT_TYPE, INT_TYPE, UNSIGNED_INT_TYPE, LONG_TYPE, UNSIGNED_LONG_TYPE};
    private static final MachineModel MACHINE_MODEL = MachineModel.LINUX64;
    private static final int POINTER_SIZE_IN_BITS = MACHINE_MODEL.getSizeof(MACHINE_MODEL.getPointerEquivalentSimpleType()) * 8;
    private static final List<CType> STRUCT_UNION_TEST_TYPES = ImmutableList.of((Object)SHORT_TYPE, (Object)INT_TYPE, (Object)UNSIGNED_SHORT_TYPE, (Object)UNSIGNED_INT_TYPE, (Object)LONG_TYPE, (Object)UNSIGNED_LONG_TYPE, (Object)CHAR_TYPE);
    private static final List<String> STRUCT_UNION_FIELD_NAMES = ImmutableList.of((Object)"SHORT_TYPE", (Object)"INT_TYPE", (Object)"UNSIGNED_SHORT_TYPE", (Object)"UNSIGNED_INT_TYPE", (Object)"LONG_TYPE", (Object)"UNSIGNED_LONG_TYPE", (Object)"CHAR_TYPE");
    private static final List<CType> ARRAY_TEST_TYPES = ImmutableList.of((Object)SHORT_TYPE, (Object)INT_TYPE, (Object)UNSIGNED_SHORT_TYPE, (Object)UNSIGNED_INT_TYPE, (Object)LONG_TYPE, (Object)UNSIGNED_LONG_TYPE, (Object)CHAR_TYPE);
    private static final BigInteger TEST_ARRAY_LENGTH = BigInteger.valueOf(50L);
    private SMGTransferRelation transferRelation;

    @Before
    public void init() throws InvalidConfigurationException {
        LogManager logManager = LogManager.createTestLogManager();
        this.smgOptions = new SMGOptions(Configuration.defaultConfiguration());
        this.initialState = SMGState.of(MACHINE_MODEL, logManager, this.smgOptions).copyAndAddStackFrame(CFunctionDeclaration.DUMMY);
        this.transferRelation = new SMGTransferRelation(logManager, this.smgOptions, SMGCPAExportOptions.getNoExportInstance(), MACHINE_MODEL, (Collection<String>)ImmutableList.of(), null);
        this.transferRelation.setInfo(this.initialState, null, new CDeclarationEdge("", FileLocation.DUMMY, CFANode.newDummyCFANode(), CFANode.newDummyCFANode(), null));
    }

    @Test
    public void localVariableDeclarationStructSimpleTypesTest() throws CPATransferException {
        String variableName = "variableName";
        String structName = "TestStruct";
        CType type = this.makeElaboratedTypeFor(structName, CComplexType.ComplexTypeKind.STRUCT, STRUCT_UNION_TEST_TYPES, STRUCT_UNION_FIELD_NAMES);
        Object statesAfterDecl = this.transferRelation.handleDeclarationEdge(null, this.declareVariableWithoutInitializer(variableName, type, false, false));
        Truth.assertThat((Iterable)statesAfterDecl).hasSize(1);
        SMGState state = (SMGState)statesAfterDecl.get(0);
        SymbolicProgramConfiguration memoryModel = state.getMemoryModel();
        Truth.assertThat((Boolean)memoryModel.getStackFrames().peek().containsVariable(variableName)).isTrue();
        SMGObject memoryObject = memoryModel.getStackFrames().peek().getVariable(variableName);
        BigInteger expectedSize = MACHINE_MODEL.getSizeofInBits(type);
        Truth.assertThat((Boolean)(memoryObject.getSize().compareTo(expectedSize) == 0 ? 1 : 0)).isTrue();
        for (int i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
            BigInteger sizeInBits;
            BigInteger offsetInBits = MACHINE_MODEL.getFieldOffsetInBits((CCompositeType)((CElaboratedType)type).getRealType(), STRUCT_UNION_FIELD_NAMES.get(i));
            List<ValueAndSMGState> readValueAndState = state.readValue(memoryObject, offsetInBits, sizeInBits = MACHINE_MODEL.getSizeofInBits(STRUCT_UNION_TEST_TYPES.get(i)), null);
            Preconditions.checkArgument((readValueAndState.size() == 1 ? 1 : 0) != 0);
            Truth.assertThat((Boolean)readValueAndState.get(0).getValue().isExplicitlyKnown()).isFalse();
        }
    }

    @Test
    public void localVariableDeclarationWithAssignmentStructSimpleTypesTest() throws CPATransferException {
        String variableName = "variableName";
        String structName = "TestStruct";
        CType type = this.makeElaboratedTypeFor(structName, CComplexType.ComplexTypeKind.STRUCT, STRUCT_UNION_TEST_TYPES, STRUCT_UNION_FIELD_NAMES);
        ImmutableList.Builder listOfInitsBuilder = ImmutableList.builder();
        BigInteger value = BigInteger.ONE;
        for (CType currType : STRUCT_UNION_TEST_TYPES) {
            CExpression exprToInit = currType == CNumericTypes.CHAR ? this.makeCharExpressionFrom((char)value.intValue()) : this.makeIntegerExpressionFrom(value, (CSimpleType)currType);
            listOfInitsBuilder.add((Object)this.makeCInitializerExpressionFor(exprToInit));
            value = value.add(BigInteger.ONE);
        }
        CInitializer initList = this.makeCInitializerListFor((List<CInitializer>)listOfInitsBuilder.build());
        Object statesAfterDecl = this.transferRelation.handleDeclarationEdge(null, this.declareVariableWithInitializer(variableName, type, false, false, initList));
        Truth.assertThat((Iterable)statesAfterDecl).hasSize(1);
        SMGState state = (SMGState)statesAfterDecl.get(0);
        SymbolicProgramConfiguration memoryModel = state.getMemoryModel();
        Truth.assertThat((Boolean)memoryModel.getStackFrames().peek().containsVariable(variableName)).isTrue();
        SMGObject memoryObject = memoryModel.getStackFrames().peek().getVariable(variableName);
        BigInteger expectedSize = MACHINE_MODEL.getSizeofInBits(type);
        Truth.assertThat((Boolean)(memoryObject.getSize().compareTo(expectedSize) == 0 ? 1 : 0)).isTrue();
        for (int i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
            BigInteger sizeInBits;
            BigInteger offsetInBits = MACHINE_MODEL.getFieldOffsetInBits((CCompositeType)((CElaboratedType)type).getRealType(), STRUCT_UNION_FIELD_NAMES.get(i));
            List<ValueAndSMGState> readValueAndState = state.readValue(memoryObject, offsetInBits, sizeInBits = MACHINE_MODEL.getSizeofInBits(STRUCT_UNION_TEST_TYPES.get(i)), null);
            Preconditions.checkArgument((readValueAndState.size() == 1 ? 1 : 0) != 0);
            Truth.assertThat((Boolean)readValueAndState.get(0).getValue().isNumericValue()).isTrue();
            Truth.assertThat((Integer)readValueAndState.get(0).getValue().asNumericValue().bigInteger().intValueExact()).isEqualTo((Object)(i + 1));
        }
    }

    @Test
    public void localVariableDeclarationStructComplexTypesTest() throws CPATransferException {
        BigInteger sizeOfPointerInBits;
        List<ValueAndSMGState> readValueAndState;
        List<ValueAndSMGState> readValueAndState2;
        int i;
        String variableName = "variableName";
        String structName = "TestStruct";
        String nestedStructFieldName = "NESTED_STRUCT";
        ImmutableList.Builder overallFieldNames = ImmutableList.builder();
        overallFieldNames.addAll(STRUCT_UNION_FIELD_NAMES);
        overallFieldNames.add((Object)nestedStructFieldName);
        overallFieldNames.addAll((Iterable)Collections3.transformedImmutableListCopy(STRUCT_UNION_FIELD_NAMES, name -> "ARRAY_" + name));
        overallFieldNames.addAll((Iterable)Collections3.transformedImmutableListCopy(STRUCT_UNION_FIELD_NAMES, name -> "POINTER_" + name));
        CType type = this.makeNestedStruct(structName, STRUCT_UNION_TEST_TYPES, (List<String>)overallFieldNames.build(), STRUCT_UNION_TEST_TYPES, STRUCT_UNION_FIELD_NAMES, structName + "Nested", STRUCT_UNION_TEST_TYPES, STRUCT_UNION_TEST_TYPES);
        Object statesAfterDecl = this.transferRelation.handleDeclarationEdge(null, this.declareVariableWithoutInitializer(variableName, type, false, false));
        Truth.assertThat((Iterable)statesAfterDecl).hasSize(1);
        SMGState state = (SMGState)statesAfterDecl.get(0);
        SymbolicProgramConfiguration memoryModel = state.getMemoryModel();
        Truth.assertThat((Boolean)memoryModel.getStackFrames().peek().containsVariable(variableName)).isTrue();
        SMGObject memoryObject = memoryModel.getStackFrames().peek().getVariable(variableName);
        BigInteger expectedSize = MACHINE_MODEL.getSizeofInBits(type);
        Truth.assertThat((Boolean)(memoryObject.getSize().compareTo(expectedSize) == 0 ? 1 : 0)).isTrue();
        for (i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
            BigInteger sizeInBits;
            BigInteger offsetInBits = MACHINE_MODEL.getFieldOffsetInBits((CCompositeType)((CElaboratedType)type).getRealType(), STRUCT_UNION_FIELD_NAMES.get(i));
            readValueAndState2 = state.readValue(memoryObject, offsetInBits, sizeInBits = MACHINE_MODEL.getSizeofInBits(STRUCT_UNION_TEST_TYPES.get(i)), null);
            Preconditions.checkArgument((readValueAndState2.size() == 1 ? 1 : 0) != 0);
            Truth.assertThat((Boolean)readValueAndState2.get(0).getValue().isExplicitlyKnown()).isFalse();
        }
        for (i = 0; i < 1; ++i) {
            BigInteger sizeInBits;
            BigInteger baseOffsetNestedStruct = MACHINE_MODEL.getFieldOffsetInBits((CCompositeType)((CElaboratedType)type).getRealType(), nestedStructFieldName);
            BigInteger offsetInBits = MACHINE_MODEL.getFieldOffsetInBits((CCompositeType)((CElaboratedType)type).getRealType(), STRUCT_UNION_FIELD_NAMES.get(i)).add(baseOffsetNestedStruct);
            readValueAndState = state.readValue(memoryObject, offsetInBits, sizeInBits = MACHINE_MODEL.getSizeofInBits(STRUCT_UNION_TEST_TYPES.get(i)), null);
            Preconditions.checkArgument((readValueAndState.size() == 1 ? 1 : 0) != 0);
            Truth.assertThat((Boolean)readValueAndState.get(0).getValue().isExplicitlyKnown()).isFalse();
        }
        BigInteger offsetOfArrayInBits = MACHINE_MODEL.getFieldOffsetInBits((CCompositeType)((CElaboratedType)type).getRealType(), "ARRAY_" + STRUCT_UNION_FIELD_NAMES.get(0));
        BigInteger sizeOfArrayInBits = MACHINE_MODEL.getSizeofInBits(STRUCT_UNION_TEST_TYPES.get(0));
        for (int i2 = 0; i2 < TEST_ARRAY_LENGTH.intValue(); ++i2) {
            readValueAndState2 = state.readValue(memoryObject, offsetOfArrayInBits, sizeOfArrayInBits, null);
            Preconditions.checkArgument((readValueAndState2.size() == 1 ? 1 : 0) != 0);
            Truth.assertThat((Boolean)readValueAndState2.get(0).getValue().isExplicitlyKnown()).isFalse();
            offsetOfArrayInBits = offsetOfArrayInBits.add(sizeOfArrayInBits);
        }
        BigInteger offsetOfPointerInBits = MACHINE_MODEL.getFieldOffsetInBits((CCompositeType)((CElaboratedType)type).getRealType(), "POINTER_" + STRUCT_UNION_FIELD_NAMES.get(0));
        readValueAndState = state.readValue(memoryObject, offsetOfPointerInBits, sizeOfPointerInBits = BigInteger.valueOf(POINTER_SIZE_IN_BITS), null);
        Preconditions.checkArgument((readValueAndState.size() == 1 ? 1 : 0) != 0);
        Truth.assertThat((Boolean)readValueAndState.get(0).getValue().isExplicitlyKnown()).isFalse();
    }

    @Test
    public void localVariableDeclarationWithAssignmentStructComplexTypesTest() throws CPATransferException {
        List<ValueAndSMGState> readValueAndState;
        int i;
        CInitializer initList = this.makeInitializerForNestedStruct(BigInteger.ONE, STRUCT_UNION_TEST_TYPES, STRUCT_UNION_TEST_TYPES, STRUCT_UNION_TEST_TYPES, STRUCT_UNION_TEST_TYPES);
        String variableName = "variableName";
        String structName = "TestStruct";
        String nestedStructFieldName = "NESTED_STRUCT";
        ImmutableList.Builder overallFieldNames = ImmutableList.builder();
        overallFieldNames.addAll(STRUCT_UNION_FIELD_NAMES);
        overallFieldNames.add((Object)nestedStructFieldName);
        overallFieldNames.addAll((Iterable)Collections3.transformedImmutableListCopy(STRUCT_UNION_FIELD_NAMES, name -> "ARRAY_" + name));
        overallFieldNames.addAll((Iterable)Collections3.transformedImmutableListCopy(STRUCT_UNION_FIELD_NAMES, name -> "POINTER_" + name));
        CType type = this.makeNestedStruct(structName, STRUCT_UNION_TEST_TYPES, (List<String>)overallFieldNames.build(), STRUCT_UNION_TEST_TYPES, STRUCT_UNION_FIELD_NAMES, structName + "Nested", STRUCT_UNION_TEST_TYPES, STRUCT_UNION_TEST_TYPES);
        Object statesAfterDecl = this.transferRelation.handleDeclarationEdge(null, this.declareVariableWithInitializer(variableName, type, false, false, initList));
        Truth.assertThat((Iterable)statesAfterDecl).hasSize(1);
        SMGState state = (SMGState)statesAfterDecl.get(0);
        SymbolicProgramConfiguration memoryModel = state.getMemoryModel();
        Truth.assertThat((Boolean)memoryModel.getStackFrames().peek().containsVariable(variableName)).isTrue();
        SMGObject memoryObject = memoryModel.getStackFrames().peek().getVariable(variableName);
        BigInteger expectedSize = MACHINE_MODEL.getSizeofInBits(type);
        Truth.assertThat((Boolean)(memoryObject.getSize().compareTo(expectedSize) == 0 ? 1 : 0)).isTrue();
        BigInteger expectedValue = BigInteger.ONE;
        for (i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
            BigInteger sizeInBits;
            BigInteger offsetInBits = MACHINE_MODEL.getFieldOffsetInBits((CCompositeType)((CElaboratedType)type).getRealType(), STRUCT_UNION_FIELD_NAMES.get(i));
            List<ValueAndSMGState> readValueAndState2 = state.readValue(memoryObject, offsetInBits, sizeInBits = MACHINE_MODEL.getSizeofInBits(STRUCT_UNION_TEST_TYPES.get(i)), null);
            Preconditions.checkArgument((readValueAndState2.size() == 1 ? 1 : 0) != 0);
            Truth.assertThat((Boolean)readValueAndState2.get(0).getValue().isNumericValue()).isTrue();
            Truth.assertThat((Comparable)readValueAndState2.get(0).getValue().asNumericValue().bigInteger()).isEquivalentAccordingToCompareTo((Comparable)expectedValue);
            expectedValue = expectedValue.add(BigInteger.ONE);
        }
        for (i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
            BigInteger sizeInBits;
            BigInteger baseOffsetNestedStruct = MACHINE_MODEL.getFieldOffsetInBits((CCompositeType)((CElaboratedType)type).getRealType(), nestedStructFieldName);
            BigInteger offsetInBits = MACHINE_MODEL.getFieldOffsetInBits((CCompositeType)((CElaboratedType)type).getRealType(), STRUCT_UNION_FIELD_NAMES.get(i)).add(baseOffsetNestedStruct);
            readValueAndState = state.readValue(memoryObject, offsetInBits, sizeInBits = MACHINE_MODEL.getSizeofInBits(STRUCT_UNION_TEST_TYPES.get(i)), null);
            Preconditions.checkArgument((readValueAndState.size() == 1 ? 1 : 0) != 0);
            Truth.assertThat((Boolean)readValueAndState.get(0).getValue().isNumericValue()).isTrue();
            Truth.assertThat((Comparable)readValueAndState.get(0).getValue().asNumericValue().bigInteger()).isEquivalentAccordingToCompareTo((Comparable)expectedValue);
            expectedValue = expectedValue.add(BigInteger.ONE);
        }
        for (i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
            BigInteger offsetOfArrayInBits = MACHINE_MODEL.getFieldOffsetInBits((CCompositeType)((CElaboratedType)type).getRealType(), "ARRAY_" + STRUCT_UNION_FIELD_NAMES.get(i));
            BigInteger sizeOfArrayInBits = MACHINE_MODEL.getSizeofInBits(STRUCT_UNION_TEST_TYPES.get(i));
            for (int j = 0; j < TEST_ARRAY_LENGTH.intValue(); ++j) {
                readValueAndState = state.readValue(memoryObject, offsetOfArrayInBits, sizeOfArrayInBits, null);
                Preconditions.checkArgument((readValueAndState.size() == 1 ? 1 : 0) != 0);
                Truth.assertThat((Boolean)readValueAndState.get(0).getValue().isNumericValue()).isTrue();
                if (readValueAndState.get(0).getValue().asNumericValue().bigInteger().compareTo(expectedValue) != 0) {
                    Truth.assertThat((Comparable)readValueAndState.get(0).getValue().asNumericValue().bigInteger().add(BigInteger.valueOf(256L))).isEquivalentAccordingToCompareTo((Comparable)expectedValue);
                } else {
                    Truth.assertThat((Comparable)readValueAndState.get(0).getValue().asNumericValue().bigInteger()).isEquivalentAccordingToCompareTo((Comparable)expectedValue);
                }
                expectedValue = expectedValue.add(BigInteger.ONE);
                offsetOfArrayInBits = offsetOfArrayInBits.add(sizeOfArrayInBits);
            }
        }
        for (i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
            BigInteger sizeOfPointerInBits;
            BigInteger offsetOfPointerInBits = MACHINE_MODEL.getFieldOffsetInBits((CCompositeType)((CElaboratedType)type).getRealType(), "POINTER_" + STRUCT_UNION_FIELD_NAMES.get(i));
            List<ValueAndSMGState> readValueAndState3 = state.readValue(memoryObject, offsetOfPointerInBits, sizeOfPointerInBits = BigInteger.valueOf(POINTER_SIZE_IN_BITS), null);
            Preconditions.checkArgument((readValueAndState3.size() == 1 ? 1 : 0) != 0);
            Truth.assertThat((Boolean)readValueAndState3.get(0).getValue().isNumericValue()).isTrue();
            Truth.assertThat((Comparable)readValueAndState3.get(0).getValue().asNumericValue().bigInteger()).isEquivalentAccordingToCompareTo((Comparable)BigInteger.ZERO);
        }
    }

    @Test
    public void localVariableDeclarationArrayTypesTest() throws CPATransferException {
        String variableName = "variableName";
        for (CType type : ARRAY_TEST_TYPES) {
            Object statesAfterDecl = this.transferRelation.handleDeclarationEdge(null, this.declareVariableWithoutInitializer(variableName, this.makeArrayTypeFor(type, TEST_ARRAY_LENGTH), false, false));
            Truth.assertThat((Iterable)statesAfterDecl).hasSize(1);
            SMGState state = (SMGState)statesAfterDecl.get(0);
            SymbolicProgramConfiguration memoryModel = state.getMemoryModel();
            Truth.assertThat((Boolean)memoryModel.getStackFrames().peek().containsVariable(variableName)).isTrue();
            SMGObject memoryObject = memoryModel.getStackFrames().peek().getVariable(variableName);
            BigInteger typeSize = MACHINE_MODEL.getSizeofInBits(type);
            BigInteger expectedSize = typeSize.multiply(TEST_ARRAY_LENGTH);
            Truth.assertThat((Boolean)(memoryObject.getSize().compareTo(expectedSize) == 0 ? 1 : 0)).isTrue();
            for (int i = 0; i < TEST_ARRAY_LENGTH.intValue(); ++i) {
                BigInteger offset = BigInteger.valueOf(i).multiply(typeSize);
                List<ValueAndSMGState> readValueAndState = state.readValue(memoryObject, offset, typeSize, null);
                Preconditions.checkArgument((readValueAndState.size() == 1 ? 1 : 0) != 0);
                Truth.assertThat((Boolean)readValueAndState.get(0).getValue().isExplicitlyKnown()).isFalse();
            }
        }
    }

    @Test
    public void localVariableDeclarationWithAssignmentArrayTypesTest() throws CPATransferException {
        String variableName = "variableName";
        for (CType type : ARRAY_TEST_TYPES) {
            ImmutableList.Builder listOfInitsBuilder = ImmutableList.builder();
            for (int i = 0; i < TEST_ARRAY_LENGTH.intValue(); ++i) {
                CExpression exprToInit = type == CNumericTypes.CHAR ? this.makeCharExpressionFrom((char)i) : this.makeIntegerExpressionFrom(BigInteger.valueOf(i), (CSimpleType)type);
                listOfInitsBuilder.add((Object)this.makeCInitializerExpressionFor(exprToInit));
            }
            CInitializer initList = this.makeCInitializerListFor((List<CInitializer>)listOfInitsBuilder.build());
            Object statesAfterDecl = this.transferRelation.handleDeclarationEdge(null, this.declareVariableWithInitializer(variableName, this.makeArrayTypeFor(type, TEST_ARRAY_LENGTH), false, false, initList));
            Truth.assertThat((Iterable)statesAfterDecl).hasSize(1);
            SMGState state = (SMGState)statesAfterDecl.get(0);
            SymbolicProgramConfiguration memoryModel = state.getMemoryModel();
            Truth.assertThat((Boolean)memoryModel.getStackFrames().peek().containsVariable(variableName)).isTrue();
            SMGObject memoryObject = memoryModel.getStackFrames().peek().getVariable(variableName);
            BigInteger typeSize = MACHINE_MODEL.getSizeofInBits(type);
            BigInteger expectedSize = typeSize.multiply(TEST_ARRAY_LENGTH);
            Truth.assertThat((Boolean)(memoryObject.getSize().compareTo(expectedSize) == 0 ? 1 : 0)).isTrue();
            for (int i = 0; i < TEST_ARRAY_LENGTH.intValue(); ++i) {
                BigInteger offset = BigInteger.valueOf(i).multiply(typeSize);
                List<ValueAndSMGState> readValueAndState = state.readValue(memoryObject, offset, typeSize, null);
                Preconditions.checkArgument((readValueAndState.size() == 1 ? 1 : 0) != 0);
                Truth.assertThat((Boolean)readValueAndState.get(0).getValue().isNumericValue()).isTrue();
                Truth.assertThat((Integer)readValueAndState.get(0).getValue().asNumericValue().bigInteger().intValueExact()).isEqualTo((Object)i);
            }
        }
    }

    @Test
    public void localVariableDeclarationSimpleTypesTest() throws CPATransferException {
        String variableName = "variableName";
        for (CType type : TEST_TYPES) {
            Object statesAfterDecl = this.transferRelation.handleDeclarationEdge(null, this.declareVariableWithoutInitializer(variableName, type, false, false));
            Truth.assertThat((Iterable)statesAfterDecl).hasSize(1);
            SMGState state = (SMGState)statesAfterDecl.get(0);
            SymbolicProgramConfiguration memoryModel = state.getMemoryModel();
            Truth.assertThat((Boolean)memoryModel.getStackFrames().peek().containsVariable(variableName)).isTrue();
            SMGObject memoryObject = memoryModel.getStackFrames().peek().getVariable(variableName);
            BigInteger expectedSize = MACHINE_MODEL.getSizeofInBits(type);
            Truth.assertThat((Boolean)(memoryObject.getSize().compareTo(expectedSize) == 0 ? 1 : 0)).isTrue();
            List<ValueAndSMGState> readValueAndState = state.readValue(memoryObject, BigInteger.ZERO, expectedSize, null);
            Preconditions.checkArgument((readValueAndState.size() == 1 ? 1 : 0) != 0);
            Truth.assertThat((Boolean)readValueAndState.get(0).getValue().isExplicitlyKnown()).isFalse();
        }
    }

    @Test
    public void localVariableDeclarationWithAssignmentSimpleTypesTest() throws CPATransferException {
        String variableName = "variableName";
        BigInteger value = BigInteger.ONE;
        for (CType type : TEST_TYPES) {
            CExpression exprToInit = type == CNumericTypes.CHAR ? this.makeCharExpressionFrom((char)value.intValue()) : this.makeIntegerExpressionFrom(value, (CSimpleType)type);
            CInitializer initializer = this.makeCInitializerExpressionFor(exprToInit);
            Object statesAfterDecl = this.transferRelation.handleDeclarationEdge(null, this.declareVariableWithInitializer(variableName, type, false, false, initializer));
            Truth.assertThat((Iterable)statesAfterDecl).hasSize(1);
            SMGState state = (SMGState)statesAfterDecl.get(0);
            SymbolicProgramConfiguration memoryModel = state.getMemoryModel();
            Truth.assertThat((Boolean)memoryModel.getStackFrames().peek().containsVariable(variableName)).isTrue();
            SMGObject memoryObject = memoryModel.getStackFrames().peek().getVariable(variableName);
            BigInteger expectedSize = MACHINE_MODEL.getSizeofInBits(type);
            Truth.assertThat((Boolean)(memoryObject.getSize().compareTo(expectedSize) == 0 ? 1 : 0)).isTrue();
            List<ValueAndSMGState> readValueAndState = state.readValue(memoryObject, BigInteger.ZERO, expectedSize, null);
            Preconditions.checkArgument((readValueAndState.size() == 1 ? 1 : 0) != 0);
            Truth.assertThat((Boolean)readValueAndState.get(0).getValue().isExplicitlyKnown()).isTrue();
            Truth.assertThat((Boolean)(readValueAndState.get(0).getValue().asNumericValue().bigInteger().compareTo(value) == 0 ? 1 : 0)).isTrue();
            value = value.add(BigInteger.ONE);
        }
    }

    @Test
    public void localVariableDeclarationWithAssignmentMallocTest() throws CPATransferException {
        String variableName = "variableName";
        CType sizeType = INT_TYPE;
        for (int i = 0; i < 5000; i += TEST_ARRAY_LENGTH.intValue()) {
            BigInteger sizeInBytes = BigInteger.valueOf(i);
            for (CType type : TEST_TYPES) {
                SMGState stateAfterMallocAssignSuccess;
                CPointerType pointerType = new CPointerType(false, false, type);
                Object statesAfterDecl = this.transferRelation.handleDeclarationEdge(null, this.declareVariableWithoutInitializer(variableName, pointerType, false, false));
                Truth.assertThat((Iterable)statesAfterDecl).hasSize(1);
                SMGState stateAfterDecl = (SMGState)statesAfterDecl.get(0);
                CFunctionCallAssignmentStatement mallocAndAssignmentExpr = new CFunctionCallAssignmentStatement(FileLocation.DUMMY, new CIdExpression(FileLocation.DUMMY, new CPointerType(false, false, pointerType), variableName, this.declareVariableWithoutInitializer(variableName, pointerType, false, false)), this.makeMalloc(new CIntegerLiteralExpression(FileLocation.DUMMY, sizeType, sizeInBytes)));
                CStatementEdge mallocAndAssignmentEdge = new CStatementEdge(pointerType + " " + variableName + " = malloc(" + sizeInBytes + ")", mallocAndAssignmentExpr, FileLocation.DUMMY, CFANode.newDummyCFANode(), CFANode.newDummyCFANode());
                this.transferRelation.setInfo(stateAfterDecl, null, mallocAndAssignmentEdge);
                Object statesAfterMallocAssign = this.transferRelation.handleStatementEdge(mallocAndAssignmentEdge, mallocAndAssignmentExpr);
                Truth.assertThat((Boolean)(statesAfterMallocAssign instanceof List)).isTrue();
                List statesListAfterMallocAssign = (List)statesAfterMallocAssign;
                if (sizeInBytes.compareTo(BigInteger.ZERO) == 0) {
                    Truth.assertThat((Boolean)this.checkMallocFailure((SMGState)statesListAfterMallocAssign.get(0), variableName, pointerType)).isTrue();
                    continue;
                }
                if (!this.smgOptions.isEnableMallocFailure()) {
                    Truth.assertThat((Iterable)statesListAfterMallocAssign).hasSize(1);
                    stateAfterMallocAssignSuccess = (SMGState)statesListAfterMallocAssign.get(0);
                } else {
                    Truth.assertThat((Iterable)statesListAfterMallocAssign).hasSize(2);
                    SMGState stateAfterMallocAssignFailure = (SMGState)statesListAfterMallocAssign.get(1);
                    if (!this.checkMallocFailure(stateAfterMallocAssignFailure, variableName, pointerType)) {
                        stateAfterMallocAssignFailure = (SMGState)statesListAfterMallocAssign.get(0);
                        stateAfterMallocAssignSuccess = (SMGState)statesListAfterMallocAssign.get(1);
                        Truth.assertThat((Boolean)this.checkMallocFailure(stateAfterMallocAssignFailure, variableName, pointerType)).isTrue();
                    } else {
                        stateAfterMallocAssignSuccess = (SMGState)statesListAfterMallocAssign.get(0);
                    }
                }
                SymbolicProgramConfiguration memoryModel = stateAfterMallocAssignSuccess.getMemoryModel();
                Truth.assertThat((Boolean)memoryModel.getStackFrames().peek().containsVariable(variableName)).isTrue();
                SMGObject memoryObject = memoryModel.getStackFrames().peek().getVariable(variableName);
                BigInteger expectedSize = MACHINE_MODEL.getSizeofInBits(pointerType);
                Truth.assertThat((Boolean)(memoryObject.getSize().compareTo(expectedSize) == 0 ? 1 : 0)).isTrue();
                List<ValueAndSMGState> readValueAndState = stateAfterMallocAssignSuccess.readValue(memoryObject, BigInteger.ZERO, expectedSize, null);
                Preconditions.checkArgument((readValueAndState.size() == 1 ? 1 : 0) != 0);
                Truth.assertThat((Boolean)memoryModel.isPointer(readValueAndState.get(0).getValue())).isTrue();
                SMGStateAndOptionalSMGObjectAndOffset mallocObjectAndOffset = stateAfterMallocAssignSuccess.dereferencePointer(readValueAndState.get(0).getValue()).get(0);
                Truth.assertThat((Boolean)mallocObjectAndOffset.hasSMGObjectAndOffset()).isTrue();
                Truth.assertThat((Boolean)(mallocObjectAndOffset.getSMGObject().getSize().compareTo(sizeInBytes.multiply(BigInteger.valueOf(8L))) == 0 ? 1 : 0)).isTrue();
                Truth.assertThat((Boolean)(mallocObjectAndOffset.getSMGObject().getOffset().compareTo(BigInteger.ZERO) == 0 ? 1 : 0)).isTrue();
                Truth.assertThat((Boolean)(mallocObjectAndOffset.getOffsetForObject().compareTo(BigInteger.ZERO) == 0 ? 1 : 0)).isTrue();
            }
        }
    }

    @Test
    public void localVariableDeclarationWithAssignmentMallocWithSizeOfBinaryExpressionTest() throws CPATransferException {
        String variableName = "variableName";
        for (int i = 0; i < 50; ++i) {
            BigInteger sizeMultiplikator = BigInteger.valueOf(i);
            for (CType type : TEST_TYPES) {
                for (CType sizeofType : TEST_TYPES) {
                    SMGState stateAfterMallocAssignSuccess;
                    CPointerType pointerType = new CPointerType(false, false, type);
                    CBinaryExpression binarySizeExpression = new CBinaryExpression(FileLocation.DUMMY, INT_TYPE, INT_TYPE, new CIntegerLiteralExpression(FileLocation.DUMMY, INT_TYPE, sizeMultiplikator), new CUnaryExpression(FileLocation.DUMMY, INT_TYPE, new CIdExpression(FileLocation.DUMMY, new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, sizeofType, "SomeTypeNotQual", "SomeTypeNotQual", "SomeType", CDefaults.forType(sizeofType, FileLocation.DUMMY))), CUnaryExpression.UnaryOperator.SIZEOF), CBinaryExpression.BinaryOperator.MULTIPLY);
                    Object statesAfterDecl = this.transferRelation.handleDeclarationEdge(null, this.declareVariableWithoutInitializer(variableName, pointerType, false, false));
                    Truth.assertThat((Iterable)statesAfterDecl).hasSize(1);
                    SMGState stateAfterDecl = (SMGState)statesAfterDecl.get(0);
                    CFunctionCallAssignmentStatement mallocAndAssignmentExpr = new CFunctionCallAssignmentStatement(FileLocation.DUMMY, new CIdExpression(FileLocation.DUMMY, new CPointerType(false, false, pointerType), variableName, this.declareVariableWithoutInitializer(variableName, pointerType, false, false)), this.makeMalloc(binarySizeExpression));
                    CStatementEdge mallocAndAssignmentEdge = new CStatementEdge(pointerType + " " + variableName + " = malloc(" + binarySizeExpression.toASTString() + ")", mallocAndAssignmentExpr, FileLocation.DUMMY, CFANode.newDummyCFANode(), CFANode.newDummyCFANode());
                    this.transferRelation.setInfo(stateAfterDecl, null, mallocAndAssignmentEdge);
                    Object statesAfterMallocAssign = this.transferRelation.handleStatementEdge(mallocAndAssignmentEdge, mallocAndAssignmentExpr);
                    Truth.assertThat((Boolean)(statesAfterMallocAssign instanceof List)).isTrue();
                    List statesListAfterMallocAssign = (List)statesAfterMallocAssign;
                    if (sizeMultiplikator.compareTo(BigInteger.ZERO) == 0) {
                        Truth.assertThat((Boolean)this.checkMallocFailure((SMGState)statesListAfterMallocAssign.get(0), variableName, pointerType)).isTrue();
                        continue;
                    }
                    if (!this.smgOptions.isEnableMallocFailure()) {
                        Truth.assertThat((Iterable)statesListAfterMallocAssign).hasSize(1);
                        stateAfterMallocAssignSuccess = (SMGState)statesListAfterMallocAssign.get(0);
                    } else {
                        Truth.assertThat((Iterable)statesListAfterMallocAssign).hasSize(2);
                        SMGState stateAfterMallocAssignFailure = (SMGState)statesListAfterMallocAssign.get(1);
                        if (!this.checkMallocFailure(stateAfterMallocAssignFailure, variableName, pointerType)) {
                            stateAfterMallocAssignFailure = (SMGState)statesListAfterMallocAssign.get(0);
                            stateAfterMallocAssignSuccess = (SMGState)statesListAfterMallocAssign.get(1);
                            Truth.assertThat((Boolean)this.checkMallocFailure(stateAfterMallocAssignFailure, variableName, pointerType)).isTrue();
                        } else {
                            stateAfterMallocAssignSuccess = (SMGState)statesListAfterMallocAssign.get(0);
                        }
                    }
                    SymbolicProgramConfiguration memoryModel = stateAfterMallocAssignSuccess.getMemoryModel();
                    Truth.assertThat((Boolean)memoryModel.getStackFrames().peek().containsVariable(variableName)).isTrue();
                    SMGObject memoryObject = memoryModel.getStackFrames().peek().getVariable(variableName);
                    BigInteger expectedSize = MACHINE_MODEL.getSizeofInBits(pointerType);
                    Truth.assertThat((Boolean)(memoryObject.getSize().compareTo(expectedSize) == 0 ? 1 : 0)).isTrue();
                    List<ValueAndSMGState> readValueAndState = stateAfterMallocAssignSuccess.readValue(memoryObject, BigInteger.ZERO, expectedSize, null);
                    Preconditions.checkArgument((readValueAndState.size() == 1 ? 1 : 0) != 0);
                    Truth.assertThat((Boolean)memoryModel.isPointer(readValueAndState.get(0).getValue())).isTrue();
                    SMGStateAndOptionalSMGObjectAndOffset mallocObjectAndOffset = stateAfterMallocAssignSuccess.dereferencePointer(readValueAndState.get(0).getValue()).get(0);
                    Truth.assertThat((Boolean)mallocObjectAndOffset.hasSMGObjectAndOffset()).isTrue();
                    BigInteger expectedMemorySizeInBits = sizeMultiplikator.multiply(BigInteger.valueOf(8L)).multiply(MACHINE_MODEL.getSizeof(sizeofType));
                    Truth.assertThat((Boolean)(mallocObjectAndOffset.getSMGObject().getSize().compareTo(expectedMemorySizeInBits) == 0 ? 1 : 0)).isTrue();
                    Truth.assertThat((Boolean)(mallocObjectAndOffset.getSMGObject().getOffset().compareTo(BigInteger.ZERO) == 0 ? 1 : 0)).isTrue();
                    Truth.assertThat((Boolean)(mallocObjectAndOffset.getOffsetForObject().compareTo(BigInteger.ZERO) == 0 ? 1 : 0)).isTrue();
                }
            }
        }
    }

    private boolean checkMallocFailure(SMGState stateAfterMallocAssignFailure, String variableName, CType pointerType) throws SMG2Exception {
        SymbolicProgramConfiguration memoryModel = stateAfterMallocAssignFailure.getMemoryModel();
        Truth.assertThat((Boolean)memoryModel.getStackFrames().peek().containsVariable(variableName)).isTrue();
        SMGObject memoryObject = memoryModel.getStackFrames().peek().getVariable(variableName);
        BigInteger expectedSize = MACHINE_MODEL.getSizeofInBits(pointerType);
        Truth.assertThat((Boolean)(memoryObject.getSize().compareTo(expectedSize) == 0 ? 1 : 0)).isTrue();
        List<ValueAndSMGState> readValueAndState = stateAfterMallocAssignFailure.readValue(memoryObject, BigInteger.ZERO, expectedSize, null);
        Preconditions.checkArgument((readValueAndState.size() == 1 ? 1 : 0) != 0);
        if (!readValueAndState.get(0).getValue().isNumericValue()) {
            return false;
        }
        Truth.assertThat((Boolean)readValueAndState.get(0).getValue().isNumericValue()).isTrue();
        Truth.assertThat((Boolean)(readValueAndState.get(0).getValue().asNumericValue().bigInteger().compareTo(BigInteger.ZERO) == 0 ? 1 : 0)).isTrue();
        Truth.assertThat((Comparable)memoryModel.getSMGValueFromValue(readValueAndState.get(0).getValue()).orElseThrow()).isEqualTo((Object)SMGValue.zeroValue());
        return true;
    }

    @Test
    public void checkStackArrayWithAssignments() throws CPATransferException {
        Object variableName = "testArray";
        BigInteger[] values = new BigInteger[TEST_ARRAY_LENGTH.intValue()];
        for (CType testType : ARRAY_TEST_TYPES) {
            variableName = (String)variableName + testType;
            for (int i = 0; i < TEST_ARRAY_LENGTH.intValue(); ++i) {
                values[i] = ((CSimpleType)testType).isSigned() && Math.floorMod(i, 2) == 1 ? BigInteger.valueOf(-i) : BigInteger.valueOf(i);
            }
            SMGState stateWithArray = this.declareArrayVariableWithSimpleTypeWithValuesOnTheStack(TEST_ARRAY_LENGTH.intValue(), values, (String)variableName, testType);
            SymbolicProgramConfiguration memoryModel = stateWithArray.getMemoryModel();
            Truth.assertThat((Boolean)memoryModel.getStackFrames().peek().containsVariable((String)variableName)).isTrue();
            SMGObject memoryObject = memoryModel.getStackFrames().peek().getVariable((String)variableName);
            BigInteger expectedTypeSizeInBits = MACHINE_MODEL.getSizeofInBits(testType);
            Truth.assertThat((Boolean)(memoryObject.getSize().compareTo(expectedTypeSizeInBits.multiply(TEST_ARRAY_LENGTH)) == 0 ? 1 : 0)).isTrue();
            for (int i = 0; i < TEST_ARRAY_LENGTH.intValue(); ++i) {
                BigInteger offsetInBits = BigInteger.valueOf(i).multiply(expectedTypeSizeInBits);
                List<ValueAndSMGState> readValueAndState = stateWithArray.readValue(memoryObject, offsetInBits, expectedTypeSizeInBits, null);
                Preconditions.checkArgument((readValueAndState.size() == 1 ? 1 : 0) != 0);
                Truth.assertThat((Boolean)readValueAndState.get(0).getValue().isNumericValue()).isTrue();
                BigInteger expectedValue = ((CSimpleType)testType).isSigned() && Math.floorMod(i, 2) == 1 ? BigInteger.valueOf(-i) : BigInteger.valueOf(i);
                Truth.assertThat((Boolean)(readValueAndState.get(0).getValue().asNumericValue().bigInteger().compareTo(expectedValue) == 0 ? 1 : 0)).isTrue();
            }
        }
    }

    @Test
    public void checkHeapArrayWithAssignments() throws CPATransferException {
        String variableName = "testArray";
        BigInteger[] values = new BigInteger[TEST_ARRAY_LENGTH.intValue()];
        for (CType testType : ARRAY_TEST_TYPES) {
            for (int i = 0; i < TEST_ARRAY_LENGTH.intValue(); ++i) {
                values[i] = ((CSimpleType)testType).isSigned() && Math.floorMod(i, 2) == 1 ? BigInteger.valueOf(-i) : BigInteger.valueOf(i);
            }
            SMGState stateWithArray = this.declareArrayVariableWithSimpleTypeWithValuesOnTheHeap(TEST_ARRAY_LENGTH.intValue(), values, variableName, testType);
            SymbolicProgramConfiguration memoryModel = stateWithArray.getMemoryModel();
            Truth.assertThat((Boolean)memoryModel.getStackFrames().peek().containsVariable(variableName)).isTrue();
            SMGObject memoryObject = memoryModel.getStackFrames().peek().getVariable(variableName);
            BigInteger expectedTypeSizeInBits = MACHINE_MODEL.getSizeofInBits(testType);
            Truth.assertThat((Boolean)(memoryObject.getSize().compareTo(BigInteger.valueOf(POINTER_SIZE_IN_BITS)) == 0 ? 1 : 0)).isTrue();
            List<ValueAndSMGState> readAddressValueAndState = stateWithArray.readValue(memoryObject, BigInteger.ZERO, BigInteger.valueOf(POINTER_SIZE_IN_BITS), null);
            Preconditions.checkArgument((readAddressValueAndState.size() == 1 ? 1 : 0) != 0);
            Value address = readAddressValueAndState.get(0).getValue();
            SMGStateAndOptionalSMGObjectAndOffset maybeTargetOfPointer = stateWithArray.dereferencePointer(address).get(0);
            Truth.assertThat((Boolean)maybeTargetOfPointer.hasSMGObjectAndOffset()).isTrue();
            SMGStateAndOptionalSMGObjectAndOffset targetOfPointer = maybeTargetOfPointer;
            Truth.assertThat((Integer)targetOfPointer.getOffsetForObject().compareTo(BigInteger.ZERO)).isEqualTo((Object)0);
            SMGObject arrayMemoryObject = targetOfPointer.getSMGObject();
            Truth.assertThat((Boolean)arrayMemoryObject.isZero()).isFalse();
            for (int i = 0; i < TEST_ARRAY_LENGTH.intValue(); ++i) {
                BigInteger offsetInBits = BigInteger.valueOf(i).multiply(expectedTypeSizeInBits);
                List<ValueAndSMGState> readValueAndState = stateWithArray.readValue(arrayMemoryObject, offsetInBits, expectedTypeSizeInBits, null);
                Truth.assertThat((Boolean)readValueAndState.get(0).getValue().isNumericValue()).isTrue();
                BigInteger expectedValue = ((CSimpleType)testType).isSigned() && Math.floorMod(i, 2) == 1 ? BigInteger.valueOf(-i) : BigInteger.valueOf(i);
                Truth.assertThat((Boolean)(readValueAndState.get(0).getValue().asNumericValue().bigInteger().compareTo(expectedValue) == 0 ? 1 : 0)).isTrue();
            }
        }
    }

    @Test
    public void checkStackStructWithAssignments() throws CPATransferException {
        Object variableName = "testStruct";
        Object structTypeName = "testStructType";
        for (int sublist = 1; sublist < STRUCT_UNION_TEST_TYPES.size(); ++sublist) {
            variableName = (String)variableName + "sublist" + sublist;
            structTypeName = (String)structTypeName + "sublist" + sublist;
            List<CType> structTestTypes = STRUCT_UNION_TEST_TYPES.subList(0, sublist);
            List<String> structFieldNames = STRUCT_UNION_FIELD_NAMES.subList(0, sublist);
            BigInteger[] values = new BigInteger[structTestTypes.size()];
            for (int i = 0; i < structTestTypes.size(); ++i) {
                values[i] = ((CSimpleType)structTestTypes.get(i)).isSigned() && Math.floorMod(i, 2) == 1 ? BigInteger.valueOf(-i) : BigInteger.valueOf(i);
            }
            CType structType = this.makeElaboratedTypeFor((String)structTypeName, CComplexType.ComplexTypeKind.STRUCT, structTestTypes, structFieldNames);
            SMGState stateWithStruct = this.declareStructVariableWithSimpleTypeWithValuesOnTheStack(values, (String)variableName, structType, structTestTypes);
            SymbolicProgramConfiguration memoryModel = stateWithStruct.getMemoryModel();
            Truth.assertThat((Boolean)memoryModel.getStackFrames().peek().containsVariable((String)variableName)).isTrue();
            SMGObject memoryObject = memoryModel.getStackFrames().peek().getVariable((String)variableName);
            BigInteger sizeOfStructInBits = MACHINE_MODEL.getSizeofInBits(structType);
            Truth.assertThat((Boolean)(memoryObject.getSize().compareTo(sizeOfStructInBits) == 0 ? 1 : 0)).isTrue();
            Truth.assertThat((Boolean)memoryObject.isZero()).isFalse();
            for (int i = 0; i < structTestTypes.size(); ++i) {
                CType currentFieldType = structTestTypes.get(i);
                BigInteger expectedTypeSizeInBits = MACHINE_MODEL.getSizeofInBits(currentFieldType);
                BigInteger offsetInBits = MACHINE_MODEL.getFieldOffsetInBits((CCompositeType)((CElaboratedType)structType).getRealType(), structFieldNames.get(i));
                List<ValueAndSMGState> readValueAndState = stateWithStruct.readValue(memoryObject, offsetInBits, expectedTypeSizeInBits, null);
                Preconditions.checkArgument((readValueAndState.size() == 1 ? 1 : 0) != 0);
                Truth.assertThat((Boolean)readValueAndState.get(0).getValue().isNumericValue()).isTrue();
                Truth.assertThat((Boolean)(currentFieldType instanceof CSimpleType)).isTrue();
                BigInteger expectedValue = ((CSimpleType)currentFieldType).isSigned() && Math.floorMod(i, 2) == 1 ? BigInteger.valueOf(-i) : BigInteger.valueOf(i);
                Truth.assertThat((Boolean)(readValueAndState.get(0).getValue().asNumericValue().bigInteger().compareTo(expectedValue) == 0 ? 1 : 0)).isTrue();
            }
        }
    }

    @Test
    public void checkHeapStructWithAssignments() throws CPATransferException {
        String variableName = "testStruct";
        String structTypeName = "testStructType";
        for (int sublist = 1; sublist < STRUCT_UNION_TEST_TYPES.size(); ++sublist) {
            List<CType> structTestTypes = STRUCT_UNION_TEST_TYPES.subList(0, sublist);
            List<String> structFieldNames = STRUCT_UNION_FIELD_NAMES.subList(0, sublist);
            BigInteger[] values = new BigInteger[structTestTypes.size()];
            for (int i = 0; i < structTestTypes.size(); ++i) {
                values[i] = ((CSimpleType)structTestTypes.get(i)).isSigned() && Math.floorMod(i, 2) == 1 ? BigInteger.valueOf(-i) : BigInteger.valueOf(i);
            }
            CType structType = this.makeElaboratedTypeFor(structTypeName, CComplexType.ComplexTypeKind.STRUCT, structTestTypes, structFieldNames);
            SMGState stateWithStruct = this.declareStructVariableWithSimpleTypeWithValuesOnTheHeap(values, variableName, structType);
            SymbolicProgramConfiguration memoryModel = stateWithStruct.getMemoryModel();
            Truth.assertThat((Boolean)memoryModel.getStackFrames().peek().containsVariable(variableName)).isTrue();
            SMGObject memoryObject = memoryModel.getStackFrames().peek().getVariable(variableName);
            Truth.assertThat((Boolean)(memoryObject.getSize().compareTo(BigInteger.valueOf(POINTER_SIZE_IN_BITS)) == 0 ? 1 : 0)).isTrue();
            List<ValueAndSMGState> readAddressValueAndState = stateWithStruct.readValue(memoryObject, BigInteger.ZERO, BigInteger.valueOf(POINTER_SIZE_IN_BITS), null);
            Preconditions.checkArgument((readAddressValueAndState.size() == 1 ? 1 : 0) != 0);
            Value address = readAddressValueAndState.get(0).getValue();
            SMGStateAndOptionalSMGObjectAndOffset maybeTargetOfPointer = stateWithStruct.dereferencePointer(address).get(0);
            Truth.assertThat((Boolean)maybeTargetOfPointer.hasSMGObjectAndOffset()).isTrue();
            SMGStateAndOptionalSMGObjectAndOffset targetOfPointer = maybeTargetOfPointer;
            Truth.assertThat((Integer)targetOfPointer.getOffsetForObject().compareTo(BigInteger.ZERO)).isEqualTo((Object)0);
            SMGObject arrayMemoryObject = targetOfPointer.getSMGObject();
            Truth.assertThat((Boolean)arrayMemoryObject.isZero()).isFalse();
            for (int i = 0; i < structTestTypes.size(); ++i) {
                CType currentFieldType = structTestTypes.get(i);
                BigInteger expectedTypeSizeInBits = MACHINE_MODEL.getSizeofInBits(currentFieldType);
                BigInteger offsetInBits = MACHINE_MODEL.getFieldOffsetInBits((CCompositeType)((CElaboratedType)structType).getRealType(), structFieldNames.get(i));
                List<ValueAndSMGState> readValueAndState = stateWithStruct.readValue(arrayMemoryObject, offsetInBits, expectedTypeSizeInBits, null);
                Truth.assertThat((Boolean)readValueAndState.get(0).getValue().isNumericValue()).isTrue();
                Truth.assertThat((Boolean)(currentFieldType instanceof CSimpleType)).isTrue();
                BigInteger expectedValue = ((CSimpleType)currentFieldType).isSigned() && Math.floorMod(i, 2) == 1 ? BigInteger.valueOf(-i) : BigInteger.valueOf(i);
                Truth.assertThat((Boolean)(readValueAndState.get(0).getValue().asNumericValue().bigInteger().compareTo(expectedValue) == 0 ? 1 : 0)).isTrue();
            }
        }
    }

    @Test
    public void checkStackVariablesWithSimpleTypesAndValues() throws CPATransferException {
        for (CType type : TEST_TYPES) {
            String variableName = "testVariable_" + type;
            for (int i = 0; i < 2; ++i) {
                String variableNamePlus = variableName + i;
                BigInteger value = ((CSimpleType)type).isSigned() && Math.floorMod(i, 2) == 1 ? BigInteger.valueOf(-i) : BigInteger.valueOf(i);
                SMGState stateWithStruct = this.declareSimpleTypedTestVariablesWithValues(value, variableNamePlus, type);
                SymbolicProgramConfiguration memoryModel = stateWithStruct.getMemoryModel();
                Truth.assertThat((Boolean)memoryModel.getStackFrames().peek().containsVariable(variableNamePlus)).isTrue();
                SMGObject memoryObject = memoryModel.getStackFrames().peek().getVariable(variableNamePlus);
                BigInteger expectedTypeSizeInBits = MACHINE_MODEL.getSizeofInBits(type);
                Truth.assertThat((Boolean)(memoryObject.getSize().compareTo(expectedTypeSizeInBits) == 0 ? 1 : 0)).isTrue();
                List<ValueAndSMGState> readValueAndState = stateWithStruct.readValue(memoryObject, BigInteger.ZERO, expectedTypeSizeInBits, null);
                Preconditions.checkArgument((readValueAndState.size() == 1 ? 1 : 0) != 0);
                Truth.assertThat((Boolean)readValueAndState.get(0).getValue().isNumericValue()).isTrue();
                Truth.assertThat((Boolean)(readValueAndState.get(0).getValue().asNumericValue().bigInteger().compareTo(value) == 0 ? 1 : 0)).isTrue();
            }
        }
    }

    @Test
    public void testBasicTrueAssumptionWithTrueTruthAssumption() throws CPATransferException, InterruptedException {
        for (CType type : STRUCT_UNION_TEST_TYPES) {
            for (int i = -TEST_ARRAY_LENGTH.intValue(); i < TEST_ARRAY_LENGTH.intValue(); ++i) {
                BigInteger testValue = BigInteger.valueOf(i);
                if (type.equals(UNSIGNED_SHORT_TYPE) || type.equals(UNSIGNED_INT_TYPE) || type.equals(UNSIGNED_LONG_TYPE) || type.equals(CHAR_TYPE)) {
                    testValue = testValue.abs();
                }
                CBinaryExpression equality = type.equals(CHAR_TYPE) ? new CBinaryExpression(FileLocation.DUMMY, INT_TYPE, INT_TYPE, this.makeCharExpressionFrom((char)testValue.intValue()), this.makeCharExpressionFrom((char)testValue.intValue()), CBinaryExpression.BinaryOperator.EQUALS) : new CBinaryExpression(FileLocation.DUMMY, INT_TYPE, INT_TYPE, this.makeIntegerExpressionFrom(testValue, (CSimpleType)INT_TYPE), this.makeIntegerExpressionFrom(testValue, (CSimpleType)INT_TYPE), CBinaryExpression.BinaryOperator.EQUALS);
                Object statesAfter = this.transferRelation.handleAssumption(null, equality, true);
                Truth.assertThat((Iterable)statesAfter).hasSize(1);
                Iterator iterator = statesAfter.iterator();
                while (iterator.hasNext()) {
                    SMGState state = (SMGState)iterator.next();
                    Truth.assertThat((Object)state).isEqualTo((Object)this.initialState);
                }
            }
        }
    }

    @Test
    public void testBasicTrueAssumptionWithFalseTruthAssumption() throws CPATransferException, InterruptedException {
        for (CType type : STRUCT_UNION_TEST_TYPES) {
            for (int i = -TEST_ARRAY_LENGTH.intValue(); i < TEST_ARRAY_LENGTH.intValue(); ++i) {
                BigInteger testValue = BigInteger.valueOf(i);
                if (type.equals(UNSIGNED_SHORT_TYPE) || type.equals(UNSIGNED_INT_TYPE) || type.equals(UNSIGNED_LONG_TYPE) || type.equals(CHAR_TYPE)) {
                    testValue = testValue.abs();
                }
                CBinaryExpression equality = type.equals(CHAR_TYPE) ? new CBinaryExpression(FileLocation.DUMMY, INT_TYPE, INT_TYPE, this.makeCharExpressionFrom((char)testValue.intValue()), this.makeCharExpressionFrom((char)testValue.intValue()), CBinaryExpression.BinaryOperator.EQUALS) : new CBinaryExpression(FileLocation.DUMMY, INT_TYPE, INT_TYPE, this.makeIntegerExpressionFrom(testValue, (CSimpleType)INT_TYPE), this.makeIntegerExpressionFrom(testValue, (CSimpleType)INT_TYPE), CBinaryExpression.BinaryOperator.EQUALS);
                Object statesAfter = this.transferRelation.handleAssumption(null, equality, false);
                Truth.assertThat((Iterable)statesAfter).isNull();
            }
        }
    }

    @Test
    public void testHeapStructAddressEqualityTrueAssumptionWithTrueTruthAssumption() throws CPATransferException, InterruptedException {
        for (int sublist = 1; sublist < STRUCT_UNION_TEST_TYPES.size(); ++sublist) {
            String structTypeName = "testStructType" + sublist;
            String variableName1 = "testStruct1_" + sublist;
            String variableName2 = "testStruct2_" + sublist;
            List<CType> structTestTypes = STRUCT_UNION_TEST_TYPES.subList(0, sublist);
            List<String> structFieldNames = STRUCT_UNION_FIELD_NAMES.subList(0, sublist);
            BigInteger[] values = new BigInteger[structTestTypes.size()];
            for (int i = 0; i < structTestTypes.size(); ++i) {
                values[i] = ((CSimpleType)structTestTypes.get(i)).isSigned() && Math.floorMod(i, 2) == 1 ? BigInteger.valueOf(-i) : BigInteger.valueOf(i);
            }
            CType structType = this.makeElaboratedTypeFor(structTypeName, CComplexType.ComplexTypeKind.STRUCT, structTestTypes, structFieldNames);
            this.declareStructVariableWithSimpleTypeWithValuesOnTheHeap(values, variableName1, structType);
            this.declareStructVariableWithSimpleTypeWithValuesOnTheHeap(values, variableName2, structType);
            CBinaryExpression equality = new CBinaryExpression(FileLocation.DUMMY, INT_TYPE, INT_TYPE, new CIdExpression(FileLocation.DUMMY, new CPointerType(false, false, structType), variableName1, new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, new CPointerType(false, false, structType), variableName1, variableName1, variableName1, null)), new CIdExpression(FileLocation.DUMMY, new CPointerType(false, false, structType), variableName2, new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, new CPointerType(false, false, structType), variableName2, variableName2, variableName2, null)), CBinaryExpression.BinaryOperator.EQUALS);
            Object statesAfter = this.transferRelation.handleAssumption(null, equality, true);
            Truth.assertThat((Iterable)statesAfter).isNull();
        }
    }

    @Test
    public void testHeapArrayAddressEqualityFalseAssumptionWithTrueTruthAssumption() throws CPATransferException, InterruptedException {
        for (CType testType : ARRAY_TEST_TYPES) {
            String variableName1 = "testStruct1_" + testType;
            String variableName2 = "testStruct2_" + testType;
            BigInteger[] values = new BigInteger[TEST_ARRAY_LENGTH.intValue()];
            for (int i = 0; i < TEST_ARRAY_LENGTH.intValue(); ++i) {
                values[i] = ((CSimpleType)testType).isSigned() && Math.floorMod(i, 2) == 1 ? BigInteger.valueOf(-i) : BigInteger.valueOf(i);
            }
            this.declareArrayVariableWithSimpleTypeWithValuesOnTheHeap(TEST_ARRAY_LENGTH.intValue(), values, variableName1, testType);
            this.declareArrayVariableWithSimpleTypeWithValuesOnTheHeap(TEST_ARRAY_LENGTH.intValue(), values, variableName2, testType);
            CBinaryExpression equality = new CBinaryExpression(FileLocation.DUMMY, INT_TYPE, INT_TYPE, new CIdExpression(FileLocation.DUMMY, new CPointerType(false, false, testType), variableName1, new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, new CPointerType(false, false, testType), variableName1, variableName1, variableName1, null)), new CIdExpression(FileLocation.DUMMY, new CPointerType(false, false, testType), variableName2, new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, new CPointerType(false, false, testType), variableName2, variableName2, variableName2, null)), CBinaryExpression.BinaryOperator.EQUALS);
            Object statesAfter = this.transferRelation.handleAssumption(null, equality, true);
            Truth.assertThat((Iterable)statesAfter).isNull();
        }
    }

    @Test
    public void testBasicFalseAssumptionWithTrueTruthAssumption() throws CPATransferException, InterruptedException {
        for (CType type : STRUCT_UNION_TEST_TYPES) {
            for (int i = -TEST_ARRAY_LENGTH.intValue(); i < TEST_ARRAY_LENGTH.intValue(); ++i) {
                BigInteger testValue = BigInteger.valueOf(i);
                BigInteger secondValue = testValue.add(BigInteger.ONE);
                if (type.equals(UNSIGNED_SHORT_TYPE) || type.equals(UNSIGNED_INT_TYPE) || type.equals(UNSIGNED_LONG_TYPE) || type.equals(CHAR_TYPE)) {
                    testValue = testValue.abs();
                    secondValue = secondValue.abs();
                }
                CBinaryExpression equality = type.equals(CHAR_TYPE) ? new CBinaryExpression(FileLocation.DUMMY, INT_TYPE, INT_TYPE, this.makeCharExpressionFrom((char)testValue.intValue()), this.makeCharExpressionFrom((char)secondValue.intValue()), CBinaryExpression.BinaryOperator.EQUALS) : new CBinaryExpression(FileLocation.DUMMY, INT_TYPE, INT_TYPE, this.makeIntegerExpressionFrom(testValue, (CSimpleType)INT_TYPE), this.makeIntegerExpressionFrom(secondValue, (CSimpleType)INT_TYPE), CBinaryExpression.BinaryOperator.EQUALS);
                Object statesAfter = this.transferRelation.handleAssumption(null, equality, true);
                Truth.assertThat((Iterable)statesAfter).isNull();
            }
        }
    }

    @Test
    public void testBasicFalseAssumptionWithFalseTruthAssumption() throws CPATransferException, InterruptedException {
        for (CType type : STRUCT_UNION_TEST_TYPES) {
            for (int i = -TEST_ARRAY_LENGTH.intValue(); i < TEST_ARRAY_LENGTH.intValue(); ++i) {
                BigInteger testValue = BigInteger.valueOf(i);
                BigInteger secondValue = testValue.add(BigInteger.ONE);
                if (type.equals(UNSIGNED_SHORT_TYPE) || type.equals(UNSIGNED_INT_TYPE) || type.equals(UNSIGNED_LONG_TYPE) || type.equals(CHAR_TYPE)) {
                    testValue = testValue.abs();
                    secondValue = secondValue.abs();
                }
                CBinaryExpression equality = type.equals(CHAR_TYPE) ? new CBinaryExpression(FileLocation.DUMMY, INT_TYPE, INT_TYPE, this.makeCharExpressionFrom((char)testValue.intValue()), this.makeCharExpressionFrom((char)secondValue.intValue()), CBinaryExpression.BinaryOperator.EQUALS) : new CBinaryExpression(FileLocation.DUMMY, INT_TYPE, INT_TYPE, this.makeIntegerExpressionFrom(testValue, (CSimpleType)INT_TYPE), this.makeIntegerExpressionFrom(secondValue, (CSimpleType)INT_TYPE), CBinaryExpression.BinaryOperator.EQUALS);
                Object statesAfter = this.transferRelation.handleAssumption(null, equality, false);
                Truth.assertThat((Iterable)statesAfter).hasSize(1);
                Iterator iterator = statesAfter.iterator();
                while (iterator.hasNext()) {
                    SMGState state = (SMGState)iterator.next();
                    Truth.assertThat((Object)state).isEqualTo((Object)this.initialState);
                }
            }
        }
    }

    private SMGState declareSimpleTypedTestVariablesWithValues(BigInteger value, String variableName, CType type) throws CPATransferException {
        CExpression exprToInit = type == CNumericTypes.CHAR ? this.makeCharExpressionFrom((char)value.intValue()) : this.makeIntegerExpressionFrom(value, (CSimpleType)type);
        CInitializer initializer = this.makeCInitializerExpressionFor(exprToInit);
        Object statesAfterDecl = this.transferRelation.handleDeclarationEdge(null, this.declareVariableWithInitializer(variableName, type, false, false, initializer));
        Truth.assertThat((Iterable)statesAfterDecl).hasSize(1);
        SMGState state = (SMGState)statesAfterDecl.get(0);
        this.transferRelation.setInfo(state, null, new CDeclarationEdge("", FileLocation.DUMMY, CFANode.newDummyCFANode(), CFANode.newDummyCFANode(), null));
        return state;
    }

    private SMGState declareArrayVariableWithSimpleTypeWithValuesOnTheStack(int size, BigInteger[] values, String variableName, CType type) throws CPATransferException {
        Preconditions.checkArgument((values.length == size ? 1 : 0) != 0);
        ImmutableList.Builder listOfInitsBuilder = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            CExpression exprToInit = type == CNumericTypes.CHAR ? this.makeCharExpressionFrom((char)values[i].intValue()) : this.makeIntegerExpressionFrom(values[i], (CSimpleType)type);
            listOfInitsBuilder.add((Object)this.makeCInitializerExpressionFor(exprToInit));
        }
        CInitializer initList = this.makeCInitializerListFor((List<CInitializer>)listOfInitsBuilder.build());
        CType arrayType = this.makeArrayTypeFor(type, BigInteger.valueOf(size));
        Object statesAfterDecl = this.transferRelation.handleDeclarationEdge(null, this.declareVariableWithInitializer(variableName, arrayType, false, false, initList));
        Truth.assertThat((Iterable)statesAfterDecl).hasSize(1);
        SMGState state = (SMGState)statesAfterDecl.get(0);
        this.transferRelation.setInfo(state, null, new CDeclarationEdge("", FileLocation.DUMMY, CFANode.newDummyCFANode(), CFANode.newDummyCFANode(), null));
        SMGState lastState = state;
        BigInteger index = BigInteger.ZERO;
        for (BigInteger value : values) {
            ALiteralExpression valueExpr;
            if (type.equals(CHAR_TYPE)) {
                valueExpr = new CCharLiteralExpression(FileLocation.DUMMY, type, (char)value.intValueExact());
            } else if (type instanceof CSimpleType) {
                valueExpr = new CIntegerLiteralExpression(FileLocation.DUMMY, type, value);
            } else {
                throw new RuntimeException("Unsupported type in struct test type. Add the handling to where the exception is thrown.");
            }
            CExpressionAssignmentStatement assignmentExpr = new CExpressionAssignmentStatement(FileLocation.DUMMY, new CArraySubscriptExpression(FileLocation.DUMMY, type, new CIdExpression(FileLocation.DUMMY, arrayType, variableName, new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, arrayType, variableName, variableName, variableName, null)), new CIntegerLiteralExpression(FileLocation.DUMMY, INT_TYPE, index)), (CExpression)((Object)valueExpr));
            Object statesAfterAssign = this.transferRelation.handleStatementEdge(null, assignmentExpr);
            Truth.assertThat((Iterable)statesAfterAssign).hasSize(1);
            SMGState newState = state;
            Iterator iterator = statesAfterAssign.iterator();
            while (iterator.hasNext()) {
                SMGState stateAS;
                newState = stateAS = (SMGState)iterator.next();
            }
            this.transferRelation.setInfo(newState, null, new CDeclarationEdge("", FileLocation.DUMMY, CFANode.newDummyCFANode(), CFANode.newDummyCFANode(), null));
            lastState = newState;
            index = index.add(BigInteger.ONE);
        }
        return lastState;
    }

    private SMGState declareArrayVariableWithSimpleTypeWithValuesOnTheHeap(int size, BigInteger[] values, String variableName, CType type) throws CPATransferException {
        SMGState stateAfterMallocAssignSuccess;
        Preconditions.checkArgument((values.length == size ? 1 : 0) != 0);
        CPointerType pointerType = new CPointerType(false, false, type);
        CIntegerLiteralExpression sizeExpression = new CIntegerLiteralExpression(FileLocation.DUMMY, INT_TYPE, BigInteger.valueOf(size).multiply(MACHINE_MODEL.getSizeof(type)));
        Object statesAfterDecl = this.transferRelation.handleDeclarationEdge(null, this.declareVariableWithoutInitializer(variableName, pointerType, false, false));
        Truth.assertThat((Iterable)statesAfterDecl).hasSize(1);
        SMGState stateAfterDecl = (SMGState)statesAfterDecl.get(0);
        CFunctionCallAssignmentStatement mallocAndAssignmentExpr = new CFunctionCallAssignmentStatement(FileLocation.DUMMY, new CIdExpression(FileLocation.DUMMY, pointerType, variableName, this.declareVariableWithoutInitializer(variableName, pointerType, false, false)), this.makeMalloc(sizeExpression));
        CStatementEdge mallocAndAssignmentEdge = new CStatementEdge(pointerType + " " + variableName + " = malloc(" + sizeExpression.toASTString() + ")", mallocAndAssignmentExpr, FileLocation.DUMMY, CFANode.newDummyCFANode(), CFANode.newDummyCFANode());
        this.transferRelation.setInfo(stateAfterDecl, null, mallocAndAssignmentEdge);
        Object statesAfterMallocAssign = this.transferRelation.handleStatementEdge(mallocAndAssignmentEdge, mallocAndAssignmentExpr);
        Truth.assertThat((Boolean)(statesAfterMallocAssign instanceof List)).isTrue();
        List statesListAfterMallocAssign = (List)statesAfterMallocAssign;
        if (size == 0 || !this.smgOptions.isEnableMallocFailure()) {
            Truth.assertThat((Iterable)statesListAfterMallocAssign).hasSize(1);
            stateAfterMallocAssignSuccess = (SMGState)statesListAfterMallocAssign.get(0);
        } else {
            Truth.assertThat((Iterable)statesListAfterMallocAssign).hasSize(2);
            SMGState stateAfterMallocAssignFailure = (SMGState)statesListAfterMallocAssign.get(1);
            if (!this.checkMallocFailure(stateAfterMallocAssignFailure, variableName, pointerType)) {
                stateAfterMallocAssignFailure = (SMGState)statesListAfterMallocAssign.get(0);
                stateAfterMallocAssignSuccess = (SMGState)statesListAfterMallocAssign.get(1);
                Truth.assertThat((Boolean)this.checkMallocFailure(stateAfterMallocAssignFailure, variableName, pointerType)).isTrue();
            } else {
                stateAfterMallocAssignSuccess = (SMGState)statesListAfterMallocAssign.get(0);
            }
        }
        this.transferRelation.setInfo(stateAfterMallocAssignSuccess, null, new CDeclarationEdge("", FileLocation.DUMMY, CFANode.newDummyCFANode(), CFANode.newDummyCFANode(), null));
        BigInteger index = BigInteger.ZERO;
        SMGState lastState = stateAfterDecl;
        for (BigInteger value : values) {
            ALiteralExpression valueExpr;
            if (type.equals(CHAR_TYPE)) {
                valueExpr = new CCharLiteralExpression(FileLocation.DUMMY, type, (char)value.intValueExact());
            } else if (type instanceof CSimpleType) {
                valueExpr = new CIntegerLiteralExpression(FileLocation.DUMMY, type, value);
            } else {
                throw new RuntimeException("Unsupported type in struct test type. Add the handling to where the exception is thrown.");
            }
            CExpressionAssignmentStatement assignmentExpr = new CExpressionAssignmentStatement(FileLocation.DUMMY, new CArraySubscriptExpression(FileLocation.DUMMY, type, new CIdExpression(FileLocation.DUMMY, new CPointerType(false, false, type), variableName, new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, new CPointerType(false, false, type), variableName, variableName, variableName, null)), new CIntegerLiteralExpression(FileLocation.DUMMY, INT_TYPE, index)), (CExpression)((Object)valueExpr));
            index = index.add(BigInteger.ONE);
            Object statesAfterAssign = this.transferRelation.handleStatementEdge(null, assignmentExpr);
            Truth.assertThat((Iterable)statesAfterAssign).hasSize(1);
            SMGState newState = lastState;
            Iterator iterator = statesAfterAssign.iterator();
            while (iterator.hasNext()) {
                SMGState stateAS;
                newState = stateAS = (SMGState)iterator.next();
            }
            this.transferRelation.setInfo(newState, null, new CDeclarationEdge("", FileLocation.DUMMY, CFANode.newDummyCFANode(), CFANode.newDummyCFANode(), null));
            lastState = newState;
        }
        return lastState;
    }

    private SMGState declareStructVariableWithSimpleTypeWithValuesOnTheStack(BigInteger[] values, String variableName, CType structType, List<CType> types) throws CPATransferException {
        ImmutableList.Builder listOfInitsBuilder = ImmutableList.builder();
        for (int i = 0; i < types.size(); ++i) {
            CType currType = types.get(i);
            BigInteger value = values[i];
            CExpression exprToInit = currType == CNumericTypes.CHAR ? this.makeCharExpressionFrom((char)value.intValue()) : this.makeIntegerExpressionFrom(value, (CSimpleType)currType);
            listOfInitsBuilder.add((Object)this.makeCInitializerExpressionFor(exprToInit));
            value = value.add(BigInteger.ONE);
        }
        CInitializer initList = this.makeCInitializerListFor((List<CInitializer>)listOfInitsBuilder.build());
        Object statesAfterDecl = this.transferRelation.handleDeclarationEdge(null, this.declareVariableWithInitializer(variableName, structType, false, false, initList));
        Truth.assertThat((Iterable)statesAfterDecl).hasSize(1);
        SMGState state = (SMGState)statesAfterDecl.get(0);
        this.transferRelation.setInfo(state, null, new CDeclarationEdge("", FileLocation.DUMMY, CFANode.newDummyCFANode(), CFANode.newDummyCFANode(), null));
        return state;
    }

    private SMGState declareStructVariableWithSimpleTypeWithValuesOnTheHeap(BigInteger[] values, String variableName, CType type) throws CPATransferException {
        SMGState stateAfterMallocAssignSuccess;
        CPointerType pointerType = new CPointerType(false, false, type);
        CIntegerLiteralExpression sizeExpression = new CIntegerLiteralExpression(FileLocation.DUMMY, INT_TYPE, MACHINE_MODEL.getSizeof(type));
        Object statesAfterDecl = this.transferRelation.handleDeclarationEdge(null, this.declareVariableWithoutInitializer(variableName, pointerType, false, false));
        Truth.assertThat((Iterable)statesAfterDecl).hasSize(1);
        SMGState stateAfterDecl = (SMGState)statesAfterDecl.get(0);
        CFunctionCallAssignmentStatement mallocAndAssignmentExpr = new CFunctionCallAssignmentStatement(FileLocation.DUMMY, new CIdExpression(FileLocation.DUMMY, new CPointerType(false, false, pointerType), variableName, this.declareVariableWithoutInitializer(variableName, pointerType, false, false)), this.makeMalloc(sizeExpression));
        CStatementEdge mallocAndAssignmentEdge = new CStatementEdge(pointerType + " " + variableName + " = malloc(" + sizeExpression.toASTString() + ")", mallocAndAssignmentExpr, FileLocation.DUMMY, CFANode.newDummyCFANode(), CFANode.newDummyCFANode());
        this.transferRelation.setInfo(stateAfterDecl, null, mallocAndAssignmentEdge);
        Object statesAfterMallocAssign = this.transferRelation.handleStatementEdge(mallocAndAssignmentEdge, mallocAndAssignmentExpr);
        Truth.assertThat((Boolean)(statesAfterMallocAssign instanceof List)).isTrue();
        List statesListAfterMallocAssign = (List)statesAfterMallocAssign;
        if (MACHINE_MODEL.getSizeof(type).intValue() == 0 || !this.smgOptions.isEnableMallocFailure()) {
            Truth.assertThat((Iterable)statesListAfterMallocAssign).hasSize(1);
            stateAfterMallocAssignSuccess = (SMGState)statesListAfterMallocAssign.get(0);
        } else {
            Truth.assertThat((Iterable)statesListAfterMallocAssign).hasSize(2);
            SMGState stateAfterMallocAssignFailure = (SMGState)statesListAfterMallocAssign.get(1);
            if (!this.checkMallocFailure(stateAfterMallocAssignFailure, variableName, pointerType)) {
                stateAfterMallocAssignFailure = (SMGState)statesListAfterMallocAssign.get(0);
                stateAfterMallocAssignSuccess = (SMGState)statesListAfterMallocAssign.get(1);
                Truth.assertThat((Boolean)this.checkMallocFailure(stateAfterMallocAssignFailure, variableName, pointerType)).isTrue();
            } else {
                stateAfterMallocAssignSuccess = (SMGState)statesListAfterMallocAssign.get(0);
            }
        }
        this.transferRelation.setInfo(stateAfterMallocAssignSuccess, null, mallocAndAssignmentEdge);
        Truth.assertThat((Boolean)(type instanceof CElaboratedType)).isTrue();
        CElaboratedType ceType = (CElaboratedType)type;
        Truth.assertThat((Boolean)(ceType.getRealType() instanceof CCompositeType)).isTrue();
        List<CCompositeType.CCompositeTypeMemberDeclaration> members = ((CCompositeType)ceType.getRealType()).getMembers();
        Truth.assertThat(members).hasSize(values.length);
        SMGState lastState = stateAfterMallocAssignSuccess;
        for (int i = 0; i < members.size(); ++i) {
            ALiteralExpression valueExpr;
            CCompositeType.CCompositeTypeMemberDeclaration member = members.get(i);
            BigInteger value = values[i];
            CType memberType = member.getType();
            String memberName = member.getName();
            if (memberType.equals(CHAR_TYPE)) {
                valueExpr = new CCharLiteralExpression(FileLocation.DUMMY, memberType, (char)value.intValueExact());
            } else if (memberType instanceof CSimpleType) {
                valueExpr = new CIntegerLiteralExpression(FileLocation.DUMMY, memberType, value);
            } else {
                throw new RuntimeException("Unsupported type in struct test type. Add the handling to where the exception is thrown.");
            }
            CExpressionAssignmentStatement assignExpr = new CExpressionAssignmentStatement(FileLocation.DUMMY, new CFieldReference(FileLocation.DUMMY, memberType, memberName, new CIdExpression(FileLocation.DUMMY, pointerType, variableName, new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, pointerType, variableName, variableName, variableName, null)), true), (CExpression)((Object)valueExpr));
            Object statesAfterAssign = this.transferRelation.handleStatementEdge(null, assignExpr);
            Truth.assertThat((Iterable)statesAfterAssign).hasSize(1);
            SMGState stateAfterAssign = stateAfterDecl;
            Iterator iterator = statesAfterAssign.iterator();
            while (iterator.hasNext()) {
                SMGState stateAS;
                stateAfterAssign = stateAS = (SMGState)iterator.next();
            }
            this.transferRelation.setInfo(stateAfterAssign, null, mallocAndAssignmentEdge);
            lastState = stateAfterAssign;
        }
        return lastState;
    }

    private CFunctionCallExpression makeMalloc(CExpression sizeExpr) {
        CFunctionType mallocType = new CFunctionType(CPointerType.POINTER_TO_VOID, Collections.singletonList(CNumericTypes.INT), false);
        CFunctionDeclaration mallocFunctionDeclaration = new CFunctionDeclaration(FileLocation.DUMMY, mallocType, "malloc", (List<CParameterDeclaration>)ImmutableList.of((Object)new CParameterDeclaration(FileLocation.DUMMY, CPointerType.POINTER_TO_VOID, "size")), (ImmutableSet<CFunctionDeclaration.FunctionAttribute>)ImmutableSet.of());
        return new CFunctionCallExpression(FileLocation.DUMMY, CPointerType.POINTER_TO_VOID, new CIdExpression(FileLocation.DUMMY, mallocFunctionDeclaration), Collections.singletonList(sizeExpr), mallocFunctionDeclaration);
    }

    private CVariableDeclaration declareVariableWithoutInitializer(String variableName, CType type, boolean isGlobal, boolean isExtern) {
        return this.declareVariableWithInitializer(variableName, type, isGlobal, isExtern, null);
    }

    private CVariableDeclaration declareVariableWithInitializer(String variableName, CType type, boolean isGlobal, boolean isExtern, CInitializer initializer) {
        CStorageClass storage = CStorageClass.AUTO;
        if (isExtern) {
            storage = CStorageClass.EXTERN;
        }
        return new CVariableDeclaration(FileLocation.DUMMY, isGlobal, storage, type, variableName, variableName, variableName, initializer);
    }

    private CType makeElaboratedTypeFor(String structureName, CComplexType.ComplexTypeKind complexTypeKind, List<CType> listOfTypes, List<String> fieldNames) {
        ImmutableList.Builder typeBuilder = new ImmutableList.Builder();
        for (int i = 0; i < listOfTypes.size(); ++i) {
            typeBuilder.add((Object)new CCompositeType.CCompositeTypeMemberDeclaration(listOfTypes.get(i), fieldNames.get(i)));
        }
        CCompositeType realType = new CCompositeType(false, false, complexTypeKind, (List<CCompositeType.CCompositeTypeMemberDeclaration>)typeBuilder.build(), structureName, structureName);
        return new CElaboratedType(false, false, complexTypeKind, structureName, structureName, realType);
    }

    private CType makeArrayTypeFor(CType elementType, CExpression length) {
        return new CArrayType(false, false, elementType, length);
    }

    private CType makeArrayTypeFor(CType elementType, BigInteger length) {
        return this.makeArrayTypeFor(elementType, new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.INT, length));
    }

    private CType makePointerTypeFor(CType pointerType) {
        return new CPointerType(false, false, pointerType);
    }

    private CInitializer makeCInitializerExpressionFor(CExpression expr) {
        return new CInitializerExpression(FileLocation.DUMMY, expr);
    }

    private CInitializer makeCInitializerListFor(List<CInitializer> list) {
        return new CInitializerList(FileLocation.DUMMY, list);
    }

    private CIntegerLiteralExpression makeIntegerExpressionFrom(BigInteger value, CSimpleType type) {
        Preconditions.checkArgument((value.compareTo(MACHINE_MODEL.getMinimalIntegerValue(type)) >= 0 && value.compareTo(MACHINE_MODEL.getMaximalIntegerValue(type)) <= 0 ? 1 : 0) != 0);
        return new CIntegerLiteralExpression(FileLocation.DUMMY, type, value);
    }

    private CExpression makeCharExpressionFrom(char value) {
        return new CCharLiteralExpression(FileLocation.DUMMY, CNumericTypes.CHAR, value);
    }

    private CType makeNestedStruct(String structName, List<CType> structTypesList, List<String> structFieldNames, List<CType> nestedStructTypesList, List<String> nestedStructFieldNames, String nestedStructName, List<CType> arrayTypesList, List<CType> pointerTypesList) {
        ImmutableList.Builder listTypesTop = ImmutableList.builder();
        listTypesTop.addAll(structTypesList);
        listTypesTop.add((Object)this.makeElaboratedTypeFor(nestedStructName, CComplexType.ComplexTypeKind.STRUCT, nestedStructTypesList, nestedStructFieldNames));
        for (CType arrayType : arrayTypesList) {
            listTypesTop.add((Object)this.makeArrayTypeFor(arrayType, TEST_ARRAY_LENGTH));
        }
        for (CType pointerType : pointerTypesList) {
            listTypesTop.add((Object)this.makePointerTypeFor(pointerType));
        }
        return this.makeElaboratedTypeFor(structName, CComplexType.ComplexTypeKind.STRUCT, (List<CType>)listTypesTop.build(), structFieldNames);
    }

    private CInitializer makeInitializerForNestedStruct(BigInteger beginningValue, List<CType> structTypesList, List<CType> nestedStructTypesList, List<CType> arrayTypesList, List<CType> pointerTypesList) {
        BigInteger value = beginningValue;
        ImmutableList.Builder topStructInitList = ImmutableList.builder();
        for (CType type : structTypesList) {
            CExpression exprToInit = type == CNumericTypes.CHAR ? this.makeCharExpressionFrom((char)value.intValue()) : this.makeIntegerExpressionFrom(value, (CSimpleType)type);
            topStructInitList.add((Object)this.makeCInitializerExpressionFor(exprToInit));
            value = value.add(BigInteger.ONE);
        }
        ImmutableList.Builder nestedStructInitList = ImmutableList.builder();
        for (CType type : nestedStructTypesList) {
            CExpression exprToInit = type == CNumericTypes.CHAR ? this.makeCharExpressionFrom((char)value.intValue()) : this.makeIntegerExpressionFrom(value, (CSimpleType)type);
            nestedStructInitList.add((Object)this.makeCInitializerExpressionFor(exprToInit));
            value = value.add(BigInteger.ONE);
        }
        topStructInitList.add((Object)this.makeCInitializerListFor((List<CInitializer>)nestedStructInitList.build()));
        for (CType type : arrayTypesList) {
            topStructInitList.add((Object)this.makeArrayInitializer(value, TEST_ARRAY_LENGTH.intValue(), type));
            value = value.add(TEST_ARRAY_LENGTH);
        }
        for (CType type : pointerTypesList) {
            topStructInitList.add((Object)this.makeCInitializerExpressionFor(this.makeIntegerExpressionFrom(BigInteger.ZERO, (CSimpleType)INT_TYPE)));
        }
        return this.makeCInitializerListFor((List<CInitializer>)topStructInitList.build());
    }

    private CInitializer makeArrayInitializer(BigInteger beginningValue, int length, CType type) {
        ImmutableList.Builder arrayInitList = ImmutableList.builder();
        BigInteger value = beginningValue;
        for (int i = 0; i < length; ++i) {
            CExpression exprToInit = type == CNumericTypes.CHAR ? this.makeCharExpressionFrom((char)value.intValue()) : this.makeIntegerExpressionFrom(value, (CSimpleType)type);
            arrayInitList.add((Object)this.makeCInitializerExpressionFor(exprToInit));
            value = value.add(BigInteger.ONE);
        }
        return this.makeCInitializerListFor((List<CInitializer>)arrayInitList.build());
    }
}

