/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedLongs;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPABuiltins;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMG2Exception;
import org.sosy_lab.cpachecker.cpa.smg2.util.value.SMGCPAExpressionEvaluator;
import org.sosy_lab.cpachecker.cpa.smg2.util.value.ValueAndSMGState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.AddressExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.ConstantSymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicIdentifier;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValue;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueFactory;
import org.sosy_lab.cpachecker.cpa.value.type.FunctionValue;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.BuiltinFloatFunctions;
import org.sosy_lab.cpachecker.util.BuiltinFunctions;
import org.sosy_lab.cpachecker.util.BuiltinOverflowFunctions;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class SMGCPAValueVisitor
extends DefaultCExpressionVisitor<List<ValueAndSMGState>, CPATransferException>
implements CRightHandSideVisitor<List<ValueAndSMGState>, CPATransferException> {
    private static final int SIZE_OF_JAVA_LONG = 64;
    private final SMGCPAExpressionEvaluator evaluator;
    private final SMGState state;
    private final CFAEdge cfaEdge;
    private final LogManagerWithoutDuplicates logger;

    public SMGCPAValueVisitor(SMGCPAExpressionEvaluator pEvaluator, SMGState currentState, CFAEdge edge, LogManagerWithoutDuplicates pLogger) {
        this.evaluator = pEvaluator;
        this.state = currentState;
        this.cfaEdge = edge;
        this.logger = pLogger;
    }

    public List<ValueAndSMGState> evaluate(CRightHandSide pExp, CType pTargetType) throws CPATransferException {
        List<ValueAndSMGState> uncastedValuesAndStates = pExp.accept(this);
        ImmutableList.Builder result = ImmutableList.builder();
        for (ValueAndSMGState uncastedValueAndState : uncastedValuesAndStates) {
            Value castedValue = this.castCValue(uncastedValueAndState.getValue(), pTargetType, this.evaluator.getMachineModel());
            result.add((Object)ValueAndSMGState.of(castedValue, uncastedValueAndState.getState()));
        }
        return result.build();
    }

    @Override
    protected List<ValueAndSMGState> visitDefault(CExpression pExp) throws CPATransferException {
        this.logger.logf(Level.INFO, "%s, Default value: CExpression %s could not be recognized and the default value %s was used for its value. Related CFAEdge: %s", new Object[]{this.cfaEdge.getFileLocation(), pExp, SMGValue.zeroValue(), this.cfaEdge.getRawStatement()});
        return ImmutableList.of((Object)ValueAndSMGState.of(Value.UnknownValue.getInstance(), this.state));
    }

    @Override
    public List<ValueAndSMGState> visit(CFunctionCallExpression pIastFunctionCallExpression) throws CPATransferException {
        return this.handleFunctions(pIastFunctionCallExpression);
    }

    @Override
    public List<ValueAndSMGState> visit(CArraySubscriptExpression e) throws CPATransferException {
        CExpression arrayExpr = e.getArrayExpression();
        CType returnType = SMGCPAExpressionEvaluator.getCanonicalType(e.getExpressionType());
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (ValueAndSMGState arrayValueAndState : arrayExpr.accept(this)) {
            Value arrayValue = arrayValueAndState.getValue();
            SMGState currentState = arrayValueAndState.getState();
            if (currentState.getMemoryModel().isPointer(arrayValue)) {
                arrayValue = AddressExpression.withZeroOffset(arrayValue, SMGCPAExpressionEvaluator.getCanonicalType(arrayExpr));
            } else if (!SMGCPAExpressionEvaluator.valueIsAddressExprOrVariableOffset(arrayValue)) {
                resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(currentState));
                continue;
            }
            CExpression subscriptExpr = e.getSubscriptExpression();
            List<ValueAndSMGState> subscriptValueAndStates = subscriptExpr.accept(new SMGCPAValueVisitor(this.evaluator, currentState, this.cfaEdge, this.logger));
            for (ValueAndSMGState subscriptValueAndState : subscriptValueAndStates) {
                Value subscriptValue = subscriptValueAndState.getValue();
                SMGState newState = subscriptValueAndState.getState();
                if (!subscriptValue.isNumericValue()) {
                    resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(newState.withUnknownOffsetMemoryAccess()));
                    continue;
                }
                BigInteger typeSizeInBits = this.evaluator.getBitSizeof(newState, returnType);
                BigInteger subscriptOffset = typeSizeInBits.multiply(subscriptValue.asNumericValue().bigInteger());
                if (arrayExpr.getExpressionType() instanceof CPointerType) {
                    Preconditions.checkArgument((boolean)(arrayValue instanceof AddressExpression));
                } else if (arrayExpr.getExpressionType() instanceof CCompositeType || arrayExpr.getExpressionType() instanceof CElaboratedType || arrayExpr.getExpressionType() instanceof CArrayType || arrayExpr.getExpressionType() instanceof CTypedefType) {
                    if (arrayValue instanceof SymbolicIdentifier) {
                        Preconditions.checkArgument((boolean)((SymbolicIdentifier)arrayValue).getRepresentedLocation().isPresent());
                    } else {
                        Preconditions.checkArgument((boolean)(arrayValue instanceof AddressExpression));
                    }
                } else {
                    if (arrayValue instanceof SymbolicIdentifier) {
                        Preconditions.checkArgument((boolean)((SymbolicIdentifier)arrayValue).getRepresentedLocation().isEmpty());
                    }
                    Preconditions.checkArgument((!(arrayValue instanceof AddressExpression) ? 1 : 0) != 0);
                }
                resultBuilder.addAll(this.evaluateReadOfValueAndOffset(arrayValue, subscriptOffset, returnType, newState));
            }
        }
        return resultBuilder.build();
    }

    private List<ValueAndSMGState> evaluateReadOfValueAndOffset(Value arrayValue, BigInteger additionalOffset, CType pReturnType, SMGState pCurrentState) throws CPATransferException {
        SMGState newState = pCurrentState;
        CType returnType = SMGCPAExpressionEvaluator.getCanonicalType(pReturnType);
        BigInteger typeSizeInBits = this.evaluator.getBitSizeof(newState, returnType);
        if (arrayValue instanceof AddressExpression) {
            AddressExpression arrayAddr = (AddressExpression)arrayValue;
            Value addrOffsetValue = arrayAddr.getOffset();
            if (!addrOffsetValue.isNumericValue()) {
                return ImmutableList.of((Object)ValueAndSMGState.ofUnknownValue(newState));
            }
            BigInteger finalOffset = addrOffsetValue.asNumericValue().bigInteger().add(additionalOffset);
            if (SMGCPAExpressionEvaluator.isStructOrUnionType(returnType) || returnType instanceof CArrayType || returnType instanceof CFunctionType) {
                return ImmutableList.of((Object)ValueAndSMGState.of(arrayAddr.copyWithNewOffset(new NumericValue(finalOffset)), newState));
            }
            if (returnType instanceof CPointerType) {
                ImmutableList.Builder returnBuilder = ImmutableList.builder();
                for (ValueAndSMGState readPointerAndState : this.evaluator.readValueWithPointerDereference(newState, arrayAddr.getMemoryAddress(), finalOffset, typeSizeInBits, returnType)) {
                    newState = readPointerAndState.getState();
                    if (readPointerAndState.getValue().isUnknown()) {
                        returnBuilder.add((Object)ValueAndSMGState.ofUnknownValue(newState));
                        continue;
                    }
                    returnBuilder.add((Object)ValueAndSMGState.of(AddressExpression.withZeroOffset(readPointerAndState.getValue(), returnType), newState));
                }
                return returnBuilder.build();
            }
            return this.evaluator.readValueWithPointerDereference(newState, arrayAddr.getMemoryAddress(), finalOffset, typeSizeInBits, returnType);
        }
        if (arrayValue instanceof SymbolicIdentifier && ((SymbolicIdentifier)arrayValue).getRepresentedLocation().isPresent()) {
            MemoryLocation memloc = ((SymbolicIdentifier)arrayValue).getRepresentedLocation().orElseThrow();
            String qualifiedVarName = memloc.getIdentifier();
            BigInteger finalOffset = BigInteger.valueOf(memloc.getOffset()).add(additionalOffset);
            if (SMGCPAExpressionEvaluator.isStructOrUnionType(returnType) || returnType instanceof CArrayType || returnType instanceof CFunctionType) {
                return ImmutableList.of((Object)ValueAndSMGState.of(SymbolicValueFactory.getInstance().newIdentifier(memloc.withAddedOffset(additionalOffset.longValueExact())), newState));
            }
            if (returnType instanceof CPointerType) {
                ImmutableList.Builder returnBuilder = ImmutableList.builder();
                for (ValueAndSMGState readPointerAndState : this.evaluator.readStackOrGlobalVariable(newState, qualifiedVarName, finalOffset, typeSizeInBits, returnType)) {
                    newState = readPointerAndState.getState();
                    if (readPointerAndState.getValue().isUnknown()) {
                        returnBuilder.add((Object)ValueAndSMGState.ofUnknownValue(newState));
                        continue;
                    }
                    returnBuilder.add((Object)ValueAndSMGState.of(AddressExpression.withZeroOffset(readPointerAndState.getValue(), returnType), newState));
                }
                return returnBuilder.build();
            }
            return this.evaluator.readStackOrGlobalVariable(newState, qualifiedVarName, finalOffset, typeSizeInBits, returnType);
        }
        return ImmutableList.of((Object)ValueAndSMGState.ofUnknownValue(newState));
    }

    @Override
    public List<ValueAndSMGState> visit(CBinaryExpression e) throws CPATransferException {
        CBinaryExpression.BinaryOperator binaryOperator = e.getOperator();
        CType calculationType = e.getCalculationType();
        CExpression lVarInBinaryExp = e.getOperand1();
        CExpression rVarInBinaryExp = e.getOperand2();
        CType returnType = SMGCPAExpressionEvaluator.getCanonicalType(e.getExpressionType());
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (ValueAndSMGState leftValueAndState : lVarInBinaryExp.accept(this)) {
            Value leftValue = leftValueAndState.getValue();
            SMGState currentState = leftValueAndState.getState();
            if (leftValue.isUnknown()) {
                resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(currentState));
                continue;
            }
            for (ValueAndSMGState rightValueAndState : rVarInBinaryExp.accept(new SMGCPAValueVisitor(this.evaluator, leftValueAndState.getState(), this.cfaEdge, this.logger))) {
                currentState = rightValueAndState.getState();
                Value rightValue = rightValueAndState.getValue();
                if (rightValue.isUnknown()) {
                    resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(currentState));
                    continue;
                }
                ValueAndSMGState castLeftValue = this.castCValue(leftValue, calculationType, currentState);
                leftValue = castLeftValue.getValue();
                currentState = castLeftValue.getState();
                if (binaryOperator != CBinaryExpression.BinaryOperator.SHIFT_LEFT && binaryOperator != CBinaryExpression.BinaryOperator.SHIFT_RIGHT) {
                    ValueAndSMGState castRightValue = this.castCValue(rightValue, calculationType, currentState);
                    rightValue = castRightValue.getValue();
                    currentState = castRightValue.getState();
                }
                if (leftValue instanceof AddressExpression || rightValue instanceof AddressExpression || this.evaluator.isPointerValue(rightValue, currentState) && this.evaluator.isPointerValue(leftValue, currentState) || leftValue instanceof ConstantSymbolicExpression && this.evaluator.isPointerValue(((ConstantSymbolicExpression)leftValue).getValue(), currentState) && rightValue instanceof ConstantSymbolicExpression && this.evaluator.isPointerValue(((ConstantSymbolicExpression)rightValue).getValue(), currentState)) {
                    Value nonConstRightValue = rightValue;
                    if (rightValue instanceof ConstantSymbolicExpression && this.evaluator.isPointerValue(((ConstantSymbolicExpression)rightValue).getValue(), currentState)) {
                        nonConstRightValue = ((ConstantSymbolicExpression)rightValue).getValue();
                    }
                    Value nonConstLeftValue = leftValue;
                    if (leftValue instanceof ConstantSymbolicExpression && this.evaluator.isPointerValue(((ConstantSymbolicExpression)leftValue).getValue(), currentState)) {
                        nonConstLeftValue = ((ConstantSymbolicExpression)leftValue).getValue();
                    }
                    if (binaryOperator == CBinaryExpression.BinaryOperator.EQUALS) {
                        Preconditions.checkArgument((boolean)(returnType instanceof CSimpleType));
                        if (!(nonConstLeftValue instanceof AddressExpression) && !this.evaluator.isPointerValue(nonConstLeftValue, currentState) || !(nonConstRightValue instanceof AddressExpression) && !this.evaluator.isPointerValue(nonConstRightValue, currentState)) {
                            resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(currentState));
                            continue;
                        }
                        resultBuilder.add((Object)ValueAndSMGState.of(this.evaluator.checkEqualityForAddresses(nonConstLeftValue, nonConstRightValue, currentState), currentState));
                        continue;
                    }
                    if (binaryOperator == CBinaryExpression.BinaryOperator.NOT_EQUALS) {
                        Preconditions.checkArgument((boolean)(returnType instanceof CSimpleType));
                        resultBuilder.add((Object)ValueAndSMGState.of(this.evaluator.checkNonEqualityForAddresses(nonConstLeftValue, nonConstRightValue, currentState), currentState));
                        continue;
                    }
                    if (binaryOperator == CBinaryExpression.BinaryOperator.PLUS || binaryOperator == CBinaryExpression.BinaryOperator.MINUS) {
                        Value leftAddrExpr = nonConstLeftValue;
                        if (!(nonConstLeftValue instanceof AddressExpression) && this.evaluator.isPointerValue(nonConstLeftValue, currentState) && !leftAddrExpr.isExplicitlyKnown()) {
                            leftAddrExpr = AddressExpression.withZeroOffset(nonConstLeftValue, SMGCPAExpressionEvaluator.getCanonicalType(lVarInBinaryExp));
                        }
                        Value rightAddrExpr = nonConstRightValue;
                        if (!(nonConstRightValue instanceof AddressExpression) && this.evaluator.isPointerValue(nonConstRightValue, currentState) && !rightAddrExpr.isExplicitlyKnown()) {
                            rightAddrExpr = AddressExpression.withZeroOffset(nonConstRightValue, SMGCPAExpressionEvaluator.getCanonicalType(rVarInBinaryExp));
                        }
                        resultBuilder.addAll(this.calculatePointerArithmetics(leftAddrExpr, rightAddrExpr, binaryOperator, e.getExpressionType(), calculationType, currentState));
                        continue;
                    }
                }
                if (leftValue instanceof FunctionValue || rightValue instanceof FunctionValue) {
                    resultBuilder.add((Object)ValueAndSMGState.of(this.calculateExpressionWithFunctionValue(binaryOperator, rightValue, leftValue), currentState));
                    continue;
                }
                if (leftValue instanceof SymbolicValue || rightValue instanceof SymbolicValue) {
                    if (leftValue instanceof SymbolicIdentifier) {
                        Preconditions.checkArgument((boolean)((SymbolicIdentifier)leftValue).getRepresentedLocation().isEmpty());
                    } else if (rightValue instanceof SymbolicIdentifier) {
                        Preconditions.checkArgument((boolean)((SymbolicIdentifier)rightValue).getRepresentedLocation().isEmpty());
                    }
                    resultBuilder.add((Object)ValueAndSMGState.of(this.calculateSymbolicBinaryExpression(leftValue, rightValue, e), currentState));
                    continue;
                }
                if (!leftValue.isNumericValue() || !rightValue.isNumericValue()) {
                    this.logger.logf(Level.FINE, "Parameters to binary operation '%s %s %s' are no numeric values.", new Object[]{leftValue, binaryOperator, rightValue});
                    resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(currentState));
                    continue;
                }
                if (this.isArithmeticOperation(binaryOperator)) {
                    Value arithResult = this.arithmeticOperation((NumericValue)leftValue, (NumericValue)rightValue, binaryOperator, calculationType);
                    resultBuilder.add((Object)this.castCValue(arithResult, e.getExpressionType(), currentState));
                    continue;
                }
                if (this.isComparison(binaryOperator)) {
                    Value returnValue = this.booleanOperation((NumericValue)leftValue, (NumericValue)rightValue, binaryOperator, calculationType);
                    resultBuilder.add((Object)ValueAndSMGState.of(returnValue, currentState));
                    continue;
                }
                throw new AssertionError((Object)"Unhandled binary operator in the value visitor.");
            }
        }
        return resultBuilder.build();
    }

    @Override
    public List<ValueAndSMGState> visit(CCastExpression e) throws CPATransferException {
        CType targetType = e.getExpressionType();
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (ValueAndSMGState valueAndState : e.getOperand().accept(this)) {
            SMGState currentState = valueAndState.getState();
            Value value = valueAndState.getValue();
            builder.add((Object)this.castCValue(value, targetType, currentState));
        }
        return builder.build();
    }

    public ValueAndSMGState castCValue(Value value, CType targetType, SMGState currentState) {
        int size;
        MachineModel machineModel = this.evaluator.getMachineModel();
        if (targetType instanceof CPointerType) {
            if (value instanceof AddressExpression || value instanceof NumericValue) {
                return ValueAndSMGState.of(value, currentState);
            }
            if (this.evaluator.isPointerValue(value, currentState)) {
                return ValueAndSMGState.of(AddressExpression.withZeroOffset(value, targetType), currentState);
            }
            return ValueAndSMGState.of(Value.UnknownValue.getInstance(), currentState);
        }
        if (!value.isExplicitlyKnown()) {
            return ValueAndSMGState.of(this.castSymbolicValue(value, targetType, Optional.of(machineModel)), currentState);
        }
        if (!value.isNumericValue()) {
            this.logger.logf(Level.FINE, "Can not cast C value %s to %s", new Object[]{value.toString(), targetType.toString()});
            return ValueAndSMGState.of(value, currentState);
        }
        NumericValue numericValue = (NumericValue)value;
        CType type = targetType.getCanonicalType();
        if (type instanceof CSimpleType) {
            size = this.evaluator.getBitSizeof(currentState, type).intValue();
        } else if (type instanceof CBitFieldType) {
            size = ((CBitFieldType)type).getBitFieldSize();
            type = ((CBitFieldType)type).getType();
        } else {
            return ValueAndSMGState.of(value, currentState);
        }
        return ValueAndSMGState.of(this.castNumeric(numericValue, type, machineModel, size), currentState);
    }

    @Override
    public List<ValueAndSMGState> visit(CFieldReference e) throws CPATransferException {
        CFieldReference explicitReference = e.withExplicitPointerDereference();
        CExpression ownerExpression = explicitReference.getFieldOwner();
        CType returnType = SMGCPAExpressionEvaluator.getCanonicalType(explicitReference.getExpressionType());
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (ValueAndSMGState valueAndState : ownerExpression.accept(this)) {
            SMGState currentState = valueAndState.getState();
            Value structValue = valueAndState.getValue();
            if (structValue.isUnknown()) {
                builder.add((Object)ValueAndSMGState.ofUnknownValue(currentState));
                continue;
            }
            BigInteger fieldOffset = this.evaluator.getFieldOffsetInBits(SMGCPAExpressionEvaluator.getCanonicalType(ownerExpression), explicitReference.getFieldName());
            if (ownerExpression.getExpressionType() instanceof CPointerType) {
                Preconditions.checkArgument((boolean)(structValue instanceof AddressExpression));
            } else if (ownerExpression.getExpressionType() instanceof CCompositeType || ownerExpression.getExpressionType() instanceof CElaboratedType || ownerExpression.getExpressionType() instanceof CArrayType || ownerExpression.getExpressionType() instanceof CTypedefType) {
                if (structValue instanceof SymbolicIdentifier) {
                    Preconditions.checkArgument((boolean)((SymbolicIdentifier)structValue).getRepresentedLocation().isPresent());
                } else {
                    Preconditions.checkArgument((boolean)(structValue instanceof AddressExpression));
                }
            } else {
                Preconditions.checkArgument((!(structValue instanceof SymbolicIdentifier) ? 1 : 0) != 0);
                Preconditions.checkArgument((!(structValue instanceof AddressExpression) ? 1 : 0) != 0);
            }
            builder.addAll(this.evaluateReadOfValueAndOffset(structValue, fieldOffset, returnType, currentState));
        }
        return builder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<ValueAndSMGState> visit(CIdExpression e) throws CPATransferException {
        CSimpleDeclaration varDecl = e.getDeclaration();
        CType returnType = SMGCPAExpressionEvaluator.getCanonicalType(e.getExpressionType());
        if (varDecl == null) {
            throw new SMG2Exception("Usage of undeclared variable: " + e.getName() + ".");
        }
        String variableName = varDecl.getQualifiedName();
        ImmutableList.Builder creationBuilder = ImmutableList.builder();
        if (!this.state.isLocalOrGlobalVariablePresent(variableName)) {
            if (varDecl instanceof CVariableDeclaration) {
                creationBuilder.addAll(this.evaluator.handleVariableDeclarationWithoutInizializer(this.state, (CVariableDeclaration)varDecl));
            } else {
                if (!(varDecl instanceof CParameterDeclaration)) throw new SMG2Exception("Unhandled on-the-fly variable creation type: " + varDecl);
                creationBuilder.addAll(this.evaluator.handleVariableDeclarationWithoutInizializer(this.state, ((CParameterDeclaration)varDecl).asVariableDeclaration()));
            }
        } else {
            creationBuilder.add((Object)this.state);
        }
        ImmutableList.Builder finalStatesBuilder = ImmutableList.builder();
        for (SMGState currentState : creationBuilder.build()) {
            BigInteger sizeInBits;
            if (returnType instanceof CArrayType) {
                finalStatesBuilder.add((Object)this.evaluator.createAddressForLocalOrGlobalVariable(variableName, currentState));
                continue;
            }
            if (SMGCPAExpressionEvaluator.isStructOrUnionType(returnType)) {
                finalStatesBuilder.add((Object)ValueAndSMGState.of(SymbolicValueFactory.getInstance().newIdentifier(MemoryLocation.forIdentifier(variableName).withOffset(0L)), currentState));
                continue;
            }
            if (returnType instanceof CPointerType || returnType instanceof CFunctionType) {
                sizeInBits = this.evaluator.getBitSizeof(currentState, e.getExpressionType());
                for (ValueAndSMGState readValueAndState : this.evaluator.readStackOrGlobalVariable(currentState, varDecl.getQualifiedName(), BigInteger.ZERO, sizeInBits, SMGCPAExpressionEvaluator.getCanonicalType(e))) {
                    SMGState newState;
                    Value readValue = readValueAndState.getValue();
                    Value addressValue = this.evaluator.isPointerValue(readValue, newState = readValueAndState.getState()) ? AddressExpression.withZeroOffset(readValue, returnType) : readValue;
                    finalStatesBuilder.add((Object)ValueAndSMGState.of(addressValue, newState));
                }
                continue;
            }
            sizeInBits = this.evaluator.getBitSizeof(currentState, e.getExpressionType());
            finalStatesBuilder.addAll(this.evaluator.readStackOrGlobalVariable(currentState, varDecl.getQualifiedName(), BigInteger.ZERO, sizeInBits, SMGCPAExpressionEvaluator.getCanonicalType(e)));
        }
        return finalStatesBuilder.build();
    }

    @Override
    public List<ValueAndSMGState> visit(CCharLiteralExpression e) throws CPATransferException {
        char value = e.getCharacter();
        return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue((int)value), this.state));
    }

    @Override
    public List<ValueAndSMGState> visit(CFloatLiteralExpression e) throws CPATransferException {
        BigDecimal value = e.getValue();
        return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(value), this.state));
    }

    @Override
    public List<ValueAndSMGState> visit(CIntegerLiteralExpression e) throws CPATransferException {
        BigInteger value = e.getValue();
        return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(value), this.state));
    }

    @Override
    public List<ValueAndSMGState> visit(CStringLiteralExpression e) throws CPATransferException {
        return ImmutableList.of((Object)ValueAndSMGState.ofUnknownValue(this.state));
    }

    @Override
    public List<ValueAndSMGState> visit(CTypeIdExpression e) throws CPATransferException {
        CTypeIdExpression.TypeIdOperator idOperator = e.getOperator();
        CType innerType = e.getType();
        switch (idOperator) {
            case SIZEOF: {
                BigInteger size = this.evaluator.getBitSizeof(this.state, innerType);
                return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(size), this.state));
            }
            case ALIGNOF: {
                BigInteger align = this.evaluator.getAlignOf(innerType);
                return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(align), this.state));
            }
        }
        return ImmutableList.of((Object)ValueAndSMGState.ofUnknownValue(this.state));
    }

    @Override
    public List<ValueAndSMGState> visit(CUnaryExpression e) throws CPATransferException {
        CUnaryExpression.UnaryOperator unaryOperator = e.getOperator();
        CExpression unaryOperand = e.getOperand();
        CType returnType = SMGCPAExpressionEvaluator.getCanonicalType(e.getExpressionType());
        CType operandType = SMGCPAExpressionEvaluator.getCanonicalType(unaryOperand.getExpressionType());
        switch (unaryOperator) {
            case SIZEOF: {
                BigInteger sizeInBits = this.evaluator.getBitSizeof(this.state, operandType);
                return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(sizeInBits.divide(BigInteger.valueOf(8L))), this.state));
            }
            case ALIGNOF: {
                return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(this.evaluator.getMachineModel().getAlignof(unaryOperand.getExpressionType())), this.state));
            }
            case AMPER: {
                return this.evaluator.createAddress(unaryOperand, this.state, this.cfaEdge);
            }
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        block9: for (ValueAndSMGState valueAndState : unaryOperand.accept(this)) {
            SMGState currentState = valueAndState.getState();
            Value value = valueAndState.getValue();
            if (value instanceof SymbolicValue) {
                builder.add((Object)ValueAndSMGState.of(this.createSymbolicExpression(value, operandType, unaryOperator, returnType), currentState));
                continue;
            }
            if (!value.isNumericValue()) {
                this.logger.logf(Level.FINE, "Invalid argument %s for unary operator %s.", new Object[]{value, unaryOperator});
                builder.add((Object)ValueAndSMGState.ofUnknownValue(currentState));
                continue;
            }
            NumericValue numericValue = (NumericValue)value;
            switch (unaryOperator) {
                case MINUS: {
                    builder.add((Object)ValueAndSMGState.of(numericValue.negate(), currentState));
                    continue block9;
                }
                case TILDE: {
                    builder.add((Object)ValueAndSMGState.of(new NumericValue(numericValue.longValue() ^ 0xFFFFFFFFFFFFFFFFL), currentState));
                    continue block9;
                }
            }
            throw new AssertionError((Object)("Unknown unary operator: " + unaryOperator));
        }
        return builder.build();
    }

    @Override
    public List<ValueAndSMGState> visit(CPointerExpression e) throws CPATransferException {
        CType returnType = SMGCPAExpressionEvaluator.getCanonicalType(e.getExpressionType());
        CExpression expr = e.getOperand();
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (ValueAndSMGState valueAndState : expr.accept(this)) {
            SMGState currentState = valueAndState.getState();
            Value value = valueAndState.getValue();
            if (!(value instanceof AddressExpression)) {
                Preconditions.checkArgument((value.isNumericValue() && value.asNumericValue().bigInteger().compareTo(BigInteger.ZERO) == 0 || !this.evaluator.isPointerValue(value, currentState) ? 1 : 0) != 0);
                builder.add((Object)ValueAndSMGState.ofUnknownValue(currentState));
                continue;
            }
            AddressExpression pointerValue = (AddressExpression)value;
            Value offset = pointerValue.getOffset();
            if (!offset.isNumericValue()) {
                builder.add((Object)ValueAndSMGState.ofUnknownValue(currentState.withUnknownOffsetMemoryAccess()));
                continue;
            }
            BigInteger sizeInBits = this.evaluator.getBitSizeof(currentState, returnType);
            BigInteger offsetInBits = offset.asNumericValue().bigInteger();
            if (SMGCPAExpressionEvaluator.isStructOrUnionType(returnType)) {
                builder.add((Object)ValueAndSMGState.of(value, currentState));
                continue;
            }
            if (returnType instanceof CArrayType) {
                Preconditions.checkArgument((!currentState.getMemoryModel().pointsToZeroPlus(pointerValue.getMemoryAddress()) ? 1 : 0) != 0);
                ValueAndSMGState readArray = this.evaluator.readValueWithPointerDereference(currentState, pointerValue.getMemoryAddress(), offsetInBits, sizeInBits, returnType).get(0);
                builder.add((Object)readArray);
                continue;
            }
            Preconditions.checkArgument((!currentState.getMemoryModel().pointsToZeroPlus(pointerValue.getMemoryAddress()) ? 1 : 0) != 0);
            ValueAndSMGState readValueAndState = this.evaluator.readValueWithPointerDereference(currentState, pointerValue.getMemoryAddress(), offsetInBits, sizeInBits, returnType).get(0);
            if (returnType instanceof CPointerType) {
                builder.add((Object)ValueAndSMGState.of(AddressExpression.withZeroOffset(readValueAndState.getValue(), returnType), currentState));
                continue;
            }
            builder.add((Object)readValueAndState);
        }
        return builder.build();
    }

    @Override
    public List<ValueAndSMGState> visit(CAddressOfLabelExpression e) throws CPATransferException {
        return this.visitDefault(e);
    }

    @Override
    public List<ValueAndSMGState> visit(CImaginaryLiteralExpression e) throws CPATransferException {
        return this.visitDefault(e);
    }

    @Override
    public List<ValueAndSMGState> visit(CComplexCastExpression e) throws CPATransferException {
        return this.visitDefault(e);
    }

    private Value createSymbolicExpression(Value pValue, CType pOperandType, CUnaryExpression.UnaryOperator pUnaryOperator, CType pExpressionType) {
        SymbolicValueFactory factory = SymbolicValueFactory.getInstance();
        SymbolicExpression operand = factory.asConstant(pValue, pOperandType);
        switch (pUnaryOperator) {
            case MINUS: {
                return factory.negate(operand, pExpressionType);
            }
            case TILDE: {
                return factory.binaryNot(operand, pExpressionType);
            }
        }
        throw new AssertionError((Object)("Unhandled unary operator " + pUnaryOperator));
    }

    private Value castSymbolicValue(Value pValue, Type pTargetType, Optional<MachineModel> pMachineModel) {
        SymbolicValueFactory factory = SymbolicValueFactory.getInstance();
        if (pValue instanceof SymbolicValue && pTargetType instanceof CSimpleType) {
            return factory.cast((SymbolicValue)pValue, pTargetType, pMachineModel);
        }
        return pValue;
    }

    private Value castNumeric(@NonNull NumericValue numericValue, CType type, MachineModel machineModel, int size) {
        if (!(type instanceof CSimpleType)) {
            return numericValue;
        }
        CSimpleType st = (CSimpleType)type;
        switch (st.getType()) {
            case BOOL: {
                return this.convertToBool(numericValue);
            }
            case INT128: 
            case INT: 
            case CHAR: {
                BigInteger signedLowerBound;
                BigInteger signedUpperBound;
                if (this.isNan(numericValue)) {
                    return Value.UnknownValue.getInstance();
                }
                if ((numericValue.getNumber() instanceof Float || numericValue.getNumber() instanceof Double) && Math.abs(numericValue.doubleValue() - (double)numericValue.longValue()) >= 1.0) {
                    return Value.UnknownValue.getInstance();
                }
                BigInteger valueToCastAsInt = numericValue.getNumber() instanceof BigInteger ? numericValue.bigInteger() : (numericValue.getNumber() instanceof BigDecimal ? numericValue.bigDecimalValue().toBigInteger() : BigInteger.valueOf(numericValue.longValue()));
                boolean targetIsSigned = machineModel.isSigned(st);
                BigInteger maxValue = BigInteger.ONE.shiftLeft(size);
                BigInteger result = valueToCastAsInt.remainder(maxValue);
                if (targetIsSigned) {
                    signedUpperBound = maxValue.divide(BigInteger.valueOf(2L)).subtract(BigInteger.ONE);
                    signedLowerBound = maxValue.divide(BigInteger.valueOf(2L)).negate();
                } else {
                    signedUpperBound = maxValue.subtract(BigInteger.ONE);
                    signedLowerBound = BigInteger.ZERO;
                }
                if (this.isGreaterThan(result, signedUpperBound)) {
                    result = result.subtract(maxValue);
                } else if (this.isLessThan(result, signedLowerBound)) {
                    result = result.add(maxValue);
                }
                return new NumericValue(result);
            }
            case FLOAT: 
            case DOUBLE: 
            case FLOAT128: {
                Value result;
                int bitPerByte = machineModel.getSizeofCharInBits();
                if (this.isNan(numericValue) || this.isInfinity(numericValue)) {
                    result = numericValue;
                } else if (size == machineModel.getSizeofFloat() * 8) {
                    result = new NumericValue(Float.valueOf(numericValue.floatValue()));
                } else if (size == machineModel.getSizeofDouble() * 8) {
                    result = new NumericValue(numericValue.doubleValue());
                } else if (size == machineModel.getSizeofFloat128() * 8) {
                    result = new NumericValue(numericValue.bigDecimalValue());
                } else if (size == machineModel.getSizeofLongDouble() * bitPerByte || size == machineModel.getSizeofDouble()) {
                    result = numericValue.bigDecimalValue().doubleValue() == numericValue.doubleValue() ? new NumericValue(numericValue.doubleValue()) : (numericValue.bigDecimalValue().floatValue() == numericValue.floatValue() ? new NumericValue(Float.valueOf(numericValue.floatValue())) : Value.UnknownValue.getInstance());
                } else {
                    throw new AssertionError((Object)("Unhandled floating point type: " + type));
                }
                return result;
            }
        }
        throw new AssertionError((Object)("Unhandled type: " + type));
    }

    private Value convertToBool(NumericValue pValue) {
        Number n = pValue.getNumber();
        if (this.isBooleanFalseRepresentation(n)) {
            return new NumericValue(0);
        }
        return new NumericValue(1);
    }

    private boolean isBooleanFalseRepresentation(Number n) {
        return (n instanceof Float || n instanceof Double) && 0.0 == n.doubleValue() || n instanceof BigInteger && BigInteger.ZERO.equals(n) || n instanceof BigDecimal && ((BigDecimal)n).compareTo(BigDecimal.ZERO) == 0 || 0L == n.longValue();
    }

    private boolean isNan(NumericValue pValue) {
        Number n = pValue.getNumber();
        return n.equals(Float.valueOf(Float.NaN)) || n.equals(Double.NaN) || NumericValue.NegativeNaN.VALUE.equals(n);
    }

    private boolean isInfinity(NumericValue pValue) {
        Number n = pValue.getNumber();
        return n.equals(Double.POSITIVE_INFINITY) || n.equals(Double.NEGATIVE_INFINITY) || n.equals(Float.valueOf(Float.POSITIVE_INFINITY)) || n.equals(Float.valueOf(Float.NEGATIVE_INFINITY));
    }

    private boolean isGreaterThan(BigInteger i1, BigInteger i2) {
        return i1.compareTo(i2) > 0;
    }

    private boolean isLessThan(BigInteger i1, BigInteger i2) {
        return i1.compareTo(i2) < 0;
    }

    private boolean isUnspecifiedType(CType pType) {
        return pType instanceof CSimpleType && ((CSimpleType)pType).getType() == CBasicType.UNSPECIFIED;
    }

    private Value fmin(Number pOp1, Number pOp2) {
        BigDecimal op2bd;
        if (Double.isNaN(pOp1.doubleValue()) || Double.isInfinite(pOp1.doubleValue()) && pOp1.doubleValue() > 0.0 || Double.isInfinite(pOp2.doubleValue()) && pOp2.doubleValue() < 0.0) {
            return new NumericValue(pOp2);
        }
        if (Double.isNaN(pOp2.doubleValue()) || Double.isInfinite(pOp2.doubleValue()) && pOp2.doubleValue() > 0.0 || Double.isInfinite(pOp1.doubleValue()) && pOp1.doubleValue() < 0.0) {
            return new NumericValue(pOp1);
        }
        BigDecimal op1bd = pOp1 instanceof BigDecimal ? (BigDecimal)pOp1 : BigDecimal.valueOf(pOp1.doubleValue());
        if (op1bd.compareTo(op2bd = pOp2 instanceof BigDecimal ? (BigDecimal)pOp2 : BigDecimal.valueOf(pOp2.doubleValue())) < 0) {
            return new NumericValue(op1bd);
        }
        return new NumericValue(op2bd);
    }

    private Value fdim(Number pOp1, Number pOp2, String pFunctionName) {
        BigDecimal op2bd;
        if (Double.isNaN(pOp1.doubleValue()) || Double.isNaN(pOp2.doubleValue())) {
            return new NumericValue(Double.NaN);
        }
        if (Double.isInfinite(pOp1.doubleValue())) {
            if (Double.isInfinite(pOp2.doubleValue())) {
                if (pOp1.doubleValue() > pOp2.doubleValue()) {
                    return new NumericValue(pOp1.doubleValue() - pOp2.doubleValue());
                }
                return new NumericValue(0.0);
            }
            if (pOp1.doubleValue() < 0.0) {
                return new NumericValue(0.0);
            }
            return new NumericValue(pOp1);
        }
        if (Double.isInfinite(pOp2.doubleValue())) {
            if (pOp2.doubleValue() < 0.0) {
                return new NumericValue(Double.NaN);
            }
            return new NumericValue(0.0);
        }
        BigDecimal op1bd = pOp1 instanceof BigDecimal ? (BigDecimal)pOp1 : BigDecimal.valueOf(pOp1.doubleValue());
        if (op1bd.compareTo(op2bd = pOp2 instanceof BigDecimal ? (BigDecimal)pOp2 : BigDecimal.valueOf(pOp2.doubleValue())) > 0) {
            BigDecimal maxValue;
            BigDecimal difference = op1bd.subtract(op2bd);
            CSimpleType type = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(pFunctionName);
            switch (type.getType()) {
                case FLOAT: {
                    maxValue = BigDecimal.valueOf(3.4028234663852886E38);
                    break;
                }
                case DOUBLE: {
                    maxValue = BigDecimal.valueOf(Double.MAX_VALUE);
                    break;
                }
                default: {
                    return Value.UnknownValue.getInstance();
                }
            }
            if (difference.compareTo(maxValue) > 0) {
                return new NumericValue(Double.POSITIVE_INFINITY);
            }
            return new NumericValue(difference);
        }
        return new NumericValue(0.0);
    }

    private Optional<Boolean> isNegative(Number pNumber) {
        if (pNumber instanceof BigDecimal) {
            return Optional.of(((BigDecimal)pNumber).signum() < 0);
        }
        if (pNumber instanceof Float) {
            float number = pNumber.floatValue();
            if (Float.isNaN(number)) {
                return Optional.of(false);
            }
            return Optional.of(number < 0.0f || 1.0f / number < 0.0f);
        }
        if (pNumber instanceof Double) {
            double number = pNumber.doubleValue();
            if (Double.isNaN(number)) {
                return Optional.of(false);
            }
            return Optional.of(number < 0.0 || 1.0 / number < 0.0);
        }
        if (pNumber instanceof NumericValue.NegativeNaN) {
            return Optional.of(true);
        }
        return Optional.empty();
    }

    private Value fmax(Number pOp1, Number pOp2) {
        BigDecimal op2bd;
        if (Double.isNaN(pOp1.doubleValue()) || Double.isInfinite(pOp1.doubleValue()) && pOp1.doubleValue() < 0.0 || Double.isInfinite(pOp2.doubleValue()) && pOp2.doubleValue() > 0.0) {
            return new NumericValue(pOp2);
        }
        if (Double.isNaN(pOp2.doubleValue()) || Double.isInfinite(pOp2.doubleValue()) && pOp2.doubleValue() < 0.0 || Double.isInfinite(pOp1.doubleValue()) && pOp1.doubleValue() > 0.0) {
            return new NumericValue(pOp1);
        }
        BigDecimal op1bd = pOp1 instanceof BigDecimal ? (BigDecimal)pOp1 : BigDecimal.valueOf(pOp1.doubleValue());
        if (op1bd.compareTo(op2bd = pOp2 instanceof BigDecimal ? (BigDecimal)pOp2 : BigDecimal.valueOf(pOp2.doubleValue())) > 0) {
            return new NumericValue(op1bd);
        }
        return new NumericValue(op2bd);
    }

    private List<ValueAndSMGState> handleFunctions(CFunctionCallExpression pIastFunctionCallExpression) throws CPATransferException {
        CExpression functionNameExp = pIastFunctionCallExpression.getFunctionNameExpression();
        if (functionNameExp instanceof CIdExpression) {
            SMGCPABuiltins smgBuiltins;
            String calledFunctionName = ((CIdExpression)functionNameExp).getName();
            if (BuiltinFunctions.isBuiltinFunction(calledFunctionName)) {
                CType functionType = BuiltinFunctions.getFunctionType(calledFunctionName);
                if (this.isUnspecifiedType(functionType)) {
                    return ImmutableList.of((Object)ValueAndSMGState.ofUnknownValue(this.state));
                }
                List<CExpression> parameterExpressions = pIastFunctionCallExpression.getParameterExpressions();
                ImmutableList.Builder parameterValuesBuilder = ImmutableList.builder();
                SMGState currentState = this.state;
                Iterator<CExpression> iterator = parameterExpressions.iterator();
                while (iterator.hasNext()) {
                    SMGCPAValueVisitor vv = new SMGCPAValueVisitor(this.evaluator, currentState, this.cfaEdge, this.logger);
                    CExpression currParamExp = iterator.next();
                    List<ValueAndSMGState> newValuesAndStates = vv.evaluate(currParamExp, SMGCPAExpressionEvaluator.getCanonicalType(currParamExp));
                    Preconditions.checkArgument((newValuesAndStates.size() == 1 ? 1 : 0) != 0);
                    Value newValue = newValuesAndStates.get(0).getValue();
                    currentState = newValuesAndStates.get(0).getState();
                    parameterValuesBuilder.add((Object)newValue);
                }
                ImmutableList parameterValues = parameterValuesBuilder.build();
                if (BuiltinOverflowFunctions.isBuiltinOverflowFunction(calledFunctionName)) {
                    return ImmutableList.of((Object)ValueAndSMGState.of(Value.UnknownValue.getInstance(), currentState));
                }
                if (BuiltinFloatFunctions.matchesAbsolute(calledFunctionName)) {
                    assert (parameterValues.size() == 1);
                    CType parameterType = parameterExpressions.get(0).getExpressionType();
                    Value parameter = (Value)parameterValues.get(0);
                    if (parameterType instanceof CSimpleType && !((CSimpleType)parameterType).isSigned()) {
                        return ImmutableList.of((Object)ValueAndSMGState.of(parameter, currentState));
                    }
                    if (parameter.isExplicitlyKnown()) {
                        assert (parameter.isNumericValue());
                        double absoluteValue = Math.abs(((NumericValue)parameter).doubleValue());
                        return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(absoluteValue), currentState));
                    }
                } else {
                    Value op2;
                    Value op1;
                    NumericValue denomValue;
                    NumericValue numerValue;
                    Value denom;
                    Value numer;
                    Number op22;
                    Number op12;
                    Value operand2;
                    Value operand1;
                    Number number;
                    Value parameter;
                    CSimpleType paramType;
                    NumericValue numericValue;
                    Value value;
                    if (BuiltinFloatFunctions.matchesHugeVal(calledFunctionName) || BuiltinFloatFunctions.matchesInfinity(calledFunctionName)) {
                        assert (parameterValues.isEmpty());
                        if (BuiltinFloatFunctions.matchesHugeValFloat(calledFunctionName) || BuiltinFloatFunctions.matchesInfinityFloat(calledFunctionName)) {
                            return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(Float.valueOf(Float.POSITIVE_INFINITY)), currentState));
                        }
                        assert (BuiltinFloatFunctions.matchesInfinityDouble(calledFunctionName) || BuiltinFloatFunctions.matchesInfinityLongDouble(calledFunctionName) || BuiltinFloatFunctions.matchesHugeValDouble(calledFunctionName) || BuiltinFloatFunctions.matchesHugeValLongDouble(calledFunctionName)) : " Unhandled builtin function for infinity: " + calledFunctionName;
                        return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(Double.POSITIVE_INFINITY), currentState));
                    }
                    if (BuiltinFloatFunctions.matchesNaN(calledFunctionName)) {
                        assert (parameterValues.isEmpty() || parameterValues.size() == 1);
                        if (BuiltinFloatFunctions.matchesNaNFloat(calledFunctionName)) {
                            return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(Float.valueOf(Float.NaN)), currentState));
                        }
                        assert (BuiltinFloatFunctions.matchesNaNDouble(calledFunctionName) || BuiltinFloatFunctions.matchesNaNLongDouble(calledFunctionName)) : "Unhandled builtin function for NaN: " + calledFunctionName;
                        return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(Double.NaN), currentState));
                    }
                    if (BuiltinFloatFunctions.matchesIsNaN(calledFunctionName)) {
                        if (parameterValues.size() == 1 && (value = (Value)parameterValues.get(0)).isExplicitlyKnown()) {
                            numericValue = value.asNumericValue();
                            paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(calledFunctionName);
                            switch (paramType.getType()) {
                                case FLOAT: {
                                    return Float.isNaN(numericValue.floatValue()) ? ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(1), currentState)) : ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(0), currentState));
                                }
                                case DOUBLE: {
                                    return Double.isNaN(numericValue.doubleValue()) ? ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(1), currentState)) : ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(0), currentState));
                                }
                            }
                        }
                    } else if (BuiltinFloatFunctions.matchesIsInfinity(calledFunctionName)) {
                        if (parameterValues.size() == 1 && (value = (Value)parameterValues.get(0)).isExplicitlyKnown()) {
                            numericValue = value.asNumericValue();
                            paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(calledFunctionName);
                            switch (paramType.getType()) {
                                case FLOAT: {
                                    return Float.isInfinite(numericValue.floatValue()) ? ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(1), currentState)) : ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(0), currentState));
                                }
                                case DOUBLE: {
                                    return Double.isInfinite(numericValue.doubleValue()) ? ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(1), currentState)) : ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(0), currentState));
                                }
                            }
                        }
                    } else if (BuiltinFloatFunctions.matchesFinite(calledFunctionName)) {
                        if (parameterValues.size() == 1 && (value = (Value)parameterValues.get(0)).isExplicitlyKnown()) {
                            numericValue = value.asNumericValue();
                            paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(calledFunctionName);
                            switch (paramType.getType()) {
                                case FLOAT: {
                                    return Float.isInfinite(numericValue.floatValue()) ? ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(0), currentState)) : ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(1), currentState));
                                }
                                case DOUBLE: {
                                    return Double.isInfinite(numericValue.doubleValue()) ? ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(0), currentState)) : ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(1), currentState));
                                }
                            }
                        }
                    } else if (BuiltinFloatFunctions.matchesFloor(calledFunctionName)) {
                        if (parameterValues.size() == 1 && (parameter = (Value)parameterValues.get(0)).isExplicitlyKnown()) {
                            assert (parameter.isNumericValue());
                            number = parameter.asNumericValue().getNumber();
                            if (number instanceof BigDecimal) {
                                return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(((BigDecimal)number).setScale(0, RoundingMode.FLOOR)), currentState));
                            }
                            if (number instanceof Float) {
                                return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(Math.floor(number.floatValue())), currentState));
                            }
                            if (number instanceof Double) {
                                return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(Math.floor(number.doubleValue())), currentState));
                            }
                            if (number instanceof NumericValue.NegativeNaN) {
                                return ImmutableList.of((Object)ValueAndSMGState.of(parameter, currentState));
                            }
                        }
                    } else if (BuiltinFloatFunctions.matchesCeil(calledFunctionName)) {
                        if (parameterValues.size() == 1 && (parameter = (Value)parameterValues.get(0)).isExplicitlyKnown()) {
                            assert (parameter.isNumericValue());
                            number = parameter.asNumericValue().getNumber();
                            if (number instanceof BigDecimal) {
                                return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(((BigDecimal)number).setScale(0, RoundingMode.CEILING)), currentState));
                            }
                            if (number instanceof Float) {
                                return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(Math.ceil(number.floatValue())), currentState));
                            }
                            if (number instanceof Double) {
                                return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(Math.ceil(number.doubleValue())), currentState));
                            }
                            if (number instanceof NumericValue.NegativeNaN) {
                                return ImmutableList.of((Object)ValueAndSMGState.of(parameter, currentState));
                            }
                        }
                    } else if (BuiltinFloatFunctions.matchesRound(calledFunctionName) || BuiltinFloatFunctions.matchesLround(calledFunctionName) || BuiltinFloatFunctions.matchesLlround(calledFunctionName)) {
                        if (parameterValues.size() == 1 && (parameter = (Value)parameterValues.get(0)).isExplicitlyKnown()) {
                            assert (parameter.isNumericValue());
                            number = parameter.asNumericValue().getNumber();
                            if (number instanceof BigDecimal) {
                                return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(((BigDecimal)number).setScale(0, RoundingMode.HALF_UP)), currentState));
                            }
                            if (number instanceof Float) {
                                float f = number.floatValue();
                                if (0.0f == f || Float.isInfinite(f)) {
                                    return ImmutableList.of((Object)ValueAndSMGState.of(parameter, currentState));
                                }
                                return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(Math.round(f)), currentState));
                            }
                            if (number instanceof Double) {
                                double d = number.doubleValue();
                                if (0.0 == d || Double.isInfinite(d)) {
                                    return ImmutableList.of((Object)ValueAndSMGState.of(parameter, currentState));
                                }
                                return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(Math.round(d)), currentState));
                            }
                            if (number instanceof NumericValue.NegativeNaN) {
                                return ImmutableList.of((Object)ValueAndSMGState.of(parameter, currentState));
                            }
                        }
                    } else if (BuiltinFloatFunctions.matchesTrunc(calledFunctionName)) {
                        if (parameterValues.size() == 1 && (parameter = (Value)parameterValues.get(0)).isExplicitlyKnown()) {
                            assert (parameter.isNumericValue());
                            number = parameter.asNumericValue().getNumber();
                            if (number instanceof BigDecimal) {
                                return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(((BigDecimal)number).setScale(0, RoundingMode.DOWN)), currentState));
                            }
                            if (number instanceof Float) {
                                float f = number.floatValue();
                                if (0.0f == f || Float.isInfinite(f) || Float.isNaN(f)) {
                                    return ImmutableList.of((Object)ValueAndSMGState.of(parameter, currentState));
                                }
                                return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(Float.valueOf(BigDecimal.valueOf(number.floatValue()).setScale(0, RoundingMode.DOWN).floatValue())), currentState));
                            }
                            if (number instanceof Double) {
                                double d = number.doubleValue();
                                if (0.0 == d || Double.isInfinite(d) || Double.isNaN(d)) {
                                    return ImmutableList.of((Object)ValueAndSMGState.of(parameter, currentState));
                                }
                                return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(BigDecimal.valueOf(number.doubleValue()).setScale(0, RoundingMode.DOWN).doubleValue()), currentState));
                            }
                            if (number instanceof NumericValue.NegativeNaN) {
                                return ImmutableList.of((Object)ValueAndSMGState.of(parameter, currentState));
                            }
                        }
                    } else if (BuiltinFloatFunctions.matchesFdim(calledFunctionName)) {
                        if (parameterValues.size() == 2) {
                            operand1 = (Value)parameterValues.get(0);
                            operand2 = (Value)parameterValues.get(1);
                            if (operand1.isExplicitlyKnown() && operand2.isExplicitlyKnown()) {
                                assert (operand1.isNumericValue());
                                assert (operand2.isNumericValue());
                                op12 = operand1.asNumericValue().getNumber();
                                op22 = operand2.asNumericValue().getNumber();
                                Value result = this.fdim(op12, op22, calledFunctionName);
                                if (!Value.UnknownValue.getInstance().equals(result)) {
                                    return ImmutableList.of((Object)ValueAndSMGState.of(result, currentState));
                                }
                            }
                        }
                    } else if (BuiltinFloatFunctions.matchesFmax(calledFunctionName)) {
                        if (parameterValues.size() == 2) {
                            operand1 = (Value)parameterValues.get(0);
                            operand2 = (Value)parameterValues.get(1);
                            if (operand1.isExplicitlyKnown() && operand2.isExplicitlyKnown()) {
                                assert (operand1.isNumericValue());
                                assert (operand2.isNumericValue());
                                op12 = operand1.asNumericValue().getNumber();
                                op22 = operand2.asNumericValue().getNumber();
                                return ImmutableList.of((Object)ValueAndSMGState.of(this.fmax(op12, op22), currentState));
                            }
                        }
                    } else if (BuiltinFloatFunctions.matchesFmin(calledFunctionName)) {
                        if (parameterValues.size() == 2) {
                            operand1 = (Value)parameterValues.get(0);
                            operand2 = (Value)parameterValues.get(1);
                            if (operand1.isExplicitlyKnown() && operand2.isExplicitlyKnown()) {
                                assert (operand1.isNumericValue());
                                assert (operand2.isNumericValue());
                                op12 = operand1.asNumericValue().getNumber();
                                op22 = operand2.asNumericValue().getNumber();
                                return ImmutableList.of((Object)ValueAndSMGState.of(this.fmin(op12, op22), currentState));
                            }
                        }
                    } else if (BuiltinFloatFunctions.matchesSignbit(calledFunctionName)) {
                        if (parameterValues.size() == 1 && (parameter = (Value)parameterValues.get(0)).isExplicitlyKnown()) {
                            assert (parameter.isNumericValue());
                            number = parameter.asNumericValue().getNumber();
                            Optional<Boolean> isNegative = this.isNegative(number);
                            if (isNegative.isPresent()) {
                                return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(isNegative.orElseThrow() != false ? 1 : 0), currentState));
                            }
                        }
                    } else if (BuiltinFloatFunctions.matchesCopysign(calledFunctionName)) {
                        if (parameterValues.size() == 2) {
                            Value target = (Value)parameterValues.get(0);
                            Value source = (Value)parameterValues.get(1);
                            if (target.isExplicitlyKnown() && source.isExplicitlyKnown()) {
                                assert (target.isNumericValue());
                                assert (source.isNumericValue());
                                Number targetNumber = target.asNumericValue().getNumber();
                                Number sourceNumber = source.asNumericValue().getNumber();
                                Optional<Boolean> sourceNegative = this.isNegative(sourceNumber);
                                Optional<Boolean> targetNegative = this.isNegative(targetNumber);
                                if (sourceNegative.isPresent() && targetNegative.isPresent()) {
                                    if (sourceNegative.orElseThrow().equals(targetNegative.orElseThrow())) {
                                        return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(targetNumber), currentState));
                                    }
                                    return ImmutableList.of((Object)ValueAndSMGState.of(target.asNumericValue().negate(), currentState));
                                }
                            }
                        }
                    } else if (BuiltinFloatFunctions.matchesFloatClassify(calledFunctionName)) {
                        if (parameterValues.size() == 1 && (value = (Value)parameterValues.get(0)).isExplicitlyKnown()) {
                            numericValue = value.asNumericValue();
                            paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(calledFunctionName);
                            switch (paramType.getType()) {
                                case FLOAT: {
                                    float v = numericValue.floatValue();
                                    if (Float.isNaN(v)) {
                                        return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(0), currentState));
                                    }
                                    if (Float.isInfinite(v)) {
                                        return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(1), currentState));
                                    }
                                    if ((double)v == 0.0) {
                                        return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(2), currentState));
                                    }
                                    if (Float.toHexString(v).startsWith("0x0.")) {
                                        return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(3), currentState));
                                    }
                                    return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(4), currentState));
                                }
                                case DOUBLE: {
                                    double v = numericValue.doubleValue();
                                    if (Double.isNaN(v)) {
                                        return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(0), currentState));
                                    }
                                    if (Double.isInfinite(v)) {
                                        return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(1), currentState));
                                    }
                                    if (v == 0.0) {
                                        return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(2), currentState));
                                    }
                                    if (Double.toHexString(v).startsWith("0x0.")) {
                                        return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(3), currentState));
                                    }
                                    return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(4), currentState));
                                }
                            }
                        }
                    } else if (BuiltinFloatFunctions.matchesModf(calledFunctionName)) {
                        if (parameterValues.size() == 2 && (value = (Value)parameterValues.get(0)).isExplicitlyKnown()) {
                            numericValue = value.asNumericValue();
                            paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(calledFunctionName);
                            switch (paramType.getType()) {
                                case FLOAT: {
                                    long integralPart = (long)numericValue.floatValue();
                                    float fractionalPart = numericValue.floatValue() - (float)integralPart;
                                    return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(Float.valueOf(fractionalPart)), currentState));
                                }
                                case DOUBLE: {
                                    long integralPart = (long)numericValue.doubleValue();
                                    double fractionalPart = numericValue.doubleValue() - (double)integralPart;
                                    return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(fractionalPart), currentState));
                                }
                            }
                        }
                    } else if (BuiltinFloatFunctions.matchesFremainder(calledFunctionName)) {
                        if (parameterValues.size() == 2) {
                            numer = (Value)parameterValues.get(0);
                            denom = (Value)parameterValues.get(1);
                            if (numer.isExplicitlyKnown() && denom.isExplicitlyKnown()) {
                                numerValue = numer.asNumericValue();
                                denomValue = denom.asNumericValue();
                                switch (BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(calledFunctionName).getType()) {
                                    case FLOAT: {
                                        float num = numerValue.floatValue();
                                        float den = denomValue.floatValue();
                                        if (Float.isNaN(num) || Float.isNaN(den) || Float.isInfinite(num) || den == 0.0f) {
                                            return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(Float.valueOf(Float.NaN)), currentState));
                                        }
                                        return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(Float.valueOf((float)Math.IEEEremainder(num, den))), currentState));
                                    }
                                    case DOUBLE: {
                                        double num = numerValue.doubleValue();
                                        double den = denomValue.doubleValue();
                                        if (Double.isNaN(num) || Double.isNaN(den) || Double.isInfinite(num) || den == 0.0) {
                                            return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(Double.NaN), currentState));
                                        }
                                        return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(Math.IEEEremainder(num, den)), currentState));
                                    }
                                }
                            }
                        }
                    } else if (BuiltinFloatFunctions.matchesFmod(calledFunctionName)) {
                        if (parameterValues.size() == 2) {
                            numer = (Value)parameterValues.get(0);
                            denom = (Value)parameterValues.get(1);
                            if (numer.isExplicitlyKnown() && denom.isExplicitlyKnown()) {
                                numerValue = numer.asNumericValue();
                                denomValue = denom.asNumericValue();
                                switch (BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(calledFunctionName).getType()) {
                                    case FLOAT: {
                                        float num = numerValue.floatValue();
                                        float den = denomValue.floatValue();
                                        if (Float.isNaN(num) || Float.isNaN(den) || Float.isInfinite(num) || den == 0.0f) {
                                            return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(Float.valueOf(Float.NaN)), currentState));
                                        }
                                        if (num == 0.0f && den != 0.0f) {
                                            return ImmutableList.of((Object)ValueAndSMGState.of(numer, currentState));
                                        }
                                        return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(Float.valueOf(num % den)), currentState));
                                    }
                                    case DOUBLE: {
                                        double num = numerValue.doubleValue();
                                        double den = denomValue.doubleValue();
                                        if (Double.isNaN(num) || Double.isNaN(den) || Double.isInfinite(num) || den == 0.0) {
                                            return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(Double.NaN), currentState));
                                        }
                                        if (num == 0.0 && den != 0.0) {
                                            return ImmutableList.of((Object)ValueAndSMGState.of(numer, currentState));
                                        }
                                        return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(num % den), currentState));
                                    }
                                }
                            }
                        }
                    } else if (BuiltinFloatFunctions.matchesIsgreater(calledFunctionName)) {
                        op1 = (Value)parameterValues.get(0);
                        op2 = (Value)parameterValues.get(1);
                        if (op1.isExplicitlyKnown() && op2.isExplicitlyKnown()) {
                            double num2;
                            double num1 = op1.asNumericValue().doubleValue();
                            return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(num1 > (num2 = op2.asNumericValue().doubleValue()) ? 1 : 0), currentState));
                        }
                    } else if (BuiltinFloatFunctions.matchesIsgreaterequal(calledFunctionName)) {
                        op1 = (Value)parameterValues.get(0);
                        op2 = (Value)parameterValues.get(1);
                        if (op1.isExplicitlyKnown() && op2.isExplicitlyKnown()) {
                            double num2;
                            double num1 = op1.asNumericValue().doubleValue();
                            return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(num1 >= (num2 = op2.asNumericValue().doubleValue()) ? 1 : 0), currentState));
                        }
                    } else if (BuiltinFloatFunctions.matchesIsless(calledFunctionName)) {
                        op1 = (Value)parameterValues.get(0);
                        op2 = (Value)parameterValues.get(1);
                        if (op1.isExplicitlyKnown() && op2.isExplicitlyKnown()) {
                            double num2;
                            double num1 = op1.asNumericValue().doubleValue();
                            return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(num1 < (num2 = op2.asNumericValue().doubleValue()) ? 1 : 0), currentState));
                        }
                    } else if (BuiltinFloatFunctions.matchesIslessequal(calledFunctionName)) {
                        op1 = (Value)parameterValues.get(0);
                        op2 = (Value)parameterValues.get(1);
                        if (op1.isExplicitlyKnown() && op2.isExplicitlyKnown()) {
                            double num2;
                            double num1 = op1.asNumericValue().doubleValue();
                            return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(num1 <= (num2 = op2.asNumericValue().doubleValue()) ? 1 : 0), currentState));
                        }
                    } else if (BuiltinFloatFunctions.matchesIslessgreater(calledFunctionName)) {
                        op1 = (Value)parameterValues.get(0);
                        op2 = (Value)parameterValues.get(1);
                        if (op1.isExplicitlyKnown() && op2.isExplicitlyKnown()) {
                            double num2;
                            double num1 = op1.asNumericValue().doubleValue();
                            return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(num1 > (num2 = op2.asNumericValue().doubleValue()) || num1 < num2 ? 1 : 0), currentState));
                        }
                    } else if (BuiltinFloatFunctions.matchesIsunordered(calledFunctionName)) {
                        op1 = (Value)parameterValues.get(0);
                        op2 = (Value)parameterValues.get(1);
                        if (op1.isExplicitlyKnown() && op2.isExplicitlyKnown()) {
                            double num1 = op1.asNumericValue().doubleValue();
                            double num2 = op2.asNumericValue().doubleValue();
                            return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(Double.isNaN(num1) || Double.isNaN(num2) ? 1 : 0), currentState));
                        }
                    }
                }
            }
            if ((smgBuiltins = this.evaluator.getBuiltinFunctionHandler()).isABuiltIn(calledFunctionName)) {
                return smgBuiltins.handleFunctioncall(pIastFunctionCallExpression, calledFunctionName, this.state, this.cfaEdge);
            }
        }
        return ImmutableList.of((Object)ValueAndSMGState.ofUnknownValue(this.state));
    }

    private Value calculateExpressionWithFunctionValue(CBinaryExpression.BinaryOperator binaryOperator, Value val1, Value val2) {
        if (val1 instanceof FunctionValue) {
            return this.calculateOperationWithFunctionValue(binaryOperator, (FunctionValue)val1, val2);
        }
        if (val2 instanceof FunctionValue) {
            return this.calculateOperationWithFunctionValue(binaryOperator, (FunctionValue)val2, val1);
        }
        return new Value.UnknownValue();
    }

    private List<ValueAndSMGState> calculatePointerArithmetics(Value leftValue, Value rightValue, CBinaryExpression.BinaryOperator binaryOperator, CType expressionType, CType calculationType, SMGState currentState) throws SMG2Exception {
        if (binaryOperator != CBinaryExpression.BinaryOperator.PLUS && binaryOperator != CBinaryExpression.BinaryOperator.MINUS) {
            return ImmutableList.of((Object)ValueAndSMGState.ofUnknownValue(currentState));
        }
        CType canonicalReturnType = expressionType;
        if (calculationType instanceof CPointerType) {
            canonicalReturnType = ((CPointerType)expressionType).getType();
        }
        if (leftValue instanceof AddressExpression && !(rightValue instanceof AddressExpression)) {
            AddressExpression addressValue = (AddressExpression)leftValue;
            Value addressOffset = addressValue.getOffset();
            if (!rightValue.isNumericValue() || !addressOffset.isNumericValue()) {
                return ImmutableList.of((Object)ValueAndSMGState.ofUnknownValue(currentState));
            }
            Value correctlyTypedOffset = calculationType instanceof CPointerType ? this.arithmeticOperation(new NumericValue(this.evaluator.getBitSizeof(currentState, canonicalReturnType)), (NumericValue)rightValue, CBinaryExpression.BinaryOperator.MULTIPLY, (CType)this.evaluator.getMachineModel().getPointerEquivalentSimpleType()) : this.arithmeticOperation(new NumericValue(BigInteger.valueOf(8L)), (NumericValue)rightValue, CBinaryExpression.BinaryOperator.MULTIPLY, calculationType);
            Value finalOffset = this.arithmeticOperation((NumericValue)addressOffset, (NumericValue)correctlyTypedOffset, binaryOperator, calculationType);
            return ImmutableList.of((Object)ValueAndSMGState.of(addressValue.copyWithNewOffset(finalOffset), currentState));
        }
        if (!(leftValue instanceof AddressExpression) && rightValue instanceof AddressExpression) {
            AddressExpression addressValue = (AddressExpression)rightValue;
            Value addressOffset = addressValue.getOffset();
            if (!leftValue.isNumericValue() || !addressOffset.isNumericValue() || binaryOperator == CBinaryExpression.BinaryOperator.MINUS) {
                return ImmutableList.of((Object)ValueAndSMGState.ofUnknownValue(currentState));
            }
            Value correctlyTypedOffset = calculationType instanceof CPointerType ? this.arithmeticOperation(new NumericValue(this.evaluator.getBitSizeof(currentState, canonicalReturnType)), (NumericValue)leftValue, CBinaryExpression.BinaryOperator.MULTIPLY, (CType)this.evaluator.getMachineModel().getPointerEquivalentSimpleType()) : this.arithmeticOperation(new NumericValue(BigInteger.valueOf(8L)), (NumericValue)leftValue, CBinaryExpression.BinaryOperator.MULTIPLY, calculationType);
            Value finalOffset = this.arithmeticOperation((NumericValue)correctlyTypedOffset, (NumericValue)addressOffset, binaryOperator, calculationType);
            return ImmutableList.of((Object)ValueAndSMGState.of(addressValue.copyWithNewOffset(finalOffset), currentState));
        }
        if (rightValue.isNumericValue() && leftValue.isNumericValue() && rightValue.asNumericValue().getNumber().equals(leftValue.asNumericValue().getNumber())) {
            return ImmutableList.of((Object)ValueAndSMGState.of(new NumericValue(0), currentState));
        }
        AddressExpression addressRight = (AddressExpression)rightValue;
        AddressExpression addressLeft = (AddressExpression)leftValue;
        Value leftOffset = addressLeft.getOffset();
        Value rightOffset = addressRight.getOffset();
        if (binaryOperator != CBinaryExpression.BinaryOperator.MINUS || !rightOffset.isNumericValue() || !leftOffset.isNumericValue()) {
            return ImmutableList.of((Object)ValueAndSMGState.ofUnknownValue(currentState));
        }
        ImmutableList.Builder returnBuilder = ImmutableList.builder();
        for (ValueAndSMGState distanceInBitsAndState : this.evaluator.calculateAddressDistance(currentState, addressLeft.getMemoryAddress(), addressRight.getMemoryAddress())) {
            NumericValue size;
            Value distanceInBits = distanceInBitsAndState.getValue();
            currentState = distanceInBitsAndState.getState();
            if (!distanceInBits.isNumericValue()) {
                returnBuilder.add((Object)ValueAndSMGState.of(distanceInBits, currentState));
                continue;
            }
            if (addressRight.getType() instanceof CPointerType) {
                size = new NumericValue(this.evaluator.getBitSizeof(currentState, ((CPointerType)addressRight.getType()).getType()));
            } else if (addressRight.getType() instanceof CArrayType) {
                size = new NumericValue(this.evaluator.getBitSizeof(currentState, (CArrayType)addressRight.getType()));
            } else {
                returnBuilder.add((Object)ValueAndSMGState.ofUnknownValue(currentState));
                continue;
            }
            Value distance = this.arithmeticOperation((NumericValue)distanceInBits, size, CBinaryExpression.BinaryOperator.DIVIDE, (CType)this.evaluator.getMachineModel().getPointerEquivalentSimpleType());
            returnBuilder.add((Object)ValueAndSMGState.of(distance, currentState));
        }
        return returnBuilder.build();
    }

    public Value calculateSymbolicBinaryExpression(Value pLValue, Value pRValue, CBinaryExpression pExpression) {
        if (pLValue instanceof AddressExpression || pRValue instanceof AddressExpression) {
            this.logger.logf(Level.ALL, "Could not determine result of %s operation on one or more memory addresses.", new Object[]{pExpression});
            return Value.UnknownValue.getInstance();
        }
        CBinaryExpression.BinaryOperator operator = pExpression.getOperator();
        CType leftOperandType = pExpression.getOperand1().getExpressionType();
        CType rightOperandType = pExpression.getOperand2().getExpressionType();
        CType expressionType = pExpression.getExpressionType();
        CType calculationType = pExpression.getCalculationType();
        if (operator.equals(CBinaryExpression.BinaryOperator.EQUALS) && pLValue.equals(pRValue)) {
            return new NumericValue(1);
        }
        return this.createSymbolicExpression(pLValue, leftOperandType, pRValue, rightOperandType, operator, expressionType, calculationType);
    }

    private SymbolicValue createSymbolicExpression(Value pLeftValue, CType pLeftType, Value pRightValue, CType pRightType, CBinaryExpression.BinaryOperator pOperator, CType pExpressionType, CType pCalculationType) {
        SymbolicValueFactory factory = SymbolicValueFactory.getInstance();
        SymbolicExpression leftOperand = factory.asConstant(pLeftValue, pLeftType);
        SymbolicExpression rightOperand = factory.asConstant(pRightValue, pRightType);
        switch (pOperator) {
            case PLUS: {
                return factory.add(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case MINUS: {
                return factory.minus(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case MULTIPLY: {
                return factory.multiply(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case DIVIDE: {
                return factory.divide(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case MODULO: {
                return factory.modulo(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case SHIFT_LEFT: {
                return factory.shiftLeft(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case SHIFT_RIGHT: {
                return factory.shiftRightSigned(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case BINARY_AND: {
                return factory.binaryAnd(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case BINARY_OR: {
                return factory.binaryOr(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case BINARY_XOR: {
                return factory.binaryXor(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case EQUALS: {
                return factory.equal(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case NOT_EQUALS: {
                return factory.notEqual(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case LESS_THAN: {
                return factory.lessThan(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case LESS_EQUAL: {
                return factory.lessThanOrEqual(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case GREATER_THAN: {
                return factory.greaterThan(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case GREATER_EQUAL: {
                return factory.greaterThanOrEqual(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
        }
        throw new AssertionError((Object)("Unhandled binary operation " + pOperator));
    }

    private NumericValue calculateOperationWithFunctionValue(CBinaryExpression.BinaryOperator binaryOperator, FunctionValue val1, Value val2) {
        switch (binaryOperator) {
            case EQUALS: {
                return new NumericValue(val1.equals(val2) ? 1 : 0);
            }
            case NOT_EQUALS: {
                return new NumericValue(val1.equals(val2) ? 0 : 1);
            }
        }
        throw new AssertionError((Object)("Operation " + binaryOperator + " is not supported for function values"));
    }

    private Value arithmeticOperation(NumericValue lNum, NumericValue rNum, CBinaryExpression.BinaryOperator op, CType calculationType) {
        CSimpleType type = this.getArithmeticType(calculationType);
        if (type == null) {
            this.logger.logf(Level.FINE, "unsupported type %s for result of binary operation %s", new Object[]{calculationType, op});
            return Value.UnknownValue.getInstance();
        }
        try {
            switch (type.getType()) {
                case INT: {
                    long lVal = lNum.getNumber().longValue();
                    long rVal = rNum.getNumber().longValue();
                    long result = this.arithmeticOperation(lVal, rVal, op, calculationType);
                    return new NumericValue(result);
                }
                case INT128: {
                    BigInteger lVal = lNum.bigInteger();
                    BigInteger rVal = rNum.bigInteger();
                    BigInteger result = this.arithmeticOperation(lVal, rVal, op);
                    return new NumericValue(result);
                }
                case DOUBLE: {
                    if (type.isLong()) {
                        return this.arithmeticOperationForLongDouble(lNum, rNum, op, calculationType);
                    }
                    double lVal = lNum.doubleValue();
                    double rVal = rNum.doubleValue();
                    double result = this.arithmeticOperation(lVal, rVal, op, calculationType);
                    return new NumericValue(result);
                }
                case FLOAT: {
                    float lVal = lNum.floatValue();
                    float rVal = rNum.floatValue();
                    float result = this.arithmeticOperation(lVal, rVal, op);
                    return new NumericValue(Float.valueOf(result));
                }
            }
            this.logger.logf(Level.FINE, "unsupported type for result of binary operation %s", new Object[]{type.toString()});
            return Value.UnknownValue.getInstance();
        }
        catch (ArithmeticException ae) {
            this.logger.logf(Level.WARNING, "expression causes arithmetic exception (%s): %s %s %s", new Object[]{ae.getMessage(), lNum.bigDecimalValue(), op.getOperator(), rNum.bigDecimalValue()});
            return Value.UnknownValue.getInstance();
        }
    }

    private Value arithmeticOperationForLongDouble(NumericValue pLNum, NumericValue pRNum, CBinaryExpression.BinaryOperator pOp, CType pCalculationType) {
        return Value.UnknownValue.getInstance();
    }

    private long arithmeticOperation(long l, long r, CBinaryExpression.BinaryOperator op, CType calculationType) {
        CSimpleType st = this.getArithmeticType(calculationType);
        if (st != null && this.evaluator.getMachineModel().getSizeofInBits(st) >= 64 && st.isUnsigned()) {
            switch (op) {
                case DIVIDE: {
                    if (r == 0L) {
                        this.logger.logf(Level.SEVERE, "Division by Zero (%d / %d)", new Object[]{l, r});
                        return 0L;
                    }
                    return UnsignedLongs.divide((long)l, (long)r);
                }
                case MODULO: {
                    return UnsignedLongs.remainder((long)l, (long)r);
                }
                case SHIFT_RIGHT: {
                    return l >>> (int)r;
                }
            }
        }
        switch (op) {
            case PLUS: {
                return l + r;
            }
            case MINUS: {
                return l - r;
            }
            case DIVIDE: {
                if (r == 0L) {
                    this.logger.logf(Level.SEVERE, "Division by Zero (%d / %d)", new Object[]{l, r});
                    return 0L;
                }
                return l / r;
            }
            case MODULO: {
                return l % r;
            }
            case MULTIPLY: {
                return l * r;
            }
            case SHIFT_LEFT: {
                return r >= 64L ? 0L : l << (int)r;
            }
            case SHIFT_RIGHT: {
                return l >> (int)r;
            }
            case BINARY_AND: {
                return l & r;
            }
            case BINARY_OR: {
                return l | r;
            }
            case BINARY_XOR: {
                return l ^ r;
            }
        }
        throw new AssertionError((Object)("unknown binary operation: " + op));
    }

    private double arithmeticOperation(double l, double r, CBinaryExpression.BinaryOperator op, CType calculationType) {
        Preconditions.checkArgument((calculationType.getCanonicalType() instanceof CSimpleType && !((CSimpleType)calculationType.getCanonicalType()).isLong() ? 1 : 0) != 0, (Object)"Value analysis can't compute long double values in a precise manner");
        switch (op) {
            case PLUS: {
                return l + r;
            }
            case MINUS: {
                return l - r;
            }
            case DIVIDE: {
                return l / r;
            }
            case MODULO: {
                return l % r;
            }
            case MULTIPLY: {
                return l * r;
            }
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: {
                throw new AssertionError((Object)("Trying to perform " + op + " on floating point operands"));
            }
        }
        throw new AssertionError((Object)("Unknown binary operation: " + op));
    }

    private BigInteger arithmeticOperation(BigInteger l, BigInteger r, CBinaryExpression.BinaryOperator op) {
        switch (op) {
            case PLUS: {
                return l.add(r);
            }
            case MINUS: {
                return l.subtract(r);
            }
            case DIVIDE: {
                if (r.equals(BigInteger.ZERO)) {
                    this.logger.logf(Level.SEVERE, "Division by Zero (%s / %s)", new Object[]{l.toString(), r.toString()});
                    return BigInteger.ZERO;
                }
                return l.divide(r);
            }
            case MODULO: {
                return l.mod(r);
            }
            case MULTIPLY: {
                return l.multiply(r);
            }
            case SHIFT_LEFT: {
                if (r.compareTo(BigInteger.valueOf(128L)) <= 0 && r.signum() != -1) {
                    return l.shiftLeft(r.intValue());
                }
                this.logger.logf(Level.SEVERE, "Right-hand side (%s) of the bitshift is larger than 128 or negative.", new Object[]{r.toString()});
                return BigInteger.ZERO;
            }
            case SHIFT_RIGHT: {
                if (r.compareTo(BigInteger.valueOf(128L)) <= 0 && r.signum() != -1) {
                    return l.shiftRight(r.intValue());
                }
                return BigInteger.ZERO;
            }
            case BINARY_AND: {
                return l.and(r);
            }
            case BINARY_OR: {
                return l.or(r);
            }
            case BINARY_XOR: {
                return l.xor(r);
            }
        }
        throw new AssertionError((Object)("Unknown binary operation: " + op));
    }

    private float arithmeticOperation(float l, float r, CBinaryExpression.BinaryOperator op) {
        switch (op) {
            case PLUS: {
                return l + r;
            }
            case MINUS: {
                return l - r;
            }
            case DIVIDE: {
                return l / r;
            }
            case MODULO: {
                return l % r;
            }
            case MULTIPLY: {
                return l * r;
            }
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: {
                throw new AssertionError((Object)("Trying to perform " + op + " on floating point operands"));
            }
        }
        throw new AssertionError((Object)("Unknown binary operation: " + op));
    }

    private Value booleanOperation(NumericValue l, NumericValue r, CBinaryExpression.BinaryOperator op, CType calculationType) {
        int cmp;
        CSimpleType type = this.getArithmeticType(calculationType);
        if (type == null) {
            this.logger.logf(Level.FINE, "unsupported type %s for result of binary operation %s", new Object[]{calculationType, op});
            return Value.UnknownValue.getInstance();
        }
        switch (type.getType()) {
            case INT128: 
            case INT: 
            case CHAR: {
                BigInteger leftBigInt = l.getNumber() instanceof BigInteger ? (BigInteger)l.getNumber() : BigInteger.valueOf(l.longValue());
                BigInteger rightBigInt = r.getNumber() instanceof BigInteger ? (BigInteger)r.getNumber() : BigInteger.valueOf(r.longValue());
                cmp = leftBigInt.compareTo(rightBigInt);
                break;
            }
            case FLOAT: {
                float lVal = l.floatValue();
                float rVal = r.floatValue();
                if (Float.isNaN(lVal) || Float.isNaN(rVal)) {
                    return new NumericValue(op == CBinaryExpression.BinaryOperator.NOT_EQUALS ? 1L : 0L);
                }
                if (lVal == 0.0f && rVal == 0.0f) {
                    cmp = 0;
                    break;
                }
                cmp = Float.compare(lVal, rVal);
                break;
            }
            case DOUBLE: {
                double lVal = l.doubleValue();
                double rVal = r.doubleValue();
                if (Double.isNaN(lVal) || Double.isNaN(rVal)) {
                    return new NumericValue(op == CBinaryExpression.BinaryOperator.NOT_EQUALS ? 1L : 0L);
                }
                if (lVal == 0.0 && rVal == 0.0) {
                    cmp = 0;
                    break;
                }
                cmp = Double.compare(lVal, rVal);
                break;
            }
            default: {
                this.logger.logf(Level.FINE, "unsupported type %s for result of binary operation %s", new Object[]{type.toString(), op});
                return Value.UnknownValue.getInstance();
            }
        }
        return new NumericValue(this.matchBooleanOperation(op, cmp) ? 1L : 0L);
    }

    public Value castCValue(@NonNull Value value, CType targetType, MachineModel machineModel) {
        int size;
        if (!value.isExplicitlyKnown()) {
            if (value instanceof AddressExpression || value instanceof SymbolicIdentifier && ((SymbolicIdentifier)value).getRepresentedLocation().isPresent()) {
                return value;
            }
            return SMGCPAValueVisitor.castIfSymbolic(value, targetType, Optional.of(machineModel));
        }
        if (!value.isNumericValue()) {
            this.logger.logf(Level.FINE, "Can not cast C value %s to %s", new Object[]{value.toString(), targetType.toString()});
            return value;
        }
        NumericValue numericValue = (NumericValue)value;
        CType type = targetType.getCanonicalType();
        if (type instanceof CSimpleType) {
            CSimpleType st = (CSimpleType)type;
            size = machineModel.getSizeofInBits(st);
        } else if (type instanceof CBitFieldType) {
            size = ((CBitFieldType)type).getBitFieldSize();
            type = ((CBitFieldType)type).getType();
        } else {
            return value;
        }
        return this.castNumeric(numericValue, type, machineModel, size);
    }

    private static Value castIfSymbolic(Value pValue, Type pTargetType, Optional<MachineModel> pMachineModel) {
        SymbolicValueFactory factory = SymbolicValueFactory.getInstance();
        if (pValue instanceof SymbolicValue && (pTargetType instanceof JSimpleType || pTargetType instanceof CSimpleType)) {
            return factory.cast((SymbolicValue)pValue, pTargetType, pMachineModel);
        }
        return pValue;
    }

    private boolean matchBooleanOperation(CBinaryExpression.BinaryOperator op, int cmp) {
        switch (op) {
            case GREATER_THAN: {
                return cmp > 0;
            }
            case GREATER_EQUAL: {
                return cmp >= 0;
            }
            case LESS_THAN: {
                return cmp < 0;
            }
            case LESS_EQUAL: {
                return cmp <= 0;
            }
            case EQUALS: {
                return cmp == 0;
            }
            case NOT_EQUALS: {
                return cmp != 0;
            }
        }
        throw new AssertionError((Object)("Unknown binary operation: " + op));
    }

    public @Nullable CSimpleType getArithmeticType(CType type) {
        if ((type = type.getCanonicalType()) instanceof CPointerType) {
            return CNumericTypes.INT;
        }
        if (type instanceof CSimpleType) {
            return (CSimpleType)type;
        }
        return null;
    }

    private boolean isArithmeticOperation(CBinaryExpression.BinaryOperator binaryOperator) {
        switch (binaryOperator) {
            case PLUS: 
            case MINUS: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULO: 
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: {
                return true;
            }
        }
        return false;
    }

    private boolean isComparison(CBinaryExpression.BinaryOperator binaryOperator) {
        switch (binaryOperator) {
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case LESS_EQUAL: 
            case GREATER_THAN: 
            case GREATER_EQUAL: {
                return true;
            }
        }
        return false;
    }

    protected SMGState getInitialVisitorState() {
        return this.state;
    }

    protected CFAEdge getInitialVisitorCFAEdge() {
        return this.cfaEdge;
    }

    protected SMGCPAExpressionEvaluator getInitialVisitorEvaluator() {
        return this.evaluator;
    }

    protected LogManagerWithoutDuplicates getInitialVisitorLogger() {
        return this.logger;
    }
}

