/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.DummyCFAEdge;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CDefaults;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPAValueVisitor;
import org.sosy_lab.cpachecker.cpa.smg2.SMGErrorInfo;
import org.sosy_lab.cpachecker.cpa.smg2.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.SymbolicProgramConfiguration;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMG2Exception;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGStateAndOptionalSMGObjectAndOffset;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGValueAndSMGState;
import org.sosy_lab.cpachecker.cpa.smg2.util.value.SMGCPAExpressionEvaluator;
import org.sosy_lab.cpachecker.cpa.smg2.util.value.ValueAndSMGState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.AddressExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.ConstantSymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicIdentifier;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueFactory;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;

public class SMGCPAValueVisitorTest {
    private static final CType CHAR_TYPE = CNumericTypes.CHAR;
    private static final CType SHORT_TYPE = CNumericTypes.SHORT_INT;
    private static final CType UNSIGNED_SHORT_TYPE = CNumericTypes.UNSIGNED_SHORT_INT;
    private static final CType INT_TYPE = CNumericTypes.INT;
    private static final CType UNSIGNED_INT_TYPE = CNumericTypes.UNSIGNED_INT;
    private static final CType LONG_TYPE = CNumericTypes.LONG_INT;
    private static final CType UNSIGNED_LONG_TYPE = CNumericTypes.UNSIGNED_LONG_INT;
    private static final CType FLOAT_TYPE = CNumericTypes.FLOAT;
    private static final CType DOUBLE_TYPE = CNumericTypes.DOUBLE;
    private static final String COMPOSITE_VARIABLE_NAME = "compositeVariableName";
    private static final String COMPOSITE_DECLARATION_NAME = "compositeDeclaration";
    private static final CType[] BIT_FIELD_TYPES = new CType[]{CHAR_TYPE, SHORT_TYPE, UNSIGNED_SHORT_TYPE, INT_TYPE, UNSIGNED_INT_TYPE, LONG_TYPE, UNSIGNED_LONG_TYPE};
    private static final MachineModel MACHINE_MODEL = MachineModel.LINUX64;
    private static final int POINTER_SIZE_IN_BITS = MACHINE_MODEL.getSizeof(MACHINE_MODEL.getPointerEquivalentSimpleType()) * 8;
    private static final List<CType> STRUCT_UNION_TEST_TYPES = ImmutableList.of((Object)SHORT_TYPE, (Object)INT_TYPE, (Object)UNSIGNED_SHORT_TYPE, (Object)UNSIGNED_INT_TYPE, (Object)LONG_TYPE, (Object)UNSIGNED_LONG_TYPE, (Object)CHAR_TYPE);
    private static final List<CType> ARRAY_TEST_TYPES = ImmutableList.of((Object)SHORT_TYPE, (Object)INT_TYPE, (Object)UNSIGNED_SHORT_TYPE, (Object)UNSIGNED_INT_TYPE, (Object)LONG_TYPE, (Object)UNSIGNED_LONG_TYPE, (Object)CHAR_TYPE);
    private static final int TEST_ARRAY_LENGTH = 40;
    private LogManagerWithoutDuplicates logger;
    private SMGCPAExpressionEvaluator evaluator;
    private SMGState currentState;
    private SMGCPAValueVisitor visitor;

    @Before
    public void init() throws InvalidConfigurationException {
        this.logger = new LogManagerWithoutDuplicates(LogManager.createTestLogManager());
        this.evaluator = new SMGCPAExpressionEvaluator(MACHINE_MODEL, this.logger, null, null);
        this.currentState = SMGState.of(MACHINE_MODEL, (LogManager)this.logger, new SMGOptions(Configuration.defaultConfiguration()));
        this.visitor = new SMGCPAValueVisitor(this.evaluator, this.currentState, new DummyCFAEdge(null, null), this.logger);
    }

    public void resetSMGStateAndVisitor() throws InvalidConfigurationException {
        this.currentState = SMGState.of(MACHINE_MODEL, (LogManager)this.logger, new SMGOptions(Configuration.defaultConfiguration()));
        this.visitor = new SMGCPAValueVisitor(this.evaluator, this.currentState, new DummyCFAEdge(null, null), this.logger);
    }

    @Test
    public void readFieldDerefTest() throws InvalidConfigurationException, CPATransferException {
        for (int i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
            CFieldReference fieldRef = this.createFieldRefForStackVar(COMPOSITE_DECLARATION_NAME, COMPOSITE_VARIABLE_NAME, i, STRUCT_UNION_TEST_TYPES, true, CComplexType.ComplexTypeKind.STRUCT);
            NumericValue intValue = new NumericValue(i);
            ConstantSymbolicExpression addressValue = new ConstantSymbolicExpression(new Value.UnknownValue(), null);
            this.addHeapVariableToMemoryModel(0, this.getSizeInBitsForListOfCTypeWithPadding(STRUCT_UNION_TEST_TYPES), addressValue);
            this.addStackVariableToMemoryModel(COMPOSITE_VARIABLE_NAME, POINTER_SIZE_IN_BITS);
            this.writeToStackVariableInMemoryModel(COMPOSITE_VARIABLE_NAME, 0, POINTER_SIZE_IN_BITS, addressValue);
            this.writeToHeapObjectByAddress(addressValue, this.getOffsetInBitsWithPadding(STRUCT_UNION_TEST_TYPES, i), MACHINE_MODEL.getSizeof(STRUCT_UNION_TEST_TYPES.get(i)).intValue() * 8, intValue);
            List<ValueAndSMGState> resultList = fieldRef.accept(this.visitor);
            Truth.assertThat(resultList).hasSize(1);
            Value resultValue = resultList.get(0).getValue();
            Truth.assertThat((Object)resultValue).isInstanceOf(NumericValue.class);
            Truth.assertThat((Comparable)resultValue.asNumericValue().bigInteger()).isEqualTo((Object)BigInteger.valueOf(i));
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void readStructDerefWithPointerValuesTest() throws InvalidConfigurationException, CPATransferException {
        ArrayList<SymbolicIdentifier> addresses = new ArrayList<SymbolicIdentifier>();
        SymbolicIdentifier addressOfStructValue = SymbolicValueFactory.getInstance().newIdentifier(null);
        this.addHeapVariableToMemoryModel(0, STRUCT_UNION_TEST_TYPES.size() * POINTER_SIZE_IN_BITS, addressOfStructValue);
        this.addStackVariableToMemoryModel(COMPOSITE_VARIABLE_NAME, POINTER_SIZE_IN_BITS);
        this.writeToStackVariableInMemoryModel(COMPOSITE_VARIABLE_NAME, 0, POINTER_SIZE_IN_BITS, addressOfStructValue);
        for (int i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
            SymbolicIdentifier addressValue = SymbolicValueFactory.getInstance().newIdentifier(null);
            this.writeToHeapObjectByAddress(addressOfStructValue, i * POINTER_SIZE_IN_BITS, POINTER_SIZE_IN_BITS, addressValue);
            addresses.add(addressValue);
        }
        for (int repeatRead = 0; repeatRead < 2; ++repeatRead) {
            for (int i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
                CFieldReference fieldRef = this.createStructFieldRefWithPointerNoDeref(COMPOSITE_DECLARATION_NAME, COMPOSITE_VARIABLE_NAME, i, (List<CType>)Collections3.transformedImmutableListCopy(STRUCT_UNION_TEST_TYPES, n -> new CPointerType(false, false, (CType)n)));
                List<ValueAndSMGState> resultList = fieldRef.accept(this.visitor);
                Truth.assertThat(resultList).hasSize(1);
                Value resultValue = resultList.get(0).getValue();
                Truth.assertThat((Object)resultValue).isInstanceOf(AddressExpression.class);
                Truth.assertThat((Object)((AddressExpression)resultValue).getMemoryAddress()).isEqualTo(addresses.get(i));
                Truth.assertThat((Boolean)((AddressExpression)resultValue).getOffset().isNumericValue()).isTrue();
                Truth.assertThat((Comparable)((AddressExpression)resultValue).getOffset().asNumericValue().bigInteger()).isEqualTo((Object)BigInteger.ZERO);
            }
        }
    }

    @Test
    public void readFieldDerefWithPointerValuesTest() throws InvalidConfigurationException, CPATransferException {
        ArrayList<SymbolicIdentifier> addresses = new ArrayList<SymbolicIdentifier>();
        SymbolicIdentifier addressOfStructValue = SymbolicValueFactory.getInstance().newIdentifier(null);
        this.addHeapVariableToMemoryModel(0, STRUCT_UNION_TEST_TYPES.size() * POINTER_SIZE_IN_BITS, addressOfStructValue);
        this.addStackVariableToMemoryModel(COMPOSITE_VARIABLE_NAME, POINTER_SIZE_IN_BITS);
        this.writeToStackVariableInMemoryModel(COMPOSITE_VARIABLE_NAME, 0, POINTER_SIZE_IN_BITS, addressOfStructValue);
        for (int i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
            SymbolicIdentifier addressValue = SymbolicValueFactory.getInstance().newIdentifier(null);
            this.writeToHeapObjectByAddress(addressOfStructValue, i * POINTER_SIZE_IN_BITS, POINTER_SIZE_IN_BITS, addressValue);
            addresses.add(addressValue);
        }
        for (int repeatRead = 0; repeatRead < 2; ++repeatRead) {
            for (int i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
                CFieldReference fieldRef = this.createFieldRefForStackVar(COMPOSITE_DECLARATION_NAME, COMPOSITE_VARIABLE_NAME, i, (List<CType>)Collections3.transformedImmutableListCopy(STRUCT_UNION_TEST_TYPES, n -> new CPointerType(false, false, (CType)n)), true, CComplexType.ComplexTypeKind.STRUCT);
                List<ValueAndSMGState> resultList = fieldRef.accept(this.visitor);
                Truth.assertThat(resultList).hasSize(1);
                Value resultValue = resultList.get(0).getValue();
                Truth.assertThat((Object)resultValue).isInstanceOf(AddressExpression.class);
                Truth.assertThat((Object)((AddressExpression)resultValue).getMemoryAddress()).isEqualTo(addresses.get(i));
                Truth.assertThat((Boolean)((AddressExpression)resultValue).getOffset().isNumericValue()).isTrue();
                Truth.assertThat((Comparable)((AddressExpression)resultValue).getOffset().asNumericValue().bigInteger()).isEqualTo((Object)BigInteger.ZERO);
            }
        }
    }

    @Test
    public void readFieldFromStackWithPointerValuesTest() throws CPATransferException {
        ArrayList<SymbolicIdentifier> addresses = new ArrayList<SymbolicIdentifier>();
        this.addStackVariableToMemoryModel(COMPOSITE_VARIABLE_NAME, STRUCT_UNION_TEST_TYPES.size() * POINTER_SIZE_IN_BITS);
        for (int i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
            SymbolicIdentifier addressValue = SymbolicValueFactory.getInstance().newIdentifier(null);
            this.writeToStackVariableInMemoryModel(COMPOSITE_VARIABLE_NAME, i * POINTER_SIZE_IN_BITS, POINTER_SIZE_IN_BITS, addressValue);
            addresses.add(addressValue);
        }
        for (int repeatRead = 0; repeatRead < 2; ++repeatRead) {
            for (int i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
                CFieldReference fieldRef = this.createFieldRefForStackVar(COMPOSITE_DECLARATION_NAME, COMPOSITE_VARIABLE_NAME, i, (List<CType>)Collections3.transformedImmutableListCopy(STRUCT_UNION_TEST_TYPES, n -> new CPointerType(false, false, (CType)n)), false, CComplexType.ComplexTypeKind.STRUCT);
                List<ValueAndSMGState> resultList = fieldRef.accept(this.visitor);
                Truth.assertThat(resultList).hasSize(1);
                Value resultValue = resultList.get(0).getValue();
                Truth.assertThat((Object)resultValue).isInstanceOf(AddressExpression.class);
                Truth.assertThat((Object)((AddressExpression)resultValue).getMemoryAddress()).isEqualTo(addresses.get(i));
                Truth.assertThat((Boolean)((AddressExpression)resultValue).getOffset().isNumericValue()).isTrue();
                Truth.assertThat((Comparable)((AddressExpression)resultValue).getOffset().asNumericValue().bigInteger()).isEqualTo((Object)BigInteger.ZERO);
            }
        }
    }

    @Test
    public void readFieldDerefRepeatedTest() throws InvalidConfigurationException, CPATransferException {
        this.setupHeapStructAndFill(COMPOSITE_VARIABLE_NAME, STRUCT_UNION_TEST_TYPES);
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
                CFieldReference fieldRef = this.createFieldRefForStackVar(COMPOSITE_DECLARATION_NAME, COMPOSITE_VARIABLE_NAME, i, STRUCT_UNION_TEST_TYPES, true, CComplexType.ComplexTypeKind.STRUCT);
                List<ValueAndSMGState> resultList = fieldRef.accept(this.visitor);
                Truth.assertThat(resultList).hasSize(1);
                Value resultValue = resultList.get(0).getValue();
                Truth.assertThat((Object)resultValue).isInstanceOf(NumericValue.class);
                this.checkValue(STRUCT_UNION_TEST_TYPES.get(i), i, resultValue);
            }
        }
    }

    @Test
    public void readFieldDerefPointerExplicitlyTest() throws InvalidConfigurationException, CPATransferException {
        for (int i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
            NumericValue intValue = new NumericValue(i);
            ConstantSymbolicExpression addressValue = new ConstantSymbolicExpression(new Value.UnknownValue(), null);
            this.addHeapVariableToMemoryModel(0, this.getSizeInBitsForListOfCTypeWithPadding(STRUCT_UNION_TEST_TYPES), addressValue);
            this.addStackVariableToMemoryModel(COMPOSITE_VARIABLE_NAME, POINTER_SIZE_IN_BITS);
            this.writeToStackVariableInMemoryModel(COMPOSITE_VARIABLE_NAME, 0, POINTER_SIZE_IN_BITS, addressValue);
            this.writeToHeapObjectByAddress(addressValue, this.getOffsetInBitsWithPadding(STRUCT_UNION_TEST_TYPES, i), MACHINE_MODEL.getSizeof(STRUCT_UNION_TEST_TYPES.get(i)).intValue() * 8, intValue);
            CFieldReference fieldRef = this.createStructFieldRefWithPointerNoDeref(COMPOSITE_DECLARATION_NAME, COMPOSITE_VARIABLE_NAME, i, STRUCT_UNION_TEST_TYPES);
            List<ValueAndSMGState> resultList = fieldRef.accept(this.visitor);
            Truth.assertThat(resultList).hasSize(1);
            Value resultValue = resultList.get(0).getValue();
            Truth.assertThat((Object)resultValue).isInstanceOf(NumericValue.class);
            Truth.assertThat((Comparable)resultValue.asNumericValue().bigInteger()).isEqualTo((Object)BigInteger.valueOf(i));
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void readFieldDerefPointerExplicitlyRepeatedlyTest() throws InvalidConfigurationException, CPATransferException {
        ConstantSymbolicExpression addressValue = new ConstantSymbolicExpression(new Value.UnknownValue(), null);
        this.addHeapVariableToMemoryModel(0, this.getSizeInBitsForListOfCTypeWithPadding(STRUCT_UNION_TEST_TYPES), addressValue);
        this.addStackVariableToMemoryModel(COMPOSITE_VARIABLE_NAME, POINTER_SIZE_IN_BITS);
        this.writeToStackVariableInMemoryModel(COMPOSITE_VARIABLE_NAME, 0, POINTER_SIZE_IN_BITS, addressValue);
        for (int i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
            NumericValue intValue = new NumericValue(i);
            this.writeToHeapObjectByAddress(addressValue, this.getOffsetInBitsWithPadding(STRUCT_UNION_TEST_TYPES, i), MACHINE_MODEL.getSizeof(STRUCT_UNION_TEST_TYPES.get(i)).intValue() * 8, intValue);
        }
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
                CFieldReference fieldRef = this.createStructFieldRefWithPointerNoDeref(COMPOSITE_DECLARATION_NAME, COMPOSITE_VARIABLE_NAME, i, STRUCT_UNION_TEST_TYPES);
                List<ValueAndSMGState> resultList = fieldRef.accept(this.visitor);
                Truth.assertThat(resultList).hasSize(1);
                Value resultValue = resultList.get(0).getValue();
                Truth.assertThat((Object)resultValue).isInstanceOf(NumericValue.class);
                Truth.assertThat((Comparable)resultValue.asNumericValue().bigInteger()).isEqualTo((Object)BigInteger.valueOf(i));
            }
        }
    }

    @Test
    public void readFieldWithStructOnStackTest() throws CPATransferException, InvalidConfigurationException {
        for (int i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
            CFieldReference fieldRef = this.createFieldRefForStackVar(COMPOSITE_DECLARATION_NAME, COMPOSITE_VARIABLE_NAME, i, STRUCT_UNION_TEST_TYPES, false, CComplexType.ComplexTypeKind.STRUCT);
            NumericValue intValue = new NumericValue(i);
            this.addStackVariableToMemoryModel(COMPOSITE_VARIABLE_NAME, this.getSizeInBitsForListOfCTypeWithPadding(STRUCT_UNION_TEST_TYPES));
            this.writeToStackVariableInMemoryModel(COMPOSITE_VARIABLE_NAME, this.getOffsetInBitsWithPadding(STRUCT_UNION_TEST_TYPES, i), MACHINE_MODEL.getSizeof(STRUCT_UNION_TEST_TYPES.get(i)).intValue() * 8, intValue);
            List<ValueAndSMGState> resultList = fieldRef.accept(this.visitor);
            Truth.assertThat(resultList).hasSize(1);
            Value resultValue = resultList.get(0).getValue();
            Truth.assertThat((Object)resultValue).isInstanceOf(NumericValue.class);
            Truth.assertThat((Comparable)resultValue.asNumericValue().bigInteger()).isEqualTo((Object)BigInteger.valueOf(i));
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void readFieldWithStructOnStackRepeatedTest() throws CPATransferException {
        this.createStackVarOnStackAndFill(COMPOSITE_VARIABLE_NAME, STRUCT_UNION_TEST_TYPES);
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
                CFieldReference fieldRef = this.createFieldRefForStackVar(COMPOSITE_DECLARATION_NAME, COMPOSITE_VARIABLE_NAME, i, STRUCT_UNION_TEST_TYPES, false, CComplexType.ComplexTypeKind.STRUCT);
                List<ValueAndSMGState> resultList = fieldRef.accept(this.visitor);
                Truth.assertThat(resultList).hasSize(1);
                Value resultValue = resultList.get(0).getValue();
                Truth.assertThat((Object)resultValue).isInstanceOf(NumericValue.class);
                Truth.assertThat((Comparable)resultValue.asNumericValue().bigInteger()).isEqualTo((Object)BigInteger.valueOf(i));
            }
        }
    }

    @Test
    public void readFieldZeroWithUnionOnStackRepeatedTest() throws CPATransferException {
        this.addStackVariableToMemoryModel(COMPOSITE_VARIABLE_NAME, this.getLargestSizeInBitsForListOfCType(STRUCT_UNION_TEST_TYPES));
        this.writeToStackVariableInMemoryModel(COMPOSITE_VARIABLE_NAME, 0, this.getLargestSizeInBitsForListOfCType(STRUCT_UNION_TEST_TYPES), new NumericValue(0));
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
                CFieldReference fieldRef = this.createFieldRefForStackVar(COMPOSITE_DECLARATION_NAME, COMPOSITE_VARIABLE_NAME, i, STRUCT_UNION_TEST_TYPES, false, CComplexType.ComplexTypeKind.UNION);
                List<ValueAndSMGState> resultList = fieldRef.accept(this.visitor);
                Truth.assertThat(resultList).hasSize(1);
                Value resultValue = resultList.get(0).getValue();
                Truth.assertThat((Object)resultValue).isInstanceOf(NumericValue.class);
                Truth.assertThat((Comparable)resultValue.asNumericValue().bigInteger()).isEqualTo((Object)BigInteger.ZERO);
            }
        }
    }

    @Test
    public void readFieldWithUnionOnStackRepeatedTest() throws CPATransferException {
        this.addStackVariableToMemoryModel(COMPOSITE_VARIABLE_NAME, this.getLargestSizeInBitsForListOfCType(STRUCT_UNION_TEST_TYPES));
        for (int k = 0; k < STRUCT_UNION_TEST_TYPES.size(); ++k) {
            NumericValue intValue = new NumericValue(k + 1);
            this.writeToStackVariableInMemoryModel(COMPOSITE_VARIABLE_NAME, 0, MACHINE_MODEL.getSizeof(STRUCT_UNION_TEST_TYPES.get(k)).intValue() * 8, intValue);
            for (int i = 0; i < STRUCT_UNION_TEST_TYPES.size(); ++i) {
                CFieldReference fieldRef = this.createFieldRefForStackVar(COMPOSITE_DECLARATION_NAME, COMPOSITE_VARIABLE_NAME, i, STRUCT_UNION_TEST_TYPES, false, CComplexType.ComplexTypeKind.UNION);
                for (int j = 0; j < 4; ++j) {
                    List<ValueAndSMGState> resultList = fieldRef.accept(this.visitor);
                    Truth.assertThat(resultList).hasSize(1);
                    Value resultValue = resultList.get(0).getValue();
                    if (MACHINE_MODEL.getSizeof(STRUCT_UNION_TEST_TYPES.get(k)).compareTo(MACHINE_MODEL.getSizeof(STRUCT_UNION_TEST_TYPES.get(i))) == 0) {
                        Truth.assertThat((Object)resultValue).isInstanceOf(NumericValue.class);
                        Truth.assertThat((Comparable)resultValue.asNumericValue().bigInteger()).isEqualTo((Object)BigInteger.valueOf(k + 1));
                        continue;
                    }
                    Truth.assertThat((Object)resultValue).isInstanceOf(ConstantSymbolicExpression.class);
                }
            }
        }
    }

    @Test
    public void readStackArraySubscriptConstMultipleTypesRepeated() throws CPATransferException, InvalidConfigurationException {
        String arrayVariableName = "arrayVariable";
        for (CType currentArrayType : ARRAY_TEST_TYPES) {
            this.setupStackArray(arrayVariableName, currentArrayType);
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 40; ++k) {
                    CArraySubscriptExpression arraySubscriptExpr = this.arraySubscriptStackAccess(arrayVariableName, currentArrayType, k, 40);
                    List<ValueAndSMGState> resultList = arraySubscriptExpr.accept(this.visitor);
                    Truth.assertThat(resultList).hasSize(1);
                    Value resultValue = resultList.get(0).getValue();
                    this.checkValue(currentArrayType, k, resultValue);
                }
            }
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void readStackArraySubscriptWithVariableMultipleTypesRepeated() throws CPATransferException, InvalidConfigurationException {
        String arrayVariableName = "arrayVariable";
        String indiceVariableName = "indexVariableName";
        CType indexVarType = INT_TYPE;
        for (CType currentArrayType : ARRAY_TEST_TYPES) {
            this.setupStackArray(arrayVariableName, currentArrayType);
            this.setupIndexVariables(indiceVariableName);
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 40; ++k) {
                    CArraySubscriptExpression arraySubscriptExpr = this.arraySubscriptStackAccessWithVariable(arrayVariableName, indiceVariableName + k, currentArrayType, indexVarType, 40);
                    List<ValueAndSMGState> resultList = arraySubscriptExpr.accept(this.visitor);
                    Truth.assertThat(resultList).hasSize(1);
                    Value resultValue = resultList.get(0).getValue();
                    this.checkValue(currentArrayType, k, resultValue);
                }
            }
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void readHeapArraySubscriptConstMultipleTypesRepeated() throws CPATransferException, InvalidConfigurationException {
        String arrayVariableName = "arrayVariable";
        for (CType currentArrayType : ARRAY_TEST_TYPES) {
            this.setupHeapArray(arrayVariableName, currentArrayType);
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 40; ++k) {
                    CArraySubscriptExpression arraySubscriptExpr = this.arraySubscriptHeapAccess(arrayVariableName, currentArrayType, k);
                    List<ValueAndSMGState> resultList = arraySubscriptExpr.accept(this.visitor);
                    Truth.assertThat(resultList).hasSize(1);
                    Value resultValue = resultList.get(0).getValue();
                    this.checkValue(currentArrayType, k, resultValue);
                }
            }
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void readHeapArraySubscriptWithVariableMultipleTypesRepeated() throws CPATransferException, InvalidConfigurationException {
        String arrayVariableName = "arrayVariable";
        String indexVariableName = "indexVariable";
        for (CType currentArrayType : ARRAY_TEST_TYPES) {
            this.setupHeapArray(arrayVariableName, currentArrayType);
            this.setupIndexVariables(indexVariableName);
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 40; ++k) {
                    CArraySubscriptExpression arraySubscriptExpr = this.arraySubscriptHeapAccessWithVariable(arrayVariableName, indexVariableName + k, INT_TYPE, currentArrayType);
                    List<ValueAndSMGState> resultList = arraySubscriptExpr.accept(this.visitor);
                    Truth.assertThat(resultList).hasSize(1);
                    Value resultValue = resultList.get(0).getValue();
                    this.checkValue(currentArrayType, k, resultValue);
                }
            }
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void readNestedPointerHeapArrayLeadingToConstArrayMultipleTypesRepeated() throws CPATransferException, InvalidConfigurationException {
        String pointerArrayName = "pointerArrayVariable";
        for (CType currentValueArrayType : ARRAY_TEST_TYPES) {
            int sizeOfCurrentTypeInBits = MACHINE_MODEL.getSizeof(currentValueArrayType).intValue() * 8;
            SymbolicIdentifier addressValueArray = SymbolicValueFactory.getInstance().newIdentifier(null);
            this.addHeapVariableToMemoryModel(0, sizeOfCurrentTypeInBits * 40, addressValueArray);
            for (int k = 0; k < 40; ++k) {
                Value arrayValue = this.transformInputIntoValue(currentValueArrayType, k);
                this.writeToHeapObjectByAddress(addressValueArray, sizeOfCurrentTypeInBits * k, sizeOfCurrentTypeInBits, arrayValue);
            }
            SymbolicIdentifier addressPointerArray = SymbolicValueFactory.getInstance().newIdentifier(null);
            this.addStackVariableToMemoryModel(pointerArrayName, POINTER_SIZE_IN_BITS);
            this.writeToStackVariableInMemoryModel(pointerArrayName, 0, POINTER_SIZE_IN_BITS, addressPointerArray);
            this.addHeapVariableToMemoryModel(0, POINTER_SIZE_IN_BITS * 40, addressPointerArray);
            SMGObject objectForAddressValue = this.currentState.dereferencePointer(addressValueArray).get(0).getSMGObject();
            for (int j = 0; j < 40; ++j) {
                Value address = this.addPointerToMemory(objectForAddressValue, j * sizeOfCurrentTypeInBits);
                this.writeToHeapObjectByAddress(addressPointerArray, POINTER_SIZE_IN_BITS * j, POINTER_SIZE_IN_BITS, address);
            }
            for (int read = 0; read < 2; ++read) {
                for (int pointerArrayOffset = 0; pointerArrayOffset < 40; ++pointerArrayOffset) {
                    for (int valueArrayOffset = -pointerArrayOffset - 1; valueArrayOffset < 40; ++valueArrayOffset) {
                        int realIndex = valueArrayOffset + pointerArrayOffset;
                        CPointerExpression arrayPointerExpr = this.pointerWithBinaryAccessFromExpression(pointerArrayName, currentValueArrayType, pointerArrayOffset, valueArrayOffset);
                        if (realIndex < 0 || realIndex >= 40) {
                            List<ValueAndSMGState> visitedValuesAndStates = arrayPointerExpr.accept(this.visitor);
                            Truth.assertThat(visitedValuesAndStates).hasSize(1);
                            ValueAndSMGState visitedValueAndState = visitedValuesAndStates.get(0);
                            Truth.assertThat((Object)visitedValueAndState.getValue()).isEqualTo((Object)Value.UnknownValue.getInstance());
                            Truth.assertThat(visitedValueAndState.getState().getErrorInfo()).hasSize(1);
                            SMGErrorInfo error = visitedValueAndState.getState().getErrorInfo().get(0);
                            Truth.assertThat((Boolean)error.isInvalidRead()).isTrue();
                            continue;
                        }
                        List<ValueAndSMGState> resultList = arrayPointerExpr.accept(this.visitor);
                        Truth.assertThat(resultList).hasSize(1);
                        Value resultValue = resultList.get(0).getValue();
                        this.checkValue(currentValueArrayType, realIndex, resultValue);
                    }
                }
            }
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void readHeapArrayConstMultipleTypesRepeated() throws CPATransferException, InvalidConfigurationException {
        String arrayVariableName = "arrayVariable";
        for (CType currentArrayType : ARRAY_TEST_TYPES) {
            this.setupHeapArray(arrayVariableName, currentArrayType);
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 40; ++k) {
                    CPointerExpression arrayPointerExpr = this.arrayPointerAccess(arrayVariableName, currentArrayType, k);
                    List<ValueAndSMGState> resultList = arrayPointerExpr.accept(this.visitor);
                    Truth.assertThat(resultList).hasSize(1);
                    Value resultValue = resultList.get(0).getValue();
                    this.checkValue(currentArrayType, k, resultValue);
                }
            }
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void readHeapArrayConst2PointersMultipleTypesRepeated() throws CPATransferException, InvalidConfigurationException {
        String arrayVariableName = "arrayVariable";
        String addressToAddressVariableName = "addressToAddressVariableName";
        for (CType currentArrayType : ARRAY_TEST_TYPES) {
            int sizeOfCurrentTypeInBits = MACHINE_MODEL.getSizeof(currentArrayType).intValue() * 8;
            SymbolicIdentifier addressValue = SymbolicValueFactory.getInstance().newIdentifier(null);
            this.addHeapVariableToMemoryModel(0, sizeOfCurrentTypeInBits * 40, addressValue);
            this.addStackVariableToMemoryModel(arrayVariableName, POINTER_SIZE_IN_BITS);
            this.writeToStackVariableInMemoryModel(arrayVariableName, 0, POINTER_SIZE_IN_BITS, addressValue);
            this.addStackVariableToMemoryModel(addressToAddressVariableName, POINTER_SIZE_IN_BITS);
            SMGObject objectForAddressValue = this.currentState.getMemoryModel().getStackFrames().peek().getVariable(arrayVariableName);
            Value addressForAddressValue = this.addPointerToMemory(objectForAddressValue, 0);
            this.writeToStackVariableInMemoryModel(addressToAddressVariableName, 0, POINTER_SIZE_IN_BITS, addressForAddressValue);
            for (int k = 0; k < 40; ++k) {
                Value arrayValue = this.transformInputIntoValue(currentArrayType, k);
                this.writeToHeapObjectByAddress(addressValue, sizeOfCurrentTypeInBits * k, sizeOfCurrentTypeInBits, arrayValue);
            }
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 40; ++k) {
                    CPointerExpression arrayPointerExpr = this.pointerOfPointerAccess(addressToAddressVariableName, currentArrayType, k);
                    List<ValueAndSMGState> resultList = arrayPointerExpr.accept(this.visitor);
                    Truth.assertThat(resultList).hasSize(1);
                    Value resultValue = resultList.get(0).getValue();
                    this.checkValue(currentArrayType, k, resultValue);
                }
            }
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void readHeapArrayVariableMultipleTypesRepeated() throws CPATransferException, InvalidConfigurationException {
        String arrayVariableName = "arrayVariable";
        String indexVariableName = "indexVariableName";
        CType indexVarType = INT_TYPE;
        for (CType currentArrayType : ARRAY_TEST_TYPES) {
            this.setupHeapArray(arrayVariableName, currentArrayType);
            this.setupIndexVariables(indexVariableName);
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 40; ++k) {
                    CPointerExpression arrayPointerExpr = this.arrayPointerAccessPlusVariableIndexOnTheRight(arrayVariableName, indexVariableName + k, indexVarType, currentArrayType);
                    List<ValueAndSMGState> resultList = arrayPointerExpr.accept(this.visitor);
                    Truth.assertThat(resultList).hasSize(1);
                    Value resultValue = resultList.get(0).getValue();
                    this.checkValue(currentArrayType, k, resultValue);
                }
            }
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void readHeapArrayVariableLeftMultipleTypesRepeated() throws CPATransferException, InvalidConfigurationException {
        String arrayVariableName = "arrayVariable";
        String indexVariableName = "indexVariableName";
        CType indexVarType = INT_TYPE;
        for (CType currentArrayType : ARRAY_TEST_TYPES) {
            this.setupHeapArray(arrayVariableName, currentArrayType);
            this.setupIndexVariables(indexVariableName);
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 40; ++k) {
                    CPointerExpression arrayPointerExpr = this.arrayPointerAccessPlusVariableIndexOnTheLeft(arrayVariableName, indexVariableName + k, indexVarType, currentArrayType);
                    List<ValueAndSMGState> resultList = arrayPointerExpr.accept(this.visitor);
                    Truth.assertThat(resultList).hasSize(1);
                    Value resultValue = resultList.get(0).getValue();
                    this.checkValue(currentArrayType, k, resultValue);
                }
            }
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void readHeapArrayMultiplePointerVariableMultipleTypesRepeated() throws CPATransferException, InvalidConfigurationException {
        String arrayVariableName = "arrayVariable";
        String indexVariableName = "indexVariableName";
        CType indexVarType = INT_TYPE;
        for (CType currentArrayType : ARRAY_TEST_TYPES) {
            int k;
            int sizeOfCurrentTypeInBits = MACHINE_MODEL.getSizeof(currentArrayType).intValue() * 8;
            ConstantSymbolicExpression addressValue = new ConstantSymbolicExpression(new Value.UnknownValue(), null);
            this.addHeapVariableToMemoryModel(0, sizeOfCurrentTypeInBits * 40, addressValue);
            this.addStackVariableToMemoryModel(arrayVariableName, POINTER_SIZE_IN_BITS);
            this.writeToStackVariableInMemoryModel(arrayVariableName, 0, POINTER_SIZE_IN_BITS, addressValue);
            for (k = 0; k < 40; ++k) {
                Value arrayValue = this.transformInputIntoValue(currentArrayType, k);
                this.writeToHeapObjectByAddress(addressValue, sizeOfCurrentTypeInBits * k, sizeOfCurrentTypeInBits, arrayValue);
            }
            for (k = 0; k < 40; ++k) {
                this.addStackVariableToMemoryModel(indexVariableName + k, MACHINE_MODEL.getSizeof(indexVarType).intValue() * 8);
                this.writeToStackVariableInMemoryModel(indexVariableName + k, 0, MACHINE_MODEL.getSizeof(indexVarType).intValue() * 8, new NumericValue(k));
            }
            for (int j = 0; j < 40; ++j) {
                Value newPointer = this.addPointerToExistingHeapObject(j * sizeOfCurrentTypeInBits, addressValue);
                this.addStackVariableToMemoryModel(arrayVariableName + j, POINTER_SIZE_IN_BITS);
                this.writeToStackVariableInMemoryModel(arrayVariableName + j, 0, POINTER_SIZE_IN_BITS, newPointer);
            }
            for (k = 0; k < 2; ++k) {
                for (int pointerNum = 0; pointerNum < 40; ++pointerNum) {
                    for (int index = -pointerNum; index < 40 - pointerNum; ++index) {
                        CPointerExpression arrayPointerExpr = index < 0 ? this.arrayPointerAccessMinusVariableIndexOnTheRight(arrayVariableName + pointerNum, indexVariableName + -index, indexVarType, currentArrayType) : this.arrayPointerAccessPlusVariableIndexOnTheRight(arrayVariableName + pointerNum, indexVariableName + index, indexVarType, currentArrayType);
                        List<ValueAndSMGState> resultList = arrayPointerExpr.accept(this.visitor);
                        Truth.assertThat(resultList).hasSize(1);
                        Value resultValue = resultList.get(0).getValue();
                        this.checkValue(currentArrayType, pointerNum + index, resultValue);
                    }
                }
            }
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void readHeapArrayMultiplePointerVariableMultipleTypesRepeatedOutOfBoundsRead() throws CPATransferException, InvalidConfigurationException {
        String arrayVariableName = "arrayVariable";
        String indexVariableName = "indexVariableName";
        CType indexVarType = INT_TYPE;
        for (CType currentArrayType : ARRAY_TEST_TYPES) {
            int k;
            int sizeOfCurrentTypeInBits = MACHINE_MODEL.getSizeof(currentArrayType).intValue() * 8;
            ConstantSymbolicExpression addressValue = new ConstantSymbolicExpression(new Value.UnknownValue(), null);
            this.addHeapVariableToMemoryModel(0, sizeOfCurrentTypeInBits * 40, addressValue);
            this.addStackVariableToMemoryModel(arrayVariableName, POINTER_SIZE_IN_BITS);
            this.writeToStackVariableInMemoryModel(arrayVariableName, 0, POINTER_SIZE_IN_BITS, addressValue);
            for (k = -40; k <= 40; ++k) {
                this.addStackVariableToMemoryModel(indexVariableName + k, MACHINE_MODEL.getSizeof(indexVarType).intValue() * 8);
                this.writeToStackVariableInMemoryModel(indexVariableName + k, 0, MACHINE_MODEL.getSizeof(indexVarType).intValue() * 8, new NumericValue(k));
            }
            for (int j = -1; j <= 40; ++j) {
                Value newPointer = this.addPointerToExistingHeapObject(j * sizeOfCurrentTypeInBits, addressValue);
                this.addStackVariableToMemoryModel(arrayVariableName + j, POINTER_SIZE_IN_BITS);
                this.writeToStackVariableInMemoryModel(arrayVariableName + j, 0, POINTER_SIZE_IN_BITS, newPointer);
            }
            for (k = 0; k < 2; ++k) {
                for (int pointerNum = -1; pointerNum <= 40; ++pointerNum) {
                    for (int index = -40; index <= 40; ++index) {
                        BigInteger expectedOffset;
                        CPointerExpression arrayPointerExpr;
                        if (pointerNum + index < 0 || pointerNum + index >= 40) {
                            arrayPointerExpr = this.arrayPointerAccessPlusVariableIndexOnTheRight(arrayVariableName + pointerNum, indexVariableName + index, indexVarType, currentArrayType);
                            expectedOffset = BigInteger.valueOf(pointerNum + index).multiply(BigInteger.valueOf(sizeOfCurrentTypeInBits));
                        } else {
                            if (pointerNum - index >= 0 && pointerNum - index < 40) continue;
                            arrayPointerExpr = this.arrayPointerAccessMinusVariableIndexOnTheRight(arrayVariableName + pointerNum, indexVariableName + index, indexVarType, currentArrayType);
                            expectedOffset = BigInteger.valueOf(pointerNum - index).multiply(BigInteger.valueOf(sizeOfCurrentTypeInBits));
                        }
                        List<ValueAndSMGState> visitedValuesAndStates = arrayPointerExpr.accept(this.visitor);
                        Truth.assertThat(visitedValuesAndStates).hasSize(1);
                        ValueAndSMGState visitedValueAndState = visitedValuesAndStates.get(0);
                        Truth.assertThat((Object)visitedValueAndState.getValue()).isEqualTo((Object)Value.UnknownValue.getInstance());
                        Truth.assertThat(visitedValueAndState.getState().getErrorInfo()).hasSize(1);
                        SMGErrorInfo error = visitedValueAndState.getState().getErrorInfo().get(0);
                        Truth.assertThat((Boolean)error.isInvalidRead()).isTrue();
                        BigInteger expectedObjectSize = BigInteger.valueOf(sizeOfCurrentTypeInBits).multiply(BigInteger.valueOf(40L));
                        Truth.assertThat((String)error.getErrorDescription()).contains((CharSequence)("with size " + expectedObjectSize + " bits at offset " + expectedOffset + " bit with read type size " + sizeOfCurrentTypeInBits + " bit"));
                    }
                }
            }
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void readHeapArrayMultiplePointerNegativeVariableMultipleTypesRepeated() throws CPATransferException, InvalidConfigurationException {
        String arrayVariableName = "arrayVariable";
        String indexVariableName = "indexVariableName";
        CType indexVarType = INT_TYPE;
        for (CType currentArrayType : ARRAY_TEST_TYPES) {
            int k;
            int sizeOfCurrentTypeInBits = MACHINE_MODEL.getSizeof(currentArrayType).intValue() * 8;
            ConstantSymbolicExpression addressValue = new ConstantSymbolicExpression(new Value.UnknownValue(), null);
            this.addHeapVariableToMemoryModel(0, sizeOfCurrentTypeInBits * 40, addressValue);
            this.addStackVariableToMemoryModel(arrayVariableName, POINTER_SIZE_IN_BITS);
            this.writeToStackVariableInMemoryModel(arrayVariableName, 0, POINTER_SIZE_IN_BITS, addressValue);
            for (k = 0; k < 40; ++k) {
                Value arrayValue = this.transformInputIntoValue(currentArrayType, k);
                this.writeToHeapObjectByAddress(addressValue, sizeOfCurrentTypeInBits * k, sizeOfCurrentTypeInBits, arrayValue);
            }
            for (k = 0; k < 40; ++k) {
                this.addStackVariableToMemoryModel(indexVariableName + k, MACHINE_MODEL.getSizeof(indexVarType).intValue() * 8);
                this.writeToStackVariableInMemoryModel(indexVariableName + k, 0, MACHINE_MODEL.getSizeof(indexVarType).intValue() * 8, new NumericValue(-k));
            }
            for (int j = 0; j < 40; ++j) {
                Value newPointer = this.addPointerToExistingHeapObject(j * sizeOfCurrentTypeInBits, addressValue);
                this.addStackVariableToMemoryModel(arrayVariableName + j, POINTER_SIZE_IN_BITS);
                this.writeToStackVariableInMemoryModel(arrayVariableName + j, 0, POINTER_SIZE_IN_BITS, newPointer);
            }
            for (k = 0; k < 2; ++k) {
                for (int pointerNum = 0; pointerNum < 40; ++pointerNum) {
                    for (int index = -pointerNum; index < 40 - pointerNum; ++index) {
                        CPointerExpression arrayPointerExpr = index < 0 ? this.arrayPointerAccessPlusVariableIndexOnTheRight(arrayVariableName + pointerNum, indexVariableName + -index, indexVarType, currentArrayType) : this.arrayPointerAccessMinusVariableIndexOnTheRight(arrayVariableName + pointerNum, indexVariableName + index, indexVarType, currentArrayType);
                        List<ValueAndSMGState> resultList = arrayPointerExpr.accept(this.visitor);
                        Truth.assertThat(resultList).hasSize(1);
                        Value resultValue = resultList.get(0).getValue();
                        this.checkValue(currentArrayType, pointerNum + index, resultValue);
                    }
                }
            }
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void stackArrayPointerDistance() throws CPATransferException, InvalidConfigurationException {
        String arrayVariableName = "arrayVariable";
        String indexVariableName = "indexVariableName";
        CType indexVarType = INT_TYPE;
        for (CType currentArrayType : ARRAY_TEST_TYPES) {
            int sizeOfCurrentTypeInBits = MACHINE_MODEL.getSizeof(currentArrayType).intValue() * 8;
            SymbolicIdentifier addressValue = SymbolicValueFactory.getInstance().newIdentifier(null);
            this.addHeapVariableToMemoryModel(0, sizeOfCurrentTypeInBits * 40, addressValue);
            this.addStackVariableToMemoryModel(arrayVariableName, POINTER_SIZE_IN_BITS);
            this.writeToStackVariableInMemoryModel(arrayVariableName, 0, POINTER_SIZE_IN_BITS, addressValue);
            for (int k = 0; k < 40; ++k) {
                Value arrayValue = this.transformInputIntoValue(currentArrayType, k);
                this.writeToHeapObjectByAddress(addressValue, sizeOfCurrentTypeInBits * k, sizeOfCurrentTypeInBits, arrayValue);
                this.addStackVariableToMemoryModel(indexVariableName + k, MACHINE_MODEL.getSizeof(indexVarType).intValue() * 8);
                this.writeToStackVariableInMemoryModel(indexVariableName + k, 0, MACHINE_MODEL.getSizeof(indexVarType).intValue() * 8, new NumericValue(k));
            }
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 40; ++k) {
                    CPointerExpression arrayPointerExpr = this.arrayPointerAccessPlusVariableIndexOnTheRight(arrayVariableName, indexVariableName + k, indexVarType, currentArrayType);
                    List<ValueAndSMGState> resultList = arrayPointerExpr.accept(this.visitor);
                    Truth.assertThat(resultList).hasSize(1);
                    Value resultValue = resultList.get(0).getValue();
                    this.checkValue(currentArrayType, k, resultValue);
                }
            }
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void heapArrayPointerDistance() throws CPATransferException, InvalidConfigurationException {
        String arrayVariableName = "arrayVariable";
        for (CType currentArrayType : ARRAY_TEST_TYPES) {
            int sizeOfCurrentTypeInBits = MACHINE_MODEL.getSizeof(currentArrayType).intValue() * 8;
            ConstantSymbolicExpression addressValue = new ConstantSymbolicExpression(new Value.UnknownValue(), null);
            this.addHeapVariableToMemoryModel(0, sizeOfCurrentTypeInBits * 40, addressValue);
            this.addStackVariableToMemoryModel(arrayVariableName, POINTER_SIZE_IN_BITS);
            this.writeToStackVariableInMemoryModel(arrayVariableName, 0, POINTER_SIZE_IN_BITS, addressValue);
            for (int k = 0; k < 40; ++k) {
                Value newPointer = this.addPointerToExistingHeapObject(k * sizeOfCurrentTypeInBits, addressValue);
                this.addStackVariableToMemoryModel(arrayVariableName + k, POINTER_SIZE_IN_BITS);
                this.writeToStackVariableInMemoryModel(arrayVariableName + k, 0, POINTER_SIZE_IN_BITS, newPointer);
            }
            for (int j = 0; j < 40; ++j) {
                for (int k = 0; k < 40; ++k) {
                    CBinaryExpression arrayDistanceExpr = this.arrayPointerMinusArrayPointer(arrayVariableName + j, arrayVariableName + k, currentArrayType);
                    List<ValueAndSMGState> resultList = arrayDistanceExpr.accept(this.visitor);
                    Truth.assertThat(resultList).hasSize(1);
                    Value resultValue = resultList.get(0).getValue();
                    Truth.assertThat((Boolean)resultValue.isNumericValue()).isTrue();
                    Truth.assertThat((Long)resultValue.asNumericValue().longValue()).isEqualTo((Object)(j - k));
                }
            }
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void castCharTest() throws CPATransferException {
        char[] testChars = new char[]{'\u0000', '\u0001', 'a', 'A', '\u007f', '\u00ff'};
        for (CType typeToTest : BIT_FIELD_TYPES) {
            for (char testChar : testChars) {
                CCastExpression castExpression = new CCastExpression(FileLocation.DUMMY, typeToTest, new CCharLiteralExpression(FileLocation.DUMMY, CNumericTypes.CHAR, testChar));
                List<ValueAndSMGState> result = castExpression.accept(this.visitor);
                Value value = result.get(0).getValue();
                Truth.assertThat((Object)value).isInstanceOf(NumericValue.class);
                Truth.assertThat((Comparable)value.asNumericValue().bigInteger()).isEqualTo((Object)this.convertToType(BigInteger.valueOf(testChar), typeToTest));
            }
        }
    }

    @Test
    public void castSignedShortTest() throws CPATransferException {
        short[] testValues = new short[]{Short.MIN_VALUE, -1, 0, 1, Short.MAX_VALUE};
        for (CType typeToTest : BIT_FIELD_TYPES) {
            for (short testValue : testValues) {
                CCastExpression castExpression = new CCastExpression(FileLocation.DUMMY, typeToTest, new CIntegerLiteralExpression(FileLocation.DUMMY, SHORT_TYPE, BigInteger.valueOf(testValue)));
                List<ValueAndSMGState> result = castExpression.accept(this.visitor);
                Value value = result.get(0).getValue();
                Truth.assertThat((Object)value).isInstanceOf(NumericValue.class);
                Truth.assertThat((Comparable)value.asNumericValue().bigInteger()).isEqualTo((Object)this.convertToType(BigInteger.valueOf(testValue), typeToTest));
            }
        }
    }

    @Test
    public void castUnsignedShortTest() throws CPATransferException {
        int[] testValues = new int[]{0, 1, Short.MAX_VALUE, 65534, 65535};
        for (CType typeToTest : BIT_FIELD_TYPES) {
            for (int testValue : testValues) {
                CCastExpression castExpression = new CCastExpression(FileLocation.DUMMY, typeToTest, new CIntegerLiteralExpression(FileLocation.DUMMY, UNSIGNED_SHORT_TYPE, BigInteger.valueOf(testValue)));
                List<ValueAndSMGState> result = castExpression.accept(this.visitor);
                Value value = result.get(0).getValue();
                Truth.assertThat((Object)value).isInstanceOf(NumericValue.class);
                Truth.assertThat((Comparable)value.asNumericValue().bigInteger()).isEqualTo((Object)this.convertToType(BigInteger.valueOf(testValue), typeToTest));
            }
        }
    }

    @Test
    public void castSignedIntTest() throws CPATransferException {
        int[] testValues = new int[]{Integer.MIN_VALUE, -1, 0, 1, Integer.MAX_VALUE};
        for (CType typeToTest : BIT_FIELD_TYPES) {
            for (int testValue : testValues) {
                CCastExpression castExpression = new CCastExpression(FileLocation.DUMMY, typeToTest, new CIntegerLiteralExpression(FileLocation.DUMMY, INT_TYPE, BigInteger.valueOf(testValue)));
                List<ValueAndSMGState> result = castExpression.accept(this.visitor);
                Value value = result.get(0).getValue();
                Truth.assertThat((Object)value).isInstanceOf(NumericValue.class);
                Truth.assertThat((Comparable)value.asNumericValue().bigInteger()).isEqualTo((Object)this.convertToType(BigInteger.valueOf(testValue), typeToTest));
            }
        }
    }

    @Test
    public void castUnsignedIntTest() throws CPATransferException {
        BigInteger[] testValues = new BigInteger[]{BigInteger.valueOf(0L), BigInteger.valueOf(1L), BigInteger.valueOf(Integer.MAX_VALUE), BigInteger.valueOf(Integer.MAX_VALUE).multiply(BigInteger.TWO), BigInteger.valueOf(Integer.MAX_VALUE).multiply(BigInteger.TWO).add(BigInteger.ONE)};
        for (CType typeToTest : BIT_FIELD_TYPES) {
            for (BigInteger testValue : testValues) {
                CCastExpression castExpression = new CCastExpression(FileLocation.DUMMY, typeToTest, new CIntegerLiteralExpression(FileLocation.DUMMY, UNSIGNED_INT_TYPE, testValue));
                List<ValueAndSMGState> result = castExpression.accept(this.visitor);
                Value value = result.get(0).getValue();
                Truth.assertThat((Object)value).isInstanceOf(NumericValue.class);
                Truth.assertThat((Comparable)value.asNumericValue().bigInteger()).isEqualTo((Object)this.convertToType(testValue, typeToTest));
            }
        }
    }

    @Test
    public void castSignedLongTest() throws CPATransferException {
        long[] testValues = new long[]{Long.MIN_VALUE, -1L, 0L, 1L, Long.MAX_VALUE};
        for (CType typeToTest : BIT_FIELD_TYPES) {
            for (long testValue : testValues) {
                CCastExpression castExpression = new CCastExpression(FileLocation.DUMMY, typeToTest, new CIntegerLiteralExpression(FileLocation.DUMMY, LONG_TYPE, BigInteger.valueOf(testValue)));
                List<ValueAndSMGState> result = castExpression.accept(this.visitor);
                Value value = result.get(0).getValue();
                Truth.assertThat((Object)value).isInstanceOf(NumericValue.class);
                Truth.assertThat((Comparable)value.asNumericValue().bigInteger()).isEqualTo((Object)this.convertToType(BigInteger.valueOf(testValue), typeToTest));
            }
        }
    }

    @Test
    public void castUnsignedLongTest() throws CPATransferException {
        BigInteger[] testValues = new BigInteger[]{BigInteger.valueOf(0L), BigInteger.valueOf(1L), BigInteger.valueOf(Long.MAX_VALUE), BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.TWO), BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.TWO).add(BigInteger.ONE)};
        for (CType typeToTest : BIT_FIELD_TYPES) {
            for (BigInteger testValue : testValues) {
                CCastExpression castExpression = new CCastExpression(FileLocation.DUMMY, typeToTest, new CIntegerLiteralExpression(FileLocation.DUMMY, UNSIGNED_LONG_TYPE, testValue));
                List<ValueAndSMGState> result = castExpression.accept(this.visitor);
                Value value = result.get(0).getValue();
                Truth.assertThat((Object)value).isInstanceOf(NumericValue.class);
                Truth.assertThat((Comparable)value.asNumericValue().bigInteger()).isEqualTo((Object)this.convertToType(testValue, typeToTest));
            }
        }
    }

    @Test
    public void testAddressOperatorOnSimpleStackVariable() throws CPATransferException {
        String variableName = "varName";
        for (CType typeToTest : STRUCT_UNION_TEST_TYPES) {
            this.addStackVariableToMemoryModel(variableName + typeToTest, MACHINE_MODEL.getSizeof(typeToTest).intValue() * 8);
            NumericValue intValue = new NumericValue(99);
            this.writeToStackVariableInMemoryModel(variableName + typeToTest, 0, MACHINE_MODEL.getSizeof(typeToTest).intValue() * 8, intValue);
            CVariableDeclaration decl = new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, typeToTest, variableName + "NotQual", variableName + "NotQual", variableName + typeToTest, CDefaults.forType(typeToTest, FileLocation.DUMMY));
            CUnaryExpression amperVar = this.wrapInAmper(new CIdExpression(FileLocation.DUMMY, decl));
            List<ValueAndSMGState> resultList = amperVar.accept(this.visitor);
            Truth.assertThat(resultList).hasSize(1);
            Value resultValue = resultList.get(0).getValue();
            Truth.assertThat((Boolean)((AddressExpression)resultValue).getOffset().isNumericValue()).isTrue();
            Truth.assertThat((Boolean)(((AddressExpression)resultValue).getOffset().asNumericValue().longValue() == 0L ? 1 : 0)).isTrue();
            resultValue = ((AddressExpression)resultValue).getMemoryAddress();
            this.currentState = resultList.get(0).getState();
            SMGObject expectedTarget = this.currentState.getMemoryModel().getObjectForVisibleVariable(variableName + typeToTest).orElseThrow();
            BigInteger expectedOffset = BigInteger.ZERO;
            Truth.assertThat((Object)resultValue).isInstanceOf(Value.class);
            Truth.assertThat((Boolean)this.currentState.dereferencePointer(resultValue).get(0).hasSMGObjectAndOffset()).isTrue();
            Truth.assertThat((Comparable)this.currentState.dereferencePointer(resultValue).get(0).getSMGObject()).isEqualTo((Object)expectedTarget);
            Truth.assertThat((Comparable)this.currentState.dereferencePointer(resultValue).get(0).getOffsetForObject()).isEqualTo((Object)expectedOffset);
            Truth.assertThat((Comparable)this.currentState.getPointsToTarget(resultValue).orElseThrow().getSMGObject()).isNotEqualTo((Object)SMGObject.nullInstance());
            Truth.assertThat((Comparable)this.currentState.getPointsToTarget(resultValue).orElseThrow().getSMGObject()).isEqualTo((Object)expectedTarget);
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().getAddressValueForPointsToTarget(expectedTarget, expectedOffset).isPresent()).isTrue();
            SMGValue smgValueForPointer = this.currentState.getMemoryModel().getAddressValueForPointsToTarget(expectedTarget, expectedOffset).orElseThrow();
            Value valueForSMGValue = this.currentState.getMemoryModel().getValueFromSMGValue(smgValueForPointer).orElseThrow();
            Truth.assertThat((Object)valueForSMGValue).isEqualTo((Object)resultValue);
        }
    }

    @Test
    public void testAddressOperatorOnPointerToHeapArray() throws CPATransferException, InvalidConfigurationException {
        for (CType currentTestType : ARRAY_TEST_TYPES) {
            String arrayVariableName = "arrayName" + currentTestType;
            this.setupHeapArray(arrayVariableName, currentTestType);
            CUnaryExpression amperOfArrayPointerExpr = this.wrapInAmper(this.arrayPointerAccess(arrayVariableName, currentTestType, 0).getOperand());
            List<ValueAndSMGState> resultList = amperOfArrayPointerExpr.accept(this.visitor);
            Truth.assertThat(resultList).hasSize(1);
            Value resultValue = resultList.get(0).getValue();
            Truth.assertThat((Boolean)((AddressExpression)resultValue).getOffset().isNumericValue()).isTrue();
            Truth.assertThat((Boolean)(((AddressExpression)resultValue).getOffset().asNumericValue().longValue() == 0L ? 1 : 0)).isTrue();
            resultValue = ((AddressExpression)resultValue).getMemoryAddress();
            this.currentState = resultList.get(0).getState();
            SMGObject expectedTarget = this.currentState.getMemoryModel().getObjectForVisibleVariable(arrayVariableName).orElseThrow();
            BigInteger expectedOffset = BigInteger.ZERO;
            Truth.assertThat((Object)resultValue).isInstanceOf(Value.class);
            Truth.assertThat((Boolean)this.currentState.dereferencePointer(resultValue).get(0).hasSMGObjectAndOffset()).isTrue();
            Truth.assertThat((Comparable)this.currentState.dereferencePointer(resultValue).get(0).getSMGObject()).isEqualTo((Object)expectedTarget);
            Truth.assertThat((Comparable)this.currentState.dereferencePointer(resultValue).get(0).getOffsetForObject()).isEqualTo((Object)expectedOffset);
            Truth.assertThat((Comparable)this.currentState.getPointsToTarget(resultValue).orElseThrow().getSMGObject()).isNotEqualTo((Object)SMGObject.nullInstance());
            Truth.assertThat((Comparable)this.currentState.getPointsToTarget(resultValue).orElseThrow().getSMGObject()).isEqualTo((Object)expectedTarget);
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().getAddressValueForPointsToTarget(expectedTarget, expectedOffset).isPresent()).isTrue();
            SMGValue smgValueForPointer = this.currentState.getMemoryModel().getAddressValueForPointsToTarget(expectedTarget, expectedOffset).orElseThrow();
            Value valueForSMGValue = this.currentState.getMemoryModel().getValueFromSMGValue(smgValueForPointer).orElseThrow();
            Truth.assertThat((Object)valueForSMGValue).isEqualTo((Object)resultValue);
        }
    }

    @Test
    public void testAddressOperatorOnHeapArray() throws CPATransferException, InvalidConfigurationException {
        String indiceVarName = "indice";
        this.setupIndexVariables(indiceVarName);
        for (CType currentTestType : ARRAY_TEST_TYPES) {
            BigInteger sizeOfCurrentTypeInBits = MACHINE_MODEL.getSizeof(currentTestType).multiply(BigInteger.valueOf(8L));
            String arrayVariableName = "arrayName" + currentTestType;
            Value heapAddress = this.setupHeapArray(arrayVariableName, currentTestType);
            for (int currentIndice = 0; currentIndice < 40; ++currentIndice) {
                CUnaryExpression arrayAmperOfPointerExpr = this.wrapInAmper(this.arrayPointerAccess(arrayVariableName, currentTestType, currentIndice));
                List<ValueAndSMGState> resultList = arrayAmperOfPointerExpr.accept(this.visitor);
                Truth.assertThat(resultList).hasSize(1);
                Value resultValue = resultList.get(0).getValue();
                Truth.assertThat((Boolean)((AddressExpression)resultValue).getOffset().isNumericValue()).isTrue();
                Truth.assertThat((Boolean)(((AddressExpression)resultValue).getOffset().asNumericValue().longValue() == 0L ? 1 : 0)).isTrue();
                resultValue = ((AddressExpression)resultValue).getMemoryAddress();
                this.currentState = resultList.get(0).getState();
                SMGObject expectedTarget = this.currentState.dereferencePointer(heapAddress).get(0).getSMGObject();
                BigInteger expectedOffset = BigInteger.valueOf(currentIndice).multiply(sizeOfCurrentTypeInBits);
                Truth.assertThat((Object)resultValue).isInstanceOf(Value.class);
                Truth.assertThat((Boolean)this.currentState.dereferencePointer(resultValue).get(0).hasSMGObjectAndOffset()).isTrue();
                Truth.assertThat((Comparable)this.currentState.dereferencePointer(resultValue).get(0).getSMGObject()).isEqualTo((Object)expectedTarget);
                Truth.assertThat((Comparable)this.currentState.dereferencePointer(resultValue).get(0).getOffsetForObject()).isEqualTo((Object)expectedOffset);
                Truth.assertThat((Comparable)this.currentState.getPointsToTarget(resultValue).orElseThrow().getSMGObject()).isNotEqualTo((Object)SMGObject.nullInstance());
                Truth.assertThat((Comparable)this.currentState.getPointsToTarget(resultValue).orElseThrow().getSMGObject()).isEqualTo((Object)expectedTarget);
                Truth.assertThat((Boolean)this.currentState.getMemoryModel().getAddressValueForPointsToTarget(expectedTarget, expectedOffset).isPresent()).isTrue();
                SMGValue smgValueForPointer = this.currentState.getMemoryModel().getAddressValueForPointsToTarget(expectedTarget, expectedOffset).orElseThrow();
                Value valueForSMGValue = this.currentState.getMemoryModel().getValueFromSMGValue(smgValueForPointer).orElseThrow();
                Truth.assertThat((Object)valueForSMGValue).isEqualTo((Object)resultValue);
            }
        }
    }

    @Test
    public void testAddressOperatorOnPointerToStackArray() throws CPATransferException, InvalidConfigurationException {
        for (CType currentTestType : ARRAY_TEST_TYPES) {
            BigInteger sizeOfCurrentTypeInBits = MACHINE_MODEL.getSizeof(currentTestType).multiply(BigInteger.valueOf(8L));
            String arrayVariableName = "arrayName" + currentTestType;
            Value heapAddress = this.setupHeapArray(arrayVariableName, currentTestType);
            for (int currentIndice = 0; currentIndice < 40; ++currentIndice) {
                CUnaryExpression arrayAmperOfPointerExpr = this.wrapInAmper(this.arraySubscriptHeapAccess(arrayVariableName, currentTestType, currentIndice));
                List<ValueAndSMGState> resultList = arrayAmperOfPointerExpr.accept(this.visitor);
                Truth.assertThat(resultList).hasSize(1);
                Value resultValue = resultList.get(0).getValue();
                Truth.assertThat((Boolean)((AddressExpression)resultValue).getOffset().isNumericValue()).isTrue();
                Truth.assertThat((Boolean)(((AddressExpression)resultValue).getOffset().asNumericValue().longValue() == 0L ? 1 : 0)).isTrue();
                resultValue = ((AddressExpression)resultValue).getMemoryAddress();
                this.currentState = resultList.get(0).getState();
                SMGObject expectedTarget = this.currentState.dereferencePointer(heapAddress).get(0).getSMGObject();
                BigInteger expectedOffset = BigInteger.valueOf(currentIndice).multiply(sizeOfCurrentTypeInBits);
                Truth.assertThat((Object)resultValue).isInstanceOf(Value.class);
                Truth.assertThat((Boolean)this.currentState.dereferencePointer(resultValue).get(0).hasSMGObjectAndOffset()).isTrue();
                Truth.assertThat((Comparable)this.currentState.dereferencePointer(resultValue).get(0).getSMGObject()).isEqualTo((Object)expectedTarget);
                Truth.assertThat((Comparable)this.currentState.dereferencePointer(resultValue).get(0).getOffsetForObject()).isEqualTo((Object)expectedOffset);
                Truth.assertThat((Comparable)this.currentState.getPointsToTarget(resultValue).orElseThrow().getSMGObject()).isNotEqualTo((Object)SMGObject.nullInstance());
                Truth.assertThat((Comparable)this.currentState.getPointsToTarget(resultValue).orElseThrow().getSMGObject()).isEqualTo((Object)expectedTarget);
                Truth.assertThat((Boolean)this.currentState.getMemoryModel().getAddressValueForPointsToTarget(expectedTarget, expectedOffset).isPresent()).isTrue();
                SMGValue smgValueForPointer = this.currentState.getMemoryModel().getAddressValueForPointsToTarget(expectedTarget, expectedOffset).orElseThrow();
                Value valueForSMGValue = this.currentState.getMemoryModel().getValueFromSMGValue(smgValueForPointer).orElseThrow();
                Truth.assertThat((Object)valueForSMGValue).isEqualTo((Object)resultValue);
            }
        }
    }

    @Test
    public void testAddressOperatorOnStackStruct() throws CPATransferException {
        for (int j = 0; j < STRUCT_UNION_TEST_TYPES.size() - 1; ++j) {
            List<CType> listOfTypes = STRUCT_UNION_TEST_TYPES.subList(0, j + 1);
            this.createStackVarOnStackAndFill(COMPOSITE_VARIABLE_NAME + j, listOfTypes);
            CUnaryExpression amperFieldRef = this.wrapInAmper(this.exprForStructOrUnionOnStackVar(COMPOSITE_DECLARATION_NAME + j, COMPOSITE_VARIABLE_NAME + j, listOfTypes, false, CComplexType.ComplexTypeKind.STRUCT));
            List<ValueAndSMGState> resultList = amperFieldRef.accept(this.visitor);
            Truth.assertThat(resultList).hasSize(1);
            Value resultValue = resultList.get(0).getValue();
            Truth.assertThat((Boolean)((AddressExpression)resultValue).getOffset().isNumericValue()).isTrue();
            Truth.assertThat((Boolean)(((AddressExpression)resultValue).getOffset().asNumericValue().longValue() == 0L ? 1 : 0)).isTrue();
            resultValue = ((AddressExpression)resultValue).getMemoryAddress();
            this.currentState = resultList.get(0).getState();
            SMGObject expectedTarget = this.currentState.getMemoryModel().getObjectForVisibleVariable(COMPOSITE_VARIABLE_NAME + j).orElseThrow();
            BigInteger expectedOffset = BigInteger.ZERO;
            Truth.assertThat((Object)resultValue).isInstanceOf(Value.class);
            Truth.assertThat((Boolean)this.currentState.dereferencePointer(resultValue).get(0).hasSMGObjectAndOffset()).isTrue();
            Truth.assertThat((Comparable)this.currentState.dereferencePointer(resultValue).get(0).getSMGObject()).isEqualTo((Object)expectedTarget);
            Truth.assertThat((Comparable)this.currentState.dereferencePointer(resultValue).get(0).getOffsetForObject()).isEqualTo((Object)expectedOffset);
            Truth.assertThat((Comparable)this.currentState.getPointsToTarget(resultValue).orElseThrow().getSMGObject()).isNotEqualTo((Object)SMGObject.nullInstance());
            Truth.assertThat((Comparable)this.currentState.getPointsToTarget(resultValue).orElseThrow().getSMGObject()).isEqualTo((Object)expectedTarget);
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().getAddressValueForPointsToTarget(expectedTarget, expectedOffset).isPresent()).isTrue();
            SMGValue smgValueForPointer = this.currentState.getMemoryModel().getAddressValueForPointsToTarget(expectedTarget, expectedOffset).orElseThrow();
            Value valueForSMGValue = this.currentState.getMemoryModel().getValueFromSMGValue(smgValueForPointer).orElseThrow();
            Truth.assertThat((Object)valueForSMGValue).isEqualTo((Object)resultValue);
        }
    }

    @Test
    public void testAddressOperatorOnHeapStruct() throws Exception {
        for (int j = 0; j < STRUCT_UNION_TEST_TYPES.size() - 1; ++j) {
            List<CType> listOfTypes = STRUCT_UNION_TEST_TYPES.subList(0, j + 1);
            this.setupHeapStructAndFill(COMPOSITE_VARIABLE_NAME + j, listOfTypes);
            CUnaryExpression amperStructRef = this.wrapInAmper(this.createPointerRefForStructPointerNoDeref(COMPOSITE_DECLARATION_NAME + j, COMPOSITE_VARIABLE_NAME + j, listOfTypes).getOperand());
            List<ValueAndSMGState> resultList = amperStructRef.accept(this.visitor);
            Truth.assertThat(resultList).hasSize(1);
            Value resultValue = resultList.get(0).getValue();
            Truth.assertThat((Boolean)((AddressExpression)resultValue).getOffset().isNumericValue()).isTrue();
            Truth.assertThat((Boolean)(((AddressExpression)resultValue).getOffset().asNumericValue().longValue() == 0L ? 1 : 0)).isTrue();
            resultValue = ((AddressExpression)resultValue).getMemoryAddress();
            this.currentState = resultList.get(0).getState();
            SMGObject expectedTarget = this.currentState.getMemoryModel().getObjectForVisibleVariable(COMPOSITE_VARIABLE_NAME + j).orElseThrow();
            BigInteger expectedOffset = BigInteger.ZERO;
            Truth.assertThat((Object)resultValue).isInstanceOf(Value.class);
            SMGStateAndOptionalSMGObjectAndOffset resultMaybeTarget = this.currentState.dereferencePointer(resultValue).get(0);
            Truth.assertThat((Boolean)resultMaybeTarget.hasSMGObjectAndOffset()).isTrue();
            Truth.assertThat((Comparable)resultMaybeTarget.getSMGObject()).isEqualTo((Object)expectedTarget);
            Truth.assertThat((Comparable)resultMaybeTarget.getOffsetForObject()).isEqualTo((Object)expectedOffset);
            Truth.assertThat((Comparable)this.currentState.getPointsToTarget(resultValue).orElseThrow().getSMGObject()).isNotEqualTo((Object)SMGObject.nullInstance());
            Truth.assertThat((Comparable)this.currentState.getPointsToTarget(resultValue).orElseThrow().getSMGObject()).isEqualTo((Object)expectedTarget);
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().getAddressValueForPointsToTarget(expectedTarget, expectedOffset).isPresent()).isTrue();
            SMGValue smgValueForPointer = this.currentState.getMemoryModel().getAddressValueForPointsToTarget(expectedTarget, expectedOffset).orElseThrow();
            Value valueForSMGValue = this.currentState.getMemoryModel().getValueFromSMGValue(smgValueForPointer).orElseThrow();
            Truth.assertThat((Object)valueForSMGValue).isEqualTo((Object)resultValue);
        }
    }

    @Test
    public void testAddressOperatorOnStructMembersOnHeap() throws InvalidConfigurationException, CPATransferException {
        for (int j = 0; j < STRUCT_UNION_TEST_TYPES.size() - 1; ++j) {
            List<CType> listOfTypes = STRUCT_UNION_TEST_TYPES.subList(0, j + 1);
            Value addressForHeap = this.setupHeapStructAndFill(COMPOSITE_VARIABLE_NAME + j, listOfTypes);
            for (int indice = 0; indice < listOfTypes.size(); ++indice) {
                CUnaryExpression amperFieldRef = this.wrapInAmper(this.createFieldRefForStackVar(COMPOSITE_DECLARATION_NAME + j, COMPOSITE_VARIABLE_NAME + j, indice, listOfTypes, true, CComplexType.ComplexTypeKind.STRUCT));
                List<ValueAndSMGState> resultList = amperFieldRef.accept(this.visitor);
                Truth.assertThat(resultList).hasSize(1);
                Value resultValue = resultList.get(0).getValue();
                Truth.assertThat((Boolean)((AddressExpression)resultValue).getOffset().isNumericValue()).isTrue();
                Truth.assertThat((Boolean)(((AddressExpression)resultValue).getOffset().asNumericValue().longValue() == 0L ? 1 : 0)).isTrue();
                resultValue = ((AddressExpression)resultValue).getMemoryAddress();
                this.currentState = resultList.get(0).getState();
                SMGObject expectedTarget = this.currentState.dereferencePointer(addressForHeap).get(0).getSMGObject();
                BigInteger expectedOffset = BigInteger.valueOf(this.getOffsetInBitsWithPadding(listOfTypes, indice));
                Truth.assertThat((Object)resultValue).isInstanceOf(Value.class);
                Truth.assertThat((Boolean)this.currentState.dereferencePointer(resultValue).get(0).hasSMGObjectAndOffset()).isTrue();
                Truth.assertThat((Comparable)this.currentState.dereferencePointer(resultValue).get(0).getSMGObject()).isEqualTo((Object)expectedTarget);
                Truth.assertThat((Comparable)this.currentState.dereferencePointer(resultValue).get(0).getOffsetForObject()).isEqualTo((Object)expectedOffset);
                Truth.assertThat((Comparable)this.currentState.getPointsToTarget(resultValue).orElseThrow().getSMGObject()).isNotEqualTo((Object)SMGObject.nullInstance());
                Truth.assertThat((Comparable)this.currentState.getPointsToTarget(resultValue).orElseThrow().getSMGObject()).isEqualTo((Object)expectedTarget);
                Truth.assertThat((Boolean)this.currentState.getMemoryModel().getAddressValueForPointsToTarget(expectedTarget, expectedOffset).isPresent()).isTrue();
                SMGValue smgValueForPointer = this.currentState.getMemoryModel().getAddressValueForPointsToTarget(expectedTarget, expectedOffset).orElseThrow();
                Value valueForSMGValue = this.currentState.getMemoryModel().getValueFromSMGValue(smgValueForPointer).orElseThrow();
                Truth.assertThat((Object)valueForSMGValue).isEqualTo((Object)resultValue);
            }
        }
    }

    @Test
    public void testAddressOperatorOnStructMembersOnStack() throws CPATransferException {
        for (int j = 0; j < STRUCT_UNION_TEST_TYPES.size() - 1; ++j) {
            List<CType> listOfTypes = STRUCT_UNION_TEST_TYPES.subList(0, j + 1);
            this.createStackVarOnStackAndFill(COMPOSITE_VARIABLE_NAME + j, listOfTypes);
            for (int indice = 0; indice < listOfTypes.size(); ++indice) {
                CUnaryExpression amperFieldRef = this.wrapInAmper(this.createFieldRefForStackVar(COMPOSITE_DECLARATION_NAME + j, COMPOSITE_VARIABLE_NAME + j, indice, listOfTypes, false, CComplexType.ComplexTypeKind.STRUCT));
                List<ValueAndSMGState> resultList = amperFieldRef.accept(this.visitor);
                Truth.assertThat(resultList).hasSize(1);
                Value resultValue = resultList.get(0).getValue();
                Truth.assertThat((Boolean)((AddressExpression)resultValue).getOffset().isNumericValue()).isTrue();
                Truth.assertThat((Boolean)(((AddressExpression)resultValue).getOffset().asNumericValue().longValue() == 0L ? 1 : 0)).isTrue();
                resultValue = ((AddressExpression)resultValue).getMemoryAddress();
                this.currentState = resultList.get(0).getState();
                SMGObject expectedTarget = this.currentState.getMemoryModel().getObjectForVisibleVariable(COMPOSITE_VARIABLE_NAME + j).orElseThrow();
                BigInteger expectedOffset = BigInteger.valueOf(this.getOffsetInBitsWithPadding(listOfTypes, indice));
                Truth.assertThat((Object)resultValue).isInstanceOf(Value.class);
                Truth.assertThat((Boolean)this.currentState.dereferencePointer(resultValue).get(0).hasSMGObjectAndOffset()).isTrue();
                Truth.assertThat((Comparable)this.currentState.dereferencePointer(resultValue).get(0).getSMGObject()).isEqualTo((Object)expectedTarget);
                Truth.assertThat((Comparable)this.currentState.dereferencePointer(resultValue).get(0).getOffsetForObject()).isEqualTo((Object)expectedOffset);
                Truth.assertThat((Comparable)this.currentState.getPointsToTarget(resultValue).orElseThrow().getSMGObject()).isNotEqualTo((Object)SMGObject.nullInstance());
                Truth.assertThat((Comparable)this.currentState.getPointsToTarget(resultValue).orElseThrow().getSMGObject()).isEqualTo((Object)expectedTarget);
                Truth.assertThat((Boolean)this.currentState.getMemoryModel().getAddressValueForPointsToTarget(expectedTarget, expectedOffset).isPresent()).isTrue();
                SMGValue smgValueForPointer = this.currentState.getMemoryModel().getAddressValueForPointsToTarget(expectedTarget, expectedOffset).orElseThrow();
                Value valueForSMGValue = this.currentState.getMemoryModel().getValueFromSMGValue(smgValueForPointer).orElseThrow();
                Truth.assertThat((Object)valueForSMGValue).isEqualTo((Object)resultValue);
            }
        }
    }

    @Test
    public void testSizeofSimpleTypes() throws CPATransferException, InvalidConfigurationException {
        String variableName = "varName";
        for (CType typeToTest : STRUCT_UNION_TEST_TYPES) {
            this.addStackVariableToMemoryModel(variableName, MACHINE_MODEL.getSizeof(typeToTest).intValue() * 8);
            NumericValue intValue = new NumericValue(99);
            this.writeToStackVariableInMemoryModel(variableName, 0, MACHINE_MODEL.getSizeof(typeToTest).intValue() * 8, intValue);
            CVariableDeclaration decl = new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, typeToTest, variableName + "NotQual", variableName + "NotQual", variableName, CDefaults.forType(typeToTest, FileLocation.DUMMY));
            CUnaryExpression sizeOfVar = this.wrapInSizeof(new CIdExpression(FileLocation.DUMMY, decl));
            List<ValueAndSMGState> resultList = sizeOfVar.accept(this.visitor);
            Truth.assertThat(resultList).hasSize(1);
            Value resultValue = resultList.get(0).getValue();
            Truth.assertThat((Object)resultValue).isInstanceOf(NumericValue.class);
            Truth.assertThat((Comparable)resultValue.asNumericValue().bigInteger()).isEqualTo((Object)MACHINE_MODEL.getSizeof(typeToTest));
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void testSizeofStructs() throws CPATransferException, InvalidConfigurationException {
        for (int j = 0; j < STRUCT_UNION_TEST_TYPES.size() - 1; ++j) {
            List<CType> listOfTypes = STRUCT_UNION_TEST_TYPES.subList(0, j + 1);
            this.createStackVarOnStackAndFill(COMPOSITE_VARIABLE_NAME, listOfTypes);
            for (int i = 0; i < listOfTypes.size(); ++i) {
                CUnaryExpression sizeOfFieldRef = this.wrapInSizeof(this.createFieldRefForStackVar(COMPOSITE_DECLARATION_NAME, COMPOSITE_VARIABLE_NAME, i, listOfTypes, false, CComplexType.ComplexTypeKind.STRUCT));
                List<ValueAndSMGState> resultList = sizeOfFieldRef.accept(this.visitor);
                Truth.assertThat(resultList).hasSize(1);
                Value resultValue = resultList.get(0).getValue();
                Truth.assertThat((Object)resultValue).isInstanceOf(NumericValue.class);
                Truth.assertThat((Comparable)resultValue.asNumericValue().bigInteger()).isEqualTo((Object)MACHINE_MODEL.getSizeof(listOfTypes.get(i)));
            }
            CUnaryExpression sizeOfVariableRef = this.wrapInSizeof(this.exprForStructOrUnionOnStackVar(COMPOSITE_DECLARATION_NAME, COMPOSITE_VARIABLE_NAME, listOfTypes, false, CComplexType.ComplexTypeKind.STRUCT));
            List<ValueAndSMGState> resultList = sizeOfVariableRef.accept(this.visitor);
            Truth.assertThat(resultList).hasSize(1);
            Value resultValue = resultList.get(0).getValue();
            Truth.assertThat((Object)resultValue).isInstanceOf(NumericValue.class);
            Truth.assertThat((Comparable)resultValue.asNumericValue().bigInteger().multiply(BigInteger.valueOf(8L))).isEqualTo((Object)BigInteger.valueOf(this.getSizeInBitsForListOfCTypeWithPadding(listOfTypes)));
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void testSizeofUnions() throws CPATransferException, InvalidConfigurationException {
        for (int j = 0; j < STRUCT_UNION_TEST_TYPES.size() - 1; ++j) {
            List<CType> listOfTypes = STRUCT_UNION_TEST_TYPES.subList(0, j + 1);
            this.addStackVariableToMemoryModel(COMPOSITE_VARIABLE_NAME, this.getLargestSizeInBitsForListOfCType(listOfTypes));
            for (int i = 0; i < j; ++i) {
                NumericValue intValue = new NumericValue(j);
                this.writeToStackVariableInMemoryModel(COMPOSITE_VARIABLE_NAME, 0, MACHINE_MODEL.getSizeof(listOfTypes.get(j)).intValue() * 8, intValue);
                for (int k = 0; k < listOfTypes.size(); ++k) {
                    CUnaryExpression sizeofUnionFieldRef = this.wrapInSizeof(this.createFieldRefForStackVar(COMPOSITE_DECLARATION_NAME, COMPOSITE_VARIABLE_NAME, k, listOfTypes, false, CComplexType.ComplexTypeKind.UNION));
                    List<ValueAndSMGState> resultList = sizeofUnionFieldRef.accept(this.visitor);
                    Truth.assertThat(resultList).hasSize(1);
                    Value resultValue = resultList.get(0).getValue();
                    Truth.assertThat((Object)resultValue).isInstanceOf(NumericValue.class);
                    Truth.assertThat((Comparable)resultValue.asNumericValue().bigInteger()).isEqualTo((Object)MACHINE_MODEL.getSizeof(listOfTypes.get(k)));
                }
                CUnaryExpression sizeofUnionRef = this.wrapInSizeof(this.exprForStructOrUnionOnStackVar(COMPOSITE_DECLARATION_NAME, COMPOSITE_VARIABLE_NAME, listOfTypes, false, CComplexType.ComplexTypeKind.UNION));
                List<ValueAndSMGState> resultList = sizeofUnionRef.accept(this.visitor);
                Truth.assertThat(resultList).hasSize(1);
                Value resultValue = resultList.get(0).getValue();
                Truth.assertThat((Object)resultValue).isInstanceOf(NumericValue.class);
                Truth.assertThat((Comparable)resultValue.asNumericValue().bigInteger().multiply(BigInteger.valueOf(8L))).isEqualTo((Object)BigInteger.valueOf(this.getLargestSizeInBitsForListOfCType(listOfTypes)));
            }
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void testSizeofHeapArraysWithPointer() throws InvalidConfigurationException, CPATransferException {
        for (CType currentTestType : ARRAY_TEST_TYPES) {
            String arrayVariableName = "arrayName";
            String indiceVarName = "indice";
            this.setupHeapArray(arrayVariableName, currentTestType);
            this.setupIndexVariables(indiceVarName);
            for (int currentIndice = 0; currentIndice < 40; ++currentIndice) {
                CUnaryExpression arrayPointerExpr = this.wrapInSizeof(this.arrayPointerAccess(arrayVariableName, currentTestType, currentIndice));
                List<ValueAndSMGState> resultList = arrayPointerExpr.accept(this.visitor);
                Truth.assertThat(resultList).hasSize(1);
                Value resultValue = resultList.get(0).getValue();
                Truth.assertThat((Object)resultValue).isInstanceOf(NumericValue.class);
                Truth.assertThat((Comparable)resultValue.asNumericValue().bigInteger()).isEqualTo((Object)MACHINE_MODEL.getSizeof(currentTestType));
            }
            CUnaryExpression arrayPointerExpr = this.wrapInSizeof(this.arrayPointerAccess(arrayVariableName, currentTestType, 0).getOperand());
            List<ValueAndSMGState> resultList = arrayPointerExpr.accept(this.visitor);
            Truth.assertThat(resultList).hasSize(1);
            Value resultValue = resultList.get(0).getValue();
            Truth.assertThat((Object)resultValue).isInstanceOf(NumericValue.class);
            Truth.assertThat((Integer)resultValue.asNumericValue().bigInteger().intValue()).isEqualTo((Object)(POINTER_SIZE_IN_BITS / 8));
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void testSizeofHeapArraysWithSubscript() throws InvalidConfigurationException, CPATransferException {
        for (CType currentTestType : ARRAY_TEST_TYPES) {
            String arrayVariableName = "arrayName";
            String indiceVarName = "indice";
            this.setupHeapArray(arrayVariableName, currentTestType);
            this.setupIndexVariables(indiceVarName);
            for (int currentIndice = 0; currentIndice < 40; ++currentIndice) {
                CUnaryExpression arraySubscriptExpr = this.wrapInSizeof(this.arraySubscriptHeapAccessWithVariable(arrayVariableName, indiceVarName + currentIndice, INT_TYPE, currentTestType));
                List<ValueAndSMGState> resultList = arraySubscriptExpr.accept(this.visitor);
                Truth.assertThat(resultList).hasSize(1);
                Value resultValue = resultList.get(0).getValue();
                Truth.assertThat((Object)resultValue).isInstanceOf(NumericValue.class);
                Truth.assertThat((Comparable)resultValue.asNumericValue().bigInteger()).isEqualTo((Object)MACHINE_MODEL.getSizeof(currentTestType));
            }
            CUnaryExpression arraySizeofExpr = this.wrapInSizeof(this.arraySubscriptHeapAccessWithVariable(arrayVariableName, indiceVarName + "0", INT_TYPE, currentTestType).getArrayExpression());
            List<ValueAndSMGState> resultList = arraySizeofExpr.accept(this.visitor);
            Truth.assertThat(resultList).hasSize(1);
            Value resultValue = resultList.get(0).getValue();
            Truth.assertThat((Object)resultValue).isInstanceOf(NumericValue.class);
            Truth.assertThat((Integer)resultValue.asNumericValue().bigInteger().intValue()).isEqualTo((Object)(POINTER_SIZE_IN_BITS / 8));
            this.resetSMGStateAndVisitor();
        }
    }

    @Test
    public void testSizeofStackArraysWithSubscript() throws InvalidConfigurationException, CPATransferException {
        for (CType currentTestType : ARRAY_TEST_TYPES) {
            String arrayVariableName = "arrayName";
            this.setupStackArray(arrayVariableName, currentTestType);
            for (int currentIndice = 0; currentIndice < 40; ++currentIndice) {
                CUnaryExpression arraySubscriptExpr = this.wrapInSizeof(this.arraySubscriptStackAccess(arrayVariableName, currentTestType, currentIndice, 40));
                List<ValueAndSMGState> resultList = arraySubscriptExpr.accept(this.visitor);
                Truth.assertThat(resultList).hasSize(1);
                Value resultValue = resultList.get(0).getValue();
                Truth.assertThat((Object)resultValue).isInstanceOf(NumericValue.class);
                Truth.assertThat((Comparable)resultValue.asNumericValue().bigInteger()).isEqualTo((Object)MACHINE_MODEL.getSizeof(currentTestType));
            }
            this.resetSMGStateAndVisitor();
        }
    }

    private CUnaryExpression wrapInAmper(CExpression exprToWrap) {
        CType typeOfExpr = exprToWrap.getExpressionType();
        CPointerType newType = new CPointerType(false, false, typeOfExpr);
        return new CUnaryExpression(FileLocation.DUMMY, newType, exprToWrap, CUnaryExpression.UnaryOperator.AMPER);
    }

    private CUnaryExpression wrapInSizeof(CExpression exprToWrap) {
        return new CUnaryExpression(FileLocation.DUMMY, INT_TYPE, exprToWrap, CUnaryExpression.UnaryOperator.SIZEOF);
    }

    private BigInteger convertToType(BigInteger value, CType type) {
        if (value.compareTo(BigInteger.ZERO) == 0) {
            return value;
        }
        if (type == CHAR_TYPE) {
            return BigInteger.valueOf(value.byteValue());
        }
        if (type == SHORT_TYPE) {
            return BigInteger.valueOf(value.shortValue());
        }
        if (type == UNSIGNED_SHORT_TYPE) {
            if (value.shortValue() < 0) {
                return BigInteger.valueOf(value.shortValue() & 0xFFFF);
            }
            return BigInteger.valueOf(value.shortValue());
        }
        if (type == INT_TYPE) {
            return BigInteger.valueOf(value.intValue());
        }
        if (type == UNSIGNED_INT_TYPE) {
            return BigInteger.valueOf(Integer.toUnsignedLong(value.intValue()));
        }
        if (type == LONG_TYPE) {
            return BigInteger.valueOf(value.longValue());
        }
        if (type == UNSIGNED_LONG_TYPE) {
            BigInteger longValue = BigInteger.valueOf(value.longValue());
            if (longValue.signum() < 0) {
                return longValue.add(BigInteger.ONE.shiftLeft(64));
            }
            return longValue;
        }
        return BigInteger.ZERO;
    }

    private int getSizeInBitsForListOfCTypeWithPadding(List<CType> listOfTypes) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (int i = 0; i < listOfTypes.size(); ++i) {
            builder.add((Object)new CCompositeType.CCompositeTypeMemberDeclaration(listOfTypes.get(i), "field" + i));
        }
        ImmutableList members = builder.build();
        CCompositeType structType = new CCompositeType(false, false, CComplexType.ComplexTypeKind.STRUCT, (List<CCompositeType.CCompositeTypeMemberDeclaration>)members, "someName", "someName");
        CElaboratedType elaboratedType = new CElaboratedType(false, false, CComplexType.ComplexTypeKind.STRUCT, "someName", "someName", structType);
        return MACHINE_MODEL.getSizeofInBits(elaboratedType).intValue();
    }

    private int getSizeInBitsForListOfCTypeWithoutPadding(List<CType> listOfTypes) {
        int size = 0;
        for (CType type : listOfTypes) {
            size += MACHINE_MODEL.getSizeof(type).intValue() * 8;
        }
        return size;
    }

    private int getLargestSizeInBitsForListOfCType(List<CType> listOfTypes) {
        int size = 0;
        for (CType type : listOfTypes) {
            int tempSize = MACHINE_MODEL.getSizeof(type).intValue() * 8;
            if (tempSize <= size) continue;
            size = tempSize;
        }
        return size;
    }

    private int getOffsetInBitsWithPadding(List<CType> listOfTypes, int offsetBeginning) {
        int offset = 0;
        for (int j = 0; j < offsetBeginning; ++j) {
            int mod = (offset += MACHINE_MODEL.getSizeof(listOfTypes.get(j)).intValue() * 8) % (MACHINE_MODEL.getSizeof(listOfTypes.get(j + 1)).intValue() * 8);
            if (mod == 0) continue;
            offset += mod;
        }
        return offset;
    }

    private int getOffsetInBitsWithoutPadding(List<CType> listOfTypes, int offsetBeginning) {
        int offset = 0;
        for (int j = 0; j < offsetBeginning; ++j) {
            offset += MACHINE_MODEL.getSizeof(listOfTypes.get(j)).intValue() * 8;
        }
        return offset;
    }

    private void createStackVarOnStackAndFill(String variableName, List<CType> testTypesList) throws SMG2Exception {
        this.addStackVariableToMemoryModel(variableName, this.getSizeInBitsForListOfCTypeWithPadding(testTypesList));
        for (int i = 0; i < testTypesList.size(); ++i) {
            NumericValue intValue = new NumericValue(i);
            this.writeToStackVariableInMemoryModel(variableName, this.getOffsetInBitsWithPadding(testTypesList, i), MACHINE_MODEL.getSizeof(testTypesList.get(i)).intValue() * 8, intValue);
        }
    }

    public CPointerExpression createPointerRefForStructPointerNoDeref(String structName, String variableName, List<CType> fieldTypes) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (int i = 0; i < fieldTypes.size(); ++i) {
            builder.add((Object)new CCompositeType.CCompositeTypeMemberDeclaration(fieldTypes.get(i), "field" + i));
        }
        ImmutableList members = builder.build();
        CCompositeType structType = new CCompositeType(false, false, CComplexType.ComplexTypeKind.STRUCT, (List<CCompositeType.CCompositeTypeMemberDeclaration>)members, structName, structName);
        CElaboratedType elaboratedType = new CElaboratedType(false, false, CComplexType.ComplexTypeKind.STRUCT, structName, structName, structType);
        CPointerType structPointerType = new CPointerType(false, false, elaboratedType);
        CVariableDeclaration declararation = new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, structPointerType, variableName + "NotQual", variableName + "NotQual", variableName, CDefaults.forType(structPointerType, FileLocation.DUMMY));
        CIdExpression structVarExpr = new CIdExpression(FileLocation.DUMMY, declararation);
        return new CPointerExpression(FileLocation.DUMMY, elaboratedType, structVarExpr);
    }

    public CFieldReference createStructFieldRefWithPointerNoDeref(String structName, String variableName, int fieldNumberToRead, List<CType> fieldTypes) {
        CPointerExpression structPointerExpr = this.createPointerRefForStructPointerNoDeref(structName, variableName, fieldTypes);
        CElaboratedType elaboratedType = (CElaboratedType)structPointerExpr.getExpressionType();
        CCompositeType structType = (CCompositeType)elaboratedType.getRealType();
        return new CFieldReference(FileLocation.DUMMY, structType.getMembers().get(fieldNumberToRead).getType(), "field" + fieldNumberToRead, structPointerExpr, false);
    }

    public CIdExpression exprForStructOrUnionOnStackVar(String structName, String variableName, List<CType> fieldTypes, boolean deref, CComplexType.ComplexTypeKind structOrUnion) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (int i = 0; i < fieldTypes.size(); ++i) {
            builder.add((Object)new CCompositeType.CCompositeTypeMemberDeclaration(fieldTypes.get(i), "field" + i));
        }
        ImmutableList members = builder.build();
        CCompositeType structType = new CCompositeType(false, false, structOrUnion, (List<CCompositeType.CCompositeTypeMemberDeclaration>)members, structName, structName);
        CElaboratedType elaboratedType = new CElaboratedType(false, false, structOrUnion, structName, structName, structType);
        CPointerType structPointerType = new CPointerType(false, false, elaboratedType);
        CVariableDeclaration declararation = deref ? new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, structPointerType, variableName + "NotQual", variableName + "NotQual", variableName, CDefaults.forType(structPointerType, FileLocation.DUMMY)) : new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, elaboratedType, variableName + "NotQual", variableName + "NotQual", variableName, CDefaults.forType(elaboratedType, FileLocation.DUMMY));
        return new CIdExpression(FileLocation.DUMMY, declararation);
    }

    public CFieldReference createFieldRefForStackVar(String structName, String variableName, int fieldNumberToRead, List<CType> fieldTypes, boolean deref, CComplexType.ComplexTypeKind structOrUnion) {
        CIdExpression structVarExpr = this.exprForStructOrUnionOnStackVar(structName, variableName, fieldTypes, deref, structOrUnion);
        CType structExprType = structVarExpr.getExpressionType();
        if (structExprType instanceof CPointerType) {
            structExprType = ((CPointerType)structExprType).getType();
        }
        CCompositeType structRetType = (CCompositeType)((CElaboratedType)structExprType).getRealType();
        return new CFieldReference(FileLocation.DUMMY, structRetType.getMembers().get(fieldNumberToRead).getType(), "field" + fieldNumberToRead, structVarExpr, deref);
    }

    private void setupStackArray(String arrayVariableName, CType arrayElementType) throws SMG2Exception {
        int sizeOfCurrentTypeInBits = MACHINE_MODEL.getSizeof(arrayElementType).intValue() * 8;
        this.addStackVariableToMemoryModel(arrayVariableName, sizeOfCurrentTypeInBits * 40);
        for (int k = 0; k < 40; ++k) {
            Value arrayValue = this.transformInputIntoValue(arrayElementType, k);
            this.writeToStackVariableInMemoryModel(arrayVariableName, sizeOfCurrentTypeInBits * k, sizeOfCurrentTypeInBits, arrayValue);
        }
    }

    private Value setupHeapStructAndFill(String stackVariableName, List<CType> listOfTypes) throws InvalidConfigurationException, SMG2Exception {
        SymbolicIdentifier addressValue = SymbolicValueFactory.getInstance().newIdentifier(null);
        this.addHeapVariableToMemoryModel(0, this.getSizeInBitsForListOfCTypeWithPadding(listOfTypes), addressValue);
        this.addStackVariableToMemoryModel(stackVariableName, POINTER_SIZE_IN_BITS);
        this.writeToStackVariableInMemoryModel(stackVariableName, 0, POINTER_SIZE_IN_BITS, addressValue);
        for (int i = 0; i < listOfTypes.size(); ++i) {
            CType currentType = listOfTypes.get(i);
            Value intValue = this.transformInputIntoValue(currentType, i);
            this.writeToHeapObjectByAddress(addressValue, this.getOffsetInBitsWithPadding(listOfTypes, i), MACHINE_MODEL.getSizeof(currentType).intValue() * 8, intValue);
        }
        return addressValue;
    }

    private Value setupHeapArray(String arrayVariableName, CType currentArrayType) throws InvalidConfigurationException, SMG2Exception {
        int sizeOfCurrentTypeInBits = MACHINE_MODEL.getSizeof(currentArrayType).intValue() * 8;
        SymbolicIdentifier addressValue = SymbolicValueFactory.getInstance().newIdentifier(null);
        this.addHeapVariableToMemoryModel(0, sizeOfCurrentTypeInBits * 40, addressValue);
        this.addStackVariableToMemoryModel(arrayVariableName, POINTER_SIZE_IN_BITS);
        this.writeToStackVariableInMemoryModel(arrayVariableName, 0, POINTER_SIZE_IN_BITS, addressValue);
        for (int k = 0; k < 40; ++k) {
            Value arrayValue = this.transformInputIntoValue(currentArrayType, k);
            this.writeToHeapObjectByAddress(addressValue, sizeOfCurrentTypeInBits * k, sizeOfCurrentTypeInBits, arrayValue);
        }
        return addressValue;
    }

    private void setupIndexVariables(String indexVariableName) throws SMG2Exception {
        for (int k = 0; k < 40; ++k) {
            this.addStackVariableToMemoryModel(indexVariableName + k, MACHINE_MODEL.getSizeof(INT_TYPE).intValue() * 8);
            this.writeToStackVariableInMemoryModel(indexVariableName + k, 0, MACHINE_MODEL.getSizeof(INT_TYPE).intValue() * 8, new NumericValue(k));
        }
    }

    private void addStackVariableToMemoryModel(String variableName, int sizeInBits) throws SMG2Exception {
        if (this.currentState.getMemoryModel().getStackFrames().size() < 1) {
            this.currentState = this.currentState.copyAndAddStackFrame(CFunctionDeclaration.DUMMY);
        }
        this.currentState = this.currentState.copyAndAddLocalVariable(sizeInBits, variableName, null);
        this.visitor = new SMGCPAValueVisitor(this.evaluator, this.currentState, new DummyCFAEdge(null, null), this.logger);
    }

    private void writeToStackVariableInMemoryModel(String stackVariableName, int writeOffsetInBits, int writeSizeInBits, Value valueToWrite) {
        if (valueToWrite instanceof AddressExpression) {
            ValueAndSMGState valueToWriteAndState = this.currentState.transformAddressExpression(valueToWrite);
            valueToWrite = valueToWriteAndState.getValue();
            this.currentState = valueToWriteAndState.getState();
        }
        Preconditions.checkArgument((!(valueToWrite instanceof AddressExpression) ? 1 : 0) != 0);
        SMGValueAndSMGState valueAndState = this.currentState.copyAndAddValue(valueToWrite);
        SMGValue smgValue = valueAndState.getSMGValue();
        this.currentState = valueAndState.getSMGState();
        this.currentState = this.currentState.writeValue(this.currentState.getMemoryModel().getObjectForVisibleVariable(stackVariableName).orElseThrow(), BigInteger.valueOf(writeOffsetInBits), BigInteger.valueOf(writeSizeInBits), smgValue);
        this.visitor = new SMGCPAValueVisitor(this.evaluator, this.currentState, new DummyCFAEdge(null, null), this.logger);
    }

    private void addHeapVariableToMemoryModel(int offset, int size, Value addressValue) throws InvalidConfigurationException {
        SymbolicProgramConfiguration spc = this.currentState.getMemoryModel();
        SMGObject smgHeapObject = SMGObject.of(0, BigInteger.valueOf(size), BigInteger.valueOf(0L));
        spc = spc.copyAndAddHeapObject(smgHeapObject);
        spc = spc.copyAndAddPointerFromAddressToRegion(addressValue, smgHeapObject, BigInteger.valueOf(offset));
        this.currentState = SMGState.of(MachineModel.LINUX64, spc, (LogManager)this.logger, new SMGOptions(Configuration.defaultConfiguration()), this.currentState.getErrorInfo());
        this.visitor = new SMGCPAValueVisitor(this.evaluator, this.currentState, new DummyCFAEdge(null, null), this.logger);
    }

    private Value addPointerToMemory(SMGObject pTarget, int offset) throws InvalidConfigurationException {
        ValueAndSMGState addressAndState = this.currentState.searchOrCreateAddress(pTarget, BigInteger.valueOf(offset));
        this.currentState = addressAndState.getState();
        this.visitor = new SMGCPAValueVisitor(this.evaluator, this.currentState, new DummyCFAEdge(null, null), this.logger);
        return addressAndState.getValue();
    }

    private Value addPointerToExistingHeapObject(int offset, Value addressOfTargetWith0Offset) throws SMG2Exception {
        SMGStateAndOptionalSMGObjectAndOffset objectAndOffset = this.currentState.dereferencePointer(addressOfTargetWith0Offset).get(0);
        Preconditions.checkArgument((objectAndOffset.getOffsetForObject().longValue() == 0L ? 1 : 0) != 0);
        ValueAndSMGState newPointerValueAndState = this.currentState.searchOrCreateAddress(objectAndOffset.getSMGObject(), BigInteger.valueOf(offset));
        this.currentState = newPointerValueAndState.getState();
        this.visitor = new SMGCPAValueVisitor(this.evaluator, this.currentState, new DummyCFAEdge(null, null), this.logger);
        return newPointerValueAndState.getValue();
    }

    private void writeToHeapObjectByAddress(Value addressValue, int writeOffsetInBits, int writeSizeInBits, Value valueToWrite) throws InvalidConfigurationException, SMG2Exception {
        SymbolicProgramConfiguration spc = this.currentState.getMemoryModel();
        SMGStateAndOptionalSMGObjectAndOffset targetAndOffset = this.currentState.dereferencePointer(addressValue).get(0);
        spc = spc.copyAndCreateValue(valueToWrite);
        spc = spc.writeValue(targetAndOffset.getSMGObject(), BigInteger.valueOf(writeOffsetInBits), BigInteger.valueOf(writeSizeInBits), spc.getSMGValueFromValue(valueToWrite).orElseThrow());
        this.currentState = SMGState.of(MachineModel.LINUX64, spc, (LogManager)this.logger, new SMGOptions(Configuration.defaultConfiguration()), this.currentState.getErrorInfo());
        this.visitor = new SMGCPAValueVisitor(this.evaluator, this.currentState, new DummyCFAEdge(null, null), this.logger);
    }

    public CArraySubscriptExpression arraySubscriptStackAccess(String variableName, CType elementType, int subscriptIndexInt, int lengthInt) {
        CIntegerLiteralExpression length = new CIntegerLiteralExpression(FileLocation.DUMMY, INT_TYPE, BigInteger.valueOf(lengthInt));
        CIntegerLiteralExpression subscriptAccess = new CIntegerLiteralExpression(FileLocation.DUMMY, INT_TYPE, BigInteger.valueOf(subscriptIndexInt));
        CArrayType arrayType = new CArrayType(false, false, elementType, length);
        CVariableDeclaration declararation = new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, arrayType, variableName + "NotQual", variableName + "NotQual", variableName, null);
        CIdExpression idExpr = new CIdExpression(FileLocation.DUMMY, declararation);
        return new CArraySubscriptExpression(FileLocation.DUMMY, elementType, idExpr, subscriptAccess);
    }

    public CArraySubscriptExpression arraySubscriptStackAccessWithVariable(String arrayVariableName, String indexVariableName, CType elementType, CType indexVariableType, int lengthInt) {
        CIntegerLiteralExpression length = new CIntegerLiteralExpression(FileLocation.DUMMY, INT_TYPE, BigInteger.valueOf(lengthInt));
        CArrayType arrayType = new CArrayType(false, false, elementType, length);
        CVariableDeclaration arrayDeclararation = new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, arrayType, arrayVariableName + "NotQual", arrayVariableName + "NotQual", arrayVariableName, null);
        CVariableDeclaration indexDeclararation = new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, indexVariableType, indexVariableName + "NotQual", indexVariableName + "NotQual", indexVariableName, null);
        CIdExpression arrayExpr = new CIdExpression(FileLocation.DUMMY, arrayDeclararation);
        CIdExpression indexVarExpr = new CIdExpression(FileLocation.DUMMY, indexDeclararation);
        return new CArraySubscriptExpression(FileLocation.DUMMY, elementType, arrayExpr, indexVarExpr);
    }

    public CArraySubscriptExpression arraySubscriptHeapAccess(String variableName, CType elementType, int subscriptIndexInt) {
        CIntegerLiteralExpression subscriptAccess = new CIntegerLiteralExpression(FileLocation.DUMMY, INT_TYPE, BigInteger.valueOf(subscriptIndexInt));
        CPointerType pointerType = new CPointerType(false, false, elementType);
        CVariableDeclaration declararation = new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, pointerType, variableName + "NotQual", variableName + "NotQual", variableName, null);
        CIdExpression idExpr = new CIdExpression(FileLocation.DUMMY, declararation);
        return new CArraySubscriptExpression(FileLocation.DUMMY, elementType, idExpr, subscriptAccess);
    }

    public CArraySubscriptExpression arraySubscriptHeapAccessWithVariable(String variableName, String indexVariableName, CType indexVariableType, CType elementType) {
        CPointerType pointerType = new CPointerType(false, false, elementType);
        CVariableDeclaration arrayDeclararation = new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, pointerType, variableName + "NotQual", variableName + "NotQual", variableName, null);
        CVariableDeclaration declararationIndex = new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, indexVariableType, indexVariableName + "NotQual", indexVariableName + "NotQual", indexVariableName, null);
        CIdExpression arrayExpr = new CIdExpression(FileLocation.DUMMY, arrayDeclararation);
        CIdExpression indexExpr = new CIdExpression(FileLocation.DUMMY, declararationIndex);
        return new CArraySubscriptExpression(FileLocation.DUMMY, elementType, arrayExpr, indexExpr);
    }

    public CPointerExpression arrayPointerAccess(String variableName, CType elementType, int arrayIndiceInt) {
        CIntegerLiteralExpression arrayIndice = new CIntegerLiteralExpression(FileLocation.DUMMY, INT_TYPE, BigInteger.valueOf(Math.abs(arrayIndiceInt)));
        CPointerType cPointerReturnType = new CPointerType(false, false, elementType);
        CPointerType cPointerBinaryOperType = new CPointerType(false, false, elementType);
        CVariableDeclaration idDeclararation = new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, cPointerReturnType, variableName + "NotQual", variableName + "NotQual", variableName, null);
        CIdExpression idExpr = new CIdExpression(FileLocation.DUMMY, idDeclararation);
        if (arrayIndiceInt == 0) {
            return new CPointerExpression(FileLocation.DUMMY, elementType, idExpr);
        }
        CBinaryExpression.BinaryOperator cBinOperator = arrayIndiceInt >= 0 ? CBinaryExpression.BinaryOperator.PLUS : CBinaryExpression.BinaryOperator.MINUS;
        CBinaryExpression arrayExpr = new CBinaryExpression(FileLocation.DUMMY, cPointerReturnType, cPointerBinaryOperType, idExpr, arrayIndice, cBinOperator);
        return new CPointerExpression(FileLocation.DUMMY, elementType, arrayExpr);
    }

    public CPointerExpression pointerWithBinaryAccessFromExpression(String variableName, CType elementType, int innerIndiceInt, int outerindiceInt) {
        CPointerType cPointerReturnType = new CPointerType(false, false, elementType);
        CPointerExpression inner = this.arrayPointerAccess(variableName, cPointerReturnType, innerIndiceInt);
        CIntegerLiteralExpression outerIndice = new CIntegerLiteralExpression(FileLocation.DUMMY, INT_TYPE, BigInteger.valueOf(Math.abs(outerindiceInt)));
        CPointerType cPointerBinaryOperType = new CPointerType(false, false, elementType);
        if (outerindiceInt == 0) {
            return new CPointerExpression(FileLocation.DUMMY, elementType, inner);
        }
        CBinaryExpression.BinaryOperator cBinOperator = outerindiceInt >= 0 ? CBinaryExpression.BinaryOperator.PLUS : CBinaryExpression.BinaryOperator.MINUS;
        CBinaryExpression outerBinaryExpr = new CBinaryExpression(FileLocation.DUMMY, cPointerReturnType, cPointerBinaryOperType, inner, outerIndice, cBinOperator);
        return new CPointerExpression(FileLocation.DUMMY, elementType, outerBinaryExpr);
    }

    public CPointerExpression pointerOfPointerAccess(String outerVariableName, CType elementType, int indiceInt) {
        CIntegerLiteralExpression arrayIndice = new CIntegerLiteralExpression(FileLocation.DUMMY, INT_TYPE, BigInteger.valueOf(Math.abs(indiceInt)));
        CPointerType cPointerReturnType = new CPointerType(false, false, elementType);
        CPointerType cPointerPointerReturnType = new CPointerType(false, false, cPointerReturnType);
        CPointerType cPointerBinaryOperType = new CPointerType(false, false, elementType);
        CVariableDeclaration declararation = new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, cPointerPointerReturnType, outerVariableName + "NotQual", outerVariableName + "NotQual", outerVariableName, null);
        CIdExpression idExpr = new CIdExpression(FileLocation.DUMMY, declararation);
        CPointerExpression pointerToArray = new CPointerExpression(FileLocation.DUMMY, cPointerReturnType, idExpr);
        if (indiceInt == 0) {
            return new CPointerExpression(FileLocation.DUMMY, elementType, pointerToArray);
        }
        CBinaryExpression.BinaryOperator cBinOperator = indiceInt >= 0 ? CBinaryExpression.BinaryOperator.PLUS : CBinaryExpression.BinaryOperator.MINUS;
        CBinaryExpression binaryExpr = new CBinaryExpression(FileLocation.DUMMY, cPointerReturnType, cPointerBinaryOperType, pointerToArray, arrayIndice, cBinOperator);
        return new CPointerExpression(FileLocation.DUMMY, elementType, binaryExpr);
    }

    public CPointerExpression arrayPointerAccessPlusVariableIndexOnTheRight(String arrayVariableName, String indexVariableName, CType indexVariableType, CType elementType) {
        CPointerType cPointerReturnType = new CPointerType(false, false, elementType);
        CPointerType cPointerBinaryOperType = new CPointerType(false, false, INT_TYPE);
        return this.buildCPointerExpressionFromBinary(cPointerReturnType, cPointerBinaryOperType, this.createCIdExprWithType(cPointerReturnType, arrayVariableName), this.createCIdExprWithType(indexVariableType, indexVariableName), elementType, CBinaryExpression.BinaryOperator.PLUS);
    }

    public CPointerExpression arrayPointerAccessPlusVariableIndexOnTheLeft(String arrayVariableName, String indexVariableName, CType indexVariableType, CType elementType) {
        CPointerType cPointerReturnType = new CPointerType(false, false, elementType);
        CPointerType cPointerBinaryOperType = new CPointerType(false, false, INT_TYPE);
        return this.buildCPointerExpressionFromBinary(cPointerReturnType, cPointerBinaryOperType, this.createCIdExprWithType(indexVariableType, indexVariableName), this.createCIdExprWithType(cPointerReturnType, arrayVariableName), elementType, CBinaryExpression.BinaryOperator.PLUS);
    }

    public CPointerExpression arrayPointerAccessMinusVariableIndexOnTheRight(String arrayVariableName, String indexVariableName, CType indexVariableType, CType elementType) {
        CPointerType cPointerReturnType = new CPointerType(false, false, elementType);
        CPointerType cPointerBinaryOperType = new CPointerType(false, false, INT_TYPE);
        return this.buildCPointerExpressionFromBinary(cPointerReturnType, cPointerBinaryOperType, this.createCIdExprWithType(cPointerReturnType, arrayVariableName), this.createCIdExprWithType(indexVariableType, indexVariableName), elementType, CBinaryExpression.BinaryOperator.MINUS);
    }

    public CBinaryExpression arrayPointerMinusArrayPointer(String leftArrayVariableName, String rightArrayVariableName, CType arrayType) {
        CPointerType cPointerReturnType = new CPointerType(false, false, arrayType);
        CPointerType cPointerBinaryOperType = new CPointerType(false, false, INT_TYPE);
        return new CBinaryExpression(FileLocation.DUMMY, cPointerBinaryOperType, cPointerBinaryOperType, this.createCIdExprWithType(cPointerReturnType, leftArrayVariableName), this.createCIdExprWithType(cPointerReturnType, rightArrayVariableName), CBinaryExpression.BinaryOperator.MINUS);
    }

    private CIdExpression createCIdExprWithType(CType indexVariableType, String indexVariableName) {
        CVariableDeclaration declararationIndex = new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, indexVariableType, indexVariableName, indexVariableName, indexVariableName, null);
        return new CIdExpression(FileLocation.DUMMY, declararationIndex);
    }

    private CPointerExpression buildCPointerExpressionFromBinary(CPointerType cPointerReturnType, CPointerType cPointerBinaryOperType, CIdExpression leftIdExpr, CIdExpression rightIdExpr, CType elementType, CBinaryExpression.BinaryOperator cBinOperator) {
        CBinaryExpression binaryExpr = new CBinaryExpression(FileLocation.DUMMY, cPointerReturnType, cPointerBinaryOperType, leftIdExpr, rightIdExpr, cBinOperator);
        return new CPointerExpression(FileLocation.DUMMY, elementType, binaryExpr);
    }

    private void checkValue(CType valueType, int numValue, Value valueToCheck) {
        Value expected = this.transformInputIntoValue(valueType, numValue);
        Truth.assertThat((Object)valueToCheck).isInstanceOf(expected.getClass());
        if (valueType instanceof CSimpleType) {
            Truth.assertThat((Object)valueToCheck).isInstanceOf(NumericValue.class);
            Truth.assertThat((Comparable)valueToCheck.asNumericValue().bigInteger()).isEqualTo((Object)expected.asNumericValue().bigInteger());
        }
    }

    private @Nullable Value transformInputIntoValue(CType valueType, int numValue) {
        if (valueType instanceof CSimpleType) {
            if (((CSimpleType)valueType).isSigned()) {
                return new NumericValue(numValue % 2 == 0 ? numValue : -numValue);
            }
            return new NumericValue(numValue);
        }
        return null;
    }
}

