/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.core.counterexample.Address;
import org.sosy_lab.cpachecker.core.counterexample.AssumptionToEdgeAllocator;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteState;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteStatePath;
import org.sosy_lab.cpachecker.core.counterexample.IDExpression;
import org.sosy_lab.cpachecker.core.counterexample.LeftHandSide;
import org.sosy_lab.cpachecker.core.counterexample.Memory;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentSet;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.StackFrame;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMG2Exception;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGStateAndOptionalSMGObjectAndOffset;
import org.sosy_lab.cpachecker.cpa.value.refiner.ConcreteErrorPathAllocator;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.smg.graph.SMGHasValueEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;

public class SMGConcreteErrorPathAllocator
extends ConcreteErrorPathAllocator<SMGState> {
    private static final String MEMORY_NAME = "SMGv2_Analysis_Heap";

    protected SMGConcreteErrorPathAllocator(AssumptionToEdgeAllocator pAssumptionToEdgeAllocator) {
        super(SMGState.class, pAssumptionToEdgeAllocator);
    }

    @Override
    protected ConcreteStatePath createConcreteStatePath(List<Pair<SMGState, List<CFAEdge>>> pPath) {
        ArrayList<ConcreteStatePath.ConcreteStatePathNode> result = new ArrayList<ConcreteStatePath.ConcreteStatePathNode>(pPath.size());
        for (Pair<SMGState, List<CFAEdge>> edgeStatePair : pPath) {
            SMGState valueState = edgeStatePair.getFirst();
            List<CFAEdge> edges = edgeStatePair.getSecond();
            if (edges.size() > 1) {
                Iterator it = Lists.reverse(edges).iterator();
                ArrayList<ConcreteStatePath.SingleConcreteState> intermediateStates = new ArrayList<ConcreteStatePath.SingleConcreteState>();
                HashSet<CLeftHandSide> alreadyAssigned = new HashSet<CLeftHandSide>();
                boolean isFirstIteration = true;
                while (it.hasNext()) {
                    CFAEdge innerEdge = (CFAEdge)it.next();
                    ConcreteState state = this.createConcreteStateForMultiEdge(valueState, alreadyAssigned, innerEdge);
                    if (isFirstIteration) {
                        intermediateStates.add(new ConcreteStatePath.SingleConcreteState(innerEdge, state));
                        isFirstIteration = false;
                        continue;
                    }
                    intermediateStates.add(new ConcreteStatePath.IntermediateConcreteState(innerEdge, state));
                }
                result.addAll(Lists.reverse(intermediateStates));
                continue;
            }
            HashMap<LeftHandSide, Address> variableAddresses = new HashMap<LeftHandSide, Address>();
            result.add(new ConcreteStatePath.SingleConcreteState((CFAEdge)Iterables.getOnlyElement(edges), new ConcreteState((Map<LeftHandSide, Object>)ImmutableMap.of(), this.allocateAddresses(valueState, variableAddresses), variableAddresses, exp -> MEMORY_NAME)));
        }
        return new ConcreteStatePath(result);
    }

    private ConcreteState createConcreteStateForMultiEdge(SMGState pValueState, Set<CLeftHandSide> alreadyAssigned, CFAEdge innerEdge) {
        CStatement stmt;
        ConcreteState state = this.allValuesForLeftHandSideKnown(innerEdge, alreadyAssigned) ? this.createConcreteState(pValueState) : ConcreteState.empty();
        if (innerEdge.getEdgeType() == CFAEdgeType.StatementEdge && (stmt = ((CStatementEdge)innerEdge).getStatement()) instanceof CAssignment) {
            CLeftHandSide lhs = ((CAssignment)stmt).getLeftHandSide();
            alreadyAssigned.add(lhs);
        }
        return state;
    }

    public ConcreteState createConcreteState(SMGState pValueState) {
        HashMap<LeftHandSide, Address> variableAddresses = new HashMap<LeftHandSide, Address>();
        return new ConcreteState((Map<LeftHandSide, Object>)ImmutableMap.of(), this.allocateAddresses(pValueState, variableAddresses), variableAddresses, exp -> MEMORY_NAME);
    }

    private boolean allValuesForLeftHandSideKnown(CFAEdge pCfaEdge, Set<CLeftHandSide> pAlreadyAssigned) {
        if (pCfaEdge.getEdgeType() == CFAEdgeType.DeclarationEdge) {
            return this.isDeclarationValueKnown((CDeclarationEdge)pCfaEdge, pAlreadyAssigned);
        }
        if (pCfaEdge.getEdgeType() == CFAEdgeType.StatementEdge) {
            return this.isStatementValueKnown((CStatementEdge)pCfaEdge, pAlreadyAssigned);
        }
        return false;
    }

    private boolean isStatementValueKnown(CStatementEdge pCfaEdge, Set<CLeftHandSide> pAlreadyAssigned) {
        CStatement stmt = pCfaEdge.getStatement();
        if (stmt instanceof CAssignment) {
            CLeftHandSide leftHandSide = ((CAssignment)stmt).getLeftHandSide();
            return this.isLeftHandSideValueKnown(leftHandSide, pAlreadyAssigned);
        }
        return true;
    }

    private Map<String, Memory> allocateAddresses(SMGState pValueState, Map<LeftHandSide, Address> pVariableAddressMap) {
        HashMap<Address, Object> values = new HashMap<Address, Object>();
        this.fillAddressAndValueMaps(pValueState, pVariableAddressMap, values);
        return ImmutableMap.of((Object)MEMORY_NAME, (Object)new Memory(MEMORY_NAME, values));
    }

    private void fillAddressAndValueMaps(SMGState state, Map<LeftHandSide, Address> lfhsToAddressMap, Map<Address, Object> valuesMap) {
        HashSet<SMGObject> todo = new HashSet<SMGObject>();
        HashSet<SMGObject> alreadyVisited = new HashSet<SMGObject>();
        StackFrame currentStackFrame = state.getMemoryModel().getStackFrames().peek();
        String functionName = currentStackFrame.getFunctionDefinition().getName();
        Address nextAddressToBeAssigned = Address.valueOf(BigInteger.ZERO);
        long spaceForLastValue = 64L;
        for (Map.Entry<String, SMGObject> var : currentStackFrame.getVariables().entrySet()) {
            String variableName = var.getKey().replace(functionName + "::", "");
            IDExpression idExp = new IDExpression(variableName, functionName);
            lfhsToAddressMap.put(idExp, nextAddressToBeAssigned);
            SMGObject objectForVar = var.getValue();
            long biggestOffset = this.putValuesIntoMap(nextAddressToBeAssigned, state, valuesMap, objectForVar, alreadyVisited, todo);
            BigInteger offset = BigInteger.valueOf(biggestOffset + spaceForLastValue);
            nextAddressToBeAssigned = nextAddressToBeAssigned.addOffset(offset);
        }
        PersistentMap<String, SMGObject> globalVarMapping = state.getMemoryModel().getGlobalVariableToSmgObjectMap();
        for (Map.Entry var : globalVarMapping.entrySet()) {
            String variableName = (String)var.getKey();
            IDExpression idExp = new IDExpression(variableName);
            lfhsToAddressMap.put(idExp, nextAddressToBeAssigned);
            SMGObject objectForVar = (SMGObject)var.getValue();
            long biggestOffset = this.putValuesIntoMap(nextAddressToBeAssigned, state, valuesMap, objectForVar, alreadyVisited, todo);
            BigInteger offset = BigInteger.valueOf(biggestOffset + spaceForLastValue);
            nextAddressToBeAssigned = nextAddressToBeAssigned.addOffset(offset);
        }
    }

    private long putValuesIntoMap(Address baseAddress, SMGState state, Map<Address, Object> valuesMap, SMGObject objectForVar, Set<SMGObject> alreadyVisited, Set<SMGObject> todo) {
        alreadyVisited.add(objectForVar);
        PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>> valuesByObject = state.getMemoryModel().getSmg().getSMGObjectsWithSMGHasValueEdges();
        PersistentSet valuesInObject = (PersistentSet)valuesByObject.get((Object)objectForVar);
        if (valuesInObject == null || valuesInObject.isEmpty()) {
            return 0L;
        }
        long biggestOffset = 0L;
        for (SMGHasValueEdge hve : valuesInObject) {
            if (hve.getOffset().longValue() > biggestOffset) {
                biggestOffset = hve.getOffset().longValue();
            }
            BigInteger offset = hve.getOffset();
            Optional<Value> value = state.getMemoryModel().getValueFromSMGValue(hve.hasValue());
            if (!value.orElseThrow().isNumericValue()) {
                if (!state.getMemoryModel().isPointer(value.orElseThrow())) continue;
                try {
                    SMGStateAndOptionalSMGObjectAndOffset target;
                    List<SMGStateAndOptionalSMGObjectAndOffset> listOfTargets = state.dereferencePointer(value.orElseThrow());
                    if (listOfTargets.size() == 1) {
                        target = listOfTargets.get(0);
                    } else {
                        Preconditions.checkArgument((listOfTargets.get(0).hasSMGObjectAndOffset() && !alreadyVisited.contains(listOfTargets.get(0).getSMGObject()) && !state.getMemoryModel().pointsToZeroPlus(value.orElseThrow()) ? 1 : 0) != 0);
                        target = listOfTargets.get(0);
                    }
                    if (!target.hasSMGObjectAndOffset() || alreadyVisited.contains(target.getSMGObject())) continue;
                    todo.add(target.getSMGObject());
                }
                catch (SMG2Exception sMG2Exception) {}
                continue;
            }
            valuesMap.put(baseAddress.addOffset(offset), value.orElseThrow().asNumericValue().bigInteger());
        }
        return biggestOffset;
    }
}

