/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2;

import com.google.common.collect.ImmutableMap;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentStack;
import org.sosy_lab.cpachecker.cpa.smg2.util.CFunctionDeclarationAndOptionalValue;
import org.sosy_lab.cpachecker.cpa.smg2.util.ValueAndValueSize;
import org.sosy_lab.cpachecker.util.smg.graph.SMGHasValueEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public final class SMGInformation {
    private final Map<SMGObject, Set<SMGHasValueEdge>> heapValuesRemoved;
    private final PersistentMap<String, CType> variableToTypeMap;
    private final Map<String, BigInteger> variableNameAndSizeInBits;
    private final PersistentMap<MemoryLocation, ValueAndValueSize> nonHeapAssignments;
    private final PersistentStack<CFunctionDeclarationAndOptionalValue> stackDeclarations;

    SMGInformation(PersistentMap<MemoryLocation, ValueAndValueSize> pAssignments, Map<String, BigInteger> pVariableNameAndSizeInBits, PersistentMap<String, CType> pVariableToTypeMap, PersistentStack<CFunctionDeclarationAndOptionalValue> pStackDeclarations) {
        this.nonHeapAssignments = pAssignments;
        this.variableNameAndSizeInBits = pVariableNameAndSizeInBits;
        this.variableToTypeMap = pVariableToTypeMap;
        this.stackDeclarations = pStackDeclarations;
        this.heapValuesRemoved = ImmutableMap.of();
    }

    SMGInformation(Map<SMGObject, Set<SMGHasValueEdge>> pHeapValuesRemoved) {
        this.nonHeapAssignments = PathCopyingPersistentTreeMap.of();
        this.variableNameAndSizeInBits = new HashMap<String, BigInteger>();
        this.variableToTypeMap = PathCopyingPersistentTreeMap.of();
        this.stackDeclarations = PersistentStack.of();
        this.heapValuesRemoved = pHeapValuesRemoved;
    }

    private SMGInformation() {
        this.nonHeapAssignments = PathCopyingPersistentTreeMap.of();
        this.variableNameAndSizeInBits = new HashMap<String, BigInteger>();
        this.variableToTypeMap = PathCopyingPersistentTreeMap.of();
        this.stackDeclarations = PersistentStack.of();
        this.heapValuesRemoved = ImmutableMap.of();
    }

    public static SMGInformation getEmptySMGInformation() {
        return new SMGInformation();
    }

    public Map<SMGObject, Set<SMGHasValueEdge>> getHeapValuesPerObjectMap() {
        return this.heapValuesRemoved;
    }

    public PersistentMap<MemoryLocation, ValueAndValueSize> getAssignments() {
        return this.nonHeapAssignments;
    }

    public PersistentMap<String, CType> getTypeOfVariablesMap() {
        return this.variableToTypeMap;
    }

    public Map<String, BigInteger> getSizeInformationForVariablesMap() {
        return this.variableNameAndSizeInBits;
    }

    public PersistentStack<CFunctionDeclarationAndOptionalValue> getDeclarationsForStackframesReversed() {
        return this.stackDeclarations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SMGInformation that = (SMGInformation)o;
        return this.nonHeapAssignments.equals(that.nonHeapAssignments) && this.heapValuesRemoved.equals(that.heapValuesRemoved);
    }

    public int hashCode() {
        return Objects.hash(this.nonHeapAssignments) + 31 * Objects.hash(this.variableToTypeMap) + 17 * Objects.hash(this.variableNameAndSizeInBits) + 23 * Objects.hash(this.heapValuesRemoved);
    }

    public String toString() {
        return "VariableInformation[" + this.nonHeapAssignments + "]\nHeap Values [" + this.heapValuesRemoved + "]";
    }
}

