/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2;

import com.google.common.collect.ImmutableSet;
import java.math.BigInteger;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.cpachecker.cpa.smg.SMGRuntimeCheck;

@Options(prefix="cpa.smg2")
public class SMGOptions {
    @Option(secure=true, description="with this option enabled, a check for unreachable memory occurs whenever a function returns, and not only at the end of the main function")
    private boolean checkForMemLeaksAtEveryFrameDrop = true;
    @Option(secure=true, description="with this option enabled, memory that is not freed before the end of main is reported as memleak even if it is reachable from local variables in main")
    private boolean handleNonFreedMemoryInMainAsMemLeak = true;
    @Option(secure=true, name="enableMallocFail", description="If this Option is enabled, failure of mallocis simulated")
    private boolean enableMallocFailure = true;
    @Option(secure=true, toUppercase=true, name="handleUnknownFunctions", description="Sets how unknown functions are handled.")
    private UnknownFunctionHandling handleUnknownFunctions = UnknownFunctionHandling.STRICT;
    @Option(secure=true, description="Which unknown function are always considered as safe functions, i.e., free of memory-related side-effects?")
    private ImmutableSet<String> safeUnknownFunctions = ImmutableSet.of((Object)"abort");
    @Option(secure=true, toUppercase=true, name="GCCZeroLengthArray", description="Enable GCC extension 'Arrays of Length Zero'.")
    private boolean GCCZeroLengthArray = false;
    @Option(secure=true, name="guessSizeOfUnknownMemorySize", description="Size of memory that cannot be calculated will be guessed.")
    private boolean guessSizeOfUnknownMemorySize = false;
    @Option(secure=true, name="memoryAllocationFunctions", description="Memory allocation functions")
    private ImmutableSet<String> memoryAllocationFunctions = ImmutableSet.of((Object)"malloc", (Object)"__kmalloc", (Object)"kmalloc", (Object)"realloc");
    @Option(secure=true, name="guessSize", description="Allocation size of memory that cannot be calculated.")
    private BigInteger guessSize = BigInteger.valueOf(2L);
    @Option(secure=true, name="memoryAllocationFunctionsSizeParameter", description="Size parameter of memory allocation functions")
    private int memoryAllocationFunctionsSizeParameter = 0;
    @Option(secure=true, name="arrayAllocationFunctions", description="Array allocation functions")
    private ImmutableSet<String> arrayAllocationFunctions = ImmutableSet.of((Object)"calloc");
    @Option(secure=true, name="memoryArrayAllocationFunctionsNumParameter", description="Position of number of element parameter for array allocation functions")
    private int memoryArrayAllocationFunctionsNumParameter = 0;
    @Option(secure=true, name="memoryArrayAllocationFunctionsElemSizeParameter", description="Position of element size parameter for array allocation functions")
    private int memoryArrayAllocationFunctionsElemSizeParameter = 1;
    @Option(secure=true, name="zeroingMemoryAllocation", description="Allocation functions which set memory to zero")
    private ImmutableSet<String> zeroingMemoryAllocation = ImmutableSet.of((Object)"calloc", (Object)"kzalloc");
    @Option(secure=true, name="deallocationFunctions", description="Deallocation functions")
    private ImmutableSet<String> deallocationFunctions = ImmutableSet.of((Object)"free");
    @Option(secure=true, name="externalAllocationFunction", description="Functions which indicate on external allocated memory")
    private ImmutableSet<String> externalAllocationFunction = ImmutableSet.of((Object)"ext_allocation");
    @Option(secure=true, name="externalAllocationSize", description="Default size of externally allocated memory")
    private int externalAllocationSize = Integer.MAX_VALUE;
    @Option(secure=true, name="trackPredicates", description="Enable track predicates on SMG state")
    private boolean trackPredicates = false;
    @Option(secure=true, name="trackErrorPredicates", description="Enable track predicates for possible memory safety error on SMG state")
    private boolean trackErrorPredicates = false;
    @Option(secure=true, name="handleUnknownDereferenceAsSafe", description="Handle unknown dereference as safe and check error based on error predicate, depends on trackPredicates")
    private boolean handleUnknownDereferenceAsSafe = false;
    @Option(secure=true, name="crashOnUnknown", description="Crash on unknown array dereferences")
    private boolean crashOnUnknown = false;
    @Option(secure=true, description="with this option enabled, heap abstraction will be enabled.")
    private boolean enableHeapAbstraction = false;
    @Option(secure=true, name="memoryErrors", description="Determines if memory errors are target states")
    private boolean memoryErrors = true;
    @Option(secure=true, name="unknownOnUndefined", description="Emit messages when we encounter non-target undefined behavior")
    private boolean unknownOnUndefined = true;
    @Option(secure=true, name="runtimeCheck", description="Sets the level of runtime checking: NONE, HALF, FULL")
    private SMGRuntimeCheck runtimeCheck = SMGRuntimeCheck.NONE;
    @Option(secure=true, name="exportSMG.file", description="Filename format for SMG graph dumps")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate exportSMGFilePattern = PathTemplate.ofFormatString((String)"smg/smg-%s.dot");
    @Option(secure=true, toUppercase=true, name="exportSMGwhen", description="Describes when SMG graphs should be dumped.")
    private SMGExportLevel exportSMG = SMGExportLevel.NEVER;
    @Option(secure=true, name="allocateExternalVariables", description="Allocate memory on declaration of external variable")
    private boolean allocateExternalVariables = true;
    @Option(secure=true, name="handleIncompleteExternalVariableAsExternalAllocation", description="Handle external variables with incomplete type (extern int array[]) as external allocation")
    private boolean handleIncompleteExternalVariableAsExternalAllocation = false;
    @Option(secure=true, name="joinOnBlockEnd", description="Perform merge SMGStates by SMGJoin on ends of code block. Works with 'merge=JOIN'")
    private boolean joinOnBlockEnd = true;
    @Option(secure=true, description="Use equality assumptions to assign values (e.g., (x == 0) => x = 0)")
    private boolean assignEqualityAssumptions = true;
    @Option(secure=true, description="Treat symbolic values as unknowns and assign new concrete values to them.")
    private boolean assignSymbolicValues = true;
    @Option(secure=true, description="if there is an assumption like (x!=0), this option sets unknown (uninitialized) variables to 1L, when the true-branch is handled.")
    private boolean initAssumptionVars = false;
    @Option(secure=true, description="Assume that variables used only in a boolean context are either zero or one.")
    private boolean optimizeBooleanVariables = true;
    @Option(secure=true, description="If this option is enabled, a memory allocation (e.g. malloc or array declaration) for unknown memory sizes does not abort, but also does not create any memory.")
    private boolean ignoreUnknownMemoryAllocation = false;

    public SMGOptions(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
    }

    public boolean isIgnoreUnknownMemoryAllocation() {
        return this.ignoreUnknownMemoryAllocation;
    }

    boolean isOptimizeBooleanVariables() {
        return this.optimizeBooleanVariables;
    }

    boolean isInitAssumptionVars() {
        return this.initAssumptionVars;
    }

    public boolean isCheckForMemLeaksAtEveryFrameDrop() {
        return this.checkForMemLeaksAtEveryFrameDrop;
    }

    public boolean isHandleNonFreedMemoryInMainAsMemLeak() {
        return this.handleNonFreedMemoryInMainAsMemLeak;
    }

    public boolean isEnableMallocFailure() {
        return this.enableMallocFailure;
    }

    public UnknownFunctionHandling getHandleUnknownFunctions() {
        return this.handleUnknownFunctions;
    }

    public ImmutableSet<String> getSafeUnknownFunctions() {
        return this.safeUnknownFunctions;
    }

    public boolean isGCCZeroLengthArray() {
        return this.GCCZeroLengthArray;
    }

    public boolean isGuessSizeOfUnknownMemorySize() {
        return this.guessSizeOfUnknownMemorySize;
    }

    public BigInteger getGuessSize() {
        return this.guessSize;
    }

    public ImmutableSet<String> getMemoryAllocationFunctions() {
        return this.memoryAllocationFunctions;
    }

    public int getMemoryAllocationFunctionsSizeParameter() {
        return this.memoryAllocationFunctionsSizeParameter;
    }

    public ImmutableSet<String> getArrayAllocationFunctions() {
        return this.arrayAllocationFunctions;
    }

    public int getMemoryArrayAllocationFunctionsNumParameter() {
        return this.memoryArrayAllocationFunctionsNumParameter;
    }

    public int getMemoryArrayAllocationFunctionsElemSizeParameter() {
        return this.memoryArrayAllocationFunctionsElemSizeParameter;
    }

    public ImmutableSet<String> getZeroingMemoryAllocation() {
        return this.zeroingMemoryAllocation;
    }

    public ImmutableSet<String> getDeallocationFunctions() {
        return this.deallocationFunctions;
    }

    public ImmutableSet<String> getExternalAllocationFunction() {
        return this.externalAllocationFunction;
    }

    public int getExternalAllocationSize() {
        return this.externalAllocationSize;
    }

    public boolean trackPredicates() {
        return this.trackPredicates;
    }

    public boolean trackErrorPredicates() {
        return this.trackErrorPredicates;
    }

    public boolean isHeapAbstractionEnabled() {
        return this.enableHeapAbstraction;
    }

    public boolean isMemoryErrorTarget() {
        return this.memoryErrors;
    }

    public boolean unknownOnUndefined() {
        return this.unknownOnUndefined;
    }

    public SMGRuntimeCheck getRuntimeCheck() {
        return this.runtimeCheck;
    }

    public PathTemplate getExportSMGFilePattern() {
        return this.exportSMGFilePattern;
    }

    public SMGExportLevel getExportSMGLevel() {
        return this.exportSMG;
    }

    public boolean isHandleIncompleteExternalVariableAsExternalAllocation() {
        return this.handleIncompleteExternalVariableAsExternalAllocation;
    }

    public boolean getAllocateExternalVariables() {
        return this.allocateExternalVariables;
    }

    public boolean isHandleUnknownDereferenceAsSafe() {
        return this.handleUnknownDereferenceAsSafe;
    }

    public boolean getJoinOnBlockEnd() {
        return this.joinOnBlockEnd;
    }

    public boolean crashOnUnknown() {
        return this.crashOnUnknown;
    }

    boolean isAssignEqualityAssumptions() {
        return this.assignEqualityAssumptions;
    }

    boolean isAssignSymbolicValues() {
        return this.assignSymbolicValues;
    }

    public static enum SMGExportLevel {
        NEVER,
        LEAF,
        INTERESTING,
        EVERY;

    }

    public static enum UnknownFunctionHandling {
        STRICT,
        ASSUME_SAFE,
        ASSUME_EXTERNAL_ALLOCATED;

    }
}

