/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.core.defaults.precision.RefinablePrecision;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class SMGPrecision
extends RefinablePrecision {
    private final ImmutableSortedSet<MemoryLocation> rawPrecision;
    private final ImmutableSet<Value> trackedHeapValues;

    SMGPrecision(VariableTrackingPrecision pBaseline) {
        super(pBaseline);
        this.rawPrecision = ImmutableSortedSet.of();
        this.trackedHeapValues = ImmutableSet.of();
    }

    private SMGPrecision(VariableTrackingPrecision pBaseline, Iterable<MemoryLocation> pRawPrecision, Iterable<Value> pTrackedHeapValues) {
        super(pBaseline);
        this.rawPrecision = ImmutableSortedSet.copyOf(pRawPrecision);
        this.trackedHeapValues = ImmutableSet.copyOf(pTrackedHeapValues);
    }

    @Override
    public SMGPrecision withIncrement(Multimap<CFANode, MemoryLocation> increment) {
        if (this.rawPrecision.containsAll(increment.values())) {
            return this;
        }
        Iterable refinedPrec = Iterables.concat(this.rawPrecision, (Iterable)increment.values());
        return new SMGPrecision(super.getBaseline(), refinedPrec, (Iterable<Value>)this.trackedHeapValues);
    }

    public SMGPrecision withValueIncrement(Multimap<CFANode, Value> increment) {
        if (this.trackedHeapValues.containsAll(increment.values())) {
            return this;
        }
        Iterable refinedTrackedHeapValues = Iterables.concat(this.trackedHeapValues, (Iterable)increment.values());
        return new SMGPrecision(super.getBaseline(), (Iterable<MemoryLocation>)this.rawPrecision, refinedTrackedHeapValues);
    }

    @Override
    public void serialize(Writer writer) throws IOException {
        ArrayList<String> globals = new ArrayList<String>();
        String previousScope = null;
        for (MemoryLocation variable : this.rawPrecision) {
            if (variable.isOnFunctionStack()) {
                String functionName = variable.getFunctionName();
                if (!functionName.equals(previousScope)) {
                    writer.write("\n" + functionName + ":\n");
                }
                writer.write(variable.getExtendedQualifiedName() + "\n");
                previousScope = functionName;
                continue;
            }
            globals.add(variable.getExtendedQualifiedName());
        }
        if (previousScope != null) {
            writer.write("\n");
        }
        writer.write("*:\n" + Joiner.on((String)"\n").join(globals));
    }

    @Override
    public VariableTrackingPrecision join(VariableTrackingPrecision pConsolidatedPrecision) {
        Preconditions.checkArgument((boolean)this.getClass().equals(pConsolidatedPrecision.getClass()));
        SMGPrecision consolidatedPrecision = (SMGPrecision)pConsolidatedPrecision;
        Preconditions.checkArgument((boolean)super.getBaseline().equals(consolidatedPrecision.getBaseline()));
        Iterable joinedPrec = Iterables.concat(this.rawPrecision, consolidatedPrecision.rawPrecision);
        return new SMGPrecision(super.getBaseline(), joinedPrec, (Iterable<Value>)ImmutableSet.builder().addAll(this.trackedHeapValues).addAll(consolidatedPrecision.trackedHeapValues).build());
    }

    public ImmutableSet<Value> getTrackedHeapValues() {
        return this.trackedHeapValues;
    }

    @Override
    public int getSize() {
        return this.rawPrecision.size() + this.trackedHeapValues.size();
    }

    public String toString() {
        return this.rawPrecision + " " + this.trackedHeapValues;
    }

    @Override
    public boolean isEmpty() {
        return this.rawPrecision.isEmpty() && this.trackedHeapValues.isEmpty();
    }

    @Override
    public boolean isTracking(MemoryLocation pVariable, Type pType, CFANode pLocation) {
        return super.isTracking(pVariable, pType, pLocation) && this.rawPrecision.contains((Object)pVariable);
    }

    @Override
    public boolean tracksTheSameVariablesAs(VariableTrackingPrecision pOtherPrecision) {
        return pOtherPrecision.getClass().equals(this.getClass()) && super.getBaseline().equals(((SMGPrecision)pOtherPrecision).getBaseline()) && this.rawPrecision.equals(((SMGPrecision)pOtherPrecision).rawPrecision);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && other instanceof SMGPrecision && this.rawPrecision.equals(((SMGPrecision)other).rawPrecision);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.rawPrecision.hashCode();
    }
}

