/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintStream;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.conditions.path.AssignmentsInPathCondition;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPAStatistics;
import org.sosy_lab.cpachecker.cpa.smg2.SMGPrecision;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.abstraction.SMGCPAAbstractionManager;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMG2Exception;
import org.sosy_lab.cpachecker.cpa.smg2.util.ValueAndValueSize;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.LiveVariables;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

public class SMGPrecisionAdjustment
implements PrecisionAdjustment {
    private final SMGCPAStatistics stats;
    private final PrecAdjustmentOptions options;
    private final Optional<LiveVariables> liveVariables;
    private final Optional<ImmutableSet<CFANode>> maybeLoops;
    private final StatCounter abstractions;
    private final StatTimer totalLiveness;
    private final StatTimer totalAbstraction;
    private final StatTimer totalEnforcePath;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="false alarm")
    private boolean performPrecisionBasedAbstraction = false;

    public SMGPrecisionAdjustment(SMGCPAStatistics pStats, CFA pCfa, PrecAdjustmentOptions pOptions, PrecAdjustmentStatistics pStatistics) {
        this.options = pOptions;
        this.stats = pStats;
        this.liveVariables = pCfa.getLiveVariables();
        this.maybeLoops = pCfa.getAllLoopHeads();
        this.abstractions = pStatistics.abstractions;
        pStatistics.renewTimers();
        this.totalLiveness = pStatistics.totalLivenessTimer;
        this.totalAbstraction = pStatistics.totalAbstractionTimer;
        this.totalEnforcePath = pStatistics.totalEnforcePathTimer;
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState pState, Precision pPrecision, UnmodifiableReachedSet pStates, Function<AbstractState, AbstractState> projection, AbstractState fullState) throws CPAException, InterruptedException {
        return this.prec((SMGState)pState, (VariableTrackingPrecision)pPrecision, AbstractStates.extractStateByType(fullState, LocationState.class), AbstractStates.extractStateByType(fullState, AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState.class));
    }

    private Optional<PrecisionAdjustmentResult> prec(SMGState pState, VariableTrackingPrecision pPrecision, LocationState location, AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState assignments) {
        SMGState resultState = pState;
        if (this.options.doLivenessAbstraction && this.liveVariables.isPresent()) {
            this.totalLiveness.start();
            if (this.options.abstractProgramVariables) {
                resultState = this.enforceLiveness(pState, location, resultState);
            }
            this.totalLiveness.stop();
        }
        this.totalAbstraction.start();
        if (this.performPrecisionBasedAbstraction()) {
            resultState = this.enforcePrecision(resultState, location, pPrecision);
        }
        this.totalAbstraction.stop();
        if (assignments != null) {
            this.totalEnforcePath.start();
            if (this.options.abstractProgramVariables) {
                resultState = this.enforcePathThreshold(resultState, assignments);
            }
            this.totalEnforcePath.stop();
        }
        if (this.options.abstractLinkedLists && this.checkAbstractListAt(location)) {
            try {
                resultState = new SMGCPAAbstractionManager(resultState, this.options.getListAbstractionMinimumLengthThreshhold()).findAndAbstractLists();
            }
            catch (SMG2Exception sMG2Exception) {
                // empty catch block
            }
        }
        return Optional.of(PrecisionAdjustmentResult.create(resultState, pPrecision, PrecisionAdjustmentResult.Action.CONTINUE));
    }

    private boolean isLoopHead(LocationState location) {
        return this.maybeLoops.isPresent() && this.maybeLoops.orElseThrow().contains((Object)location.getLocationNode());
    }

    private boolean checkAbstractListAt(LocationState location) {
        return this.options.abstractAtFunction(location) || this.isLoopHead(location);
    }

    private boolean performPrecisionBasedAbstraction() {
        if (this.options.iterationThreshold == -1) {
            return true;
        }
        if (this.stats.getCurrentNumberOfIterations() < this.options.iterationThreshold) {
            return false;
        }
        if (this.performPrecisionBasedAbstraction) {
            return true;
        }
        this.performPrecisionBasedAbstraction = this.stats.getCurrentLevelOfDeterminism() < this.options.determinismThreshold;
        return this.performPrecisionBasedAbstraction;
    }

    private SMGState enforceLiveness(SMGState pState, LocationState location, SMGState initialState) {
        boolean hasMoreThanOneEnteringLeavingEdge;
        CFANode actNode = location.getLocationNode();
        SMGState currentState = initialState;
        boolean bl = hasMoreThanOneEnteringLeavingEdge = actNode.getNumEnteringEdges() > 1 || actNode.getNumLeavingEdges() > 1;
        if (!this.options.onlyAtNonLinearCFA || hasMoreThanOneEnteringLeavingEdge) {
            boolean onlyBlankEdgesEntering = true;
            for (int i = 0; i < actNode.getNumEnteringEdges() && onlyBlankEdgesEntering; ++i) {
                onlyBlankEdgesEntering = location.getLocationNode().getEnteringEdge(i) instanceof BlankEdge;
            }
            if (!onlyBlankEdgesEntering) {
                for (MemoryLocation variable : pState.getTrackedMemoryLocations()) {
                    if (this.liveVariables.orElseThrow().isVariableLive(variable.getExtendedQualifiedName(), location.getLocationNode())) continue;
                    currentState = currentState.copyAndForget(variable).getState();
                }
            }
        }
        return currentState;
    }

    private SMGState enforcePrecision(SMGState state, LocationState location, VariableTrackingPrecision precision) {
        SMGState currentState = state;
        if (this.options.abstractAtEachLocation() || this.options.abstractAtBranch(location) || this.options.abstractAtJoin(location) || this.options.abstractAtFunction(location) || this.options.abstractAtLoop(location)) {
            if (this.options.abstractProgramVariables) {
                for (MemoryLocation memoryLocation : currentState.getMemoryModel().getMemoryLocationsAndValuesForSPCWithoutHeap().keySet()) {
                    CType type = currentState.getMemoryModel().getTypeOfVariable(memoryLocation);
                    if (location == null || precision.isTracking(memoryLocation, type, location.getLocationNode())) continue;
                    currentState = currentState.copyAndForget(memoryLocation).getState();
                }
            }
            if (precision instanceof SMGPrecision && this.options.abstractHeapValues) {
                SMGPrecision smgPrecision = (SMGPrecision)precision;
                currentState = currentState.enforceHeapValuePrecision((Set<Value>)smgPrecision.getTrackedHeapValues());
            }
            this.abstractions.inc();
        }
        return currentState;
    }

    private SMGState enforcePathThreshold(SMGState state, AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState assignments) {
        SMGState currentState = state;
        for (Map.Entry e : currentState.getMemoryModel().getMemoryLocationsAndValuesForSPCWithoutHeap().entrySet()) {
            MemoryLocation memoryLocation = (MemoryLocation)e.getKey();
            assignments.updateAssignmentInformation(memoryLocation, ((ValueAndValueSize)e.getValue()).getValue());
            if (!assignments.exceedsThreshold(memoryLocation)) continue;
            currentState = currentState.copyAndForget(memoryLocation).getState();
        }
        return currentState;
    }

    public static class PrecAdjustmentStatistics
    implements Statistics {
        final StatCounter abstractions = new StatCounter("Number of abstraction computations");
        private StatTimer totalLivenessTimer;
        private StatTimer totalAbstractionTimer;
        private StatTimer totalEnforcePathTimer;

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            this.renewTimers();
            StatisticsWriter writer = StatisticsWriter.writingStatisticsTo(pOut);
            writer.put(this.abstractions);
            writer.put(this.totalLivenessTimer);
            writer.put(this.totalAbstractionTimer);
            writer.put(this.totalEnforcePathTimer);
        }

        @Override
        public String getName() {
            return "SMGPrecisionAdjustment";
        }

        public void renewTimers() {
            this.totalLivenessTimer = new StatTimer("Total time for liveness abstraction");
            this.totalAbstractionTimer = new StatTimer("Total time for abstraction computation");
            this.totalEnforcePathTimer = new StatTimer("Total time for path thresholds");
        }
    }

    @Options(prefix="cpa.smg2.abstraction")
    public static class PrecAdjustmentOptions {
        @Option(secure=true, description="restrict abstraction computations to branching points")
        private boolean alwaysAtBranch = false;
        @Option(secure=true, description="restrict abstraction computations to join points")
        private boolean alwaysAtJoin = false;
        @Option(secure=true, description="restrict abstraction computations to function calls/returns")
        private boolean alwaysAtFunction = false;
        @Option(secure=true, description="If enabled, abstraction computations at loop-heads are enabled. List abstraction has to be enabled for this.")
        private boolean alwaysAtLoop = false;
        @Option(secure=true, description="toggle liveness abstraction")
        private boolean doLivenessAbstraction = false;
        @Option(secure=true, description="restrict liveness abstractions to nodes with more than one entering and/or leaving edge")
        private boolean onlyAtNonLinearCFA = false;
        @Option(secure=true, description="skip abstraction computations until the given number of iterations are reached, after that decision is based on then current level of determinism, setting the option to -1 always performs abstraction computations")
        @IntegerOption(min=-1L)
        private int iterationThreshold = -1;
        @Option(secure=true, description="threshold for level of determinism, in percent, up-to which abstraction computations are performed (and iteration threshold was reached)")
        @IntegerOption(min=0L, max=100L)
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="false alarm")
        private int determinismThreshold = 85;
        @Option(secure=true, name="listAbstractionMinimumLengthThreshhold", description="The minimum list segments directly following each other with the same value needed to abstract them.Minimum is 2.")
        private int listAbstractionMinimumLengthThreshhold = 12;
        @Option(secure=true, name="abstractHeapValues", description="If heap values are to be abstracted based on CEGAR.")
        private boolean abstractHeapValues = false;
        @Option(secure=true, name="abstractProgramVariables", description="Abstraction of program variables via CEGAR.")
        private boolean abstractProgramVariables = false;
        @Option(secure=true, name="abstractLinkedLists", description="Abstraction of all detected linked lists at loop heads.")
        private boolean abstractLinkedLists = true;
        private final @Nullable ImmutableSet<CFANode> loopHeads;

        public PrecAdjustmentOptions(Configuration config, CFA pCfa) throws InvalidConfigurationException {
            config.inject((Object)this);
            this.loopHeads = this.alwaysAtLoop && pCfa.getAllLoopHeads().isPresent() ? pCfa.getAllLoopHeads().orElseThrow() : null;
        }

        public int getListAbstractionMinimumLengthThreshhold() {
            return this.listAbstractionMinimumLengthThreshhold;
        }

        private boolean abstractAtEachLocation() {
            return !this.alwaysAtBranch && !this.alwaysAtJoin && !this.alwaysAtFunction && !this.alwaysAtLoop;
        }

        private boolean abstractAtBranch(LocationState location) {
            return this.alwaysAtBranch && location.getLocationNode().getNumLeavingEdges() > 1;
        }

        private boolean abstractAtJoin(LocationState location) {
            return this.alwaysAtJoin && location.getLocationNode().getNumEnteringEdges() > 1;
        }

        private boolean abstractAtFunction(LocationState location) {
            return this.alwaysAtFunction && (location.getLocationNode() instanceof FunctionEntryNode || location.getLocationNode().getEnteringSummaryEdge() != null);
        }

        private boolean abstractAtLoop(LocationState location) {
            Preconditions.checkState((!this.alwaysAtLoop || this.loopHeads != null ? 1 : 0) != 0);
            return this.alwaysAtLoop && this.loopHeads.contains((Object)location.getLocationNode());
        }
    }
}

