/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentSet;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentStack;
import org.sosy_lab.cpachecker.cpa.smg2.SMGErrorInfo;
import org.sosy_lab.cpachecker.cpa.smg2.SMGInformation;
import org.sosy_lab.cpachecker.cpa.smg2.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg2.StackFrame;
import org.sosy_lab.cpachecker.cpa.smg2.SymbolicProgramConfiguration;
import org.sosy_lab.cpachecker.cpa.smg2.abstraction.SMGCPAMaterializer;
import org.sosy_lab.cpachecker.cpa.smg2.refiner.SMGInterpolant;
import org.sosy_lab.cpachecker.cpa.smg2.util.CFunctionDeclarationAndOptionalValue;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMG2Exception;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGObjectAndOffset;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGObjectAndSMGState;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGStateAndOptionalSMGObjectAndOffset;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGValueAndSMGState;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGValueAndSPC;
import org.sosy_lab.cpachecker.cpa.smg2.util.SPCAndSMGObjects;
import org.sosy_lab.cpachecker.cpa.smg2.util.ValueAndValueSize;
import org.sosy_lab.cpachecker.cpa.smg2.util.value.ValueAndSMGState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.AddressExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicIdentifier;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueFactory;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.refinement.ImmutableForgetfulState;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.graph.SMGDoublyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGHasValueEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGPointsToEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGSinglyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.smg.join.SMGJoinSPC;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class SMGState
implements ImmutableForgetfulState<SMGInformation>,
LatticeAbstractState<SMGState>,
AbstractQueryableState,
Graphable {
    private static final String HAS_INVALID_FREES = "has-invalid-frees";
    private static final String HAS_INVALID_READS = "has-invalid-reads";
    private static final String HAS_INVALID_WRITES = "has-invalid-writes";
    private static final String HAS_LEAKS = "has-leaks";
    private static final String HAS_HEAP_OBJECTS = "has-heap-objects";
    private static final Pattern externalAllocationRecursivePattern = Pattern.compile("^(r_)(\\d+)(_.*)$");
    private final SymbolicProgramConfiguration memoryModel;
    private final MachineModel machineModel;
    private final LogManager logger;
    private final List<SMGErrorInfo> errorInfo;
    private final SMGOptions options;
    private final SMGCPAMaterializer materializer;
    private static int anonymousVarCount = 0;

    private SMGState(MachineModel pMachineModel, SymbolicProgramConfiguration spc, LogManager logManager, SMGOptions opts) {
        this.memoryModel = spc;
        this.machineModel = pMachineModel;
        this.logger = logManager;
        this.options = opts;
        this.errorInfo = ImmutableList.of();
        this.materializer = new SMGCPAMaterializer(this.logger);
    }

    private SMGState(MachineModel pMachineModel, SymbolicProgramConfiguration spc, LogManager logManager, SMGOptions opts, List<SMGErrorInfo> errorInf) {
        this.memoryModel = spc;
        this.machineModel = pMachineModel;
        this.logger = logManager;
        this.options = opts;
        this.errorInfo = errorInf;
        this.materializer = new SMGCPAMaterializer(this.logger);
    }

    @Override
    public Object evaluateProperty(String pProperty) throws InvalidQueryException {
        switch (pProperty) {
            case "toString": {
                return this.toString();
            }
            case "heapObjects": {
                return this.memoryModel.getHeapObjects();
            }
        }
        return this.checkProperty(pProperty);
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        switch (pProperty) {
            case "has-leaks": {
                if (this.hasMemoryLeak()) {
                    this.issueMemoryError("Memory leak found", false);
                    return true;
                }
                return false;
            }
            case "has-invalid-writes": {
                if (this.hasInvalidWrite()) {
                    this.issueMemoryError("Invalid write found", true);
                    return true;
                }
                return false;
            }
            case "has-invalid-reads": {
                if (this.hasInvalidRead()) {
                    this.issueMemoryError("Invalid read found", true);
                    return true;
                }
                return false;
            }
            case "has-invalid-frees": {
                if (this.hasInvalidFree()) {
                    this.issueMemoryError("Invalid free found", true);
                    return true;
                }
                return false;
            }
            case "has-heap-objects": {
                PersistentSet<SMGObject> heapObs = this.memoryModel.getHeapObjects();
                Preconditions.checkState((heapObs.size() >= 1 && heapObs.contains(SMGObject.nullInstance()) ? 1 : 0) != 0, (Object)"NULL must always be a heap object");
                for (SMGObject object : heapObs) {
                    if (this.memoryModel.isObjectValid(object)) continue;
                    heapObs = heapObs.removeAndCopy(object);
                }
                return !heapObs.isEmpty();
            }
        }
        throw new InvalidQueryException("Query '" + pProperty + "' is invalid.");
    }

    private void issueMemoryError(String pMessage, boolean pUndefinedBehavior) {
        if (this.options.isMemoryErrorTarget()) {
            this.logger.log(Level.FINE, new Object[]{pMessage});
        } else if (pUndefinedBehavior) {
            this.logger.log(Level.FINE, new Object[]{pMessage});
            this.logger.log(Level.FINE, new Object[]{"Non-target undefined behavior detected. The verification result is unreliable."});
        }
    }

    private boolean hasInvalidWrite() {
        for (SMGErrorInfo errorInf : this.errorInfo) {
            if (!errorInf.isInvalidWrite()) continue;
            return true;
        }
        return false;
    }

    private boolean hasInvalidRead() {
        for (SMGErrorInfo errorInf : this.errorInfo) {
            if (!errorInf.isInvalidRead()) continue;
            return true;
        }
        return false;
    }

    private boolean hasInvalidFree() {
        for (SMGErrorInfo errorInf : this.errorInfo) {
            if (!errorInf.isInvalidFree()) continue;
            return true;
        }
        return false;
    }

    private boolean hasMemoryLeak() {
        for (SMGErrorInfo errorInf : this.errorInfo) {
            if (!errorInf.hasMemoryLeak()) continue;
            return true;
        }
        return false;
    }

    public static SMGState of(MachineModel pMachineModel, LogManager logManager, SMGOptions opts) {
        return new SMGState(pMachineModel, SymbolicProgramConfiguration.of(BigInteger.valueOf(pMachineModel.getSizeofPtrInBits())), logManager, opts);
    }

    public static SMGState of(MachineModel pMachineModel, LogManager logManager, SMGOptions opts, CFA pCfa) {
        FunctionEntryNode pNode = pCfa.getMainFunction();
        return SMGState.of(pMachineModel, logManager, opts, pNode);
    }

    public static SMGState of(MachineModel pMachineModel, LogManager logManager, SMGOptions opts, FunctionEntryNode cfaFunEntryNode) {
        SMGState newState = SMGState.of(pMachineModel, logManager, opts);
        if (cfaFunEntryNode instanceof CFunctionEntryNode) {
            CFunctionEntryNode functionNode = (CFunctionEntryNode)cfaFunEntryNode;
            return newState.copyAndAddStackFrame(functionNode.getFunctionDefinition());
        }
        return newState;
    }

    public static SMGState of(MachineModel pMachineModel, LogManager logManager, SMGOptions opts, CFunctionDeclaration cfaEntryFunDecl) {
        return SMGState.of(pMachineModel, logManager, opts).copyAndAddStackFrame(cfaEntryFunDecl);
    }

    public static SMGState of(MachineModel pMachineModel, SymbolicProgramConfiguration pSPC, LogManager logManager, SMGOptions opts, List<SMGErrorInfo> pErrorInfo) {
        return new SMGState(pMachineModel, pSPC, logManager, opts, pErrorInfo);
    }

    public boolean isLocalOrGlobalVariablePresent(MemoryLocation memLoc) {
        String qualifiedName = memLoc.getQualifiedName();
        return this.isGlobalVariablePresent(qualifiedName) || this.isLocalVariablePresentAnywhere(qualifiedName);
    }

    public boolean isLocalOrGlobalVariablePresent(String qualifiedName) {
        return this.isGlobalVariablePresent(qualifiedName) || this.isLocalVariablePresent(qualifiedName);
    }

    public Optional<Boolean> isLocalOrGlobalVariableValid(String qualifiedName) {
        Optional<SMGObject> memRegion;
        if ((this.isGlobalVariablePresent(qualifiedName) || this.isLocalVariablePresentAnywhere(qualifiedName)) && (memRegion = this.memoryModel.getObjectForVisibleVariable(qualifiedName)).isPresent()) {
            return Optional.of(this.memoryModel.isObjectValid(memRegion.orElseThrow()));
        }
        return Optional.empty();
    }

    public SMGState copyAndRemoveStackVariable(String qualifiedName) {
        return this.copyAndReplaceMemoryModel(this.memoryModel.copyAndRemoveStackVariable(qualifiedName));
    }

    private SMGState assignReturnValue(MemoryLocation memLoc, ValueAndValueSize valueAndSize, Map<String, BigInteger> variableNameToMemorySizeInBits, Map<String, CType> variableTypeMap) {
        SMGState currentState = this;
        SMGObject obj = this.getReturnObjectForMemoryLocation(memLoc);
        BigInteger offsetToWriteToInBits = BigInteger.valueOf(memLoc.getOffset());
        @Nullable BigInteger sizeOfWriteInBits = valueAndSize.getSizeInBits();
        Preconditions.checkArgument((sizeOfWriteInBits != null ? 1 : 0) != 0);
        Value valueToWrite = valueAndSize.getValue();
        Preconditions.checkArgument((!valueToWrite.isUnknown() ? 1 : 0) != 0);
        CType typeOfUnknown = null;
        CType simpleType = variableTypeMap.get(memLoc.getQualifiedName());
        if (simpleType != null && simpleType.getCanonicalType() instanceof CSimpleType) {
            typeOfUnknown = simpleType;
        }
        return currentState.writeValue(obj, offsetToWriteToInBits, sizeOfWriteInBits, valueToWrite, typeOfUnknown);
    }

    private boolean isFunctionReturnVariableAndPresent(MemoryLocation memLoc) {
        return memLoc.getIdentifier().equals("__retval__") && this.getReturnObjectForMemoryLocation(memLoc) != null;
    }

    public SMGState assignNonHeapConstant(MemoryLocation memLoc, ValueAndValueSize valueAndSize, Map<String, BigInteger> variableNameToMemorySizeInBits, Map<String, CType> variableTypeMap) throws SMG2Exception {
        if (this.isFunctionReturnVariableAndPresent(memLoc)) {
            return this.assignReturnValue(memLoc, valueAndSize, variableNameToMemorySizeInBits, variableTypeMap);
        }
        SMGState currentState = this;
        String qualifiedName = memLoc.getQualifiedName();
        if (!this.isLocalOrGlobalVariablePresent(memLoc)) {
            BigInteger sizeInBits = variableNameToMemorySizeInBits.get(qualifiedName);
            currentState = memLoc.isOnFunctionStack() ? currentState.copyAndAddLocalVariableToSpecificStackframe(memLoc.getFunctionName(), sizeInBits, qualifiedName, variableTypeMap.get(qualifiedName)) : currentState.copyAndAddGlobalVariable(sizeInBits, qualifiedName, variableTypeMap.get(qualifiedName));
        }
        BigInteger offsetToWriteToInBits = BigInteger.valueOf(memLoc.getOffset());
        @Nullable BigInteger sizeOfWriteInBits = valueAndSize.getSizeInBits();
        Preconditions.checkArgument((sizeOfWriteInBits != null ? 1 : 0) != 0);
        Value valueToWrite = valueAndSize.getValue();
        Preconditions.checkArgument((!valueToWrite.isUnknown() ? 1 : 0) != 0);
        CType typeOfUnknown = null;
        CType simpleType = variableTypeMap.get(memLoc.getQualifiedName());
        if (simpleType != null && simpleType.getCanonicalType() instanceof CSimpleType) {
            typeOfUnknown = simpleType;
        }
        return currentState.writeToAnyStackOrGlobalVariable(qualifiedName, offsetToWriteToInBits, sizeOfWriteInBits, valueToWrite, typeOfUnknown);
    }

    public SMGState reconstructStackFrames(PersistentStack<CFunctionDeclarationAndOptionalValue> pStackDeclarations) {
        SMGState currentState = this;
        Iterator<StackFrame> existingFrames = currentState.memoryModel.getStackFrames().iterator();
        Iterator<CFunctionDeclarationAndOptionalValue> shouldBeFrames = pStackDeclarations.iterator();
        while (shouldBeFrames.hasNext()) {
            if (existingFrames.hasNext()) {
                StackFrame thisFrame = existingFrames.next();
                CFunctionDeclarationAndOptionalValue otherFunDefAndReturnValue = shouldBeFrames.next();
                CFunctionDeclaration otherFunDef = otherFunDefAndReturnValue.getCFunctionDeclaration();
                Preconditions.checkArgument((boolean)thisFrame.getFunctionDefinition().equals(otherFunDef));
                continue;
            }
            CFunctionDeclarationAndOptionalValue otherFunDefAndReturnValue = shouldBeFrames.next();
            CFunctionDeclaration otherFunDef = otherFunDefAndReturnValue.getCFunctionDeclaration();
            currentState = currentState.copyAndAddStackFrame(otherFunDef);
            if (!otherFunDefAndReturnValue.hasReturnValue()) continue;
            currentState = currentState.writeToReturn(otherFunDefAndReturnValue.getReturnValue());
        }
        return currentState;
    }

    public boolean verifyVariableEqualityWithValueAt(MemoryLocation variableAndOffset, ValueAndValueSize valueAndSize) {
        Value expectedValue = valueAndSize.getValue();
        Value readValue = this.getValueToVerify(variableAndOffset, valueAndSize);
        return expectedValue.asNumericValue().longValue() == readValue.asNumericValue().longValue();
    }

    public Value getValueToVerify(MemoryLocation variableAndOffset, ValueAndValueSize valueAndSize) {
        String variableName = variableAndOffset.getQualifiedName();
        BigInteger offsetInBits = BigInteger.valueOf(variableAndOffset.getOffset());
        @Nullable BigInteger sizeOfReadInBits = valueAndSize.getSizeInBits();
        if (sizeOfReadInBits == null) {
            return Value.UnknownValue.getInstance();
        }
        SMGObject memoryToRead = this.memoryModel.getObjectForVariable(variableName).orElseThrow();
        return this.readValueWithoutMaterialization(memoryToRead, offsetInBits, sizeOfReadInBits, null).getValue();
    }

    public SMGState reconstructSMGStateFromNonHeapAssignments(@Nullable PersistentMap<MemoryLocation, ValueAndValueSize> nonHeapAssignments, @Nullable Map<String, BigInteger> variableNameToMemorySizeInBits, @Nullable Map<String, CType> variableTypeMap, PersistentStack<CFunctionDeclarationAndOptionalValue> pStackDeclarations) throws SMG2Exception {
        if (nonHeapAssignments == null || pStackDeclarations == null) {
            return this;
        }
        SMGState currentState = this;
        currentState = currentState.reconstructStackFrames(pStackDeclarations);
        for (Map.Entry entry : nonHeapAssignments.entrySet()) {
            currentState = currentState.assignNonHeapConstant((MemoryLocation)entry.getKey(), (ValueAndValueSize)entry.getValue(), variableNameToMemorySizeInBits, variableTypeMap);
        }
        return currentState;
    }

    public SMGState withViolationsOf(SMGState pOther) {
        if (this.errorInfo.equals(pOther.errorInfo)) {
            return this;
        }
        return SMGState.of(this.machineModel, this.memoryModel, this.logger, this.options, (List<SMGErrorInfo>)new ImmutableList.Builder().addAll(this.errorInfo).addAll(pOther.errorInfo).build());
    }

    public SMGState copyAndAddGlobalVariable(int pTypeSizeInBits, String pVarName, CType type) {
        return this.copyAndAddGlobalVariable(BigInteger.valueOf(pTypeSizeInBits), pVarName, type);
    }

    public SMGState copyAndAddGlobalVariable(BigInteger pTypeSizeInBits, String pVarName, CType type) {
        SMGObject newObject = SMGObject.of(0, pTypeSizeInBits, BigInteger.ZERO);
        return SMGState.of(this.machineModel, this.memoryModel.copyAndAddGlobalObject(newObject, pVarName, type), this.logger, this.options, this.errorInfo);
    }

    public SMGObjectAndSMGState copyAndAddHeapObject(BigInteger pTypeSizeInBits) {
        SMGObject newObject = SMGObject.of(0, pTypeSizeInBits, BigInteger.ZERO);
        return SMGObjectAndSMGState.of(newObject, SMGState.of(this.machineModel, this.memoryModel.copyAndAddHeapObject(newObject), this.logger, this.options, this.errorInfo));
    }

    public SMGState copyAndAddObjectToHeap(SMGObject object) {
        return SMGState.of(this.machineModel, this.memoryModel.copyAndAddHeapObject(object), this.logger, this.options, this.errorInfo);
    }

    public SMGState copyAllValuesFromObjToObj(SMGObject source, SMGObject target) {
        return SMGState.of(this.machineModel, this.memoryModel.copyAllValuesFromObjToObj(source, target), this.logger, this.options, this.errorInfo);
    }

    public SMGState replaceAllPointersTowardsWith(SMGValue pointerValue, SMGObject newTarget) {
        return SMGState.of(this.machineModel, this.memoryModel.replaceAllPointersTowardsWith(pointerValue, newTarget), this.logger, this.options, this.errorInfo);
    }

    public SMGObjectAndSMGState copyAndAddStackObject(BigInteger pTypeSizeInBits) {
        SMGObject newObject = SMGObject.of(0, pTypeSizeInBits, BigInteger.ZERO);
        return SMGObjectAndSMGState.of(newObject, SMGState.of(this.machineModel, this.memoryModel.copyAndAddStackObject(newObject), this.logger, this.options, this.errorInfo));
    }

    public boolean isGlobalVariablePresent(String pVarName) {
        return this.memoryModel.getGlobalVariableToSmgObjectMap().containsKey((Object)pVarName);
    }

    private boolean isLocalVariablePresentAnywhere(String pVarName) {
        PersistentStack<StackFrame> frames = this.memoryModel.getStackFrames();
        if (frames == null) {
            return false;
        }
        for (StackFrame stackframe : frames) {
            if (!stackframe.getVariables().containsKey(pVarName)) continue;
            return true;
        }
        return false;
    }

    private boolean isLocalVariablePresent(String pVarName) {
        PersistentStack<StackFrame> frames = this.memoryModel.getStackFrames();
        if (frames == null) {
            return false;
        }
        StackFrame stackframe = frames.peek();
        return stackframe.getVariables().containsKey(pVarName);
    }

    public SMGState copyAndAddLocalVariable(int pTypeSize, String pVarName, CType type) throws SMG2Exception {
        if (this.memoryModel.getStackFrames().isEmpty()) {
            throw new SMG2Exception("Can't add a variable named " + pVarName + " to the memory model because there is no stack frame.");
        }
        SMGObject newObject = SMGObject.of(0, BigInteger.valueOf(pTypeSize), BigInteger.ZERO);
        return SMGState.of(this.machineModel, this.memoryModel.copyAndAddStackObject(newObject, pVarName, type), this.logger, this.options, this.errorInfo);
    }

    public SMGState copyAndAddLocalVariable(SMGObject object, String pVarName, CType type) throws SMG2Exception {
        if (this.memoryModel.getStackFrames().isEmpty()) {
            throw new SMG2Exception("Can't add a variable named " + pVarName + " to the memory model because there is no stack frame.");
        }
        return SMGState.of(this.machineModel, this.memoryModel.copyAndAddStackObject(object, pVarName, type), this.logger, this.options, this.errorInfo);
    }

    public SMGState copyAndAddLocalVariable(BigInteger pTypeSize, String pVarName, CType type) throws SMG2Exception {
        if (this.memoryModel.getStackFrames().isEmpty()) {
            throw new SMG2Exception("Can't add a variable named " + pVarName + " to the memory model because there is no stack frame.");
        }
        SMGObject newObject = SMGObject.of(0, pTypeSize, BigInteger.ZERO);
        return SMGState.of(this.machineModel, this.memoryModel.copyAndAddStackObject(newObject, pVarName, type), this.logger, this.options, this.errorInfo);
    }

    private SMGState copyAndAddLocalVariableToSpecificStackframe(String functionNameForStackFrame, BigInteger pTypeSize, String pVarName, CType type) throws SMG2Exception {
        if (this.memoryModel.getStackFrames().isEmpty()) {
            throw new SMG2Exception("Can't add a variable named " + pVarName + " to the memory model because there is no stack frame.");
        }
        SMGObject newObject = SMGObject.of(0, pTypeSize, BigInteger.ZERO);
        return SMGState.of(this.machineModel, this.memoryModel.copyAndAddStackObjectToSpecificStackFrame(functionNameForStackFrame, newObject, pVarName, type), this.logger, this.options, this.errorInfo);
    }

    public SMGState copyAndAddAnonymousVariable(int pTypeSize, CType type) throws SMG2Exception {
        return this.copyAndAddLocalVariable(pTypeSize, SMGState.makeAnonymousVariableName(), type);
    }

    public boolean checkVariableExists(SMGState pState, String variableName) {
        return pState.getMemoryModel().getObjectForVisibleVariable(variableName).isPresent();
    }

    public SMGState copyAndAddStackFrame(CFunctionDeclaration pFunctionDefinition) {
        return this.copyAndAddStackFrame(pFunctionDefinition, null);
    }

    public SMGState copyAndAddStackFrame(CFunctionDeclaration pFunctionDefinition, @Nullable ImmutableList<Value> variableArgumentsInOrder) {
        return SMGState.of(this.machineModel, this.memoryModel.copyAndAddStackFrame(pFunctionDefinition, this.machineModel, variableArgumentsInOrder), this.logger, this.options, this.errorInfo);
    }

    @Override
    public String toDOTLabel() {
        return this.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    @Override
    public String getCPAName() {
        return "SMGCPA";
    }

    @Override
    public SMGState join(SMGState pOther) throws CPAException, InterruptedException {
        SMGJoinSPC joinSPC = new SMGJoinSPC(this.memoryModel, pOther.memoryModel);
        if (joinSPC.getStatus() != SMGJoinStatus.INCOMPARABLE || !joinSPC.isDefined()) {
            return pOther;
        }
        return this;
    }

    @Override
    public boolean isLessOrEqual(SMGState pOther) throws CPAException, InterruptedException {
        if (this.getSize() < pOther.getSize()) {
            return false;
        }
        if (!this.errorInfo.isEmpty()) {
            ImmutableSet otherSetOfPropertyViolations = (ImmutableSet)pOther.errorInfo.stream().map(SMGErrorInfo::getPropertyViolated).collect(ImmutableSet.toImmutableSet());
            if (!this.errorInfo.stream().map(SMGErrorInfo::getPropertyViolated).allMatch(arg_0 -> ((ImmutableSet)otherSetOfPropertyViolations).contains(arg_0))) {
                return false;
            }
        }
        Iterator<CFunctionDeclarationAndOptionalValue> thisStackFrames = this.memoryModel.getFunctionDeclarationsFromStackFrames().iterator();
        Iterator<CFunctionDeclarationAndOptionalValue> otherStackFrames = pOther.memoryModel.getFunctionDeclarationsFromStackFrames().iterator();
        while (otherStackFrames.hasNext()) {
            if (!thisStackFrames.hasNext()) {
                return false;
            }
            CFunctionDeclarationAndOptionalValue thisFrame = thisStackFrames.next();
            CFunctionDeclarationAndOptionalValue otherFrame = otherStackFrames.next();
            if (otherFrame.hasReturnValue()) {
                Value otherRetVal = otherFrame.getReturnValue();
                if (!thisFrame.hasReturnValue()) {
                    return false;
                }
                Value thisRetVal = thisFrame.getReturnValue();
                if (this.areValuesEqual(this, thisRetVal, pOther, otherRetVal, (Set<Value>)ImmutableSet.of())) continue;
                return false;
            }
            if (!thisFrame.hasReturnValue()) continue;
            return false;
        }
        PersistentMap memLocAndValues = this.memoryModel.getMemoryLocationsAndValuesForSPCWithoutHeap();
        for (Map.Entry otherEntry : pOther.memoryModel.getMemoryLocationsAndValuesForSPCWithoutHeap().entrySet()) {
            MemoryLocation key = (MemoryLocation)otherEntry.getKey();
            Value otherValue = ((ValueAndValueSize)otherEntry.getValue()).getValue();
            ValueAndValueSize thisValueAndType = (ValueAndValueSize)memLocAndValues.get((Object)key);
            if (thisValueAndType == null || !this.areValuesEqual(this, thisValueAndType.getValue(), pOther, otherValue, (Set<Value>)ImmutableSet.of())) {
                return false;
            }
            memLocAndValues = memLocAndValues.removeAndCopy((Object)key);
        }
        for (Map.Entry remainingThisEntry : memLocAndValues.entrySet()) {
            Value otherValue = ((ValueAndValueSize)remainingThisEntry.getValue()).getValue();
            if (!this.memoryModel.isPointer(otherValue)) continue;
            return false;
        }
        if (memLocAndValues.size() > 0) {
            return false;
        }
        if (this.memoryModel.getHeapObjects().size() > pOther.memoryModel.getHeapObjects().size()) {
            return false;
        }
        for (SMGObject heapObjThis : this.memoryModel.getHeapObjects()) {
            if (!pOther.memoryModel.getHeapObjects().contains(heapObjThis) || pOther.memoryModel.getSmg().isValid(heapObjThis) == this.memoryModel.getSmg().isValid(heapObjThis)) continue;
            return false;
        }
        SPCAndSMGObjects newHeapAndUnreachablesThis = this.memoryModel.copyAndPruneUnreachable();
        SPCAndSMGObjects newHeapAndUnreachablesOther = pOther.memoryModel.copyAndPruneUnreachable();
        return newHeapAndUnreachablesOther.getSMGObjects().containsAll(newHeapAndUnreachablesThis.getSMGObjects());
    }

    private boolean areValuesEqual(SMGState thisState, @Nullable Value thisValue, SMGState otherState, @Nullable Value otherValue, Set<Value> thisAlreadyChecked) throws SMG2Exception {
        if (thisValue == otherValue && thisValue.isExplicitlyKnown()) {
            return true;
        }
        if (otherValue == null || thisValue == null) {
            return false;
        }
        if (thisValue.isNumericValue() && otherValue.isNumericValue()) {
            Number thisNum = thisValue.asNumericValue().getNumber();
            Number otherNum = otherValue.asNumericValue().getNumber();
            if (thisNum.getClass() != otherNum.getClass()) {
                return false;
            }
            if (thisNum instanceof Float && (((Float)thisNum).isNaN() || ((Float)otherNum).isNaN())) {
                return false;
            }
            if (thisNum instanceof Double && (((Double)thisNum).isNaN() || ((Double)otherNum).isNaN())) {
                return false;
            }
            return thisNum.equals(otherNum);
        }
        if (this.memoryModel.isPointer(thisValue) && otherState.memoryModel.isPointer(otherValue)) {
            if (thisAlreadyChecked.contains(thisValue)) {
                return true;
            }
            return this.isHeapEqualForTwoPointersWithTwoStates(thisState, thisValue, otherState, otherValue, (Set<Value>)ImmutableSet.builder().addAll(thisAlreadyChecked).add((Object)thisValue).build());
        }
        if (thisValue instanceof SymbolicExpression && otherValue instanceof SymbolicExpression && ((SymbolicExpression)thisValue).getType().equals(((SymbolicExpression)otherValue).getType())) {
            if (this.options.isAssignSymbolicValues()) {
                return true;
            }
            return thisValue.equals(otherValue);
        }
        return thisValue.equals(otherValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isHeapEqualForTwoPointersWithTwoStates(SMGState thisState, Value thisAddress, SMGState otherState, Value otherAddress, Set<Value> thisAlreadyChecked) throws SMG2Exception {
        Optional<SMGStateAndOptionalSMGObjectAndOffset> thisDeref = thisState.dereferencePointerWithoutMaterilization(thisAddress);
        Optional<SMGStateAndOptionalSMGObjectAndOffset> otherDeref = otherState.dereferencePointerWithoutMaterilization(otherAddress);
        if (!thisDeref.isPresent() || !otherDeref.isPresent()) return false;
        SMGStateAndOptionalSMGObjectAndOffset thisDerefObjAndOffset = thisDeref.orElseThrow();
        SMGStateAndOptionalSMGObjectAndOffset otherDerefObjAndOffset = otherDeref.orElseThrow();
        thisState = thisDerefObjAndOffset.getSMGState();
        otherState = otherDerefObjAndOffset.getSMGState();
        SMGObject thisObj = thisDerefObjAndOffset.getSMGObject();
        SMGObject otherObj = otherDerefObjAndOffset.getSMGObject();
        if (thisDerefObjAndOffset.getOffsetForObject().compareTo(otherDerefObjAndOffset.getOffsetForObject()) != 0) {
            return false;
        }
        if (!thisState.memoryModel.getPointerSpecifier(thisAddress).equals((Object)otherState.memoryModel.getPointerSpecifier(otherAddress))) {
            return false;
        }
        if (thisObj.getSize().compareTo(otherObj.getSize()) != 0 || thisObj.getNestingLevel() != otherObj.getNestingLevel() || thisObj.getOffset().compareTo(otherObj.getOffset()) != 0) {
            return false;
        }
        if (thisObj instanceof SMGDoublyLinkedListSegment) {
            if (!(otherObj instanceof SMGDoublyLinkedListSegment)) return false;
            SMGDoublyLinkedListSegment thisDLL = (SMGDoublyLinkedListSegment)thisObj;
            SMGDoublyLinkedListSegment otherDLL = (SMGDoublyLinkedListSegment)otherObj;
            if (thisDLL.getMinLength() < otherDLL.getMinLength() || thisDLL.getNextOffset().compareTo(otherDLL.getNextOffset()) != 0 || thisDLL.getPrevOffset().compareTo(otherDLL.getPrevOffset()) != 0 || thisDLL.getHeadOffset().compareTo(otherDLL.getHeadOffset()) != 0) return this.checkEqualValuesForTwoStatesWithExemptions(thisObj, otherObj, (ImmutableList<BigInteger>)ImmutableList.of(), thisState, otherState, thisAlreadyChecked);
            return this.checkEqualValuesForTwoStatesWithExemptions(thisDLL, otherDLL, (ImmutableList<BigInteger>)ImmutableList.of((Object)thisDLL.getNextOffset(), (Object)thisDLL.getPrevOffset()), thisState, otherState, thisAlreadyChecked);
        }
        if (!(thisObj instanceof SMGSinglyLinkedListSegment)) return this.checkEqualValuesForTwoStatesWithExemptions(thisObj, otherObj, (ImmutableList<BigInteger>)ImmutableList.of(), thisState, otherState, thisAlreadyChecked);
        if (!(otherObj instanceof SMGSinglyLinkedListSegment)) return false;
        SMGSinglyLinkedListSegment thisSLL = (SMGSinglyLinkedListSegment)thisObj;
        SMGSinglyLinkedListSegment otherSLL = (SMGSinglyLinkedListSegment)otherObj;
        if (thisSLL.getMinLength() < otherSLL.getMinLength() || thisSLL.getNextOffset().compareTo(otherSLL.getNextOffset()) != 0 || thisSLL.getHeadOffset().compareTo(otherSLL.getHeadOffset()) != 0) return this.checkEqualValuesForTwoStatesWithExemptions(thisObj, otherObj, (ImmutableList<BigInteger>)ImmutableList.of(), thisState, otherState, thisAlreadyChecked);
        return this.checkEqualValuesForTwoStatesWithExemptions(thisSLL, otherSLL, (ImmutableList<BigInteger>)ImmutableList.of((Object)thisSLL.getNextOffset()), thisState, otherState, thisAlreadyChecked);
    }

    private boolean checkEqualValuesForTwoStatesWithExemptions(SMGObject thisObject, SMGObject otherObject, ImmutableList<BigInteger> excemptOffsets, SMGState thisState, SMGState otherState, Set<Value> thisAlreadyChecked) throws SMG2Exception {
        Value thisHVEValue;
        Value otherHVEValue;
        FluentIterable<SMGHasValueEdge> otherHVEs;
        FluentIterable<SMGHasValueEdge> thisHVEs;
        if (excemptOffsets.isEmpty()) {
            thisHVEs = thisState.memoryModel.getSmg().getHasValueEdgesByPredicate(thisObject, (Predicate<SMGHasValueEdge>)((Predicate)hv -> true));
            otherHVEs = otherState.memoryModel.getSmg().getHasValueEdgesByPredicate(otherObject, (Predicate<SMGHasValueEdge>)((Predicate)e -> true));
        } else {
            thisHVEs = thisState.memoryModel.getSmg().getHasValueEdgesByPredicate(thisObject, (Predicate<SMGHasValueEdge>)((Predicate)e -> !excemptOffsets.contains((Object)e.getOffset())));
            otherHVEs = otherState.memoryModel.getSmg().getHasValueEdgesByPredicate(otherObject, (Predicate<SMGHasValueEdge>)((Predicate)e -> !excemptOffsets.contains((Object)e.getOffset())));
        }
        HashMap<BigInteger, SMGHasValueEdge> otherOffsetToHVEdgeMap = new HashMap<BigInteger, SMGHasValueEdge>();
        for (SMGHasValueEdge hve : otherHVEs) {
            otherOffsetToHVEdgeMap.put(hve.getOffset(), hve);
        }
        HashMap<BigInteger, SMGHasValueEdge> thisOffsetToHVEdgeMap = new HashMap<BigInteger, SMGHasValueEdge>();
        for (SMGHasValueEdge hve : thisHVEs) {
            thisOffsetToHVEdgeMap.put(hve.getOffset(), hve);
            if (!this.memoryModel.getSmg().isPointer(hve.hasValue()) || otherOffsetToHVEdgeMap.get(hve.getOffset()) != null) continue;
            return false;
        }
        for (SMGHasValueEdge otherHVE : otherHVEs) {
            BigInteger otherOffset = otherHVE.getOffset();
            SMGHasValueEdge thisHVE = (SMGHasValueEdge)thisOffsetToHVEdgeMap.get(otherOffset);
            if (thisHVE == null || thisHVE.getSizeInBits().compareTo(otherHVE.getSizeInBits()) != 0) {
                return false;
            }
            otherHVEValue = otherState.memoryModel.getValueFromSMGValue(otherHVE.hasValue()).orElseThrow();
            thisHVEValue = thisState.memoryModel.getValueFromSMGValue(thisHVE.hasValue()).orElseThrow();
            if (this.areValuesEqual(thisState, thisHVEValue, otherState, otherHVEValue, thisAlreadyChecked)) continue;
            return false;
        }
        for (SMGHasValueEdge thisHVE : thisHVEs) {
            BigInteger thisOffset = thisHVE.getOffset();
            SMGHasValueEdge otherHVE = (SMGHasValueEdge)otherOffsetToHVEdgeMap.get(thisOffset);
            if (otherHVE == null || thisHVE.getSizeInBits().compareTo(thisHVE.getSizeInBits()) != 0) {
                return false;
            }
            otherHVEValue = otherState.memoryModel.getValueFromSMGValue(otherHVE.hasValue()).orElseThrow();
            thisHVEValue = thisState.memoryModel.getValueFromSMGValue(thisHVE.hasValue()).orElseThrow();
            if (this.areValuesEqual(thisState, thisHVEValue, otherState, otherHVEValue, thisAlreadyChecked)) continue;
            return false;
        }
        return true;
    }

    public boolean hasMemoryErrors() {
        for (SMGErrorInfo info : this.errorInfo) {
            if (!info.hasMemoryErrors()) continue;
            return true;
        }
        return false;
    }

    public boolean hasMemoryLeaks() {
        for (SMGErrorInfo info : this.errorInfo) {
            if (!info.hasMemoryLeak()) continue;
            return true;
        }
        return false;
    }

    public boolean areNonEqualAddresses(Value pValue1, Value pValue2) {
        Optional<SMGValue> smgValue1 = this.memoryModel.getSMGValueFromValue(pValue1);
        Optional<SMGValue> smgValue2 = this.memoryModel.getSMGValueFromValue(pValue2);
        if (smgValue1.isEmpty() || smgValue2.isEmpty()) {
            return true;
        }
        return this.memoryModel.proveInequality(smgValue1.orElseThrow(), smgValue2.orElseThrow());
    }

    private void logMemoryError(String pMessage, boolean pUndefinedBehavior) {
        if (this.options.isMemoryErrorTarget()) {
            this.logger.log(Level.FINE, new Object[]{pMessage});
        } else if (pUndefinedBehavior) {
            this.logger.log(Level.FINE, new Object[]{pMessage});
            this.logger.log(Level.FINE, new Object[]{"Non-target undefined behavior detected. The verification result is unreliable."});
        }
    }

    private static String makeAnonymousVariableName() {
        return "anonymous_var_" + anonymousVarCount++;
    }

    public SMGState copyAndPruneOutOfScopeVariables(Set<CSimpleDeclaration> pOutOfScopeVars) {
        SMGState retState = this;
        for (CSimpleDeclaration variable : pOutOfScopeVars) {
            retState = retState.copyAndPruneVariable(MemoryLocation.forDeclaration(variable));
        }
        return retState;
    }

    public SMGState copyAndReplaceMemoryModel(SymbolicProgramConfiguration newSPC) {
        return SMGState.of(this.machineModel, newSPC, this.logger, this.options, this.errorInfo);
    }

    private SMGState copyAndPruneVariable(MemoryLocation pMemoryLocation) {
        if (pMemoryLocation.isOnFunctionStack()) {
            return this.copyAndPruneFunctionStackVariable(pMemoryLocation);
        }
        return this.copyAndPruneGlobalVariable(pMemoryLocation);
    }

    private SMGState copyAndPruneGlobalVariable(MemoryLocation pMemoryLocation) {
        return SMGState.of(this.machineModel, this.memoryModel.copyAndRemoveGlobalVariable(pMemoryLocation.getIdentifier()), this.logger, this.options, this.errorInfo);
    }

    private SMGState copyAndPruneFunctionStackVariable(MemoryLocation pMemoryLocation) {
        return SMGState.of(this.machineModel, this.memoryModel.copyAndRemoveStackVariable(pMemoryLocation.getQualifiedName()), this.logger, this.options, this.errorInfo);
    }

    public SMGState copyAndPruneFunctionStackVariable(String variableName) {
        return SMGState.of(this.machineModel, this.memoryModel.copyAndRemoveStackVariable(variableName), this.logger, this.options, this.errorInfo);
    }

    public SMGState dropStackFrame() {
        return SMGState.of(this.machineModel, this.memoryModel.copyAndDropStackFrame(), this.logger, this.options, this.errorInfo);
    }

    public SMGState copyAndPruneUnreachable() {
        SPCAndSMGObjects newHeapAndUnreachables = this.memoryModel.copyAndPruneUnreachable();
        SymbolicProgramConfiguration newHeap = newHeapAndUnreachables.getSPC();
        Collection<SMGObject> unreachableObjects = newHeapAndUnreachables.getSMGObjects();
        if (unreachableObjects.isEmpty()) {
            return this;
        }
        return this.copyAndReplaceMemoryModel(newHeap).copyWithMemLeak(unreachableObjects);
    }

    public SMGState copyAndRemoveObjectFromHeap(SMGObject obj) {
        return this.copyAndReplaceMemoryModel(this.memoryModel.copyAndRemoveObjectFromHeap(obj));
    }

    private SMGState copyWithMemLeak(Collection<SMGObject> leakedObjects) {
        String leakedObjectsLabels = leakedObjects.stream().map(Object::toString).collect(Collectors.joining(","));
        String errorMSG = "Memory leak of " + leakedObjectsLabels + " is detected.";
        SMGErrorInfo newErrorInfo = SMGErrorInfo.of().withProperty(SMGErrorInfo.Property.INVALID_HEAP).withErrorMessage(errorMSG).withInvalidObjects(leakedObjects);
        this.logMemoryError(errorMSG, true);
        return this.copyWithNewErrorInfo(newErrorInfo);
    }

    public SMGState withUninitializedVariableUsage(String uninitializedVariableName) {
        String errorMSG = "Usage of uninitialized variable: " + uninitializedVariableName + ". A unknown value was assumed, but behavior is of this variable is generally undefined.";
        SMGErrorInfo newErrorInfo = SMGErrorInfo.of().withProperty(SMGErrorInfo.Property.INVALID_READ).withErrorMessage(errorMSG).withInvalidObjects(Collections.singleton(uninitializedVariableName));
        this.logMemoryError(errorMSG, true);
        return this.copyWithNewErrorInfo(newErrorInfo);
    }

    public SMGState withUnknownPointerDereferenceWhenReading(Value unknownAddress) {
        String errorMSG = "Unknown value pointer dereference for value: " + unknownAddress + ".";
        SMGErrorInfo newErrorInfo = SMGErrorInfo.of().withProperty(SMGErrorInfo.Property.INVALID_READ).withErrorMessage(errorMSG).withInvalidObjects(Collections.singleton(unknownAddress));
        this.logMemoryError(errorMSG, true);
        return this.copyWithNewErrorInfo(newErrorInfo);
    }

    public SMGState withUnknownPointerDereferenceWhenWriting(Value unknownAddress) {
        String errorMSG = "Unknown value pointer dereference with intent to write to it for value: " + unknownAddress + ".";
        SMGErrorInfo newErrorInfo = SMGErrorInfo.of().withProperty(SMGErrorInfo.Property.INVALID_READ).withErrorMessage(errorMSG).withInvalidObjects(Collections.singleton(unknownAddress));
        this.logMemoryError(errorMSG, true);
        return this.copyWithNewErrorInfo(newErrorInfo);
    }

    public SMGState withWriteToUnknownVariable(String variableName) {
        String errorMSG = "Failed write to variable " + variableName + ".";
        SMGErrorInfo newErrorInfo = SMGErrorInfo.of().withProperty(SMGErrorInfo.Property.INVALID_WRITE).withErrorMessage(errorMSG).withInvalidObjects(Collections.singleton(variableName));
        this.logMemoryError(errorMSG, true);
        return this.copyWithNewErrorInfo(newErrorInfo);
    }

    public SMGState withNullPointerDereferenceWhenWriting(SMGObject nullObject) {
        String errorMSG = "Null pointer dereference on read of object with the intent to write to: " + nullObject + ".";
        SMGErrorInfo newErrorInfo = SMGErrorInfo.of().withProperty(SMGErrorInfo.Property.INVALID_READ).withErrorMessage(errorMSG).withInvalidObjects(Collections.singleton(nullObject));
        this.logMemoryError(errorMSG, true);
        return this.copyWithNewErrorInfo(newErrorInfo);
    }

    public SMGState withMemoryLeak(String errorMsg, Collection<Object> pUnreachableObjects) {
        SMGErrorInfo newErrorInfo = SMGErrorInfo.of().withProperty(SMGErrorInfo.Property.INVALID_HEAP).withErrorMessage(errorMsg).withInvalidObjects(pUnreachableObjects);
        this.logMemoryError(errorMsg, true);
        return this.copyWithNewErrorInfo(newErrorInfo);
    }

    public SMGState withInvalidWrite(Value invalidAddress) {
        String errorMSG = "Write to invalid, unknown or non-existing memory region, pointed to by: " + invalidAddress + ".";
        SMGErrorInfo newErrorInfo = SMGErrorInfo.of().withProperty(SMGErrorInfo.Property.INVALID_WRITE).withErrorMessage(errorMSG).withInvalidObjects(Collections.singleton(invalidAddress));
        this.logMemoryError(errorMSG, true);
        return this.copyWithNewErrorInfo(newErrorInfo);
    }

    public SMGState withInvalidWrite(SMGObject invalidWriteRegion) {
        String errorMSG = "Write to invalid, unknown or non-existing or beyond the boundries of a memory region: " + invalidWriteRegion + ".";
        SMGErrorInfo newErrorInfo = SMGErrorInfo.of().withProperty(SMGErrorInfo.Property.INVALID_WRITE).withErrorMessage(errorMSG).withInvalidObjects(Collections.singleton(invalidWriteRegion));
        this.logMemoryError(errorMSG, true);
        return this.copyWithNewErrorInfo(newErrorInfo);
    }

    public SMGState withInvalidWriteToZeroObject(SMGObject invalidWriteRegion) {
        String errorMSG = "Write to invalid memory region: NULL.";
        SMGErrorInfo newErrorInfo = SMGErrorInfo.of().withProperty(SMGErrorInfo.Property.INVALID_WRITE).withErrorMessage(errorMSG).withInvalidObjects(Collections.singleton(invalidWriteRegion));
        this.logMemoryError(errorMSG, true);
        return this.copyWithNewErrorInfo(newErrorInfo);
    }

    public SMGState withInvalidWrite(String errorMSG, Value invalidValue) {
        SMGErrorInfo newErrorInfo = SMGErrorInfo.of().withProperty(SMGErrorInfo.Property.INVALID_WRITE).withErrorMessage(errorMSG).withInvalidObjects(Collections.singleton(invalidValue));
        this.logMemoryError(errorMSG, true);
        return this.copyWithNewErrorInfo(newErrorInfo);
    }

    public SMGState withNullPointerDereferenceWhenReading(SMGObject nullObject) {
        String errorMSG = "Null pointer dereference on read of object with the intent to read it: " + nullObject + ".";
        SMGErrorInfo newErrorInfo = SMGErrorInfo.of().withProperty(SMGErrorInfo.Property.INVALID_READ).withErrorMessage(errorMSG).withInvalidObjects(Collections.singleton(nullObject));
        this.logMemoryError(errorMSG, true);
        return this.copyWithNewErrorInfo(newErrorInfo);
    }

    public SMGState withInvalidStackVariableRead(String readVariable) {
        String errorMSG = "Invalid read of variable named: " + readVariable + ".";
        SMGErrorInfo newErrorInfo = SMGErrorInfo.of().withProperty(SMGErrorInfo.Property.INVALID_READ).withErrorMessage(errorMSG).withInvalidObjects(Collections.singleton(readVariable));
        this.logMemoryError(errorMSG, true);
        return this.copyWithNewErrorInfo(newErrorInfo);
    }

    public SMGState withInvalidRead(SMGObject readMemory) {
        String errorMSG = "Invalid read of memory object: " + readMemory + ".";
        SMGErrorInfo newErrorInfo = SMGErrorInfo.of().withProperty(SMGErrorInfo.Property.INVALID_READ).withErrorMessage(errorMSG).withInvalidObjects(Collections.singleton(readMemory));
        this.logMemoryError(errorMSG, true);
        return this.copyWithNewErrorInfo(newErrorInfo);
    }

    public SMGState withOutOfRangeWrite(SMGObject objectWrittenTo, BigInteger writeOffset, BigInteger writeSize, Value pValue) {
        String errorMSG = String.format("Try writing value %s with size %d at offset %d bit to object sized %d bit.", pValue.toString(), writeSize, writeOffset, objectWrittenTo.getSize());
        SMGErrorInfo newErrorInfo = SMGErrorInfo.of().withProperty(SMGErrorInfo.Property.INVALID_WRITE).withErrorMessage(errorMSG).withInvalidObjects(Collections.singleton(objectWrittenTo));
        this.logMemoryError(errorMSG, true);
        return this.copyWithNewErrorInfo(newErrorInfo);
    }

    public SMGState withOutOfRangeRead(SMGObject objectRead, BigInteger readOffset, BigInteger readSize) {
        String errorMSG = String.format("Try reading object %s with size %d bits at offset %d bit with read type size %d bit", objectRead, objectRead.getSize(), readOffset, readSize);
        SMGErrorInfo newErrorInfo = SMGErrorInfo.of().withProperty(SMGErrorInfo.Property.INVALID_READ).withErrorMessage(errorMSG).withInvalidObjects(Collections.singleton(objectRead));
        this.logMemoryError(errorMSG, true);
        return this.copyWithNewErrorInfo(newErrorInfo);
    }

    public SMGState withUnknownOffsetMemoryAccess() {
        String errorMSG = "Memory access with an invalid or unknown offset detected. This might be the result of an overapproximation and might be a false positive.";
        SMGErrorInfo newErrorInfo = SMGErrorInfo.of().withProperty(SMGErrorInfo.Property.INVALID_READ).withErrorMessage(errorMSG).withInvalidObjects((Collection<?>)ImmutableSet.of());
        this.logMemoryError(errorMSG, true);
        return this.copyWithNewErrorInfo(newErrorInfo);
    }

    public SMGState withUndefinedbehavior(String errorMSG, Collection<Object> reason) {
        SMGErrorInfo newErrorInfo = SMGErrorInfo.of().withProperty(SMGErrorInfo.Property.UNDEFINED_BEHAVIOR).withErrorMessage(errorMSG).withInvalidObjects(reason);
        this.logMemoryError(errorMSG, true);
        return this.copyWithNewErrorInfo(newErrorInfo);
    }

    public SMGState withInvalidFree(String errorMSG, Value invalidValue) {
        SMGErrorInfo newErrorInfo = SMGErrorInfo.of().withProperty(SMGErrorInfo.Property.INVALID_FREE).withErrorMessage(errorMSG).withInvalidObjects(Collections.singleton(invalidValue));
        this.logMemoryError(errorMSG, true);
        return this.copyWithNewErrorInfo(newErrorInfo);
    }

    public SMGState copyWithNewErrorInfo(SMGErrorInfo pErrorInfo) {
        return SMGState.of(this.machineModel, this.memoryModel, this.logger, this.options, (List<SMGErrorInfo>)new ImmutableList.Builder().addAll(this.errorInfo).add((Object)pErrorInfo).build());
    }

    public SymbolicProgramConfiguration getMemoryModel() {
        return this.memoryModel;
    }

    public SMGValueAndSMGState copyAndAddValue(Value pValue) {
        Optional<SMGValue> maybeValue = this.memoryModel.getSMGValueFromValue(pValue);
        if (maybeValue.isPresent()) {
            return SMGValueAndSMGState.of(this, maybeValue.orElseThrow());
        }
        SMGValue newSMGValue = SMGValue.of();
        return SMGValueAndSMGState.of(SMGState.of(this.machineModel, this.memoryModel.copyAndPutValue(pValue, newSMGValue), this.logger, this.options, this.errorInfo), newSMGValue);
    }

    public List<SMGErrorInfo> getErrorInfo() {
        return this.errorInfo;
    }

    public Optional<SMGObjectAndOffset> getPointsToTarget(Value pValue) {
        Optional<SMGPointsToEdge> pointerEdgeOptional;
        Optional<SMGValue> addressOptional = this.memoryModel.getSMGValueFromValue(pValue);
        if (addressOptional.isPresent() && (pointerEdgeOptional = this.memoryModel.getSmg().getPTEdge(addressOptional.orElseThrow())).isPresent()) {
            return Optional.of(SMGObjectAndOffset.of(pointerEdgeOptional.orElseThrow().pointsTo(), pointerEdgeOptional.orElseThrow().getOffset()));
        }
        return Optional.empty();
    }

    private ValueAndSMGState searchOrCreateAddressForAddressExpr(Value pValue) {
        if (pValue instanceof AddressExpression) {
            AddressExpression addressExprValue = (AddressExpression)pValue;
            Value offsetAddr = addressExprValue.getOffset();
            if (offsetAddr.isNumericValue()) {
                BigInteger offsetAddrBI = offsetAddr.asNumericValue().bigInteger();
                if (offsetAddrBI.compareTo(BigInteger.ZERO) != 0) {
                    Optional<SMGObjectAndOffset> maybeTargetAndOffset = this.getPointsToTarget(addressExprValue.getMemoryAddress());
                    if (maybeTargetAndOffset.isEmpty()) {
                        return ValueAndSMGState.ofUnknownValue(this);
                    }
                    SMGObjectAndOffset targetAndOffset = maybeTargetAndOffset.orElseThrow();
                    SMGObject target = targetAndOffset.getSMGObject();
                    BigInteger offsetPointer = targetAndOffset.getOffsetForObject();
                    BigInteger offsetOverall = offsetPointer.add(offsetAddrBI);
                    ValueAndSMGState addressAndState = this.searchOrCreateAddress(target, offsetOverall);
                    return ValueAndSMGState.of(AddressExpression.withZeroOffset(addressAndState.getValue(), addressExprValue.getType()), addressAndState.getState());
                }
            } else {
                return ValueAndSMGState.ofUnknownValue(this);
            }
        }
        return ValueAndSMGState.of(pValue, this);
    }

    public ValueAndSMGState searchOrCreateAddress(SMGObject targetObject, BigInteger offsetInBits) {
        Optional<SMGValue> maybeAddressValue = this.getMemoryModel().getAddressValueForPointsToTarget(targetObject, offsetInBits);
        if (maybeAddressValue.isPresent()) {
            Optional<Value> valueForSMGValue = this.getMemoryModel().getValueFromSMGValue(maybeAddressValue.orElseThrow());
            return ValueAndSMGState.of(valueForSMGValue.orElseThrow(), this);
        }
        SymbolicIdentifier addressValue = SymbolicValueFactory.getInstance().newIdentifier(null);
        SMGState newState = this.createAndAddPointer(addressValue, targetObject, offsetInBits);
        return ValueAndSMGState.of(addressValue, newState);
    }

    public List<ValueAndSMGState> readValue(SMGObject pObject, BigInteger pFieldOffset, BigInteger pSizeofInBits, @Nullable CType readType) throws SMG2Exception {
        if (!this.memoryModel.isObjectValid(pObject) && !this.memoryModel.isObjectExternallyAllocated(pObject)) {
            return ImmutableList.of((Object)ValueAndSMGState.of(Value.UnknownValue.getInstance(), this.withInvalidRead(pObject)));
        }
        SMGValueAndSPC valueAndNewSPC = this.memoryModel.readValue(pObject, pFieldOffset, pSizeofInBits);
        SMGState currentState = this.copyAndReplaceMemoryModel(valueAndNewSPC.getSPC());
        SMGValue readSMGValue = valueAndNewSPC.getSMGValue();
        ImmutableList.Builder returnBuilder = ImmutableList.builder();
        if (this.memoryModel.getSmg().isPointer(readSMGValue) && this.memoryModel.getSmg().pointsToZeroPlus(readSMGValue)) {
            for (SMGStateAndOptionalSMGObjectAndOffset newState : this.materializeLinkedList(readSMGValue, this.memoryModel.getSmg().getPTEdge(readSMGValue).orElseThrow(), currentState)) {
                List<ValueAndSMGState> readAfterMat = newState.getSMGState().readValue(pObject, pFieldOffset, pSizeofInBits, readType);
                Preconditions.checkArgument((readAfterMat.size() == 1 ? 1 : 0) != 0);
                returnBuilder.addAll(readAfterMat);
            }
        } else {
            returnBuilder.add((Object)currentState.handleReadSMGValue(readSMGValue, readType));
        }
        return returnBuilder.build();
    }

    public ValueAndSMGState readValueWithoutMaterialization(SMGObject pObject, BigInteger pFieldOffset, BigInteger pSizeofInBits, @Nullable CType readType) {
        if (!this.memoryModel.isObjectValid(pObject) && !this.memoryModel.isObjectExternallyAllocated(pObject)) {
            return ValueAndSMGState.of(Value.UnknownValue.getInstance(), this.withInvalidRead(pObject));
        }
        SMGValueAndSPC valueAndNewSPC = this.memoryModel.readValue(pObject, pFieldOffset, pSizeofInBits);
        SMGState currentState = this.copyAndReplaceMemoryModel(valueAndNewSPC.getSPC());
        SMGValue readSMGValue = valueAndNewSPC.getSMGValue();
        return currentState.handleReadSMGValue(readSMGValue, readType);
    }

    private ValueAndSMGState handleReadSMGValue(SMGValue readSMGValue, @Nullable CType readType) {
        Optional<Value> maybeValue = this.getMemoryModel().getValueFromSMGValue(readSMGValue);
        if (maybeValue.isPresent()) {
            Preconditions.checkArgument((!(maybeValue.orElseThrow() instanceof AddressExpression) ? 1 : 0) != 0);
            Value valueRead = maybeValue.orElseThrow();
            if (readType != null && this.doesRequireUnionFloatConversion(valueRead, readType)) {
                valueRead = this.castValueForUnionFloatConversion(valueRead, readType);
            }
            return ValueAndSMGState.of(valueRead, this);
        }
        Value unknownValue = this.getNewSymbolicValueForType(readType);
        return ValueAndSMGState.of(unknownValue, this.copyAndReplaceMemoryModel(this.getMemoryModel().copyAndPutValue(unknownValue, readSMGValue)));
    }

    public SMGValueAndSMGState readSMGValue(SMGObject pObject, BigInteger pFieldOffset, BigInteger pSizeofInBits) {
        SMGValueAndSPC valueAndNewSPC = this.memoryModel.readValue(pObject, pFieldOffset, pSizeofInBits);
        SMGState newState = this.copyAndReplaceMemoryModel(valueAndNewSPC.getSPC());
        SMGValue readSMGValue = valueAndNewSPC.getSMGValue();
        if (newState.memoryModel.getValueFromSMGValue(readSMGValue).isEmpty()) {
            Value unknownValue = this.getNewSymbolicValueForType(null);
            return SMGValueAndSMGState.of(this.copyAndReplaceMemoryModel(newState.getMemoryModel().copyAndPutValue(unknownValue, readSMGValue)), readSMGValue);
        }
        return SMGValueAndSMGState.of(newState, readSMGValue);
    }

    private boolean doesRequireUnionFloatConversion(Value valueRead, CType readType) {
        if (!valueRead.isNumericValue()) {
            return false;
        }
        if (readType instanceof CSimpleType) {
            return this.isFloatingPointType(valueRead) != this.isFloatingPointType(readType);
        }
        return false;
    }

    private boolean isFloatingPointType(CType pType) {
        if (pType instanceof CSimpleType) {
            return ((CSimpleType)pType).getType().isFloatingPointType();
        }
        return false;
    }

    private boolean isFloatingPointType(Value value) {
        if (!value.isNumericValue()) {
            return false;
        }
        Number num = value.asNumericValue().getNumber();
        return num instanceof Float || num instanceof Double || num == NumericValue.NegativeNaN.VALUE;
    }

    private Value castValueForUnionFloatConversion(Value readValue, CType expectedType) {
        if (readValue.isNumericValue()) {
            if (this.isFloatingPointType(readValue)) {
                return this.extractFloatingPointValueAsIntegralValue(readValue);
            }
            if (this.isFloatingPointType(expectedType.getCanonicalType()) && !this.isFloatingPointType(readValue)) {
                return this.extractIntegralValueAsFloatingPointValue(expectedType.getCanonicalType(), readValue);
            }
            return readValue;
        }
        return Value.UnknownValue.getInstance();
    }

    private Value extractFloatingPointValueAsIntegralValue(Value readValue) {
        Number numberValue = readValue.asNumericValue().getNumber();
        if (numberValue instanceof Float) {
            float floatValue = numberValue.floatValue();
            int intBits = Float.floatToIntBits(floatValue);
            return new NumericValue(BigInteger.valueOf(intBits));
        }
        if (numberValue instanceof Double) {
            double doubleValue = numberValue.doubleValue();
            long longBits = Double.doubleToLongBits(doubleValue);
            return new NumericValue(BigInteger.valueOf(longBits));
        }
        return Value.UnknownValue.getInstance();
    }

    private Value extractIntegralValueAsFloatingPointValue(CType pReadType, Value readValue) {
        if (pReadType instanceof CSimpleType) {
            CBasicType basicReadType = ((CSimpleType)pReadType.getCanonicalType()).getType();
            NumericValue numericValue = readValue.asNumericValue();
            if (basicReadType.equals((Object)CBasicType.FLOAT)) {
                int bits = numericValue.bigInteger().intValue();
                float floatValue = Float.intBitsToFloat(bits);
                return new NumericValue(Float.valueOf(floatValue));
            }
            if (basicReadType.equals((Object)CBasicType.DOUBLE)) {
                long bits = numericValue.bigInteger().longValue();
                double doubleValue = Double.longBitsToDouble(bits);
                return new NumericValue(doubleValue);
            }
        }
        return Value.UnknownValue.getInstance();
    }

    public List<SMGState> free(Value addressToFree, CFunctionCallExpression pFunctionCall, CFAEdge cfaEdge) throws SMG2Exception {
        Value sanitizedAddressToFree = addressToFree;
        BigInteger baseOffset = BigInteger.ZERO;
        if (addressToFree instanceof AddressExpression) {
            AddressExpression addressExpr = (AddressExpression)addressToFree;
            sanitizedAddressToFree = addressExpr.getMemoryAddress();
            if (!addressExpr.getOffset().isNumericValue()) {
                return ImmutableList.of((Object)this);
            }
            baseOffset = addressExpr.getOffset().asNumericValue().bigInteger();
        }
        if (sanitizedAddressToFree.isNumericValue() && sanitizedAddressToFree.asNumericValue().bigInteger().compareTo(BigInteger.ZERO) == 0) {
            this.logger.log(Level.FINE, new Object[]{pFunctionCall.getFileLocation(), ":", "The argument of a free invocation:", cfaEdge.getRawStatement(), "is 0"});
            return ImmutableList.of((Object)this);
        }
        ImmutableList.Builder returnBuilder = ImmutableList.builder();
        for (SMGStateAndOptionalSMGObjectAndOffset maybeRegion : this.dereferencePointer(sanitizedAddressToFree)) {
            if (!maybeRegion.hasSMGObjectAndOffset()) {
                this.logger.log(Level.FINE, new Object[]{"Free on expression ", pFunctionCall.getParameterExpressions().get(0).toASTString(), " is invalid, because the target of the address could not be calculated."});
                returnBuilder.add((Object)maybeRegion.getSMGState().withInvalidFree("Invalid free of unallocated object is found.", addressToFree));
                continue;
            }
            SMGState currentState = maybeRegion.getSMGState();
            SMGObject regionToFree = maybeRegion.getSMGObject();
            BigInteger offsetInBits = baseOffset.add(maybeRegion.getOffsetForObject());
            if (regionToFree.isZero()) {
                this.logger.log(Level.FINE, new Object[]{pFunctionCall.getFileLocation(), ":", "The argument of a free invocation:", cfaEdge.getRawStatement(), "is 0"});
                returnBuilder.add((Object)currentState);
                continue;
            }
            if (!this.memoryModel.isHeapObject(regionToFree) && !this.memoryModel.isObjectExternallyAllocated(regionToFree)) {
                returnBuilder.add((Object)currentState.withInvalidFree("Invalid free of unallocated object is found.", addressToFree));
                continue;
            }
            if (!this.memoryModel.isObjectValid(regionToFree)) {
                returnBuilder.add((Object)currentState.withInvalidFree("Free has been used on this memory before.", addressToFree));
                continue;
            }
            if (offsetInBits.compareTo(BigInteger.ZERO) != 0 && !currentState.memoryModel.isObjectExternallyAllocated(regionToFree)) {
                returnBuilder.add((Object)currentState.withInvalidFree("Invalid free as a pointer was used that was not returned by malloc, calloc or realloc.", addressToFree));
                continue;
            }
            SymbolicProgramConfiguration newSPC = currentState.memoryModel.invalidateSMGObject(regionToFree);
            returnBuilder.add((Object)currentState.copyAndReplaceMemoryModel(newSPC));
        }
        return returnBuilder.build();
    }

    protected SMGState writeValue(SMGObject object, BigInteger writeOffsetInBits, BigInteger sizeInBits, Value valueToWrite, CType type) {
        if (object.isZero()) {
            return this.withInvalidWriteToZeroObject(object);
        }
        if (valueToWrite instanceof AddressExpression) {
            ValueAndSMGState valueToWriteAndState = this.transformAddressExpression(valueToWrite);
            valueToWrite = valueToWriteAndState.getValue();
            SMGState sMGState = valueToWriteAndState.getState();
        }
        if (valueToWrite.isUnknown()) {
            valueToWrite = this.getNewSymbolicValueForType(type);
        }
        Preconditions.checkArgument((!(valueToWrite instanceof AddressExpression) ? 1 : 0) != 0);
        SMGValueAndSMGState valueAndState = this.copyAndAddValue(valueToWrite);
        SMGValue smgValue = valueAndState.getSMGValue();
        SMGState currentState = valueAndState.getSMGState();
        return currentState.writeValue(object, writeOffsetInBits, sizeInBits, smgValue);
    }

    public SMGState writeValue(SMGObject object, BigInteger writeOffsetInBits, BigInteger sizeInBits, SMGValue valueToWrite) {
        Preconditions.checkArgument((boolean)this.memoryModel.isObjectValid(object));
        return this.copyAndReplaceMemoryModel(this.memoryModel.writeValue(object, writeOffsetInBits, sizeInBits, valueToWrite));
    }

    public SMGState writeToReturn(BigInteger sizeInBits, Value valueToWrite, CType returnValueType) {
        SMGObject returnObject = this.getMemoryModel().getReturnObjectForCurrentStackFrame().orElseThrow();
        if (valueToWrite.isUnknown()) {
            valueToWrite = this.getNewSymbolicValueForType(returnValueType);
        }
        if (returnObject.getOffset().compareTo(BigInteger.ZERO) > 0 || returnObject.getSize().compareTo(sizeInBits) < 0) {
            return this.withOutOfRangeWrite(returnObject, BigInteger.ZERO, sizeInBits, valueToWrite);
        }
        return this.writeValue(returnObject, BigInteger.ZERO, sizeInBits, valueToWrite, returnValueType);
    }

    private SMGState writeToReturn(Value valueToWrite) {
        SMGObject returnObject = this.memoryModel.getReturnObjectForCurrentStackFrame().orElseThrow();
        return this.writeValue(returnObject, BigInteger.ZERO, returnObject.getSize(), valueToWrite, null);
    }

    public SMGState writeValueTo(SMGObject object, BigInteger writeOffsetInBits, BigInteger sizeInBits, Value valueToWrite, CType valueType) throws SMG2Exception {
        if (object.isZero()) {
            return this.withInvalidWriteToZeroObject(object);
        }
        if (!this.memoryModel.isObjectValid(object)) {
            return this.withInvalidWrite(object);
        }
        if (valueToWrite.isUnknown()) {
            valueToWrite = this.getNewSymbolicValueForType(valueType);
        }
        if (object.getOffset().compareTo(writeOffsetInBits) > 0 || object.getSize().compareTo(sizeInBits.add(writeOffsetInBits)) < 0) {
            return this.withOutOfRangeWrite(object, writeOffsetInBits, sizeInBits, valueToWrite);
        }
        return this.writeValue(object, writeOffsetInBits, sizeInBits, valueToWrite, valueType);
    }

    public List<SMGState> writeValueTo(Value addressToMemory, BigInteger writeOffsetInBits, BigInteger sizeInBits, Value valueToWrite, CType valueType) throws SMG2Exception {
        ImmutableList.Builder returnBuilder = ImmutableList.builder();
        for (SMGStateAndOptionalSMGObjectAndOffset maybeRegion : this.dereferencePointer(addressToMemory)) {
            if (!maybeRegion.hasSMGObjectAndOffset()) {
                returnBuilder.add((Object)maybeRegion.getSMGState());
                continue;
            }
            SMGState currentState = maybeRegion.getSMGState();
            SMGObject memoryRegion = maybeRegion.getSMGObject();
            if (!currentState.memoryModel.isObjectValid(memoryRegion)) {
                returnBuilder.add((Object)currentState);
                continue;
            }
            Preconditions.checkArgument((maybeRegion.getOffsetForObject().compareTo(BigInteger.ZERO) == 0 ? 1 : 0) != 0);
            returnBuilder.add((Object)currentState.writeValueTo(memoryRegion, writeOffsetInBits, sizeInBits, valueToWrite, valueType));
        }
        return returnBuilder.build();
    }

    public List<SMGState> writeToZero(Value addressToMemory, CType type) throws SMG2Exception {
        ImmutableList.Builder returnBuilder = ImmutableList.builder();
        for (SMGStateAndOptionalSMGObjectAndOffset maybeRegion : this.dereferencePointer(addressToMemory)) {
            if (!maybeRegion.hasSMGObjectAndOffset()) {
                returnBuilder.add((Object)maybeRegion.getSMGState());
                continue;
            }
            SMGState currentState = maybeRegion.getSMGState();
            SMGObject memoryRegion = maybeRegion.getSMGObject();
            Preconditions.checkArgument((maybeRegion.getOffsetForObject().compareTo(BigInteger.ZERO) == 0 ? 1 : 0) != 0);
            returnBuilder.add((Object)currentState.writeValue(memoryRegion, maybeRegion.getOffsetForObject(), memoryRegion.getSize(), new NumericValue(0), type));
        }
        return returnBuilder.build();
    }

    public SMGState copySMGObjectContentToSMGObject(SMGObject sourceObject, BigInteger sourceStartOffset, SMGObject targetObject, BigInteger targetStartOffset, BigInteger copySizeInBits) {
        SMGState currentState = this;
        BigInteger maxReadOffsetPlusSize = sourceStartOffset.add(copySizeInBits);
        Set<SMGHasValueEdge> sourceContents = this.memoryModel.getSmg().getEdges(sourceObject);
        for (SMGHasValueEdge edge : sourceContents) {
            BigInteger edgeOffsetInBits = edge.getOffset();
            BigInteger edgeSizeInBits = edge.getSizeInBits();
            if (sourceStartOffset.compareTo(edgeOffsetInBits) > 0 || edgeOffsetInBits.add(edgeSizeInBits).compareTo(maxReadOffsetPlusSize) > 0) continue;
            BigInteger finalWriteOffsetInBits = edgeOffsetInBits.subtract(sourceStartOffset).add(targetStartOffset);
            SMGValue value = edge.hasValue();
            currentState = currentState.writeValue(targetObject, finalWriteOffsetInBits, edgeSizeInBits, value);
        }
        return currentState;
    }

    public SMGState writeToStackOrGlobalVariable(String variableName, BigInteger writeOffsetInBits, BigInteger writeSizeInBits, Value valueToWrite, CType valueType) throws SMG2Exception {
        Optional<SMGObject> maybeVariableMemory = this.getMemoryModel().getObjectForVisibleVariable(variableName);
        if (maybeVariableMemory.isEmpty()) {
            return this.withWriteToUnknownVariable(variableName);
        }
        SMGObject variableMemory = maybeVariableMemory.orElseThrow();
        if (variableMemory.getOffset().compareTo(writeOffsetInBits) > 0 || variableMemory.getSize().compareTo(writeSizeInBits.add(writeOffsetInBits)) < 0) {
            throw new SMG2Exception(this.withOutOfRangeWrite(variableMemory, writeOffsetInBits, writeSizeInBits, valueToWrite));
        }
        return this.writeValue(variableMemory, writeOffsetInBits, writeSizeInBits, valueToWrite, valueType);
    }

    private SMGState writeToAnyStackOrGlobalVariable(String variableName, BigInteger writeOffsetInBits, BigInteger writeSizeInBits, Value valueToWrite, @Nullable CType valueType) {
        Optional<SMGObject> maybeVariableMemory = this.getMemoryModel().getObjectForVariable(variableName);
        SMGObject variableMemory = maybeVariableMemory.orElseThrow();
        return this.writeValue(variableMemory, writeOffsetInBits, writeSizeInBits, valueToWrite, valueType);
    }

    ValueAndSMGState transformAddressExpression(Value value) {
        if (value instanceof AddressExpression) {
            ValueAndSMGState valueToWriteAndState = this.searchOrCreateAddressForAddressExpr(value);
            Value valueToWrite = valueToWriteAndState.getValue();
            SMGState currentState = valueToWriteAndState.getState();
            if (valueToWrite instanceof AddressExpression) {
                Preconditions.checkArgument((((AddressExpression)valueToWrite).getOffset().asNumericValue().bigInteger().compareTo(BigInteger.ZERO) == 0 ? 1 : 0) != 0);
                valueToWrite = ((AddressExpression)valueToWrite).getMemoryAddress();
                return ValueAndSMGState.of(valueToWrite, currentState);
            }
            return ValueAndSMGState.of(valueToWrite, currentState);
        }
        return ValueAndSMGState.of(value, this);
    }

    public SMGState writeToStackOrGlobalVariableToZero(String variableName, CType type) throws SMG2Exception {
        Optional<SMGObject> maybeVariableMemory = this.getMemoryModel().getObjectForVisibleVariable(variableName);
        if (maybeVariableMemory.isEmpty()) {
            throw new SMG2Exception(this.withWriteToUnknownVariable(variableName));
        }
        SMGObject variableMemory = maybeVariableMemory.orElseThrow();
        return this.writeValue(variableMemory, variableMemory.getOffset(), variableMemory.getSize(), new NumericValue(0), type);
    }

    public SMGState createAndAddPointer(Value addressValue, SMGObject target, BigInteger offsetInBits) {
        return this.copyAndReplaceMemoryModel(this.memoryModel.copyAndAddPointerFromAddressToRegion(addressValue, target, offsetInBits));
    }

    public ValueAndSMGState createAndAddPointerWithNestingLevel(SMGObject target, BigInteger offsetInBits, int nestingLevel) {
        Optional<SMGValue> maybeAddressValue = this.getMemoryModel().getAddressValueForPointsToTargetWithNestingLevel(target, offsetInBits, nestingLevel);
        if (maybeAddressValue.isPresent()) {
            Optional<Value> valueForSMGValue = this.getMemoryModel().getValueFromSMGValue(maybeAddressValue.orElseThrow());
            if (maybeAddressValue.orElseThrow().getNestingLevel() != nestingLevel) {
                Preconditions.checkArgument((maybeAddressValue.orElseThrow().getNestingLevel() == nestingLevel ? 1 : 0) != 0);
            }
            return ValueAndSMGState.of(valueForSMGValue.orElseThrow(), this);
        }
        SymbolicIdentifier newAddressValue = SymbolicValueFactory.getInstance().newIdentifier(null);
        return ValueAndSMGState.of(newAddressValue, this.copyAndReplaceMemoryModel(this.memoryModel.copyAndAddPointerFromAddressToRegionWithNestingLevel(newAddressValue, target, offsetInBits, nestingLevel)));
    }

    public SMGState setExternallyAllocatedFlag(String variableName) {
        return this.copyAndReplaceMemoryModel(this.memoryModel.copyAndAddExternalObject(this.getMemoryModel().getObjectForVisibleVariable(variableName).orElseThrow()));
    }

    private Value getNewSymbolicValueForType(CType valueType) {
        SymbolicValueFactory factory = SymbolicValueFactory.getInstance();
        return factory.asConstant(factory.newIdentifier(null), valueType);
    }

    public Optional<SMGObject> getObjectForFunction(CFunctionDeclaration pDeclaration) {
        String functionQualifiedSMGName = this.getUniqueFunctionName(pDeclaration);
        return this.memoryModel.getObjectForVisibleVariable(functionQualifiedSMGName);
    }

    public SMGState copyAndAddFunctionVariable(CFunctionDeclaration pDeclaration) {
        String functionQualifiedSMGName = this.getUniqueFunctionName(pDeclaration);
        return this.copyAndAddGlobalVariable(0, functionQualifiedSMGName, (CType)pDeclaration.getType());
    }

    public String getUniqueFunctionName(CFunctionDeclaration pDeclaration) {
        StringBuilder functionName = new StringBuilder(pDeclaration.getQualifiedName());
        for (CParameterDeclaration parameterDcl : pDeclaration.getParameters()) {
            functionName.append("_");
            functionName.append(CharMatcher.anyOf((CharSequence)"* ").replaceFrom((CharSequence)parameterDcl.toASTString(), (CharSequence)"_"));
        }
        return "__" + functionName;
    }

    public String getUniqueFunctionBasedNameForVarArgs(CFunctionDeclaration pDeclaration) {
        return this.getUniqueFunctionName(pDeclaration) + "_varArgs";
    }

    @Override
    public Set<MemoryLocation> getTrackedMemoryLocations() {
        return this.memoryModel.getMemoryLocationsAndValuesForSPCWithoutHeap().keySet();
    }

    public Set<Value> getTrackedHeapValues() {
        ImmutableSet.Builder trackedHeapValues = ImmutableSet.builder();
        PersistentMap<SMGObject, PersistentSet<SMGHasValueEdge>> valuesOfObj = this.memoryModel.getSmg().getSMGObjectsWithSMGHasValueEdges();
        for (SMGObject heapObj : this.memoryModel.getHeapObjects()) {
            if (!this.memoryModel.isObjectValid(heapObj) || !valuesOfObj.containsKey((Object)heapObj)) continue;
            for (SMGHasValueEdge hve : (PersistentSet)valuesOfObj.get((Object)heapObj)) {
                Value value = this.memoryModel.getValueFromSMGValue(hve.hasValue()).orElseThrow();
                if (!value.isExplicitlyKnown()) continue;
                trackedHeapValues.add((Object)value);
            }
        }
        return trackedHeapValues.build();
    }

    @Override
    public int getSize() {
        return this.memoryModel.getNumberOfVariables();
    }

    public SMGInterpolant createInterpolant() {
        PersistentStack<CFunctionDeclarationAndOptionalValue> funDecls = this.memoryModel.getFunctionDeclarationsFromStackFrames();
        Iterator<CFunctionDeclarationAndOptionalValue> funDeclsIter = funDecls.iterator();
        Preconditions.checkArgument((boolean)funDeclsIter.hasNext());
        return new SMGInterpolant(this.options, this.machineModel, this.logger, this.memoryModel.getMemoryLocationsAndValuesForSPCWithoutHeap(), this.memoryModel.getSizeObMemoryForSPCWithoutHeap(), (Map<String, CType>)this.memoryModel.getVariableTypeMap(), funDecls, funDeclsIter.next().getCFunctionDeclaration(), this.getTrackedHeapValues(), this.memoryModel);
    }

    @Override
    @Deprecated
    public void remember(MemoryLocation pLocation, SMGInformation pForgottenInformation) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public SMGInformation forget(MemoryLocation pLocation) {
        throw new UnsupportedOperationException();
    }

    public SMGState enforceHeapValuePrecision(Set<Value> valuesToRetain) {
        SMG currentSMG = this.memoryModel.getSmg();
        SMGState currentState = this;
        for (SMGObject heapObject : this.memoryModel.getHeapObjects()) {
            if (!this.memoryModel.isObjectValid(heapObject)) continue;
            FluentIterable<SMGHasValueEdge> retainIterable = this.memoryModel.getSmg().getHasValueEdgesByPredicate(heapObject, (Predicate<SMGHasValueEdge>)((Predicate)hv -> currentSMG.isPointer(hv.hasValue()) || this.memoryModel.getValueFromSMGValue(hv.hasValue()).isEmpty() || !this.memoryModel.getValueFromSMGValue(hv.hasValue()).orElseThrow().isExplicitlyKnown() || valuesToRetain.contains(this.memoryModel.getValueFromSMGValue(hv.hasValue()).orElseThrow())));
            currentState = currentState.copyAndReplaceMemoryModel(currentState.getMemoryModel().copyAndReplaceHVEdgesAt(heapObject, PersistentSet.copyOf(retainIterable)));
        }
        return currentState;
    }

    public SMGState removeHeapValue(Value valueToRemove) {
        SMG currentSMG = this.memoryModel.getSmg();
        SMGState currentState = this;
        for (SMGObject heapObject : this.memoryModel.getHeapObjects()) {
            if (!this.memoryModel.isObjectValid(heapObject)) continue;
            FluentIterable<SMGHasValueEdge> retainIterable = this.memoryModel.getSmg().getHasValueEdgesByPredicate(heapObject, (Predicate<SMGHasValueEdge>)((Predicate)hv -> currentSMG.isPointer(hv.hasValue()) || this.memoryModel.getValueFromSMGValue(hv.hasValue()).isEmpty() || !this.memoryModel.getValueFromSMGValue(hv.hasValue()).orElseThrow().isExplicitlyKnown() || !valueToRemove.equals(this.memoryModel.getValueFromSMGValue(hv.hasValue()).orElseThrow())));
            currentState = currentState.copyAndReplaceMemoryModel(currentState.getMemoryModel().copyAndReplaceHVEdgesAt(heapObject, PersistentSet.copyOf(retainIterable)));
        }
        return currentState;
    }

    public SMGState copyAndRemember(SMGInformation pForgottenInformation) {
        SMGState currentState = this;
        for (Map.Entry<SMGObject, Set<SMGHasValueEdge>> entry : pForgottenInformation.getHeapValuesPerObjectMap().entrySet()) {
            SMGObject object = entry.getKey();
            for (SMGHasValueEdge edgeToInsert : entry.getValue()) {
                currentState = currentState.copyAndReplaceMemoryModel(currentState.memoryModel.replaceValueAtWithAndCopy(object, edgeToInsert.getOffset(), edgeToInsert.getSizeInBits(), edgeToInsert));
            }
        }
        return currentState;
    }

    @Override
    public ImmutableForgetfulState.StateAndInfo<SMGState, SMGInformation> copyAndForget(MemoryLocation pLocation) {
        String qualifiedName = pLocation.getQualifiedName();
        BigInteger offsetInBits = BigInteger.valueOf(pLocation.getOffset());
        SMGObject memory = qualifiedName.contains("::__retval__") ? this.getReturnObjectForMemoryLocation(pLocation) : this.getMemoryModel().getObjectForVariable(qualifiedName).orElseThrow();
        Optional<SMGHasValueEdge> maybeEdgeToRemove = this.memoryModel.getSmg().getHasValueEdgeByPredicate(memory, (Predicate<SMGHasValueEdge>)((Predicate)o -> o.getOffset().compareTo(offsetInBits) == 0));
        if (maybeEdgeToRemove.isEmpty()) {
            return new ImmutableForgetfulState.StateAndInfo<SMGState, SMGInformation>(this, new SMGInformation((PersistentMap<MemoryLocation, ValueAndValueSize>)PathCopyingPersistentTreeMap.of(), this.getMemoryModel().getSizeObMemoryForSPCWithoutHeap(), this.memoryModel.getVariableTypeMap(), this.memoryModel.getFunctionDeclarationsFromStackFrames()));
        }
        SMGHasValueEdge edgeToRemove = maybeEdgeToRemove.orElseThrow();
        Value removedValue = this.memoryModel.getValueFromSMGValue(edgeToRemove.hasValue()).orElseThrow();
        SymbolicProgramConfiguration newSPC = this.memoryModel.copyAndRemoveHasValueEdges(memory, (Collection<SMGHasValueEdge>)ImmutableList.of((Object)edgeToRemove));
        SMGState newState = this.copyAndReplaceMemoryModel(newSPC);
        return new ImmutableForgetfulState.StateAndInfo<SMGState, SMGInformation>(newState, new SMGInformation((PersistentMap<MemoryLocation, ValueAndValueSize>)PathCopyingPersistentTreeMap.of().putAndCopy((Object)pLocation, (Object)ValueAndValueSize.of(removedValue, edgeToRemove.getSizeInBits())), this.getMemoryModel().getSizeObMemoryForSPCWithoutHeap(), this.memoryModel.getVariableTypeMap(), this.memoryModel.getFunctionDeclarationsFromStackFrames()));
    }

    private SMGObject getReturnObjectForMemoryLocation(MemoryLocation memLoc) {
        String funcName = memLoc.getFunctionName();
        for (StackFrame stack : this.memoryModel.getStackFrames()) {
            if (!stack.getFunctionDefinition().getQualifiedName().equals(funcName)) continue;
            return stack.getReturnObject().orElseThrow();
        }
        return null;
    }

    public SMGState copyAndRemember(MemoryLocation pLocation, SMGInformation pForgottenInformation) {
        SMGState newState;
        ValueAndValueSize valueAndSize = (ValueAndValueSize)pForgottenInformation.getAssignments().get((Object)pLocation);
        try {
            newState = this.assignNonHeapConstant(pLocation, valueAndSize, pForgottenInformation.getSizeInformationForVariablesMap(), (Map<String, CType>)pForgottenInformation.getTypeOfVariablesMap());
        }
        catch (SMG2Exception e) {
            throw new RuntimeException(e);
        }
        return newState;
    }

    public int getNumberOfGlobalVariables() {
        return this.memoryModel.getGlobalVariableToSmgObjectMap().size();
    }

    public boolean hasStackFrameForFunctionDef(CFunctionDeclaration edgeToCheck) {
        for (StackFrame frame : this.memoryModel.getStackFrames()) {
            if (frame.getFunctionDefinition() != edgeToCheck) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!this.errorInfo.isEmpty()) {
            builder.append("Latest error found: " + this.errorInfo.get(this.errorInfo.size() - 1));
        }
        for (Map.Entry memLoc : this.memoryModel.getMemoryLocationsAndValuesForSPCWithoutHeap().entrySet()) {
            CType readType = this.memoryModel.getTypeOfVariable((MemoryLocation)memLoc.getKey());
            Value valueRead = ((ValueAndValueSize)memLoc.getValue()).getValue();
            if (readType != null && this.doesRequireUnionFloatConversion(valueRead, readType)) {
                valueRead = this.castValueForUnionFloatConversion(valueRead, readType);
            }
            if (this.memoryModel.isPointer(valueRead)) {
                builder.append(memLoc.getKey() + ":  pointer: " + valueRead);
                builder.append("\n");
                continue;
            }
            builder.append(memLoc.getKey() + ": " + valueRead);
            builder.append("\n");
        }
        return builder.toString();
    }

    public SMGState abstractIntoDLL(SMGObject root, BigInteger nfo, BigInteger pfo, Set<SMGObject> alreadyVisited) throws SMG2Exception {
        SMGDoublyLinkedListSegment newDLL;
        int newMinLength;
        Optional<SMGObject> maybeNext = this.getValidNextSLL(root, nfo);
        if (maybeNext.isEmpty() || maybeNext.orElseThrow().equals(root) || alreadyVisited.contains(maybeNext.orElseThrow())) {
            return this;
        }
        SMGObject nextObj = maybeNext.orElseThrow();
        if (!this.checkEqualValuesForTwoStatesWithExemptions(root, nextObj, (ImmutableList<BigInteger>)ImmutableList.of((Object)nfo, (Object)pfo), this, this, (Set<Value>)ImmutableSet.of())) {
            return this.abstractIntoDLL(nextObj, nfo, pfo, (Set<SMGObject>)ImmutableSet.builder().addAll(alreadyVisited).add((Object)root).build());
        }
        int incrementAmount = 1;
        if (root.isSLL()) {
            return this;
        }
        if (root instanceof SMGDoublyLinkedListSegment) {
            SMGDoublyLinkedListSegment oldDLL = (SMGDoublyLinkedListSegment)root;
            newMinLength = ((SMGDoublyLinkedListSegment)root).getMinLength();
            if (nextObj instanceof SMGSinglyLinkedListSegment) {
                newMinLength += ((SMGSinglyLinkedListSegment)nextObj).getMinLength();
                incrementAmount = ((SMGSinglyLinkedListSegment)nextObj).getMinLength();
            } else {
                ++newMinLength;
            }
            newDLL = new SMGDoublyLinkedListSegment(oldDLL.getNestingLevel(), oldDLL.getSize(), oldDLL.getOffset(), oldDLL.getHeadOffset(), oldDLL.getNextOffset(), oldDLL.getPrevOffset(), newMinLength);
        } else {
            BigInteger headOffset = nfo.compareTo(root.getOffset()) == 0 || pfo.compareTo(root.getOffset()) == 0 ? (nfo.compareTo(root.getOffset().add(this.memoryModel.getSizeOfPointer())) == 0 || pfo.compareTo(root.getOffset().add(this.memoryModel.getSizeOfPointer())) == 0 ? root.getOffset().add(this.memoryModel.getSizeOfPointer()).add(this.memoryModel.getSizeOfPointer()) : root.getOffset().add(this.memoryModel.getSizeOfPointer())) : BigInteger.ZERO;
            newMinLength = 1;
            if (nextObj instanceof SMGSinglyLinkedListSegment) {
                newMinLength += ((SMGSinglyLinkedListSegment)nextObj).getMinLength();
                incrementAmount = ((SMGSinglyLinkedListSegment)nextObj).getMinLength();
            } else {
                ++newMinLength;
            }
            newDLL = new SMGDoublyLinkedListSegment(root.getNestingLevel(), root.getSize(), root.getOffset(), headOffset, nfo, pfo, newMinLength);
        }
        SMGState currentState = this.copyAndAddObjectToHeap(newDLL);
        currentState = currentState.copyAllValuesFromObjToObj(nextObj, newDLL);
        SMGValueAndSMGState prevPointer = currentState.readSMGValue(root, pfo, this.memoryModel.getSizeOfPointer());
        currentState = prevPointer.getSMGState().writeValue(newDLL, pfo, this.memoryModel.getSizeOfPointer(), prevPointer.getSMGValue());
        currentState = currentState.copyAndReplaceMemoryModel(currentState.memoryModel.replaceAllPointersTowardsWith(nextObj, (SMGObject)newDLL));
        currentState = currentState.copyAndReplaceMemoryModel(currentState.memoryModel.replaceAllPointersTowardsWithAndIncrementNestingLevel(root, newDLL, incrementAmount));
        currentState = currentState.copyAndReplaceMemoryModel(currentState.memoryModel.copyAndRemoveObjectFromHeap(nextObj));
        currentState = currentState.copyAndReplaceMemoryModel(currentState.memoryModel.copyAndRemoveObjectFromHeap(root));
        return currentState.abstractIntoDLL(newDLL, nfo, pfo, (Set<SMGObject>)ImmutableSet.builder().addAll(alreadyVisited).add((Object)newDLL).build());
    }

    public SMGState abstractIntoSLL(SMGObject root, BigInteger nfo, Set<SMGObject> alreadyVisited) throws SMG2Exception {
        SMGSinglyLinkedListSegment newSLL;
        Optional<SMGObject> maybeNext = this.getValidNextSLL(root, nfo);
        if (maybeNext.isEmpty() || maybeNext.orElseThrow().equals(root) || alreadyVisited.contains(maybeNext.orElseThrow())) {
            return this;
        }
        SMGObject nextObj = maybeNext.orElseThrow();
        if (!this.checkEqualValuesForTwoStatesWithExemptions(root, nextObj, (ImmutableList<BigInteger>)ImmutableList.of((Object)nfo), this, this, (Set<Value>)ImmutableSet.of())) {
            return this.abstractIntoSLL(nextObj, nfo, (Set<SMGObject>)ImmutableSet.builder().addAll(alreadyVisited).add((Object)root).build());
        }
        int incrementAmount = 1;
        if (root instanceof SMGDoublyLinkedListSegment) {
            return this;
        }
        if (root instanceof SMGSinglyLinkedListSegment) {
            SMGSinglyLinkedListSegment oldSLL = (SMGSinglyLinkedListSegment)root;
            int newMinLength = oldSLL.getMinLength();
            if (nextObj instanceof SMGSinglyLinkedListSegment) {
                newMinLength += ((SMGSinglyLinkedListSegment)nextObj).getMinLength();
                incrementAmount = ((SMGSinglyLinkedListSegment)nextObj).getMinLength();
            } else {
                ++newMinLength;
            }
            newSLL = new SMGSinglyLinkedListSegment(oldSLL.getNestingLevel(), oldSLL.getSize(), oldSLL.getOffset(), oldSLL.getHeadOffset(), nfo, newMinLength);
        } else {
            int newMinLength = 1;
            if (nextObj instanceof SMGSinglyLinkedListSegment) {
                newMinLength += ((SMGSinglyLinkedListSegment)nextObj).getMinLength();
                incrementAmount = ((SMGSinglyLinkedListSegment)nextObj).getMinLength();
            } else {
                ++newMinLength;
            }
            BigInteger headOffset = nfo.compareTo(root.getOffset()) == 0 ? nfo.add(this.memoryModel.getSizeOfPointer()) : BigInteger.ZERO;
            newSLL = new SMGSinglyLinkedListSegment(root.getNestingLevel(), root.getSize(), root.getOffset(), headOffset, nfo, newMinLength);
        }
        SMGState currentState = this.copyAndAddObjectToHeap(newSLL);
        currentState = currentState.copyAllValuesFromObjToObj(nextObj, newSLL);
        currentState = currentState.copyAndReplaceMemoryModel(currentState.memoryModel.replaceAllPointersTowardsWith(nextObj, (SMGObject)newSLL));
        currentState = currentState.copyAndReplaceMemoryModel(currentState.memoryModel.replaceAllPointersTowardsWithAndIncrementNestingLevel(root, newSLL, incrementAmount));
        currentState = currentState.copyAndReplaceMemoryModel(currentState.memoryModel.copyAndRemoveObjectFromHeap(nextObj));
        currentState = currentState.copyAndReplaceMemoryModel(currentState.memoryModel.copyAndRemoveObjectFromHeap(root));
        return currentState.abstractIntoSLL(newSLL, nfo, (Set<SMGObject>)ImmutableSet.builder().addAll(alreadyVisited).add((Object)newSLL).build());
    }

    private Optional<SMGObject> getValidNextSLL(SMGObject root, BigInteger nfo) {
        SMGState currentState = this;
        SMGValueAndSMGState valueAndState = currentState.readSMGValue(root, nfo, this.memoryModel.getSizeOfPointer());
        SMGValue value = valueAndState.getSMGValue();
        if (!this.memoryModel.getSmg().isPointer(value)) {
            return Optional.empty();
        }
        SMGObject nextObject = this.memoryModel.getSmg().getPTEdge(value).orElseThrow().pointsTo();
        if (!this.memoryModel.getSmg().isValid(nextObject) || root.getSize().compareTo(nextObject.getSize()) != 0) {
            return Optional.empty();
        }
        return Optional.of(nextObject);
    }

    public SMGState invalidateVariable(MemoryLocation variable) {
        Set<SMGObject> otherPresentObjects;
        Optional<SMGObject> maybeVariableObject;
        if (this.isLocalOrGlobalVariablePresent(variable) && (maybeVariableObject = this.memoryModel.getObjectForVisibleVariable(variable.getQualifiedName())).isPresent() && !(otherPresentObjects = this.memoryModel.getObjectsValidInOtherStackFrames()).contains(maybeVariableObject.orElseThrow())) {
            return this.copyAndReplaceMemoryModel(this.memoryModel.invalidateSMGObject(maybeVariableObject.orElseThrow()));
        }
        return this;
    }

    public List<SMGStateAndOptionalSMGObjectAndOffset> dereferencePointer(Value pointer) throws SMG2Exception {
        if (!this.memoryModel.isPointer(pointer)) {
            return ImmutableList.of((Object)SMGStateAndOptionalSMGObjectAndOffset.of(this));
        }
        SMGState currentState = this;
        SMGValue smgValueAddress = this.memoryModel.getSMGValueFromValue(pointer).orElseThrow();
        SMGPointsToEdge ptEdge = this.memoryModel.getSmg().getPTEdge(smgValueAddress).orElseThrow();
        if (ptEdge.pointsTo() instanceof SMGSinglyLinkedListSegment) {
            return this.materializeLinkedList(smgValueAddress, ptEdge, currentState);
        }
        Preconditions.checkArgument((!(ptEdge.pointsTo() instanceof SMGSinglyLinkedListSegment) ? 1 : 0) != 0);
        return ImmutableList.of((Object)SMGStateAndOptionalSMGObjectAndOffset.of(ptEdge.pointsTo(), ptEdge.getOffset(), currentState));
    }

    private List<SMGStateAndOptionalSMGObjectAndOffset> materializeLinkedList(SMGValue initialPointerValue, SMGPointsToEdge ptEdge, SMGState pState) throws SMG2Exception {
        SMGState currentState = pState;
        if (ptEdge.pointsTo() instanceof SMGSinglyLinkedListSegment) {
            List<SMGValueAndSMGState> newPointersValueAndStates = currentState.materializeReturnPointerValueAndCopy(initialPointerValue);
            if (newPointersValueAndStates.size() == 2) {
                Preconditions.checkArgument((((SMGSinglyLinkedListSegment)ptEdge.pointsTo()).getMinLength() == 0 ? 1 : 0) != 0);
                ImmutableList.Builder returnBuilder = ImmutableList.builder();
                for (SMGValueAndSMGState newPointerValueAndState : newPointersValueAndStates) {
                    currentState = newPointerValueAndState.getSMGState();
                    Optional<SMGPointsToEdge> maybePtEdge = currentState.memoryModel.getSmg().getPTEdge(newPointerValueAndState.getSMGValue());
                    if (maybePtEdge.isEmpty()) {
                        returnBuilder.add((Object)SMGStateAndOptionalSMGObjectAndOffset.of(currentState));
                        continue;
                    }
                    ptEdge = maybePtEdge.orElseThrow();
                    Preconditions.checkArgument((!(ptEdge.pointsTo() instanceof SMGSinglyLinkedListSegment) ? 1 : 0) != 0);
                    returnBuilder.add((Object)SMGStateAndOptionalSMGObjectAndOffset.of(ptEdge.pointsTo(), ptEdge.getOffset(), currentState));
                }
                return returnBuilder.build();
            }
            if (newPointersValueAndStates.size() != 1) {
                throw new SMG2Exception("Critical error: Unexpected return from list materialization.");
            }
            SMGValueAndSMGState newPointerValueAndState = newPointersValueAndStates.get(0);
            currentState = newPointerValueAndState.getSMGState();
            Optional<SMGPointsToEdge> maybePtEdge = currentState.memoryModel.getSmg().getPTEdge(newPointerValueAndState.getSMGValue());
            if (maybePtEdge.isEmpty()) {
                return ImmutableList.of((Object)SMGStateAndOptionalSMGObjectAndOffset.of(currentState));
            }
            ptEdge = maybePtEdge.orElseThrow();
        }
        Preconditions.checkArgument((!(ptEdge.pointsTo() instanceof SMGSinglyLinkedListSegment) ? 1 : 0) != 0);
        return ImmutableList.of((Object)SMGStateAndOptionalSMGObjectAndOffset.of(ptEdge.pointsTo(), ptEdge.getOffset(), currentState));
    }

    public Optional<SMGStateAndOptionalSMGObjectAndOffset> dereferencePointerWithoutMaterilization(Value pointer) {
        if (!this.memoryModel.isPointer(pointer)) {
            return Optional.empty();
        }
        SMGState currentState = this;
        SMGValue smgValueAddress = this.memoryModel.getSMGValueFromValue(pointer).orElseThrow();
        SMGPointsToEdge ptEdge = this.memoryModel.getSmg().getPTEdge(smgValueAddress).orElseThrow();
        return Optional.of(SMGStateAndOptionalSMGObjectAndOffset.of(ptEdge.pointsTo(), ptEdge.getOffset(), currentState));
    }

    public List<SMGValueAndSMGState> materializeReturnPointerValueAndCopy(SMGValue valueToPointerToAbstractObject) throws SMG2Exception {
        SMGPointsToEdge ptEdge = this.memoryModel.getSmg().getPTEdge(valueToPointerToAbstractObject).orElseThrow();
        SMGState currentState = this;
        List<SMGValueAndSMGState> materializationAndState = null;
        while (ptEdge.pointsTo() instanceof SMGSinglyLinkedListSegment) {
            SMGObject obj = ptEdge.pointsTo();
            if (obj.isZero() || !currentState.memoryModel.isObjectValid(obj)) {
                throw new SMG2Exception("");
            }
            Preconditions.checkArgument((boolean)(obj instanceof SMGSinglyLinkedListSegment));
            materializationAndState = currentState.materializer.handleMaterilisation(valueToPointerToAbstractObject, obj, currentState);
            if (materializationAndState.size() == 1) {
                currentState = materializationAndState.get(0).getSMGState();
                ptEdge = currentState.memoryModel.getSmg().getPTEdge(valueToPointerToAbstractObject).orElseThrow();
                continue;
            }
            Preconditions.checkArgument((materializationAndState.size() == 2 ? 1 : 0) != 0);
            if (currentState.memoryModel.getSmg().isPointer(materializationAndState.get(0).getSMGValue())) {
                Preconditions.checkArgument((!(materializationAndState.get((int)0).getSMGState().memoryModel.getSmg().getPTEdge(materializationAndState.get(0).getSMGValue()).orElseThrow().pointsTo() instanceof SMGSinglyLinkedListSegment) ? 1 : 0) != 0);
            }
            Preconditions.checkArgument((!(materializationAndState.get((int)1).getSMGState().memoryModel.getSmg().getPTEdge(materializationAndState.get(1).getSMGValue()).orElseThrow().pointsTo() instanceof SMGSinglyLinkedListSegment) ? 1 : 0) != 0);
            break;
        }
        Preconditions.checkNotNull(materializationAndState);
        return materializationAndState;
    }

    public boolean hasPointer(MemoryLocation memLoc) {
        SMGObject memory;
        String qualifiedName = memLoc.getQualifiedName();
        BigInteger offsetInBits = BigInteger.valueOf(memLoc.getOffset());
        if (qualifiedName.contains("::__retval__")) {
            memory = this.getReturnObjectForMemoryLocation(memLoc);
        } else {
            Optional<SMGObject> maybeMemory = this.getMemoryModel().getObjectForVariable(qualifiedName);
            if (maybeMemory.isEmpty()) {
                return false;
            }
            memory = maybeMemory.orElseThrow();
        }
        Optional<SMGHasValueEdge> maybeEdge = this.memoryModel.getSmg().getHasValueEdgeByPredicate(memory, (Predicate<SMGHasValueEdge>)((Predicate)o -> o.getOffset().compareTo(offsetInBits) == 0));
        if (maybeEdge.isEmpty()) {
            return false;
        }
        return this.memoryModel.getSmg().isPointer(maybeEdge.orElseThrow().hasValue());
    }
}

