/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithAssumptions;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsState;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerState;
import org.sosy_lab.cpachecker.cpa.rtt.RTTState;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPAAddressVisitor;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPAAssigningValueVisitor;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPABuiltins;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPAExportOptions;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPAStatistics;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPAValueVisitor;
import org.sosy_lab.cpachecker.cpa.smg2.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg2.SMGPrecision;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMG2Exception;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGObjectAndOffset;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGStateAndOptionalSMGObjectAndOffset;
import org.sosy_lab.cpachecker.cpa.smg2.util.value.SMGCPAExpressionEvaluator;
import org.sosy_lab.cpachecker.cpa.smg2.util.value.ValueAndSMGState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.ConstraintsStrengthenOperator;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.AddressExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicIdentifier;
import org.sosy_lab.cpachecker.cpa.value.type.BooleanValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class SMGTransferRelation
extends ForwardingTransferRelation<Collection<SMGState>, SMGState, SMGPrecision> {
    private final SMGOptions options;
    private final SMGCPAExportOptions exportSMGOptions;
    private final MachineModel machineModel;
    private final LogManagerWithoutDuplicates logger;
    private final SMGCPAExpressionEvaluator evaluator;
    private final ConstraintsStrengthenOperator constraintsStrengthenOperator;
    private final Collection<String> booleanVariables;
    private final @Nullable SMGCPAStatistics stats;

    public SMGTransferRelation(LogManager pLogger, SMGOptions pOptions, SMGCPAExportOptions pExportSMGOptions, CFA pCfa, ConstraintsStrengthenOperator pConstraintsStrengthenOperator, SMGCPAStatistics pStats) {
        this.logger = new LogManagerWithoutDuplicates(pLogger);
        this.options = pOptions;
        this.exportSMGOptions = pExportSMGOptions;
        this.machineModel = pCfa.getMachineModel();
        this.booleanVariables = pCfa.getVarClassification().isPresent() ? pCfa.getVarClassification().orElseThrow().getIntBoolVars() : ImmutableSet.of();
        this.evaluator = new SMGCPAExpressionEvaluator(this.machineModel, this.logger, this.exportSMGOptions, this.options);
        this.constraintsStrengthenOperator = pConstraintsStrengthenOperator;
        this.stats = pStats;
    }

    protected SMGTransferRelation(LogManager pLogger, SMGOptions pOptions, SMGCPAExportOptions pExportSMGOptions, MachineModel pMachineModel, Collection<String> pBooleanVariables, @Nullable ConstraintsStrengthenOperator pConstraintsStrengthenOperator) {
        this.logger = new LogManagerWithoutDuplicates(pLogger);
        this.options = pOptions;
        this.exportSMGOptions = pExportSMGOptions;
        this.machineModel = pMachineModel;
        this.evaluator = new SMGCPAExpressionEvaluator(this.machineModel, this.logger, this.exportSMGOptions, this.options);
        this.booleanVariables = pBooleanVariables;
        this.constraintsStrengthenOperator = pConstraintsStrengthenOperator;
        this.stats = null;
    }

    @Override
    protected Collection<SMGState> postProcessing(Collection<SMGState> pSuccessors, CFAEdge edge) {
        if (pSuccessors == null) {
            return super.postProcessing(pSuccessors, edge);
        }
        ImmutableList.Builder successors = ImmutableList.builder();
        for (SMGState s : pSuccessors) {
            for (CSimpleDeclaration variable : edge.getSuccessor().getOutOfScopeVariables()) {
                s = s.invalidateVariable(MemoryLocation.forDeclaration(variable));
            }
            successors.add((Object)s);
        }
        return successors.build();
    }

    @Override
    protected Set<SMGState> handleBlankEdge(BlankEdge cfaEdge) throws CPATransferException {
        if (cfaEdge.getSuccessor() instanceof FunctionExitNode && this.isEntryFunction(cfaEdge)) {
            return this.handleReturnEntryFunction(Collections.singleton((SMGState)this.state));
        }
        return Collections.singleton((SMGState)this.state);
    }

    private Set<SMGState> handleReturnEntryFunction(Collection<SMGState> pSuccessors) {
        return (Set)pSuccessors.stream().map(pState -> {
            if (this.options.isHandleNonFreedMemoryInMainAsMemLeak()) {
                pState = pState.dropStackFrame();
            }
            return pState.copyAndPruneUnreachable();
        }).collect(ImmutableSet.toImmutableSet());
    }

    private boolean isEntryFunction(CFAEdge pCfaEdge) {
        return pCfaEdge.getSuccessor().getNumLeavingEdges() == 0;
    }

    @Override
    protected Collection<SMGState> handleReturnStatementEdge(CReturnStatementEdge returnEdge) throws CPATransferException {
        ImmutableList.Builder successorsBuilder = ImmutableList.builder();
        if (((SMGState)this.state).getMemoryModel().hasReturnObjectForCurrentStackFrame()) {
            CExpression returnExp = returnEdge.getExpression().orElse(CIntegerLiteralExpression.ZERO);
            CType retType = SMGCPAExpressionEvaluator.getCanonicalType(returnExp);
            Optional<CAssignment> returnAssignment = returnEdge.asAssignment();
            if (returnAssignment.isPresent()) {
                retType = returnAssignment.orElseThrow().getLeftHandSide().getExpressionType();
            }
            SMGCPAValueVisitor vv = new SMGCPAValueVisitor(this.evaluator, (SMGState)this.state, returnEdge, this.logger);
            for (ValueAndSMGState returnValueAndState : vv.evaluate(returnExp, retType)) {
                BigInteger sizeInBits = this.evaluator.getBitSizeof((SMGState)this.state, retType);
                ValueAndSMGState valueAndStateToWrite = this.evaluator.unpackAddressExpression(returnValueAndState.getValue(), returnValueAndState.getState());
                successorsBuilder.add((Object)valueAndStateToWrite.getState().writeToReturn(sizeInBits, valueAndStateToWrite.getValue(), returnExp.getExpressionType()));
            }
        } else {
            successorsBuilder.add((Object)((SMGState)this.state));
        }
        if (this.isEntryFunction(returnEdge)) {
            return this.handleReturnEntryFunction((Collection<SMGState>)successorsBuilder.build());
        }
        return successorsBuilder.build();
    }

    @Override
    protected Collection<SMGState> handleFunctionReturnEdge(CFunctionReturnEdge functionReturnEdge, CFunctionSummaryEdge fnkCall, CFunctionCall summaryExpr, String callerFunctionName) throws CPATransferException {
        ImmutableList successors = this.handleFunctionReturn(functionReturnEdge);
        if (this.options.isCheckForMemLeaksAtEveryFrameDrop()) {
            ImmutableList.Builder prunedSuccessors = ImmutableList.builder();
            for (SMGState successor : successors) {
                prunedSuccessors.add((Object)successor.copyAndPruneUnreachable());
            }
            successors = prunedSuccessors.build();
        }
        return successors;
    }

    private List<SMGState> handleFunctionReturn(CFunctionReturnEdge functionReturnEdge) throws CPATransferException {
        CFunctionSummaryEdge summaryEdge = functionReturnEdge.getSummaryEdge();
        CFunctionCall summaryExpr = summaryEdge.getExpression();
        Preconditions.checkArgument((((SMGState)this.state).getMemoryModel().getStackFrames().peek().getFunctionDefinition() == summaryEdge.getFunctionEntry().getFunctionDefinition() ? 1 : 0) != 0);
        if (summaryExpr instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement funcCallExpr = (CFunctionCallAssignmentStatement)summaryExpr;
            CLeftHandSide leftValue = funcCallExpr.getLeftHandSide();
            CType rightValueType = SMGCPAExpressionEvaluator.getCanonicalType(funcCallExpr.getRightHandSide());
            BigInteger sizeInBits = this.evaluator.getBitSizeof((SMGState)this.state, rightValueType);
            Optional<SMGObject> returnObject = ((SMGState)this.state).getMemoryModel().getReturnObjectForCurrentStackFrame();
            Preconditions.checkArgument((boolean)returnObject.isPresent());
            ImmutableList.Builder stateBuilder = ImmutableList.builder();
            for (ValueAndSMGState readValueAndState : ((SMGState)this.state).readValue(returnObject.orElseThrow(), BigInteger.ZERO, sizeInBits, rightValueType)) {
                SMGState currentState = readValueAndState.getState().dropStackFrame();
                for (SMGState stateWithNewVar : this.createVariableOnTheSpot(leftValue, currentState)) {
                    stateBuilder.addAll(this.evaluator.writeValueToExpression(summaryEdge, leftValue, readValueAndState.getValue(), stateWithNewVar));
                }
            }
            return stateBuilder.build();
        }
        return ImmutableList.of((Object)((SMGState)this.state).dropStackFrame());
    }

    private List<SMGState> createVariableOnTheSpot(CExpression leftHandSideExpr, SMGState pState) throws CPATransferException {
        if (leftHandSideExpr instanceof CIdExpression) {
            CIdExpression leftCIdExpr = (CIdExpression)leftHandSideExpr;
            CSimpleDeclaration decl = leftCIdExpr.getDeclaration();
            String varName = decl.getQualifiedName();
            SMGState currentState = pState;
            if (pState.isLocalOrGlobalVariablePresent(varName) && !pState.isLocalOrGlobalVariableValid(varName).orElse(true).booleanValue()) {
                currentState = pState.copyAndRemoveStackVariable(varName);
            }
            if (!currentState.isLocalOrGlobalVariablePresent(varName)) {
                if (decl instanceof CVariableDeclaration) {
                    return this.evaluator.handleVariableDeclarationWithoutInizializer(currentState, (CVariableDeclaration)decl);
                }
                if (decl instanceof CParameterDeclaration) {
                    return this.evaluator.handleVariableDeclarationWithoutInizializer(currentState, ((CParameterDeclaration)decl).asVariableDeclaration());
                }
            }
            return ImmutableList.of((Object)pState);
        }
        if (leftHandSideExpr instanceof CArraySubscriptExpression) {
            CExpression arrayExpr = ((CArraySubscriptExpression)leftHandSideExpr).getArrayExpression();
            return this.createVariableOnTheSpot(arrayExpr, pState);
        }
        if (leftHandSideExpr instanceof CFieldReference) {
            CExpression fieldOwn = ((CFieldReference)leftHandSideExpr).getFieldOwner();
            return this.createVariableOnTheSpot(fieldOwn, pState);
        }
        if (leftHandSideExpr instanceof CPointerExpression) {
            CExpression operand = ((CPointerExpression)leftHandSideExpr).getOperand();
            return this.createVariableOnTheSpot(operand, pState);
        }
        if (leftHandSideExpr instanceof CUnaryExpression) {
            CExpression operand = ((CUnaryExpression)leftHandSideExpr).getOperand();
            return this.createVariableOnTheSpot(operand, pState);
        }
        if (leftHandSideExpr instanceof CCastExpression) {
            CExpression operand = ((CCastExpression)leftHandSideExpr).getOperand();
            return this.createVariableOnTheSpot(operand, pState);
        }
        return ImmutableList.of((Object)pState);
    }

    @Override
    protected Collection<SMGState> handleFunctionCallEdge(CFunctionCallEdge callEdge, List<CExpression> arguments, List<CParameterDeclaration> paramDecl, String calledFunctionName) throws CPATransferException {
        if (!callEdge.getSuccessor().getFunctionDefinition().getType().takesVarArgs() && paramDecl.size() != arguments.size()) {
            throw new SMG2Exception("The number of arguments expected and given do not match for function call " + callEdge.getDescription() + ".");
        }
        return ImmutableList.of((Object)this.handleFunctionCall((SMGState)this.state, callEdge, arguments, paramDecl));
    }

    private SMGState handleFunctionCall(SMGState initialState, CFunctionCallEdge callEdge, List<CExpression> arguments, List<CParameterDeclaration> paramDecl) throws CPATransferException {
        SMGState currentState = initialState;
        ImmutableList.Builder readValuesInOrderBuilder = ImmutableList.builder();
        BigInteger overallVarArgsSizeInBits = BigInteger.ZERO;
        CType parameterType = null;
        for (int i = 0; i < arguments.size(); ++i) {
            ValueAndSMGState valueAndState;
            CExpression cParamExp = arguments.get(i);
            CType argumentType = SMGCPAExpressionEvaluator.getCanonicalType(cParamExp.getExpressionType());
            if (paramDecl.size() > i) {
                parameterType = SMGCPAExpressionEvaluator.getCanonicalType(paramDecl.get(i));
            } else {
                overallVarArgsSizeInBits = overallVarArgsSizeInBits.add(this.evaluator.getBitSizeof(currentState, cParamExp));
            }
            if (parameterType instanceof CPointerType && argumentType instanceof CArrayType) {
                List<ValueAndSMGState> addressesAndStates = this.evaluator.createAddress(cParamExp, currentState, (CFAEdge)callEdge);
                Preconditions.checkArgument((addressesAndStates.size() == 1 ? 1 : 0) != 0);
                valueAndState = addressesAndStates.get(0);
            } else {
                List<ValueAndSMGState> valuesAndStates = cParamExp.accept(new SMGCPAValueVisitor(this.evaluator, currentState, callEdge, this.logger));
                Preconditions.checkArgument((valuesAndStates.size() == 1 ? 1 : 0) != 0);
                valueAndState = valuesAndStates.get(0);
            }
            readValuesInOrderBuilder.add((Object)valueAndState.getValue());
            currentState = valueAndState.getState();
        }
        ImmutableList readValuesInOrder = readValuesInOrderBuilder.build();
        CFunctionDeclaration funcDecl = callEdge.getSuccessor().getFunctionDefinition();
        if (funcDecl.getType().takesVarArgs()) {
            ImmutableList.Builder varArgsBuilder = ImmutableList.builder();
            for (int i = paramDecl.size(); i < arguments.size(); ++i) {
                varArgsBuilder.add((Object)((Value)readValuesInOrder.get(i)));
            }
            currentState = currentState.copyAndAddStackFrame(funcDecl, (ImmutableList<Value>)varArgsBuilder.build());
        } else {
            currentState = currentState.copyAndAddStackFrame(funcDecl);
        }
        for (int i = 0; i < paramDecl.size(); ++i) {
            Value paramValue = (Value)readValuesInOrder.get(i);
            CType valueType = SMGCPAExpressionEvaluator.getCanonicalType(arguments.get(i));
            String varName = paramDecl.get(i).getQualifiedName();
            CType cParamType = SMGCPAExpressionEvaluator.getCanonicalType(paramDecl.get(i));
            currentState = this.handleFunctionParameterAssignments(varName, valueType, paramValue, cParamType, callEdge, currentState);
        }
        return currentState;
    }

    private SMGState handleFunctionParameterAssignments(String varName, CType valueType, Value paramValue, CType cParamType, CFAEdge callEdge, SMGState pCurrentState) throws SMG2Exception {
        SMGState currentState = pCurrentState;
        if (valueType instanceof CArrayType && cParamType instanceof CArrayType) {
            List<SMGStateAndOptionalSMGObjectAndOffset> knownMemoriesAndStates = currentState.dereferencePointer(paramValue);
            Preconditions.checkArgument((knownMemoriesAndStates.size() == 1 ? 1 : 0) != 0);
            SMGStateAndOptionalSMGObjectAndOffset knownMemoryAndState = knownMemoriesAndStates.get(0);
            currentState = knownMemoryAndState.getSMGState();
            if (!knownMemoryAndState.hasSMGObjectAndOffset()) {
                throw new SMG2Exception("Could not associate a local array in a new function.");
            }
            if (knownMemoryAndState.getOffsetForObject().compareTo(BigInteger.ZERO) != 0) {
                throw new SMG2Exception("Could not associate a local array in a new function.");
            }
            SMGObject knownMemory = knownMemoryAndState.getSMGObject();
            return currentState.copyAndAddLocalVariable(knownMemory, varName, cParamType);
        }
        if (SMGCPAExpressionEvaluator.isStructOrUnionType(valueType) && SMGCPAExpressionEvaluator.isStructOrUnionType(cParamType)) {
            if (paramValue.isUnknown()) {
                return currentState;
            }
            Preconditions.checkArgument((boolean)(paramValue instanceof SymbolicIdentifier));
            Preconditions.checkArgument((boolean)((SymbolicIdentifier)paramValue).getRepresentedLocation().isPresent());
            MemoryLocation locationInPrevStackFrame = ((SymbolicIdentifier)paramValue).getRepresentedLocation().orElseThrow();
            Optional<SMGObject> maybeKnownMemory = currentState.getMemoryModel().getObjectForVisibleVariableFromPreviousStackframe(locationInPrevStackFrame.getQualifiedName());
            if (maybeKnownMemory.isEmpty()) {
                throw new SMG2Exception("Usage of unknown variable in function " + callEdge);
            }
            BigInteger offsetSource = BigInteger.valueOf(locationInPrevStackFrame.getOffset());
            currentState = currentState.copyAndAddLocalVariable(maybeKnownMemory.orElseThrow().getSize().subtract(offsetSource), varName, cParamType);
            SMGObject newMemory = currentState.getMemoryModel().getObjectForVisibleVariable(varName).orElseThrow();
            return currentState.copySMGObjectContentToSMGObject(maybeKnownMemory.orElseThrow(), offsetSource, newMemory, BigInteger.ZERO, newMemory.getSize().subtract(offsetSource));
        }
        return this.evaluator.writeValueToNewVariableBasedOnTypes(paramValue, cParamType, valueType, varName, currentState);
    }

    @Override
    protected void setInfo(AbstractState abstractState, Precision abstractPrecision, CFAEdge cfaEdge) {
        super.setInfo(abstractState, abstractPrecision, cfaEdge);
        if (this.stats != null) {
            this.stats.incrementIterations();
        }
    }

    @Override
    protected Collection<SMGState> handleAssumption(CAssumeEdge cfaEdge, CExpression expression, boolean truthAssumption) throws CPATransferException, InterruptedException {
        return this.handleAssumption(expression, cfaEdge, truthAssumption);
    }

    private @Nullable Collection<SMGState> handleAssumption(AExpression expression, CFAEdge cfaEdge, boolean truthValue) throws CPATransferException {
        if (this.stats != null) {
            this.stats.incrementAssumptions();
        }
        Pair<AExpression, Boolean> simplifiedExpression = SMGTransferRelation.simplifyAssumption(expression, truthValue);
        CExpression cExpression = (CExpression)simplifiedExpression.getFirst();
        truthValue = simplifiedExpression.getSecond();
        ImmutableList.Builder resultStateBuilder = ImmutableList.builder();
        SMGCPAValueVisitor vv = new SMGCPAValueVisitor(this.evaluator, (SMGState)this.state, cfaEdge, this.logger);
        for (ValueAndSMGState valueAndState : vv.evaluate(cExpression, SMGCPAExpressionEvaluator.getCanonicalType((CExpression)expression))) {
            Value value = valueAndState.getValue();
            SMGState currentState = valueAndState.getState();
            if (value.isExplicitlyKnown() && this.stats != null) {
                this.stats.incrementDeterministicAssumptions();
            }
            if (!value.isExplicitlyKnown()) {
                SMGCPAAssigningValueVisitor avv = new SMGCPAAssigningValueVisitor(this.evaluator, (SMGState)this.state, cfaEdge, this.logger, truthValue, this.options, this.booleanVariables);
                for (ValueAndSMGState newValueAndUpdatedState : cExpression.accept(avv)) {
                    SMGState updatedState = newValueAndUpdatedState.getState();
                    resultStateBuilder.add((Object)updatedState);
                }
                continue;
            }
            if (this.representsBoolean(value, truthValue)) {
                resultStateBuilder.add((Object)currentState);
                continue;
            }
            return null;
        }
        return resultStateBuilder.build();
    }

    private boolean representsBoolean(Value value, boolean bool) {
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).isTrue() == bool;
        }
        if (value.isNumericValue()) {
            if (bool) {
                return value.asNumericValue().longValue() == 1L;
            }
            return value.asNumericValue().longValue() == 0L;
        }
        return false;
    }

    @Override
    protected Collection<SMGState> handleStatementEdge(CStatementEdge pCfaEdge, CStatement cStmt) throws CPATransferException {
        if (cStmt instanceof CAssignment) {
            CAssignment cAssignment = (CAssignment)cStmt;
            CLeftHandSide lValue = cAssignment.getLeftHandSide();
            CRightHandSide rValue = cAssignment.getRightHandSide();
            ImmutableList.Builder stateBuilder = ImmutableList.builder();
            for (SMGState currentState : this.createVariableOnTheSpot(lValue, (SMGState)this.state)) {
                stateBuilder.addAll(this.handleAssignment(currentState, pCfaEdge, lValue, rValue));
            }
            return stateBuilder.build();
        }
        if (cStmt instanceof CFunctionCallStatement) {
            CFunctionCallStatement cFCall = (CFunctionCallStatement)cStmt;
            CFunctionCallExpression cFCExpression = cFCall.getFunctionCallExpression();
            CExpression fileNameExpression = cFCExpression.getFunctionNameExpression();
            String calledFunctionName = fileNameExpression.toASTString();
            ImmutableList.Builder resultStatesBuilder = ImmutableList.builder();
            resultStatesBuilder.addAll(this.handleFunctionCallWithoutBody((SMGState)this.state, pCfaEdge, cFCExpression, calledFunctionName));
            return resultStatesBuilder.build();
        }
        return ImmutableList.of((Object)((SMGState)this.state));
    }

    private Collection<SMGState> handleFunctionCallWithoutBody(SMGState pState, CStatementEdge pCfaEdge, CFunctionCallExpression cFCExpression, String calledFunctionName) throws CPATransferException {
        SMGCPABuiltins builtins = this.evaluator.getBuiltinFunctionHandler();
        if (builtins.isABuiltIn(calledFunctionName)) {
            if (builtins.isConfigurableAllocationFunction(calledFunctionName)) {
                ImmutableList.Builder newStatesBuilder = ImmutableList.builder();
                String errorMSG = "Calling " + this.functionName + " and not using the return value results in a memory leak.";
                this.logger.logf(Level.INFO, "Error in %s: %s", new Object[]{errorMSG, pCfaEdge.getFileLocation()});
                List<ValueAndSMGState> uselessValuesAndNewStates = builtins.evaluateConfigurableAllocationFunction(cFCExpression, pState, pCfaEdge);
                for (ValueAndSMGState valueAndState : uselessValuesAndNewStates) {
                    newStatesBuilder.add((Object)valueAndState.getState().withMemoryLeak(errorMSG, (Collection<Object>)ImmutableList.of((Object)valueAndState.getValue())));
                }
                return newStatesBuilder.build();
            }
            if (builtins.isDeallocationFunction(calledFunctionName)) {
                return builtins.evaluateFree(cFCExpression, pState, pCfaEdge);
            }
        } else {
            return builtins.checkAllParametersForValidity(cFCExpression, pState, pCfaEdge);
        }
        List<ValueAndSMGState> uselessValuesAndStates = builtins.handleBuiltinFunctionCall(pCfaEdge, cFCExpression, calledFunctionName, pState);
        return Collections3.transformedImmutableListCopy(uselessValuesAndStates, valAndState -> valAndState.getState());
    }

    @Override
    protected List<SMGState> handleDeclarationEdge(CDeclarationEdge edge, CDeclaration cDecl) throws CPATransferException {
        SMGState currentState = (SMGState)this.state;
        if (cDecl instanceof CFunctionDeclaration) {
            CFunctionDeclaration cFuncDecl = (CFunctionDeclaration)cDecl;
            if (cFuncDecl.getQualifiedName().equals("main") && cFuncDecl.getParameters() != null) {
                for (CParameterDeclaration parameters : cFuncDecl.getParameters()) {
                    CType paramType = SMGCPAExpressionEvaluator.getCanonicalType(parameters.getType());
                    BigInteger paramSizeInBits = this.evaluator.getBitSizeof(currentState, paramType);
                    currentState = currentState.copyAndAddLocalVariable(paramSizeInBits, parameters.getQualifiedName(), paramType);
                }
            }
        } else if (!(cDecl instanceof CComplexTypeDeclaration) && !(cDecl instanceof CTypeDefDeclaration) && cDecl instanceof CVariableDeclaration) {
            try {
                return this.evaluator.handleVariableDeclaration(currentState, (CVariableDeclaration)cDecl, edge);
            }
            catch (UnsupportedOperationException e) {
                throw new UnsupportedCodeException(e.getMessage(), edge);
            }
        }
        return ImmutableList.of((Object)currentState);
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState element, Iterable<AbstractState> elements, CFAEdge cfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        Preconditions.checkArgument((boolean)(element instanceof SMGState));
        ArrayList<SMGState> toStrengthen = new ArrayList<SMGState>();
        ArrayList<SMGState> result = new ArrayList<SMGState>();
        toStrengthen.add((SMGState)element);
        result.add((SMGState)element);
        for (AbstractState ae : elements) {
            if (ae instanceof RTTState) {
                result.clear();
                for (SMGState stateToStrengthen : toStrengthen) {
                    super.setInfo(element, pPrecision, cfaEdge);
                    result.add(stateToStrengthen);
                }
                toStrengthen.clear();
                toStrengthen.addAll(result);
                continue;
            }
            if (ae instanceof AbstractStateWithAssumptions) {
                result.clear();
                for (SMGState stateToStrengthen : toStrengthen) {
                    super.setInfo(element, pPrecision, cfaEdge);
                    AbstractStateWithAssumptions stateWithAssumptions = (AbstractStateWithAssumptions)ae;
                    result.addAll(this.strengthenWithAssumptions(stateWithAssumptions, stateToStrengthen, cfaEdge));
                }
                toStrengthen.clear();
                toStrengthen.addAll(result);
                continue;
            }
            if (ae instanceof ConstraintsState) {
                throw new CPATransferException("ConstraintsCPA not compatible with SMGCPA!.");
            }
            if (!(ae instanceof PointerState)) continue;
            throw new CPATransferException("Don't use the pointer CPA with the SMGCPA!");
        }
        ArrayList<AbstractState> postProcessedResult = new ArrayList<AbstractState>(result.size());
        for (SMGState rawResult : result) {
            if (rawResult == element) {
                postProcessedResult.add(element);
                continue;
            }
            postProcessedResult.addAll(this.postProcessing((Collection<SMGState>)ImmutableList.of((Object)rawResult), cfaEdge));
        }
        super.resetInfo();
        return postProcessedResult;
    }

    private @NonNull Collection<SMGState> strengthenWithAssumptions(AbstractStateWithAssumptions pStateWithAssumptions, SMGState pState, CFAEdge pCfaEdge) throws CPATransferException {
        AExpression assumption;
        Object newStates = ImmutableList.of((Object)pState);
        Iterator<? extends AExpression> iterator = pStateWithAssumptions.getAssumptions().iterator();
        while (iterator.hasNext() && (newStates = this.handleAssumption(assumption = iterator.next(), pCfaEdge, true)) != null) {
            Iterator iterator2 = newStates.iterator();
            while (iterator2.hasNext()) {
                SMGState newState = (SMGState)iterator2.next();
                this.setInfo(newState, this.precision, pCfaEdge);
            }
        }
        return Objects.requireNonNullElseGet(newStates, ImmutableList::of);
    }

    private List<SMGState> handleAssignment(SMGState pState, CFAEdge cfaEdge, CExpression lValue, CRightHandSide rValue) throws CPATransferException {
        CType rightHandSideType = SMGCPAExpressionEvaluator.getCanonicalType(rValue);
        CType leftHandSideType = SMGCPAExpressionEvaluator.getCanonicalType(lValue);
        ImmutableList.Builder returnStateBuilder = ImmutableList.builder();
        SMGState currentState = pState;
        for (SMGStateAndOptionalSMGObjectAndOffset targetAndOffsetAndState : lValue.accept(new SMGCPAAddressVisitor(this.evaluator, currentState, cfaEdge, this.logger))) {
            currentState = targetAndOffsetAndState.getSMGState();
            if (!targetAndOffsetAndState.hasSMGObjectAndOffset()) {
                List<ValueAndSMGState> listOfStates = rValue.accept(new SMGCPAValueVisitor(this.evaluator, currentState, cfaEdge, this.logger));
                returnStateBuilder.addAll((Iterable)Lists.transform(listOfStates, ValueAndSMGState::getState));
                continue;
            }
            SMGObject addressToWriteTo = targetAndOffsetAndState.getSMGObject();
            BigInteger offsetToWriteTo = targetAndOffsetAndState.getOffsetForObject();
            if (leftHandSideType instanceof CPointerType && rightHandSideType instanceof CArrayType) {
                for (ValueAndSMGState addressAndState : this.evaluator.createAddress(rValue, currentState, cfaEdge)) {
                    BigInteger sizeOfTypeLeft = this.evaluator.getBitSizeof(currentState, leftHandSideType);
                    Value addressToAssign = addressAndState.getValue();
                    currentState = addressAndState.getState();
                    returnStateBuilder.add((Object)currentState.writeValueTo(addressToWriteTo, offsetToWriteTo, sizeOfTypeLeft, addressToAssign, leftHandSideType));
                }
                continue;
            }
            SMGCPAValueVisitor vv = new SMGCPAValueVisitor(this.evaluator, currentState, cfaEdge, this.logger);
            for (ValueAndSMGState valueAndState : vv.evaluate(rValue, leftHandSideType)) {
                returnStateBuilder.add((Object)this.handleAssignmentOfValueTo(valueAndState.getValue(), leftHandSideType, addressToWriteTo, offsetToWriteTo, rightHandSideType, valueAndState.getState()));
            }
        }
        return returnStateBuilder.build();
    }

    private SMGState handleAssignmentOfValueTo(Value valueToWrite, CType leftHandSideType, SMGObject addressToWriteTo, BigInteger offsetToWriteTo, CType rightHandSideType, SMGState pCurrentState) throws SMG2Exception {
        SMGState currentState = pCurrentState;
        BigInteger sizeInBits = this.evaluator.getBitSizeof(currentState, leftHandSideType);
        if (valueToWrite instanceof SymbolicIdentifier && ((SymbolicIdentifier)valueToWrite).getRepresentedLocation().isPresent()) {
            Preconditions.checkArgument((boolean)SMGCPAExpressionEvaluator.isStructOrUnionType(rightHandSideType));
            return this.evaluator.copyStructOrArrayFromValueTo(valueToWrite, leftHandSideType, addressToWriteTo, offsetToWriteTo, currentState);
        }
        if (valueToWrite instanceof AddressExpression) {
            if (SMGCPAExpressionEvaluator.isStructOrUnionType(rightHandSideType)) {
                Value properPointer;
                Preconditions.checkArgument((rightHandSideType.equals(leftHandSideType) || rightHandSideType.canBeAssignedFrom(leftHandSideType) ? 1 : 0) != 0);
                AddressExpression addressInValue = (AddressExpression)valueToWrite;
                Value pointerOffset = addressInValue.getOffset();
                if (!pointerOffset.isNumericValue()) {
                    return currentState.writeValueTo(addressToWriteTo, offsetToWriteTo, sizeInBits, (Value)Value.UnknownValue.getInstance(), leftHandSideType);
                }
                BigInteger baseOffsetFromPointer = pointerOffset.asNumericValue().bigInteger();
                if (baseOffsetFromPointer.compareTo(BigInteger.ZERO) == 0) {
                    properPointer = addressInValue.getMemoryAddress();
                } else {
                    List<ValueAndSMGState> newAddressesAndStates = this.evaluator.findOrcreateNewPointer(addressInValue.getMemoryAddress(), addressInValue.getOffset().asNumericValue().bigInteger(), currentState);
                    Preconditions.checkArgument((newAddressesAndStates.size() == 1 ? 1 : 0) != 0);
                    ValueAndSMGState newAddressAndState = newAddressesAndStates.get(0);
                    currentState = newAddressAndState.getState();
                    properPointer = newAddressAndState.getValue();
                }
                Optional<SMGObjectAndOffset> maybeRightHandSideMemoryAndOffset = currentState.getPointsToTarget(properPointer);
                if (maybeRightHandSideMemoryAndOffset.isEmpty()) {
                    return currentState;
                }
                SMGObjectAndOffset rightHandSideMemoryAndOffset = maybeRightHandSideMemoryAndOffset.orElseThrow();
                return currentState.copySMGObjectContentToSMGObject(rightHandSideMemoryAndOffset.getSMGObject(), rightHandSideMemoryAndOffset.getOffsetForObject(), addressToWriteTo, offsetToWriteTo, addressToWriteTo.getSize().subtract(offsetToWriteTo));
            }
            AddressExpression addressInValue = (AddressExpression)valueToWrite;
            if (addressInValue.getOffset().isNumericValue() && addressInValue.getOffset().asNumericValue().longValue() == 0L) {
                valueToWrite = addressInValue.getMemoryAddress();
            } else if (addressInValue.getOffset().isNumericValue()) {
                List<ValueAndSMGState> newAddressesAndStates = this.evaluator.findOrcreateNewPointer(addressInValue.getMemoryAddress(), addressInValue.getOffset().asNumericValue().bigInteger(), currentState);
                Preconditions.checkArgument((newAddressesAndStates.size() == 1 ? 1 : 0) != 0);
                ValueAndSMGState newAddressAndState = newAddressesAndStates.get(0);
                currentState = newAddressAndState.getState();
                valueToWrite = newAddressAndState.getValue();
            } else {
                valueToWrite = Value.UnknownValue.getInstance();
            }
            Preconditions.checkArgument((sizeInBits.compareTo(this.evaluator.getBitSizeof(currentState, leftHandSideType)) == 0 ? 1 : 0) != 0);
            return currentState.writeValueTo(addressToWriteTo, offsetToWriteTo, sizeInBits, valueToWrite, leftHandSideType);
        }
        return currentState.writeValueTo(addressToWriteTo, offsetToWriteTo, sizeInBits, valueToWrite, leftHandSideType);
    }
}

