/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.math.BigInteger;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;

public final class StackFrame {
    public static final String RETVAL_LABEL = "___cpa_temp_result_var_";
    private final PersistentMap<String, SMGObject> stackVariables;
    private final CFunctionDeclaration stackFunction;
    private final Optional<SMGObject> returnValueObject;
    private final Optional<ImmutableList<Value>> variableArguments;

    private StackFrame(CFunctionDeclaration pDeclaration, PersistentMap<String, SMGObject> pVariables, Optional<SMGObject> pReturnValueObject, Optional<ImmutableList<Value>> pVariableArguments) {
        this.stackVariables = (PersistentMap)Preconditions.checkNotNull(pVariables);
        this.returnValueObject = pReturnValueObject;
        this.stackFunction = pDeclaration;
        this.variableArguments = pVariableArguments;
    }

    public StackFrame(CFunctionDeclaration pDeclaration, MachineModel pMachineModel) {
        this.stackVariables = PathCopyingPersistentTreeMap.of();
        this.stackFunction = pDeclaration;
        CType returnType = pDeclaration.getType().getReturnType().getCanonicalType();
        if (returnType instanceof CVoidType) {
            this.returnValueObject = Optional.empty();
        } else {
            BigInteger returnValueSize = pMachineModel.getSizeofInBits(returnType);
            this.returnValueObject = Optional.of(SMGObject.of(0, returnValueSize, BigInteger.ZERO));
        }
        this.variableArguments = Optional.empty();
    }

    public StackFrame(CFunctionDeclaration pDeclaration, MachineModel pMachineModel, @Nullable ImmutableList<Value> pVariableArguments) {
        this.stackVariables = PathCopyingPersistentTreeMap.of();
        this.stackFunction = pDeclaration;
        CType returnType = pDeclaration.getType().getReturnType().getCanonicalType();
        if (returnType instanceof CVoidType) {
            this.returnValueObject = Optional.empty();
        } else {
            BigInteger returnValueSize = pMachineModel.getSizeofInBits(returnType);
            this.returnValueObject = Optional.of(SMGObject.of(0, returnValueSize, BigInteger.ZERO));
        }
        this.variableArguments = Optional.ofNullable(pVariableArguments);
    }

    public StackFrame copyAndAddStackVariable(String pVariableName, SMGObject pObject) {
        Preconditions.checkArgument((!this.stackVariables.containsKey((Object)pVariableName) ? 1 : 0) != 0, (String)"Stack frame for function already contains a variable '%s'", (Object)pVariableName);
        return new StackFrame(this.stackFunction, (PersistentMap<String, SMGObject>)this.stackVariables.putAndCopy((Object)pVariableName, (Object)pObject), this.returnValueObject, this.variableArguments);
    }

    public StackFrame copyAndRemoveVariable(String pName) {
        if (RETVAL_LABEL.equals(pName)) {
            return this;
        }
        return new StackFrame(this.stackFunction, (PersistentMap<String, SMGObject>)this.stackVariables.removeAndCopy((Object)pName), this.returnValueObject, this.variableArguments);
    }

    public CFunctionDeclaration getFunctionDefinition() {
        return this.stackFunction;
    }

    public SMGObject getVariable(String pName) {
        if (pName.equals(RETVAL_LABEL) && this.returnValueObject.isPresent()) {
            return this.returnValueObject.orElseThrow();
        }
        Optional<SMGObject> to_return = Optional.ofNullable((SMGObject)this.stackVariables.get((Object)pName));
        if (to_return.isEmpty()) {
            throw new NoSuchElementException(String.format("No variable with name '%s' in stack frame for function", pName));
        }
        return to_return.orElseThrow();
    }

    public boolean containsVariable(String pName) {
        if (pName.equals(RETVAL_LABEL)) {
            return this.returnValueObject.isPresent();
        }
        return this.stackVariables.containsKey((Object)pName);
    }

    public Map<String, SMGObject> getVariables() {
        return this.stackVariables;
    }

    public FluentIterable<SMGObject> getAllObjects() {
        if (this.returnValueObject.isPresent()) {
            return FluentIterable.concat((Iterable)this.stackVariables.values(), (Iterable)ImmutableSet.of((Object)this.returnValueObject.orElseThrow()));
        }
        return FluentIterable.from((Iterable)this.stackVariables.values());
    }

    public Optional<SMGObject> getReturnObject() {
        return this.returnValueObject;
    }

    public boolean hasVariable(String var) {
        return this.stackVariables.containsKey((Object)var);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : this.stackVariables.entrySet()) {
            builder.append((String)entry.getKey() + " -> " + entry.getValue() + "  ");
        }
        if (this.variableArguments.isPresent()) {
            builder.append("variable arguments:");
            for (Value value : this.variableArguments.orElseThrow()) {
                builder.append(" " + value + "  ");
            }
        }
        if (this.returnValueObject.isPresent()) {
            builder.append(" return object: -> " + this.returnValueObject.orElseThrow() + "  ");
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StackFrame)) {
            return false;
        }
        StackFrame other = (StackFrame)o;
        return Objects.equals(this.stackVariables, other.stackVariables) && Objects.equals(this.stackFunction, other.stackFunction) && Objects.equals(this.returnValueObject, other.returnValueObject) && Objects.equals(this.variableArguments, other.variableArguments);
    }

    public int hashCode() {
        return Objects.hash(this.stackVariables, this.stackFunction, this.returnValueObject, this.variableArguments);
    }

    public boolean hasVariableArguments() {
        return this.variableArguments.isPresent();
    }

    public ImmutableList<Value> getVariableArguments() {
        return this.variableArguments.orElseThrow();
    }

    public StackFrame copyWith(Optional<SMGObject> pReturnOptional, Map<String, SMGObject> pFrameMapping) {
        return new StackFrame(this.stackFunction, (PersistentMap<String, SMGObject>)PathCopyingPersistentTreeMap.copyOf(pFrameMapping), pReturnOptional, this.variableArguments);
    }
}

