/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentSet;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentStack;
import org.sosy_lab.cpachecker.cpa.smg2.StackFrame;
import org.sosy_lab.cpachecker.cpa.smg2.util.CFunctionDeclarationAndOptionalValue;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGAndSMGObjects;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGObjectsAndValues;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGValueAndSPC;
import org.sosy_lab.cpachecker.cpa.smg2.util.SPCAndSMGObjects;
import org.sosy_lab.cpachecker.cpa.smg2.util.ValueAndValueSize;
import org.sosy_lab.cpachecker.cpa.smg2.util.value.ValueWrapper;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.SMGProveNequality;
import org.sosy_lab.cpachecker.util.smg.graph.SMGHasValueEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGPointsToEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGSinglyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.smg.util.SMGandValue;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class SymbolicProgramConfiguration {
    private final SMG smg;
    private final PersistentMap<String, SMGObject> globalVariableMapping;
    private final PersistentStack<StackFrame> stackVariableMapping;
    private final PersistentMap<String, CType> variableToTypeMap;
    private final PersistentSet<SMGObject> heapObjects;
    private final PersistentMap<SMGObject, Boolean> externalObjectAllocation;
    private final ImmutableBiMap<Equivalence.Wrapper<Value>, SMGValue> valueMapping;
    private static final ValueWrapper valueWrapper = new ValueWrapper();

    private SymbolicProgramConfiguration(SMG pSmg, PersistentMap<String, SMGObject> pGlobalVariableMapping, PersistentStack<StackFrame> pStackVariableMapping, PersistentSet<SMGObject> pHeapObjects, PersistentMap<SMGObject, Boolean> pExternalObjectAllocation, ImmutableBiMap<Equivalence.Wrapper<Value>, SMGValue> pValueMapping, PersistentMap<String, CType> pVariableToTypeMap) {
        this.globalVariableMapping = pGlobalVariableMapping;
        this.stackVariableMapping = pStackVariableMapping;
        this.smg = pSmg;
        this.externalObjectAllocation = pExternalObjectAllocation;
        this.heapObjects = pHeapObjects;
        this.valueMapping = pValueMapping;
        this.variableToTypeMap = pVariableToTypeMap;
    }

    public static SymbolicProgramConfiguration of(SMG pSmg, PersistentMap<String, SMGObject> pGlobalVariableMapping, PersistentStack<StackFrame> pStackVariableMapping, PersistentSet<SMGObject> pHeapObjects, PersistentMap<SMGObject, Boolean> pExternalObjectAllocation, ImmutableBiMap<Equivalence.Wrapper<Value>, SMGValue> pValueMapping, PersistentMap<String, CType> pVariableToTypeMap) {
        return new SymbolicProgramConfiguration(pSmg, pGlobalVariableMapping, pStackVariableMapping, pHeapObjects, pExternalObjectAllocation, pValueMapping, pVariableToTypeMap);
    }

    public static SymbolicProgramConfiguration of(BigInteger sizeOfPtr) {
        return new SymbolicProgramConfiguration(new SMG(sizeOfPtr), (PersistentMap<String, SMGObject>)PathCopyingPersistentTreeMap.of(), PersistentStack.of(), PersistentSet.of(SMGObject.nullInstance()), (PersistentMap<SMGObject, Boolean>)PathCopyingPersistentTreeMap.of(), (ImmutableBiMap<Equivalence.Wrapper<Value>, SMGValue>)ImmutableBiMap.of((Object)valueWrapper.wrap(new NumericValue(0)), (Object)SMGValue.zeroValue(), (Object)valueWrapper.wrap(new NumericValue(Float.valueOf(0.0f))), (Object)SMGValue.zeroFloatValue(), (Object)valueWrapper.wrap(new NumericValue(0.0)), (Object)SMGValue.zeroDoubleValue()), (PersistentMap<String, CType>)PathCopyingPersistentTreeMap.of());
    }

    public SymbolicProgramConfiguration copyAndRemoveHasValueEdges(SMGObject memory, Collection<SMGHasValueEdge> edgesToRemove) {
        SMG newSMG = this.smg.copyAndRemoveHVEdges(edgesToRemove, memory);
        return new SymbolicProgramConfiguration(newSMG, this.globalVariableMapping, this.stackVariableMapping, this.heapObjects, this.externalObjectAllocation, this.valueMapping, this.variableToTypeMap);
    }

    public PersistentMap<String, SMGObject> getGlobalVariableToSmgObjectMap() {
        return this.globalVariableMapping;
    }

    public SMG getSmg() {
        return this.smg;
    }

    public BigInteger getSizeOfPointer() {
        return this.smg.getSizeOfPointer();
    }

    public boolean pointsToZeroPlus(Value value) {
        Preconditions.checkNotNull((Object)value);
        return this.smg.pointsToZeroPlus(this.getSMGValueFromValue(value).orElse(null));
    }

    int getNumberOfVariables() {
        int size = this.globalVariableMapping.size();
        for (StackFrame frame : this.stackVariableMapping) {
            size += frame.getVariables().size();
        }
        return size;
    }

    public boolean proveInequality(SMGValue pValue1, SMGValue pValue2) {
        SMGProveNequality nequality = new SMGProveNequality(this.smg);
        return nequality.proveInequality(pValue1, pValue2);
    }

    public SymbolicProgramConfiguration copyAndAddGlobalObject(SMGObject pNewObject, String pVarName, CType type) {
        return SymbolicProgramConfiguration.of(this.smg.copyAndAddObject(pNewObject), (PersistentMap<String, SMGObject>)this.globalVariableMapping.putAndCopy((Object)pVarName, (Object)pNewObject), this.stackVariableMapping, this.heapObjects, this.externalObjectAllocation, this.valueMapping, (PersistentMap<String, CType>)this.variableToTypeMap.putAndCopy((Object)pVarName, (Object)type));
    }

    public PersistentStack<StackFrame> getStackFrames() {
        return this.stackVariableMapping;
    }

    public SymbolicProgramConfiguration copyAndAddStackObject(SMGObject pNewObject, String pVarName, CType type) {
        StackFrame currentFrame = this.stackVariableMapping.peek();
        if (pVarName.contains(":")) {
            String functionName = pVarName.substring(0, pVarName.indexOf(":"));
            Preconditions.checkArgument((boolean)currentFrame.getFunctionDefinition().getQualifiedName().equals(functionName));
        }
        PersistentStack<StackFrame> tmpStack = this.stackVariableMapping.popAndCopy();
        currentFrame = currentFrame.copyAndAddStackVariable(pVarName, pNewObject);
        return SymbolicProgramConfiguration.of(this.smg.copyAndAddObject(pNewObject), this.globalVariableMapping, tmpStack.pushAndCopy(currentFrame), this.heapObjects, this.externalObjectAllocation, this.valueMapping, (PersistentMap<String, CType>)this.variableToTypeMap.putAndCopy((Object)pVarName, (Object)type));
    }

    SymbolicProgramConfiguration copyAndAddStackObjectToSpecificStackFrame(String functionName, SMGObject pNewObject, String pVarName, CType type) {
        PersistentStack<Object> topStack = PersistentStack.of();
        StackFrame currentFrame = this.stackVariableMapping.peek();
        PersistentStack<StackFrame> tmpStack = this.stackVariableMapping.popAndCopy();
        while (!currentFrame.getFunctionDefinition().getQualifiedName().equals(functionName)) {
            topStack = topStack.pushAndCopy(currentFrame);
            currentFrame = tmpStack.peek();
            tmpStack = tmpStack.popAndCopy();
        }
        currentFrame = currentFrame.copyAndAddStackVariable(pVarName, pNewObject);
        tmpStack = tmpStack.pushAndCopy(currentFrame);
        while (topStack.size() > 0) {
            tmpStack = tmpStack.pushAndCopy((StackFrame)topStack.peek());
            topStack = topStack.popAndCopy();
        }
        return SymbolicProgramConfiguration.of(this.smg.copyAndAddObject(pNewObject), this.globalVariableMapping, tmpStack, this.heapObjects, this.externalObjectAllocation, this.valueMapping, (PersistentMap<String, CType>)this.variableToTypeMap.putAndCopy((Object)pVarName, (Object)type));
    }

    public SymbolicProgramConfiguration copyAndAddStackFrame(CFunctionDeclaration pFunctionDefinition, MachineModel model, @Nullable ImmutableList<Value> variableArguments) {
        Optional<SMGObject> returnObj;
        StackFrame newStackFrame = new StackFrame(pFunctionDefinition, model, variableArguments);
        CType returnType = pFunctionDefinition.getType().getReturnType().getCanonicalType();
        if (returnType instanceof CVoidType) {
            returnType = CNumericTypes.INT;
        }
        if ((returnObj = newStackFrame.getReturnObject()).isEmpty()) {
            return SymbolicProgramConfiguration.of(this.smg, this.globalVariableMapping, this.stackVariableMapping.pushAndCopy(newStackFrame), this.heapObjects, this.externalObjectAllocation, this.valueMapping, this.variableToTypeMap);
        }
        return SymbolicProgramConfiguration.of(this.smg.copyAndAddObject(returnObj.orElseThrow()), this.globalVariableMapping, this.stackVariableMapping.pushAndCopy(newStackFrame), this.heapObjects, this.externalObjectAllocation, this.valueMapping, (PersistentMap<String, CType>)this.variableToTypeMap.putAndCopy((Object)(pFunctionDefinition.getQualifiedName() + "::__retval__"), (Object)returnType));
    }

    public SymbolicProgramConfiguration copyAndRemoveGlobalVariable(String pIdentifier) {
        Optional<SMGObject> objToRemove = Optional.ofNullable((SMGObject)this.globalVariableMapping.get((Object)pIdentifier));
        if (objToRemove.isEmpty()) {
            return this;
        }
        PersistentMap newGlobalsMap = this.globalVariableMapping.removeAndCopy((Object)pIdentifier);
        SMG newSmg = this.smg.copyAndInvalidateObject(objToRemove.orElseThrow());
        return SymbolicProgramConfiguration.of(newSmg, (PersistentMap<String, SMGObject>)newGlobalsMap, this.stackVariableMapping, this.heapObjects, this.externalObjectAllocation, this.valueMapping, (PersistentMap<String, CType>)this.variableToTypeMap.removeAndCopy((Object)pIdentifier));
    }

    public SymbolicProgramConfiguration copyAndRemoveStackVariable(String pIdentifier) {
        if (this.stackVariableMapping.isEmpty()) {
            return this;
        }
        StackFrame frame = this.stackVariableMapping.peek();
        if (frame.containsVariable(pIdentifier)) {
            SMGObject objToRemove = frame.getVariable(pIdentifier);
            StackFrame newFrame = frame.copyAndRemoveVariable(pIdentifier);
            PersistentStack<StackFrame> newStack = this.stackVariableMapping.replace((Predicate<StackFrame>)((Predicate)f -> f == frame), newFrame);
            SMG newSmg = this.smg.copyAndInvalidateObject(objToRemove);
            return SymbolicProgramConfiguration.of(newSmg, this.globalVariableMapping, newStack, this.heapObjects, this.externalObjectAllocation, this.valueMapping, (PersistentMap<String, CType>)this.variableToTypeMap.removeAndCopy((Object)pIdentifier));
        }
        return this;
    }

    public SymbolicProgramConfiguration copyAndAddHeapObject(SMGObject pObject) {
        if (this.heapObjects.contains(pObject)) {
            throw new IllegalArgumentException("Heap object already in the SMG: [" + pObject + "]");
        }
        return SymbolicProgramConfiguration.of(this.smg.copyAndAddObject(pObject), this.globalVariableMapping, this.stackVariableMapping, this.heapObjects.addAndCopy(pObject), this.externalObjectAllocation, this.valueMapping, this.variableToTypeMap);
    }

    public SymbolicProgramConfiguration copyAllValuesFromObjToObj(SMGObject source, SMGObject target) {
        return SymbolicProgramConfiguration.of(this.smg.copyHVEdgesFromTo(source, target), this.globalVariableMapping, this.stackVariableMapping, this.heapObjects, this.externalObjectAllocation, this.valueMapping, this.variableToTypeMap);
    }

    public SymbolicProgramConfiguration replaceAllPointersTowardsWith(SMGValue pointerValue, SMGObject newTarget) {
        return SymbolicProgramConfiguration.of(this.smg.replaceAllPointersTowardsWith(pointerValue, newTarget), this.globalVariableMapping, this.stackVariableMapping, this.heapObjects, this.externalObjectAllocation, this.valueMapping, this.variableToTypeMap);
    }

    public boolean isHeapObject(SMGObject pObject) {
        return this.heapObjects.contains(pObject);
    }

    public PersistentSet<SMGObject> getHeapObjects() {
        return this.heapObjects;
    }

    public SymbolicProgramConfiguration copyAndDropStackFrame() {
        StackFrame frame = this.stackVariableMapping.peek();
        PersistentStack<StackFrame> newStack = this.stackVariableMapping.popAndCopy();
        SMG newSmg = this.smg;
        PersistentMap newVariableToTypeMap = this.variableToTypeMap;
        Set<SMGObject> validObjects = this.getObjectsValidInOtherStackFrames();
        for (SMGObject object : frame.getAllObjects()) {
            if (validObjects.contains(object)) continue;
            newSmg = newSmg.copyAndInvalidateObject(object);
        }
        for (String varName : frame.getVariables().keySet()) {
            newVariableToTypeMap = newVariableToTypeMap.removeAndCopy((Object)varName);
        }
        return SymbolicProgramConfiguration.of(newSmg, this.globalVariableMapping, newStack, this.heapObjects, this.externalObjectAllocation, this.valueMapping, (PersistentMap<String, CType>)newVariableToTypeMap);
    }

    protected Set<SMGObject> getObjectsValidInOtherStackFrames() {
        ImmutableSet.Builder validObjectsBuilder = ImmutableSet.builder();
        for (StackFrame otherFrame : this.stackVariableMapping.popAndCopy()) {
            validObjectsBuilder.addAll(otherFrame.getAllObjects());
        }
        return validObjectsBuilder.build();
    }

    public SPCAndSMGObjects copyAndPruneUnreachable() {
        ImmutableSet visibleObjects = FluentIterable.concat((Iterable)this.globalVariableMapping.values(), (Iterable)FluentIterable.from(this.stackVariableMapping).transformAndConcat(stackFrame -> stackFrame.getAllObjects())).toSet();
        SMGObjectsAndValues reachable = this.smg.collectReachableObjectsAndValues((Collection<SMGObject>)visibleObjects);
        HashSet<SMGObject> unreachableObjects = new HashSet(Sets.difference(this.smg.getObjects(), reachable.getObjects()));
        HashSet<SMGValue> unreachableValues = new HashSet(Sets.difference(this.smg.getValues(), reachable.getValues()));
        unreachableObjects = (Set)unreachableObjects.stream().filter(o -> this.isObjectValid((SMGObject)o)).collect(ImmutableSet.toImmutableSet());
        unreachableValues = (Set)unreachableValues.stream().filter(v -> !v.isZero()).collect(ImmutableSet.toImmutableSet());
        SMG newSmg = this.smg.copyAndRemoveObjects(unreachableObjects).copyAndRemoveValues(unreachableValues);
        PersistentSet<SMGObject> newHeapObjects = this.heapObjects;
        for (SMGObject smgObject : unreachableObjects) {
            newHeapObjects = newHeapObjects.removeAndCopy(smgObject);
        }
        return SPCAndSMGObjects.of(SymbolicProgramConfiguration.of(newSmg, this.globalVariableMapping, this.stackVariableMapping, newHeapObjects, this.externalObjectAllocation, this.valueMapping, this.variableToTypeMap), unreachableObjects);
    }

    public SymbolicProgramConfiguration replaceSMGValueNestingLevel(SMGValue value, int newLevel) {
        return SymbolicProgramConfiguration.of(this.smg.replaceSMGValueNestingLevel(value, newLevel), this.globalVariableMapping, this.stackVariableMapping, this.heapObjects, this.externalObjectAllocation, this.valueMapping, this.variableToTypeMap);
    }

    public SymbolicProgramConfiguration copyAndRemoveObjectAndAssociatedSubSMG(SMGObject object) {
        Preconditions.checkArgument((boolean)(object instanceof SMGSinglyLinkedListSegment));
        Preconditions.checkArgument((((SMGSinglyLinkedListSegment)object).getMinLength() == 0 ? 1 : 0) != 0);
        SMGAndSMGObjects newSMGAndToRemoveObjects = this.smg.copyAndRemoveObjectAndSubSMG(object);
        SMG newSMG = newSMGAndToRemoveObjects.getSMG();
        PersistentSet<SMGObject> newHeapObject = this.heapObjects.removeAndCopy(object);
        for (SMGObject toRemove : newSMGAndToRemoveObjects.getSMGObjects()) {
            newHeapObject = newHeapObject.removeAndCopy(toRemove);
        }
        return SymbolicProgramConfiguration.of(newSMG, this.globalVariableMapping, this.stackVariableMapping, newHeapObject, this.externalObjectAllocation, this.valueMapping, this.variableToTypeMap);
    }

    public Optional<SMGObject> getReturnObjectForCurrentStackFrame() {
        return this.stackVariableMapping.peek().getReturnObject();
    }

    public boolean hasReturnObjectForCurrentStackFrame() {
        return this.stackVariableMapping.peek().getReturnObject().isPresent();
    }

    public SymbolicProgramConfiguration copyAndPutValue(Value cValue, SMGValue smgValue) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        return SymbolicProgramConfiguration.of(this.smg, this.globalVariableMapping, this.stackVariableMapping, this.heapObjects, this.externalObjectAllocation, (ImmutableBiMap<Equivalence.Wrapper<Value>, SMGValue>)builder.putAll(this.valueMapping).put((Object)valueWrapper.wrap(cValue), (Object)smgValue).buildOrThrow(), this.variableToTypeMap);
    }

    public SymbolicProgramConfiguration copyAndInvalidateExternalAllocation(SMGObject pObject) {
        return SymbolicProgramConfiguration.of(this.smg, this.globalVariableMapping, this.stackVariableMapping, this.heapObjects, (PersistentMap<SMGObject, Boolean>)this.externalObjectAllocation.putAndCopy((Object)pObject, (Object)false), this.valueMapping, this.variableToTypeMap);
    }

    public Optional<SMGValue> getSMGValueFromValue(Value cValue) {
        return Optional.ofNullable((SMGValue)this.valueMapping.get((Object)valueWrapper.wrap(cValue)));
    }

    public Optional<Value> getValueFromSMGValue(SMGValue smgValue) {
        Equivalence.Wrapper got = (Equivalence.Wrapper)this.valueMapping.inverse().get((Object)smgValue);
        if (got == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((Value)got.get());
    }

    public SymbolicProgramConfiguration copyAndCreateValue(Value cValue) {
        if (this.valueMapping.containsKey((Object)valueWrapper.wrap(cValue))) {
            return this;
        }
        return this.copyAndPutValue(cValue, SMGValue.of());
    }

    public SymbolicProgramConfiguration copyAndAddExternalObject(SMGObject pObject) {
        return SymbolicProgramConfiguration.of(this.smg, this.globalVariableMapping, this.stackVariableMapping, this.heapObjects, (PersistentMap<SMGObject, Boolean>)this.externalObjectAllocation.putAndCopy((Object)pObject, (Object)true), this.valueMapping, this.variableToTypeMap);
    }

    private SymbolicProgramConfiguration copyAndReplaceSMG(SMG pSMG) {
        return SymbolicProgramConfiguration.of(pSMG, this.globalVariableMapping, this.stackVariableMapping, this.heapObjects, this.externalObjectAllocation, this.valueMapping, this.variableToTypeMap);
    }

    public SymbolicProgramConfiguration copyAndAddStackObject(SMGObject newObject) {
        return this.copyAndReplaceSMG(this.getSmg().copyAndAddObject(newObject));
    }

    public Optional<SMGObject> getObjectForVisibleVariable(String pName) {
        StackFrame prevFrame;
        if (this.globalVariableMapping.containsKey((Object)pName)) {
            return Optional.of((SMGObject)this.globalVariableMapping.get((Object)pName));
        }
        if (this.stackVariableMapping.isEmpty()) {
            return Optional.empty();
        }
        StackFrame currentFrame = this.stackVariableMapping.peek();
        int sizeOfVariables = currentFrame.getVariables().size();
        if (currentFrame.hasVariableArguments()) {
            sizeOfVariables += currentFrame.getVariableArguments().size();
        }
        if (sizeOfVariables < currentFrame.getFunctionDefinition().getParameters().size() && this.stackVariableMapping.size() > 1 && (prevFrame = this.stackVariableMapping.popAndCopy().peek()).containsVariable(pName)) {
            return Optional.of(prevFrame.getVariable(pName));
        }
        if (currentFrame.containsVariable(pName)) {
            return Optional.of(currentFrame.getVariable(pName));
        }
        return Optional.empty();
    }

    Optional<SMGObject> getObjectForVariable(String pName) {
        if (this.globalVariableMapping.containsKey((Object)pName)) {
            return Optional.of((SMGObject)this.globalVariableMapping.get((Object)pName));
        }
        for (StackFrame frame : this.stackVariableMapping) {
            if (!frame.containsVariable(pName)) continue;
            return Optional.of(frame.getVariable(pName));
        }
        return Optional.empty();
    }

    public Optional<SMGObject> getObjectForVisibleVariableFromPreviousStackframe(String pName) {
        StackFrame lowerFrame = this.stackVariableMapping.popAndCopy().peek();
        if (lowerFrame.containsVariable(pName)) {
            return Optional.of(lowerFrame.getVariable(pName));
        }
        if (this.globalVariableMapping.containsKey((Object)pName)) {
            return Optional.of((SMGObject)this.globalVariableMapping.get((Object)pName));
        }
        return Optional.empty();
    }

    public boolean isObjectExternallyAllocated(SMGObject pObject) {
        return this.externalObjectAllocation.containsKey((Object)pObject);
    }

    public boolean isObjectValid(SMGObject pObject) {
        return this.smg.isValid(pObject);
    }

    public SMGValueAndSPC readValue(SMGObject pObject, BigInteger pFieldOffset, BigInteger pSizeofInBits) {
        SMGandValue newSMGAndValue = this.smg.readValue(pObject, pFieldOffset, pSizeofInBits);
        return SMGValueAndSPC.of(newSMGAndValue.getValue(), this.copyAndReplaceSMG(newSMGAndValue.getSMG()));
    }

    public SymbolicProgramConfiguration copyAndAddPointerFromAddressToRegion(Value address, SMGObject target, BigInteger offsetInBits) {
        SymbolicProgramConfiguration spc = this.copyAndCreateValue(address);
        SMGValue smgAddress = spc.getSMGValueFromValue(address).orElseThrow();
        SMGPointsToEdge pointsToEdge = new SMGPointsToEdge(target, offsetInBits, SMGTargetSpecifier.IS_REGION);
        return spc.copyAndReplaceSMG(spc.getSmg().copyAndAddPTEdge(pointsToEdge, smgAddress));
    }

    public SymbolicProgramConfiguration copyAndAddPointerFromAddressToRegionWithNestingLevel(Value address, SMGObject target, BigInteger offsetInBits, int nestingLevel) {
        SymbolicProgramConfiguration spc = this.copyAndCreateValue(address);
        SMGValue smgAddress = spc.getSMGValueFromValue(address).orElseThrow();
        SMGPointsToEdge pointsToEdge = new SMGPointsToEdge(target, offsetInBits, SMGTargetSpecifier.IS_REGION);
        if (target instanceof SMGSinglyLinkedListSegment) {
            Preconditions.checkArgument((((SMGSinglyLinkedListSegment)target).getMinLength() >= nestingLevel ? 1 : 0) != 0);
        }
        return spc.copyAndReplaceSMG(spc.getSmg().copyAndAddPTEdge(pointsToEdge, smgAddress.withNestingLevelAndCopy(nestingLevel)));
    }

    public Optional<SMGValue> getAddressValueForPointsToTarget(SMGObject target, BigInteger offset) {
        Map<SMGValue, SMGPointsToEdge> pteMapping = this.getSmg().getPTEdgeMapping();
        SMGPointsToEdge searchedForEdge = new SMGPointsToEdge(target, offset, SMGTargetSpecifier.IS_REGION);
        for (Map.Entry<SMGValue, SMGPointsToEdge> entry : pteMapping.entrySet()) {
            if (entry.getValue().compareTo(searchedForEdge) != 0) continue;
            return Optional.of(entry.getKey());
        }
        return Optional.empty();
    }

    public Optional<SMGValue> getAddressValueForPointsToTargetWithNestingLevel(SMGObject target, BigInteger offset, int nestingLevel) {
        Map<SMGValue, SMGPointsToEdge> pteMapping = this.getSmg().getPTEdgeMapping();
        SMGPointsToEdge searchedForEdge = new SMGPointsToEdge(target, offset, SMGTargetSpecifier.IS_REGION);
        for (Map.Entry<SMGValue, SMGPointsToEdge> entry : pteMapping.entrySet()) {
            if (entry.getValue().compareTo(searchedForEdge) != 0 || entry.getKey().getNestingLevel() != nestingLevel) continue;
            return Optional.of(entry.getKey());
        }
        return Optional.empty();
    }

    SMGTargetSpecifier getPointerSpecifier(Value pointer) {
        SMGValue smgValueAddress = (SMGValue)this.valueMapping.get((Object)valueWrapper.wrap(pointer));
        SMGPointsToEdge ptEdge = this.smg.getPTEdge(smgValueAddress).orElseThrow();
        Preconditions.checkNotNull((Object)ptEdge);
        return ptEdge.targetSpecifier();
    }

    public boolean isPointer(Value maybePointer) {
        if (this.valueMapping.containsKey((Object)valueWrapper.wrap(maybePointer))) {
            return this.smg.isPointer((SMGValue)this.valueMapping.get((Object)valueWrapper.wrap(maybePointer)));
        }
        return false;
    }

    public SymbolicProgramConfiguration writeValue(SMGObject pObject, BigInteger pFieldOffset, BigInteger pSizeofInBits, SMGValue pValue) {
        SMG newSMG = this.smg.copyAndAddValue(pValue);
        return this.copyAndReplaceSMG(newSMG.writeValue(pObject, pFieldOffset, pSizeofInBits, pValue));
    }

    public SymbolicProgramConfiguration invalidateSMGObject(SMGObject pObject) {
        Preconditions.checkArgument((boolean)this.smg.getObjects().contains(pObject));
        SymbolicProgramConfiguration newSPC = this;
        if (this.isObjectExternallyAllocated(pObject)) {
            newSPC = this.copyAndInvalidateExternalAllocation(pObject);
        }
        SMG newSMG = newSPC.getSmg().copyAndInvalidateObject(pObject);
        return newSPC.copyAndReplaceSMG(newSMG);
    }

    public PersistentMap<MemoryLocation, ValueAndValueSize> getMemoryLocationsAndValuesForSPCWithoutHeap() {
        PersistentSortedMap map = PathCopyingPersistentTreeMap.of();
        for (Map.Entry globalEntry : this.globalVariableMapping.entrySet()) {
            String qualifiedName = (String)globalEntry.getKey();
            SMGObject memory = (SMGObject)globalEntry.getValue();
            Preconditions.checkArgument((boolean)this.smg.isValid(memory));
            for (SMGHasValueEdge valueEdge : this.smg.getEdges(memory)) {
                MemoryLocation memLoc = MemoryLocation.fromQualifiedName(qualifiedName, valueEdge.getOffset().longValueExact());
                SMGValue smgValue = valueEdge.hasValue();
                BigInteger typeSize = valueEdge.getSizeInBits();
                Preconditions.checkArgument((boolean)this.valueMapping.containsValue((Object)smgValue));
                Value value = (Value)((Equivalence.Wrapper)this.valueMapping.inverse().get((Object)smgValue)).get();
                Preconditions.checkNotNull((Object)value);
                ValueAndValueSize valueAndValueSize = ValueAndValueSize.of(value, typeSize);
                map = map.putAndCopy((Object)memLoc, (Object)valueAndValueSize);
            }
        }
        for (StackFrame stackframe : this.stackVariableMapping) {
            if (stackframe.getReturnObject().isPresent()) {
                String funName = stackframe.getFunctionDefinition().getQualifiedName();
                for (SMGHasValueEdge valueEdge : this.smg.getEdges(stackframe.getReturnObject().orElseThrow())) {
                    MemoryLocation memLoc = MemoryLocation.fromQualifiedName(funName + "::__retval__", valueEdge.getOffset().longValueExact());
                    SMGValue smgValue = valueEdge.hasValue();
                    BigInteger typeSize = valueEdge.getSizeInBits();
                    Preconditions.checkArgument((boolean)this.valueMapping.containsValue((Object)smgValue));
                    Value value = (Value)((Equivalence.Wrapper)this.valueMapping.inverse().get((Object)smgValue)).get();
                    Preconditions.checkNotNull((Object)value);
                    ValueAndValueSize valueAndValueSize = ValueAndValueSize.of(value, typeSize);
                    map = map.putAndCopy((Object)memLoc, (Object)valueAndValueSize);
                }
            }
            for (Map.Entry<String, SMGObject> localVariable : stackframe.getVariables().entrySet()) {
                String qualifiedName = localVariable.getKey();
                SMGObject memory = localVariable.getValue();
                if (!this.smg.isValid(memory)) continue;
                for (SMGHasValueEdge valueEdge : this.smg.getEdges(memory)) {
                    MemoryLocation memLoc = MemoryLocation.fromQualifiedName(qualifiedName, valueEdge.getOffset().longValueExact());
                    SMGValue smgValue = valueEdge.hasValue();
                    BigInteger typeSize = valueEdge.getSizeInBits();
                    Preconditions.checkArgument((boolean)this.valueMapping.containsValue((Object)smgValue));
                    Value value = (Value)((Equivalence.Wrapper)this.valueMapping.inverse().get((Object)smgValue)).get();
                    Preconditions.checkNotNull((Object)value);
                    ValueAndValueSize valueAndValueSize = ValueAndValueSize.of(value, typeSize);
                    map = map.putAndCopy((Object)memLoc, (Object)valueAndValueSize);
                }
            }
        }
        return map;
    }

    public Map<String, BigInteger> getSizeObMemoryForSPCWithoutHeap() {
        HashMap<String, BigInteger> variableNameToMemorySizeInBits = new HashMap<String, BigInteger>();
        for (Map.Entry globalEntry : this.globalVariableMapping.entrySet()) {
            String qualifiedName = (String)globalEntry.getKey();
            SMGObject memory = (SMGObject)globalEntry.getValue();
            variableNameToMemorySizeInBits.put(qualifiedName, memory.getSize());
        }
        for (StackFrame stackframe : this.stackVariableMapping) {
            for (Map.Entry<String, SMGObject> localVariable : stackframe.getVariables().entrySet()) {
                String qualifiedName = localVariable.getKey();
                SMGObject memory = localVariable.getValue();
                variableNameToMemorySizeInBits.put(qualifiedName, memory.getSize());
            }
        }
        return variableNameToMemorySizeInBits;
    }

    public PersistentStack<CFunctionDeclarationAndOptionalValue> getFunctionDeclarationsFromStackFrames() {
        PersistentStack<CFunctionDeclarationAndOptionalValue> decls = PersistentStack.of();
        for (StackFrame frame : this.stackVariableMapping) {
            if (frame.getReturnObject().isEmpty()) {
                decls = decls.pushAndCopy(CFunctionDeclarationAndOptionalValue.of(frame.getFunctionDefinition(), Optional.empty()));
                continue;
            }
            FluentIterable<SMGHasValueEdge> edges = this.smg.getHasValueEdgesByPredicate(frame.getReturnObject().orElseThrow(), (Predicate<SMGHasValueEdge>)((Predicate)n -> true));
            if (edges.isEmpty()) {
                decls = decls.pushAndCopy(CFunctionDeclarationAndOptionalValue.of(frame.getFunctionDefinition(), Optional.empty()));
                continue;
            }
            Preconditions.checkArgument((edges.size() == 1 ? 1 : 0) != 0);
            Value returnValue = this.getValueFromSMGValue(((SMGHasValueEdge)edges.get(0)).hasValue()).orElseThrow();
            decls = decls.pushAndCopy(CFunctionDeclarationAndOptionalValue.of(frame.getFunctionDefinition(), Optional.of(returnValue)));
        }
        return decls;
    }

    public CType getTypeOfVariable(MemoryLocation memLoc) {
        CType type = (CType)this.variableToTypeMap.get((Object)memLoc.getQualifiedName());
        return type;
    }

    public PersistentMap<String, CType> getVariableTypeMap() {
        return this.variableToTypeMap;
    }

    public SymbolicProgramConfiguration copyAndRemoveObjectFromHeap(SMGObject obj) {
        return new SymbolicProgramConfiguration(this.smg.copyAndRemoveObjects((Collection<SMGObject>)ImmutableSet.of((Object)obj)), this.globalVariableMapping, this.stackVariableMapping, this.heapObjects.removeAndCopy(obj), this.externalObjectAllocation, this.valueMapping, this.variableToTypeMap);
    }

    public SymbolicProgramConfiguration replaceAllPointersTowardsWith(SMGObject oldObj, SMGObject newObject) {
        return new SymbolicProgramConfiguration(this.smg.replaceAllPointersTowardsWith(oldObj, newObject), this.globalVariableMapping, this.stackVariableMapping, this.heapObjects, this.externalObjectAllocation, this.valueMapping, this.variableToTypeMap);
    }

    public SymbolicProgramConfiguration replaceAllPointersTowardsWithAndIncrementNestingLevel(SMGObject oldObj, SMGObject newObject, int incrementAmount) {
        return new SymbolicProgramConfiguration(this.smg.replaceAllPointersTowardsWithAndIncrementNestingLevel(oldObj, newObject, incrementAmount), this.globalVariableMapping, this.stackVariableMapping, this.heapObjects, this.externalObjectAllocation, this.valueMapping, this.variableToTypeMap);
    }

    public SymbolicProgramConfiguration replaceSpecificPointersTowardsWithAndSetNestingLevelZero(SMGObject oldObj, SMGObject newObject, int replacementLevel) {
        return new SymbolicProgramConfiguration(this.smg.replaceSpecificPointersTowardsWithAndSetNestingLevelZero(oldObj, newObject, replacementLevel), this.globalVariableMapping, this.stackVariableMapping, this.heapObjects, this.externalObjectAllocation, this.valueMapping, this.variableToTypeMap);
    }

    public SymbolicProgramConfiguration copyAndReplaceHVEdgesAt(SMGObject objectToReplace, PersistentSet<SMGHasValueEdge> newHVEdges) {
        return new SymbolicProgramConfiguration(this.smg.copyAndReplaceHVEdgesAt(objectToReplace, newHVEdges), this.globalVariableMapping, this.stackVariableMapping, this.heapObjects, this.externalObjectAllocation, this.valueMapping, this.variableToTypeMap);
    }

    public SymbolicProgramConfiguration replaceValueAtWithAndCopy(SMGObject object, BigInteger offsetInBits, BigInteger sizeInBits, SMGHasValueEdge newHVEdge) {
        return new SymbolicProgramConfiguration(this.smg.copyAndReplaceHVEdgeAt(object, offsetInBits, sizeInBits, newHVEdge), this.globalVariableMapping, this.stackVariableMapping, this.heapObjects, this.externalObjectAllocation, this.valueMapping, this.variableToTypeMap);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        Object pointerInfo;
        Value value;
        SMGValue smgValue;
        StringBuilder builder = new StringBuilder();
        builder.append("Global variables:\n");
        for (Map.Entry entry : this.globalVariableMapping.entrySet()) {
            String qualifiedName = (String)entry.getKey();
            SMGObject sMGObject = (SMGObject)entry.getValue();
            Object memoryString = " in ";
            memoryString = this.smg.isValid(sMGObject) ? (String)memoryString + sMGObject : (String)memoryString + "invalid " + sMGObject;
            for (SMGHasValueEdge valueEdge : this.smg.getEdges(sMGObject)) {
                smgValue = valueEdge.hasValue();
                Preconditions.checkArgument((boolean)this.valueMapping.containsValue((Object)smgValue));
                value = (Value)((Equivalence.Wrapper)this.valueMapping.inverse().get((Object)smgValue)).get();
                Preconditions.checkNotNull((Object)value);
                pointerInfo = "";
                if (this.smg.isPointer(smgValue)) {
                    pointerInfo = " -> " + this.smg.getPTEdge(smgValue);
                }
                builder.append(qualifiedName).append(": ").append(value).append("(").append(smgValue).append((String)pointerInfo).append(")").append((String)memoryString);
                builder.append("\n");
            }
        }
        builder.append("\n");
        builder.append("Local Variables per StackFrame:");
        builder.append("\n");
        for (StackFrame stackFrame : this.stackVariableMapping) {
            Object funName;
            if (stackFrame.getReturnObject().isPresent()) {
                void var5_16;
                funName = stackFrame.getFunctionDefinition().getQualifiedName();
                String string = "";
                if (this.smg.isValid(stackFrame.getReturnObject().orElseThrow())) {
                    String string2 = string + stackFrame.getReturnObject().orElseThrow();
                } else {
                    String string3 = string + " invalid " + stackFrame.getReturnObject().orElseThrow();
                }
                builder.append("\n");
                builder.append("Function ").append((String)funName).append(" return object ").append(":" + (String)var5_16 + " with values: ");
                for (SMGHasValueEdge valueEdge : this.smg.getEdges(stackFrame.getReturnObject().orElseThrow())) {
                    MemoryLocation memLoc = MemoryLocation.fromQualifiedName((String)funName + "::__retval__", valueEdge.getOffset().longValueExact());
                    smgValue = valueEdge.hasValue();
                    Preconditions.checkArgument((boolean)this.valueMapping.containsValue((Object)smgValue));
                    value = (Value)((Equivalence.Wrapper)this.valueMapping.inverse().get((Object)smgValue)).get();
                    Preconditions.checkNotNull((Object)value);
                    pointerInfo = "";
                    if (this.smg.isPointer(smgValue)) {
                        pointerInfo = " -> " + this.smg.getPTEdge(smgValue);
                    }
                    builder.append("\n");
                    builder.append(memLoc.getQualifiedName()).append(": ").append(value).append("(").append(smgValue).append((String)pointerInfo).append(")");
                }
            } else {
                builder.append("\n");
                funName = stackFrame.getFunctionDefinition().getQualifiedName();
                builder.append("Function ").append((String)funName);
                builder.append("\n");
            }
            for (Map.Entry entry : stackFrame.getVariables().entrySet()) {
                String qualifiedName = (String)entry.getKey();
                SMGObject memory = (SMGObject)entry.getValue();
                Object memoryString = " in ";
                memoryString = this.smg.isValid(memory) ? (String)memoryString + memory : (String)memoryString + " invalid " + memory;
                for (SMGHasValueEdge valueEdge : this.smg.getEdges(memory)) {
                    SMGValue smgValue2 = valueEdge.hasValue();
                    Preconditions.checkArgument((boolean)this.valueMapping.containsValue((Object)smgValue2));
                    Value value2 = (Value)((Equivalence.Wrapper)this.valueMapping.inverse().get((Object)smgValue2)).get();
                    Preconditions.checkNotNull((Object)value2);
                    Object pointerInfo2 = "";
                    if (this.smg.isPointer(smgValue2)) {
                        pointerInfo2 = " -> " + this.smg.getPTEdge(smgValue2);
                    }
                    builder.append("  " + qualifiedName).append(": ").append(value2).append("(").append(smgValue2).append((String)pointerInfo2).append(")").append((String)memoryString);
                }
            }
            builder.append("\n");
        }
        builder.append("\n");
        builder.append("Pointers and targets with values:");
        builder.append("\n");
        for (Map.Entry entry : this.smg.getPTEdgeMapping().entrySet()) {
            String validity = "";
            if (!this.smg.isValid(((SMGPointsToEdge)entry.getValue()).pointsTo())) {
                validity = " (invalid object)";
            }
            builder.append(entry.getKey()).append(" (" + ((SMGValue)entry.getKey()).getNestingLevel() + ")").append(" -> ").append(entry.getValue()).append(this.smg.getHasValueEdgesByPredicate(((SMGPointsToEdge)entry.getValue()).pointsTo(), (Predicate<SMGHasValueEdge>)((Predicate)n -> true))).append(validity);
            builder.append("\n");
        }
        builder.append("\n");
        builder.append("Value mappings:");
        builder.append("\n");
        for (Map.Entry entry : this.valueMapping.entrySet()) {
            builder.append(entry.getValue()).append(" <- ").append(((Equivalence.Wrapper)entry.getKey()).get());
            builder.append("\n");
        }
        return builder.toString();
    }
}

