/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2.abstraction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMG2Exception;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGValueAndSMGState;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.smg.SMG;
import org.sosy_lab.cpachecker.util.smg.graph.SMGDoublyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGHasValueEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGPointsToEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGSinglyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;

public class SMGCPAAbstractionManager {
    private SMGState state;
    private int minimumLengthForListsForAbstraction;

    public SMGCPAAbstractionManager(SMGState pState, int pMinimumLengthForListsForAbstraction) {
        this.state = pState;
        this.minimumLengthForListsForAbstraction = pMinimumLengthForListsForAbstraction;
    }

    public SMGState findAndAbstractLists() throws SMG2Exception {
        SMGState currentState = this.state;
        for (SMGCandidate candidate : this.getRefinedLinkedCandidates()) {
            if (!currentState.getMemoryModel().isObjectValid(candidate.getObject())) continue;
            Optional<BigInteger> maybePFO = this.isDLL(candidate, currentState.getMemoryModel().getSmg());
            if (maybePFO.isPresent()) {
                for (SMGCandidate trueDLLCandidate : this.checkValueEquality(candidate.getObject(), candidate.getObject(), candidate.getSuspectedNfo(), maybePFO, new HashSet<SMGObject>(), new HashSet<SMGCandidate>(), 0)) {
                    currentState = currentState.abstractIntoDLL(trueDLLCandidate.getObject(), trueDLLCandidate.getSuspectedNfo(), maybePFO.orElseThrow(), (Set<SMGObject>)ImmutableSet.of());
                }
                continue;
            }
            for (SMGCandidate trueSLLCandidate : this.checkValueEquality(candidate.getObject(), candidate.getObject(), candidate.getSuspectedNfo(), Optional.empty(), new HashSet<SMGObject>(), new HashSet<SMGCandidate>(), 0)) {
                currentState = currentState.abstractIntoSLL(trueSLLCandidate.getObject(), trueSLLCandidate.getSuspectedNfo(), (Set<SMGObject>)ImmutableSet.of());
            }
        }
        return currentState;
    }

    private Set<SMGCandidate> checkValueEquality(SMGObject root, SMGObject walker, BigInteger nfo, Optional<BigInteger> maybePfo, Set<SMGObject> alreadySeen, Set<SMGCandidate> currentCandidates, int currentLength) {
        SMG smg = this.state.getMemoryModel().getSmg();
        if (!smg.isValid(root) || alreadySeen.contains(walker)) {
            return currentCandidates;
        }
        HashMap<BigInteger, Value> offsetToValueMap = new HashMap<BigInteger, Value>();
        for (SMGHasValueEdge hve : smg.getEdges(root)) {
            offsetToValueMap.put(hve.getOffset(), this.state.getMemoryModel().getValueFromSMGValue(hve.hasValue()).orElseThrow());
        }
        SMGPointsToEdge pointsToNext = null;
        boolean notEqual = false;
        for (SMGHasValueEdge hve : smg.getEdges(walker)) {
            SMGValue value = hve.hasValue();
            if (hve.getOffset().compareTo(nfo) == 0 && smg.isPointer(value)) {
                pointsToNext = smg.getPTEdge(value).orElseThrow();
                alreadySeen.add(walker);
                continue;
            }
            if (maybePfo.isPresent() && hve.getOffset().compareTo(maybePfo.orElseThrow()) == 0) continue;
            Value valueAtOffset = (Value)offsetToValueMap.get(hve.getOffset());
            Value thisValue = this.state.getMemoryModel().getValueFromSMGValue(hve.hasValue()).orElseThrow();
            if (thisValue.equals(valueAtOffset)) continue;
            if (this.state.getMemoryModel().isPointer(thisValue) || this.state.getMemoryModel().isPointer(valueAtOffset)) {
                notEqual = true;
                continue;
            }
            if (valueAtOffset != null && !thisValue.isExplicitlyKnown() && !valueAtOffset.isExplicitlyKnown()) continue;
            notEqual = true;
        }
        if (pointsToNext == null) {
            return currentCandidates;
        }
        if (notEqual) {
            return this.checkValueEquality(walker, pointsToNext.pointsTo(), nfo, maybePfo, alreadySeen, currentCandidates, 1);
        }
        if (currentLength + 1 >= this.minimumLengthForListsForAbstraction) {
            currentCandidates.add(new SMGCandidate(root, nfo));
            return this.checkValueEquality(root, pointsToNext.pointsTo(), nfo, maybePfo, alreadySeen, currentCandidates, currentLength + 1);
        }
        return this.checkValueEquality(root, pointsToNext.pointsTo(), nfo, maybePfo, alreadySeen, currentCandidates, currentLength + 1);
    }

    private int getLinkedCandidateLength(SMGObject root, BigInteger nfo, Set<SMGObject> alreadySeen) {
        SMG smg = this.state.getMemoryModel().getSmg();
        if (!smg.isValid(root) || alreadySeen.contains(root)) {
            return 0;
        }
        for (SMGHasValueEdge hve : smg.getEdges(root)) {
            SMGValue value = hve.hasValue();
            int size = 1;
            if (root instanceof SMGSinglyLinkedListSegment) {
                size = ((SMGSinglyLinkedListSegment)root).getMinLength();
            }
            if (hve.getOffset().compareTo(nfo) != 0 || !smg.isPointer(value)) continue;
            SMGPointsToEdge pointsToEdge = smg.getPTEdge(value).orElseThrow();
            alreadySeen.add(root);
            return size + this.getLinkedCandidateLength(pointsToEdge.pointsTo(), nfo, alreadySeen);
        }
        return 0;
    }

    ImmutableList<SMGCandidate> getRefinedLinkedCandidates() {
        ImmutableList sortedCandiList = ImmutableList.sortedCopyOf(Comparator.comparing(SMGCandidate::getSuspectedNfo), this.refineCandidates(this.getLinkedCandidates(), this.state));
        return (ImmutableList)sortedCandiList.stream().filter(c -> this.minimumLengthForListsForAbstraction <= this.getLinkedCandidateLength(c.getObject(), c.getSuspectedNfo(), new HashSet<SMGObject>())).collect(ImmutableList.toImmutableList());
    }

    private Set<SMGCandidate> getLinkedCandidates() {
        SMG smg = this.state.getMemoryModel().getSmg();
        HashSet<SMGCandidate> candidates = new HashSet<SMGCandidate>();
        HashSet<SMGObject> alreadyVisited = new HashSet<SMGObject>();
        for (SMGObject heapObj : this.state.getMemoryModel().getHeapObjects()) {
            Optional<SMGCandidate> maybeCandidate;
            if (!smg.isValid(heapObj) || !(maybeCandidate = this.getSLLinkedCandidatesForObject(heapObj, smg, alreadyVisited, this.state.getMemoryModel().getHeapObjects())).isPresent()) continue;
            candidates.add(maybeCandidate.orElseThrow());
        }
        return candidates;
    }

    protected Optional<BigInteger> isDLL(SMGCandidate candidate, SMG smg) {
        BigInteger nfo = candidate.getSuspectedNfo();
        SMGObject root = candidate.getObject();
        SMGObject nextObject = null;
        if (root instanceof SMGDoublyLinkedListSegment) {
            SMGDoublyLinkedListSegment dll = (SMGDoublyLinkedListSegment)root;
            if (dll.getNextOffset().compareTo(nfo) == 0) {
                return Optional.of(dll.getPrevOffset());
            }
            if (dll.getPrevOffset().compareTo(nfo) != 0) {
                throw new AssertionError((Object)"Error during shape refinement.");
            }
        } else if (root instanceof SMGSinglyLinkedListSegment) {
            return Optional.empty();
        }
        for (SMGHasValueEdge hve : smg.getEdges(root)) {
            SMGValue value = hve.hasValue();
            if (hve.getOffset().compareTo(nfo) != 0 || !smg.isPointer(value)) continue;
            SMGPointsToEdge pointsToEdge = smg.getPTEdge(value).orElseThrow();
            nextObject = pointsToEdge.pointsTo();
            break;
        }
        return this.nexthaveBackPointers(nextObject, root, smg, nfo, 1);
    }

    Set<SMGCandidate> refineCandidates(Set<SMGCandidate> candidates, SMGState pState) {
        Set<SMGCandidate> finalCandidates = candidates;
        ImmutableList sortedCandiList = ImmutableList.sortedCopyOf(Comparator.comparing(SMGCandidate::getSuspectedNfo), candidates);
        for (SMGCandidate candi : sortedCandiList) {
            if (!finalCandidates.contains(candi)) continue;
            finalCandidates = this.traverseAndKickEqual(candi.getObject(), candi.getSuspectedNfo(), finalCandidates, pState, new HashSet<SMGObject>());
        }
        return finalCandidates;
    }

    private Set<SMGCandidate> traverseAndKickEqual(SMGObject candidate, BigInteger nfo, Set<SMGCandidate> candidates, SMGState pState, Set<SMGObject> alreadyVisited) {
        if (alreadyVisited.contains(candidate)) {
            return candidates;
        }
        alreadyVisited.add(candidate);
        Optional<SMGObject> maybeNext = this.getValidNextSLL(candidate, nfo, pState);
        if (maybeNext.isPresent()) {
            SMGObject nextObject = maybeNext.orElseThrow();
            Set newCandidates = (Set)candidates.stream().filter(can -> !can.getObject().equals(nextObject)).collect(ImmutableSet.toImmutableSet());
            return this.traverseAndKickEqual(nextObject, nfo, newCandidates, pState, alreadyVisited);
        }
        return candidates;
    }

    private Optional<SMGObject> getValidNextSLL(SMGObject root, BigInteger nfo, SMGState pState) {
        SMGValueAndSMGState valueAndState = pState.readSMGValue(root, nfo, pState.getMemoryModel().getSizeOfPointer());
        SMGValue value = valueAndState.getSMGValue();
        if (!this.state.getMemoryModel().getSmg().isPointer(value)) {
            return Optional.empty();
        }
        SMGObject nextObject = pState.getMemoryModel().getSmg().getPTEdge(value).orElseThrow().pointsTo();
        if (!pState.getMemoryModel().getSmg().isValid(nextObject) || root.getSize().compareTo(nextObject.getSize()) != 0) {
            return Optional.empty();
        }
        return Optional.of(nextObject);
    }

    private Optional<BigInteger> nexthaveBackPointers(SMGObject root, SMGObject previous, SMG smg, BigInteger nfo, BigInteger pfo, int lengthToCheck, Set<SMGObject> alreadyVisited) {
        SMGValue value;
        if (lengthToCheck <= 0) {
            return Optional.of(pfo);
        }
        ImmutableSet<SMGHasValueEdge> setOfPointers = this.getPointersToSameSizeObjectsWithoutOffset(root, smg, alreadyVisited, nfo);
        if (setOfPointers.size() < 1) {
            return Optional.empty();
        }
        SMGObject nextObject = null;
        for (SMGHasValueEdge hve : smg.getEdges(root)) {
            value = hve.hasValue();
            if (hve.getOffset().compareTo(nfo) != 0 || !smg.isPointer(value)) continue;
            Optional<SMGPointsToEdge> pointsToEdge = smg.getPTEdge(value);
            if (pointsToEdge.isEmpty()) break;
            nextObject = pointsToEdge.orElseThrow().pointsTo();
            break;
        }
        alreadyVisited.add(previous);
        for (SMGHasValueEdge hve : setOfPointers) {
            SMGPointsToEdge pte;
            SMGObject prevInCurrent;
            if (hve.getOffset().compareTo(pfo) != 0 || !(prevInCurrent = (pte = smg.getPTEdge(value = hve.hasValue()).orElseThrow()).pointsTo()).equals(previous)) continue;
            if (nextObject == null) {
                return Optional.empty();
            }
            Optional<BigInteger> maybePFO = this.nexthaveBackPointers(nextObject, root, smg, nfo, pfo, lengthToCheck - 1, alreadyVisited);
            if (!maybePFO.isPresent()) continue;
            return maybePFO;
        }
        return Optional.empty();
    }

    private Optional<BigInteger> nexthaveBackPointers(SMGObject root, SMGObject previous, SMG smg, BigInteger nfo, int lengthToCheck) {
        HashSet<SMGObject> alreadyVisited = new HashSet<SMGObject>();
        ImmutableSet<SMGHasValueEdge> setOfPointers = this.getPointersToSameSizeObjectsWithoutOffset(root, smg, alreadyVisited, nfo);
        if (setOfPointers.size() < 1) {
            return Optional.empty();
        }
        SMGObject nextObject = null;
        for (SMGHasValueEdge hve : smg.getEdges(root)) {
            SMGValue value = hve.hasValue();
            if (hve.getOffset().compareTo(nfo) != 0 || !smg.isPointer(value)) continue;
            Optional<SMGPointsToEdge> pointsToEdge = smg.getPTEdge(value);
            if (pointsToEdge.isEmpty()) break;
            nextObject = pointsToEdge.orElseThrow().pointsTo();
            break;
        }
        alreadyVisited.add(previous);
        for (SMGHasValueEdge hve : setOfPointers) {
            Optional<BigInteger> maybePFO;
            BigInteger pfo = hve.getOffset();
            SMGValue value = hve.hasValue();
            SMGPointsToEdge pte = smg.getPTEdge(value).orElseThrow();
            SMGObject prevInCurrent = pte.pointsTo();
            if (!prevInCurrent.equals(previous) || !(maybePFO = this.nexthaveBackPointers(nextObject, root, smg, nfo, pfo, lengthToCheck - 1, alreadyVisited)).isPresent()) continue;
            return maybePFO;
        }
        return Optional.empty();
    }

    private Optional<SMGCandidate> getSLLinkedCandidatesForObject(SMGObject potentialRoot, SMG pInputSmg, Set<SMGObject> pAlreadyVisited, Collection<SMGObject> heapObjects) {
        HashSet<SMGObject> thisAlreadyVisited = new HashSet<SMGObject>(pAlreadyVisited);
        if (thisAlreadyVisited.contains(potentialRoot) || !pInputSmg.isValid(potentialRoot)) {
            return Optional.empty();
        }
        thisAlreadyVisited.add(potentialRoot);
        if (potentialRoot instanceof SMGSinglyLinkedListSegment) {
            pAlreadyVisited.add(potentialRoot);
            SMGSinglyLinkedListSegment sll = (SMGSinglyLinkedListSegment)potentialRoot;
            return Optional.of(new SMGCandidate(potentialRoot, sll.getNextOffset()));
        }
        ImmutableSet<SMGHasValueEdge> setOfPointers = this.getPointersToSameSizeObjects(potentialRoot, pInputSmg, thisAlreadyVisited);
        ImmutableList sortedPointersList = ImmutableList.sortedCopyOf(Comparator.comparing(SMGHasValueEdge::getOffset), setOfPointers);
        if (setOfPointers.isEmpty()) {
            return Optional.empty();
        }
        for (SMGHasValueEdge hve : sortedPointersList) {
            ImmutableSet<SMGObject> maybePointerFromHeap;
            SMGSinglyLinkedListSegment sll;
            SMGValue value = hve.hasValue();
            BigInteger nfo = hve.getOffset();
            SMGPointsToEdge pointsToEdge = pInputSmg.getPTEdge(value).orElseThrow();
            SMGObject reachedObject = pointsToEdge.pointsTo();
            if (reachedObject instanceof SMGSinglyLinkedListSegment && (sll = (SMGSinglyLinkedListSegment)reachedObject).getNextOffset().compareTo(nfo) == 0) {
                pAlreadyVisited.add(potentialRoot);
                return Optional.of(new SMGCandidate(potentialRoot, nfo));
            }
            if (!this.followupHasNextPointerToValid(reachedObject, nfo, pInputSmg, thisAlreadyVisited) || !(maybePointerFromHeap = pInputSmg.findAllAddressesForTargetObject(potentialRoot, heapObjects)).isEmpty() && (maybePointerFromHeap.size() != 1 || !maybePointerFromHeap.contains((Object)reachedObject))) continue;
            pAlreadyVisited.add(potentialRoot);
            return Optional.of(new SMGCandidate(potentialRoot, nfo));
        }
        return Optional.empty();
    }

    private boolean followupHasNextPointerToValid(SMGObject potentialFollowup, BigInteger nfoOfPrev, SMG pInputSmg, Set<SMGObject> alreadyVisited) {
        alreadyVisited.add(potentialFollowup);
        ImmutableSet<SMGHasValueEdge> pointers = this.getPointersToSameSizeObjects(potentialFollowup, pInputSmg, alreadyVisited);
        if (pointers.isEmpty()) {
            alreadyVisited.remove(potentialFollowup);
            return false;
        }
        for (SMGHasValueEdge hve : pointers) {
            if (hve.getOffset().compareTo(nfoOfPrev) != 0) continue;
            return true;
        }
        return false;
    }

    private ImmutableSet<SMGHasValueEdge> getPointersToSameSizeObjects(SMGObject root, SMG pInputSmg, Set<SMGObject> alreadyVisted) {
        BigInteger rootSize = root.getSize();
        ImmutableSet.Builder res = ImmutableSet.builder();
        for (SMGHasValueEdge hve : pInputSmg.getEdges(root)) {
            SMGPointsToEdge pointsToEdge;
            SMGObject reachedObject;
            SMGValue value = hve.hasValue();
            if (!pInputSmg.isPointer(value) || alreadyVisted.contains(reachedObject = (pointsToEdge = pInputSmg.getPTEdge(value).orElseThrow()).pointsTo()) || !pInputSmg.isValid(reachedObject) || reachedObject.getSize().compareTo(rootSize) != 0 || pointsToEdge.targetSpecifier() != SMGTargetSpecifier.IS_ALL_POINTER && pointsToEdge.targetSpecifier() != SMGTargetSpecifier.IS_REGION) continue;
            res.add((Object)hve);
        }
        return res.build();
    }

    private ImmutableSet<SMGHasValueEdge> getPointersToSameSizeObjectsWithoutOffset(SMGObject root, SMG pInputSmg, Set<SMGObject> alreadyVisted, BigInteger offsetToAvoid) {
        BigInteger rootSize = root.getSize();
        ImmutableSet.Builder res = ImmutableSet.builder();
        for (SMGHasValueEdge hve : pInputSmg.getEdges(root)) {
            SMGPointsToEdge pointsToEdge;
            SMGObject reachedObject;
            SMGValue value = hve.hasValue();
            if (hve.getOffset().compareTo(offsetToAvoid) == 0 || !pInputSmg.isPointer(value) || alreadyVisted.contains(reachedObject = (pointsToEdge = pInputSmg.getPTEdge(value).orElseThrow()).pointsTo()) || !pInputSmg.isValid(reachedObject) || reachedObject.getSize().compareTo(rootSize) != 0 || pointsToEdge.targetSpecifier() != SMGTargetSpecifier.IS_ALL_POINTER && pointsToEdge.targetSpecifier() != SMGTargetSpecifier.IS_REGION) continue;
            res.add((Object)hve);
        }
        return res.build();
    }

    protected static class SMGCandidate {
        private SMGObject object;
        private BigInteger suspectedNfo;

        public SMGCandidate(SMGObject object, BigInteger suspectedNfo) {
            this.object = object;
            this.suspectedNfo = suspectedNfo;
        }

        public SMGObject getObject() {
            return this.object;
        }

        public BigInteger getSuspectedNfo() {
            return this.suspectedNfo;
        }
    }
}

