/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2.abstraction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smg2.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.abstraction.SMGCPAAbstractionManager;
import org.sosy_lab.cpachecker.cpa.smg2.abstraction.SMGCPAMaterializer;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMG2Exception;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGStateAndOptionalSMGObjectAndOffset;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGValueAndSMGState;
import org.sosy_lab.cpachecker.cpa.smg2.util.value.ValueAndSMGState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicIdentifier;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueFactory;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.smg.graph.SMGDoublyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGPointsToEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGSinglyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;

public class SMGCPAAbstractionTest {
    private MachineModel machineModel;
    private BigInteger pointerSizeInBits;
    private LogManagerWithoutDuplicates logger;
    private SMGState currentState;
    private SMGCPAMaterializer materializer;
    private BigInteger sllSize;
    private BigInteger dllSize;
    private BigInteger hfo = BigInteger.ZERO;
    private BigInteger nfo;
    private BigInteger pfo;
    private static final int TEST_LIST_LENGTH = 50;

    @Before
    public void init() throws InvalidConfigurationException {
        this.machineModel = MachineModel.LINUX32;
        this.pointerSizeInBits = BigInteger.valueOf((long)this.machineModel.getSizeof(this.machineModel.getPointerEquivalentSimpleType()) * 8L);
        this.sllSize = this.pointerSizeInBits.multiply(BigInteger.TWO);
        this.dllSize = this.pointerSizeInBits.multiply(BigInteger.valueOf(3L));
        this.nfo = this.hfo.add(this.pointerSizeInBits);
        this.pfo = this.nfo.add(this.pointerSizeInBits);
        this.logger = new LogManagerWithoutDuplicates(LogManager.createTestLogManager());
        this.materializer = new SMGCPAMaterializer((LogManager)this.logger);
        this.currentState = SMGState.of(this.machineModel, (LogManager)this.logger, new SMGOptions(Configuration.defaultConfiguration()));
    }

    @After
    public void resetSMGStateAndVisitor() throws InvalidConfigurationException {
        this.currentState = SMGState.of(this.machineModel, (LogManager)this.logger, new SMGOptions(Configuration.defaultConfiguration()));
    }

    @Ignore
    @Test
    public void nestedListSLLTest() throws InvalidConfigurationException, SMG2Exception {
        Value[] pointers;
        this.resetSMGStateAndVisitor();
        int listLength = 10;
        this.resetSMGStateAndVisitor();
        for (Value pointer : pointers = this.buildConcreteList(false, this.sllSize, listLength)) {
            Value[] pointersNested = this.buildConcreteList(false, this.sllSize, listLength);
            SMGStateAndOptionalSMGObjectAndOffset topListSegmentAndState = this.currentState.dereferencePointerWithoutMaterilization(pointer).orElseThrow();
            this.currentState = topListSegmentAndState.getSMGState();
            SMGObject topListSegment = topListSegmentAndState.getSMGObject();
            this.currentState = this.currentState.writeValue(topListSegment, this.hfo, this.pointerSizeInBits, this.currentState.getMemoryModel().getSMGValueFromValue(pointersNested[0]).orElseThrow());
        }
        SMGCPAAbstractionManager absFinder = new SMGCPAAbstractionManager(this.currentState, listLength - 1);
        this.currentState = absFinder.findAndAbstractLists();
        SMGObject abstractedTopListSegment = null;
        for (Value pointer : pointers) {
            SMGStateAndOptionalSMGObjectAndOffset topListSegmentAndState = this.currentState.dereferencePointerWithoutMaterilization(pointer).orElseThrow();
            this.currentState = topListSegmentAndState.getSMGState();
            SMGObject currentTopListSegment = topListSegmentAndState.getSMGObject();
            if (abstractedTopListSegment != null) {
                Truth.assertThat(abstractedTopListSegment).isEqualTo((Object)currentTopListSegment);
                abstractedTopListSegment = currentTopListSegment;
            } else {
                abstractedTopListSegment = currentTopListSegment;
            }
            Truth.assertThat((Boolean)(currentTopListSegment instanceof SMGSinglyLinkedListSegment)).isTrue();
            Truth.assertThat((Integer)((SMGSinglyLinkedListSegment)currentTopListSegment).getMinLength()).isEqualTo((Object)listLength);
        }
    }

    @Test
    public void nestedListDLLTest() throws InvalidConfigurationException {
        this.resetSMGStateAndVisitor();
    }

    @Test
    public void nestedListAbstractionSLLTest() throws InvalidConfigurationException {
        this.resetSMGStateAndVisitor();
    }

    @Test
    public void nestedListAbstractionDLLTest() throws InvalidConfigurationException {
        this.resetSMGStateAndVisitor();
    }

    @Test
    public void correctPointerNestingSLLTest() throws InvalidConfigurationException, SMG2Exception {
        int lengthOfList = 10;
        this.resetSMGStateAndVisitor();
        Value[] pointers = this.buildConcreteList(false, this.sllSize, lengthOfList);
        SMGCPAAbstractionManager absFinder = new SMGCPAAbstractionManager(this.currentState, lengthOfList - 1);
        this.currentState = absFinder.findAndAbstractLists();
        this.derefPointersAtAndCheckListMaterialization(lengthOfList, pointers, new int[]{1, 2, 4, 8, 9}, false);
    }

    @Test
    public void correctPointerNestingDLLTest() throws InvalidConfigurationException, SMG2Exception {
        int lengthOfList = 10;
        this.resetSMGStateAndVisitor();
        Value[] pointers = this.buildConcreteList(true, this.dllSize, lengthOfList);
        SMGCPAAbstractionManager absFinder = new SMGCPAAbstractionManager(this.currentState, lengthOfList - 1);
        this.currentState = absFinder.findAndAbstractLists();
        this.derefPointersAtAndCheckListMaterialization(lengthOfList, pointers, new int[]{1, 2, 4, 8, 9}, true);
    }

    @Test
    public void correctZeroPlusAbsorptionSLLTest() throws InvalidConfigurationException, SMG2Exception {
        int lengthOfList = 10;
        this.nfo = BigInteger.ZERO;
        this.sllSize = this.pointerSizeInBits;
        for (int i = 0; i < 3; ++i) {
            this.resetSMGStateAndVisitor();
            Value[] pointers = this.buildConcreteList(false, this.sllSize, lengthOfList);
            SMGCPAAbstractionManager absFinder = new SMGCPAAbstractionManager(this.currentState, lengthOfList - 1);
            this.currentState = absFinder.findAndAbstractLists();
            this.derefPointersAtAndCheckListMaterialization(lengthOfList, pointers, new int[]{lengthOfList - 1}, false);
            this.currentState = absFinder.findAndAbstractLists();
            this.assertAbstractedList(pointers, lengthOfList, false);
            this.nfo = this.nfo.add(this.pointerSizeInBits);
            this.sllSize = this.sllSize.add(this.pointerSizeInBits);
        }
    }

    @Test
    public void correctZeroPlusAbsorptionDLLTest() throws InvalidConfigurationException, SMG2Exception {
        int lengthOfList = 10;
        this.nfo = BigInteger.ZERO;
        this.pfo = this.nfo.add(this.pointerSizeInBits);
        this.dllSize = this.pointerSizeInBits.multiply(BigInteger.TWO);
        for (int i = 0; i < 3; ++i) {
            this.resetSMGStateAndVisitor();
            Value[] pointers = this.buildConcreteList(true, this.dllSize, lengthOfList);
            SMGCPAAbstractionManager absFinder = new SMGCPAAbstractionManager(this.currentState, lengthOfList - 1);
            this.currentState = absFinder.findAndAbstractLists();
            this.derefPointersAtAndCheckListMaterialization(lengthOfList, pointers, new int[]{lengthOfList - 1}, true);
            this.currentState = absFinder.findAndAbstractLists();
            this.assertAbstractedList(pointers, lengthOfList, true);
            this.checkListDataIntegrity(pointers, true);
            this.nfo = this.nfo.add(this.pointerSizeInBits);
            this.dllSize = this.dllSize.add(this.pointerSizeInBits);
            this.pfo = this.nfo.add(this.pointerSizeInBits);
        }
    }

    private void assertAbstractedList(Value[] pointers, int lengthOfList, boolean dll) {
        Truth.assertThat(this.currentState.getMemoryModel().getHeapObjects()).hasSize(2);
        int numOfValidObjects = 0;
        for (SMGObject obj : this.currentState.getMemoryModel().getSmg().getObjects()) {
            if (!this.currentState.getMemoryModel().isObjectValid(obj)) continue;
            ++numOfValidObjects;
            Truth.assertThat((Boolean)(obj instanceof SMGSinglyLinkedListSegment)).isTrue();
            Truth.assertThat((Integer)((SMGSinglyLinkedListSegment)obj).getMinLength()).isEqualTo((Object)lengthOfList);
            SMGObject derefedAbstractedObj = this.currentState.dereferencePointerWithoutMaterilization(pointers[lengthOfList - 1]).orElseThrow().getSMGObject();
            Truth.assertThat((Comparable)obj).isEqualTo((Object)derefedAbstractedObj);
            ValueAndSMGState readNfoWithoutMaterialization = this.currentState.readValueWithoutMaterialization(obj, this.nfo, this.pointerSizeInBits, null);
            this.currentState = readNfoWithoutMaterialization.getState();
            Truth.assertThat((Boolean)readNfoWithoutMaterialization.getValue().isNumericValue()).isTrue();
            Truth.assertThat((Comparable)readNfoWithoutMaterialization.getValue().asNumericValue().bigInteger()).isEquivalentAccordingToCompareTo((Comparable)BigInteger.ZERO);
            if (!dll) continue;
            Truth.assertThat((Boolean)(obj instanceof SMGDoublyLinkedListSegment)).isTrue();
            ValueAndSMGState readPfoWithoutMaterialization = this.currentState.readValueWithoutMaterialization(obj, this.pfo, this.pointerSizeInBits, null);
            this.currentState = readPfoWithoutMaterialization.getState();
            Truth.assertThat((Boolean)readPfoWithoutMaterialization.getValue().isNumericValue()).isTrue();
            Truth.assertThat((Comparable)readPfoWithoutMaterialization.getValue().asNumericValue().bigInteger()).isEquivalentAccordingToCompareTo((Comparable)BigInteger.ZERO);
        }
        Truth.assertThat((Integer)numOfValidObjects).isEqualTo((Object)1);
    }

    @Test
    public void zeroPlusRemovalSLLTest() throws SMG2Exception, InvalidConfigurationException {
        int sizeOfList = 3;
        this.resetSMGStateAndVisitor();
        Value[] pointers = this.buildConcreteList(false, this.sllSize, sizeOfList);
        SMGCPAAbstractionManager absFinder = new SMGCPAAbstractionManager(this.currentState, sizeOfList);
        this.currentState = absFinder.findAndAbstractLists();
        List<SMGStateAndOptionalSMGObjectAndOffset> statesAndResultingObjects = this.currentState.dereferencePointer(pointers[sizeOfList - 1]);
        Truth.assertThat((Boolean)(statesAndResultingObjects.size() == 1 ? 1 : 0)).isTrue();
        SMGStateAndOptionalSMGObjectAndOffset stateAndResultingObject = statesAndResultingObjects.get(0);
        this.currentState = stateAndResultingObject.getSMGState();
        SMGObject lastConcreteListObject = stateAndResultingObject.getSMGObject();
        Truth.assertThat((Comparable)stateAndResultingObject.getOffsetForObject()).isEquivalentAccordingToCompareTo((Comparable)BigInteger.ZERO);
        this.checkNextPointsToZeroPlus(lastConcreteListObject, false);
        this.checkZeroPlusBehaviour(false, lastConcreteListObject, BigInteger.ZERO);
    }

    @Test
    public void zeroPlusRemovalDLLTest() throws SMG2Exception, InvalidConfigurationException {
        int sizeOfList = 3;
        this.resetSMGStateAndVisitor();
        Value[] pointers = this.buildConcreteList(true, this.dllSize, sizeOfList);
        SMGCPAAbstractionManager absFinder = new SMGCPAAbstractionManager(this.currentState, sizeOfList);
        this.currentState = absFinder.findAndAbstractLists();
        List<SMGStateAndOptionalSMGObjectAndOffset> statesAndResultingObjects = this.currentState.dereferencePointer(pointers[sizeOfList - 1]);
        Truth.assertThat((Boolean)(statesAndResultingObjects.size() == 1 ? 1 : 0)).isTrue();
        SMGStateAndOptionalSMGObjectAndOffset stateAndResultingObject = statesAndResultingObjects.get(0);
        this.currentState = stateAndResultingObject.getSMGState();
        SMGObject lastConcreteListObject = stateAndResultingObject.getSMGObject();
        Truth.assertThat((Comparable)stateAndResultingObject.getOffsetForObject()).isEquivalentAccordingToCompareTo((Comparable)BigInteger.ZERO);
        this.checkNextPointsToZeroPlus(lastConcreteListObject, true);
        this.checkZeroPlusBehaviour(true, lastConcreteListObject, BigInteger.ZERO);
    }

    private void checkNextPointsToZeroPlus(SMGObject lastConcreteListObject, boolean dll) {
        SMGValueAndSMGState readValueAndState = this.currentState.readSMGValue(lastConcreteListObject, this.nfo, this.pointerSizeInBits);
        this.currentState = readValueAndState.getSMGState();
        SMGValue nextPointerValue = readValueAndState.getSMGValue();
        Truth.assertThat((Boolean)this.currentState.getMemoryModel().getSmg().isPointer(nextPointerValue)).isTrue();
        SMGPointsToEdge pointsToEdge = this.currentState.getMemoryModel().getSmg().getPTEdge(nextPointerValue).orElseThrow();
        Truth.assertThat((Boolean)(pointsToEdge.pointsTo() instanceof SMGSinglyLinkedListSegment)).isTrue();
        Truth.assertThat((Integer)((SMGSinglyLinkedListSegment)pointsToEdge.pointsTo()).getMinLength()).isEqualTo((Object)0);
        if (dll) {
            SMGValueAndSMGState readPfoValueAndState = this.currentState.readSMGValue(pointsToEdge.pointsTo(), this.pfo, this.pointerSizeInBits);
            this.currentState = readPfoValueAndState.getSMGState();
            SMGValue prevPointerValue = readPfoValueAndState.getSMGValue();
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().getSmg().isPointer(prevPointerValue)).isTrue();
            SMGPointsToEdge pointsToPrevConcreteEdge = this.currentState.getMemoryModel().getSmg().getPTEdge(prevPointerValue).orElseThrow();
            Truth.assertThat((Comparable)pointsToPrevConcreteEdge.pointsTo()).isEqualTo((Object)lastConcreteListObject);
        }
    }

    private void checkZeroPlusBehaviour(boolean dll, SMGObject lastConcreteListObject, BigInteger expectedNfoValue) throws SMG2Exception {
        List<ValueAndSMGState> statesAndReadValueZeroPlus = this.currentState.readValue(lastConcreteListObject, this.nfo, this.pointerSizeInBits, null);
        Truth.assertThat(statesAndReadValueZeroPlus).hasSize(2);
        ValueAndSMGState firstReadValueAndState = statesAndReadValueZeroPlus.get(0);
        this.currentState = firstReadValueAndState.getState();
        Truth.assertThat((Boolean)firstReadValueAndState.getValue().isNumericValue()).isTrue();
        Truth.assertThat((Comparable)firstReadValueAndState.getValue().asNumericValue().bigInteger()).isEquivalentAccordingToCompareTo((Comparable)expectedNfoValue);
        ValueAndSMGState secondReadValueAndState = statesAndReadValueZeroPlus.get(1);
        this.currentState = secondReadValueAndState.getState();
        Truth.assertThat((Boolean)secondReadValueAndState.getValue().isNumericValue()).isFalse();
        SMGValue pointerValueFromZeroPlus = this.currentState.getMemoryModel().getSMGValueFromValue(secondReadValueAndState.getValue()).orElseThrow();
        Truth.assertThat((Boolean)this.currentState.getMemoryModel().getSmg().isPointer(pointerValueFromZeroPlus)).isTrue();
        SMGPointsToEdge pointsToAdditionalSegmentEdge = this.currentState.getMemoryModel().getSmg().getPTEdge(pointerValueFromZeroPlus).orElseThrow();
        Truth.assertThat((Boolean)(pointsToAdditionalSegmentEdge.pointsTo() instanceof SMGSinglyLinkedListSegment)).isFalse();
        Truth.assertThat((Comparable)((Object)pointsToAdditionalSegmentEdge.targetSpecifier())).isEqualTo((Object)SMGTargetSpecifier.IS_REGION);
        SMGValueAndSMGState readNfoValueAndState = this.currentState.readSMGValue(pointsToAdditionalSegmentEdge.pointsTo(), this.nfo, this.pointerSizeInBits);
        this.currentState = readNfoValueAndState.getSMGState();
        SMGValue nextPointerValue = readNfoValueAndState.getSMGValue();
        Truth.assertThat((Boolean)this.currentState.getMemoryModel().getSmg().isPointer(nextPointerValue)).isTrue();
        SMGPointsToEdge pointsToNextConcreteEdge = this.currentState.getMemoryModel().getSmg().getPTEdge(nextPointerValue).orElseThrow();
        Truth.assertThat((Boolean)(pointsToNextConcreteEdge.pointsTo() instanceof SMGSinglyLinkedListSegment)).isTrue();
        Truth.assertThat((Integer)((SMGSinglyLinkedListSegment)pointsToNextConcreteEdge.pointsTo()).getMinLength()).isEqualTo((Object)0);
        if (dll) {
            SMGValueAndSMGState readPfoValueAndState = this.currentState.readSMGValue(pointsToAdditionalSegmentEdge.pointsTo(), this.pfo, this.pointerSizeInBits);
            this.currentState = readPfoValueAndState.getSMGState();
            SMGValue prevPointerValue = readPfoValueAndState.getSMGValue();
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().getSmg().isPointer(prevPointerValue)).isTrue();
            SMGPointsToEdge pointsToPrevConcreteEdge = this.currentState.getMemoryModel().getSmg().getPTEdge(prevPointerValue).orElseThrow();
            Truth.assertThat((Comparable)pointsToPrevConcreteEdge.pointsTo()).isEqualTo((Object)lastConcreteListObject);
        }
    }

    @Test
    public void basicSLLFullAbstractionTest() throws SMG2Exception {
        Value[] pointers = this.buildConcreteList(false, this.sllSize, 50);
        SMGStateAndOptionalSMGObjectAndOffset stateAndObject = this.currentState.dereferencePointerWithoutMaterilization(pointers[0]).orElseThrow();
        this.currentState = stateAndObject.getSMGState();
        Truth.assertThat((Boolean)stateAndObject.getSMGObject().isSLL()).isFalse();
        Truth.assertThat((Boolean)(stateAndObject.getSMGObject() instanceof SMGSinglyLinkedListSegment)).isFalse();
        SMGCPAAbstractionManager absFinder = new SMGCPAAbstractionManager(this.currentState, 3);
        this.currentState = absFinder.findAndAbstractLists();
        SMGStateAndOptionalSMGObjectAndOffset stateAndObjectAfterAbstraction = this.currentState.dereferencePointerWithoutMaterilization(pointers[0]).orElseThrow();
        this.currentState = stateAndObjectAfterAbstraction.getSMGState();
        Truth.assertThat((Boolean)stateAndObjectAfterAbstraction.getSMGObject().isSLL()).isTrue();
        Truth.assertThat((Boolean)(((SMGSinglyLinkedListSegment)stateAndObjectAfterAbstraction.getSMGObject()).getMinLength() == 50 ? 1 : 0)).isTrue();
        Truth.assertThat((Boolean)this.currentState.readSMGValue(stateAndObjectAfterAbstraction.getSMGObject(), this.pointerSizeInBits, this.pointerSizeInBits).getSMGValue().isZero()).isTrue();
        Truth.assertThat((Boolean)stateAndObjectAfterAbstraction.getSMGObject().isSLL()).isTrue();
        Truth.assertThat((Boolean)(stateAndObjectAfterAbstraction.getOffsetForObject().compareTo(BigInteger.ZERO) == 0 ? 1 : 0)).isTrue();
        Truth.assertThat(this.currentState.getMemoryModel().getSmg().getObjects()).hasSize(100);
        int normalObjectCounter = 0;
        Boolean[] found = new Boolean[49];
        for (SMGObject object : this.currentState.getMemoryModel().getSmg().getObjects()) {
            if (object.isZero()) continue;
            if (!(object instanceof SMGSinglyLinkedListSegment)) {
                ++normalObjectCounter;
                Truth.assertThat((Boolean)this.currentState.getMemoryModel().getSmg().isValid(object)).isFalse();
                continue;
            }
            Truth.assertThat((Boolean)found[((SMGSinglyLinkedListSegment)object).getMinLength() - 2]).isNull();
            found[((SMGSinglyLinkedListSegment)object).getMinLength() - 2] = true;
            if (((SMGSinglyLinkedListSegment)object).getMinLength() == 50) {
                Truth.assertThat((Boolean)this.currentState.getMemoryModel().getSmg().isValid(object)).isTrue();
                continue;
            }
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().getSmg().isValid(object)).isFalse();
        }
        Truth.assertThat((Integer)normalObjectCounter).isEqualTo((Object)50);
        Boolean[] booleanArray = found;
        int object = booleanArray.length;
        for (int i = 0; i < object; ++i) {
            boolean f = booleanArray[i];
            Truth.assertThat((Boolean)f).isTrue();
        }
        Truth.assertThat(this.currentState.getMemoryModel().getHeapObjects()).hasSize(2);
        for (SMGObject heapObj : this.currentState.getMemoryModel().getHeapObjects()) {
            Truth.assertThat((Boolean)(heapObj.isZero() || heapObj instanceof SMGSinglyLinkedListSegment && ((SMGSinglyLinkedListSegment)heapObj).getMinLength() == 50 ? 1 : 0)).isTrue();
        }
    }

    @Test
    public void basicDLLFullAbstractionTest() throws SMG2Exception {
        int listSize = 100;
        Value[] pointers = this.buildConcreteList(true, this.pointerSizeInBits.multiply(BigInteger.valueOf(3L)), listSize);
        SMGStateAndOptionalSMGObjectAndOffset stateAndObject = this.currentState.dereferencePointerWithoutMaterilization(pointers[0]).orElseThrow();
        this.currentState = stateAndObject.getSMGState();
        Truth.assertThat((Boolean)stateAndObject.getSMGObject().isSLL()).isFalse();
        Truth.assertThat((Boolean)(stateAndObject.getSMGObject() instanceof SMGSinglyLinkedListSegment)).isFalse();
        SMGCPAAbstractionManager absFinder = new SMGCPAAbstractionManager(this.currentState, 3);
        this.currentState = absFinder.findAndAbstractLists();
        SMGStateAndOptionalSMGObjectAndOffset stateAndObjectAfterAbstraction = this.currentState.dereferencePointerWithoutMaterilization(pointers[0]).orElseThrow();
        this.currentState = stateAndObjectAfterAbstraction.getSMGState();
        Truth.assertThat((Boolean)stateAndObjectAfterAbstraction.getSMGObject().isSLL()).isFalse();
        Truth.assertThat((Boolean)(stateAndObjectAfterAbstraction.getSMGObject() instanceof SMGDoublyLinkedListSegment)).isTrue();
        Truth.assertThat((Boolean)(((SMGDoublyLinkedListSegment)stateAndObjectAfterAbstraction.getSMGObject()).getMinLength() == listSize ? 1 : 0)).isTrue();
        Truth.assertThat((Boolean)this.currentState.readSMGValue(stateAndObjectAfterAbstraction.getSMGObject(), this.pointerSizeInBits, this.pointerSizeInBits).getSMGValue().isZero()).isTrue();
        Truth.assertThat((Boolean)stateAndObjectAfterAbstraction.getSMGObject().isSLL()).isFalse();
        Truth.assertThat((Boolean)(stateAndObjectAfterAbstraction.getOffsetForObject().compareTo(BigInteger.ZERO) == 0 ? 1 : 0)).isTrue();
        Truth.assertThat((Boolean)this.currentState.readSMGValue(stateAndObjectAfterAbstraction.getSMGObject(), this.pointerSizeInBits.add(this.pointerSizeInBits), this.pointerSizeInBits).getSMGValue().isZero()).isTrue();
    }

    @Test
    public void basicSLLFullAbstractionWithExternalPointerTest() throws SMG2Exception {
        Value[] pointers = this.buildConcreteList(false, this.pointerSizeInBits.multiply(BigInteger.valueOf(2L)), 50);
        SMGStateAndOptionalSMGObjectAndOffset stateAndObject = this.currentState.dereferencePointerWithoutMaterilization(pointers[0]).orElseThrow();
        this.currentState = stateAndObject.getSMGState();
        Truth.assertThat((Boolean)stateAndObject.getSMGObject().isSLL()).isFalse();
        Truth.assertThat((Boolean)(stateAndObject.getSMGObject() instanceof SMGSinglyLinkedListSegment)).isFalse();
        SMGCPAAbstractionManager absFinder = new SMGCPAAbstractionManager(this.currentState, 3);
        this.currentState = absFinder.findAndAbstractLists();
        SMGStateAndOptionalSMGObjectAndOffset stateAndObjectAfterAbstraction = this.currentState.dereferencePointerWithoutMaterilization(pointers[0]).orElseThrow();
        this.currentState = stateAndObjectAfterAbstraction.getSMGState();
        Truth.assertThat((Boolean)stateAndObjectAfterAbstraction.getSMGObject().isSLL()).isTrue();
        Truth.assertThat((Boolean)(((SMGSinglyLinkedListSegment)stateAndObjectAfterAbstraction.getSMGObject()).getMinLength() == 50 ? 1 : 0)).isTrue();
        Truth.assertThat((Boolean)this.currentState.readSMGValue(stateAndObjectAfterAbstraction.getSMGObject(), this.pointerSizeInBits, this.pointerSizeInBits).getSMGValue().isZero()).isTrue();
        Truth.assertThat((Boolean)stateAndObjectAfterAbstraction.getSMGObject().isSLL()).isTrue();
        Truth.assertThat((Boolean)(stateAndObjectAfterAbstraction.getOffsetForObject().compareTo(BigInteger.ZERO) == 0 ? 1 : 0)).isTrue();
        int level = 49;
        for (Value pointer : pointers) {
            Optional<SMGStateAndOptionalSMGObjectAndOffset> maybeTarget = this.currentState.dereferencePointerWithoutMaterilization(pointer);
            Truth.assertThat((Boolean)maybeTarget.isPresent()).isTrue();
            SMGStateAndOptionalSMGObjectAndOffset targetAndState = maybeTarget.orElseThrow();
            Truth.assertThat((Boolean)targetAndState.getSMGObject().equals(stateAndObjectAfterAbstraction.getSMGObject())).isTrue();
            SMGValue smgValue = this.currentState.getMemoryModel().getSMGValueFromValue(pointer).orElseThrow();
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().getSmg().getPTEdge(smgValue).isPresent()).isTrue();
            for (SMGValue pteMapping : this.currentState.getMemoryModel().getSmg().getPTEdgeMapping().keySet()) {
                if (!pteMapping.equals(smgValue)) continue;
                Truth.assertThat((Integer)pteMapping.getNestingLevel()).isEqualTo((Object)level);
            }
            --level;
        }
    }

    @Test
    public void basicDLLFullAbstractionWithExternalPointerTest() throws SMG2Exception {
        int minAbstractionLength = 3;
        Value[] pointers = this.buildConcreteList(true, this.dllSize, 50);
        SMGStateAndOptionalSMGObjectAndOffset stateAndObject = this.currentState.dereferencePointerWithoutMaterilization(pointers[0]).orElseThrow();
        this.currentState = stateAndObject.getSMGState();
        Truth.assertThat((Boolean)stateAndObject.getSMGObject().isSLL()).isFalse();
        Truth.assertThat((Boolean)(stateAndObject.getSMGObject() instanceof SMGSinglyLinkedListSegment)).isFalse();
        SMGCPAAbstractionManager absFinder = new SMGCPAAbstractionManager(this.currentState, minAbstractionLength);
        this.currentState = absFinder.findAndAbstractLists();
        SMGStateAndOptionalSMGObjectAndOffset stateAndObjectAfterAbstraction = this.currentState.dereferencePointerWithoutMaterilization(pointers[0]).orElseThrow();
        this.currentState = stateAndObjectAfterAbstraction.getSMGState();
        Truth.assertThat((Boolean)stateAndObjectAfterAbstraction.getSMGObject().isSLL()).isFalse();
        Truth.assertThat((Boolean)(stateAndObjectAfterAbstraction.getSMGObject() instanceof SMGDoublyLinkedListSegment)).isTrue();
        Truth.assertThat((Boolean)(((SMGDoublyLinkedListSegment)stateAndObjectAfterAbstraction.getSMGObject()).getMinLength() == 50 ? 1 : 0)).isTrue();
        Truth.assertThat((Boolean)this.currentState.readSMGValue(stateAndObjectAfterAbstraction.getSMGObject(), this.pointerSizeInBits, this.pointerSizeInBits).getSMGValue().isZero()).isTrue();
        Truth.assertThat((Boolean)stateAndObjectAfterAbstraction.getSMGObject().isSLL()).isFalse();
        Truth.assertThat((Boolean)(stateAndObjectAfterAbstraction.getOffsetForObject().compareTo(BigInteger.ZERO) == 0 ? 1 : 0)).isTrue();
        Truth.assertThat((Boolean)this.currentState.readSMGValue(stateAndObjectAfterAbstraction.getSMGObject(), this.pointerSizeInBits.add(this.pointerSizeInBits), this.pointerSizeInBits).getSMGValue().isZero()).isTrue();
        int level = 49;
        for (Value pointer : pointers) {
            Optional<SMGStateAndOptionalSMGObjectAndOffset> maybeTarget = this.currentState.dereferencePointerWithoutMaterilization(pointer);
            Truth.assertThat((Boolean)maybeTarget.isPresent()).isTrue();
            SMGStateAndOptionalSMGObjectAndOffset targetAndState = maybeTarget.orElseThrow();
            Truth.assertThat((Boolean)targetAndState.getSMGObject().equals(stateAndObjectAfterAbstraction.getSMGObject())).isTrue();
            SMGValue smgValue = this.currentState.getMemoryModel().getSMGValueFromValue(pointer).orElseThrow();
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().getSmg().getPTEdge(smgValue).isPresent()).isTrue();
            for (SMGValue pteMapping : this.currentState.getMemoryModel().getSmg().getPTEdgeMapping().keySet()) {
                if (!pteMapping.equals(smgValue)) continue;
                Truth.assertThat((Integer)pteMapping.getNestingLevel()).isEqualTo((Object)level);
            }
            --level;
        }
    }

    @Test
    public void basicDLLFullAbstractionWithExternalPointerMaterializationTest() throws SMG2Exception {
        int listSize = 100;
        Value[] pointers = this.buildConcreteList(true, this.pointerSizeInBits.multiply(BigInteger.valueOf(3L)), listSize);
        SMGStateAndOptionalSMGObjectAndOffset stateAndObject = this.currentState.dereferencePointerWithoutMaterilization(pointers[0]).orElseThrow();
        this.currentState = stateAndObject.getSMGState();
        Truth.assertThat((Boolean)stateAndObject.getSMGObject().isSLL()).isFalse();
        Truth.assertThat((Boolean)(stateAndObject.getSMGObject() instanceof SMGSinglyLinkedListSegment)).isFalse();
        SMGCPAAbstractionManager absFinder = new SMGCPAAbstractionManager(this.currentState, 3);
        this.currentState = absFinder.findAndAbstractLists();
        for (int i = 0; i < listSize; ++i) {
            SMGStateAndOptionalSMGObjectAndOffset returnedObjAndState = this.currentState.dereferencePointer(pointers[i]).get(0);
            this.currentState = returnedObjAndState.getSMGState();
            SMGObject newObj = returnedObjAndState.getSMGObject();
            Truth.assertThat((Boolean)(!(newObj instanceof SMGSinglyLinkedListSegment) ? 1 : 0)).isTrue();
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().isObjectValid(newObj)).isTrue();
            ValueAndSMGState nextPointerAndState = this.currentState.readValue(newObj, this.pointerSizeInBits, this.pointerSizeInBits, null).get(0);
            this.currentState = nextPointerAndState.getState();
            for (Map.Entry<SMGValue, SMGPointsToEdge> entry : this.currentState.getMemoryModel().getSmg().getPTEdgeMapping().entrySet()) {
                if (!entry.getValue().pointsTo().equals(newObj)) continue;
                Truth.assertThat((Integer)entry.getKey().getNestingLevel()).isEqualTo((Object)0);
            }
            Value nextPointer = nextPointerAndState.getValue();
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().isPointer(nextPointer)).isTrue();
            if (i == listSize - 1) {
                Map.Entry<SMGValue, SMGPointsToEdge> entry;
                Truth.assertThat((Boolean)(nextPointer.asNumericValue().bigInteger().compareTo(BigInteger.ZERO) == 0 ? 1 : 0)).isTrue();
                entry = this.currentState.getMemoryModel().getSmg().getPTEdgeMapping().entrySet().iterator();
                while (entry.hasNext()) {
                    Map.Entry entry2 = (Map.Entry)entry.next();
                    if (!((SMGPointsToEdge)entry2.getValue()).pointsTo().equals(SMGObject.nullInstance())) continue;
                    Truth.assertThat((Integer)((SMGValue)entry2.getKey()).getNestingLevel()).isEqualTo((Object)0);
                }
                continue;
            }
            Optional<SMGStateAndOptionalSMGObjectAndOffset> maybeNextObj = this.currentState.dereferencePointerWithoutMaterilization(nextPointer);
            Truth.assertThat((Boolean)maybeNextObj.isPresent()).isTrue();
            SMGStateAndOptionalSMGObjectAndOffset nextObjAndState = maybeNextObj.orElseThrow();
            this.currentState = nextObjAndState.getSMGState();
            SMGObject nextObj = nextObjAndState.getSMGObject();
            Truth.assertThat((Boolean)(nextObj instanceof SMGDoublyLinkedListSegment)).isTrue();
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().isObjectValid(nextObj)).isTrue();
            Truth.assertThat((Integer)((SMGDoublyLinkedListSegment)nextObj).getMinLength()).isEqualTo((Object)(listSize - i - 1));
            for (Map.Entry<SMGValue, SMGPointsToEdge> entry : this.currentState.getMemoryModel().getSmg().getPTEdgeMapping().entrySet()) {
                if (!entry.getValue().pointsTo().equals(nextObj)) continue;
                Truth.assertThat((Integer)entry.getKey().getNestingLevel()).isLessThan((Comparable)Integer.valueOf(listSize - i - 1));
            }
            SMGStateAndOptionalSMGObjectAndOffset nextObjAndStateFromExternalPointer = this.currentState.dereferencePointerWithoutMaterilization(pointers[i + 1]).orElseThrow();
            this.currentState = nextObjAndStateFromExternalPointer.getSMGState();
            SMGObject newObjFromExternalPointer = nextObjAndStateFromExternalPointer.getSMGObject();
            Truth.assertThat((Boolean)(newObjFromExternalPointer instanceof SMGDoublyLinkedListSegment)).isTrue();
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().isObjectValid(newObjFromExternalPointer)).isTrue();
            Truth.assertThat((Integer)((SMGDoublyLinkedListSegment)newObjFromExternalPointer).getMinLength()).isEqualTo((Object)(listSize - (i + 1)));
            for (Map.Entry<SMGValue, SMGPointsToEdge> entry : this.currentState.getMemoryModel().getSmg().getPTEdgeMapping().entrySet()) {
                if (!entry.getValue().pointsTo().equals(newObjFromExternalPointer)) continue;
                Truth.assertThat((Integer)entry.getKey().getNestingLevel()).isLessThan((Comparable)Integer.valueOf(listSize - i - 1));
            }
            Truth.assertThat((Comparable)nextObj).isEqualTo((Object)newObjFromExternalPointer);
        }
    }

    @Test
    public void basicSLLFullAbstractionWithExternalPointerMaterializationTest() throws SMG2Exception {
        Value[] pointers = this.buildConcreteList(false, this.sllSize, 50);
        SMGStateAndOptionalSMGObjectAndOffset stateAndObject = this.currentState.dereferencePointerWithoutMaterilization(pointers[0]).orElseThrow();
        this.currentState = stateAndObject.getSMGState();
        Truth.assertThat((Boolean)stateAndObject.getSMGObject().isSLL()).isFalse();
        Truth.assertThat((Boolean)(stateAndObject.getSMGObject() instanceof SMGSinglyLinkedListSegment)).isFalse();
        SMGCPAAbstractionManager absFinder = new SMGCPAAbstractionManager(this.currentState, 3);
        this.currentState = absFinder.findAndAbstractLists();
        for (int i = 0; i < 50; ++i) {
            SMGStateAndOptionalSMGObjectAndOffset returnedObjAndState = this.currentState.dereferencePointer(pointers[i]).get(0);
            this.currentState = returnedObjAndState.getSMGState();
            SMGObject newObj = returnedObjAndState.getSMGObject();
            Truth.assertThat((Boolean)(!(newObj instanceof SMGSinglyLinkedListSegment) ? 1 : 0)).isTrue();
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().isObjectValid(newObj)).isTrue();
            ValueAndSMGState nextPointerAndState = this.currentState.readValue(newObj, this.pointerSizeInBits, this.pointerSizeInBits, null).get(0);
            this.currentState = nextPointerAndState.getState();
            for (Map.Entry<SMGValue, SMGPointsToEdge> entry : this.currentState.getMemoryModel().getSmg().getPTEdgeMapping().entrySet()) {
                if (!entry.getValue().pointsTo().equals(newObj)) continue;
                Truth.assertThat((Integer)entry.getKey().getNestingLevel()).isEqualTo((Object)0);
            }
            Value nextPointer = nextPointerAndState.getValue();
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().isPointer(nextPointer)).isTrue();
            if (i == 49) {
                Map.Entry<SMGValue, SMGPointsToEdge> entry;
                Truth.assertThat((Boolean)(nextPointer.asNumericValue().bigInteger().compareTo(BigInteger.ZERO) == 0 ? 1 : 0)).isTrue();
                entry = this.currentState.getMemoryModel().getSmg().getPTEdgeMapping().entrySet().iterator();
                while (entry.hasNext()) {
                    Map.Entry entry2 = (Map.Entry)entry.next();
                    if (!((SMGPointsToEdge)entry2.getValue()).pointsTo().equals(SMGObject.nullInstance())) continue;
                    Truth.assertThat((Integer)((SMGValue)entry2.getKey()).getNestingLevel()).isEqualTo((Object)0);
                }
                continue;
            }
            Optional<SMGStateAndOptionalSMGObjectAndOffset> maybeNextObj = this.currentState.dereferencePointerWithoutMaterilization(nextPointer);
            Truth.assertThat((Boolean)maybeNextObj.isPresent()).isTrue();
            SMGStateAndOptionalSMGObjectAndOffset nextObjAndState = maybeNextObj.orElseThrow();
            this.currentState = nextObjAndState.getSMGState();
            SMGObject nextObj = nextObjAndState.getSMGObject();
            Truth.assertThat((Boolean)(nextObj instanceof SMGSinglyLinkedListSegment)).isTrue();
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().isObjectValid(nextObj)).isTrue();
            Truth.assertThat((Integer)((SMGSinglyLinkedListSegment)nextObj).getMinLength()).isEqualTo((Object)(50 - i - 1));
            for (Map.Entry<SMGValue, SMGPointsToEdge> entry : this.currentState.getMemoryModel().getSmg().getPTEdgeMapping().entrySet()) {
                if (!entry.getValue().pointsTo().equals(nextObj)) continue;
                Truth.assertThat((Integer)entry.getKey().getNestingLevel()).isLessThan((Comparable)Integer.valueOf(50 - i));
            }
            SMGStateAndOptionalSMGObjectAndOffset nextObjAndStateFromExternalPointer = this.currentState.dereferencePointerWithoutMaterilization(pointers[i + 1]).orElseThrow();
            this.currentState = nextObjAndStateFromExternalPointer.getSMGState();
            SMGObject newObjFromExternalPointer = nextObjAndStateFromExternalPointer.getSMGObject();
            Truth.assertThat((Boolean)(newObjFromExternalPointer instanceof SMGSinglyLinkedListSegment)).isTrue();
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().isObjectValid(newObjFromExternalPointer)).isTrue();
            Truth.assertThat((Integer)((SMGSinglyLinkedListSegment)newObjFromExternalPointer).getMinLength()).isEqualTo((Object)(50 - (i + 1)));
            for (Map.Entry<SMGValue, SMGPointsToEdge> entry : this.currentState.getMemoryModel().getSmg().getPTEdgeMapping().entrySet()) {
                if (!entry.getValue().pointsTo().equals(newObjFromExternalPointer)) continue;
                Truth.assertThat((Integer)entry.getKey().getNestingLevel()).isLessThan((Comparable)Integer.valueOf(50 - i - 1));
            }
            Truth.assertThat((Comparable)nextObj).isEqualTo((Object)newObjFromExternalPointer);
        }
    }

    @Test
    public void basicDLLMaterializationTest() throws SMG2Exception {
        BigInteger offset = BigInteger.ZERO;
        SMGDoublyLinkedListSegment currentAbstraction = new SMGDoublyLinkedListSegment(0, this.dllSize, offset, this.hfo, this.nfo, this.pfo, 50);
        this.currentState = this.currentState.copyAndAddObjectToHeap(currentAbstraction);
        this.currentState = this.currentState.writeValueTo(currentAbstraction, this.hfo, this.pointerSizeInBits, (Value)new NumericValue(1), null);
        this.currentState = this.currentState.writeValueTo(currentAbstraction, this.nfo, this.pointerSizeInBits, (Value)new NumericValue(0), null);
        this.currentState = this.currentState.writeValueTo(currentAbstraction, this.pfo, this.pointerSizeInBits, (Value)new NumericValue(0), null);
        SymbolicIdentifier pointer = SymbolicValueFactory.getInstance().newIdentifier(null);
        this.currentState = this.currentState.createAndAddPointer(pointer, currentAbstraction, BigInteger.ZERO);
        this.currentState = this.currentState.copyAndReplaceMemoryModel(this.currentState.getMemoryModel().replaceSMGValueNestingLevel(this.currentState.getMemoryModel().getSMGValueFromValue(pointer).orElseThrow(), 49));
        SMGValue pointerToFirst = this.currentState.getMemoryModel().getSMGValueFromValue(pointer).orElseThrow();
        SMGObject[] previous = new SMGObject[50];
        for (int i = 0; i < 50; ++i) {
            SMGStateAndOptionalSMGObjectAndOffset targetAndOffset;
            List<SMGValueAndSMGState> resultValuesAndStates = this.materializer.handleMaterilisation(pointerToFirst, currentAbstraction, this.currentState);
            Truth.assertThat(resultValuesAndStates).hasSize(1);
            SMGValueAndSMGState resultValueAndState = resultValuesAndStates.get(0);
            this.currentState = resultValueAndState.getSMGState();
            Truth.assertThat((Boolean)(this.currentState.getMemoryModel().getHeapObjects().size() == i + 3 ? 1 : 0)).isTrue();
            Value currentPointer = this.currentState.getMemoryModel().getValueFromSMGValue(resultValueAndState.getSMGValue()).orElseThrow();
            if (i == 49) {
                Optional<SMGStateAndOptionalSMGObjectAndOffset> object = this.currentState.dereferencePointerWithoutMaterilization(currentPointer);
                Truth.assertThat((Boolean)object.isPresent()).isTrue();
                Truth.assertThat((Boolean)(object.orElseThrow().getSMGObject().getSize().compareTo(this.dllSize) == 0 ? 1 : 0)).isTrue();
                ValueAndSMGState nextPointer = this.currentState.readValue(object.orElseThrow().getSMGObject(), this.nfo, this.pointerSizeInBits, null).get(0);
                Truth.assertThat((Boolean)nextPointer.getValue().isNumericValue()).isTrue();
                Truth.assertThat((Boolean)(nextPointer.getValue().asNumericValue().bigInteger().compareTo(BigInteger.ZERO) == 0 ? 1 : 0)).isTrue();
                break;
            }
            if (i == 0) {
                Truth.assertThat((Boolean)currentPointer.equals(pointer)).isTrue();
            }
            Truth.assertThat((Boolean)((targetAndOffset = resultValueAndState.getSMGState().dereferencePointerWithoutMaterilization(currentPointer).orElseThrow()).getOffsetForObject().compareTo(BigInteger.ZERO) == 0 ? 1 : 0)).isTrue();
            SMGObject newObj = targetAndOffset.getSMGObject();
            SMGValueAndSMGState headAndState = this.currentState.readSMGValue(newObj, BigInteger.ZERO, this.pointerSizeInBits);
            this.currentState = headAndState.getSMGState();
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().getValueFromSMGValue(headAndState.getSMGValue()).isPresent()).isTrue();
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().getValueFromSMGValue(headAndState.getSMGValue()).orElseThrow().isNumericValue()).isTrue();
            Truth.assertThat((Boolean)(this.currentState.getMemoryModel().getValueFromSMGValue(headAndState.getSMGValue()).orElseThrow().asNumericValue().bigInteger().compareTo(BigInteger.ONE) == 0 ? 1 : 0)).isTrue();
            SMGStateAndOptionalSMGObjectAndOffset prevObjAndOffset = resultValueAndState.getSMGState().dereferencePointerWithoutMaterilization(this.currentState.getMemoryModel().getValueFromSMGValue(pointerToFirst).orElseThrow()).orElseThrow();
            SMGValueAndSMGState nextPointerAndState = this.currentState.readSMGValue(newObj, this.pointerSizeInBits, this.pointerSizeInBits);
            this.currentState = nextPointerAndState.getSMGState();
            SMGValueAndSMGState prevPointerAndState = this.currentState.readSMGValue(newObj, this.pfo, this.pointerSizeInBits);
            this.currentState = prevPointerAndState.getSMGState();
            SMGValue prevPointer = prevPointerAndState.getSMGValue();
            pointerToFirst = nextPointerAndState.getSMGValue();
            SMGStateAndOptionalSMGObjectAndOffset prevObjFromPrevPointerAndOffset = resultValueAndState.getSMGState().dereferencePointerWithoutMaterilization(this.currentState.getMemoryModel().getValueFromSMGValue(prevPointer).orElseThrow()).orElseThrow();
            if (i == 0) {
                Truth.assertThat((Boolean)prevObjFromPrevPointerAndOffset.getSMGObject().isZero()).isTrue();
                previous[i] = prevObjAndOffset.getSMGObject();
            } else {
                previous[i] = prevObjAndOffset.getSMGObject();
                Truth.assertThat((Boolean)previous[i - 1].equals(prevObjFromPrevPointerAndOffset.getSMGObject())).isTrue();
            }
            SMGStateAndOptionalSMGObjectAndOffset targetToNextAndOffset = resultValueAndState.getSMGState().dereferencePointerWithoutMaterilization(this.currentState.getMemoryModel().getValueFromSMGValue(pointerToFirst).orElseThrow()).orElseThrow();
            Truth.assertThat((Boolean)(targetToNextAndOffset.getSMGObject() instanceof SMGSinglyLinkedListSegment)).isTrue();
            currentAbstraction = (SMGDoublyLinkedListSegment)targetToNextAndOffset.getSMGObject();
        }
    }

    @Test
    public void basicSLLMaterializationTest() throws SMG2Exception {
        BigInteger offset = BigInteger.ZERO;
        SMGSinglyLinkedListSegment currentAbstraction = new SMGSinglyLinkedListSegment(0, this.sllSize, offset, this.hfo, this.nfo, 50);
        this.currentState = this.currentState.copyAndAddObjectToHeap(currentAbstraction);
        this.currentState = this.currentState.writeValueTo(currentAbstraction, this.hfo, this.pointerSizeInBits, (Value)new NumericValue(1), null);
        this.currentState = this.currentState.writeValueTo(currentAbstraction, this.nfo, this.pointerSizeInBits, (Value)new NumericValue(0), null);
        SymbolicIdentifier pointer = SymbolicValueFactory.getInstance().newIdentifier(null);
        this.currentState = this.currentState.createAndAddPointer(pointer, currentAbstraction, BigInteger.ZERO);
        this.currentState = this.currentState.copyAndReplaceMemoryModel(this.currentState.getMemoryModel().replaceSMGValueNestingLevel(this.currentState.getMemoryModel().getSMGValueFromValue(pointer).orElseThrow(), 49));
        SMGValue pointerToFirst = this.currentState.getMemoryModel().getSMGValueFromValue(pointer).orElseThrow();
        for (int i = 0; i < 50; ++i) {
            SMGStateAndOptionalSMGObjectAndOffset targetAndOffset;
            List<SMGValueAndSMGState> resultValuesAndStates = this.materializer.handleMaterilisation(pointerToFirst, currentAbstraction, this.currentState);
            Truth.assertThat(resultValuesAndStates).hasSize(1);
            SMGValueAndSMGState resultValueAndState = resultValuesAndStates.get(0);
            this.currentState = resultValueAndState.getSMGState();
            Truth.assertThat((Boolean)(this.currentState.getMemoryModel().getHeapObjects().size() == i + 3 ? 1 : 0)).isTrue();
            Value currentPointer = this.currentState.getMemoryModel().getValueFromSMGValue(resultValueAndState.getSMGValue()).orElseThrow();
            if (i == 49) {
                Optional<SMGStateAndOptionalSMGObjectAndOffset> object = this.currentState.dereferencePointerWithoutMaterilization(currentPointer);
                Truth.assertThat((Boolean)object.isPresent()).isTrue();
                Truth.assertThat((Boolean)(object.orElseThrow().getSMGObject().getSize().compareTo(this.sllSize) == 0 ? 1 : 0)).isTrue();
                ValueAndSMGState nextPointer = this.currentState.readValue(object.orElseThrow().getSMGObject(), this.nfo, this.pointerSizeInBits, null).get(0);
                Truth.assertThat((Boolean)nextPointer.getValue().isNumericValue()).isTrue();
                Truth.assertThat((Boolean)(nextPointer.getValue().asNumericValue().bigInteger().compareTo(BigInteger.ZERO) == 0 ? 1 : 0)).isTrue();
                break;
            }
            if (i == 0) {
                Truth.assertThat((Boolean)currentPointer.equals(pointer)).isTrue();
            }
            Truth.assertThat((Boolean)((targetAndOffset = resultValueAndState.getSMGState().dereferencePointerWithoutMaterilization(currentPointer).orElseThrow()).getOffsetForObject().compareTo(BigInteger.ZERO) == 0 ? 1 : 0)).isTrue();
            SMGObject newObj = targetAndOffset.getSMGObject();
            SMGValueAndSMGState headAndState = this.currentState.readSMGValue(newObj, BigInteger.ZERO, this.pointerSizeInBits);
            this.currentState = headAndState.getSMGState();
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().getValueFromSMGValue(headAndState.getSMGValue()).isPresent()).isTrue();
            Truth.assertThat((Boolean)this.currentState.getMemoryModel().getValueFromSMGValue(headAndState.getSMGValue()).orElseThrow().isNumericValue()).isTrue();
            Truth.assertThat((Boolean)(this.currentState.getMemoryModel().getValueFromSMGValue(headAndState.getSMGValue()).orElseThrow().asNumericValue().bigInteger().compareTo(BigInteger.ONE) == 0 ? 1 : 0)).isTrue();
            SMGValueAndSMGState nextPointerAndState = this.currentState.readSMGValue(newObj, this.pointerSizeInBits, this.pointerSizeInBits);
            this.currentState = nextPointerAndState.getSMGState();
            pointerToFirst = nextPointerAndState.getSMGValue();
            SMGStateAndOptionalSMGObjectAndOffset targetToNextAndOffset = resultValueAndState.getSMGState().dereferencePointerWithoutMaterilization(this.currentState.getMemoryModel().getValueFromSMGValue(pointerToFirst).orElseThrow()).orElseThrow();
            Truth.assertThat((Boolean)(targetToNextAndOffset.getSMGObject() instanceof SMGSinglyLinkedListSegment)).isTrue();
            currentAbstraction = (SMGSinglyLinkedListSegment)targetToNextAndOffset.getSMGObject();
        }
    }

    @Test
    public void basicSLLDetectionTest() throws SMG2Exception, InvalidConfigurationException {
        int minAbstractionLength = 3;
        for (int i = 1; i < 50; ++i) {
            this.resetSMGStateAndVisitor();
            SMGState state = this.createXLongExplicitSLLOnHeap(i);
            SMGCPAAbstractionManager absFinder = new SMGCPAAbstractionManager(state, minAbstractionLength);
            ImmutableList<SMGCPAAbstractionManager.SMGCandidate> candidates = absFinder.getRefinedLinkedCandidates();
            if (i > minAbstractionLength - 1) {
                Truth.assertThat(candidates).hasSize(1);
                Truth.assertThat((Boolean)absFinder.isDLL((SMGCPAAbstractionManager.SMGCandidate)candidates.iterator().next(), state.getMemoryModel().getSmg()).isEmpty()).isTrue();
                continue;
            }
            Truth.assertThat(candidates).hasSize(0);
        }
    }

    @Test
    public void basicDLLDetectionTest() throws SMG2Exception, InvalidConfigurationException {
        int minAbstractionLength = 3;
        for (int i = 1; i < 50; ++i) {
            this.resetSMGStateAndVisitor();
            SMGState state = this.createXLongExplicitDLLOnHeap(i);
            SMGCPAAbstractionManager absFinder = new SMGCPAAbstractionManager(state, minAbstractionLength);
            ImmutableList<SMGCPAAbstractionManager.SMGCandidate> candidates = absFinder.getRefinedLinkedCandidates();
            if (i > minAbstractionLength - 1) {
                Truth.assertThat(candidates).hasSize(1);
                SMGCPAAbstractionManager.SMGCandidate candidate = (SMGCPAAbstractionManager.SMGCandidate)candidates.iterator().next();
                Optional<BigInteger> maybePfo = absFinder.isDLL(candidate, state.getMemoryModel().getSmg());
                Truth.assertThat((Boolean)maybePfo.isPresent()).isTrue();
                Truth.assertThat((Boolean)(maybePfo.orElseThrow().compareTo(this.pointerSizeInBits.add(this.pointerSizeInBits)) == 0 ? 1 : 0)).isTrue();
                continue;
            }
            Truth.assertThat(candidates).hasSize(0);
        }
    }

    @Test
    public void abstractSLLTest() throws InvalidConfigurationException, SMG2Exception {
        int minAbstractionLength = 3;
        for (int i = 1; i < 50; ++i) {
            this.resetSMGStateAndVisitor();
            SMGState state = this.createXLongExplicitSLLOnHeap(i);
            SMGCPAAbstractionManager absFinder = new SMGCPAAbstractionManager(state, minAbstractionLength);
            ImmutableList<SMGCPAAbstractionManager.SMGCandidate> candidates = absFinder.getRefinedLinkedCandidates();
            if (i < minAbstractionLength) continue;
            SMGCPAAbstractionManager.SMGCandidate firstObj = (SMGCPAAbstractionManager.SMGCandidate)candidates.iterator().next();
            Truth.assertThat((Comparable)firstObj.getSuspectedNfo()).isEquivalentAccordingToCompareTo((Comparable)this.nfo);
            state = state.abstractIntoSLL(firstObj.getObject(), this.nfo, (Set<SMGObject>)ImmutableSet.of());
            Set<SMGObject> objects = state.getMemoryModel().getSmg().getObjects();
            SMGSinglyLinkedListSegment sll = null;
            for (SMGObject object : objects) {
                if (object instanceof SMGSinglyLinkedListSegment && state.getMemoryModel().isObjectValid(object)) {
                    Truth.assertThat((Boolean)(sll == null ? 1 : 0)).isTrue();
                    sll = (SMGSinglyLinkedListSegment)object;
                    continue;
                }
                Truth.assertThat((Boolean)(!state.getMemoryModel().isObjectValid(object) ? 1 : 0)).isTrue();
            }
            Truth.assertThat((Boolean)(sll.getMinLength() == i ? 1 : 0)).isTrue();
            Truth.assertThat((Boolean)(sll.getNextOffset().compareTo(this.nfo) == 0 ? 1 : 0)).isTrue();
            Truth.assertThat((Boolean)(sll.getSize().compareTo(this.sllSize) == 0 ? 1 : 0)).isTrue();
        }
    }

    @Test
    public void abstractDLLTest() throws InvalidConfigurationException, SMG2Exception {
        int minAbstractionLength = 3;
        for (int i = 1; i < 50; ++i) {
            this.resetSMGStateAndVisitor();
            SMGState state = this.createXLongExplicitDLLOnHeap(i);
            SMGCPAAbstractionManager absFinder = new SMGCPAAbstractionManager(state, minAbstractionLength);
            ImmutableList<SMGCPAAbstractionManager.SMGCandidate> candidates = absFinder.getRefinedLinkedCandidates();
            if (i < minAbstractionLength) continue;
            SMGCPAAbstractionManager.SMGCandidate firstObj = (SMGCPAAbstractionManager.SMGCandidate)candidates.iterator().next();
            Truth.assertThat((Comparable)firstObj.getSuspectedNfo()).isEquivalentAccordingToCompareTo((Comparable)this.nfo);
            state = state.abstractIntoDLL(firstObj.getObject(), this.nfo, this.pfo, (Set<SMGObject>)ImmutableSet.of());
            Set<SMGObject> objects = state.getMemoryModel().getSmg().getObjects();
            SMGSinglyLinkedListSegment dll = null;
            for (SMGObject object : objects) {
                if (object instanceof SMGDoublyLinkedListSegment && state.getMemoryModel().isObjectValid(object)) {
                    Truth.assertThat((Boolean)(dll == null ? 1 : 0)).isTrue();
                    dll = (SMGDoublyLinkedListSegment)object;
                    continue;
                }
                Truth.assertThat((Boolean)(!state.getMemoryModel().isObjectValid(object) ? 1 : 0)).isTrue();
            }
            Truth.assertThat((Boolean)(dll.getMinLength() == i ? 1 : 0)).isTrue();
            Truth.assertThat((Boolean)(dll.getNextOffset().compareTo(this.nfo) == 0 ? 1 : 0)).isTrue();
            Truth.assertThat((Boolean)(((SMGDoublyLinkedListSegment)dll).getPrevOffset().compareTo(this.pfo) == 0 ? 1 : 0)).isTrue();
            Truth.assertThat((Boolean)(dll.getSize().compareTo(this.dllSize) == 0 ? 1 : 0)).isTrue();
            Truth.assertThat((Boolean)state.readSMGValue(dll, this.pfo, this.pointerSizeInBits).getSMGValue().isZero()).isTrue();
            Truth.assertThat((Boolean)state.readSMGValue(dll, this.nfo, this.pointerSizeInBits).getSMGValue().isZero()).isTrue();
        }
    }

    @Test
    public void abstractDLLLimitTest() throws InvalidConfigurationException, SMG2Exception {
        int minAbstractionLength;
        for (int minLength = minAbstractionLength = 3; minLength < 50; minLength += 10) {
            for (int i = 1; i < 50; ++i) {
                this.resetSMGStateAndVisitor();
                SMGState state = this.createXLongExplicitDLLOnHeap(i);
                SMGCPAAbstractionManager absFinder = new SMGCPAAbstractionManager(state, minLength);
                ImmutableList<SMGCPAAbstractionManager.SMGCandidate> candidates = absFinder.getRefinedLinkedCandidates();
                if (i < minLength) {
                    Truth.assertThat((Boolean)candidates.isEmpty()).isTrue();
                    continue;
                }
                SMGCPAAbstractionManager.SMGCandidate firstObj = (SMGCPAAbstractionManager.SMGCandidate)candidates.iterator().next();
                Truth.assertThat((Comparable)firstObj.getSuspectedNfo()).isEquivalentAccordingToCompareTo((Comparable)this.nfo);
                state = state.abstractIntoDLL(firstObj.getObject(), this.nfo, this.pfo, (Set<SMGObject>)ImmutableSet.of());
                Set<SMGObject> objects = state.getMemoryModel().getSmg().getObjects();
                SMGSinglyLinkedListSegment dll = null;
                for (SMGObject object : objects) {
                    if (object instanceof SMGDoublyLinkedListSegment && state.getMemoryModel().isObjectValid(object)) {
                        Truth.assertThat((Boolean)(dll == null ? 1 : 0)).isTrue();
                        dll = (SMGDoublyLinkedListSegment)object;
                        continue;
                    }
                    Truth.assertThat((Boolean)(!state.getMemoryModel().isObjectValid(object) ? 1 : 0)).isTrue();
                }
                Truth.assertThat((Boolean)(dll.getMinLength() == i ? 1 : 0)).isTrue();
                Truth.assertThat((Boolean)(dll.getNextOffset().compareTo(this.nfo) == 0 ? 1 : 0)).isTrue();
                Truth.assertThat((Boolean)(((SMGDoublyLinkedListSegment)dll).getPrevOffset().compareTo(this.pfo) == 0 ? 1 : 0)).isTrue();
                Truth.assertThat((Boolean)(dll.getSize().compareTo(this.dllSize) == 0 ? 1 : 0)).isTrue();
                Truth.assertThat((Boolean)state.readSMGValue(dll, this.pfo, this.pointerSizeInBits).getSMGValue().isZero()).isTrue();
                Truth.assertThat((Boolean)state.readSMGValue(dll, this.nfo, this.pointerSizeInBits).getSMGValue().isZero()).isTrue();
            }
        }
    }

    private SMGState createXLongExplicitDLLOnHeap(int length) throws SMG2Exception {
        BigInteger offset = BigInteger.ZERO;
        SMGDoublyLinkedListSegment currentAbstraction = new SMGDoublyLinkedListSegment(0, this.dllSize, offset, this.hfo, this.nfo, this.pfo, length);
        this.currentState = this.currentState.copyAndAddObjectToHeap(currentAbstraction);
        this.currentState = this.currentState.writeValueTo(currentAbstraction, this.hfo, this.pointerSizeInBits, (Value)new NumericValue(1), null);
        this.currentState = this.currentState.writeValueTo(currentAbstraction, this.nfo, this.pointerSizeInBits, (Value)new NumericValue(0), null);
        this.currentState = this.currentState.writeValueTo(currentAbstraction, this.pfo, this.pointerSizeInBits, (Value)new NumericValue(0), null);
        SymbolicIdentifier pointer = SymbolicValueFactory.getInstance().newIdentifier(null);
        this.currentState = this.currentState.createAndAddPointer(pointer, currentAbstraction, BigInteger.ZERO);
        this.currentState = this.currentState.copyAndReplaceMemoryModel(this.currentState.getMemoryModel().replaceSMGValueNestingLevel(this.currentState.getMemoryModel().getSMGValueFromValue(pointer).orElseThrow(), length - 1));
        SMGValue pointerToFirst = this.currentState.getMemoryModel().getSMGValueFromValue(pointer).orElseThrow();
        for (int i = 0; i < length; ++i) {
            SMGValueAndSMGState resultValueAndState;
            List<SMGValueAndSMGState> resultValuesAndStates = this.materializer.handleMaterilisation(pointerToFirst, currentAbstraction, this.currentState);
            if (i + 1 == 50) {
                Truth.assertThat(resultValuesAndStates).hasSize(2);
                resultValueAndState = resultValuesAndStates.get(1);
            } else {
                Truth.assertThat(resultValuesAndStates).hasSize(1);
                resultValueAndState = resultValuesAndStates.get(0);
            }
            this.currentState = resultValueAndState.getSMGState();
            if (i + 1 == length) break;
            Value currentPointer = this.currentState.getMemoryModel().getValueFromSMGValue(resultValueAndState.getSMGValue()).orElseThrow();
            SMGStateAndOptionalSMGObjectAndOffset targetAndOffset = resultValueAndState.getSMGState().dereferencePointerWithoutMaterilization(currentPointer).orElseThrow();
            Truth.assertThat((Boolean)(targetAndOffset.getOffsetForObject().compareTo(BigInteger.ZERO) == 0 ? 1 : 0)).isTrue();
            SMGObject newObj = targetAndOffset.getSMGObject();
            SMGValueAndSMGState nextPointerAndState = this.currentState.readSMGValue(newObj, this.pointerSizeInBits, this.pointerSizeInBits);
            this.currentState = nextPointerAndState.getSMGState();
            pointerToFirst = nextPointerAndState.getSMGValue();
            SMGStateAndOptionalSMGObjectAndOffset targetToNextAndOffset = resultValueAndState.getSMGState().dereferencePointerWithoutMaterilization(this.currentState.getMemoryModel().getValueFromSMGValue(pointerToFirst).orElseThrow()).orElseThrow();
            Truth.assertThat((Boolean)(targetToNextAndOffset.getSMGObject() instanceof SMGDoublyLinkedListSegment)).isTrue();
            currentAbstraction = (SMGDoublyLinkedListSegment)targetToNextAndOffset.getSMGObject();
        }
        return this.currentState;
    }

    private SMGState createXLongExplicitSLLOnHeap(int length) throws SMG2Exception {
        BigInteger offset = BigInteger.ZERO;
        SMGSinglyLinkedListSegment currentAbstraction = new SMGSinglyLinkedListSegment(0, this.sllSize, offset, this.hfo, this.nfo, length);
        this.currentState = this.currentState.copyAndAddObjectToHeap(currentAbstraction);
        this.currentState = this.currentState.writeValueTo(currentAbstraction, this.hfo, this.pointerSizeInBits, (Value)new NumericValue(1), null);
        this.currentState = this.currentState.writeValueTo(currentAbstraction, this.nfo, this.pointerSizeInBits, (Value)new NumericValue(0), null);
        SymbolicIdentifier pointer = SymbolicValueFactory.getInstance().newIdentifier(null);
        this.currentState = this.currentState.createAndAddPointer(pointer, currentAbstraction, BigInteger.ZERO);
        this.currentState = this.currentState.copyAndReplaceMemoryModel(this.currentState.getMemoryModel().replaceSMGValueNestingLevel(this.currentState.getMemoryModel().getSMGValueFromValue(pointer).orElseThrow(), length - 1));
        SMGValue pointerToFirst = this.currentState.getMemoryModel().getSMGValueFromValue(pointer).orElseThrow();
        for (int i = 0; i < length; ++i) {
            SMGValueAndSMGState resultValueAndState;
            List<SMGValueAndSMGState> resultValuesAndStates = this.materializer.handleMaterilisation(pointerToFirst, currentAbstraction, this.currentState);
            if (i + 1 == 50) {
                Truth.assertThat(resultValuesAndStates).hasSize(2);
                resultValueAndState = resultValuesAndStates.get(1);
            } else {
                Truth.assertThat(resultValuesAndStates).hasSize(1);
                resultValueAndState = resultValuesAndStates.get(0);
            }
            this.currentState = resultValueAndState.getSMGState();
            if (i + 1 == length) break;
            Value currentPointer = this.currentState.getMemoryModel().getValueFromSMGValue(resultValueAndState.getSMGValue()).orElseThrow();
            SMGStateAndOptionalSMGObjectAndOffset targetAndOffset = resultValueAndState.getSMGState().dereferencePointerWithoutMaterilization(currentPointer).orElseThrow();
            Truth.assertThat((Boolean)(targetAndOffset.getOffsetForObject().compareTo(BigInteger.ZERO) == 0 ? 1 : 0)).isTrue();
            SMGObject newObj = targetAndOffset.getSMGObject();
            SMGValueAndSMGState nextPointerAndState = this.currentState.readSMGValue(newObj, this.pointerSizeInBits, this.pointerSizeInBits);
            this.currentState = nextPointerAndState.getSMGState();
            pointerToFirst = nextPointerAndState.getSMGValue();
            SMGStateAndOptionalSMGObjectAndOffset targetToNextAndOffset = resultValueAndState.getSMGState().dereferencePointerWithoutMaterilization(this.currentState.getMemoryModel().getValueFromSMGValue(pointerToFirst).orElseThrow()).orElseThrow();
            Truth.assertThat((Boolean)(targetToNextAndOffset.getSMGObject() instanceof SMGSinglyLinkedListSegment)).isTrue();
            currentAbstraction = (SMGSinglyLinkedListSegment)targetToNextAndOffset.getSMGObject();
        }
        return this.currentState;
    }

    private Value[] buildConcreteList(boolean dll, BigInteger sizeOfSegment, int listLength) throws SMG2Exception {
        Value[] pointerArray = new Value[listLength];
        SMGObject prevObject = null;
        for (int i = 0; i < listLength; ++i) {
            SMGObject listSegment = SMGObject.of(0, sizeOfSegment, BigInteger.ZERO);
            this.currentState = this.currentState.copyAndAddObjectToHeap(listSegment);
            for (int j = 0; j < sizeOfSegment.divide(this.pointerSizeInBits).intValue(); ++j) {
                this.currentState = this.currentState.writeValueTo(listSegment, BigInteger.valueOf(j).multiply(BigInteger.valueOf(32L)), this.pointerSizeInBits, (Value)new NumericValue(j), null);
            }
            if (i == listLength - 1) {
                NumericValue nextPointer = new NumericValue(0);
                this.currentState = this.currentState.writeValueTo(listSegment, this.nfo, this.pointerSizeInBits, (Value)nextPointer, null);
            }
            if (prevObject != null) {
                ValueAndSMGState pointerAndState = this.currentState.searchOrCreateAddress(listSegment, BigInteger.ZERO);
                this.currentState = pointerAndState.getState();
                this.currentState = this.currentState.writeValueTo(prevObject, this.nfo, this.pointerSizeInBits, pointerAndState.getValue(), null);
            }
            if (dll) {
                Value prevPointer;
                if (i == 0) {
                    prevPointer = new NumericValue(0);
                } else {
                    ValueAndSMGState pointerAndState = this.currentState.searchOrCreateAddress(prevObject, BigInteger.ZERO);
                    prevPointer = pointerAndState.getValue();
                    this.currentState = pointerAndState.getState();
                }
                this.currentState = this.currentState.writeValueTo(listSegment, this.pfo, this.pointerSizeInBits, prevPointer, null);
            }
            ValueAndSMGState pointerAndState = this.currentState.searchOrCreateAddress(listSegment, BigInteger.ZERO);
            pointerArray[i] = pointerAndState.getValue();
            this.currentState = pointerAndState.getState();
            prevObject = listSegment;
        }
        this.checkListDataIntegrity(pointerArray, dll);
        return pointerArray;
    }

    private void derefPointersAtAndCheckListMaterialization(int totalSizeOfList, Value[] pointers, int[] derefPositions, boolean dll) throws SMG2Exception {
        int tmp = 0;
        Truth.assertThat((Boolean)(derefPositions[0] >= 0 ? 1 : 0)).isTrue();
        for (int num : derefPositions) {
            Truth.assertThat((Boolean)(tmp <= num ? 1 : 0)).isTrue();
            tmp = num;
        }
        Truth.assertThat((Integer)derefPositions[derefPositions.length - 1]).isLessThan((Comparable)Integer.valueOf(totalSizeOfList));
        for (int k : derefPositions) {
            SMGObject prevObjFromRead;
            Optional<SMGStateAndOptionalSMGObjectAndOffset> derefPrevFromRead;
            Value backPointer;
            ValueAndSMGState backPointerRead;
            SMGObject currentObj;
            int i;
            List<SMGStateAndOptionalSMGObjectAndOffset> derefAtList = this.currentState.dereferencePointer(pointers[k]);
            Truth.assertThat(derefAtList).hasSize(1);
            SMGStateAndOptionalSMGObjectAndOffset derefAt = derefAtList.get(0);
            this.currentState = derefAt.getSMGState();
            Truth.assertThat((Boolean)(derefAt.getSMGObject() instanceof SMGSinglyLinkedListSegment)).isFalse();
            for (i = 0; i <= k; ++i) {
                Optional<SMGStateAndOptionalSMGObjectAndOffset> derefWConcreteTarget = this.currentState.dereferencePointerWithoutMaterilization(pointers[i]);
                Truth.assertThat((Boolean)derefWConcreteTarget.isPresent()).isTrue();
                currentObj = derefWConcreteTarget.orElseThrow().getSMGObject();
                Truth.assertThat((Boolean)(currentObj instanceof SMGSinglyLinkedListSegment)).isFalse();
                ValueAndSMGState addressAndState = this.currentState.searchOrCreateAddress(derefWConcreteTarget.orElseThrow().getSMGObject(), BigInteger.ZERO);
                this.currentState = addressAndState.getState();
                Value address = addressAndState.getValue();
                Truth.assertThat((Object)address).isEqualTo((Object)pointers[i]);
                Truth.assertThat((Boolean)(this.currentState.getMemoryModel().getSMGValueFromValue(address).orElseThrow().getNestingLevel() == 0 ? 1 : 0)).isTrue();
                if (!dll || i <= 0) continue;
                backPointerRead = this.currentState.readValueWithoutMaterialization(currentObj, this.pfo, this.pointerSizeInBits, null);
                this.currentState = backPointerRead.getState();
                backPointer = backPointerRead.getValue();
                derefPrevFromRead = this.currentState.dereferencePointerWithoutMaterilization(backPointer);
                Truth.assertThat((Boolean)derefPrevFromRead.isPresent()).isTrue();
                prevObjFromRead = derefPrevFromRead.orElseThrow().getSMGObject();
                Truth.assertThat((Boolean)(prevObjFromRead instanceof SMGSinglyLinkedListSegment)).isFalse();
                Optional<SMGStateAndOptionalSMGObjectAndOffset> derefPrevWConcreteTarget = this.currentState.dereferencePointerWithoutMaterilization(pointers[i - 1]);
                Truth.assertThat((Boolean)derefPrevWConcreteTarget.isPresent()).isTrue();
                SMGObject prevObj = derefPrevWConcreteTarget.orElseThrow().getSMGObject();
                Truth.assertThat((Boolean)(prevObj instanceof SMGSinglyLinkedListSegment)).isFalse();
                Truth.assertThat((Comparable)prevObjFromRead).isEqualTo((Object)prevObj);
                Truth.assertThat((Object)pointers[i - 1]).isEqualTo((Object)backPointer);
                Truth.assertThat((Comparable)this.currentState.getMemoryModel().getSMGValueFromValue(pointers[i - 1]).orElseThrow()).isEqualTo((Object)this.currentState.getMemoryModel().getSMGValueFromValue(backPointer).orElseThrow());
                Truth.assertThat((Integer)this.currentState.getMemoryModel().getSMGValueFromValue(backPointer).orElseThrow().getNestingLevel()).isEqualTo((Object)0);
            }
            for (i = k + 1; i < totalSizeOfList; ++i) {
                Optional<SMGStateAndOptionalSMGObjectAndOffset> derefWOConcreteTarget = this.currentState.dereferencePointerWithoutMaterilization(pointers[i]);
                Truth.assertThat((Boolean)derefWOConcreteTarget.isPresent()).isTrue();
                Truth.assertThat((Boolean)(derefWOConcreteTarget.orElseThrow().getSMGObject() instanceof SMGSinglyLinkedListSegment)).isTrue();
                if (!dll || i <= 0) continue;
                currentObj = derefWOConcreteTarget.orElseThrow().getSMGObject();
                Optional<SMGStateAndOptionalSMGObjectAndOffset> derefWConcreteTarget = this.currentState.dereferencePointerWithoutMaterilization(pointers[k]);
                Truth.assertThat((Boolean)derefWConcreteTarget.isPresent()).isTrue();
                SMGObject prevConcreteObj = derefWConcreteTarget.orElseThrow().getSMGObject();
                backPointerRead = this.currentState.readValueWithoutMaterialization(currentObj, this.pfo, this.pointerSizeInBits, null);
                this.currentState = backPointerRead.getState();
                backPointer = backPointerRead.getValue();
                derefPrevFromRead = this.currentState.dereferencePointerWithoutMaterilization(backPointer);
                Truth.assertThat((Boolean)derefPrevFromRead.isPresent()).isTrue();
                prevObjFromRead = derefPrevFromRead.orElseThrow().getSMGObject();
                Truth.assertThat((Boolean)(prevObjFromRead instanceof SMGSinglyLinkedListSegment)).isFalse();
                Truth.assertThat((Boolean)(prevConcreteObj instanceof SMGSinglyLinkedListSegment)).isFalse();
                Truth.assertThat((Comparable)prevObjFromRead).isEqualTo((Object)prevConcreteObj);
                Truth.assertThat((Object)pointers[k]).isEqualTo((Object)backPointer);
                Truth.assertThat((Comparable)this.currentState.getMemoryModel().getSMGValueFromValue(pointers[k]).orElseThrow()).isEqualTo((Object)this.currentState.getMemoryModel().getSMGValueFromValue(backPointer).orElseThrow());
                Truth.assertThat((Integer)this.currentState.getMemoryModel().getSMGValueFromValue(backPointer).orElseThrow().getNestingLevel()).isEqualTo((Object)0);
            }
            if (k + 1 < totalSizeOfList) {
                Truth.assertThat(this.currentState.getMemoryModel().getSmg().getPTEdgeMapping().entrySet()).hasSize(totalSizeOfList + 3);
            } else {
                Truth.assertThat(this.currentState.getMemoryModel().getSmg().getPTEdgeMapping().entrySet()).hasSize(totalSizeOfList + 4);
            }
            int zeros = 0;
            int found0Plus = 0;
            int foundNum = 0;
            for (Map.Entry<SMGValue, SMGPointsToEdge> entry : this.currentState.getMemoryModel().getSmg().getPTEdgeMapping().entrySet()) {
                if (entry.getKey().isZero()) {
                    ++zeros;
                    continue;
                }
                boolean found = false;
                for (int i2 = 0; i2 < pointers.length; ++i2) {
                    Value pointer = pointers[i2];
                    SMGValue pointerSMGValue = this.currentState.getMemoryModel().getSMGValueFromValue(pointer).orElseThrow();
                    if (!pointerSMGValue.equals(entry.getKey())) continue;
                    Truth.assertThat((Boolean)found).isFalse();
                    found = true;
                    ++foundNum;
                    if (i2 < k + 1) {
                        Truth.assertThat((Integer)entry.getKey().getNestingLevel()).isEqualTo((Object)0);
                        continue;
                    }
                    Truth.assertThat((Integer)entry.getKey().getNestingLevel()).isEqualTo((Object)(totalSizeOfList - i2 - 1));
                }
                if (k + 1 != totalSizeOfList) continue;
                ValueAndSMGState nextPointerToZeroPlusWithoutMaterialization = this.currentState.readValueWithoutMaterialization(this.currentState.dereferencePointer(pointers[totalSizeOfList - 1]).get(0).getSMGObject(), this.nfo, this.pointerSizeInBits, null);
                this.currentState = nextPointerToZeroPlusWithoutMaterialization.getState();
                if (!entry.getKey().equals(this.currentState.getMemoryModel().getSMGValueFromValue(nextPointerToZeroPlusWithoutMaterialization.getValue()).orElseThrow())) continue;
                Truth.assertThat((Integer)entry.getKey().getNestingLevel()).isEqualTo((Object)0);
                Truth.assertThat((Integer)found0Plus).isEqualTo((Object)0);
                Truth.assertThat((Boolean)found).isFalse();
                ++found0Plus;
            }
            if (k + 1 == totalSizeOfList) {
                Truth.assertThat((Integer)found0Plus).isEqualTo((Object)1);
            }
            Truth.assertThat((Integer)foundNum).isEqualTo((Object)totalSizeOfList);
            Truth.assertThat((Boolean)(zeros == 3 ? 1 : 0)).isTrue();
        }
    }

    private void checkListDataIntegrity(Value[] pointers, boolean dll) {
        int toCheckData = this.sllSize.divide(this.pointerSizeInBits).subtract(BigInteger.ONE).intValue();
        if (dll) {
            toCheckData = this.sllSize.divide(this.pointerSizeInBits).subtract(BigInteger.ONE).subtract(BigInteger.ONE).intValue();
        }
        for (Value pointer : pointers) {
            for (int j = 0; j < toCheckData; ++j) {
                ValueAndSMGState readDataWithoutMaterialization = this.currentState.readValueWithoutMaterialization(this.currentState.dereferencePointerWithoutMaterilization(pointer).orElseThrow().getSMGObject(), BigInteger.valueOf(j).multiply(this.pointerSizeInBits), this.pointerSizeInBits, null);
                this.currentState = readDataWithoutMaterialization.getState();
                Truth.assertThat((Boolean)readDataWithoutMaterialization.getValue().isNumericValue()).isTrue();
                Truth.assertThat((Comparable)readDataWithoutMaterialization.getValue().asNumericValue().bigInteger()).isEquivalentAccordingToCompareTo((Comparable)BigInteger.valueOf(j));
            }
        }
    }
}

