/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2.abstraction;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMG2Exception;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGObjectAndSMGState;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGValueAndSMGState;
import org.sosy_lab.cpachecker.cpa.smg2.util.value.ValueAndSMGState;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.smg.graph.SMGDoublyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGPointsToEdge;
import org.sosy_lab.cpachecker.util.smg.graph.SMGSinglyLinkedListSegment;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;

public class SMGCPAMaterializer {
    private final LogManager logger;
    private static final int MINIMUM_LIST_LENGTH = 0;

    public SMGCPAMaterializer(LogManager pLogger) {
        this.logger = pLogger;
    }

    public List<SMGValueAndSMGState> handleMaterilisation(SMGValue valueTopointerToAbstractObject, SMGObject pAbstractObject, SMGState state) throws SMG2Exception {
        if (pAbstractObject instanceof SMGDoublyLinkedListSegment) {
            SMGDoublyLinkedListSegment sllListSeg = (SMGDoublyLinkedListSegment)pAbstractObject;
            if (sllListSeg.getMinLength() == 0) {
                return this.handleZeroPlusDLS(sllListSeg, valueTopointerToAbstractObject, state);
            }
            return ImmutableList.of((Object)this.materialiseDLLS(sllListSeg, valueTopointerToAbstractObject, state));
        }
        if (pAbstractObject instanceof SMGSinglyLinkedListSegment) {
            SMGSinglyLinkedListSegment dllListSeg = (SMGSinglyLinkedListSegment)pAbstractObject;
            if (dllListSeg.getMinLength() == 0) {
                return this.handleZeroPlusSLS(dllListSeg, valueTopointerToAbstractObject, state);
            }
            return ImmutableList.of((Object)this.materialiseSLLS(dllListSeg, valueTopointerToAbstractObject, state));
        }
        throw new SMG2Exception("The SMG failed to materialize a abstract list.");
    }

    private List<SMGValueAndSMGState> handleZeroPlusSLS(SMGSinglyLinkedListSegment pListSeg, SMGValue pointerValueTowardsThisSegment, SMGState state) throws SMG2Exception {
        this.logger.log(Level.ALL, new Object[]{"Split into 2 states because of 0+ SLS materialization.", pListSeg});
        ImmutableList.Builder returnStates = ImmutableList.builder();
        SMGState currentState = state;
        BigInteger nfo = pListSeg.getNextOffset();
        BigInteger pointerSize = currentState.getMemoryModel().getSizeOfPointer();
        SMGObject prevObj = currentState.getMemoryModel().getSmg().getPreviousObjectOfZeroPlusAbstraction(pointerValueTowardsThisSegment);
        SMGValueAndSMGState nextPointerAndState = currentState.readSMGValue(pListSeg, nfo, pointerSize);
        currentState = nextPointerAndState.getSMGState();
        SMGValue nextPointerValue = nextPointerAndState.getSMGValue();
        currentState = currentState.writeValue(prevObj, nfo, pointerSize, nextPointerValue);
        currentState = currentState.copyAndReplaceMemoryModel(currentState.getMemoryModel().copyAndRemoveObjectAndAssociatedSubSMG(pListSeg));
        returnStates.add((Object)SMGValueAndSMGState.of(currentState, nextPointerValue));
        return returnStates.add((Object)this.materialiseSLLS(pListSeg, pointerValueTowardsThisSegment, state)).build();
    }

    private List<SMGValueAndSMGState> handleZeroPlusDLS(SMGDoublyLinkedListSegment pListSeg, SMGValue pointerValueTowardsThisSegment, SMGState state) throws SMG2Exception {
        this.logger.log(Level.ALL, new Object[]{"Split into 2 states because of 0+ DLS materialization.", pListSeg});
        ImmutableList.Builder returnStates = ImmutableList.builder();
        SMGState currentState = state;
        BigInteger nfo = pListSeg.getNextOffset();
        BigInteger pfo = pListSeg.getPrevOffset();
        BigInteger pointerSize = currentState.getMemoryModel().getSizeOfPointer();
        SMGValueAndSMGState nextPointerAndState = currentState.readSMGValue(pListSeg, nfo, pointerSize);
        currentState = nextPointerAndState.getSMGState();
        SMGValueAndSMGState prevPointerAndState = currentState.readSMGValue(pListSeg, pfo, pointerSize);
        currentState = prevPointerAndState.getSMGState();
        SMGValue nextPointerValue = nextPointerAndState.getSMGValue();
        SMGValue prevPointerValue = prevPointerAndState.getSMGValue();
        SMGPointsToEdge prevPointer = currentState.getMemoryModel().getSmg().getPTEdge(prevPointerValue).orElseThrow();
        SMGObject prevObj = prevPointer.pointsTo();
        Optional<SMGPointsToEdge> maybeNextPointer = currentState.getMemoryModel().getSmg().getPTEdge(nextPointerValue);
        if (maybeNextPointer.isPresent() && !maybeNextPointer.orElseThrow().pointsTo().isZero()) {
            currentState = currentState.writeValue(maybeNextPointer.orElseThrow().pointsTo(), pfo, pointerSize, prevPointerValue);
        }
        currentState = currentState.writeValue(prevObj, nfo, pointerSize, nextPointerValue);
        currentState = currentState.copyAndReplaceMemoryModel(currentState.getMemoryModel().copyAndRemoveObjectAndAssociatedSubSMG(pListSeg));
        returnStates.add((Object)SMGValueAndSMGState.of(currentState, nextPointerValue));
        return returnStates.add((Object)this.materialiseDLLS(pListSeg, pointerValueTowardsThisSegment, state)).build();
    }

    private SMGValueAndSMGState materialiseSLLS(SMGSinglyLinkedListSegment pListSeg, SMGValue pValueOfPointerToAbstractObject, SMGState state) throws SMG2Exception {
        if (!state.getMemoryModel().isObjectValid(pListSeg)) {
            throw new SMG2Exception("Error when materializing a SLL.");
        }
        SMGValue initialPointer = pValueOfPointerToAbstractObject;
        this.logger.log(Level.ALL, new Object[]{"Materialise SLL ", pListSeg});
        SMGObjectAndSMGState newConcreteRegionAndState = state.copyAndAddHeapObject(pListSeg.getSize());
        SMGState currentState = newConcreteRegionAndState.getState();
        SMGObject newConcreteRegion = newConcreteRegionAndState.getSMGObject();
        BigInteger nfo = pListSeg.getNextOffset();
        BigInteger pointerSize = currentState.getMemoryModel().getSizeOfPointer();
        currentState = currentState.copyAllValuesFromObjToObj(pListSeg, newConcreteRegion);
        SMGSinglyLinkedListSegment newAbsListSeg = (SMGSinglyLinkedListSegment)pListSeg.decrementLengthAndCopy();
        currentState = currentState.copyAndAddObjectToHeap(newAbsListSeg);
        currentState = currentState.copyAllValuesFromObjToObj(pListSeg, newAbsListSeg);
        currentState = currentState.copyAndReplaceMemoryModel(currentState.getMemoryModel().replaceSpecificPointersTowardsWithAndSetNestingLevelZero(pListSeg, newConcreteRegion, Integer.max(pListSeg.getMinLength() - 1, 0)));
        Preconditions.checkArgument((pListSeg.getMinLength() >= 0 ? 1 : 0) != 0);
        currentState = currentState.copyAndReplaceMemoryModel(currentState.getMemoryModel().replaceAllPointersTowardsWith(pListSeg, (SMGObject)newAbsListSeg));
        currentState = currentState.copyAndRemoveObjectFromHeap(pListSeg);
        Preconditions.checkArgument((newAbsListSeg.getMinLength() >= 0 ? 1 : 0) != 0);
        ValueAndSMGState newAddressAndState = currentState.createAndAddPointerWithNestingLevel(newAbsListSeg, BigInteger.ZERO, Integer.max(newAbsListSeg.getMinLength() - 1, 0));
        currentState = newAddressAndState.getState();
        Value newPointerValue = newAddressAndState.getValue();
        SMGValueAndSMGState newValuePointingToWardsAbstractListAndState = currentState.copyAndAddValue(newPointerValue);
        SMGValue newValuePointingToWardsAbstractList = newValuePointingToWardsAbstractListAndState.getSMGValue().withNestingLevelAndCopy(newAbsListSeg.getMinLength() - 1);
        currentState = newValuePointingToWardsAbstractListAndState.getSMGState();
        currentState = currentState.writeValue(newConcreteRegion, nfo, pointerSize, newValuePointingToWardsAbstractList);
        assert (this.checkPointersOfMaterializedSLL(newConcreteRegion, nfo, currentState));
        return SMGValueAndSMGState.of(currentState, initialPointer);
    }

    private SMGValueAndSMGState materialiseDLLS(SMGDoublyLinkedListSegment pListSeg, SMGValue pValueOfPointerToAbstractObject, SMGState state) throws SMG2Exception {
        if (!state.getMemoryModel().isObjectValid(pListSeg)) {
            throw new SMG2Exception("Error when materializing a DLL.");
        }
        SMGValue initialPointer = pValueOfPointerToAbstractObject;
        this.logger.log(Level.ALL, new Object[]{"Materialise DLL ", pListSeg});
        BigInteger nfo = pListSeg.getNextOffset();
        BigInteger pfo = pListSeg.getPrevOffset();
        SMGObjectAndSMGState newConcreteRegionAndState = state.copyAndAddHeapObject(pListSeg.getSize());
        SMGState currentState = newConcreteRegionAndState.getState();
        SMGObject newConcreteRegion = newConcreteRegionAndState.getSMGObject();
        BigInteger pointerSize = currentState.getMemoryModel().getSizeOfPointer();
        currentState = currentState.copyAllValuesFromObjToObj(pListSeg, newConcreteRegion);
        currentState = currentState.copyAndReplaceMemoryModel(currentState.getMemoryModel().replaceSpecificPointersTowardsWithAndSetNestingLevelZero(pListSeg, newConcreteRegion, Integer.max(pListSeg.getMinLength() - 1, 0)));
        Preconditions.checkArgument((pListSeg.getMinLength() >= 0 ? 1 : 0) != 0);
        ValueAndSMGState correctPointerToNewConcreteAndState = currentState.searchOrCreateAddress(newConcreteRegion, BigInteger.ZERO);
        currentState = correctPointerToNewConcreteAndState.getState();
        Optional<SMGValue> maybeValueOfPointerToConcreteObject = currentState.getMemoryModel().getSMGValueFromValue(correctPointerToNewConcreteAndState.getValue());
        Preconditions.checkArgument((boolean)maybeValueOfPointerToConcreteObject.isPresent());
        SMGValue valueOfPointerToConcreteObject = maybeValueOfPointerToConcreteObject.orElseThrow();
        Optional<SMGPointsToEdge> maybePointsToEdgeToConcreteRegion = currentState.getMemoryModel().getSmg().getPTEdge(valueOfPointerToConcreteObject);
        Preconditions.checkArgument((boolean)maybePointsToEdgeToConcreteRegion.isPresent());
        Preconditions.checkArgument((boolean)maybePointsToEdgeToConcreteRegion.orElseThrow().pointsTo().equals(newConcreteRegion));
        SMGDoublyLinkedListSegment newAbsListSeg = (SMGDoublyLinkedListSegment)pListSeg.decrementLengthAndCopy();
        currentState = currentState.copyAndAddObjectToHeap(newAbsListSeg);
        currentState = currentState.copyAndReplaceMemoryModel(currentState.getMemoryModel().replaceAllPointersTowardsWith(pListSeg, (SMGObject)newAbsListSeg));
        currentState = currentState.copyAllValuesFromObjToObj(pListSeg, newAbsListSeg);
        ValueAndSMGState pointerAndState = currentState.createAndAddPointerWithNestingLevel(newAbsListSeg, BigInteger.ZERO, Integer.max(newAbsListSeg.getMinLength() - 1, 0));
        currentState = pointerAndState.getState();
        Value newPointerValue = pointerAndState.getValue();
        SMGValueAndSMGState newValuePointingToWardsAbstractListAndState = currentState.copyAndAddValue(newPointerValue);
        SMGValue newValuePointingToWardsAbstractList = newValuePointingToWardsAbstractListAndState.getSMGValue().withNestingLevelAndCopy(newAbsListSeg.getMinLength() - 1);
        currentState = newValuePointingToWardsAbstractListAndState.getSMGState();
        currentState = currentState.writeValue(newConcreteRegion, nfo, pointerSize, newValuePointingToWardsAbstractList);
        currentState = currentState.writeValue(newAbsListSeg, pfo, pointerSize, valueOfPointerToConcreteObject);
        SMGValueAndSMGState nextPointerAndState = currentState.readSMGValue(pListSeg, nfo, pointerSize);
        currentState = nextPointerAndState.getSMGState();
        SMGValue nextPointerValue = nextPointerAndState.getSMGValue();
        Optional<SMGPointsToEdge> maybeNextPointer = currentState.getMemoryModel().getSmg().getPTEdge(nextPointerValue);
        if (maybeNextPointer.isPresent() && currentState.getMemoryModel().isObjectValid(maybeNextPointer.orElseThrow().pointsTo())) {
            currentState = currentState.writeValue(maybeNextPointer.orElseThrow().pointsTo(), pfo, pointerSize, newValuePointingToWardsAbstractList);
        }
        currentState = currentState.copyAndRemoveObjectFromHeap(pListSeg);
        Preconditions.checkArgument((newAbsListSeg.getMinLength() >= 0 ? 1 : 0) != 0);
        assert (this.checkPointersOfMaterializedDLL(newConcreteRegion, nfo, pfo, currentState));
        if (initialPointer.equals(valueOfPointerToConcreteObject)) {
            initialPointer = initialPointer.withNestingLevelAndCopy(0);
        }
        return SMGValueAndSMGState.of(currentState, initialPointer);
    }

    private boolean checkPointersOfMaterializedDLL(SMGObject newConcreteRegion, BigInteger nfo, BigInteger pfo, SMGState state) {
        BigInteger pointerSize = state.getMemoryModel().getSizeOfPointer();
        SMGValueAndSMGState nextPointerAndState = state.readSMGValue(newConcreteRegion, nfo, pointerSize);
        SMGState currentState = nextPointerAndState.getSMGState();
        SMGValueAndSMGState prevPointerAndState = currentState.readSMGValue(newConcreteRegion, pfo, pointerSize);
        currentState = prevPointerAndState.getSMGState();
        SMGValue nextPointerValue = nextPointerAndState.getSMGValue();
        SMGValue prevPointerValue = prevPointerAndState.getSMGValue();
        Optional<SMGPointsToEdge> prevPointer = currentState.getMemoryModel().getSmg().getPTEdge(prevPointerValue);
        SMGObject start = newConcreteRegion;
        ArrayList<SMGObject> listOfObjects = new ArrayList<SMGObject>();
        if (prevPointer.isPresent()) {
            SMGObject maybeStart = prevPointer.orElseThrow().pointsTo();
            if (state.getMemoryModel().isObjectValid(maybeStart) && maybeStart.getSize().compareTo(start.getSize()) == 0 && !start.equals(maybeStart)) {
                start = maybeStart;
                listOfObjects.add(start);
            }
        }
        listOfObjects.add(newConcreteRegion);
        Optional<SMGPointsToEdge> nextPointer = currentState.getMemoryModel().getSmg().getPTEdge(nextPointerValue);
        Preconditions.checkArgument((boolean)nextPointer.isPresent());
        SMGObject abstractObjectFollowingNewConcrete = nextPointer.orElseThrow().pointsTo();
        listOfObjects.add(abstractObjectFollowingNewConcrete);
        SMGValueAndSMGState nextNextPointerAndState = state.readSMGValue(abstractObjectFollowingNewConcrete, nfo, pointerSize);
        currentState = nextNextPointerAndState.getSMGState();
        SMGValue nextNextPointerValue = nextNextPointerAndState.getSMGValue();
        Optional<SMGPointsToEdge> nextNextPointer = currentState.getMemoryModel().getSmg().getPTEdge(nextNextPointerValue);
        if (nextNextPointer.isPresent()) {
            listOfObjects.add(nextNextPointer.orElseThrow().pointsTo());
        }
        if (!this.checkList(start, nfo, listOfObjects, currentState)) {
            return false;
        }
        Collections.reverse(listOfObjects);
        return this.checkList((SMGObject)listOfObjects.get(0), pfo, listOfObjects, currentState);
    }

    private boolean checkPointersOfMaterializedSLL(SMGObject newConcreteRegion, BigInteger nfo, SMGState state) {
        BigInteger pointerSize = state.getMemoryModel().getSizeOfPointer();
        SMGValueAndSMGState nextPointerAndState = state.readSMGValue(newConcreteRegion, nfo, pointerSize);
        SMGState currentState = nextPointerAndState.getSMGState();
        SMGValue nextPointerValue = nextPointerAndState.getSMGValue();
        SMGObject start = newConcreteRegion;
        ArrayList<SMGObject> listOfObjects = new ArrayList<SMGObject>();
        listOfObjects.add(newConcreteRegion);
        Optional<SMGPointsToEdge> nextPointer = currentState.getMemoryModel().getSmg().getPTEdge(nextPointerValue);
        Preconditions.checkArgument((boolean)nextPointer.isPresent());
        SMGObject abstractObjectFollowingNewConcrete = nextPointer.orElseThrow().pointsTo();
        listOfObjects.add(abstractObjectFollowingNewConcrete);
        SMGValueAndSMGState nextNextPointerAndState = state.readSMGValue(abstractObjectFollowingNewConcrete, nfo, pointerSize);
        currentState = nextNextPointerAndState.getSMGState();
        SMGValue nextNextPointerValue = nextNextPointerAndState.getSMGValue();
        Optional<SMGPointsToEdge> nextNextPointer = currentState.getMemoryModel().getSmg().getPTEdge(nextNextPointerValue);
        if (nextNextPointer.isPresent()) {
            listOfObjects.add(nextNextPointer.orElseThrow().pointsTo());
        }
        return this.checkList(start, nfo, listOfObjects, currentState);
    }

    private boolean checkList(SMGObject start, BigInteger pointerOffset, List<SMGObject> listOfObjects, SMGState state) {
        SMGObject currentObj = start;
        BigInteger pointerSize = state.getMemoryModel().getSizeOfPointer();
        for (int i = 0; i < listOfObjects.size(); ++i) {
            SMGObject toCheckObj = listOfObjects.get(i);
            if (!currentObj.equals(toCheckObj)) {
                return false;
            }
            if (i == listOfObjects.size() - 1 || !state.getMemoryModel().isObjectValid(currentObj)) break;
            SMGValueAndSMGState nextPointerAndState = state.readSMGValue(currentObj, pointerOffset, pointerSize);
            SMGState currentState = nextPointerAndState.getSMGState();
            SMGValue nextPointerValue = nextPointerAndState.getSMGValue();
            Optional<SMGPointsToEdge> prevPointer = currentState.getMemoryModel().getSmg().getPTEdge(nextPointerValue);
            if (prevPointer.isEmpty()) {
                return false;
            }
            currentObj = prevPointer.orElseThrow().pointsTo();
        }
        return true;
    }
}

