/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2.refiner;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.counterexample.Address;
import org.sosy_lab.cpachecker.core.counterexample.AssumptionToEdgeAllocator;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteState;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteStatePath;
import org.sosy_lab.cpachecker.core.counterexample.IDExpression;
import org.sosy_lab.cpachecker.core.counterexample.LeftHandSide;
import org.sosy_lab.cpachecker.core.counterexample.Memory;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.util.ValueAndValueSize;
import org.sosy_lab.cpachecker.cpa.value.refiner.ConcreteErrorPathAllocator;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class SMGConcreteErrorPathAllocator
extends ConcreteErrorPathAllocator<SMGState> {
    private static final String MEMORY_NAME = "SMG_Heap";
    private final MachineModel machineModel;

    public SMGConcreteErrorPathAllocator(Configuration pConfig, LogManager pLogger, MachineModel pMachineModel) throws InvalidConfigurationException {
        super(SMGState.class, AssumptionToEdgeAllocator.create(pConfig, pLogger, pMachineModel));
        this.machineModel = pMachineModel;
    }

    @Override
    protected ConcreteStatePath createConcreteStatePath(List<Pair<SMGState, List<CFAEdge>>> pPath) {
        ArrayList<ConcreteStatePath.ConcreteStatePathNode> result = new ArrayList<ConcreteStatePath.ConcreteStatePathNode>(pPath.size());
        Map<LeftHandSide, Address> variableAddresses = SMGConcreteErrorPathAllocator.generateVariableAddresses((Iterable<SMGState>)FluentIterable.from(pPath).transform(Pair::getFirst));
        for (Pair<SMGState, List<CFAEdge>> edgeStatePair : pPath) {
            SMGState valueState = edgeStatePair.getFirst();
            List<CFAEdge> edges = edgeStatePair.getSecond();
            if (edges.size() > 1) {
                Iterator it = Lists.reverse(edges).iterator();
                ArrayList<ConcreteStatePath.SingleConcreteState> intermediateStates = new ArrayList<ConcreteStatePath.SingleConcreteState>();
                HashSet<CLeftHandSide> alreadyAssigned = new HashSet<CLeftHandSide>();
                boolean isFirstIteration = true;
                while (it.hasNext()) {
                    CFAEdge innerEdge = (CFAEdge)it.next();
                    ConcreteState state = this.createConcreteStateForMultiEdge(valueState, alreadyAssigned, innerEdge);
                    if (isFirstIteration) {
                        intermediateStates.add(new ConcreteStatePath.SingleConcreteState(innerEdge, state));
                        isFirstIteration = false;
                        continue;
                    }
                    intermediateStates.add(new ConcreteStatePath.IntermediateConcreteState(innerEdge, state));
                }
                result.addAll(Lists.reverse(intermediateStates));
                continue;
            }
            result.add(new ConcreteStatePath.SingleConcreteState((CFAEdge)Iterables.getOnlyElement(edges), new ConcreteState((Map<LeftHandSide, Object>)ImmutableMap.of(), SMGConcreteErrorPathAllocator.allocateAddresses(valueState, variableAddresses), variableAddresses, exp -> MEMORY_NAME, this.machineModel)));
        }
        return new ConcreteStatePath(result);
    }

    private ConcreteState createConcreteStateForMultiEdge(SMGState pValueState, Set<CLeftHandSide> alreadyAssigned, CFAEdge innerEdge) {
        CStatement stmt;
        ConcreteState state = this.allValuesForLeftHandSideKnown(innerEdge, alreadyAssigned) ? SMGConcreteErrorPathAllocator.createConcreteState(pValueState, this.machineModel) : ConcreteState.empty();
        if (innerEdge.getEdgeType() == CFAEdgeType.StatementEdge && (stmt = ((CStatementEdge)innerEdge).getStatement()) instanceof CAssignment) {
            CLeftHandSide lhs = ((CAssignment)stmt).getLeftHandSide();
            alreadyAssigned.add(lhs);
        }
        return state;
    }

    public static ConcreteState createConcreteState(SMGState pValueState, MachineModel pMachineModel) {
        Map<LeftHandSide, Address> variableAddresses = SMGConcreteErrorPathAllocator.generateVariableAddresses(Collections.singleton(pValueState));
        return new ConcreteState((Map<LeftHandSide, Object>)ImmutableMap.of(), SMGConcreteErrorPathAllocator.allocateAddresses(pValueState, variableAddresses), variableAddresses, exp -> MEMORY_NAME, pMachineModel);
    }

    private boolean allValuesForLeftHandSideKnown(CFAEdge pCfaEdge, Set<CLeftHandSide> pAlreadyAssigned) {
        if (pCfaEdge.getEdgeType() == CFAEdgeType.DeclarationEdge) {
            return this.isDeclarationValueKnown((CDeclarationEdge)pCfaEdge, pAlreadyAssigned);
        }
        if (pCfaEdge.getEdgeType() == CFAEdgeType.StatementEdge) {
            return this.isStatementValueKnown((CStatementEdge)pCfaEdge, pAlreadyAssigned);
        }
        return false;
    }

    private boolean isStatementValueKnown(CStatementEdge pCfaEdge, Set<CLeftHandSide> pAlreadyAssigned) {
        CStatement stmt = pCfaEdge.getStatement();
        if (stmt instanceof CAssignment) {
            CLeftHandSide leftHandSide = ((CAssignment)stmt).getLeftHandSide();
            return this.isLeftHandSideValueKnown(leftHandSide, pAlreadyAssigned);
        }
        return true;
    }

    private static Map<LeftHandSide, Address> generateVariableAddresses(Iterable<SMGState> pPath) {
        Multimap<IDExpression, MemoryLocation> memoryLocationsInPath = SMGConcreteErrorPathAllocator.getAllMemoryLocationsInPath(pPath);
        return SMGConcreteErrorPathAllocator.generateVariableAddresses(memoryLocationsInPath);
    }

    private static Map<LeftHandSide, Address> generateVariableAddresses(Multimap<IDExpression, MemoryLocation> pMemoryLocationsInPath) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)pMemoryLocationsInPath.size());
        Address nextAddressToBeAssigned = Address.valueOf(BigInteger.ZERO);
        for (IDExpression variable : pMemoryLocationsInPath.keySet()) {
            result.put(variable, nextAddressToBeAssigned);
            nextAddressToBeAssigned = SMGConcreteErrorPathAllocator.generateNextAddresses(pMemoryLocationsInPath.get((Object)variable), nextAddressToBeAssigned);
        }
        return result;
    }

    private static Address generateNextAddresses(Collection<MemoryLocation> pCollection, Address pNextAddressToBeAssigned) {
        long biggestStoredOffsetInPath = 0L;
        for (MemoryLocation loc : pCollection) {
            if (!loc.isReference() || loc.getOffset() <= biggestStoredOffsetInPath) continue;
            biggestStoredOffsetInPath = loc.getOffset();
        }
        long spaceForLastValue = 64L;
        BigInteger offset = BigInteger.valueOf(biggestStoredOffsetInPath + spaceForLastValue);
        return pNextAddressToBeAssigned.addOffset(offset);
    }

    private static Multimap<IDExpression, MemoryLocation> getAllMemoryLocationsInPath(Iterable<SMGState> pPath) {
        HashMultimap result = HashMultimap.create();
        for (SMGState valueState : pPath) {
            SMGConcreteErrorPathAllocator.putIfNotExists(valueState, (Multimap<IDExpression, MemoryLocation>)result);
        }
        return result;
    }

    private static void putIfNotExists(SMGState pState, Multimap<IDExpression, MemoryLocation> memoryLocationMap) {
        SMGState valueState = pState;
        for (MemoryLocation loc : valueState.getTrackedMemoryLocations()) {
            IDExpression idExp = SMGConcreteErrorPathAllocator.createBaseIdExpresssion(loc);
            if (memoryLocationMap.containsEntry((Object)idExp, (Object)loc)) continue;
            memoryLocationMap.put((Object)idExp, (Object)loc);
        }
    }

    private static IDExpression createBaseIdExpresssion(MemoryLocation pLoc) {
        if (!pLoc.isOnFunctionStack()) {
            return new IDExpression(pLoc.getIdentifier());
        }
        return new IDExpression(pLoc.getIdentifier(), pLoc.getFunctionName());
    }

    private static Map<String, Memory> allocateAddresses(SMGState pValueState, Map<LeftHandSide, Address> pVariableAddressMap) {
        Map<Address, Object> values = SMGConcreteErrorPathAllocator.createHeapValues(pValueState, pVariableAddressMap);
        return ImmutableMap.of((Object)MEMORY_NAME, (Object)new Memory(MEMORY_NAME, values));
    }

    private static Map<Address, Object> createHeapValues(SMGState pValueState, Map<LeftHandSide, Address> pVariableAddressMap) {
        HashMap<Address, Object> result = new HashMap<Address, Object>();
        for (Map.Entry entry : pValueState.getMemoryModel().getMemoryLocationsAndValuesForSPCWithoutHeap().entrySet()) {
            Address baseAddress;
            MemoryLocation heapLoc = (MemoryLocation)entry.getKey();
            Value valueAsValue = ((ValueAndValueSize)entry.getValue()).getValue();
            if (!valueAsValue.isNumericValue()) continue;
            Number value = valueAsValue.asNumericValue().getNumber();
            IDExpression lhs = SMGConcreteErrorPathAllocator.createBaseIdExpresssion(heapLoc);
            assert (pVariableAddressMap.containsKey(lhs));
            Address address = baseAddress = pVariableAddressMap.get(lhs);
            if (heapLoc.isReference()) {
                address = baseAddress.addOffset(BigInteger.valueOf(heapLoc.getOffset()));
            }
            result.put(address, value);
        }
        return result;
    }
}

