/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2.refiner;

import java.util.Deque;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.arg.path.PathPosition;
import org.sosy_lab.cpachecker.cpa.smg2.SMGInformation;
import org.sosy_lab.cpachecker.cpa.smg2.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.refiner.SMGFeasibilityChecker;
import org.sosy_lab.cpachecker.cpa.smg2.refiner.SMGInterpolant;
import org.sosy_lab.cpachecker.cpa.smg2.refiner.SMGInterpolantManager;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.refinement.FeasibilityChecker;
import org.sosy_lab.cpachecker.util.refinement.GenericEdgeInterpolator;
import org.sosy_lab.cpachecker.util.refinement.InterpolantManager;
import org.sosy_lab.cpachecker.util.refinement.StrongestPostOperator;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

@Options(prefix="cpa.smg2.interpolation")
public class SMGEdgeInterpolator
extends GenericEdgeInterpolator<SMGState, SMGInformation, SMGInterpolant> {
    public SMGEdgeInterpolator(FeasibilityChecker<SMGState> pFeasibilityChecker, StrongestPostOperator<SMGState> pStrongestPostOperator, Configuration pConfig, ShutdownNotifier pShutdownNotifier, CFA pCfa, LogManager pLogger) throws InvalidConfigurationException {
        super(pStrongestPostOperator, pFeasibilityChecker, SMGInterpolantManager.getInstance(new SMGOptions(pConfig), pCfa.getMachineModel(), pLogger, pCfa), SMGState.of(pCfa.getMachineModel(), pLogger, new SMGOptions(pConfig), pCfa), ValueAnalysisCPA.class, pConfig, pShutdownNotifier, pCfa);
    }

    @Override
    public SMGInterpolant deriveInterpolant(ARGPath pErrorPath, CFAEdge pCurrentEdge, Deque<SMGState> pCallstack, PathPosition pOffset, SMGInterpolant pInputInterpolant) throws CPAException, InterruptedException {
        Optional<SMGState> maybeSuccessor;
        super.resetNumberOfInterpolationQueries();
        InterpolantManager interpolantMgr = this.getInterpolationManager();
        SMGState stateFromOldInterpolant = pInputInterpolant.reconstructState();
        if (pCurrentEdge == null) {
            PathIterator it = pOffset.fullPathIterator();
            Optional<SMGState> intermediate = Optional.of(stateFromOldInterpolant);
            while (intermediate.isPresent()) {
                intermediate = this.getInitialSuccessor(intermediate.orElseThrow(), it.getOutgoingEdge(), pCallstack);
                it.advance();
                if (!it.isPositionWithState()) continue;
            }
            maybeSuccessor = intermediate;
        } else {
            maybeSuccessor = this.getInitialSuccessor(stateFromOldInterpolant, pCurrentEdge, pCallstack);
        }
        if (!maybeSuccessor.isPresent()) {
            return (SMGInterpolant)interpolantMgr.getFalseInterpolant();
        }
        SMGState initialSuccessor = maybeSuccessor.orElseThrow();
        if (this.getApplyItpEqualityOptimization() && stateFromOldInterpolant.equals(initialSuccessor)) {
            return pInputInterpolant;
        }
        if (this.getApplyRenamingOptimization() && this.isOnlyVariableRenamingEdge(pCurrentEdge)) {
            return (SMGInterpolant)interpolantMgr.createInterpolant(initialSuccessor);
        }
        ARGPath remainingErrorPath = pOffset.iterator().getSuffixExclusive();
        if (this.getApplyUnsatSuffixOptimization() && pInputInterpolant.isTrue() && initialSuccessor.getSize() > 1 && this.isSuffixContradicting(remainingErrorPath, initialSuccessor)) {
            return ((SMGInterpolant)interpolantMgr.getTrueInterpolant()).addStackFrameInformationAndCopy(initialSuccessor);
        }
        for (MemoryLocation memoryLocation : this.determineMemoryLocationsToInterpolateOn(initialSuccessor)) {
            this.getShutdownNotifier().shutdownIfNecessary();
            if (initialSuccessor.hasPointer(memoryLocation)) continue;
            SMGState oldSuccessor = initialSuccessor;
            initialSuccessor = initialSuccessor.copyAndForget(memoryLocation).getState().copyAndPruneUnreachable();
            try {
                if (!this.isRemainingPathFeasible(remainingErrorPath, initialSuccessor)) continue;
                initialSuccessor = oldSuccessor;
            }
            catch (AssertionError e) {
                if (((Throwable)((Object)e)).getMessage().startsWith("An allocation function was called with a symbolic size.")) {
                    initialSuccessor = oldSuccessor;
                    continue;
                }
                throw e;
            }
        }
        Set<Value> heapValues = initialSuccessor.getTrackedHeapValues();
        for (Value heapValue : heapValues) {
            this.getShutdownNotifier().shutdownIfNecessary();
            FeasibilityChecker checker = this.getFeasibilityChecker();
            if (!(checker instanceof SMGFeasibilityChecker)) break;
            SMGFeasibilityChecker smgFeasibilityChecker = (SMGFeasibilityChecker)checker;
            boolean isSpuriousBefore = smgFeasibilityChecker.isSpurious(remainingErrorPath, initialSuccessor, pCallstack, Optional.empty());
            SMGState oldState = initialSuccessor;
            initialSuccessor = initialSuccessor.removeHeapValue(heapValue);
            boolean isSpuriousAfter = smgFeasibilityChecker.isSpurious(remainingErrorPath, initialSuccessor, pCallstack, Optional.of(heapValue));
            if (isSpuriousBefore || !isSpuriousAfter) continue;
            initialSuccessor = oldState;
        }
        SMGInterpolant sMGInterpolant = (SMGInterpolant)interpolantMgr.createInterpolant(initialSuccessor);
        assert (sMGInterpolant.isSanityIntact());
        return sMGInterpolant;
    }

    private boolean isSuffixContradicting(ARGPath errorPath, SMGState stateForFrameInfo) throws CPAException, InterruptedException {
        return !this.isRemainingPathFeasible(errorPath, ((SMGState)this.getInitalState()).reconstructSMGStateFromNonHeapAssignments(null, null, null, stateForFrameInfo.getMemoryModel().getFunctionDeclarationsFromStackFrames()));
    }
}

