/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2.refiner;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPA;
import org.sosy_lab.cpachecker.cpa.smg2.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.refinement.GenericFeasibilityChecker;
import org.sosy_lab.cpachecker.util.refinement.StrongestPostOperator;

public class SMGFeasibilityChecker
extends GenericFeasibilityChecker<SMGState> {
    private final StrongestPostOperator<SMGState> strongestPostOp;
    private final VariableTrackingPrecision precision;
    private final MachineModel machineModel;
    private final LogManager logger;
    private final Configuration config;
    private final CFA cfa;

    public SMGFeasibilityChecker(StrongestPostOperator<SMGState> pStrongestPostOp, LogManager pLogger, CFA pCfa, Configuration pConfig) throws InvalidConfigurationException {
        super(pStrongestPostOp, SMGState.of(pCfa.getMachineModel(), pLogger, new SMGOptions(pConfig), pCfa), SMGCPA.class, pLogger, pConfig, pCfa);
        this.cfa = pCfa;
        this.strongestPostOp = pStrongestPostOp;
        this.config = pConfig;
        this.precision = VariableTrackingPrecision.createStaticPrecision(this.config, pCfa.getVarClassification(), ValueAnalysisCPA.class);
        this.machineModel = pCfa.getMachineModel();
        this.logger = pLogger;
    }

    public List<Pair<SMGState, List<CFAEdge>>> evaluate(ARGPath path) throws CPAException, InterruptedException {
        try {
            ArrayList<Pair<SMGState, List<CFAEdge>>> reevaluatedPath = new ArrayList<Pair<SMGState, List<CFAEdge>>>();
            SMGState next = SMGState.of(this.machineModel, this.logger, new SMGOptions(this.config), this.cfa);
            if (this.cfa.getMainFunction() instanceof CFunctionEntryNode) {
                CFunctionEntryNode functionNode = (CFunctionEntryNode)this.cfa.getMainFunction();
                next = next.copyAndAddStackFrame(functionNode.getFunctionDefinition());
            }
            PathIterator iterator = path.fullPathIterator();
            while (iterator.hasNext()) {
                ArrayList<CFAEdge> allOutgoingEdges = new ArrayList<CFAEdge>();
                do {
                    CFAEdge outgoingEdge = iterator.getOutgoingEdge();
                    allOutgoingEdges.add(outgoingEdge);
                    Optional<SMGState> successor = this.strongestPostOp.getStrongestPost(next, this.precision, outgoingEdge);
                    iterator.advance();
                    if (!successor.isPresent()) {
                        return reevaluatedPath;
                    }
                    next = successor.orElseThrow();
                } while (!iterator.isPositionWithState());
                reevaluatedPath.add(Pair.of(next, allOutgoingEdges));
            }
            return reevaluatedPath;
        }
        catch (InvalidConfigurationException | CPATransferException e) {
            throw new CPAException("Computation of successor failed for checking path: " + e.getMessage(), e);
        }
    }

    public final boolean isSpurious(ARGPath pPath, SMGState pStartingPoint, Deque<SMGState> pCallstack, Optional<Value> heapValueRemoved) throws CPAException, InterruptedException {
        try {
            SMGState next = pStartingPoint;
            PathIterator iterator = pPath.fullPathIterator();
            while (iterator.hasNext()) {
                AssumeEdge assumeEdge;
                Optional<SMGState> maybeNextComplimentary;
                CFAEdge edge = iterator.getOutgoingEdge();
                iterator.advance();
                if (!iterator.hasNext() && edge instanceof AssumeEdge && (maybeNextComplimentary = this.strongestPostOp.step(next, CFAUtils.getComplimentaryAssumeEdge(assumeEdge = (AssumeEdge)edge), this.precision, pCallstack, pPath)).isEmpty()) {
                    return false;
                }
                Optional<SMGState> maybeNext = this.strongestPostOp.step(next, edge, this.precision, pCallstack, pPath);
                if (maybeNext.isEmpty()) {
                    this.logger.log(Level.FINE, new Object[]{"found path to be infeasible when checking spuriousness: ", edge, " did not yield a successor"});
                    return false;
                }
                if (heapValueRemoved.isEmpty()) {
                    next = maybeNext.orElseThrow();
                    continue;
                }
                next = maybeNext.orElseThrow().removeHeapValue(heapValueRemoved.orElseThrow());
            }
            return true;
        }
        catch (CPATransferException e) {
            throw new CPAException("Computation of successor failed for checking path: " + e.getMessage(), e);
        }
    }
}

