/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2.refiner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentStack;
import org.sosy_lab.cpachecker.cpa.smg2.SMGErrorInfo;
import org.sosy_lab.cpachecker.cpa.smg2.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.SymbolicProgramConfiguration;
import org.sosy_lab.cpachecker.cpa.smg2.util.CFunctionDeclarationAndOptionalValue;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMG2Exception;
import org.sosy_lab.cpachecker.cpa.smg2.util.ValueAndValueSize;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.refinement.Interpolant;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public final class SMGInterpolant
implements Interpolant<SMGState, SMGInterpolant> {
    private final @Nullable PersistentMap<MemoryLocation, ValueAndValueSize> nonHeapAssignments;
    private final @Nullable Map<String, BigInteger> variableNameToMemorySizeInBits;
    private final @Nullable Map<String, CType> variableToTypeMap;
    private final @Nullable PersistentStack<CFunctionDeclarationAndOptionalValue> stackFrameDeclarations;
    private final @Nullable Set<Value> allowedHeapValues;
    private @Nullable SymbolicProgramConfiguration memoryModel;
    private final SMGOptions options;
    private final MachineModel machineModel;
    private final LogManager logger;
    private final CFunctionDeclaration cfaEntryFunctionDeclaration;

    private SMGInterpolant(SMGOptions pOptions, MachineModel pMachineModel, LogManager pLogger, CFunctionDeclaration pCFAEntryFunctionDef) {
        this.options = pOptions;
        this.machineModel = pMachineModel;
        this.logger = pLogger;
        this.nonHeapAssignments = PathCopyingPersistentTreeMap.of();
        this.variableNameToMemorySizeInBits = new HashMap<String, BigInteger>();
        this.variableToTypeMap = new HashMap<String, CType>();
        this.stackFrameDeclarations = PersistentStack.of().pushAndCopy(CFunctionDeclarationAndOptionalValue.of(pCFAEntryFunctionDef, Optional.empty()));
        this.cfaEntryFunctionDeclaration = pCFAEntryFunctionDef;
        this.allowedHeapValues = ImmutableSet.of();
        this.memoryModel = SymbolicProgramConfiguration.of(BigInteger.valueOf(pMachineModel.getSizeofPtrInBits()));
    }

    public SMGInterpolant(SMGOptions pOptions, MachineModel pMachineModel, LogManager pLogger, PersistentMap<MemoryLocation, ValueAndValueSize> pNonHeapAssignments, Map<String, BigInteger> pVariableNameToMemorySizeInBits, Map<String, CType> pVariableToTypeMap, PersistentStack<CFunctionDeclarationAndOptionalValue> pStackFrameDeclarations, CFunctionDeclaration pCfaEntryFunDecl, Set<Value> pAllowedHeapValues, SymbolicProgramConfiguration memMod) {
        this.options = pOptions;
        this.machineModel = pMachineModel;
        this.logger = pLogger;
        this.nonHeapAssignments = pNonHeapAssignments;
        this.variableNameToMemorySizeInBits = pVariableNameToMemorySizeInBits;
        this.variableToTypeMap = pVariableToTypeMap;
        Preconditions.checkArgument((pStackFrameDeclarations == null || pStackFrameDeclarations.size() >= 1 && this.hasEntryFunDef(pStackFrameDeclarations, pCfaEntryFunDecl) ? 1 : 0) != 0);
        this.stackFrameDeclarations = pStackFrameDeclarations;
        Preconditions.checkNotNull((Object)pCfaEntryFunDecl);
        this.cfaEntryFunctionDeclaration = pCfaEntryFunDecl;
        this.allowedHeapValues = pAllowedHeapValues;
        this.memoryModel = memMod;
    }

    public SMGInterpolant(SMGOptions pOptions, MachineModel pMachineModel, LogManager pLogger, PersistentMap<MemoryLocation, ValueAndValueSize> pNonHeapAssignments, Map<String, BigInteger> pVariableNameToMemorySizeInBits, Map<String, CType> pVariableToTypeMap, PersistentStack<CFunctionDeclarationAndOptionalValue> pStackFrameDeclarations, CFunctionDeclaration pCfaEntryFunDecl, Set<Value> pAllowedHeapValues) {
        this.options = pOptions;
        this.machineModel = pMachineModel;
        this.logger = pLogger;
        this.nonHeapAssignments = pNonHeapAssignments;
        this.variableNameToMemorySizeInBits = pVariableNameToMemorySizeInBits;
        this.variableToTypeMap = pVariableToTypeMap;
        Preconditions.checkArgument((pStackFrameDeclarations == null || pStackFrameDeclarations.size() >= 1 && this.hasEntryFunDef(pStackFrameDeclarations, pCfaEntryFunDecl) ? 1 : 0) != 0);
        this.stackFrameDeclarations = pStackFrameDeclarations;
        Preconditions.checkNotNull((Object)pCfaEntryFunDecl);
        this.cfaEntryFunctionDeclaration = pCfaEntryFunDecl;
        this.allowedHeapValues = pAllowedHeapValues;
        try {
            this.memoryModel = SMGState.of(this.machineModel, SymbolicProgramConfiguration.of(BigInteger.valueOf(pMachineModel.getSizeofPtrInBits())), this.logger, this.options, (List<SMGErrorInfo>)ImmutableList.of()).reconstructStackFrames(this.stackFrameDeclarations).reconstructSMGStateFromNonHeapAssignments(this.nonHeapAssignments, this.variableNameToMemorySizeInBits, this.variableToTypeMap, this.stackFrameDeclarations).getMemoryModel();
        }
        catch (SMG2Exception e) {
            this.memoryModel = SymbolicProgramConfiguration.of(BigInteger.valueOf(pMachineModel.getSizeofPtrInBits()));
        }
    }

    private boolean hasEntryFunDef(PersistentStack<CFunctionDeclarationAndOptionalValue> pStackFrameDeclarations, CFunctionDeclaration pCfaEntryFunDecl) {
        CFunctionDeclaration firstDef = null;
        Iterator<CFunctionDeclarationAndOptionalValue> iterator = pStackFrameDeclarations.iterator();
        if (iterator.hasNext()) {
            CFunctionDeclarationAndOptionalValue fundef = iterator.next();
            firstDef = fundef.getCFunctionDeclaration();
        }
        Preconditions.checkNotNull(firstDef);
        return firstDef == pCfaEntryFunDecl;
    }

    public static SMGInterpolant createInitial(SMGOptions pOptions, MachineModel pMachineModel, LogManager pLogger, CFunctionEntryNode cfaFuncEntryNode) {
        return new SMGInterpolant(pOptions, pMachineModel, pLogger, cfaFuncEntryNode.getFunctionDefinition());
    }

    public static SMGInterpolant createTRUE(SMGOptions pOptions, MachineModel pMachineModel, LogManager pLogger, CFunctionEntryNode cfaFuncEntryNode) {
        return SMGInterpolant.createInitial(pOptions, pMachineModel, pLogger, cfaFuncEntryNode);
    }

    public SMGInterpolant addStackFrameInformationAndCopy(SMGState stateForFrameInfo) {
        return new SMGInterpolant(this.options, this.machineModel, this.logger, this.nonHeapAssignments, this.variableNameToMemorySizeInBits, this.variableToTypeMap, stateForFrameInfo.getMemoryModel().getFunctionDeclarationsFromStackFrames(), this.cfaEntryFunctionDeclaration, this.allowedHeapValues, this.memoryModel);
    }

    public static SMGInterpolant createFALSE(SMGOptions pOptions, MachineModel pMachineModel, LogManager pLogger, CFunctionDeclaration cfaEntryFuncDef) {
        return new SMGInterpolant(pOptions, pMachineModel, pLogger, null, null, null, null, cfaEntryFuncDef, null, null);
    }

    @Override
    public Set<MemoryLocation> getMemoryLocations() {
        return this.isFalse() ? ImmutableSet.of() : Collections.unmodifiableSet(this.nonHeapAssignments.keySet());
    }

    @Override
    public SMGInterpolant join(SMGInterpolant other) {
        if (this.nonHeapAssignments == null || other.nonHeapAssignments == null || this.memoryModel == null) {
            return SMGInterpolant.createFALSE(this.options, this.machineModel, this.logger, this.cfaEntryFunctionDeclaration);
        }
        PersistentMap newAssignment = this.nonHeapAssignments;
        for (Map.Entry entry : other.nonHeapAssignments.entrySet()) {
            if (newAssignment.containsKey(entry.getKey())) assert (((ValueAndValueSize)entry.getValue()).equals(other.nonHeapAssignments.get(entry.getKey()))) : "interpolants mismatch in " + entry.getKey();
            newAssignment = newAssignment.putAndCopy((Object)((MemoryLocation)entry.getKey()), (Object)((ValueAndValueSize)entry.getValue()));
            String thisEntryQualName = ((MemoryLocation)entry.getKey()).getQualifiedName();
            this.variableNameToMemorySizeInBits.put(thisEntryQualName, other.variableNameToMemorySizeInBits.get(thisEntryQualName));
            this.variableToTypeMap.put(thisEntryQualName, other.variableToTypeMap.get(thisEntryQualName));
            assert (Objects.equals(((ValueAndValueSize)entry.getValue()).getSizeInBits(), ((ValueAndValueSize)other.nonHeapAssignments.get(entry.getKey())).getSizeInBits())) : "interpolants mismatch in " + entry.getKey();
        }
        @Nullable PersistentStack<CFunctionDeclarationAndOptionalValue> stackFrameDecl = this.stackFrameDeclarations;
        if (stackFrameDecl == null || other.stackFrameDeclarations != null && other.stackFrameDeclarations.size() > stackFrameDecl.size()) {
            stackFrameDecl = other.stackFrameDeclarations;
        }
        return new SMGInterpolant(this.options, this.machineModel, this.logger, (PersistentMap<MemoryLocation, ValueAndValueSize>)newAssignment, this.variableNameToMemorySizeInBits, this.variableToTypeMap, stackFrameDecl, this.cfaEntryFunctionDeclaration, (Set<Value>)ImmutableSet.builder().addAll(this.allowedHeapValues).addAll(other.allowedHeapValues).build(), this.memoryModel);
    }

    public int hashCode() {
        return Objects.hashCode(this.nonHeapAssignments);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SMGInterpolant other = (SMGInterpolant)obj;
        return Objects.equals(this.nonHeapAssignments, other.nonHeapAssignments) && Objects.equals(this.allowedHeapValues, other.allowedHeapValues);
    }

    @Override
    public boolean isTrue() {
        return !this.isFalse() && this.nonHeapAssignments.isEmpty() && this.allowedHeapValues.isEmpty();
    }

    @Override
    public boolean isFalse() {
        return this.nonHeapAssignments == null && this.allowedHeapValues == null;
    }

    public Set<Value> getAllowedHeapValues() {
        if (this.allowedHeapValues == null) {
            return ImmutableSet.of();
        }
        return this.allowedHeapValues;
    }

    @Override
    public SMGState reconstructState() {
        if (this.nonHeapAssignments == null) {
            throw new IllegalStateException("Can't reconstruct state from FALSE-interpolant");
        }
        return SMGState.of(this.machineModel, this.memoryModel, this.logger, this.options, (List<SMGErrorInfo>)ImmutableList.of()).reconstructStackFrames(this.stackFrameDeclarations);
    }

    public String toString() {
        if (this.isFalse()) {
            return "FALSE";
        }
        if (this.isTrue()) {
            return "TRUE";
        }
        return this.nonHeapAssignments.toString() + "\nAllowed heap values: " + this.allowedHeapValues;
    }

    public SMGInterpolant weaken(Set<String> toRetain) {
        if (this.isTrivial()) {
            return this;
        }
        PersistentMap weakenedAssignments = this.nonHeapAssignments;
        for (MemoryLocation current : this.nonHeapAssignments.keySet()) {
            if (toRetain.contains(current.getExtendedQualifiedName())) continue;
            weakenedAssignments = weakenedAssignments.removeAndCopy((Object)current);
            this.variableNameToMemorySizeInBits.remove(current.getQualifiedName());
        }
        return new SMGInterpolant(this.options, this.machineModel, this.logger, (PersistentMap<MemoryLocation, ValueAndValueSize>)weakenedAssignments, this.variableNameToMemorySizeInBits, this.variableToTypeMap, this.stackFrameDeclarations, this.cfaEntryFunctionDeclaration, this.allowedHeapValues, this.memoryModel);
    }

    @Override
    public int getSize() {
        return this.isTrivial() ? 0 : this.nonHeapAssignments.size();
    }

    public boolean isSanityIntact() {
        ImmutableSet.Builder availableFunctionsBuilder = ImmutableSet.builder();
        for (CFunctionDeclarationAndOptionalValue fundef : this.stackFrameDeclarations) {
            availableFunctionsBuilder.add((Object)fundef.getCFunctionDeclaration().getQualifiedName());
        }
        ImmutableSet availableFunctions = availableFunctionsBuilder.build();
        for (MemoryLocation assignment : this.nonHeapAssignments.keySet()) {
            if (!assignment.isOnFunctionStack() || availableFunctions.contains((Object)assignment.getFunctionName())) continue;
            return false;
        }
        return true;
    }
}

