/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2.refiner;

import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smg2.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.refiner.SMGInterpolant;
import org.sosy_lab.cpachecker.util.refinement.InterpolantManager;

public class SMGInterpolantManager
implements InterpolantManager<SMGState, SMGInterpolant> {
    private final SMGOptions options;
    private final MachineModel machineModel;
    private final LogManager logger;
    private final CFA cfa;

    private SMGInterpolantManager(SMGOptions pOptions, MachineModel pMachineModel, LogManager pLogger, CFA pCfa) {
        this.options = pOptions;
        this.machineModel = pMachineModel;
        this.logger = pLogger;
        this.cfa = pCfa;
    }

    public static SMGInterpolantManager getInstance(SMGOptions pOptions, MachineModel pMachineModel, LogManager pLogger, CFA pCfa) {
        return new SMGInterpolantManager(pOptions, pMachineModel, pLogger, pCfa);
    }

    @Override
    public SMGInterpolant createInitialInterpolant() {
        return SMGInterpolant.createInitial(this.options, this.machineModel, this.logger, (CFunctionEntryNode)this.cfa.getMainFunction());
    }

    @Override
    public SMGInterpolant createInterpolant(SMGState state) {
        return state.createInterpolant();
    }

    @Override
    public SMGInterpolant getTrueInterpolant() {
        return SMGInterpolant.createTRUE(this.options, this.machineModel, this.logger, (CFunctionEntryNode)this.cfa.getMainFunction());
    }

    @Override
    public SMGInterpolant getFalseInterpolant() {
        return SMGInterpolant.createFALSE(this.options, this.machineModel, this.logger, (CFunctionDeclaration)this.cfa.getMainFunction().getFunctionDefinition());
    }
}

