/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2.refiner;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.conditions.path.AssignmentsInPathCondition;
import org.sosy_lab.cpachecker.cpa.smg2.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.refiner.SMGEdgeInterpolator;
import org.sosy_lab.cpachecker.cpa.smg2.refiner.SMGInterpolant;
import org.sosy_lab.cpachecker.cpa.smg2.refiner.SMGInterpolantManager;
import org.sosy_lab.cpachecker.cpa.smg2.refiner.SMGUseDefBasedInterpolator;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.refinement.FeasibilityChecker;
import org.sosy_lab.cpachecker.util.refinement.GenericPathInterpolator;
import org.sosy_lab.cpachecker.util.refinement.GenericPrefixProvider;
import org.sosy_lab.cpachecker.util.refinement.StrongestPostOperator;
import org.sosy_lab.cpachecker.util.refinement.UseDefRelation;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

@Options(prefix="cpa.smg2.refinement")
public class SMGPathInterpolator
extends GenericPathInterpolator<SMGState, SMGInterpolant> {
    @Option(secure=true, description="whether to perform (more precise) edge-based interpolation or (more efficient) path-based interpolation")
    private boolean performEdgeBasedInterpolation = true;
    @Option(secure=true, description="whether or not to do lazy-abstraction")
    private boolean doLazyAbstraction = true;
    private AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState assignments = null;
    private final CFA cfa;
    private final SMGInterpolantManager interpolantManager;
    private final Configuration config;
    private final LogManager logger;

    public SMGPathInterpolator(FeasibilityChecker<SMGState> pFeasibilityChecker, StrongestPostOperator<SMGState> pStrongestPostOperator, GenericPrefixProvider<SMGState> pPrefixProvider, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InvalidConfigurationException {
        super(new SMGEdgeInterpolator(pFeasibilityChecker, pStrongestPostOperator, pConfig, pShutdownNotifier, pCfa, pLogger), pFeasibilityChecker, pPrefixProvider, SMGInterpolantManager.getInstance(new SMGOptions(pConfig), pCfa.getMachineModel(), pLogger, pCfa), pConfig, pLogger, pShutdownNotifier, pCfa);
        pConfig.inject((Object)this);
        this.cfa = pCfa;
        this.interpolantManager = SMGInterpolantManager.getInstance(new SMGOptions(pConfig), pCfa.getMachineModel(), pLogger, pCfa);
        this.config = pConfig;
        this.logger = pLogger;
    }

    @Override
    public Map<ARGState, SMGInterpolant> performInterpolation(ARGPath errorPath, SMGInterpolant interpolant) throws CPAException, InterruptedException {
        if (this.performEdgeBasedInterpolation) {
            return super.performInterpolation(errorPath, interpolant);
        }
        this.totalInterpolations.inc();
        ARGPath errorPathPrefix = this.performRefinementSelection(errorPath, interpolant);
        this.timerInterpolation.start();
        Map<ARGState, SMGInterpolant> interpolants = this.performPathBasedInterpolation(errorPathPrefix);
        this.timerInterpolation.stop();
        this.propagateFalseInterpolant(errorPath, errorPathPrefix, interpolants);
        return interpolants;
    }

    private Map<ARGState, SMGInterpolant> performPathBasedInterpolation(ARGPath errorPathPrefix) {
        ImmutableSet booleanVariables = this.cfa.getVarClassification().isPresent() ? this.cfa.getVarClassification().orElseThrow().getIntBoolVars() : ImmutableSet.of();
        UseDefRelation useDefRelation = new UseDefRelation(errorPathPrefix, (Set<String>)booleanVariables, !this.isRefinementSelectionEnabled());
        Map<ARGState, SMGInterpolant> interpolants = new SMGUseDefBasedInterpolator(errorPathPrefix, useDefRelation, this.cfa.getMachineModel(), this.config, this.logger, this.cfa).obtainInterpolantsAsMap();
        this.totalInterpolationQueries.setNextValue(1);
        int size = 0;
        for (SMGInterpolant itp : interpolants.values()) {
            size += itp.getSize();
        }
        this.sizeOfInterpolant.setNextValue(size);
        return interpolants;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public Multimap<CFANode, MemoryLocation> determinePrecisionIncrement(ARGPath errorPath) throws CPAException, InterruptedException {
        this.assignments = AbstractStates.extractStateByType(errorPath.getLastState(), AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState.class);
        HashMultimap increment = HashMultimap.create();
        Map<ARGState, SMGInterpolant> itps = this.performInterpolation(errorPath, this.interpolantManager.createInitialInterpolant());
        for (Map.Entry<ARGState, SMGInterpolant> itp : itps.entrySet()) {
            this.addToPrecisionIncrement((Multimap<CFANode, MemoryLocation>)increment, AbstractStates.extractLocation(itp.getKey()), itp.getValue());
        }
        return increment;
    }

    private void addToPrecisionIncrement(Multimap<CFANode, MemoryLocation> increment, CFANode currentNode, SMGInterpolant itp) {
        for (MemoryLocation memoryLocation : itp.getMemoryLocations()) {
            if (this.assignments != null && this.assignments.exceedsThreshold(memoryLocation)) continue;
            increment.put((Object)currentNode, (Object)memoryLocation);
        }
    }

    public Pair<ARGState, CFAEdge> determineRefinementRoot(ARGPath errorPath, Multimap<CFANode, MemoryLocation> increment) throws RefinementFailedException {
        if (this.interpolationOffset == -1) {
            throw new RefinementFailedException(RefinementFailedException.Reason.InterpolationFailed, errorPath);
        }
        if (this.doLazyAbstraction) {
            PathIterator it = errorPath.pathIterator();
            for (int i = 0; i < this.interpolationOffset; ++i) {
                it.advance();
            }
            return Pair.of(it.getAbstractState(), it.getIncomingEdge());
        }
        PathIterator firstElem = errorPath.pathIterator();
        firstElem.advance();
        return Pair.of(firstElem.getAbstractState(), firstElem.getOutgoingEdge());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected ARGPath sliceErrorPath(ARGPath pErrorPathPrefix) throws CPAException, InterruptedException {
        if (!this.isPathSlicingPossible(pErrorPathPrefix)) {
            return pErrorPathPrefix;
        }
        Set<ARGState> useDefStates = new UseDefRelation(pErrorPathPrefix, this.cfa.getVarClassification().isPresent() ? this.cfa.getVarClassification().orElseThrow().getIntBoolVars() : ImmutableSet.of(), false).getUseDefStates();
        ArrayDeque<Triple<FunctionCallEdge, Boolean, Integer>> functionCalls = new ArrayDeque<Triple<FunctionCallEdge, Boolean, Integer>>();
        ArrayList<CFAEdge> abstractEdges = new ArrayList<CFAEdge>(pErrorPathPrefix.getInnerEdges());
        PathIterator iterator = pErrorPathPrefix.pathIterator();
        while (iterator.hasNext()) {
            CFAEdge originalEdge = iterator.getOutgoingEdge();
            if (!useDefStates.contains(iterator.getAbstractState())) {
                void var7_10;
                CFANode endNode;
                if (originalEdge == null) {
                    CFANode cFANode = AbstractStates.extractLocation(iterator.getAbstractState());
                    endNode = AbstractStates.extractLocation(iterator.getNextAbstractState());
                } else {
                    CFANode cFANode = originalEdge.getPredecessor();
                    endNode = originalEdge.getSuccessor();
                }
                abstractEdges.set(iterator.getIndex(), new BlankEdge(originalEdge == null ? "" : originalEdge.getRawStatement(), originalEdge == null ? FileLocation.DUMMY : originalEdge.getFileLocation(), (CFANode)var7_10, endNode, "sliced edge"));
            }
            if (originalEdge != null) {
                CFAEdgeType cFAEdgeType = originalEdge.getEdgeType();
                if (cFAEdgeType == CFAEdgeType.FunctionCallEdge) {
                    boolean isAbstractEdgeFunctionCall = ((CFAEdge)abstractEdges.get(iterator.getIndex())).getEdgeType() == CFAEdgeType.FunctionCallEdge;
                    functionCalls.push(Triple.of((FunctionCallEdge)originalEdge, isAbstractEdgeFunctionCall, iterator.getIndex()));
                }
                if (cFAEdgeType == CFAEdgeType.FunctionReturnEdge) {
                    Triple functionCallInfo = (Triple)functionCalls.pop();
                    if (((Boolean)functionCallInfo.getSecond()).booleanValue() && ((CFAEdge)abstractEdges.get(iterator.getIndex())).getEdgeType() == CFAEdgeType.BlankEdge) {
                        abstractEdges.set(iterator.getIndex(), originalEdge);
                    } else if (!((Boolean)functionCallInfo.getSecond()).booleanValue() && ((CFAEdge)abstractEdges.get(iterator.getIndex())).getEdgeType() == CFAEdgeType.FunctionReturnEdge) {
                        abstractEdges.set((Integer)functionCallInfo.getThird(), (CFAEdge)functionCallInfo.getFirst());
                        for (int j = iterator.getIndex(); j >= 0; --j) {
                            if (functionCallInfo.getFirst() != abstractEdges.get(j)) continue;
                            abstractEdges.set(j, (CFAEdge)functionCallInfo.getFirst());
                            break;
                        }
                    }
                }
            }
            iterator.advance();
        }
        for (Triple triple : functionCalls) {
            abstractEdges.set((Integer)triple.getThird(), (CFAEdge)triple.getFirst());
        }
        ARGPath slicedErrorPathPrefix = new ARGPath((List<ARGState>)pErrorPathPrefix.asStatesList(), (List<CFAEdge>)abstractEdges);
        return this.isFeasible(slicedErrorPathPrefix) ? pErrorPathPrefix : slicedErrorPathPrefix;
    }
}

