/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2.refiner;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Deque;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.conditions.path.AssignmentsInPathCondition;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPAExportOptions;
import org.sosy_lab.cpachecker.cpa.smg2.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.SMGTransferRelation;
import org.sosy_lab.cpachecker.cpa.value.symbolic.ConstraintsStrengthenOperator;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.refinement.StrongestPostOperator;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class SMGStrongestPostOperator
implements StrongestPostOperator<SMGState> {
    private final SMGTransferRelation transfer;

    public SMGStrongestPostOperator(LogManager pLogger, Configuration pConfig, CFA pCfa) throws InvalidConfigurationException {
        SMGOptions options = new SMGOptions(pConfig);
        SMGCPAExportOptions exportOptions = new SMGCPAExportOptions(options.getExportSMGFilePattern(), options.getExportSMGLevel());
        this.transfer = new SMGTransferRelation(pLogger, options, exportOptions, pCfa, new ConstraintsStrengthenOperator(pConfig, pLogger), null);
    }

    @Override
    public Optional<SMGState> getStrongestPost(SMGState pOrigin, Precision pPrecision, CFAEdge pOperation) throws CPAException, InterruptedException {
        Collection successors = this.transfer.getAbstractSuccessorsForEdge(pOrigin, pPrecision, pOperation);
        if (successors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((SMGState)Iterables.getOnlyElement(successors));
    }

    @Override
    public SMGState handleFunctionCall(SMGState state, CFAEdge edge, Deque<SMGState> callstack) {
        callstack.push(state);
        return state;
    }

    @Override
    public SMGState handleFunctionReturn(SMGState next, CFAEdge edge, Deque<SMGState> callstack) {
        callstack.pop();
        return next;
    }

    @Override
    public SMGState performAbstraction(SMGState pNext, CFANode pCurrNode, ARGPath pErrorPath, Precision pPrecision) {
        assert (pPrecision instanceof VariableTrackingPrecision);
        SMGState nextState = pNext;
        VariableTrackingPrecision precision = (VariableTrackingPrecision)pPrecision;
        boolean performAbstraction = precision.allowsAbstraction();
        Set<MemoryLocation> exceedingMemoryLocations = this.obtainExceedingMemoryLocations(pErrorPath);
        if (performAbstraction) {
            for (MemoryLocation memoryLocation : nextState.getMemoryModel().getMemoryLocationsAndValuesForSPCWithoutHeap().keySet()) {
                CType trackedType;
                if (precision.isTracking(memoryLocation, trackedType = nextState.getMemoryModel().getTypeOfVariable(memoryLocation), pCurrNode)) continue;
                nextState = nextState.copyAndForget(memoryLocation).getState();
            }
        }
        for (MemoryLocation exceedingMemoryLocation : exceedingMemoryLocations) {
            nextState = nextState.copyAndForget(exceedingMemoryLocation).getState();
        }
        return nextState;
    }

    protected Set<MemoryLocation> obtainExceedingMemoryLocations(ARGPath pPath) {
        AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState assignments = AbstractStates.extractStateByType(pPath.getLastState(), AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState.class);
        if (assignments == null) {
            return ImmutableSet.of();
        }
        return assignments.getMemoryLocationsExceedingThreshold();
    }
}

