/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2.refiner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.smg2.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg2.refiner.SMGInterpolant;
import org.sosy_lab.cpachecker.cpa.smg2.util.ValueAndValueSize;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.refinement.UseDefRelation;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class SMGUseDefBasedInterpolator {
    private final UseDefRelation useDefRelation;
    private final ARGPath slicedPrefix;
    private final MachineModel machineModel;
    private final CFA cfa;
    private final SMGOptions options;
    private final LogManager logger;

    public SMGUseDefBasedInterpolator(ARGPath pSlicedPrefix, UseDefRelation pUseDefRelation, MachineModel pMachineModel, Configuration pConfig, LogManager pLogger, CFA pCfa) {
        this.slicedPrefix = pSlicedPrefix;
        this.useDefRelation = pUseDefRelation;
        this.machineModel = pMachineModel;
        try {
            this.options = new SMGOptions(pConfig);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.logger = pLogger;
        this.cfa = pCfa;
    }

    public List<Pair<ARGState, SMGInterpolant>> obtainInterpolants() {
        Map<ARGState, Collection<ASimpleDeclaration>> useDefSequence = this.useDefRelation.getExpandedUses(this.slicedPrefix);
        SMGInterpolant trivialItp = SMGInterpolant.createFALSE(this.options, this.machineModel, this.logger, (CFunctionDeclaration)this.cfa.getMainFunction().getFunctionDefinition());
        ArrayList<Pair<ARGState, SMGInterpolant>> interpolants = new ArrayList<Pair<ARGState, SMGInterpolant>>();
        PathIterator iterator = this.slicedPrefix.reversePathIterator();
        while (iterator.hasNext()) {
            iterator.advance();
            ARGState state = iterator.getAbstractState();
            Collection<ASimpleDeclaration> uses = useDefSequence.get(state);
            SMGInterpolant interpolant = uses.isEmpty() ? trivialItp : this.createInterpolant(uses);
            interpolants.add(Pair.of(state, interpolant));
            if (interpolant == trivialItp) continue;
            trivialItp = SMGInterpolant.createTRUE(this.options, this.machineModel, this.logger, (CFunctionEntryNode)this.cfa.getMainFunction());
        }
        return Lists.reverse(interpolants);
    }

    public Map<ARGState, SMGInterpolant> obtainInterpolantsAsMap() {
        LinkedHashMap<ARGState, SMGInterpolant> interpolants = new LinkedHashMap<ARGState, SMGInterpolant>();
        for (Pair<ARGState, SMGInterpolant> itp : this.obtainInterpolants()) {
            interpolants.put(itp.getFirst(), itp.getSecond());
        }
        return interpolants;
    }

    private SMGInterpolant createInterpolant(Collection<ASimpleDeclaration> uses) {
        PersistentSortedMap useDefInterpolant = PathCopyingPersistentTreeMap.of();
        for (ASimpleDeclaration use : uses) {
            for (MemoryLocation memoryLocation : this.obtainMemoryLocationsForType(use)) {
                useDefInterpolant = useDefInterpolant.putAndCopy((Object)memoryLocation, (Object)ValueAndValueSize.of(Value.UnknownValue.getInstance(), null));
            }
        }
        return new SMGInterpolant(this.options, this.machineModel, this.logger, (PersistentMap<MemoryLocation, ValueAndValueSize>)useDefInterpolant, null, null, null, (CFunctionDeclaration)this.cfa.getMainFunction().getFunctionDefinition(), (Set<Value>)ImmutableSet.of());
    }

    private ImmutableList<MemoryLocation> obtainMemoryLocationsForType(ASimpleDeclaration use) {
        return ((CType)use.getType()).accept(new MemoryLocationCreator(use.getQualifiedName(), this.machineModel));
    }

    private static class MemoryLocationCreator
    implements CTypeVisitor<ImmutableList<MemoryLocation>, IllegalArgumentException> {
        private final String qualifiedName;
        private final MachineModel model;
        private long currentOffset = 0L;
        private boolean withinComplexType = false;

        private MemoryLocationCreator(String pQualifiedName, MachineModel pModel) {
            this.model = pModel;
            this.qualifiedName = pQualifiedName;
        }

        @Override
        public ImmutableList<MemoryLocation> visit(CArrayType pArrayType) {
            this.withinComplexType = true;
            CExpression arrayLength = pArrayType.getLength();
            if (arrayLength instanceof CIntegerLiteralExpression) {
                int length = ((CIntegerLiteralExpression)arrayLength).getValue().intValue();
                return this.createMemoryLocationsForArray(length, pArrayType.getType());
            }
            return this.createSingleMemoryLocation(this.model.getSizeofPtr());
        }

        @Override
        public ImmutableList<MemoryLocation> visit(CCompositeType pCompositeType) {
            this.withinComplexType = true;
            switch (pCompositeType.getKind()) {
                case STRUCT: {
                    return this.createMemoryLocationsForStructure(pCompositeType);
                }
                case UNION: {
                    return this.createMemoryLocationsForUnion(pCompositeType);
                }
            }
            throw new AssertionError();
        }

        @Override
        public ImmutableList<MemoryLocation> visit(CElaboratedType pElaboratedType) {
            this.withinComplexType = true;
            CComplexType definition = pElaboratedType.getRealType();
            if (definition != null) {
                return definition.accept(this);
            }
            switch (pElaboratedType.getKind()) {
                default: 
            }
            return this.createSingleMemoryLocation(this.model.getSizeofInt());
        }

        @Override
        public ImmutableList<MemoryLocation> visit(CEnumType pEnumType) {
            return this.createSingleMemoryLocation(this.model.getSizeofInt());
        }

        @Override
        public ImmutableList<MemoryLocation> visit(CFunctionType pFunctionType) {
            return this.createSingleMemoryLocation(this.model.getSizeofPtr());
        }

        @Override
        public ImmutableList<MemoryLocation> visit(CPointerType pPointerType) {
            return this.createSingleMemoryLocation(this.model.getSizeofPtr());
        }

        @Override
        public ImmutableList<MemoryLocation> visit(CProblemType pProblemType) {
            throw new IllegalArgumentException("Unknown C-Type: " + pProblemType.getClass());
        }

        @Override
        public ImmutableList<MemoryLocation> visit(CSimpleType pSimpleType) {
            return this.createSingleMemoryLocation(this.model.getSizeof(pSimpleType));
        }

        @Override
        public ImmutableList<MemoryLocation> visit(CTypedefType pTypedefType) {
            return pTypedefType.getRealType().accept(this);
        }

        @Override
        public ImmutableList<MemoryLocation> visit(CVoidType pVoidType) {
            return this.createSingleMemoryLocation(this.model.getSizeofVoid());
        }

        private ImmutableList<MemoryLocation> createSingleMemoryLocation(long pSize) {
            if (this.withinComplexType) {
                ImmutableList memory = ImmutableList.of((Object)MemoryLocation.fromQualifiedName(this.qualifiedName, this.currentOffset));
                this.currentOffset += pSize;
                return memory;
            }
            return ImmutableList.of((Object)MemoryLocation.fromQualifiedName(this.qualifiedName));
        }

        private ImmutableList<MemoryLocation> createMemoryLocationsForArray(int pLength, CType pType) {
            long sizeOfType = this.model.getSizeof(pType).longValueExact();
            ImmutableList.Builder memoryLocationsForArray = ImmutableList.builderWithExpectedSize((int)pLength);
            for (int i = 0; i < pLength; ++i) {
                memoryLocationsForArray.addAll(this.createSingleMemoryLocation(sizeOfType));
            }
            return memoryLocationsForArray.build();
        }

        private ImmutableList<MemoryLocation> createMemoryLocationsForStructure(CCompositeType pCompositeType) {
            ImmutableList.Builder memoryLocationsForStructure = ImmutableList.builder();
            for (CCompositeType.CCompositeTypeMemberDeclaration member : pCompositeType.getMembers()) {
                memoryLocationsForStructure.addAll((Iterable)member.getType().accept(this));
            }
            return memoryLocationsForStructure.build();
        }

        private ImmutableList<MemoryLocation> createMemoryLocationsForUnion(CCompositeType pCompositeType) {
            return this.createSingleMemoryLocation(this.model.getSizeof(pCompositeType).longValueExact());
        }

        @Override
        public ImmutableList<MemoryLocation> visit(CBitFieldType pCBitFieldType) {
            return this.createSingleMemoryLocation(this.model.getSizeof(pCBitFieldType).longValueExact());
        }
    }
}

