/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2.util;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGObjectAndOffset;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;

public class SMGObjectAndOffsetOrSMGState {
    private final @Nullable SMGObject object;
    private final @Nullable BigInteger offset;
    private final @Nullable SMGState state;
    private final boolean newErrorState;

    private SMGObjectAndOffsetOrSMGState(SMGObject pObject, BigInteger pOffset) {
        this.object = pObject;
        this.offset = pOffset;
        this.state = null;
        this.newErrorState = false;
    }

    private SMGObjectAndOffsetOrSMGState(SMGState pState) {
        this.object = null;
        this.offset = null;
        this.state = pState;
        this.newErrorState = false;
    }

    private SMGObjectAndOffsetOrSMGState(SMGState pState, boolean pNewErrorState) {
        this.object = null;
        this.offset = null;
        this.state = pState;
        this.newErrorState = pNewErrorState;
    }

    public static SMGObjectAndOffsetOrSMGState of(SMGObject pObject, BigInteger pOffset) {
        Preconditions.checkNotNull((Object)pObject);
        Preconditions.checkNotNull((Object)pOffset);
        return new SMGObjectAndOffsetOrSMGState(pObject, pOffset);
    }

    public static SMGObjectAndOffsetOrSMGState of(SMGObjectAndOffset objAndOffset) {
        Preconditions.checkNotNull((Object)objAndOffset);
        return new SMGObjectAndOffsetOrSMGState(objAndOffset.getSMGObject(), objAndOffset.getOffsetForObject());
    }

    public static SMGObjectAndOffsetOrSMGState of(SMGState pState) {
        Preconditions.checkNotNull((Object)pState);
        return new SMGObjectAndOffsetOrSMGState(pState);
    }

    public static SMGObjectAndOffsetOrSMGState ofErrorState(SMGState pState) {
        Preconditions.checkNotNull((Object)pState);
        return new SMGObjectAndOffsetOrSMGState(pState, true);
    }

    public static SMGObjectAndOffsetOrSMGState withZeroOffset(SMGObject pObject) {
        Preconditions.checkNotNull((Object)pObject);
        return new SMGObjectAndOffsetOrSMGState(pObject, BigInteger.ZERO);
    }

    public SMGObject getSMGObject() {
        Preconditions.checkArgument((this.state == null ? 1 : 0) != 0);
        Preconditions.checkArgument((this.object != null ? 1 : 0) != 0);
        Preconditions.checkArgument((this.offset != null ? 1 : 0) != 0);
        return this.object;
    }

    public BigInteger getOffsetForObject() {
        Preconditions.checkArgument((this.state == null ? 1 : 0) != 0);
        Preconditions.checkArgument((this.object != null ? 1 : 0) != 0);
        Preconditions.checkArgument((this.offset != null ? 1 : 0) != 0);
        return this.offset;
    }

    public SMGState getSMGState() {
        Preconditions.checkArgument((this.state != null ? 1 : 0) != 0);
        Preconditions.checkArgument((this.object == null ? 1 : 0) != 0);
        Preconditions.checkArgument((this.offset == null ? 1 : 0) != 0);
        return this.state;
    }

    public boolean hasSMGState() {
        return this.state != null;
    }

    public boolean hasSMGObjectAndOffset() {
        return this.object != null && this.offset != null;
    }

    public boolean hasNewErrorState() {
        return this.newErrorState && this.state != null;
    }
}

