/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2.util;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.Optional;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGObjectAndOffset;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;

public class SMGStateAndOptionalSMGObjectAndOffset {
    private final Optional<SMGObject> object;
    private final Optional<BigInteger> offset;
    private final SMGState state;

    private SMGStateAndOptionalSMGObjectAndOffset(SMGObject pObject, BigInteger pOffset, SMGState pState) {
        this.object = Optional.of(pObject);
        this.offset = Optional.of(pOffset);
        this.state = pState;
    }

    private SMGStateAndOptionalSMGObjectAndOffset(SMGState pState) {
        this.object = Optional.empty();
        this.offset = Optional.empty();
        this.state = pState;
    }

    public static SMGStateAndOptionalSMGObjectAndOffset of(SMGObject pObject, BigInteger pOffset, SMGState pState) {
        Preconditions.checkNotNull((Object)pObject);
        Preconditions.checkNotNull((Object)pOffset);
        Preconditions.checkNotNull((Object)pState);
        return new SMGStateAndOptionalSMGObjectAndOffset(pObject, pOffset, pState);
    }

    public static SMGStateAndOptionalSMGObjectAndOffset of(SMGObjectAndOffset objAndOff, SMGState pState) {
        Preconditions.checkNotNull((Object)objAndOff);
        Preconditions.checkNotNull((Object)pState);
        return new SMGStateAndOptionalSMGObjectAndOffset(objAndOff.getSMGObject(), objAndOff.getOffsetForObject(), pState);
    }

    public static SMGStateAndOptionalSMGObjectAndOffset of(SMGState pState) {
        Preconditions.checkNotNull((Object)pState);
        return new SMGStateAndOptionalSMGObjectAndOffset(pState);
    }

    public static SMGStateAndOptionalSMGObjectAndOffset withZeroOffset(SMGObject pObject, SMGState pState) {
        Preconditions.checkNotNull((Object)pObject);
        Preconditions.checkNotNull((Object)pState);
        return new SMGStateAndOptionalSMGObjectAndOffset(pObject, BigInteger.ZERO, pState);
    }

    public SMGObject getSMGObject() {
        return this.object.orElseThrow();
    }

    public BigInteger getOffsetForObject() {
        return this.offset.orElseThrow();
    }

    public SMGState getSMGState() {
        return this.state;
    }

    public boolean hasSMGObjectAndOffset() {
        return this.object.isPresent() && this.offset.isPresent();
    }
}

