/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2.util;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cpa.value.type.Value;

public class ValueAndValueSize {
    private final Value value;
    private final @Nullable BigInteger sizeOfValueInBits;

    private ValueAndValueSize(Value pValue, BigInteger pSizeOfValueInBits) {
        this.value = pValue;
        this.sizeOfValueInBits = pSizeOfValueInBits;
    }

    public static ValueAndValueSize of(Value pValue, BigInteger pSizeOfValueInBits) {
        Preconditions.checkNotNull((Object)pValue);
        return new ValueAndValueSize(pValue, pSizeOfValueInBits);
    }

    public Value getValue() {
        return this.value;
    }

    public @Nullable BigInteger getSizeInBits() {
        return this.sizeOfValueInBits;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ValueAndValueSize)) {
            return false;
        }
        ValueAndValueSize otherVAS = (ValueAndValueSize)other;
        if (this.sizeOfValueInBits == null) {
            return this.value.equals(otherVAS.value);
        }
        return this.value.equals(otherVAS.value) && this.sizeOfValueInBits.equals(otherVAS.sizeOfValueInBits);
    }

    public int hashCode() {
        if (this.sizeOfValueInBits == null) {
            return this.value.hashCode();
        }
        return this.value.hashCode() + this.sizeOfValueInBits.hashCode();
    }

    public String toString() {
        return this.value.toString() + " (" + this.sizeOfValueInBits + ")";
    }
}

