/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2.util.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;

public class CValue
implements Comparable<CValue> {
    private static final CValue unknownCValue = new CValue();
    private final boolean unknownValue;
    private final @Nullable SMGObject address;
    private final @Nullable BigInteger offset;
    private final @Nullable BigInteger value;
    private final @Nullable BigDecimal decValue;

    private CValue(BigInteger pValue) {
        this.value = pValue;
        this.address = null;
        this.unknownValue = false;
        this.offset = null;
        this.decValue = null;
    }

    private CValue() {
        this.value = null;
        this.address = null;
        this.unknownValue = true;
        this.offset = null;
        this.decValue = null;
    }

    private CValue(SMGObject pAdressTarget, BigInteger pOffset) {
        this.value = null;
        this.address = pAdressTarget;
        this.unknownValue = false;
        this.offset = pOffset;
        this.decValue = null;
    }

    private CValue(BigDecimal decimalValue) {
        this.value = null;
        this.address = null;
        this.unknownValue = false;
        this.offset = null;
        this.decValue = decimalValue;
    }

    public static CValue zero() {
        return CValue.valueOf(BigInteger.ZERO);
    }

    public static CValue valueOf(BigInteger val) {
        return new CValue(val);
    }

    public static CValue valueOf(BigDecimal val) {
        return new CValue(val);
    }

    @Override
    public int compareTo(CValue other) {
        if (this.unknownValue) {
            return other.isUnknown() ? 0 : -1;
        }
        if (this.isAddressValue()) {
            if (other.isAddressValue()) {
                int compareAddresses = this.address.compareTo(other.getAddress());
                if (compareAddresses == 0) {
                    return this.offset.compareTo(other.getOffset());
                }
                return compareAddresses;
            }
        } else if (this.isDecimalValue()) {
            if (other.isDecimalValue()) {
                return this.decValue.compareTo(other.getDecimalValue());
            }
        } else {
            return this.value.compareTo(other.value);
        }
        return -1;
    }

    public boolean isAddressValue() {
        return this.address != null && this.offset != null;
    }

    public BigDecimal getDecimalValue() {
        return this.decValue;
    }

    public boolean isDecimalValue() {
        return this.decValue == null;
    }

    public @Nullable SMGObject getAddress() {
        return this.address;
    }

    public @Nullable BigInteger getOffset() {
        return this.offset;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object pObj) {
        if (this.isUnknown() && pObj instanceof CValue) {
            return ((CValue)pObj).isUnknown();
        }
        return pObj instanceof CValue && this.value.equals(((CValue)pObj).value);
    }

    public BigInteger getExplicitValue() {
        return this.value;
    }

    public boolean isUnknown() {
        return this.unknownValue;
    }

    public static CValue getUnknownValue() {
        return unknownCValue;
    }

    public boolean isZero() {
        return BigInteger.ZERO.equals(this.value);
    }

    public CValue shiftRight(int shiftBy) {
        if (this.isUnknown() || this.isZero()) {
            return this;
        }
        if (shiftBy < 0) {
            return this.shiftLeft(-shiftBy);
        }
        return CValue.valueOf(this.value.shiftRight(shiftBy));
    }

    public CValue shiftLeft(int shiftBy) {
        if (this.isUnknown() || this.isZero()) {
            return this;
        }
        if (shiftBy < 0) {
            return this.shiftRight(-shiftBy);
        }
        return CValue.valueOf(this.value.shiftRight(shiftBy));
    }

    public CValue clearBit(int n) {
        if (this.isUnknown() || this.isZero()) {
            return this;
        }
        return CValue.valueOf(this.getExplicitValue().clearBit(n));
    }

    public CValue concat(CValue pOverlappingBitsCValue) {
        if (this.isUnknown()) {
            return this;
        }
        if (this.isZero()) {
            return pOverlappingBitsCValue;
        }
        BigInteger otherValue = pOverlappingBitsCValue.getExplicitValue();
        BigInteger newValue = this.value.shiftRight(otherValue.bitLength()).add(otherValue);
        return CValue.valueOf(newValue);
    }

    public CValue add(CValue other) {
        if (this.isUnknown() || other.isUnknown()) {
            return unknownCValue;
        }
        if (this.isZero()) {
            return other;
        }
        if (other.isZero()) {
            return this;
        }
        return CValue.valueOf(this.value.add(other.getExplicitValue()));
    }
}

