/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg2.util.value;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.DummyCFAEdge;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPAAddressVisitor;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPABuiltins;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPAExportOptions;
import org.sosy_lab.cpachecker.cpa.smg2.SMGCPAValueVisitor;
import org.sosy_lab.cpachecker.cpa.smg2.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg2.SMGState;
import org.sosy_lab.cpachecker.cpa.smg2.SymbolicProgramConfiguration;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMG2Exception;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGObjectAndOffset;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGObjectAndSMGState;
import org.sosy_lab.cpachecker.cpa.smg2.util.SMGStateAndOptionalSMGObjectAndOffset;
import org.sosy_lab.cpachecker.cpa.smg2.util.value.ValueAndSMGState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.AddressExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicIdentifier;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueFactory;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.smg.graph.SMGObject;
import org.sosy_lab.cpachecker.util.smg.graph.SMGValue;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class SMGCPAExpressionEvaluator {
    private final SMGCPAExportOptions exportSMGOptions;
    private final SMGOptions options;
    private final LogManagerWithoutDuplicates logger;
    private final MachineModel machineModel;
    private final SMGCPABuiltins builtins;

    public SMGCPAExpressionEvaluator(MachineModel pMachineModel, LogManagerWithoutDuplicates pLogger, SMGCPAExportOptions pExportSMGOptions, SMGOptions pSMGOptions) {
        this.logger = pLogger;
        this.machineModel = pMachineModel;
        this.exportSMGOptions = pExportSMGOptions;
        this.options = pSMGOptions;
        this.builtins = new SMGCPABuiltins(this, this.options, this.exportSMGOptions, this.machineModel, this.logger);
    }

    public SMGCPABuiltins getBuiltinFunctionHandler() {
        return this.builtins;
    }

    public boolean isPointerValue(Value maybeAddress, SMGState currentState) {
        return currentState.getMemoryModel().isPointer(maybeAddress);
    }

    public ValueAndSMGState transformAddressExpressionIntoPointerValue(AddressExpression addressExpression, SMGState currentState) throws SMG2Exception {
        Value offset = addressExpression.getOffset();
        if (!offset.isNumericValue()) {
            return ValueAndSMGState.ofUnknownValue(currentState);
        }
        if (offset.asNumericValue().bigInteger().compareTo(BigInteger.ZERO) == 0) {
            return ValueAndSMGState.of(addressExpression.getMemoryAddress(), currentState);
        }
        List<ValueAndSMGState> pointers = this.findOrcreateNewPointer(addressExpression.getMemoryAddress(), offset.asNumericValue().bigInteger(), currentState);
        Preconditions.checkArgument((pointers.size() == 1 ? 1 : 0) != 0);
        return pointers.get(0);
    }

    public Value checkEqualityForAddresses(Value leftValue, Value rightValue, SMGState state) throws SMG2Exception {
        Value isNotEqual = this.checkNonEqualityForAddresses(leftValue, rightValue, state);
        if (isNotEqual.isUnknown()) {
            return isNotEqual;
        }
        return isNotEqual.asNumericValue().bigInteger().compareTo(BigInteger.ZERO) == 0 ? new NumericValue(1) : new NumericValue(0);
    }

    public Value checkNonEqualityForAddresses(Value leftValue, Value rightValue, SMGState state) throws SMG2Exception {
        SMGState currentState;
        ValueAndSMGState leftValueAndState = this.unpackAddressExpression(leftValue, state);
        leftValue = leftValueAndState.getValue();
        ValueAndSMGState rightValueAndState = this.unpackAddressExpression(rightValue, leftValueAndState.getState());
        if (!this.isPointerValue(rightValue = rightValueAndState.getValue(), currentState = rightValueAndState.getState()) || !this.isPointerValue(leftValue, currentState)) {
            return Value.UnknownValue.getInstance();
        }
        Preconditions.checkArgument((!(leftValue instanceof AddressExpression) && !(rightValue instanceof AddressExpression) ? 1 : 0) != 0);
        boolean isNotEqual = currentState.areNonEqualAddresses(leftValue, rightValue);
        return isNotEqual ? new NumericValue(1) : new NumericValue(0);
    }

    public ValueAndSMGState unpackAddressExpression(Value value, SMGState state) throws SMG2Exception {
        if (!(value instanceof AddressExpression)) {
            return ValueAndSMGState.of(value, state);
        }
        AddressExpression address1 = (AddressExpression)value;
        Value offsetValue = address1.getOffset();
        if (offsetValue.isNumericValue() && offsetValue.asNumericValue().bigInteger().compareTo(BigInteger.ZERO) == 0) {
            return ValueAndSMGState.of(address1.getMemoryAddress(), state);
        }
        Optional<SMGObjectAndOffset> maybeTargetAndOffset = state.getPointsToTarget(address1.getMemoryAddress());
        if (maybeTargetAndOffset.isEmpty()) {
            return ValueAndSMGState.ofUnknownValue(state);
        }
        SMGObjectAndOffset targetAndOffset = maybeTargetAndOffset.orElseThrow();
        SMGObject target = targetAndOffset.getSMGObject();
        if (!offsetValue.isNumericValue()) {
            throw new SMG2Exception("Comparison of non numeric offset values not possible when comparing addresses.");
        }
        BigInteger offset = offsetValue.asNumericValue().bigInteger().add(targetAndOffset.getOffsetForObject());
        return this.searchOrCreatePointer(target, offset, state);
    }

    public BigInteger getFieldOffsetInBits(CType ownerExprType, String pFieldName) {
        if (ownerExprType instanceof CElaboratedType) {
            CComplexType realType = ((CElaboratedType)ownerExprType).getRealType();
            if (realType == null) {
                throw new AssertionError();
            }
            return this.getFieldOffsetInBits(realType, pFieldName);
        }
        if (ownerExprType instanceof CCompositeType) {
            return this.machineModel.getFieldOffsetInBits((CCompositeType)ownerExprType, pFieldName);
        }
        if (ownerExprType instanceof CPointerType) {
            CType type = SMGCPAExpressionEvaluator.getCanonicalType(((CPointerType)ownerExprType).getType());
            return this.getFieldOffsetInBits(type, pFieldName);
        }
        throw new AssertionError();
    }

    public ValueAndSMGState createHeapMemoryAndPointer(SMGState pInitialSmgState, BigInteger sizeInBits) {
        SMGObjectAndSMGState newObjectAndState = pInitialSmgState.copyAndAddHeapObject(sizeInBits);
        SMGObject newObject = newObjectAndState.getSMGObject();
        SMGState newState = newObjectAndState.getState();
        SymbolicIdentifier addressValue = SymbolicValueFactory.getInstance().newIdentifier(null);
        SMGState finalState = newState.createAndAddPointer(addressValue, newObject, BigInteger.ZERO);
        return ValueAndSMGState.of(addressValue, finalState);
    }

    public ValueAndSMGState createStackMemoryAndPointer(SMGState pInitialSmgState, BigInteger sizeInBits) {
        SMGObjectAndSMGState newObjectAndState = pInitialSmgState.copyAndAddStackObject(sizeInBits);
        SMGObject newObject = newObjectAndState.getSMGObject();
        SMGState newState = newObjectAndState.getState();
        SymbolicIdentifier addressValue = SymbolicValueFactory.getInstance().newIdentifier(null);
        SMGState finalState = newState.createAndAddPointer(addressValue, newObject, BigInteger.ZERO);
        return ValueAndSMGState.of(addressValue, finalState);
    }

    public List<ValueAndSMGState> createAddress(CExpression operand, SMGState pState, CFAEdge cfaEdge) throws CPATransferException {
        SMGState currentState = pState;
        SMGCPAAddressVisitor addressVisitor = new SMGCPAAddressVisitor(this, currentState, cfaEdge, this.logger);
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (SMGStateAndOptionalSMGObjectAndOffset objectAndOffsetOrState : operand.accept(addressVisitor)) {
            currentState = objectAndOffsetOrState.getSMGState();
            if (!objectAndOffsetOrState.hasSMGObjectAndOffset()) {
                if (operand instanceof CIdExpression && SMGCPAExpressionEvaluator.getCanonicalType(operand.getExpressionType()) instanceof CFunctionType) {
                    CFunctionDeclaration functionDcl;
                    currentState = objectAndOffsetOrState.getSMGState();
                    Optional<SMGObject> functionObject = currentState.getObjectForFunction(functionDcl = (CFunctionDeclaration)((CIdExpression)operand).getDeclaration());
                    if (functionObject.isEmpty()) {
                        currentState = currentState.copyAndAddFunctionVariable(functionDcl);
                        functionObject = currentState.getObjectForFunction(functionDcl);
                    }
                    objectAndOffsetOrState = SMGStateAndOptionalSMGObjectAndOffset.withZeroOffset(functionObject.orElseThrow(), currentState);
                } else {
                    resultBuilder.add((Object)ValueAndSMGState.ofUnknownValue(currentState));
                    continue;
                }
            }
            SMGObject target = objectAndOffsetOrState.getSMGObject();
            BigInteger offset = objectAndOffsetOrState.getOffsetForObject();
            ValueAndSMGState addressAndState = this.searchOrCreatePointer(target, offset, currentState);
            resultBuilder.add((Object)ValueAndSMGState.of(AddressExpression.withZeroOffset(addressAndState.getValue(), operand.getExpressionType()), addressAndState.getState()));
        }
        return resultBuilder.build();
    }

    public List<ValueAndSMGState> createAddress(CRightHandSide operand, SMGState pState, CFAEdge cfaEdge) throws CPATransferException {
        Preconditions.checkArgument((!(operand instanceof CFunctionCallExpression) ? 1 : 0) != 0);
        return this.createAddress((CExpression)operand, pState, cfaEdge);
    }

    public List<ValueAndSMGState> findOrcreateNewPointer(Value targetAddress, BigInteger offsetInBits, SMGState pState) throws SMG2Exception {
        Preconditions.checkArgument((!(targetAddress instanceof AddressExpression) ? 1 : 0) != 0);
        ImmutableList.Builder returnBuilder = ImmutableList.builder();
        for (SMGStateAndOptionalSMGObjectAndOffset maybeTargetAndOffset : pState.dereferencePointer(targetAddress)) {
            if (!maybeTargetAndOffset.hasSMGObjectAndOffset()) {
                returnBuilder.add((Object)ValueAndSMGState.ofUnknownValue(maybeTargetAndOffset.getSMGState()));
                continue;
            }
            SMGObject object = maybeTargetAndOffset.getSMGObject();
            BigInteger baseOffset = maybeTargetAndOffset.getOffsetForObject();
            BigInteger finalOffsetInBits = baseOffset.add(offsetInBits);
            returnBuilder.add((Object)this.searchOrCreatePointer(object, finalOffsetInBits, maybeTargetAndOffset.getSMGState()));
        }
        return returnBuilder.build();
    }

    private ValueAndSMGState searchOrCreatePointer(SMGObject targetObject, BigInteger offsetInBits, SMGState pState) {
        return pState.searchOrCreateAddress(targetObject, offsetInBits);
    }

    public ValueAndSMGState createAddressForLocalOrGlobalVariable(String variableName, SMGState pState) {
        Optional<SMGObjectAndOffset> maybeObjectAndOffset = this.getTargetObjectAndOffset(pState, variableName, BigInteger.ZERO);
        if (maybeObjectAndOffset.isEmpty()) {
            return ValueAndSMGState.ofUnknownValue(pState);
        }
        SMGObjectAndOffset targetAndOffset = maybeObjectAndOffset.orElseThrow();
        SMGObject target = targetAndOffset.getSMGObject();
        BigInteger offset = targetAndOffset.getOffsetForObject();
        Optional<SMGValue> maybeAddressValue = pState.getMemoryModel().getAddressValueForPointsToTarget(target, offset);
        if (maybeAddressValue.isPresent()) {
            Optional<Value> valueForSMGValue = pState.getMemoryModel().getValueFromSMGValue(maybeAddressValue.orElseThrow());
            return ValueAndSMGState.of(valueForSMGValue.orElseThrow(), pState);
        }
        SymbolicIdentifier addressValue = SymbolicValueFactory.getInstance().newIdentifier(null);
        SMGState newState = pState.createAndAddPointer(addressValue, target, offset);
        return ValueAndSMGState.of(addressValue, newState);
    }

    public ValueAndSMGState createStackAllocation(String internalName, BigInteger sizeInBits, CType type, SMGState pState) throws CPATransferException {
        Preconditions.checkArgument((!pState.getMemoryModel().getStackFrames().peek().containsVariable(internalName) ? 1 : 0) != 0);
        return this.createAddressForLocalOrGlobalVariable(internalName, pState.copyAndAddLocalVariable(sizeInBits, internalName, type));
    }

    public List<ValueAndSMGState> readStackOrGlobalVariable(SMGState initialState, String varName, BigInteger offsetInBits, BigInteger sizeInBits, CType readType) throws CPATransferException {
        Optional<SMGObject> maybeObject = initialState.getMemoryModel().getObjectForVisibleVariable(varName);
        if (maybeObject.isEmpty()) {
            SMGState errorState = initialState.withUninitializedVariableUsage(varName);
            return ImmutableList.of((Object)ValueAndSMGState.ofUnknownValue(errorState));
        }
        return this.readValue(initialState, maybeObject.orElseThrow(), offsetInBits, sizeInBits, readType);
    }

    public List<ValueAndSMGState> readValueWithPointerDereference(SMGState pState, Value value, BigInteger pOffset, BigInteger pSizeInBits, CType readType) throws SMG2Exception {
        ImmutableList.Builder returnBuilder = ImmutableList.builder();
        for (SMGStateAndOptionalSMGObjectAndOffset maybeTargetAndOffset : pState.dereferencePointer(value)) {
            if (!maybeTargetAndOffset.hasSMGObjectAndOffset()) {
                SMGState errorState = maybeTargetAndOffset.getSMGState().withUnknownPointerDereferenceWhenReading(value);
                returnBuilder.add((Object)ValueAndSMGState.ofUnknownValue(errorState));
                continue;
            }
            pState = maybeTargetAndOffset.getSMGState();
            SMGObject object = maybeTargetAndOffset.getSMGObject();
            if (object.isZero()) {
                SMGState errorState = pState.withNullPointerDereferenceWhenReading(object);
                returnBuilder.add((Object)ValueAndSMGState.ofUnknownValue(errorState));
                continue;
            }
            BigInteger baseOffset = maybeTargetAndOffset.getOffsetForObject();
            BigInteger offset = baseOffset.add(pOffset);
            returnBuilder.addAll(this.readValue(pState, object, offset, pSizeInBits, readType));
        }
        return returnBuilder.build();
    }

    public List<SMGStateAndOptionalSMGObjectAndOffset> getTargetObjectAndOffset(SMGState pState, Value value, BigInteger pOffsetInBits) throws SMG2Exception {
        ImmutableList.Builder returnBuilder = ImmutableList.builder();
        for (SMGStateAndOptionalSMGObjectAndOffset targetAndOffset : pState.dereferencePointer(value)) {
            if (!targetAndOffset.hasSMGObjectAndOffset()) {
                SMGState errorState = targetAndOffset.getSMGState().withUnknownPointerDereferenceWhenReading(value);
                returnBuilder.add((Object)SMGStateAndOptionalSMGObjectAndOffset.of(errorState));
                continue;
            }
            BigInteger baseOffset = targetAndOffset.getOffsetForObject();
            BigInteger finalOffset = baseOffset.add(pOffsetInBits);
            returnBuilder.add((Object)SMGStateAndOptionalSMGObjectAndOffset.of(targetAndOffset.getSMGObject(), finalOffset, targetAndOffset.getSMGState()));
        }
        return returnBuilder.build();
    }

    public Optional<SMGObjectAndOffset> getTargetObjectAndOffset(SMGState state, String variableName) {
        return this.getTargetObjectAndOffset(state, variableName, BigInteger.ZERO);
    }

    public Optional<SMGObjectAndOffset> getTargetObjectAndOffset(SMGState state, String variableName, BigInteger offsetInBits) {
        Optional<SMGObject> maybeObject = state.getMemoryModel().getObjectForVisibleVariable(variableName);
        if (maybeObject.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(SMGObjectAndOffset.of(maybeObject.orElseThrow(), offsetInBits));
    }

    public List<ValueAndSMGState> calculateAddressDistance(SMGState state, Value leftPointer, Value rightPointer) throws SMG2Exception {
        SymbolicProgramConfiguration spc = state.getMemoryModel();
        if (!spc.isPointer(leftPointer) || !spc.isPointer(rightPointer)) {
            return ImmutableList.of((Object)ValueAndSMGState.ofUnknownValue(state));
        }
        ImmutableList.Builder returnBuilder = ImmutableList.builder();
        for (SMGStateAndOptionalSMGObjectAndOffset leftTargetAndOffset : state.dereferencePointer(leftPointer)) {
            if (!leftTargetAndOffset.hasSMGObjectAndOffset()) {
                returnBuilder.add((Object)ValueAndSMGState.ofUnknownValue(leftTargetAndOffset.getSMGState()));
                continue;
            }
            state = leftTargetAndOffset.getSMGState();
            for (SMGStateAndOptionalSMGObjectAndOffset rightTargetAndOffset : state.dereferencePointer(rightPointer)) {
                SMGObject rightTarget;
                if (!rightTargetAndOffset.hasSMGObjectAndOffset()) {
                    returnBuilder.add((Object)ValueAndSMGState.ofUnknownValue(rightTargetAndOffset.getSMGState()));
                    continue;
                }
                state = rightTargetAndOffset.getSMGState();
                SMGObject leftTarget = leftTargetAndOffset.getSMGObject();
                if (!leftTarget.equals(rightTarget = rightTargetAndOffset.getSMGObject())) {
                    returnBuilder.add((Object)ValueAndSMGState.ofUnknownValue(state));
                    continue;
                }
                returnBuilder.add((Object)ValueAndSMGState.of(new NumericValue(leftTargetAndOffset.getOffsetForObject().subtract(rightTargetAndOffset.getOffsetForObject()).intValue()), state));
            }
        }
        return returnBuilder.build();
    }

    private List<ValueAndSMGState> readValue(SMGState currentState, SMGObject object, BigInteger offsetInBits, BigInteger sizeInBits, @Nullable CType readType) throws SMG2Exception {
        boolean doesNotFitIntoObject;
        boolean bl = doesNotFitIntoObject = offsetInBits.compareTo(BigInteger.ZERO) < 0 || offsetInBits.add(sizeInBits).compareTo(object.getSize()) > 0;
        if (doesNotFitIntoObject) {
            SMGState errorState = currentState.withOutOfRangeRead(object, offsetInBits, sizeInBits);
            return ImmutableList.of((Object)ValueAndSMGState.ofUnknownValue(errorState));
        }
        return currentState.readValue(object, offsetInBits, sizeInBits, readType);
    }

    private ValueAndSMGState readValueWithoutMaterialization(SMGState currentState, SMGObject object, BigInteger offsetInBits, BigInteger sizeInBits) {
        boolean doesNotFitIntoObject;
        boolean bl = doesNotFitIntoObject = offsetInBits.compareTo(BigInteger.ZERO) < 0 || offsetInBits.add(sizeInBits).compareTo(object.getSize()) > 0;
        if (doesNotFitIntoObject) {
            SMGState errorState = currentState.withOutOfRangeRead(object, offsetInBits, sizeInBits);
            return ValueAndSMGState.ofUnknownValue(errorState);
        }
        return currentState.readValueWithoutMaterialization(object, offsetInBits, sizeInBits, null);
    }

    public List<SMGState> writeValueToExpression(CFAEdge edge, CExpression leftHandSideValue, Value valueToWrite, SMGState currentState) throws CPATransferException {
        BigInteger sizeInBits = this.getBitSizeof(currentState, leftHandSideValue);
        ImmutableList.Builder successorsBuilder = ImmutableList.builder();
        for (SMGStateAndOptionalSMGObjectAndOffset variableMemoryAndOffsetOrState : leftHandSideValue.accept(new SMGCPAAddressVisitor(this, currentState, edge, this.logger))) {
            if (!variableMemoryAndOffsetOrState.hasSMGObjectAndOffset()) {
                successorsBuilder.add((Object)variableMemoryAndOffsetOrState.getSMGState());
                continue;
            }
            currentState = variableMemoryAndOffsetOrState.getSMGState();
            SMGObject leftHandSideVariableMemory = variableMemoryAndOffsetOrState.getSMGObject();
            BigInteger offsetInBits = variableMemoryAndOffsetOrState.getOffsetForObject();
            ValueAndSMGState castedValueAndState = new SMGCPAValueVisitor(this, currentState, edge, this.logger).castCValue(valueToWrite, leftHandSideValue.getExpressionType(), currentState);
            valueToWrite = castedValueAndState.getValue();
            currentState = castedValueAndState.getState();
            successorsBuilder.add((Object)currentState.writeValueTo(leftHandSideVariableMemory, offsetInBits, sizeInBits, valueToWrite, leftHandSideValue.getExpressionType()));
        }
        return successorsBuilder.build();
    }

    public BigInteger getBitSizeof(SMGState pInitialSmgState, CExpression pExpression) {
        return this.getBitSizeof(pInitialSmgState, pExpression.getExpressionType());
    }

    public BigInteger getBitSizeof(SMGState pInitialSmgState, CRightHandSide pExpression) {
        return this.getBitSizeof(pInitialSmgState, pExpression.getExpressionType());
    }

    public BigInteger getBitSizeof(SMGState pInitialSmgState, CType pType) {
        return this.machineModel.getSizeofInBits(pType, new SMG2SizeofVisitor(this.machineModel, this, pInitialSmgState, this.logger, this.options));
    }

    public static boolean isStructOrUnionType(CType rValueType) {
        if (rValueType instanceof CCompositeType) {
            CCompositeType type = (CCompositeType)rValueType;
            return type.getKind() != CComplexType.ComplexTypeKind.ENUM;
        }
        if (rValueType instanceof CElaboratedType) {
            CElaboratedType type = (CElaboratedType)rValueType;
            return type.getKind() != CComplexType.ComplexTypeKind.ENUM;
        }
        return false;
    }

    public List<SMGState> copyFromMemoryToMemory(Value sourcePointer, BigInteger sourceOffset, Value targetPointer, BigInteger targetOffset, BigInteger sizeToCopy, SMGState pState) throws SMG2Exception {
        if (sizeToCopy.compareTo(BigInteger.ZERO) == 0) {
            return ImmutableList.of((Object)pState);
        }
        ImmutableList.Builder returnBuilder = ImmutableList.builder();
        for (SMGStateAndOptionalSMGObjectAndOffset maybeSourceAndOffset : pState.dereferencePointer(sourcePointer)) {
            if (!maybeSourceAndOffset.hasSMGObjectAndOffset()) {
                returnBuilder.add((Object)maybeSourceAndOffset.getSMGState().withUnknownPointerDereferenceWhenReading(sourcePointer));
                continue;
            }
            pState = maybeSourceAndOffset.getSMGState();
            SMGObject sourceObject = maybeSourceAndOffset.getSMGObject();
            if (sourceObject.isZero()) {
                returnBuilder.add((Object)pState.withNullPointerDereferenceWhenReading(sourceObject));
                continue;
            }
            BigInteger finalSourceOffset = maybeSourceAndOffset.getOffsetForObject().add(sourceOffset);
            for (SMGStateAndOptionalSMGObjectAndOffset maybeTargetAndOffset : pState.dereferencePointer(targetPointer)) {
                if (!maybeTargetAndOffset.hasSMGObjectAndOffset()) {
                    returnBuilder.add((Object)maybeTargetAndOffset.getSMGState().withUnknownPointerDereferenceWhenReading(targetPointer));
                    continue;
                }
                pState = maybeTargetAndOffset.getSMGState();
                SMGObject targetObject = maybeTargetAndOffset.getSMGObject();
                if (targetObject.isZero()) {
                    returnBuilder.add((Object)pState.withNullPointerDereferenceWhenWriting(targetObject));
                    continue;
                }
                BigInteger finalTargetoffset = maybeTargetAndOffset.getOffsetForObject().add(targetOffset);
                if (sourceObject.equals(targetObject)) {
                    int compareOffsets = finalTargetoffset.compareTo(finalSourceOffset);
                    if (compareOffsets == 0) {
                        returnBuilder.add((Object)pState.withUndefinedbehavior("Undefined behaviour because of overlapping memory regions in a copy function. I.e. memcpy().", (Collection<Object>)ImmutableList.of((Object)targetPointer, (Object)sourcePointer)));
                        continue;
                    }
                    if (compareOffsets > 0) {
                        if (finalTargetoffset.compareTo(finalSourceOffset.add(sizeToCopy)) < 0) {
                            returnBuilder.add((Object)pState.withUndefinedbehavior("Undefined behaviour because of overlapping memory regions in a copy function. I.e. memcpy().", (Collection<Object>)ImmutableList.of((Object)targetPointer, (Object)sourcePointer)));
                            continue;
                        }
                    } else if (finalSourceOffset.compareTo(finalTargetoffset.add(sizeToCopy)) < 0) {
                        returnBuilder.add((Object)pState.withUndefinedbehavior("Undefined behaviour because of overlapping memory regions in a copy function. I.e. memcpy().", (Collection<Object>)ImmutableList.of((Object)targetPointer, (Object)sourcePointer)));
                        continue;
                    }
                }
                if (sourceObject.getSize().subtract(finalSourceOffset).compareTo(sizeToCopy) < 0 || finalSourceOffset.compareTo(BigInteger.ZERO) < 0) {
                    SMGState currentState = pState.withInvalidRead(sourceObject);
                    if (targetObject.getSize().subtract(finalTargetoffset).compareTo(sizeToCopy) < 0 || finalTargetoffset.compareTo(BigInteger.ZERO) < 0) {
                        currentState = currentState.withInvalidWrite(sourceObject);
                    }
                    returnBuilder.add((Object)currentState);
                    continue;
                }
                if (targetObject.getSize().subtract(finalTargetoffset).compareTo(sizeToCopy) < 0 || finalTargetoffset.compareTo(BigInteger.ZERO) < 0) {
                    returnBuilder.add((Object)pState.withInvalidWrite(sourceObject));
                    continue;
                }
                returnBuilder.add((Object)pState.copySMGObjectContentToSMGObject(sourceObject, finalSourceOffset, targetObject, finalTargetoffset, sizeToCopy));
            }
        }
        return returnBuilder.build();
    }

    public ValueAndSMGState stringCompare(Value firstAddress, BigInteger pFirstOffsetInBits, Value secondAddress, BigInteger pSecondOffsetInBits, SMGState pState) throws SMG2Exception {
        SMGState currentState = pState;
        List<SMGStateAndOptionalSMGObjectAndOffset> maybefirstMemorysAndOffsets = currentState.dereferencePointer(firstAddress);
        Preconditions.checkArgument((maybefirstMemorysAndOffsets.size() == 1 ? 1 : 0) != 0);
        SMGStateAndOptionalSMGObjectAndOffset maybefirstMemoryAndOffset = maybefirstMemorysAndOffsets.get(0);
        currentState = maybefirstMemoryAndOffset.getSMGState();
        if (!maybefirstMemoryAndOffset.hasSMGObjectAndOffset()) {
            return ValueAndSMGState.ofUnknownValue(currentState.withUnknownPointerDereferenceWhenReading(firstAddress));
        }
        SMGObject firstObject = maybefirstMemoryAndOffset.getSMGObject();
        if (firstObject.isZero()) {
            return ValueAndSMGState.ofUnknownValue(currentState.withNullPointerDereferenceWhenReading(firstObject));
        }
        BigInteger firstOffsetInBits = maybefirstMemoryAndOffset.getOffsetForObject().add(pFirstOffsetInBits);
        List<SMGStateAndOptionalSMGObjectAndOffset> maybeSecondMemorysAndOffsets = currentState.dereferencePointer(secondAddress);
        Preconditions.checkArgument((maybeSecondMemorysAndOffsets.size() == 1 ? 1 : 0) != 0);
        SMGStateAndOptionalSMGObjectAndOffset maybeSecondMemoryAndOffset = maybeSecondMemorysAndOffsets.get(0);
        currentState = maybeSecondMemoryAndOffset.getSMGState();
        if (!maybeSecondMemoryAndOffset.hasSMGObjectAndOffset()) {
            return ValueAndSMGState.ofUnknownValue(currentState.withUnknownPointerDereferenceWhenReading(secondAddress));
        }
        SMGObject secondObject = maybeSecondMemoryAndOffset.getSMGObject();
        if (secondObject.isZero()) {
            return ValueAndSMGState.ofUnknownValue(currentState.withNullPointerDereferenceWhenWriting(secondObject));
        }
        BigInteger secondOffsetInBits = maybeSecondMemoryAndOffset.getOffsetForObject().add(pSecondOffsetInBits);
        if (firstObject.equals(secondObject) && firstOffsetInBits.compareTo(secondOffsetInBits) == 0) {
            return ValueAndSMGState.of(new NumericValue(0), currentState);
        }
        BigInteger sizeOfCharInBits = BigInteger.valueOf(this.machineModel.getSizeofCharInBits());
        boolean foundNoStringTerminationChar = true;
        while (foundNoStringTerminationChar) {
            ValueAndSMGState valueAndState1 = this.readValueWithoutMaterialization(currentState, firstObject, firstOffsetInBits, sizeOfCharInBits);
            Value value1 = valueAndState1.getValue();
            currentState = valueAndState1.getState();
            if (!value1.isNumericValue()) {
                return ValueAndSMGState.ofUnknownValue(currentState);
            }
            ValueAndSMGState valueAndState2 = this.readValueWithoutMaterialization(currentState, secondObject, secondOffsetInBits, sizeOfCharInBits);
            Value value2 = valueAndState2.getValue();
            currentState = valueAndState2.getState();
            if (!value2.isNumericValue()) {
                return ValueAndSMGState.ofUnknownValue(currentState);
            }
            int compare = value1.asNumericValue().bigInteger().compareTo(value2.asNumericValue().bigInteger());
            if (compare != 0) {
                return ValueAndSMGState.of(new NumericValue(compare), pState);
            }
            if (value1.isNumericValue() && value1.asNumericValue().longValue() == 0L || value2.isNumericValue() && value2.asNumericValue().longValue() == 0L) {
                foundNoStringTerminationChar = false;
                continue;
            }
            firstOffsetInBits = firstOffsetInBits.add(sizeOfCharInBits);
            secondOffsetInBits = secondOffsetInBits.add(sizeOfCharInBits);
        }
        return ValueAndSMGState.of(new NumericValue(0), pState);
    }

    public MachineModel getMachineModel() {
        return this.machineModel;
    }

    public static boolean valueIsAddressExprOrVariableOffset(@Nullable Value value) {
        if (value == null) {
            return false;
        }
        return value instanceof AddressExpression || value instanceof SymbolicIdentifier && ((SymbolicIdentifier)value).getRepresentedLocation().isPresent();
    }

    public static CType getCanonicalType(CType type) {
        return type.getCanonicalType();
    }

    public static CType getCanonicalType(CSimpleDeclaration decl) {
        return SMGCPAExpressionEvaluator.getCanonicalType(decl.getType());
    }

    public static CType getCanonicalType(CRightHandSide exp) {
        return SMGCPAExpressionEvaluator.getCanonicalType(exp.getExpressionType());
    }

    public SMGState writeValueToNewVariableBasedOnTypes(Value valueToWrite, CType leftHandSideType, CType rightHandSideType, String qualifiedVarName, SMGState pState) throws SMG2Exception {
        BigInteger paramSizeInBits;
        Optional<SMGObject> maybeObject;
        SMGState currentState = pState;
        CType parameterType = SMGCPAExpressionEvaluator.getCanonicalType(leftHandSideType);
        CType valueType = SMGCPAExpressionEvaluator.getCanonicalType(rightHandSideType);
        if (parameterType instanceof CArrayType && ((CArrayType)parameterType).getLength() == null) {
            parameterType = valueType;
        }
        if ((maybeObject = (currentState = currentState.copyAndAddLocalVariable(paramSizeInBits = this.getBitSizeof(currentState, parameterType), qualifiedVarName, parameterType)).getMemoryModel().getObjectForVisibleVariable(qualifiedVarName)).isEmpty()) {
            return currentState;
        }
        SMGObject newVariableMemory = maybeObject.orElseThrow();
        BigInteger ZeroOffsetInBits = BigInteger.ZERO;
        if (valueToWrite instanceof AddressExpression) {
            AddressExpression paramAddrExpr = (AddressExpression)valueToWrite;
            Value paramAddrOffsetValue = paramAddrExpr.getOffset();
            if (SMGCPAExpressionEvaluator.isStructOrUnionType(parameterType) || parameterType instanceof CArrayType) {
                if (!paramAddrOffsetValue.isNumericValue()) {
                    return currentState;
                }
                ValueAndSMGState properPointerAndState = this.transformAddressExpressionIntoPointerValue(paramAddrExpr, currentState);
                Optional<SMGObjectAndOffset> maybeParamMemoryAndOffset = (currentState = properPointerAndState.getState()).getPointsToTarget(properPointerAndState.getValue());
                if (maybeParamMemoryAndOffset.isEmpty()) {
                    return currentState;
                }
                SMGObjectAndOffset paramMemoryAndOffset = maybeParamMemoryAndOffset.orElseThrow();
                return currentState.copySMGObjectContentToSMGObject(paramMemoryAndOffset.getSMGObject(), paramMemoryAndOffset.getOffsetForObject(), newVariableMemory, ZeroOffsetInBits, newVariableMemory.getSize());
            }
            if (parameterType instanceof CPointerType || parameterType instanceof CSimpleType) {
                if (!paramAddrOffsetValue.isNumericValue()) {
                    return currentState.writeToStackOrGlobalVariable(qualifiedVarName, ZeroOffsetInBits, paramSizeInBits, Value.UnknownValue.getInstance(), parameterType);
                }
                ValueAndSMGState properPointerAndState = this.transformAddressExpressionIntoPointerValue(paramAddrExpr, currentState);
                return properPointerAndState.getState().writeToStackOrGlobalVariable(qualifiedVarName, ZeroOffsetInBits, paramSizeInBits, properPointerAndState.getValue(), parameterType);
            }
            throw new SMG2Exception("Missing type handling when writing a pointer to a " + parameterType + ".");
        }
        if (valueToWrite instanceof SymbolicIdentifier && ((SymbolicIdentifier)valueToWrite).getRepresentedLocation().isPresent()) {
            return this.copyStructOrArrayFromValueTo(valueToWrite, parameterType, newVariableMemory, ZeroOffsetInBits, currentState);
        }
        return currentState.writeToStackOrGlobalVariable(qualifiedVarName, ZeroOffsetInBits, paramSizeInBits, valueToWrite, parameterType);
    }

    public SMGState copyStructOrArrayFromValueTo(Value rightHandSideValue, CType leftHandSideType, SMGObject leftHandSideMemory, BigInteger leftHandSideOffset, SMGState pState) {
        Preconditions.checkArgument((rightHandSideValue instanceof SymbolicIdentifier && ((SymbolicIdentifier)rightHandSideValue).getRepresentedLocation().isPresent() ? 1 : 0) != 0);
        Preconditions.checkArgument((SMGCPAExpressionEvaluator.isStructOrUnionType(leftHandSideType) || leftHandSideType instanceof CArrayType ? 1 : 0) != 0);
        MemoryLocation memLocRight = ((SymbolicIdentifier)rightHandSideValue).getRepresentedLocation().orElseThrow();
        String paramIdentifier = memLocRight.getIdentifier();
        BigInteger paramBaseOffset = BigInteger.valueOf(memLocRight.getOffset());
        Optional<SMGObject> maybeRightHandSideMemory = pState.getMemoryModel().getObjectForVisibleVariable(paramIdentifier);
        if (maybeRightHandSideMemory.isEmpty() && (maybeRightHandSideMemory = pState.getMemoryModel().getObjectForVisibleVariable(paramIdentifier)).isEmpty()) {
            return pState;
        }
        SMGObject paramMemory = maybeRightHandSideMemory.orElseThrow();
        return pState.copySMGObjectContentToSMGObject(paramMemory, paramBaseOffset, leftHandSideMemory, leftHandSideOffset, leftHandSideMemory.getSize().subtract(leftHandSideOffset));
    }

    public List<SMGState> handleVariableDeclaration(SMGState pState, CVariableDeclaration pVarDecl, CFAEdge pEdge) throws CPATransferException {
        String varName = pVarDecl.getQualifiedName();
        CType cType = SMGCPAExpressionEvaluator.getCanonicalType(pVarDecl);
        SMGState currentState = pState;
        if (pState.isLocalOrGlobalVariablePresent(varName) && !pState.isLocalOrGlobalVariableValid(varName).orElse(true).booleanValue()) {
            currentState = pState.copyAndRemoveStackVariable(varName);
        }
        return this.handleInitializerForDeclaration(this.handleVariableDeclarationWithoutInizializer(currentState, pVarDecl).get(0), varName, pVarDecl, cType, pEdge);
    }

    public BigInteger getAlignOf(CType pType) {
        return BigInteger.valueOf(this.machineModel.getAlignof(pType));
    }

    public List<SMGState> handleVariableDeclarationWithoutInizializer(SMGState pState, CVariableDeclaration pVarDecl) throws CPATransferException {
        String varName = pVarDecl.getQualifiedName();
        if (pState.isLocalOrGlobalVariablePresent(varName)) {
            return ImmutableList.of((Object)pState);
        }
        CType cType = SMGCPAExpressionEvaluator.getCanonicalType(pVarDecl);
        boolean isExtern = pVarDecl.getCStorageClass().equals((Object)CStorageClass.EXTERN);
        if (cType.isIncomplete() && cType instanceof CElaboratedType) {
            return ImmutableList.of((Object)pState);
        }
        SMGState newState = pState;
        if (!(newState.checkVariableExists(newState, varName) || isExtern && !this.options.getAllocateExternalVariables())) {
            newState = this.handleInitilizerExpression(varName, cType, newState, isExtern, pVarDecl);
        }
        return ImmutableList.of((Object)newState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SMGState handleInitilizerExpression(String varName, CType cType, SMGState newState, boolean isExtern, CVariableDeclaration pVarDecl) throws SMG2Exception {
        BigInteger typeSizeInBits;
        try {
            typeSizeInBits = this.getBitSizeof(newState, cType);
        }
        catch (UnsupportedOperationException e) {
            if (!this.options.isIgnoreUnknownMemoryAllocation() || !e.getMessage().contains("Could not determine variable array length for length")) throw e;
            return newState;
        }
        if (cType instanceof CArrayType && ((CArrayType)cType).getLength() == null && pVarDecl.getInitializer() != null) {
            CInitializer init = pVarDecl.getInitializer();
            if (init instanceof CInitializerExpression) {
                CExpression initExpr = ((CInitializerExpression)init).getExpression();
                if (!(initExpr instanceof CStringLiteralExpression)) throw new SMG2Exception("Could not determine correct type size for an array for initializer expression: " + init);
                typeSizeInBits = BigInteger.valueOf(8L).multiply(BigInteger.valueOf(((CStringLiteralExpression)initExpr).getContentString().length() + 1));
            } else {
                if (!(init instanceof CInitializerList)) throw new SMG2Exception("Could not determine correct type size for an array for initializer expression: " + init);
                CInitializerList initList = (CInitializerList)init;
                CType realCType = cType.getCanonicalType();
                CArrayType arrayType = (CArrayType)realCType;
                CType memberType = SMGCPAExpressionEvaluator.getCanonicalType(arrayType.getType());
                BigInteger memberTypeSize = this.getBitSizeof(newState, memberType);
                BigInteger numberOfMembers = BigInteger.valueOf(initList.getInitializers().size());
                typeSizeInBits = BigInteger.valueOf(8L).multiply(memberTypeSize).multiply(numberOfMembers);
            }
        }
        if (this.options.isHandleIncompleteExternalVariableAsExternalAllocation() && cType.isIncomplete() && isExtern) {
            typeSizeInBits = BigInteger.valueOf(this.options.getExternalAllocationSize());
        }
        if (!pVarDecl.isGlobal()) return newState.copyAndAddLocalVariable(typeSizeInBits, varName, cType);
        return newState.copyAndAddGlobalVariable(typeSizeInBits, varName, cType);
    }

    private List<SMGState> handleInitializerForDeclaration(SMGState pState, String pVarName, CVariableDeclaration pVarDecl, CType cType, CFAEdge pEdge) throws CPATransferException {
        CInitializer newInitializer = pVarDecl.getInitializer();
        SMGState currentState = pState;
        if (pVarDecl.isGlobal()) {
            if (pVarDecl.getCStorageClass().equals((Object)CStorageClass.EXTERN)) {
                if (this.options.isHandleIncompleteExternalVariableAsExternalAllocation()) {
                    currentState = currentState.setExternallyAllocatedFlag(pVarName);
                }
            } else {
                currentState = currentState.writeToStackOrGlobalVariableToZero(pVarName, cType);
            }
        }
        if (newInitializer != null) {
            return this.handleInitializer(currentState, pVarDecl, pEdge, pVarName, BigInteger.ZERO, cType, newInitializer);
        }
        return ImmutableList.of((Object)currentState);
    }

    private List<SMGState> handleInitializer(SMGState pNewState, CVariableDeclaration pVarDecl, CFAEdge pEdge, String variableName, BigInteger pOffset, CType pLValueType, CInitializer pInitializer) throws CPATransferException {
        if (pInitializer instanceof CInitializerExpression) {
            CExpression expression = ((CInitializerExpression)pInitializer).getExpression();
            if (expression instanceof CStringLiteralExpression) {
                return this.handleStringInitializer(pNewState, pVarDecl, pEdge, variableName, pOffset, pLValueType, pInitializer.getFileLocation(), (CStringLiteralExpression)expression);
            }
            if (expression instanceof CCastExpression) {
                return this.handleCastInitializer(pNewState, pVarDecl, pEdge, variableName, pOffset, pLValueType, pInitializer.getFileLocation(), (CCastExpression)expression);
            }
            return this.writeCExpressionToLocalOrGlobalVariable(pNewState, pEdge, variableName, pOffset, pLValueType, expression);
        }
        if (pInitializer instanceof CInitializerList) {
            CInitializerList pNewInitializer = (CInitializerList)pInitializer;
            CType realCType = pLValueType.getCanonicalType();
            if (realCType instanceof CArrayType) {
                CArrayType arrayType = (CArrayType)realCType;
                return this.handleInitializerList(pNewState, pVarDecl, pEdge, variableName, pOffset, arrayType, pNewInitializer);
            }
            if (realCType instanceof CCompositeType) {
                CCompositeType structType = (CCompositeType)realCType;
                return this.handleInitializerList(pNewState, pVarDecl, pEdge, variableName, pOffset, structType, pNewInitializer);
            }
            this.logger.log(Level.INFO, () -> String.format("Type %s cannot be resolved sufficiently to handle initializer %s", realCType.toASTString(""), pNewInitializer));
            return ImmutableList.of((Object)pNewState);
        }
        if (pInitializer instanceof CDesignatedInitializer) {
            throw new AssertionError((Object)("Error in handling initializer, designated Initializer " + pInitializer.toASTString() + " should not appear at this point."));
        }
        throw new UnrecognizedCodeException("Did not recognize Initializer", pInitializer);
    }

    private List<SMGState> handleCastInitializer(SMGState pNewState, CVariableDeclaration pVarDecl, CFAEdge pEdge, String variableName, BigInteger pOffset, CType pLValueType, FileLocation pFileLocation, CCastExpression pExpression) throws CPATransferException {
        CExpression expression = pExpression.getOperand();
        if (expression instanceof CStringLiteralExpression) {
            return this.handleStringInitializer(pNewState, pVarDecl, pEdge, variableName, pOffset, pLValueType, pFileLocation, (CStringLiteralExpression)expression);
        }
        if (expression instanceof CCastExpression) {
            return this.handleCastInitializer(pNewState, pVarDecl, pEdge, variableName, pOffset, pLValueType, pFileLocation, (CCastExpression)expression);
        }
        return this.writeCExpressionToLocalOrGlobalVariable(pNewState, pEdge, variableName, pOffset, pLValueType, expression);
    }

    private List<SMGState> handleInitializerList(SMGState pState, CVariableDeclaration pVarDecl, CFAEdge pEdge, String variableName, BigInteger pOffset, CCompositeType pLValueType, CInitializerList pNewInitializer) throws CPATransferException {
        int listCounter = 0;
        List<CCompositeType.CCompositeTypeMemberDeclaration> memberTypes = pLValueType.getMembers();
        Map<CCompositeType.CCompositeTypeMemberDeclaration, BigInteger> offsetAndPosition = this.machineModel.getAllFieldOffsetsInBits(pLValueType);
        SMGState currentState = pState;
        for (CInitializer initializer : pNewInitializer.getInitializers()) {
            BigInteger offset;
            List<SMGState> newStates;
            CType memberType = memberTypes.get(0).getType();
            if (initializer instanceof CDesignatedInitializer) {
                List<CDesignator> designators = ((CDesignatedInitializer)initializer).getDesignators();
                initializer = ((CDesignatedInitializer)initializer).getRightHandSide();
                Preconditions.checkArgument((designators.size() == 1 ? 1 : 0) != 0);
                for (CCompositeType.CCompositeTypeMemberDeclaration memTypes : memberTypes) {
                    if (!memTypes.getName().equals(((CFieldDesignator)designators.get(0)).getFieldName())) continue;
                    memberType = memTypes.getType();
                    break;
                }
            } else {
                memberType = memberTypes.get(listCounter).getType();
            }
            Preconditions.checkArgument(((newStates = this.handleInitializer(currentState, pVarDecl, pEdge, variableName, offset = pOffset.add(offsetAndPosition.get(memberTypes.get(listCounter))), memberType, initializer)).size() == 1 ? 1 : 0) != 0);
            currentState = newStates.get(0);
            ++listCounter;
        }
        return ImmutableList.of((Object)currentState);
    }

    private List<SMGState> handleInitializerList(SMGState pState, CVariableDeclaration pVarDecl, CFAEdge pEdge, String variableName, BigInteger pOffset, CArrayType pLValueType, CInitializerList pNewInitializer) throws CPATransferException {
        CType memberType = SMGCPAExpressionEvaluator.getCanonicalType(pLValueType.getType());
        BigInteger memberTypeSize = this.getBitSizeof(pState, memberType);
        SMGState currentState = pState;
        BigInteger offset = pOffset;
        for (CInitializer initializer : pNewInitializer.getInitializers()) {
            if (initializer instanceof CDesignatedInitializer) {
                initializer = ((CDesignatedInitializer)initializer).getRightHandSide();
            }
            List<SMGState> newStates = this.handleInitializer(currentState, pVarDecl, pEdge, variableName, offset, memberType, initializer);
            offset = offset.add(memberTypeSize);
            Preconditions.checkArgument((newStates.size() == 1 ? 1 : 0) != 0);
            currentState = newStates.get(0);
        }
        return ImmutableList.of((Object)currentState);
    }

    private List<SMGState> handleStringInitializer(SMGState pState, CVariableDeclaration pVarDecl, CFAEdge pEdge, String variableName, BigInteger pOffset, CType pCurrentExpressionType, FileLocation pFileLocation, CStringLiteralExpression pExpression) throws CPATransferException {
        if (pCurrentExpressionType instanceof CPointerType) {
            CArrayType stringArrayType = pExpression.transformTypeToArrayType();
            String stringVarName = "_" + pExpression.getContentString() + "_STRING_LITERAL";
            int num = 0;
            while (pState.isGlobalVariablePresent(stringVarName + num)) {
                ++num;
            }
            stringVarName = stringVarName + num;
            BigInteger sizeOfString = this.getBitSizeof(pState, stringArrayType);
            SMGState currentState = pState.copyAndAddGlobalVariable(sizeOfString, stringVarName, (CType)stringArrayType);
            List<SMGState> initedStates = this.transformStringToArrayAndInitialize(currentState, pVarDecl, pEdge, stringVarName, BigInteger.ZERO, pFileLocation, pExpression);
            ImmutableList.Builder stateBuilder = ImmutableList.builder();
            for (SMGState initedState : initedStates) {
                ValueAndSMGState addressAndState = this.createAddressForLocalOrGlobalVariable(stringVarName, initedState);
                SMGState addressState = addressAndState.getState();
                stateBuilder.add((Object)addressState.writeToStackOrGlobalVariable(variableName, pOffset, this.getBitSizeof(addressState, pCurrentExpressionType), addressAndState.getValue(), pCurrentExpressionType));
            }
            return stateBuilder.build();
        }
        return this.transformStringToArrayAndInitialize(pState, pVarDecl, pEdge, variableName, pOffset, pFileLocation, pExpression);
    }

    private List<SMGState> transformStringToArrayAndInitialize(SMGState pState, CVariableDeclaration pVarDecl, CFAEdge pEdge, String variableName, BigInteger pOffset, FileLocation pFileLocation, CStringLiteralExpression pExpression) throws CPATransferException {
        ImmutableList.Builder charArrayInitialziersBuilder = ImmutableList.builder();
        CArrayType arrayType = pExpression.transformTypeToArrayType();
        for (CCharLiteralExpression charLiteralExp : pExpression.expandStringLiteral(arrayType)) {
            charArrayInitialziersBuilder.add((Object)new CInitializerExpression(pFileLocation, charLiteralExp));
        }
        return this.handleInitializerList(pState, pVarDecl, pEdge, variableName, pOffset, arrayType, new CInitializerList(pFileLocation, (List<CInitializer>)charArrayInitialziersBuilder.build()));
    }

    private List<SMGState> writeCExpressionToLocalOrGlobalVariable(SMGState pState, CFAEdge cfaEdge, String variableName, BigInteger pOffsetInBits, CType pWriteType, CExpression exprToWrite) throws CPATransferException {
        Preconditions.checkArgument((!(exprToWrite instanceof CStringLiteralExpression) ? 1 : 0) != 0);
        CType typeOfValueToWrite = SMGCPAExpressionEvaluator.getCanonicalType(exprToWrite);
        CType typeOfWrite = SMGCPAExpressionEvaluator.getCanonicalType(pWriteType);
        BigInteger sizeOfTypeLeft = this.getBitSizeof(pState, typeOfWrite);
        ImmutableList.Builder resultStatesBuilder = ImmutableList.builder();
        SMGState currentState = pState;
        if (SMGCPAExpressionEvaluator.isStructOrUnionType(typeOfWrite)) {
            for (SMGStateAndOptionalSMGObjectAndOffset sourceObjectAndOffsetOrState : exprToWrite.accept(new SMGCPAAddressVisitor(this, pState, cfaEdge, this.logger))) {
                if (!sourceObjectAndOffsetOrState.hasSMGObjectAndOffset()) {
                    resultStatesBuilder.add((Object)sourceObjectAndOffsetOrState.getSMGState());
                    continue;
                }
                currentState = sourceObjectAndOffsetOrState.getSMGState();
                Preconditions.checkArgument((pOffsetInBits.intValueExact() == 0 ? 1 : 0) != 0);
                Optional<SMGObjectAndOffset> maybeLeftHandSideVariableObject = this.getTargetObjectAndOffset(currentState, variableName);
                if (maybeLeftHandSideVariableObject.isEmpty()) {
                    throw new SMG2Exception("Usage of undeclared variable: " + variableName + ".");
                }
                SMGObject addressToWriteTo = maybeLeftHandSideVariableObject.orElseThrow().getSMGObject();
                BigInteger offsetToWriteTo = maybeLeftHandSideVariableObject.orElseThrow().getOffsetForObject();
                resultStatesBuilder.add((Object)currentState.copySMGObjectContentToSMGObject(sourceObjectAndOffsetOrState.getSMGObject(), sourceObjectAndOffsetOrState.getOffsetForObject(), addressToWriteTo, offsetToWriteTo, addressToWriteTo.getSize().subtract(offsetToWriteTo)));
            }
        } else if (typeOfWrite instanceof CPointerType && typeOfValueToWrite instanceof CArrayType) {
            for (ValueAndSMGState addressAndState : this.createAddress(exprToWrite, currentState, cfaEdge)) {
                Value addressToAssign = addressAndState.getValue();
                currentState = addressAndState.getState();
                resultStatesBuilder.add((Object)currentState.writeToStackOrGlobalVariable(variableName, pOffsetInBits, sizeOfTypeLeft, addressToAssign, typeOfWrite));
            }
        } else {
            SMGCPAValueVisitor vv = new SMGCPAValueVisitor(this, pState, cfaEdge, this.logger);
            for (ValueAndSMGState valueAndState : vv.evaluate(exprToWrite, typeOfWrite)) {
                ValueAndSMGState valueAndStateToAssign = this.unpackAddressExpression(valueAndState.getValue(), valueAndState.getState());
                Value valueToAssign = valueAndStateToAssign.getValue();
                currentState = valueAndStateToAssign.getState();
                if (valueToAssign instanceof SymbolicIdentifier) {
                    Preconditions.checkArgument((boolean)((SymbolicIdentifier)valueToAssign).getRepresentedLocation().isEmpty());
                }
                resultStatesBuilder.add((Object)currentState.writeToStackOrGlobalVariable(variableName, pOffsetInBits, sizeOfTypeLeft, valueToAssign, typeOfWrite));
            }
        }
        return resultStatesBuilder.build();
    }

    public static class SMG2SizeofVisitor
    extends MachineModel.BaseSizeofVisitor {
        private final MachineModel model;
        private final SMGState state;
        private final LogManagerWithoutDuplicates logger;
        private final SMGCPAExpressionEvaluator evaluator;
        private final SMGOptions options;

        protected SMG2SizeofVisitor(MachineModel pModel, SMGCPAExpressionEvaluator pEvaluator, SMGState pState, LogManagerWithoutDuplicates pLogger, SMGOptions pOptions) {
            super(pModel);
            this.model = pModel;
            this.state = pState;
            this.logger = pLogger;
            this.evaluator = pEvaluator;
            this.options = pOptions;
        }

        @Override
        public BigInteger visit(CArrayType pArrayType) throws IllegalArgumentException {
            CExpression arrayLength = pArrayType.getLength();
            BigInteger sizeOfType = this.model.getSizeof(pArrayType.getType());
            if (arrayLength instanceof CIntegerLiteralExpression) {
                BigInteger length = ((CIntegerLiteralExpression)arrayLength).getValue();
                return length.multiply(sizeOfType);
            }
            if (arrayLength == null) {
                return super.visit(pArrayType);
            }
            try {
                for (ValueAndSMGState lengthValueAndState : arrayLength.accept(new SMGCPAValueVisitor(this.evaluator, this.state, new DummyCFAEdge(CFANode.newDummyCFANode(), CFANode.newDummyCFANode()), this.logger))) {
                    Value lengthValue = lengthValueAndState.getValue();
                    if (lengthValue.isNumericValue()) {
                        return lengthValue.asNumericValue().bigInteger().multiply(sizeOfType);
                    }
                    if (!this.options.isGuessSizeOfUnknownMemorySize()) continue;
                    return this.options.getGuessSize().multiply(sizeOfType);
                }
            }
            catch (CPATransferException cPATransferException) {
                // empty catch block
            }
            throw new UnsupportedOperationException("Could not determine variable array length for length " + arrayLength.toASTString() + " and array type " + pArrayType.getType() + ". Try the options GuessSizeOfUnknownMemory.");
        }
    }
}

