/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.splitter;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;

public abstract class SplitInfoState
implements AbstractQueryableState {
    public abstract SplitInfoState getSplitPart(int var1, int var2);

    public abstract boolean isInSplit(int var1);

    public abstract boolean isOneElementalSplit();

    public abstract SplitInfoState removeFromSplit(int var1);

    public abstract SplitInfoState removeFromSplit(Collection<Integer> var1);

    @Override
    public String getCPAName() {
        return "SplitterCPA";
    }

    @Override
    public boolean checkProperty(String property) throws InvalidQueryException {
        if (property.equals("isSingle")) {
            return this.isOneElementalSplit();
        }
        throw new InvalidQueryException("The Query \"" + property + "\" is invalid.");
    }

    static final class SetSplitInfoState
    extends SplitInfoState {
        private final Set<Integer> inSplit;

        private SetSplitInfoState(Set<Integer> pInSplit) {
            this.inSplit = (Set)Preconditions.checkNotNull(pInSplit);
        }

        @Override
        public SplitInfoState getSplitPart(int pNumSplitParts, int pSplitPart) {
            Preconditions.checkArgument((pNumSplitParts > 0 ? 1 : 0) != 0, (Object)"Number of split parts must be a positive number.");
            Preconditions.checkArgument((pSplitPart >= 0 && pSplitPart < pNumSplitParts ? 1 : 0) != 0, (Object)"The split part must be in [0,numSplitParts).");
            if (this.inSplit.size() < pNumSplitParts) {
                return this;
            }
            ImmutableList arr = ImmutableList.sortedCopyOf(this.inSplit);
            int minElem = this.inSplit.size() / pNumSplitParts;
            int numAdditionalElem = this.inSplit.size() % pNumSplitParts;
            HashSet newSplit = Sets.newHashSetWithExpectedSize((int)(minElem + 1));
            for (int i = pSplitPart * minElem + Math.min(pSplitPart, numAdditionalElem); i < (pSplitPart + 1) * minElem + (pSplitPart + 1 < numAdditionalElem ? pSplitPart + 1 : numAdditionalElem); ++i) {
                newSplit.add((Integer)arr.get(i));
            }
            return new SetSplitInfoState(newSplit);
        }

        @Override
        public boolean isInSplit(int pSplitIndex) {
            return this.inSplit.contains(pSplitIndex);
        }

        @Override
        public SplitInfoState removeFromSplit(int pSplitIndex) {
            if (this.isInSplit(pSplitIndex) && this.inSplit.size() > 1) {
                HashSet<Integer> newSplit = new HashSet<Integer>(this.inSplit);
                newSplit.remove(pSplitIndex);
                return new SetSplitInfoState(newSplit);
            }
            return this;
        }

        @Override
        public SplitInfoState removeFromSplit(Collection<Integer> pRemoveIndices) {
            Preconditions.checkNotNull(pRemoveIndices);
            HashSet<Integer> newSplit = new HashSet<Integer>(this.inSplit);
            newSplit.removeAll(pRemoveIndices);
            if (newSplit.size() < 1) {
                return this;
            }
            return new SetSplitInfoState(newSplit);
        }

        @Override
        public int hashCode() {
            return this.inSplit.hashCode();
        }

        @Override
        public boolean isOneElementalSplit() {
            return this.inSplit.size() == 1;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SetSplitInfoState other = (SetSplitInfoState)obj;
            return this.inSplit.equals(other.inSplit);
        }
    }

    static final class SequenceSplitInfoState
    extends SplitInfoState {
        private final int[] inSplit;

        SequenceSplitInfoState(int numberOfMaximalSplits) {
            this.inSplit = new int[numberOfMaximalSplits];
            for (int i = 0; i < numberOfMaximalSplits; ++i) {
                this.inSplit[i] = i;
            }
        }

        private SequenceSplitInfoState(int[] pInSplit) {
            this.inSplit = pInSplit;
        }

        @Override
        public boolean isInSplit(int splitIndex) {
            return this.inSplit.length > 0 && this.inSplit[0] <= splitIndex && this.inSplit[this.inSplit.length - 1] >= splitIndex;
        }

        @Override
        public SplitInfoState getSplitPart(int numSplitParts, int splitPart) {
            Preconditions.checkArgument((numSplitParts > 0 ? 1 : 0) != 0, (Object)"Number of split parts must be a positive number.");
            Preconditions.checkArgument((splitPart >= 0 && splitPart < numSplitParts ? 1 : 0) != 0, (Object)"The split part must be in [0,numSplitParts).");
            if (this.inSplit.length < numSplitParts) {
                return this;
            }
            int minElem = this.inSplit.length / numSplitParts;
            int numAdditionalElem = this.inSplit.length % numSplitParts;
            return new SequenceSplitInfoState(Arrays.copyOfRange(this.inSplit, splitPart * minElem + Math.min(splitPart, numAdditionalElem), (splitPart + 1) * minElem + (splitPart + 1 < numAdditionalElem ? splitPart + 1 : numAdditionalElem)));
        }

        @Override
        public SplitInfoState removeFromSplit(int pSplitIndex) {
            if (this.isInSplit(pSplitIndex) && this.inSplit.length > 1) {
                HashSet newSplit = Sets.newHashSetWithExpectedSize((int)this.inSplit.length);
                for (int splitIndex : this.inSplit) {
                    newSplit.add(splitIndex);
                }
                newSplit.remove(pSplitIndex);
                return new SetSplitInfoState(newSplit);
            }
            return this;
        }

        @Override
        public boolean isOneElementalSplit() {
            return this.inSplit.length == 1;
        }

        @Override
        public SplitInfoState removeFromSplit(Collection<Integer> pRemoveIndices) {
            Preconditions.checkNotNull(pRemoveIndices);
            HashSet newSplit = Sets.newHashSetWithExpectedSize((int)Math.max(0, this.inSplit.length - pRemoveIndices.size()));
            for (int splitIndex : this.inSplit) {
                if (pRemoveIndices.contains(splitIndex)) continue;
                newSplit.add(splitIndex);
            }
            if (newSplit.size() < 1) {
                return this;
            }
            return new SetSplitInfoState(newSplit);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.inSplit);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SequenceSplitInfoState other = (SequenceSplitInfoState)obj;
            return Arrays.equals(this.inSplit, other.inSplit);
        }
    }
}

