/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.splitter;

import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.splitter.SplitInfoState;
import org.sosy_lab.cpachecker.cpa.splitter.SplitterTransferRelation;

@Options(prefix="program.splitter")
public class SplitterCPA
extends AbstractCPA {
    @Option(secure=true, name="max", description="maximal number")
    @IntegerOption(min=2L)
    int maxSplits = 2;
    private final TransferRelation transfer;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(SplitterCPA.class);
    }

    private SplitterCPA(Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        super("SEP", "SEP", null);
        config.inject((Object)this);
        this.transfer = new SplitterTransferRelation(config, logger, pShutdownNotifier, this.maxSplits);
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        return new SplitInfoState.SequenceSplitInfoState(this.maxSplits);
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transfer;
    }

    public int getMaximalSplitNumber() {
        return this.maxSplits;
    }
}

