/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.splitter;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.splitter.SplitInfoState;
import org.sosy_lab.cpachecker.cpa.splitter.heuristics.SplitAtAssumes;
import org.sosy_lab.cpachecker.cpa.splitter.heuristics.SplitHeuristic;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

@Options(prefix="program.splitter")
public class SplitterTransferRelation
extends SingleEdgeTransferRelation {
    @Option(secure=true, name="heuristic", description="Which program split heuristic to use")
    @ClassOption(packagePrefix={"org.sosy_lab.cpachecker.cpa.splitter.heuristics"})
    private SplitHeuristic.Factory factory = (pConfig, pLogger, pMaxSplits) -> new SplitAtAssumes();
    private final SplitHeuristic split;
    private final LogManager logger;
    private final ShutdownNotifier shutdown;

    public SplitterTransferRelation(Configuration pConfig2, LogManager pLogger2, ShutdownNotifier pShutdownNotifier, int pMaxSplits2) throws InvalidConfigurationException {
        pConfig2.inject((Object)this);
        this.logger = pLogger2;
        this.shutdown = pShutdownNotifier;
        if (this.factory == null) {
            throw new InvalidConfigurationException("Heuristic for program splitting must be defined");
        }
        this.split = this.factory.create(pConfig2, pLogger2, pMaxSplits2);
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        int numParts;
        SplitInfoState splitState = (SplitInfoState)pState;
        if (this.split.removeSplitIndices(pCfaEdge)) {
            splitState = splitState.removeFromSplit(this.split.getIndicesToRemove(pCfaEdge));
        }
        this.shutdown.shutdownIfNecessary();
        if (this.split.divideSplitIndices(pCfaEdge) && (numParts = this.split.divideIntoHowManyParts(pCfaEdge)) > 1) {
            int end;
            int start;
            ImmutableList.Builder successors = ImmutableList.builderWithExpectedSize((int)numParts);
            if (pCfaEdge instanceof AssumeEdge) {
                AssumeEdge assume = (AssumeEdge)pCfaEdge;
                if (assume.getTruthAssumption()) {
                    start = 0;
                    end = numParts / 2;
                } else {
                    start = numParts / 2;
                    end = numParts;
                }
            } else {
                start = 0;
                end = numParts;
            }
            for (int i = start; i < end; ++i) {
                SplitInfoState successor = splitState.getSplitPart(numParts, i);
                if (successor == splitState) continue;
                successors.add((Object)successor);
            }
            ImmutableList result = successors.build();
            if (!result.isEmpty()) {
                this.logger.log(Level.FINE, new Object[]{"Divided split indices."});
                return result;
            }
        }
        return ImmutableList.of((Object)splitState);
    }
}

