/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.statistics;

import java.util.Collection;
import org.sosy_lab.common.annotations.Unmaintained;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.cpa.statistics.StatisticsCPADomain;
import org.sosy_lab.cpachecker.cpa.statistics.StatisticsCPAStatistics;
import org.sosy_lab.cpachecker.cpa.statistics.StatisticsState;
import org.sosy_lab.cpachecker.cpa.statistics.StatisticsTransferRelation;
import org.sosy_lab.cpachecker.cpa.statistics.provider.SimpleIntProviderFactory;

@Options(prefix="cpa.statistics")
@Unmaintained
public class StatisticsCPA
extends AbstractCPA
implements StatisticsProvider {
    private StatisticsState.StatisticsStateFactory factory;
    private StatisticsCPAStatistics stats;
    @Option(secure=true, name="metric.nodeCount", description="count the number of traversed nodes.")
    private boolean nodeCount = true;
    @Option(secure=true, name="metric.gotoCount", description="count the number of traversed gotos.")
    private boolean gotoCount = true;
    @Option(secure=true, name="metric.assumeCount", description="count the number of traversed assume statements.")
    private boolean assumeCount = true;
    @Option(secure=true, name="metric.loopCount", description="count the number of traversed loops.")
    private boolean loopCount = true;
    @Option(secure=true, name="metric.functionCallCount", description="count the number of traversed function calls.")
    private boolean functionCallCount = true;
    @Option(secure=true, name="metric.branchCount", description="count the number of traversed edges with more then one outgoing edge.")
    private boolean branchCount = true;
    @Option(secure=true, name="metric.jumpCount", description="count the number of traversed jumps.")
    private boolean jumpCount = true;
    @Option(secure=true, name="metric.functionDefCount", description="count the number of traversed function definitions.")
    private boolean functionDefCount = true;
    @Option(secure=true, name="metric.localVariablesCount", description="count the number of traversed local variable definitions.")
    private boolean localVariablesCount = true;
    @Option(secure=true, name="metric.globalVariablesCount", description="count the number of traversed global variable definitions.")
    private boolean globalVariablesCount = true;
    @Option(secure=true, name="metric.structVariablesCount", description="count the number of traversed variable definitions with a complex structure type.")
    private boolean structVariablesCount = true;
    @Option(secure=true, name="metric.pointerVariablesCount", description="count the number of traversed variable definitions with pointer type.")
    private boolean pointerVariablesCount = true;
    @Option(secure=true, name="metric.arrayVariablesCount", description="count the number of traversed variable definitions with array type.")
    private boolean arrayVariablesCount = true;
    @Option(secure=true, name="metric.bitwiseOperationCount", description="count the number of traversed bitwise operations.")
    private boolean bitwiseOperationCount = true;
    @Option(secure=true, name="metric.arithmeticOperationCount", description="count the number of traversed arithmetic operations.")
    private boolean arithmeticOperationCount = true;
    @Option(secure=true, name="metric.integerVariablesCount", description="count the number of traversed variable definitions with integer type.")
    private boolean integerVariablesCount = true;
    @Option(secure=true, name="metric.floatVariablesCount", description="count the number of traversed variable definitions with floating type (float or double).")
    private boolean floatVariablesCount = true;
    @Option(secure=true, name="metric.dereferenceCount", description="count the number of traversed dereference operations.")
    private boolean dereferenceCount = true;
    @Option(secure=true, name="analysis", description="set this to true when you only want to do a code analysis. If StatisticsCPA is combined with other CPAs to do queries use false.")
    private boolean isAnalysis = true;
    @Option(secure=true, name="mergeSep", values={"sep", "join"}, description="which merge operator to use for StatisticsCPA? Ignored when analysis is set to true")
    private String mergeType = "sep";

    public static CPAFactory factory() {
        AutomaticCPAFactory factory = AutomaticCPAFactory.forType(StatisticsCPA.class);
        return factory;
    }

    public StatisticsCPA(Configuration config, LogManager pLogger, CFA cfa) throws InvalidConfigurationException {
        super("irrelevant", "sep", new StatisticsCPADomain(), new StatisticsTransferRelation());
        config.inject((Object)this);
        StatisticsState.StatisticsStateFactory.FactoryAnalysisType analysisType = StatisticsState.StatisticsStateFactory.FactoryAnalysisType.MetricsQuery;
        if (this.isAnalysis) {
            analysisType = StatisticsState.StatisticsStateFactory.FactoryAnalysisType.Analysis;
        }
        this.factory = new StatisticsState.StatisticsStateFactory(analysisType);
        SimpleIntProviderFactory.MergeOption defMerge = SimpleIntProviderFactory.MergeOption.Add;
        if (this.nodeCount) {
            this.factory.addProvider(SimpleIntProviderFactory.getEdgeCountProvider(defMerge));
        }
        if (this.gotoCount) {
            this.factory.addProvider(SimpleIntProviderFactory.getGotoCountProvider(defMerge));
        }
        if (this.loopCount) {
            this.factory.addProvider(SimpleIntProviderFactory.getLoopCountProvider(cfa, defMerge));
        }
        if (this.functionCallCount) {
            this.factory.addProvider(SimpleIntProviderFactory.getFunctionCallCountProvider(defMerge));
        }
        if (this.branchCount) {
            this.factory.addProvider(SimpleIntProviderFactory.getBranchCountProvider(defMerge));
        }
        if (this.jumpCount) {
            this.factory.addProvider(SimpleIntProviderFactory.getJumpCountProvider(defMerge));
        }
        if (this.functionDefCount) {
            this.factory.addProvider(SimpleIntProviderFactory.getFunctionDefCountProvider(defMerge));
        }
        if (this.localVariablesCount) {
            this.factory.addProvider(SimpleIntProviderFactory.getLocalVariablesCountProvider(defMerge));
        }
        if (this.globalVariablesCount) {
            this.factory.addProvider(SimpleIntProviderFactory.getGlobalVariablesCountProvider(defMerge));
        }
        if (this.structVariablesCount) {
            this.factory.addProvider(SimpleIntProviderFactory.getStructVariablesCountProvider(defMerge));
        }
        if (this.pointerVariablesCount) {
            this.factory.addProvider(SimpleIntProviderFactory.getPointerVariablesCountProvider(defMerge));
        }
        if (this.arrayVariablesCount) {
            this.factory.addProvider(SimpleIntProviderFactory.getArrayVariablesCountProvider(defMerge));
        }
        if (this.bitwiseOperationCount) {
            this.factory.addProvider(SimpleIntProviderFactory.getBitwiseOperationCountProvider(defMerge));
        }
        if (this.arithmeticOperationCount) {
            this.factory.addProvider(SimpleIntProviderFactory.getArithmeticOperationCountProvider(defMerge));
        }
        if (this.integerVariablesCount) {
            this.factory.addProvider(SimpleIntProviderFactory.getIntegerVariablesCountProvider(defMerge));
        }
        if (this.floatVariablesCount) {
            this.factory.addProvider(SimpleIntProviderFactory.getFloatVariablesCountProvider(defMerge));
        }
        if (this.dereferenceCount) {
            this.factory.addProvider(SimpleIntProviderFactory.getDereferenceCountProvider(defMerge));
        }
        if (this.assumeCount) {
            this.factory.addProvider(SimpleIntProviderFactory.getAssumeCountProvider(defMerge));
        }
        this.stats = new StatisticsCPAStatistics(config, pLogger, this);
    }

    public StatisticsState.StatisticsStateFactory getFactory() {
        return this.factory;
    }

    public boolean isAnalysis() {
        return this.isAnalysis;
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return this.factory.createNew(pNode);
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.add(this.stats);
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.buildMergeOperator(this.mergeType);
    }
}

