/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.statistics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.statistics.StatisticsState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class StatisticsTransferRelation
extends SingleEdgeTransferRelation {
    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        StatisticsState state = (StatisticsState)pState;
        CFANode node = state.getLocationNode();
        if (pCfaEdge != null) {
            if (CFAUtils.allLeavingEdges(node).contains((Object)pCfaEdge)) {
                return Collections.singleton(state.nextState(pCfaEdge));
            }
            return ImmutableSet.of();
        }
        ImmutableList.Builder allSuccessors = ImmutableList.builderWithExpectedSize((int)node.getNumLeavingEdges());
        for (CFAEdge successor : CFAUtils.leavingEdges(node)) {
            allSuccessors.add((Object)state.nextState(successor));
        }
        return allSuccessors.build();
    }
}

